/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.modbus.BitArray;
import org.openhab.core.io.transport.modbus.ModbusWriteFunctionCode;
import org.openhab.core.io.transport.modbus.ModbusWriteRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusWriteRequestBlueprintVisitor;

@NonNullByDefault
public class ModbusWriteCoilRequestBlueprint
extends ModbusWriteRequestBlueprint {
    private final int slaveId;
    private final int reference;
    private final BitArray bits;
    private final boolean writeMultiple;
    private final int maxTries;

    public ModbusWriteCoilRequestBlueprint(int slaveId, int reference, boolean data, boolean writeMultiple, int maxTries) {
        this(slaveId, reference, new BitArray(data), writeMultiple, maxTries);
    }

    public ModbusWriteCoilRequestBlueprint(int slaveId, int reference, BitArray data, boolean writeMultiple, int maxTries) {
        this.slaveId = slaveId;
        this.reference = reference;
        this.bits = data;
        this.writeMultiple = writeMultiple;
        this.maxTries = maxTries;
        if (!writeMultiple && this.bits.size() > 1) {
            throw new IllegalArgumentException("With multiple coils, writeMultiple must be true");
        }
        if (this.bits.size() == 0) {
            throw new IllegalArgumentException("Must have at least one bit");
        }
        if (maxTries <= 0) {
            throw new IllegalArgumentException("maxTries should be positive, was " + maxTries);
        }
    }

    @Override
    public int getUnitID() {
        return this.slaveId;
    }

    @Override
    public int getReference() {
        return this.reference;
    }

    @Override
    public ModbusWriteFunctionCode getFunctionCode() {
        return this.writeMultiple ? ModbusWriteFunctionCode.WRITE_MULTIPLE_COILS : ModbusWriteFunctionCode.WRITE_COIL;
    }

    public BitArray getCoils() {
        return this.bits;
    }

    @Override
    public int getMaxTries() {
        return this.maxTries;
    }

    public String toString() {
        return "ModbusWriteCoilRequestBlueprint [slaveId=" + this.slaveId + ", reference=" + this.reference + ", bits=" + String.valueOf(this.bits) + ", maxTries=" + this.maxTries + ", getFunctionCode()=" + String.valueOf((Object)this.getFunctionCode()) + "]";
    }

    @Override
    public void accept(ModbusWriteRequestBlueprintVisitor visitor) {
        visitor.visit(this);
    }
}

