/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.observe.NotificationOrder;
import org.eclipse.californium.elements.util.ClockUtil;

public class ObserveNotificationOrderer {
    private final AtomicInteger number = new AtomicInteger();
    private long nanoTimestamp;

    public ObserveNotificationOrderer() {
    }

    public ObserveNotificationOrderer(Integer observe) {
        if (observe == null) {
            throw new NullPointerException("observe option must not be null!");
        }
        this.number.set(observe);
        this.nanoTimestamp = ClockUtil.nanoRealtime();
    }

    public int getNextObserveNumber() {
        int next = this.number.incrementAndGet();
        while (next >= 0x1000000) {
            this.number.compareAndSet(next, 0);
            next = this.number.incrementAndGet();
        }
        return next;
    }

    public int getCurrent() {
        return this.number.get();
    }

    public synchronized boolean isNew(Response response) {
        Integer observe = response.getOptions().getObserve();
        if (observe == null) {
            return true;
        }
        long T2 = ClockUtil.nanoRealtime();
        if (NotificationOrder.isNew(this.nanoTimestamp, this.number.get(), T2, observe)) {
            this.nanoTimestamp = T2;
            this.number.set(observe);
            return true;
        }
        return false;
    }

    public synchronized void reset() {
        this.number.set(0);
        this.nanoTimestamp = 0L;
    }
}

