/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.lms.DigestUtil;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.pqc.crypto.lms.LMSigParameters;

/*
 * Exception performing whole class analysis ignored.
 */
class DigestUtil {
    DigestUtil() {
    }

    static Digest getDigest(LMOtsParameters lMOtsParameters) {
        return DigestUtil.createDigest((ASN1ObjectIdentifier)lMOtsParameters.getDigestOID(), (int)lMOtsParameters.getN());
    }

    static Digest getDigest(LMSigParameters lMSigParameters) {
        return DigestUtil.createDigest((ASN1ObjectIdentifier)lMSigParameters.getDigestOID(), (int)lMSigParameters.getM());
    }

    private static Digest createDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) {
        Digest digest = DigestUtil.createDigest((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (NISTObjectIdentifiers.id_shake256_len.equals(aSN1ObjectIdentifier) || digest.getDigestSize() != n) {
            return new WrapperDigest(digest, n);
        }
        return digest;
    }

    private static Digest createDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake256_len)) {
            return new SHAKEDigest(256);
        }
        throw new IllegalArgumentException("unrecognized digest OID: " + aSN1ObjectIdentifier);
    }
}

