/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.scoping;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedFeatures;
import org.openhab.core.library.unit.BinaryPrefix;
import org.openhab.core.library.unit.ImperialUnits;
import org.openhab.core.library.unit.MetricPrefix;
import org.openhab.core.library.unit.SIUnits;
import org.openhab.core.library.unit.Units;
import org.openhab.core.model.script.actions.BusEvent;
import org.openhab.core.model.script.actions.CoreUtil;
import org.openhab.core.model.script.actions.Exec;
import org.openhab.core.model.script.actions.HTTP;
import org.openhab.core.model.script.actions.Log;
import org.openhab.core.model.script.actions.Ping;
import org.openhab.core.model.script.actions.ScriptExecution;
import org.openhab.core.model.script.actions.Transformation;
import org.openhab.core.model.script.engine.IActionServiceProvider;
import org.openhab.core.model.script.engine.IThingActionsProvider;
import org.openhab.core.model.script.engine.action.ActionService;
import org.openhab.core.model.script.lib.NumberExtensions;
import org.openhab.core.thing.binding.ThingActions;

@Singleton
public class ScriptImplicitlyImportedTypes
extends ImplicitlyImportedFeatures {
    private List<Class<?>> actionClasses = null;
    @Inject
    IActionServiceProvider actionServiceProvider;
    @Inject
    IThingActionsProvider thingActionsProvider;

    protected List<Class<?>> getExtensionClasses() {
        List result = super.getExtensionClasses();
        result.remove(Comparable.class);
        result.remove(Double.class);
        result.remove(Integer.class);
        result.remove(BigInteger.class);
        result.remove(BigDecimal.class);
        result.remove(Double.TYPE);
        result.add(NumberExtensions.class);
        result.add(BusEvent.class);
        result.add(HTTP.class);
        result.add(Log.class);
        result.add(Ping.class);
        result.add(Transformation.class);
        result.add(ScriptExecution.class);
        result.add(URLEncoder.class);
        result.addAll(this.getActionClasses());
        return result;
    }

    protected List<Class<?>> getStaticImportClasses() {
        List result = super.getStaticImportClasses();
        result.add(BusEvent.class);
        result.add(Exec.class);
        result.add(HTTP.class);
        result.add(Log.class);
        result.add(Ping.class);
        result.add(Transformation.class);
        result.add(ScriptExecution.class);
        result.add(URLEncoder.class);
        result.add(CoreUtil.class);
        result.add(ImperialUnits.class);
        result.add(MetricPrefix.class);
        result.add(SIUnits.class);
        result.add(Units.class);
        result.add(BinaryPrefix.class);
        result.add(ChronoUnit.class);
        result.add(DayOfWeek.class);
        result.add(Duration.class);
        result.add(Month.class);
        result.add(ZoneId.class);
        result.add(ZonedDateTime.class);
        result.addAll(this.getActionClasses());
        return result;
    }

    protected List<Class<?>> getActionClasses() {
        List<ThingActions> actions;
        ArrayList localActionClasses = new ArrayList();
        List<ActionService> services = this.actionServiceProvider.get();
        if (services != null) {
            for (ActionService actionService : services) {
                localActionClasses.add(actionService.getActionClass());
            }
        }
        if ((actions = this.thingActionsProvider.get()) != null) {
            for (ThingActions thingActions : actions) {
                localActionClasses.add(thingActions.getClass());
            }
        }
        this.actionClasses = localActionClasses;
        return this.actionClasses;
    }
}

