#ifndef __MACRO_H__
#define __MACRO_H__
#include <iostream>
#include <string>
#include <vector>
using namespace std;
/** @addtogroup main */

extern int                    gv_swap_choice;

// @{ 
/// flag to select symetric seeds only
extern bool                   gv_symetric;
/// number of runs (0 when full enumeration)
extern int                    gv_nbruns;
/// flag that enables the "overdubbed" symbols
extern bool                   gv_matching_symbol_flag;

/// alignment alphabet size
extern int                    gv_align_alphabet_size;
/// seed alphabet size
extern int                    gv_seed_alphabet_size;
/// signature vector (number of seed letters per seed)
extern vector<int>            gv_signature;
/// signature flag that enable the signature selection
/// @see gv_signature
extern bool                   gv_signature_flag;
/// weight for each seed letter
extern vector<double>         gv_bsel_weight;

/// min seed letter selectivity
extern double                 gv_bsel_minprob;
/// max seed letter selectivity
extern double                 gv_bsel_maxprob;

/// min seed span
extern int                    gv_minspan;
/// max seed span
extern int                    gv_maxspan;

/// min seed weight
extern double                 gv_minweight;
/// max seed weight
extern double                 gv_maxweight;

/// flag that enables min and max seed weight
/// @see gv_minweight,gv_maxweight
extern bool                   gv_weight_interval;
/// flag that enables vectorized seeds
/// @see gv_vectorizedsubsetseed_scoring_matrix,gv_vectorizedsubsetseed_scoring_threshold
extern bool                   gv_vectorized_flag;
/// set of symbols when "overdubbed"
/// @see gv_bsymbols_flag
extern char *                 gv_bsymbols_array;
/// flag that enables "overdubbed" symbols
/// @see gv_bsymbols_array
extern bool                   gv_bsymbols_flag;

/** @name sleeping proccess activation
 *  @brief the iedera process goes into idle mode when number of process around is over  gv_nb_processes, or when its time to sleep.
 */
// @{
/// flag that activates possible sleep of the iedera process
extern bool     gv_sleeping_flag;
/// flag that activate the sleep when number of process is over gv_nb_processes
extern bool     gv_nb_processes_flag;
/// set the number of process needed to activate the sleep
extern int      gv_nb_processes;
// @}



// @}
 
/*
 * (I) Usefull functions
 */

#define ASSERT(ptr)                                                   \
  if (!(ptr)){                                                        \
    cerr << "*ERROR : memory allocation failed on" << #ptr <<   endl; \
    exit(-1);                                                         \
  }

#define ERROR(message1,message2) {                              \
  cerr << "*ERROR : " << message1 << " : " << message2 << endl; \
  exit(-1);                                                     \
}

#define WARNING(message1,message2) {                              \
  cerr << "*WARNING : " << message1 << " : " << message2 << endl; \
}

#define OUTSTREAM (gv_ofstream.is_open()?gv_ofstream:cout)
#define MAX(a,b) ((a)>(b)?(a):(b)) 
#define MAX3(a,b,c) MAX((a),MAX((b),(c)))
#define MIN(a,b) ((a)<(b)?(a):(b))
#define MIN3(a,b,c) MIN((a),MIN((b),(c)))
#define ABS(a) ((a)>=0?(a):(-a))

#define INT_INFINITY   (0x7fffffff)  

#define BINARY(u,r,o)                             \
  for (int _i__ = 1; _i__ <  (1<<r) ;_i__ <<=1){  \
     if (_i__&u)                                  \
        o << "1";                                 \
     else                                         \
        o << "0";                                 \
  }

int power(int x, int n);
double power(double x, int n);

/*
 *  (II) Constants
 */

#define FALSE      0
#define TRUE       1
#define KILO      (1024)
#define MEGA      (KILO*KILO)
#define GIGA      (MEGA*KILO)


/*
 *  (III) specific definitions 
 */

#define XSET         (unsigned int)
#define XSETBITSIZE  (sizeof(XSET)*8)

//#define ASSERTB
#define USEQUEUE
//#define BUILD
#define USEMAP

/* number of runs when "sleeping tests" are done */
#define CMOD 1
/* number of seconds when "sleeping tests" are redone when sleeping */
#define CSLEEP 600

#define CHECK_PROCESS(MOD) {                                    \
if ((MOD <= 2) || (!(nbruns % (MOD)))) {                        \
  bool sleeping = false;                                        \
 restart:                                                       \
                                                                \
  if(gv_sleeping_flag) {                                        \
                                                                \
    time_t    t    = time(NULL);                                \
    struct tm * tm = localtime(&t);                             \
                                                                \
    if (                                                        \
	(tm->tm_hour >= 8 && tm->tm_hour < 20) &&               \
	(tm->tm_wday > 0  && tm->tm_wday < 6)                   \
	) {                                                     \
      if(!sleeping) {                                           \
	/* erase automata */                                    \
        for (int i=0; i < gv_nbseeds; i ++) {                   \
           if (a_s[i] != NULL){                                 \
             delete a_s[i];                                     \
	     a_s[i] = NULL;                                     \
           }                                                    \
        }                                                       \
                                                                \
	/* security input */                                    \
	if(gv_nb_input_filenames > 0) {                         \
	  for(int i=0;i<gv_nb_input_filenames;i++)              \
	    inputPareto(l,gv_input_filenames[i]);               \
	}                                                       \
	                                                        \
	/* final output */                                      \
	cerr << "# seeds\t sel\t sens\t dist"<<  endl;          \
	selectPareto(l);                                        \
	if (!gv_output_filename)                                \
	  list_and_areaPareto(l);                               \
	else                                                    \
	  outputPareto(l,gv_output_filename);                   \
	cerr << "sleeping ..." << endl;                         \
	                                                        \
	sleeping = true;                                        \
	                                                        \
      }	                                                        \
      SLEEP(CSLEEP);                                            \
      goto restart;                                             \
                                                                \
    } else {                                                    \
                                                                \
      if (sleeping) {                                           \
	sleeping = false;                                       \
	cerr << "restarting ..." << endl;                       \
      }                                                         \
    }                                                           \
  }                                                             \
                                                                \
  if (gv_nb_processes_flag) {                                   \
                                                                \
    int lines = 0;	                                        \
    FILE * f = popen("ps -A", "r");                             \
    int c = getc(f);                                            \
    while(c != EOF) {                                           \
      if (c == '\n')                                            \
	lines++;                                                \
      c = getc(f);                                              \
    }                                                           \
    pclose(f);                                                  \
                                                                \
    if (lines >= gv_nb_processes) {                             \
      cerr << "nb processes : " << lines << endl;               \
                                                                \
      if (!sleeping) {	      		                        \
	/* erase automata */                                    \
        for (int i=0; i < gv_nbseeds; i ++) {                   \
           if (a_s[i] != NULL){                                 \
             delete a_s[i];                                     \
	     a_s[i] = NULL;                                     \
           }                                                    \
        }                                                       \
                                                                \
	/* security input */                                    \
	if (gv_nb_input_filenames > 0) {                        \
	  for(int i=0;i<gv_nb_input_filenames;i++)              \
	    inputPareto(l,gv_input_filenames[i]);               \
	}                                                       \
	                                                        \
	/* final output */                                      \
	cerr << "# seeds\t sel\t sens\t dist"<<  endl;          \
	selectPareto(l);                                        \
	if (!gv_output_filename)                                \
	  list_and_areaPareto(l);                               \
	else                                                    \
	  outputPareto(l,gv_output_filename);                   \
	cerr << "sleeping ..." << endl;                         \
	                                                        \
	sleeping = true;                                        \
      }	                                                        \
      SLEEP(CSLEEP);                                            \
      goto restart;                                             \
    } else {                                                    \
      if (sleeping) {                                           \
	sleeping = false;                                       \
	cerr << "restarting ..." << endl;                       \
      }                                                         \
    }                                                           \
  }                                                             \
 }                                                              \
}                                                                     




#endif  

