// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbmesh/v2beta1/http_route.proto

package meshv2beta1

import (
	_ "github.com/hashicorp/consul/proto-public/pbresource"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PathMatchType specifies the semantics of how HTTP paths should be compared.
// Valid PathMatchType values, along with their support levels, are:
//
// PathPrefix and Exact paths must be syntactically valid:
//
// - Must begin with the / character
// - Must not contain consecutive / characters (e.g. /foo///, //).
// - Note that values may be added to this enum, implementations must ensure that unknown values will not cause a crash.
//
// Unknown values here must result in the implementation setting the Accepted
// Condition for the Route to status: False, with a Reason of UnsupportedValue.
//
// +kubebuilder:validation:Enum=PATH_MATCH_TYPE_UNSPECIFIED;PATH_MATCH_TYPE_EXACT;PATH_MATCH_TYPE_PREFIX;PATH_MATCH_TYPE_REGEX
// +kubebuilder:validation:Type=string
type PathMatchType int32

const (
	PathMatchType_PATH_MATCH_TYPE_UNSPECIFIED PathMatchType = 0
	PathMatchType_PATH_MATCH_TYPE_EXACT       PathMatchType = 1
	PathMatchType_PATH_MATCH_TYPE_PREFIX      PathMatchType = 2
	PathMatchType_PATH_MATCH_TYPE_REGEX       PathMatchType = 3
)

// Enum value maps for PathMatchType.
var (
	PathMatchType_name = map[int32]string{
		0: "PATH_MATCH_TYPE_UNSPECIFIED",
		1: "PATH_MATCH_TYPE_EXACT",
		2: "PATH_MATCH_TYPE_PREFIX",
		3: "PATH_MATCH_TYPE_REGEX",
	}
	PathMatchType_value = map[string]int32{
		"PATH_MATCH_TYPE_UNSPECIFIED": 0,
		"PATH_MATCH_TYPE_EXACT":       1,
		"PATH_MATCH_TYPE_PREFIX":      2,
		"PATH_MATCH_TYPE_REGEX":       3,
	}
)

func (x PathMatchType) Enum() *PathMatchType {
	p := new(PathMatchType)
	*p = x
	return p
}

func (x PathMatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PathMatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_http_route_proto_enumTypes[0].Descriptor()
}

func (PathMatchType) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_http_route_proto_enumTypes[0]
}

func (x PathMatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PathMatchType.Descriptor instead.
func (PathMatchType) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{0}
}

// HeaderMatchType specifies the semantics of how HTTP header values should be
// compared. Valid HeaderMatchType values, along with their conformance levels,
// are:
//
// Note that values may be added to this enum, implementations must ensure that
// unknown values will not cause a crash.
//
// Unknown values here must result in the implementation setting the Accepted
// Condition for the Route to status: False, with a Reason of UnsupportedValue.
//
// +kubebuilder:validation:Enum=HEADER_MATCH_TYPE_UNSPECIFIED;HEADER_MATCH_TYPE_EXACT;HEADER_MATCH_TYPE_REGEX;HEADER_MATCH_TYPE_PRESENT;HEADER_MATCH_TYPE_PREFIX;HEADER_MATCH_TYPE_SUFFIX
// +kubebuilder:validation:Type=string
type HeaderMatchType int32

const (
	HeaderMatchType_HEADER_MATCH_TYPE_UNSPECIFIED HeaderMatchType = 0
	HeaderMatchType_HEADER_MATCH_TYPE_EXACT       HeaderMatchType = 1
	HeaderMatchType_HEADER_MATCH_TYPE_REGEX       HeaderMatchType = 2
	// consul only after this point (service-router compat)
	HeaderMatchType_HEADER_MATCH_TYPE_PRESENT HeaderMatchType = 3
	HeaderMatchType_HEADER_MATCH_TYPE_PREFIX  HeaderMatchType = 4
	HeaderMatchType_HEADER_MATCH_TYPE_SUFFIX  HeaderMatchType = 5
)

// Enum value maps for HeaderMatchType.
var (
	HeaderMatchType_name = map[int32]string{
		0: "HEADER_MATCH_TYPE_UNSPECIFIED",
		1: "HEADER_MATCH_TYPE_EXACT",
		2: "HEADER_MATCH_TYPE_REGEX",
		3: "HEADER_MATCH_TYPE_PRESENT",
		4: "HEADER_MATCH_TYPE_PREFIX",
		5: "HEADER_MATCH_TYPE_SUFFIX",
	}
	HeaderMatchType_value = map[string]int32{
		"HEADER_MATCH_TYPE_UNSPECIFIED": 0,
		"HEADER_MATCH_TYPE_EXACT":       1,
		"HEADER_MATCH_TYPE_REGEX":       2,
		"HEADER_MATCH_TYPE_PRESENT":     3,
		"HEADER_MATCH_TYPE_PREFIX":      4,
		"HEADER_MATCH_TYPE_SUFFIX":      5,
	}
)

func (x HeaderMatchType) Enum() *HeaderMatchType {
	p := new(HeaderMatchType)
	*p = x
	return p
}

func (x HeaderMatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HeaderMatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_http_route_proto_enumTypes[1].Descriptor()
}

func (HeaderMatchType) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_http_route_proto_enumTypes[1]
}

func (x HeaderMatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HeaderMatchType.Descriptor instead.
func (HeaderMatchType) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{1}
}

// +kubebuilder:validation:Enum=QUERY_PARAM_MATCH_TYPE_UNSPECIFIED;QUERY_PARAM_MATCH_TYPE_EXACT;QUERY_PARAM_MATCH_TYPE_REGEX;QUERY_PARAM_MATCH_TYPE_PRESENT
// +kubebuilder:validation:Type=string
type QueryParamMatchType int32

const (
	QueryParamMatchType_QUERY_PARAM_MATCH_TYPE_UNSPECIFIED QueryParamMatchType = 0
	QueryParamMatchType_QUERY_PARAM_MATCH_TYPE_EXACT       QueryParamMatchType = 1
	QueryParamMatchType_QUERY_PARAM_MATCH_TYPE_REGEX       QueryParamMatchType = 2
	// consul only after this point (service-router compat)
	QueryParamMatchType_QUERY_PARAM_MATCH_TYPE_PRESENT QueryParamMatchType = 3
)

// Enum value maps for QueryParamMatchType.
var (
	QueryParamMatchType_name = map[int32]string{
		0: "QUERY_PARAM_MATCH_TYPE_UNSPECIFIED",
		1: "QUERY_PARAM_MATCH_TYPE_EXACT",
		2: "QUERY_PARAM_MATCH_TYPE_REGEX",
		3: "QUERY_PARAM_MATCH_TYPE_PRESENT",
	}
	QueryParamMatchType_value = map[string]int32{
		"QUERY_PARAM_MATCH_TYPE_UNSPECIFIED": 0,
		"QUERY_PARAM_MATCH_TYPE_EXACT":       1,
		"QUERY_PARAM_MATCH_TYPE_REGEX":       2,
		"QUERY_PARAM_MATCH_TYPE_PRESENT":     3,
	}
)

func (x QueryParamMatchType) Enum() *QueryParamMatchType {
	p := new(QueryParamMatchType)
	*p = x
	return p
}

func (x QueryParamMatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QueryParamMatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_http_route_proto_enumTypes[2].Descriptor()
}

func (QueryParamMatchType) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_http_route_proto_enumTypes[2]
}

func (x QueryParamMatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QueryParamMatchType.Descriptor instead.
func (QueryParamMatchType) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{2}
}

// NOTE: this should align to the GAMMA/gateway-api version, or at least be
// easily translatable.
//
// https://gateway-api.sigs.k8s.io/references/spec/#gateway.networking.k8s.io/v1alpha2.HTTPRoute
//
// This is a Resource type.
type HTTPRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ParentRefs references the resources (usually Services) that a Route wants
	// to be attached to.
	//
	// It is invalid to reference an identical parent more than once. It is valid
	// to reference multiple distinct sections within the same parent resource.
	ParentRefs []*ParentReference `protobuf:"bytes,1,rep,name=parent_refs,json=parentRefs,proto3" json:"parent_refs,omitempty"`
	// Hostnames are the hostnames for which this HTTPRoute should respond to requests.
	//
	// This is only valid for north/south.
	Hostnames []string `protobuf:"bytes,2,rep,name=hostnames,proto3" json:"hostnames,omitempty"`
	// Rules are a list of HTTP-based routing rules that this route should
	// use for constructing a routing table.
	Rules []*HTTPRouteRule `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *HTTPRoute) Reset() {
	*x = HTTPRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRoute) ProtoMessage() {}

func (x *HTTPRoute) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRoute.ProtoReflect.Descriptor instead.
func (*HTTPRoute) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{0}
}

func (x *HTTPRoute) GetParentRefs() []*ParentReference {
	if x != nil {
		return x.ParentRefs
	}
	return nil
}

func (x *HTTPRoute) GetHostnames() []string {
	if x != nil {
		return x.Hostnames
	}
	return nil
}

func (x *HTTPRoute) GetRules() []*HTTPRouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// HTTPRouteRule specifies the routing rules used to determine what upstream
// service an HTTP request is routed to.
type HTTPRouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Matches []*HTTPRouteMatch  `protobuf:"bytes,1,rep,name=matches,proto3" json:"matches,omitempty"`
	Filters []*HTTPRouteFilter `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
	// BackendRefs defines the backend(s) where matching requests should be sent.
	//
	// Failure behavior here depends on how many BackendRefs are specified and
	// how many are invalid.
	//
	// If all entries in BackendRefs are invalid, and there are also no filters
	// specified in this route rule, all traffic which matches this rule MUST
	// receive a 500 status code.
	//
	// See the HTTPBackendRef definition for the rules about what makes a single
	// HTTPBackendRef invalid.
	//
	// When a HTTPBackendRef is invalid, 500 status codes MUST be returned for
	// requests that would have otherwise been routed to an invalid backend. If
	// multiple backends are specified, and some are invalid, the proportion of
	// requests that would otherwise have been routed to an invalid backend MUST
	// receive a 500 status code.
	//
	// For example, if two backends are specified with equal weights, and one is
	// invalid, 50 percent of traffic must receive a 500. Implementations may
	// choose how that 50 percent is determined.
	BackendRefs []*HTTPBackendRef  `protobuf:"bytes,3,rep,name=backend_refs,json=backendRefs,proto3" json:"backend_refs,omitempty"`
	Timeouts    *HTTPRouteTimeouts `protobuf:"bytes,4,opt,name=timeouts,proto3" json:"timeouts,omitempty"`
	Retries     *HTTPRouteRetries  `protobuf:"bytes,5,opt,name=retries,proto3" json:"retries,omitempty"`
}

func (x *HTTPRouteRule) Reset() {
	*x = HTTPRouteRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPRouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRouteRule) ProtoMessage() {}

func (x *HTTPRouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRouteRule.ProtoReflect.Descriptor instead.
func (*HTTPRouteRule) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{1}
}

func (x *HTTPRouteRule) GetMatches() []*HTTPRouteMatch {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *HTTPRouteRule) GetFilters() []*HTTPRouteFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *HTTPRouteRule) GetBackendRefs() []*HTTPBackendRef {
	if x != nil {
		return x.BackendRefs
	}
	return nil
}

func (x *HTTPRouteRule) GetTimeouts() *HTTPRouteTimeouts {
	if x != nil {
		return x.Timeouts
	}
	return nil
}

func (x *HTTPRouteRule) GetRetries() *HTTPRouteRetries {
	if x != nil {
		return x.Retries
	}
	return nil
}

type HTTPRouteMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path specifies a HTTP request path matcher. If this field is not
	// specified, a default prefix match on the “/” path is provided.
	Path *HTTPPathMatch `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Headers specifies HTTP request header matchers. Multiple match values are
	// ANDed together, meaning, a request must match all the specified headers to
	// select the route.
	Headers []*HTTPHeaderMatch `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty"`
	// QueryParams specifies HTTP query parameter matchers. Multiple match values
	// are ANDed together, meaning, a request must match all the specified query
	// parameters to select the route.
	QueryParams []*HTTPQueryParamMatch `protobuf:"bytes,3,rep,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Method specifies HTTP method matcher. When specified, this route will be
	// matched only if the request has the specified method.
	Method string `protobuf:"bytes,4,opt,name=method,proto3" json:"method,omitempty"`
}

func (x *HTTPRouteMatch) Reset() {
	*x = HTTPRouteMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPRouteMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRouteMatch) ProtoMessage() {}

func (x *HTTPRouteMatch) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRouteMatch.ProtoReflect.Descriptor instead.
func (*HTTPRouteMatch) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{2}
}

func (x *HTTPRouteMatch) GetPath() *HTTPPathMatch {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *HTTPRouteMatch) GetHeaders() []*HTTPHeaderMatch {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HTTPRouteMatch) GetQueryParams() []*HTTPQueryParamMatch {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *HTTPRouteMatch) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

type HTTPPathMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type specifies how to match against the path Value.
	Type PathMatchType `protobuf:"varint,1,opt,name=type,proto3,enum=hashicorp.consul.mesh.v2beta1.PathMatchType" json:"type,omitempty"`
	// Value of the HTTP path to match against.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *HTTPPathMatch) Reset() {
	*x = HTTPPathMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPPathMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPPathMatch) ProtoMessage() {}

func (x *HTTPPathMatch) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPPathMatch.ProtoReflect.Descriptor instead.
func (*HTTPPathMatch) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{3}
}

func (x *HTTPPathMatch) GetType() PathMatchType {
	if x != nil {
		return x.Type
	}
	return PathMatchType_PATH_MATCH_TYPE_UNSPECIFIED
}

func (x *HTTPPathMatch) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type HTTPHeaderMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type specifies how to match against the value of the header.
	Type HeaderMatchType `protobuf:"varint,1,opt,name=type,proto3,enum=hashicorp.consul.mesh.v2beta1.HeaderMatchType" json:"type,omitempty"`
	// Name is the name of the HTTP Header to be matched. Name matching MUST be
	// case insensitive. (See https://tools.ietf.org/html/rfc7230#section-3.2).
	//
	// If multiple entries specify equivalent header names, only the first entry
	// with an equivalent name MUST be considered for a match. Subsequent entries
	// with an equivalent header name MUST be ignored. Due to the
	// case-insensitivity of header names, “foo” and “Foo” are considered
	// equivalent.
	//
	// When a header is repeated in an HTTP request, it is
	// implementation-specific behavior as to how this is represented. Generally,
	// proxies should follow the guidance from the RFC:
	// https://www.rfc-editor.org/rfc/rfc7230.html#section-3.2.2 regarding
	// processing a repeated header, with special handling for “Set-Cookie”.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Value is the value of HTTP Header to be matched.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// NOTE: not in gamma; service-router compat
	Invert bool `protobuf:"varint,4,opt,name=invert,proto3" json:"invert,omitempty"`
}

func (x *HTTPHeaderMatch) Reset() {
	*x = HTTPHeaderMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPHeaderMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeaderMatch) ProtoMessage() {}

func (x *HTTPHeaderMatch) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeaderMatch.ProtoReflect.Descriptor instead.
func (*HTTPHeaderMatch) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{4}
}

func (x *HTTPHeaderMatch) GetType() HeaderMatchType {
	if x != nil {
		return x.Type
	}
	return HeaderMatchType_HEADER_MATCH_TYPE_UNSPECIFIED
}

func (x *HTTPHeaderMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPHeaderMatch) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *HTTPHeaderMatch) GetInvert() bool {
	if x != nil {
		return x.Invert
	}
	return false
}

type HTTPQueryParamMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type specifies how to match against the value of the query parameter.
	Type QueryParamMatchType `protobuf:"varint,1,opt,name=type,proto3,enum=hashicorp.consul.mesh.v2beta1.QueryParamMatchType" json:"type,omitempty"`
	// Name is the name of the HTTP query param to be matched. This must be an
	// exact string match. (See
	// https://tools.ietf.org/html/rfc7230#section-2.7.3).
	//
	// If multiple entries specify equivalent query param names, only the first
	// entry with an equivalent name MUST be considered for a match. Subsequent
	// entries with an equivalent query param name MUST be ignored.
	//
	// If a query param is repeated in an HTTP request, the behavior is purposely
	// left undefined, since different data planes have different capabilities.
	// However, it is recommended that implementations should match against the
	// first value of the param if the data plane supports it, as this behavior
	// is expected in other load balancing contexts outside of the Gateway API.
	//
	// Users SHOULD NOT route traffic based on repeated query params to guard
	// themselves against potential differences in the implementations.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Value is the value of HTTP query param to be matched.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *HTTPQueryParamMatch) Reset() {
	*x = HTTPQueryParamMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPQueryParamMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPQueryParamMatch) ProtoMessage() {}

func (x *HTTPQueryParamMatch) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPQueryParamMatch.ProtoReflect.Descriptor instead.
func (*HTTPQueryParamMatch) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{5}
}

func (x *HTTPQueryParamMatch) GetType() QueryParamMatchType {
	if x != nil {
		return x.Type
	}
	return QueryParamMatchType_QUERY_PARAM_MATCH_TYPE_UNSPECIFIED
}

func (x *HTTPQueryParamMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPQueryParamMatch) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type HTTPRouteFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RequestHeaderModifier defines a schema for a filter that modifies request
	// headers.
	RequestHeaderModifier *HTTPHeaderFilter `protobuf:"bytes,1,opt,name=request_header_modifier,json=requestHeaderModifier,proto3" json:"request_header_modifier,omitempty"`
	// ResponseHeaderModifier defines a schema for a filter that modifies
	// response headers.
	ResponseHeaderModifier *HTTPHeaderFilter `protobuf:"bytes,2,opt,name=response_header_modifier,json=responseHeaderModifier,proto3" json:"response_header_modifier,omitempty"`
	// URLRewrite defines a schema for a filter that modifies a request during
	// forwarding.
	UrlRewrite *HTTPURLRewriteFilter `protobuf:"bytes,5,opt,name=url_rewrite,json=urlRewrite,proto3" json:"url_rewrite,omitempty"`
}

func (x *HTTPRouteFilter) Reset() {
	*x = HTTPRouteFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPRouteFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRouteFilter) ProtoMessage() {}

func (x *HTTPRouteFilter) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRouteFilter.ProtoReflect.Descriptor instead.
func (*HTTPRouteFilter) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{6}
}

func (x *HTTPRouteFilter) GetRequestHeaderModifier() *HTTPHeaderFilter {
	if x != nil {
		return x.RequestHeaderModifier
	}
	return nil
}

func (x *HTTPRouteFilter) GetResponseHeaderModifier() *HTTPHeaderFilter {
	if x != nil {
		return x.ResponseHeaderModifier
	}
	return nil
}

func (x *HTTPRouteFilter) GetUrlRewrite() *HTTPURLRewriteFilter {
	if x != nil {
		return x.UrlRewrite
	}
	return nil
}

type HTTPHeaderFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set overwrites the request with the given header (name, value) before the
	// action.
	Set []*HTTPHeader `protobuf:"bytes,1,rep,name=set,proto3" json:"set,omitempty"`
	// Add adds the given header(s) (name, value) to the request before the
	// action. It appends to any existing values associated with the header name.
	Add []*HTTPHeader `protobuf:"bytes,2,rep,name=add,proto3" json:"add,omitempty"`
	// Remove the given header(s) from the HTTP request before the action. The
	// value of Remove is a list of HTTP header names. Note that the header names
	// are case-insensitive (see
	// https://datatracker.ietf.org/doc/html/rfc2616#section-4.2).
	Remove []string `protobuf:"bytes,3,rep,name=remove,proto3" json:"remove,omitempty"`
}

func (x *HTTPHeaderFilter) Reset() {
	*x = HTTPHeaderFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPHeaderFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeaderFilter) ProtoMessage() {}

func (x *HTTPHeaderFilter) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeaderFilter.ProtoReflect.Descriptor instead.
func (*HTTPHeaderFilter) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{7}
}

func (x *HTTPHeaderFilter) GetSet() []*HTTPHeader {
	if x != nil {
		return x.Set
	}
	return nil
}

func (x *HTTPHeaderFilter) GetAdd() []*HTTPHeader {
	if x != nil {
		return x.Add
	}
	return nil
}

func (x *HTTPHeaderFilter) GetRemove() []string {
	if x != nil {
		return x.Remove
	}
	return nil
}

type HTTPHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *HTTPHeader) Reset() {
	*x = HTTPHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeader) ProtoMessage() {}

func (x *HTTPHeader) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeader.ProtoReflect.Descriptor instead.
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{8}
}

func (x *HTTPHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPHeader) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type HTTPURLRewriteFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PathPrefix string `protobuf:"bytes,1,opt,name=path_prefix,json=pathPrefix,proto3" json:"path_prefix,omitempty"`
}

func (x *HTTPURLRewriteFilter) Reset() {
	*x = HTTPURLRewriteFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPURLRewriteFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPURLRewriteFilter) ProtoMessage() {}

func (x *HTTPURLRewriteFilter) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPURLRewriteFilter.ProtoReflect.Descriptor instead.
func (*HTTPURLRewriteFilter) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{9}
}

func (x *HTTPURLRewriteFilter) GetPathPrefix() string {
	if x != nil {
		return x.PathPrefix
	}
	return ""
}

type HTTPBackendRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BackendRef *BackendReference `protobuf:"bytes,1,opt,name=backend_ref,json=backendRef,proto3" json:"backend_ref,omitempty"`
	// Weight specifies the proportion of requests forwarded to the referenced
	// backend. This is computed as weight/(sum of all weights in this
	// BackendRefs list). For non-zero values, there may be some epsilon from the
	// exact proportion defined here depending on the precision an implementation
	// supports. Weight is not a percentage and the sum of weights does not need
	// to equal 100.
	//
	// If only one backend is specified and it has a weight greater than 0, 100%
	// of the traffic is forwarded to that backend. If weight is set to 0, no
	// traffic should be forwarded for this entry. If unspecified, weight defaults
	// to 1.
	Weight uint32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	// Filters defined at this level should be executed if and only if the
	// request is being forwarded to the backend defined here.
	Filters []*HTTPRouteFilter `protobuf:"bytes,3,rep,name=filters,proto3" json:"filters,omitempty"`
}

func (x *HTTPBackendRef) Reset() {
	*x = HTTPBackendRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPBackendRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPBackendRef) ProtoMessage() {}

func (x *HTTPBackendRef) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_http_route_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPBackendRef.ProtoReflect.Descriptor instead.
func (*HTTPBackendRef) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_http_route_proto_rawDescGZIP(), []int{10}
}

func (x *HTTPBackendRef) GetBackendRef() *BackendReference {
	if x != nil {
		return x.BackendRef
	}
	return nil
}

func (x *HTTPBackendRef) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *HTTPBackendRef) GetFilters() []*HTTPRouteFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

var File_pbmesh_v2beta1_http_route_proto protoreflect.FileDescriptor

var file_pbmesh_v2beta1_http_route_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1d, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1b, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x70,
	0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x68, 0x74,
	0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x70, 0x62, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc6,
	0x01, 0x0a, 0x09, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x0b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x73, 0x12, 0x1c, 0x0a,
	0x09, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x3a,
	0x06, 0xa2, 0x93, 0x04, 0x02, 0x08, 0x03, 0x22, 0x8d, 0x03, 0x0a, 0x0d, 0x48, 0x54, 0x54, 0x50,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x12, 0x48, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x50, 0x0a, 0x0c,
	0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65,
	0x66, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x73, 0x12, 0x4c,
	0x0a, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x73, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x12, 0x49, 0x0a, 0x07,
	0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54,
	0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x07,
	0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x8b, 0x02, 0x0a, 0x0e, 0x48, 0x54, 0x54, 0x50,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x40, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x50, 0x61, 0x74,
	0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x48, 0x0a, 0x07,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54,
	0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x55, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54,
	0x50, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x16, 0x0a,
	0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x67, 0x0a, 0x0d, 0x48, 0x54, 0x54, 0x50, 0x50, 0x61, 0x74,
	0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x97,
	0x01, 0x0a, 0x0f, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x42, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x22, 0x87, 0x01, 0x0a, 0x13, 0x48, 0x54, 0x54,
	0x50, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x46, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0xbb, 0x02, 0x0a, 0x0f, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x67, 0x0a, 0x17, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12,
	0x69, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x16, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x0b, 0x75, 0x72,
	0x6c, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x48, 0x54, 0x54, 0x50, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x75, 0x72, 0x6c, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x22, 0xa4, 0x01, 0x0a, 0x10, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x03, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x03, 0x73,
	0x65, 0x74, 0x12, 0x3b, 0x0a, 0x03, 0x61, 0x64, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x03, 0x61, 0x64, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x22, 0x36, 0x0a, 0x0a, 0x48, 0x54, 0x54, 0x50, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x37, 0x0a, 0x14, 0x48, 0x54, 0x54, 0x50, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x74, 0x68, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61,
	0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0xc4, 0x01, 0x0a, 0x0e, 0x48, 0x54, 0x54,
	0x50, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x12, 0x50, 0x0a, 0x0b, 0x62,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x12, 0x16, 0x0a,
	0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x48, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2a,
	0x82, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x41, 0x54, 0x48, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x41, 0x54, 0x48, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x41, 0x43, 0x54, 0x10, 0x01, 0x12, 0x1a, 0x0a,
	0x16, 0x50, 0x41, 0x54, 0x48, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x50, 0x52, 0x45, 0x46, 0x49, 0x58, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x41, 0x54,
	0x48, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x47,
	0x45, 0x58, 0x10, 0x03, 0x2a, 0xc9, 0x01, 0x0a, 0x0f, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x48, 0x45, 0x41, 0x44,
	0x45, 0x52, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x48,
	0x45, 0x41, 0x44, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x45, 0x58, 0x41, 0x43, 0x54, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x48, 0x45, 0x41, 0x44,
	0x45, 0x52, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45,
	0x47, 0x45, 0x58, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x5f,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45,
	0x4e, 0x54, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x5f, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x49, 0x58,
	0x10, 0x04, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x54,
	0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x55, 0x46, 0x46, 0x49, 0x58, 0x10, 0x05,
	0x2a, 0xa5, 0x01, 0x0a, 0x13, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x51, 0x55, 0x45, 0x52,
	0x59, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x20, 0x0a, 0x1c, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x5f,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x41, 0x43, 0x54,
	0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x50, 0x41, 0x52, 0x41,
	0x4d, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x47,
	0x45, 0x58, 0x10, 0x02, 0x12, 0x22, 0x0a, 0x1e, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x50, 0x41,
	0x52, 0x41, 0x4d, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50,
	0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x42, 0x8f, 0x02, 0x0a, 0x21, 0x63, 0x6f, 0x6d,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0e,
	0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x2f, 0x70, 0x62, 0x6d, 0x65, 0x73,
	0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x6d, 0x65, 0x73, 0x68, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x48, 0x43, 0x4d, 0xaa, 0x02, 0x1d, 0x48, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x4d,
	0x65, 0x73, 0x68, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1d, 0x48, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d,
	0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0xe2, 0x02, 0x29, 0x48, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d,
	0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x20, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x3a, 0x3a, 0x4d, 0x65, 0x73,
	0x68, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_pbmesh_v2beta1_http_route_proto_rawDescOnce sync.Once
	file_pbmesh_v2beta1_http_route_proto_rawDescData = file_pbmesh_v2beta1_http_route_proto_rawDesc
)

func file_pbmesh_v2beta1_http_route_proto_rawDescGZIP() []byte {
	file_pbmesh_v2beta1_http_route_proto_rawDescOnce.Do(func() {
		file_pbmesh_v2beta1_http_route_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbmesh_v2beta1_http_route_proto_rawDescData)
	})
	return file_pbmesh_v2beta1_http_route_proto_rawDescData
}

var file_pbmesh_v2beta1_http_route_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_pbmesh_v2beta1_http_route_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_pbmesh_v2beta1_http_route_proto_goTypes = []interface{}{
	(PathMatchType)(0),           // 0: hashicorp.consul.mesh.v2beta1.PathMatchType
	(HeaderMatchType)(0),         // 1: hashicorp.consul.mesh.v2beta1.HeaderMatchType
	(QueryParamMatchType)(0),     // 2: hashicorp.consul.mesh.v2beta1.QueryParamMatchType
	(*HTTPRoute)(nil),            // 3: hashicorp.consul.mesh.v2beta1.HTTPRoute
	(*HTTPRouteRule)(nil),        // 4: hashicorp.consul.mesh.v2beta1.HTTPRouteRule
	(*HTTPRouteMatch)(nil),       // 5: hashicorp.consul.mesh.v2beta1.HTTPRouteMatch
	(*HTTPPathMatch)(nil),        // 6: hashicorp.consul.mesh.v2beta1.HTTPPathMatch
	(*HTTPHeaderMatch)(nil),      // 7: hashicorp.consul.mesh.v2beta1.HTTPHeaderMatch
	(*HTTPQueryParamMatch)(nil),  // 8: hashicorp.consul.mesh.v2beta1.HTTPQueryParamMatch
	(*HTTPRouteFilter)(nil),      // 9: hashicorp.consul.mesh.v2beta1.HTTPRouteFilter
	(*HTTPHeaderFilter)(nil),     // 10: hashicorp.consul.mesh.v2beta1.HTTPHeaderFilter
	(*HTTPHeader)(nil),           // 11: hashicorp.consul.mesh.v2beta1.HTTPHeader
	(*HTTPURLRewriteFilter)(nil), // 12: hashicorp.consul.mesh.v2beta1.HTTPURLRewriteFilter
	(*HTTPBackendRef)(nil),       // 13: hashicorp.consul.mesh.v2beta1.HTTPBackendRef
	(*ParentReference)(nil),      // 14: hashicorp.consul.mesh.v2beta1.ParentReference
	(*HTTPRouteTimeouts)(nil),    // 15: hashicorp.consul.mesh.v2beta1.HTTPRouteTimeouts
	(*HTTPRouteRetries)(nil),     // 16: hashicorp.consul.mesh.v2beta1.HTTPRouteRetries
	(*BackendReference)(nil),     // 17: hashicorp.consul.mesh.v2beta1.BackendReference
}
var file_pbmesh_v2beta1_http_route_proto_depIdxs = []int32{
	14, // 0: hashicorp.consul.mesh.v2beta1.HTTPRoute.parent_refs:type_name -> hashicorp.consul.mesh.v2beta1.ParentReference
	4,  // 1: hashicorp.consul.mesh.v2beta1.HTTPRoute.rules:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteRule
	5,  // 2: hashicorp.consul.mesh.v2beta1.HTTPRouteRule.matches:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteMatch
	9,  // 3: hashicorp.consul.mesh.v2beta1.HTTPRouteRule.filters:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteFilter
	13, // 4: hashicorp.consul.mesh.v2beta1.HTTPRouteRule.backend_refs:type_name -> hashicorp.consul.mesh.v2beta1.HTTPBackendRef
	15, // 5: hashicorp.consul.mesh.v2beta1.HTTPRouteRule.timeouts:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteTimeouts
	16, // 6: hashicorp.consul.mesh.v2beta1.HTTPRouteRule.retries:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteRetries
	6,  // 7: hashicorp.consul.mesh.v2beta1.HTTPRouteMatch.path:type_name -> hashicorp.consul.mesh.v2beta1.HTTPPathMatch
	7,  // 8: hashicorp.consul.mesh.v2beta1.HTTPRouteMatch.headers:type_name -> hashicorp.consul.mesh.v2beta1.HTTPHeaderMatch
	8,  // 9: hashicorp.consul.mesh.v2beta1.HTTPRouteMatch.query_params:type_name -> hashicorp.consul.mesh.v2beta1.HTTPQueryParamMatch
	0,  // 10: hashicorp.consul.mesh.v2beta1.HTTPPathMatch.type:type_name -> hashicorp.consul.mesh.v2beta1.PathMatchType
	1,  // 11: hashicorp.consul.mesh.v2beta1.HTTPHeaderMatch.type:type_name -> hashicorp.consul.mesh.v2beta1.HeaderMatchType
	2,  // 12: hashicorp.consul.mesh.v2beta1.HTTPQueryParamMatch.type:type_name -> hashicorp.consul.mesh.v2beta1.QueryParamMatchType
	10, // 13: hashicorp.consul.mesh.v2beta1.HTTPRouteFilter.request_header_modifier:type_name -> hashicorp.consul.mesh.v2beta1.HTTPHeaderFilter
	10, // 14: hashicorp.consul.mesh.v2beta1.HTTPRouteFilter.response_header_modifier:type_name -> hashicorp.consul.mesh.v2beta1.HTTPHeaderFilter
	12, // 15: hashicorp.consul.mesh.v2beta1.HTTPRouteFilter.url_rewrite:type_name -> hashicorp.consul.mesh.v2beta1.HTTPURLRewriteFilter
	11, // 16: hashicorp.consul.mesh.v2beta1.HTTPHeaderFilter.set:type_name -> hashicorp.consul.mesh.v2beta1.HTTPHeader
	11, // 17: hashicorp.consul.mesh.v2beta1.HTTPHeaderFilter.add:type_name -> hashicorp.consul.mesh.v2beta1.HTTPHeader
	17, // 18: hashicorp.consul.mesh.v2beta1.HTTPBackendRef.backend_ref:type_name -> hashicorp.consul.mesh.v2beta1.BackendReference
	9,  // 19: hashicorp.consul.mesh.v2beta1.HTTPBackendRef.filters:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteFilter
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_pbmesh_v2beta1_http_route_proto_init() }
func file_pbmesh_v2beta1_http_route_proto_init() {
	if File_pbmesh_v2beta1_http_route_proto != nil {
		return
	}
	file_pbmesh_v2beta1_common_proto_init()
	file_pbmesh_v2beta1_http_route_retries_proto_init()
	file_pbmesh_v2beta1_http_route_timeouts_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pbmesh_v2beta1_http_route_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPRouteRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPRouteMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPPathMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPHeaderMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPQueryParamMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPRouteFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPHeaderFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPURLRewriteFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_http_route_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPBackendRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbmesh_v2beta1_http_route_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbmesh_v2beta1_http_route_proto_goTypes,
		DependencyIndexes: file_pbmesh_v2beta1_http_route_proto_depIdxs,
		EnumInfos:         file_pbmesh_v2beta1_http_route_proto_enumTypes,
		MessageInfos:      file_pbmesh_v2beta1_http_route_proto_msgTypes,
	}.Build()
	File_pbmesh_v2beta1_http_route_proto = out.File
	file_pbmesh_v2beta1_http_route_proto_rawDesc = nil
	file_pbmesh_v2beta1_http_route_proto_goTypes = nil
	file_pbmesh_v2beta1_http_route_proto_depIdxs = nil
}
