/* option operations

   Written by Matthias Hensler
   Copyright WSPse 1999-2004
   eMail: matthias@wspse.de

Created: 1999/06/06
Updated: 2005/04/28
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ncurses.h>
#include "mp3creat.h"

extern int init_cd();
extern void fill_in_songs(WINDOW *win);
extern void check_config();
field_select_typ *select_field_box(field_select_typ *fs_anchor, int max_length, char *stat_text,
				   BOOL use_old, BOOL allow_space);
extern void free_field_select(field_select_typ **anchor);
extern void wuuush(int code);
extern char *input_line(int y_line, char *def_str, char *usage_str, BOOL select);
extern void reinit_volume(WINDOW *win);
extern void init_config();
extern void check_config();
extern int get_config(char *file);
extern int put_config(char *file, BOOL ask);
extern char *req_get_file(const char *path, const char *description);
extern char *req_get_dir(const char *path, const char *description);
extern void filenm_generate(song_typ *track);
extern char *input_line2(int y_line, char *def_str, char *usage_str,
			 char *des1, char *des2, char *des3, char *des4,
			 char *des5, char *des6, BOOL select);
extern BOOL     select_yesno_box(char *tx);
extern void     popup_error_win(char *tx);
extern char     *copy_char_str(char *old);
extern char     *file_glob_in_name(char *name);
extern int      select_genre();
extern char     *def_cddb_server;
extern char     *def_cddb_bank;
extern char     *def_cdrom_dev;
extern char     *def_tmp_file;
extern char     *def_mp3_dir;
extern char     *def_mp3_info;
extern char     *def_cd_rip_nf;
extern char     *def_cd_rip_of;
extern char     *def_mp3_enc_nf;
extern char     *def_mp3_enc_of;
extern char     *def_m3u_pattern;
extern char     *def_m3u_patmix;
extern char     *def_m3u_dir;
extern char     *def_comment;
extern char     *fn_pattern;
extern char     *fn_pattern_mix;
extern char     *def_ill_chars;
extern char     *def_exp_file;
extern int      fn_mode;
extern char     replace_space_ch;
extern BOOL     fn_toupper;
extern signed char config_fancy_colors;
extern int      of_fifo_buf;
extern int      auto_save;
extern char     *external_config_file;
extern char     *external_cdrom_dev;
extern song_typ *lay_global_anchor[2];
extern BOOL     def_on_fly;
extern BOOL     eased_char_hand;
extern char     replace_slash_ch;
extern char     *mp3_genre[];
extern int      sb_pressed_key;
extern BOOL     rip_enc_ordered;
extern int      lay_act_side;
extern int      del_tmp_on_exit;
extern BOOL     clear_del_on_exp;
extern BOOL     config_curs_dir;
extern int      def_m3u_rel_name;
extern BOOL     config_cddb_enbl;
extern BOOL     config_para_mp3c;
extern int      config_case_chg;
extern char     *def_cddb_email;
extern char     *def_smtp_server;
extern char     *def_my_email;
extern BOOL     config_open_tray;
extern BOOL     config_ill_remove;
extern char     *def_unknown_gen;
extern BOOL     config_pat_prot;

void change_comment(song_typ *anchor, char *old, char *new);
void change_onfly_flag(BOOL new_val, song_typ *anchor);

/* rebuild field entry */
void reb_field_entry(field_select_typ *anchor, char *des, char *value)
{
  if(anchor->dest) free(anchor->dest);
  anchor->dest = copy_char_str(value);

  if(des) {
    if(anchor->field) free(anchor->field);
    anchor->field = copy_char_str(des);
  }
}

/* rebuild filenames */
void reb_filenm()
{
  song_typ *curr;
  int i;

  for(i=0;i<=1;i++) {
    curr = lay_global_anchor[i];
    while(curr) {
      if(curr->fn_auto) {
	if(curr->dirname) free(curr->dirname);
	curr->dirname = (char *) malloc(sizeof(char) * (strlen(def_mp3_dir)+1));
	if(! curr->dirname) {
	  perror("malloc");
	  wuuush(1);
	}
	memcpy(curr->dirname, def_mp3_dir, strlen(def_mp3_dir)+1);
	filenm_generate(curr);
      }
      curr = curr->next;
    }
  }    
}

/* add an entry to field tree */
void add_field_entry(field_select_typ **anchor, char *des, int nr, char *value)
{
  field_select_typ *curr, *new;

  new = (field_select_typ *) malloc(sizeof(field_select_typ));
  if(new == NULL) {
    perror("malloc");
    wuuush(1);
  }

  new->field = copy_char_str(des);
  new->dest  = copy_char_str(value);

  new->information = (char *) malloc(sizeof(char));
  if(new->information == NULL) {
    perror("malloc");
    wuuush(1);
  }
  *(new->information) = (unsigned char) nr;
  
  new->next        = NULL;
  new->prev        = NULL;

  curr = *anchor;
  while(curr) {
    if(! curr->next) break;
    curr = curr->next;
  }

  if(! curr) *anchor = new;
  else {
    curr->next = new;
    new->prev  = curr;
  }
}

/* Option menu */  
void option_menu(WINDOW *win)
{
  field_select_typ *new, *anchor;
  BOOL reinit_cddev;
  BOOL use_old;
  BOOL loaded_def;
  char *pointer;
  char mini_str[256];
  int i;

  anchor       = NULL;
  reinit_cddev = FALSE;
  use_old      = FALSE;
  loaded_def   = TRUE;

  /* generate option tree */
  while(1) {
    if(loaded_def) {
      add_field_entry(&anchor, _("CDrom device"), 1, def_cdrom_dev);
      
      add_field_entry(&anchor, _("CDDB server"), 2, def_cddb_server);

      add_field_entry(&anchor, _("CDDB eMail address"), 33, def_cddb_email);

      add_field_entry(&anchor, _("SMTP server"), 34, def_smtp_server);

      add_field_entry(&anchor, _("My eMail address"), 35, def_my_email);
      
      add_field_entry(&anchor, _("local CDDB directory"), 3, def_cddb_bank);

      if(config_cddb_enbl) {
	strcpy(mini_str, _("yes"));
      } else {
	strcpy(mini_str, _("no"));
      }
      add_field_entry(&anchor, _("allow remote CDDB access?"), 30, mini_str);
      
      add_field_entry(&anchor, _("MP3/OGG destination directory"), 4, def_mp3_dir);
      
      add_field_entry(&anchor, _("Pattern for mp3/ogg-filename creation"), 5, fn_pattern);

      add_field_entry(&anchor, _("Pattern for mp3/ogg-filename (sampler cds)"), 39, fn_pattern_mix);
      
      sprintf(mini_str, "%d", fn_mode);
      add_field_entry(&anchor, _("Patternmode"), 6, mini_str);

      sprintf(mini_str, "%c", replace_space_ch);
      add_field_entry(&anchor, _("space replace character"), 42, mini_str);
      
      if(config_case_chg == 0)      strcpy(mini_str, _("no"));
      else if(config_case_chg == 1) strcpy(mini_str, _("to lower"));
      else                          strcpy(mini_str, _("to upper"));
      add_field_entry(&anchor, _("Case change"), 32, mini_str);
      
      if(fn_toupper) {
	strcpy(mini_str, _("on"));
      } else {
	strcpy(mini_str, _("off"));
      }
      add_field_entry(&anchor, _("To-Upper mode"), 7, mini_str);
      
      add_field_entry(&anchor, _("illegal characters for filenames"), 21, def_ill_chars);

      if(config_ill_remove) {
	strcpy(mini_str, _("remove them"));
      } else {
	strcpy(mini_str, _("use patternmode"));
      }
      add_field_entry(&anchor, _("what to do with ill characters"), 37, mini_str);

      if(config_pat_prot) {
	strcpy(mini_str, _("yes"));
      } else {
	strcpy(mini_str, _("no"));
      }
      add_field_entry(&anchor, _("protect pattern masks"), 41, mini_str);
      
      sprintf(mini_str, "%c", replace_slash_ch);
      add_field_entry(&anchor, _("slash replace character"), 23, mini_str);
      
      if(eased_char_hand) {
	strcpy(mini_str, _("non-strict (8-bit Western)"));
      } else {
	strcpy(mini_str, _("strict (7-bit ASCII)"));
      }
      
      add_field_entry(&anchor, _("handling of allowed characters"), 22, mini_str);
      
      add_field_entry(&anchor, _("Pattern for m3u-playlist creation"), 17, def_m3u_pattern);

      add_field_entry(&anchor, _("Pattern for m3u-playlists (sampler cds)"), 40, def_m3u_patmix);
      
      if((def_m3u_dir) && (strcmp(def_m3u_dir, "0") == 0)) {
	add_field_entry(&anchor, _("M3U destination directory"), 18, def_mp3_dir);
      } else {
	add_field_entry(&anchor, _("M3U destination directory"), 18, def_m3u_dir);
      }

      if(def_m3u_rel_name == 0) {
	sprintf(mini_str, _("full path"));
      } else if(def_m3u_rel_name == 1) {
	sprintf(mini_str, _("relative to m3u-dir"));
      } else {
	sprintf(mini_str, _("relative to m3u-file"));
      }
      add_field_entry(&anchor, _("how to create m3u-entries"), 29, mini_str);
      
      if(auto_save) {
	strcpy(mini_str, _("on"));
      } else {
	strcpy(mini_str, _("off"));
      }
      add_field_entry(&anchor, _("auto save flag"), 8, mini_str);
      
      if(def_on_fly) {
	strcpy(mini_str, _("yes"));
      } else {
	strcpy(mini_str, _("no"));
      }
      add_field_entry(&anchor, _("encode on-fly as default?"), 20, mini_str);
      
      if(rip_enc_ordered) strcpy(mini_str, _("yes"));
      else                strcpy(mini_str, _("no"));
      add_field_entry(&anchor, _("rip all tracks before encoding?"), 24, mini_str);
      
      sprintf(mini_str, "%d", config_fancy_colors);
      add_field_entry(&anchor, _("fancy colors"), 9, mini_str);
      
      add_field_entry(&anchor, _("CDripper non-fly (output to file)"), 10, def_cd_rip_nf);
      
      add_field_entry(&anchor, _("CDripper on-fly (output to stdout)"), 11, def_cd_rip_of);
      
      add_field_entry(&anchor, _("MP3/Oggencoder non-fly (input from file)"), 12, def_mp3_enc_nf);
      
      add_field_entry(&anchor, _("MP3/Oggencoder on-fly (input from stdin)"), 13, def_mp3_enc_of);
      
      add_field_entry(&anchor, _("Program for setting MP3/OGG-ID-fields"), 14, def_mp3_info);
      
      add_field_entry(&anchor, _("MP3/OGG-comment"), 19, def_comment);

      add_field_entry(&anchor, _("String for unknown genre"), 38, def_unknown_gen);

      if(config_open_tray) {
	strcpy(mini_str, _("yes"));
      } else {
	strcpy(mini_str, _("no"));
      }
      add_field_entry(&anchor, _("open tray after encoding?"), 36, mini_str);
      
      sprintf(mini_str, "%d", of_fifo_buf);
      add_field_entry(&anchor, _("Size of FIFO-buffer in KB (for on-fly encoding)"), 15, mini_str);
      
      add_field_entry(&anchor, _("Tempfile (for non-fly encoding)"), 16, def_tmp_file);
      
      if(del_tmp_on_exit == 0)      strcpy(mini_str, _("never"));
      else if(del_tmp_on_exit == 1) strcpy(mini_str, _("only if delflag is set"));
      else                          strcpy(mini_str, _("yes, ever"));
      add_field_entry(&anchor, _("Delete tempfiles on exit?"), 25, mini_str);
      
      add_field_entry(&anchor, _("Exportfile for ripped tracks"), 26, def_exp_file);
      
      if(clear_del_on_exp) strcpy(mini_str, _("yes"));
      else                 strcpy(mini_str, _("no"));
      add_field_entry(&anchor, _("Clear delflag on export?"), 27, mini_str);
     
      if(config_para_mp3c) strcpy(mini_str, _("yes"));
      else                 strcpy(mini_str, _("no"));
      add_field_entry(&anchor, _("Allow parallel running sessions of MP3c?"), 31, mini_str);
      
      if(config_curs_dir) strcpy(mini_str, _("yes"));
      else                strcpy(mini_str, _("no"));
      add_field_entry(&anchor, _("Use directory requester for selecting directories?"), 28, mini_str);
      
      add_field_entry(&anchor, _("Load defaults"), 122, NULL);
      
      add_field_entry(&anchor, _("Load Presets (OGG/oggenc)"), 123, NULL);
      add_field_entry(&anchor, _("Load Presets (MP3/lame)"), 124, NULL);
      
      add_field_entry(&anchor, _("Load Config"), 120, NULL);
      
      add_field_entry(&anchor, _("Save Config"), 121, NULL);
      
      add_field_entry(&anchor, _("Exit Optionmenu"), 125, NULL);
      
      loaded_def = FALSE;
    }
      
    new = select_field_box(anchor, 150, _("Optionmenu"), use_old, FALSE);
    use_old = TRUE;
    if(! new) break;
    if((int) ((unsigned char) *(new->information)) == 125) break;
    switch((int) ((unsigned char) *(new->information))) {
      case 1:
	pointer = input_line(16, def_cdrom_dev, _("enter cdrom device"), TRUE);
	if(pointer) {
	  external_cdrom_dev = NULL;
	  if(def_cdrom_dev) free(def_cdrom_dev);
	  def_cdrom_dev = file_glob_in_name(pointer);
	  reinit_cddev = TRUE;
	  check_config();
	  reb_field_entry(new, NULL, def_cdrom_dev);
	}
	break;

      case 2:
	pointer = input_line2(16, def_cddb_server, _("enter CDDB-server"
			     " [host:port] (0 to disable)"),
			      _("you can input more servers, by seperating them with"),
			      _("a comma, eg. \"freedb.freedb.org:8880,cddb.cddb.com:8880\""),
			      _("note: cddb.com is not longer usable!"),
			      NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(def_cddb_server) free(def_cddb_server);
	  def_cddb_server = pointer;
	  check_config();
	  reb_field_entry(new, NULL, def_cddb_server);
	}
	break;

      case 3:
	pointer = req_get_dir(def_cddb_bank, _("select CDDB base directory"));
	if(pointer) {
	  if(def_cddb_bank) free(def_cddb_bank);
	  def_cddb_bank = pointer;
	  check_config();
	  reb_field_entry(new, NULL, def_cddb_bank);
	}
	break;

      case 4:
	pointer = req_get_dir(def_mp3_dir, _("select MP3/OGG destination directory"));
	if(pointer) {
	  if(def_mp3_dir) free(def_mp3_dir);
	  def_mp3_dir = pointer;
	  reb_filenm();
	  check_config();
	  if((def_m3u_dir) && (strcmp(def_m3u_dir, "0") == 0)) {
	    free_field_select(&anchor);
	    anchor     = NULL;
	    loaded_def = TRUE;
	    use_old    = FALSE;
	  } else {
	    reb_field_entry(new, NULL, def_mp3_dir);
	  }
	}
	break;

      case 5:
	pointer = input_line2(16, fn_pattern, _("Enter pattern for filename creation"),
			      _("%1: Artistname"), _("%2: Songtitle"), _("%3: Albumname"),
			      _("%4: Genre, %5: Year"), _("%6: Track, %7: Track with leading zeros"),
			      _("%8: CDDB-ID"), TRUE);
	if(pointer) {
	  if(fn_pattern) free(fn_pattern);
	  fn_pattern = pointer;
	  reb_filenm();
	  check_config();
	  reb_field_entry(new, NULL, fn_pattern);
	}
	break;

      case 6:
	sprintf(mini_str, "%d", fn_mode);
	pointer = input_line2(16, mini_str, _("Enter pattern mode (0, 1 or 2)"),
			      _("0: Spaces in filename allowed"),
			      _("1: Spaces will be converted to specified character"),
			      _("2: every space will be killed"),
			      NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(strlen(pointer) == 1) {
	    fn_mode = atoi(pointer);
	    if((fn_mode < 0) || (fn_mode > 2)) fn_mode = 1;
	    reb_filenm();
	    check_config();
	    sprintf(mini_str, "%d", fn_mode);
	    reb_field_entry(new, NULL, mini_str);
	  }
	  free(pointer);
	}
	break;

      case 7:
	if(select_yesno_box(_("Convert first letter in filename toupper?"))) {
	  fn_toupper = 1;
	  strcpy(mini_str, _("on"));
	} else {
	  fn_toupper = 0;
	  strcpy(mini_str, _("off"));
	}
	reb_field_entry(new, NULL, mini_str);
	reb_filenm();
	check_config();
	break;
	
      case 8:
	if(select_yesno_box(_("Save Config on exit?"))) {
	  auto_save = 1;
	  strcpy(mini_str, _("on"));
	} else {
	  auto_save = 0;
	  strcpy(mini_str, _("off"));
	}
	reb_field_entry(new, NULL, mini_str);
	check_config();
	break;
	
      case 9:
    	sprintf(mini_str, "%d", config_fancy_colors);
	pointer = input_line2(16, mini_str, _("Show fancy colors in windows (0, 1 or 2)"),
			      _("0: Never"),
			      _("1: Sometimes"),
			      _("2: Yes, everytime"),
			      NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(strlen(pointer) == 1) {
	    config_fancy_colors = atoi(pointer);
	    if((config_fancy_colors < 0) || (config_fancy_colors > 2)) config_fancy_colors = 1;
	    check_config();
	    sprintf(mini_str, "%d", config_fancy_colors);
	    reb_field_entry(new, NULL, mini_str);
	  }
	  free(pointer);
	}
	break;

      case 10:
	pointer = input_line2(16, def_cd_rip_nf, _("Program for ripping audiocds with output to file"),
			      _("%1: cdrom device"),
			      _("%2: track (numeric)"),
			      _("%3: outputfile"),
			      NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(def_cd_rip_nf) free(def_cd_rip_nf);
	  def_cd_rip_nf = file_glob_in_name(pointer);
	  check_config();
	  reb_field_entry(new, NULL, def_cd_rip_nf);
	}
	break;

      case 11:
	pointer = input_line2(16, def_cd_rip_of, _("Program for ripping audiocds with output to stdout"),
			      _("%1: cdrom device"),
			      _("%2: track (numeric)"),
			      NULL, NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(def_cd_rip_of) free(def_cd_rip_of);
	  def_cd_rip_of = file_glob_in_name(pointer);
	  check_config();
	  reb_field_entry(new, NULL, def_cd_rip_of);
	}
	break;

      case 12:
	pointer = input_line2(16, def_mp3_enc_nf, _("Program for encoding wav->mp3/ogg (input from file)"),
			      _("%1: inputfile, %2: outputfile"),
			      _("%3: album, %4: genre by number, %5: year"),
			      _("%6: comment, %7: filename, %8: genre by name"),
			      _("%a: track, %b: track (with leading zeros)"),
			      _("%c: artist, %d: title"),
			      NULL, TRUE);
	if(pointer) {
	  if(def_mp3_enc_nf) free(def_mp3_enc_nf);
	  def_mp3_enc_nf = file_glob_in_name(pointer);
	  check_config();
	  reb_field_entry(new, NULL, def_mp3_enc_nf);
	}
	break;

      case 13:
	pointer = input_line2(16, def_mp3_enc_of, _("Program for encoding wav->mp3/ogg (input from stdin)"),
			      _("%1: outputfile"),
			      _("%3: album, %4: genre by number, %5: year"),
			      _("%6: comment, %7: filename, %8: genre by name"),
			      _("%a: track, %b: track (with leading zeros)"),
			      _("%c: artist, %d: title"),
			      NULL, TRUE);
	if(pointer) {
	  if(def_mp3_enc_of) free(def_mp3_enc_of);
	  def_mp3_enc_of = file_glob_in_name(pointer);
	  check_config();
	  reb_field_entry(new, NULL,def_mp3_enc_of);
	}
	break;

      case 14:
	pointer = input_line2(16, def_mp3_info, _("Program for setting MP3/OGG ID-Fields (0 to disable)"),
			      _("%1: Artistname,  %2: Songtitle"),
			      _("%3: Albumname"),
			      _("%4: Genre (by number),  %8: Genre (by name)"),
			      _("%5: Year,  %6: Comment"),
			      _("%7: Filename of MP3-file"),
			      _("%a: tracknumber without, %b: with leading zeros"), TRUE);
	if(pointer) {
	  if(def_mp3_info) free(def_mp3_info);
	  def_mp3_info = file_glob_in_name(pointer);
	  check_config();
	  reb_field_entry(new, NULL, def_mp3_info);
	}
	break;
	
      case 15:
	sprintf(mini_str, "%d", of_fifo_buf);
	pointer = input_line(16, mini_str, _("size of FIFO-buffer in KB (for on-the-fly encoding) [16 - 8192]"), TRUE);
	if(pointer) {
	  if((strlen(pointer) > 1) && (strlen(pointer) < 5)) {
	    of_fifo_buf = atoi(pointer);
	    if((of_fifo_buf < 16) || (of_fifo_buf > 8192)) of_fifo_buf = 512;
	    check_config();
	    sprintf(mini_str, "%d", of_fifo_buf);
	    reb_field_entry(new, NULL, mini_str);
	  }
	  free(pointer);
	}
	break;
	
      case 16:
	pointer = req_get_file(def_tmp_file, _("select tempfile name"));
	if(pointer) {
	  if(def_tmp_file) free(def_tmp_file);
	  def_tmp_file = pointer;
	  if(def_tmp_file[strlen(def_tmp_file)-1] == '/') {
	    def_tmp_file = (char *) malloc(sizeof(char) * (strlen(pointer) + 17));
	    if(! def_tmp_file) {
	      perror("malloc");
	      wuuush(1);
	    }
	    sprintf(def_tmp_file, "%sWSPse-MP3Creat", pointer);
	    free(pointer);
	  }
	  check_config();
	  def_tmp_file = file_glob_in_name(def_tmp_file);
       	  reb_field_entry(new, NULL, def_tmp_file);
	}
	break;
	 
      case 17:
	pointer = input_line2(16, def_m3u_pattern, _("Enter pattern for playlist creation (0 to disable)"),
			      _("%1: Artistname"), _("%2: Songtitle"),
			      _("%3: Albumname"), _("%4: Genre, %5: Year"),
			      _("%6: Track, %7: Track with leading zeros"),
			      _("%8: CDDB-ID"), TRUE);
	if(pointer) {
	  if(def_m3u_pattern) free(def_m3u_pattern);
	  def_m3u_pattern = pointer;
	  check_config();
	  reb_field_entry(new, NULL, def_m3u_pattern);
	}
	break;

      case 18:
	if(select_yesno_box(_("use mp3/ogg-dir for playlists?"))) {
	  if(def_m3u_dir) free(def_m3u_dir);
	  def_m3u_dir = (char *) malloc(sizeof(char) * 2);
	  if(! def_m3u_dir) {
	    perror("malloc");
	    wuuush(1);
	  }
	  *(def_m3u_dir    ) = '0';
	  *(def_m3u_dir + 1) = 0;
	} else {
	  if((def_m3u_dir) && (strcmp(def_m3u_dir, "0") == 0))
	    pointer = req_get_dir(NULL, _("select directory for M3U playlists"));
	  else
	    pointer = req_get_dir(def_m3u_dir, _("select directory for M3U playlists"));
  	  if(pointer) {
  	    if(def_m3u_dir) free(def_m3u_dir);
  	    def_m3u_dir = pointer;
	  }
	}
     	check_config();
	if((def_m3u_dir) && (strcmp(def_m3u_dir, "0") == 0))
	  reb_field_entry(new, NULL, def_mp3_dir);
	else
	  reb_field_entry(new, NULL, def_m3u_dir);
	break;

      case 19:
	pointer = input_line2(16, def_comment, _("Enter pattern for mp3/ogg-comment"),
			      _("%1: Artist, %2: Title, %3: Album, %4: Genre, %5: Year, %6: Track"),
			      _("%7: Track (leading zeros), %8: MP3c-Version, %a: Encode-day"),
			      _("%b: Encode-month, %c: Encode-year (2 digits), %d: Encode-year (4 dig)"),
			      _("%e: Encode-weekday (3 letter), %f: Encode-month (3 letter)"),
			      _("%g: Encode-hour, %h: Encode-minute (not so useful ;-)"),
			      _("%i: Tracklen (minutes), %j: Tracklen (seconds), %9: CDDBID"), TRUE);
	if(pointer) {
	  change_comment(lay_global_anchor[0], def_comment, pointer);
	  change_comment(lay_global_anchor[1], def_comment, pointer);
	  if(def_comment) free(def_comment);
	  def_comment = pointer;
	  reb_field_entry(new, NULL, def_comment);
	}
	break;
	  
      case 20:
	i = 0;     /* flag if default setting was altered */
	if(select_yesno_box(_("would you like to use on-fly encoding as default?"))) {
	  /* on-fly as default = TRUE */
	  if(! def_on_fly) i = 1;   /* altered! */
	  def_on_fly = TRUE;
	} else {
	  if(def_on_fly)   i = 1;   /* altered! */
	  def_on_fly = FALSE;
	}
	if(i && lay_global_anchor[0]) {
	  if(select_yesno_box(_("reset on-fly flag for your actual cd?"))) {
	    change_onfly_flag(def_on_fly, lay_global_anchor[0]);
	  }
	}
	if(i) {
	  if(def_on_fly) strcpy(mini_str, _("yes"));
	  else           strcpy(mini_str, _("no"));
	  reb_field_entry(new, NULL, mini_str);
	}
	break;

      case 21:
	pointer = input_line(16, def_ill_chars, _("enter unallowed characters in filenames"), TRUE);
	if(pointer) {
	  if(def_ill_chars) free(def_ill_chars);
	  def_ill_chars = pointer;
	  reb_filenm();
	  check_config();
	  reb_field_entry(new, NULL, def_ill_chars);
	}
	break;

      case 22:
	if(select_yesno_box(_("allow more characters in CDDB and inputbox?"))) {
	  eased_char_hand = TRUE;
	  strcpy(mini_str, _("non-strict (8-bit Western)"));
	} else {
	  eased_char_hand = FALSE;
	  strcpy(mini_str, _("strict (7-bit ASCII)"));
	}
	reb_field_entry(new, NULL, mini_str);
	break;

      case 23:
	sprintf(mini_str, "%c", replace_slash_ch);
	pointer = input_line(16, mini_str, _("character for replacing slashes (to avoid sensless dir-creation)"),
			     TRUE);
	if(pointer) {
	  replace_slash_ch = *pointer;
	  if(strlen(pointer) < 1) replace_slash_ch = '-';
	  else if(strlen(pointer) > 1) {
	    popup_error_win(_("too many chars, skipping trailing garbage"));
	  }
	  free(pointer);
	  reb_filenm();
	  check_config();
	  sprintf(mini_str, "%c", replace_slash_ch);
	  reb_field_entry(new, NULL, mini_str);
	}
	break;
	
      case 24:
	if(select_yesno_box(_("rip all tracks at once before encoding?"))) {
	  rip_enc_ordered = TRUE;
	  strcpy(mini_str, _("yes"));
	} else {
	  rip_enc_ordered = FALSE;
	  strcpy(mini_str, _("no"));
	}
	reb_field_entry(new, NULL, mini_str);
	break;
	
      case 25:
	sprintf(mini_str, "%d", del_tmp_on_exit);
	pointer = input_line2(16, mini_str, _("what to do with remaining tmpfiles on exit"),
			      _("0: leave them untouched"),
			      _("1: delete all files with set delflag"),
			      _("2: delete them all"),
			      NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(strlen(pointer) == 1) {
	    del_tmp_on_exit = atoi(pointer);
	    if(del_tmp_on_exit < 0 || del_tmp_on_exit > 2) del_tmp_on_exit = 1;
	    if(del_tmp_on_exit == 0)      strcpy(mini_str, _("never"));
	    else if(del_tmp_on_exit == 1) strcpy(mini_str, _("only if delflag is set"));
	    else                          strcpy(mini_str, _("yes, ever"));
	    reb_field_entry(new, NULL, mini_str);
	  }
	  free(pointer);
	}
	break;

      case 26:
	pointer = req_get_file(def_exp_file, _("select default exportfile for ripped tracks"));
      	if(pointer) {
	  if(def_exp_file) free(def_exp_file);
	  def_exp_file = pointer;
	  if(def_exp_file[strlen(def_exp_file)-1] == '/') {
	    def_exp_file = (char *) realloc(def_exp_file, sizeof(char) * (strlen(def_exp_file) + 15));
	    if(! def_exp_file) {
	      wuuush(1);
	    }
	    strcat(def_exp_file, ".mp3c-exported");
	  }
	  def_exp_file = file_glob_in_name(def_exp_file);
	  reb_field_entry(new, NULL, def_exp_file);
	  check_config();
	}
	break;
	  
      case 27:
	if(select_yesno_box(_("clear delflag on export?"))) {
	  clear_del_on_exp = TRUE;
	  strcpy(mini_str, _("yes"));
	} else {
	  clear_del_on_exp = FALSE;
	  strcpy(mini_str, _("no"));
	}
	reb_field_entry(new, NULL, mini_str);
	break;

      case 28:
	if(select_yesno_box(_("use directory requester instead of inputbox for dir select?"))) {
	  config_curs_dir = TRUE;
	  strcpy(mini_str, _("yes"));
	} else {
	  config_curs_dir = FALSE;
	  strcpy(mini_str, _("no"));
	}
	reb_field_entry(new, NULL, mini_str);
	break;

      case 29:
	sprintf(mini_str, "%d", def_m3u_rel_name);
	pointer = input_line2(16, mini_str, _("How to create the filename for a playlist-entry"),
			      _("0: use fullpath to mp3-file"),
			      _("1: use a relative path to m3u-maindir"),
			      _("2: use a relative path to the playlist"),
			      NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(strlen(pointer) == 1) {
	    def_m3u_rel_name = atoi(pointer);
	    if(def_m3u_rel_name == 0) {
	      sprintf(mini_str, _("full path"));
	    } else if(def_m3u_rel_name == 1) {
	      sprintf(mini_str, _("relative to m3u-dir"));
	    } else {
	      def_m3u_rel_name = 2;
	      sprintf(mini_str, _("relative to m3u-file"));
	    }
	    reb_field_entry(new, NULL, mini_str);
	  }
	  free(pointer);
	}
	break;

      case 30:
	if(select_yesno_box(_("allow remote CDDB access?"))) {
	  config_cddb_enbl = TRUE;
	  strcpy(mini_str, _("yes"));
	} else {
	  config_cddb_enbl = FALSE;
	  strcpy(mini_str, _("no"));
	}
	reb_field_entry(new, NULL, mini_str);
	break;

      case 31:
	if(select_yesno_box(_("allow parallel running MP3c sessions?"))) {
	  config_para_mp3c = TRUE;
	  strcpy(mini_str, _("yes"));
	} else {
	  config_para_mp3c = FALSE;
	  strcpy(mini_str, _("no"));
	}
	reb_field_entry(new, NULL, mini_str);
	break;

      case 32:
	sprintf(mini_str, "%d", config_case_chg);
	pointer = input_line2(16, mini_str, _("Enter mode for case changing (0, 1 or 2)"),
			      _("0: leave case as it is"),
			      _("1: convert all to lower case"),
			      _("2: convert all to upper case"),
			      NULL,
			      _("\"ArTiSt\" will be converted to \"artist\" if 1, to \"ARTIST\" if 2"),
			      _("if 1 and toupper is also set it will be converted to \"Artist\""), TRUE);
	if(pointer) {
	  if(strlen(pointer) == 1) {
	    config_case_chg = atoi(pointer);
	    if(config_case_chg < 0 || config_case_chg > 2) config_case_chg = 0;
	    reb_filenm();
	    if(config_case_chg == 0)      strcpy(mini_str, _("no"));
	    else if(config_case_chg == 1) strcpy(mini_str, _("to lower"));
	    else                          strcpy(mini_str, _("to upper"));
	    reb_field_entry(new, NULL, mini_str);
	  }
	  free(pointer);
	  pointer = NULL;
	}
	break;

      case 33:
	pointer = input_line2(16, def_cddb_email, _("enter CDDBs eMail address"),
			      _("you can input more servers, by seperating them with a comma"),
			      NULL,
			      _("at least \"freedb-submit@freedb.org\" should accept your entries"),
			      NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(def_cddb_email) free(def_cddb_email);
	  def_cddb_email = pointer;
	  reb_field_entry(new, NULL, def_cddb_email);
	}
	break;

      case 34:
	pointer = input_line2(16, def_smtp_server, _("enter your relaying SMTP server [host:port]"),
			      _("this server is used to relay your CDDB-entries via eMail"),
			      _("if you have a local daemon running you can use"),
			      _("\"localhost:smtp\"."),
			      NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(def_smtp_server) free(def_smtp_server);
	  def_smtp_server = pointer;
	  reb_field_entry(new, NULL, def_smtp_server);
	}
	break;

      case 35:
	pointer = input_line2(16, def_my_email, _("enter your eMail address"),
			      _("please use the right address, otherwise your SMTP-server"),
			      _("might deny relaying."),
			      NULL, NULL, NULL, NULL, TRUE);
	if(pointer) {
	  if(def_my_email) free(def_my_email);
	  def_my_email = pointer;
	  reb_field_entry(new, NULL, def_my_email);
	}
	break;

      case 36:
	if(select_yesno_box(_("open tray after encoding?"))) {
	  config_open_tray = TRUE;
	  strcpy(mini_str, _("yes"));
	} else {
	  config_open_tray = FALSE;
	  strcpy(mini_str, _("no"));
	}
	reb_field_entry(new, NULL, mini_str);
	break;

      case 37:
	if(select_yesno_box(_("remove illegal characters (otherwise use patternmode)?"))) {
	  config_ill_remove = TRUE;
	  strcpy(mini_str, _("remove them"));
	} else {
	  config_ill_remove = FALSE;
	  strcpy(mini_str, _("use patternmode"));
	}
	reb_field_entry(new, NULL, mini_str);
	break;

      case 38:
	pointer = input_line(16, def_unknown_gen, _("String for unknown genre"), TRUE);
	if(pointer) {
	  if(def_unknown_gen) free(def_unknown_gen);
	  def_unknown_gen = pointer;
	  reb_field_entry(new, NULL, def_unknown_gen);
	}
	break;

      case 39:
	pointer = input_line2(16, fn_pattern_mix, _("Enter pattern for filename creation (sampler cds)"),
			      _("%1: Artistname"), _("%2: Songtitle"), _("%3: Albumname"),
			      _("%4: Genre, %5: Year"), _("%6: Track, %7: Track with leading zeros"),
			      _("%8: CDDB-ID"), TRUE);
	if(pointer) {
	  if(fn_pattern_mix) free(fn_pattern_mix);
	  fn_pattern_mix = pointer;
	  reb_filenm();
	  check_config();
	  reb_field_entry(new, NULL, fn_pattern_mix);
	}
	break;
	
      case 40:
	pointer = input_line2(16, def_m3u_patmix, _("Enter pattern for playlist creation, sampler cds (0 to disable)"),
			      _("%1: Artistname"), _("%2: Songtitle"),
			      _("%3: Albumname"), _("%4: Genre, %5: Year"),
			      _("%6: Track, %7: Track with leading zeros"),
			      _("%8: CDDB-ID"), TRUE);
	if(pointer) {
	  if(def_m3u_patmix) free(def_m3u_patmix);
	  def_m3u_patmix = pointer;
	  check_config();
	  reb_field_entry(new, NULL, def_m3u_patmix);
	}
	break;

      case 41:
	if(select_yesno_box(_("Protect patternmasks from substitutions?"))) {
	  config_pat_prot = TRUE;
	  strcpy(mini_str, _("yes"));
	} else {
	  config_pat_prot = FALSE;
	  strcpy(mini_str, _("no"));
	}
	reb_field_entry(new, NULL, mini_str);
	reb_filenm();
	break;
	
      case 42:
	sprintf(mini_str, "%c", replace_space_ch);
	pointer = input_line(16, mini_str, _("character for replacing spaces"),
			     TRUE);
	if(pointer) {
	  replace_space_ch = *pointer;
	  if(strlen(pointer) < 1) replace_space_ch = '-';
	  else if(strlen(pointer) > 1) {
	    popup_error_win(_("too many chars, skipping trailing garbage"));
	  }
	  free(pointer);
	  reb_filenm();
	  check_config();
	  sprintf(mini_str, "%c", replace_space_ch);
	  reb_field_entry(new, NULL, mini_str);
	}
	break;
	
      case 120:
	get_config(external_config_file);
	reb_filenm();
	check_config();
	reinit_cddev = TRUE;
	free_field_select(&anchor);
	anchor     = NULL;
	loaded_def = TRUE;
	use_old    = FALSE;
	break;

      case 121:
	put_config(external_config_file, TRUE);
	break;
	
      case 122:
	init_config();
	check_config();
	reinit_cddev = TRUE;
	free_field_select(&anchor);
	anchor     = NULL;
	loaded_def = TRUE;
	use_old    = FALSE;
	break;

      case 123:
	/* load presets 1: OGG/oggenc */
	if(fn_pattern)     free(fn_pattern);
	if(fn_pattern_mix) free(fn_pattern_mix);
	if(def_mp3_enc_nf) free(def_mp3_enc_nf);
	if(def_mp3_enc_of) free(def_mp3_enc_of);
	if(def_mp3_info)   free(def_mp3_info);

	fn_pattern     = copy_char_str(PRE1_PATTERN);
	fn_pattern_mix = copy_char_str(PRE1_PATTERN_M);
	def_mp3_enc_nf = file_glob_in_name(copy_char_str(PRE1_ENC_NF));
	def_mp3_enc_of = file_glob_in_name(copy_char_str(PRE1_ENC_OF));
	def_mp3_info   = file_glob_in_name(copy_char_str(PRE1_ENC_INFO));
	
	reb_filenm();
	check_config();
	free_field_select(&anchor);
	anchor     = NULL;
	loaded_def = TRUE;
	use_old    = FALSE;
	break;

      case 124:
	/* load presets 2: MP3/lame */
	if(fn_pattern)     free(fn_pattern);
	if(fn_pattern_mix) free(fn_pattern_mix);
	if(def_mp3_enc_nf) free(def_mp3_enc_nf);
	if(def_mp3_enc_of) free(def_mp3_enc_of);
	if(def_mp3_info)   free(def_mp3_info);

	fn_pattern     = copy_char_str(PRE2_PATTERN);
	fn_pattern_mix = copy_char_str(PRE2_PATTERN_M);
	def_mp3_enc_nf = file_glob_in_name(copy_char_str(PRE2_ENC_NF));
	def_mp3_enc_of = file_glob_in_name(copy_char_str(PRE2_ENC_OF));
	def_mp3_info   = file_glob_in_name(copy_char_str(PRE2_ENC_INFO));
	
	reb_filenm();
	check_config();
	free_field_select(&anchor);
	anchor     = NULL;
	loaded_def = TRUE;
	use_old    = FALSE;
	break;
    }
  }
  
  free_field_select(&anchor);
  if(reinit_cddev) {
    reinit_volume(win);
  }
}

void change_comment(song_typ *anchor, char *old, char *new)
{
  song_typ *curr;

  curr = anchor;
  while(curr) {
    if(!((curr->comment) && (old) && (strcmp(curr->comment, old) != 0))) {
      if(curr->comment) free(curr->comment);
      curr->comment = (char *) malloc(sizeof(char) * (strlen(new)+1));
      if(! curr->comment) {
	perror("malloc");
	wuuush(1);
      }
      memcpy(curr->comment, new, strlen(new)+1);
    }
    curr = curr->next;
  }
}

void change_onfly_flag(BOOL new_val, song_typ *anchor)
{
  song_typ *curr;

  curr = anchor;
  while(curr) {
    curr->on_fly = new_val;
    curr = curr->next;
  }
}

void alter_track_infos_menu(song_typ *track)
{
  field_select_typ *new, *anchor;
  song_typ song_chg_fields, *song_curr;
  char *pointer;
  char mini_str[35];
  int i;
  BOOL use_old;
  BOOL loaded_def;
  BOOL yesno_flag;

  anchor     = NULL;
  use_old    = FALSE;
  loaded_def = TRUE;

  song_chg_fields.artist = NULL;
  song_chg_fields.title  = NULL;
  song_chg_fields.album  = NULL;
  song_chg_fields.comment= NULL;
  song_chg_fields.year   = -1;
  song_chg_fields.genre  = -1;
  song_chg_fields.toc    = 0;     /* flag for on-fly flag  */
  song_chg_fields.fn_auto= FALSE; /* flag for sampler flag */
  song_chg_fields.on_fly = FALSE;
  song_chg_fields.sampler= FALSE;
  
  while(1) {
    if(loaded_def) {
      /* build up menu */
      if(song_chg_fields.artist)
	add_field_entry(&anchor, _("[*] Artist"), 1, song_chg_fields.artist);
      else
	add_field_entry(&anchor, _("[ ] Artist"), 1, track->artist);

      if(song_chg_fields.title)
	add_field_entry(&anchor, _("[*] Title"), 2, song_chg_fields.title);
      else
	add_field_entry(&anchor, _("[ ] Title"), 2, track->title);

      if(song_chg_fields.album)
	add_field_entry(&anchor, _("[*] Album"), 3, song_chg_fields.album);
      else
	add_field_entry(&anchor, _("[ ] Album"), 3, track->album);

      if(song_chg_fields.year != -1) {
	sprintf(mini_str, "%4d", song_chg_fields.year);
	add_field_entry(&anchor, _("[*] Year"), 4, mini_str);
      } else {
	sprintf(mini_str, "%4d", track->year);
	add_field_entry(&anchor, _("[ ] Year"), 4, mini_str);
      }

      if(song_chg_fields.genre != -1)
	add_field_entry(&anchor, _("[*] Genre"), 5, (song_chg_fields.genre != TOT_GENRES ?
						     mp3_genre[song_chg_fields.genre] :
						     def_unknown_gen));
      else
	add_field_entry(&anchor, _("[ ] Genre"), 5, (track->genre != TOT_GENRES ?
						     mp3_genre[track->genre] :
						     def_unknown_gen));

      if(song_chg_fields.comment)
	add_field_entry(&anchor, _("[*] Comment"), 7, song_chg_fields.comment);
      else
	add_field_entry(&anchor, _("[ ] Comment"), 7, track->comment);
      
      if(song_chg_fields.toc != 0) {
	if(song_chg_fields.on_fly) strcpy(mini_str, _("YES"));
	else                       strcpy(mini_str, _("NO"));
	if(lay_act_side == 0) add_field_entry(&anchor, _("[*] Onfly convert"), 6, mini_str);
	else                  add_field_entry(&anchor, _("[*] Delete after enc"), 6, mini_str);
      } else {
	if(track->on_fly) strcpy(mini_str, _("YES"));
	else              strcpy(mini_str, _("NO"));
	if(lay_act_side ==0) add_field_entry(&anchor, _("[ ] Onfly convert"), 6, mini_str);
	else                 add_field_entry(&anchor, _("[ ] Delete after enc"), 6, mini_str);
      }

      if(song_chg_fields.fn_auto) {
	if(song_chg_fields.sampler) strcpy(mini_str, _("YES"));
	else                        strcpy(mini_str, _("NO"));
	add_field_entry(&anchor, _("[*] Sampler CD"), 8, mini_str);
      } else {
	if(track->sampler) strcpy(mini_str, _("YES"));
	else               strcpy(mini_str, _("NO"));
	add_field_entry(&anchor, _("[ ] Sampler CD"), 8, mini_str);
      }
      
      add_field_entry(&anchor, _("Reload original values"), 120, NULL);
      add_field_entry(&anchor, _("Set values for this track"), 121, NULL);
      add_field_entry(&anchor, _("Set values for all marked tracks"), 122, NULL);
      add_field_entry(&anchor, _("Set values for ALL tracks"), 123, NULL);
      add_field_entry(&anchor, _("Exit"), 125, NULL);

      loaded_def = FALSE;
    }

    sprintf(mini_str, _("Alter informations for track %d"), (track->toc)+1);
    new = select_field_box(anchor, 150, mini_str, use_old, TRUE);
    use_old = TRUE;

    if(! new) break;
    if(sb_pressed_key == 32) {
      switch((int) ((unsigned char) *(new->information))) {
	case 1:      /* Toggle artist flag */
	  if(song_chg_fields.artist) {
	    free(song_chg_fields.artist);
	    song_chg_fields.artist = NULL;
	    reb_field_entry(new, _("[ ] Artist"), track->artist);
	  } else {
	    song_chg_fields.artist = (char *) malloc(sizeof(char) * (strlen(track->artist)+1));
	    if(! song_chg_fields.artist) {
	      perror("malloc");
	      wuuush(1);
	    }
	    strcpy(song_chg_fields.artist, track->artist);
	    reb_field_entry(new, _("[*] Artist"), song_chg_fields.artist);
	  }
	  break;
	  
	case 2:      /* Toggle title flag */
	  if(song_chg_fields.title) {
	    free(song_chg_fields.title);
	    song_chg_fields.title = NULL;
	    reb_field_entry(new, _("[ ] Title"), track->title);
	  } else {
	    song_chg_fields.title = (char *) malloc(sizeof(char) * (strlen(track->title)+1));
	    if(! song_chg_fields.title) {
	      perror("malloc");
	      wuuush(1);
	    }
	    strcpy(song_chg_fields.title, track->title);
	    reb_field_entry(new, _("[*] Title"), song_chg_fields.title);
	  }
	  break;
	  
	case 3:      /* Toggle album flag */
	  if(song_chg_fields.album) {
	    free(song_chg_fields.album);
	    song_chg_fields.album = NULL;
	    reb_field_entry(new, _("[ ] Album"), track->album);
	  } else {
	    song_chg_fields.album = (char *) malloc(sizeof(char) * (strlen(track->album)+1));
	    if(! song_chg_fields.album) {
	      perror("malloc");
	      wuuush(1);
	    }
	    strcpy(song_chg_fields.album, track->album);
	    reb_field_entry(new, _("[*] Album"), song_chg_fields.album);
	  }
	  break;

	case 4:      /* Toggle year flag */
	  if(song_chg_fields.year != -1) {
	    song_chg_fields.year = -1;
	    sprintf(mini_str, "%4d", track->year);
	    reb_field_entry(new, _("[ ] Year"), mini_str);
	  } else {
	    song_chg_fields.year = track->year;
	    sprintf(mini_str, "%4d", song_chg_fields.year);
	    reb_field_entry(new, _("[*] Year"), mini_str);
	  }
	  break;

	case 5:      /* Toggle genre flag */
	  if(song_chg_fields.genre != -1) {
	    song_chg_fields.genre = -1;
	    reb_field_entry(new, _("[ ] Genre"), (track->genre != TOT_GENRES ? 
						  mp3_genre[track->genre] :
						  def_unknown_gen));
	  } else {
	    song_chg_fields.genre = track->genre;
	    reb_field_entry(new, _("[*] Genre"), (song_chg_fields.genre != TOT_GENRES ?
						  mp3_genre[song_chg_fields.genre] :
						  def_unknown_gen));
	  }
	  break;

	case 6:      /* Toggle onfly flag */
	  if(song_chg_fields.toc != 0) {
	    song_chg_fields.toc = 0;
	    if(track->on_fly) strcpy(mini_str, _("YES"));
	    else              strcpy(mini_str, _("NO"));
	    if(lay_act_side == 0) reb_field_entry(new, _("[ ] Onfly convert"), mini_str);
	    else                  reb_field_entry(new, _("[ ] Delete after enc"), mini_str);
	  } else {
	    song_chg_fields.toc = 1;
	    song_chg_fields.on_fly = track->on_fly;
	    if(song_chg_fields.on_fly) strcpy(mini_str, _("YES"));
	    else                       strcpy(mini_str, _("NO"));
	    if(lay_act_side == 0) reb_field_entry(new, _("[*] Onfly convert"), mini_str);
	    else                  reb_field_entry(new, _("[*] Delete after enc"), mini_str);
	  }
	  break;

	case 7:      /* Toggle comment flag */
	  if(song_chg_fields.comment) {
	    free(song_chg_fields.comment);
	    song_chg_fields.comment = NULL;
	    reb_field_entry(new, _("[ ] Comment"), track->comment);
	  } else {
	    song_chg_fields.comment = (char *) malloc(sizeof(char) * (strlen(track->comment)+1));
	    if(! song_chg_fields.comment) {
	      perror("malloc");
	      wuuush(1);
	    }
	    strcpy(song_chg_fields.comment, track->comment);
	    reb_field_entry(new, _("[*] Comment"), song_chg_fields.comment);
	  }
	  break;

	case 8:      /* Toggle sampler flag */
	  if(song_chg_fields.fn_auto) {
	    song_chg_fields.fn_auto = FALSE;
	    if(track->sampler) strcpy(mini_str, _("YES"));
	    else               strcpy(mini_str, _("NO"));
	    reb_field_entry(new, _("[ ] Sampler CD"), mini_str);
	  } else {
	    song_chg_fields.fn_auto = TRUE;
	    song_chg_fields.sampler = track->sampler;
	    if(song_chg_fields.sampler) strcpy(mini_str, _("YES"));
	    else                        strcpy(mini_str, _("NO"));
	    reb_field_entry(new, _("[*] Sampler CD"), mini_str);
	  }
	  break;
      }  /* END OF SWITCH - space pressed */
    } else {  /* ELSE - space not pressed */
      if((int) ((unsigned char) *(new->information)) == 125) break;
      switch((int) ((unsigned char) *(new->information))) {
	case 1:      /* Artist */
	  if(song_chg_fields.artist) 
	    pointer = input_line(16, song_chg_fields.artist, _("Input artistname"), TRUE);
	  else
	    pointer = input_line(16, track->artist, _("Input artistname"), TRUE);
	  
	  if(song_chg_fields.artist) free(song_chg_fields.artist);
	  song_chg_fields.artist = pointer;
	  if(pointer)
	    reb_field_entry(new, _("[*] Artist"), pointer);
	  else
	    reb_field_entry(new, _("[ ] Artist"), pointer);
	  break;
	  
	case 2:      /* Title */
	  if(song_chg_fields.title)
	    pointer = input_line(16, song_chg_fields.title, _("Input songtitle"), TRUE);
	  else
	    pointer = input_line(16, track->title, _("Input songtitle"), TRUE);
	  
	  if(song_chg_fields.title) free(song_chg_fields.title);
	  song_chg_fields.title = pointer;
	  if(pointer)
	    reb_field_entry(new, _("[*] Title"), pointer);
	  else
	    reb_field_entry(new, _("[ ] Title"), pointer);
	  break;
	  
	case 3:      /* Album */
	  if(song_chg_fields.album)
	    pointer = input_line(16, song_chg_fields.album, _("Input albumname"), TRUE);
	  else
	    pointer = input_line(16, track->album, _("Input albumname"), TRUE);
	  
	  if(song_chg_fields.album) free(song_chg_fields.album);
	  song_chg_fields.album = pointer;
	  if(pointer)
	    reb_field_entry(new, _("[*] Album"), pointer);
	  else
	    reb_field_entry(new, "[ ] Album", pointer);
	  break;
	  
	case 4:      /* Year */
	  if(song_chg_fields.year != -1)
	    sprintf(mini_str, "%4d", song_chg_fields.year);
	  else
	    sprintf(mini_str, "%4d", track->year);
	  
	  pointer = input_line(16, mini_str, _("Input year"), TRUE);
	  if(pointer && (strlen(pointer) <= 4)) {
	    song_chg_fields.year = atoi(pointer);
	    if((song_chg_fields.year < 0) || (song_chg_fields.year > 9999))
	      song_chg_fields.year = 1999;
	    sprintf(mini_str, "%4d", song_chg_fields.year);
	    reb_field_entry(new, _("[*] Year"), pointer);
	  }
	  
	  if(pointer) free(pointer);
	  break;
	  
	case 5:      /* Genre */
	  i = select_genre();
	  if(i != -1) {
	    song_chg_fields.genre = i;
	    reb_field_entry(new, _("[*] Genre"), (i != TOT_GENRES ? mp3_genre[i] :
						  def_unknown_gen));
	  }
	  use_old = FALSE;
	  break;
	  
	case 6:      /* onfly */
	  if(lay_act_side == 0) yesno_flag = select_yesno_box(_("onfly encoding?"));
	  else                  yesno_flag = select_yesno_box(_("delete after encoding?"));
	  if(yesno_flag) {
	    song_chg_fields.on_fly = TRUE;
	    strcpy(mini_str, _("YES"));
	  } else {
	    song_chg_fields.on_fly = FALSE;
	    strcpy(mini_str, _("NO"));
	  }
	  song_chg_fields.toc = 1;
	  if(lay_act_side == 0) reb_field_entry(new, _("[*] Onfly convert"), mini_str);
	  else                  reb_field_entry(new, _("[*] Delete after enc"), mini_str);
	  break;

	case 7:      /* Comment */
	  if(song_chg_fields.comment)
	    pointer = input_line2(16, song_chg_fields.comment, _("Input comment pattern"),
				  _("%1: Artist, %2: Title, %3: Album, %4: Genre, %5: Year, %6: Track"),
				  _("%7: Track (leading zeros), %8: MP3c-Version, %a: Encode-day"),
				  _("%b: Encode-month, %c: Encode-year (2 digits), %d: Encode-year (4 dig)"),
				  _("%e: Encode-weekday (3 letter), %f: Encode-month (3 letter)"),
				  _("%g: Encode-hour, %h: Encode-minute (not so useful ;-)"),
				  _("%i: Tracklen (minutes), %j: Tracklen (seconds), %9: CDDBID"), TRUE);
	  else
	    pointer = input_line2(16, track->comment, _("Input comment pattern"),
				  _("%1: Artist, %2: Title, %3: Album, %4: Genre, %5: Year, %6: Track"),
				  _("%7: Track (leading zeros), %8: MP3c-Version, %a: Encode-day"),
				  _("%b: Encode-month, %c: Encode-year (2 digits), %d: Encode-year (4 dig)"),
				  _("%e: Encode-weekday (3 letter), %f: Encode-month (3 letter)"),
				  _("%g: Encode-hour, %h: Encode-minute (not so useful ;-)"),
				  _("%i: Tracklen (minutes), %j: Tracklen (seconds), %9: CDDBID"), TRUE);
	  
	  if(song_chg_fields.comment) free(song_chg_fields.comment);
	  song_chg_fields.comment = pointer;
	  if(song_chg_fields.comment)
	    reb_field_entry(new, _("[*] Comment"), song_chg_fields.comment);
	  else
	    reb_field_entry(new, _("[ ] Comment"), track->comment);
	  break;

	case 8:      /* Sampler */
	  yesno_flag = select_yesno_box(_("sampler cd?"));
	  if(yesno_flag) {
	    song_chg_fields.sampler = TRUE;
	    strcpy(mini_str, _("YES"));
	  } else {
	    song_chg_fields.sampler = FALSE;
	    strcpy(mini_str, _("NO"));
	  }
	  song_chg_fields.fn_auto = TRUE;
	  reb_field_entry(new, _("[*] Sampler CD"), mini_str);
	  break;

	case 120:    /* reload old values */
	  if(song_chg_fields.artist) free(song_chg_fields.artist);
	  song_chg_fields.artist = NULL;
	  if(song_chg_fields.title)  free(song_chg_fields.title);
	  song_chg_fields.title  = NULL;
	  if(song_chg_fields.album)  free(song_chg_fields.album);
	  song_chg_fields.album  = NULL;
	  if(song_chg_fields.comment)free(song_chg_fields.comment);
	  song_chg_fields.comment= NULL;
	  song_chg_fields.year   = -1;
	  song_chg_fields.genre  = -1;
	  song_chg_fields.toc    = 0;
	  song_chg_fields.fn_auto= FALSE;
	  free_field_select(&anchor);
	  anchor     = NULL;
	  loaded_def = TRUE;
	  use_old    = FALSE;
	  break;
	  
	case 121:    /* set for act track */
	  if(song_chg_fields.artist) {
	    if(track->artist) free(track->artist);
	    track->artist = song_chg_fields.artist;
	    song_chg_fields.artist = NULL;
	  }
	  if(song_chg_fields.title) {
	    if(track->title) free(track->title);
	    track->title = song_chg_fields.title;
	    song_chg_fields.title = NULL;
	  }
	  if(song_chg_fields.album) {
	    if(track->album) free(track->album);
	    track->album = song_chg_fields.album;
	    song_chg_fields.album = NULL;
	  }
	  if(song_chg_fields.comment) {
	    if(track->comment) free(track->comment);
	    track->comment = song_chg_fields.comment;
	    song_chg_fields.comment = NULL;
	  }
	  if(song_chg_fields.year  != -1) track->year   = song_chg_fields.year;
	  if(song_chg_fields.genre != -1) track->genre  = song_chg_fields.genre;
	  if(song_chg_fields.toc   != 0)  track->on_fly = song_chg_fields.on_fly;
	  if(song_chg_fields.fn_auto)     track->sampler= song_chg_fields.sampler;
	  filenm_generate(track);
	  free_field_select(&anchor);
	  anchor     = NULL;
	  loaded_def = TRUE;
	  use_old    = FALSE;
	  break;
	  
	case 122:    /* set for marked tracks */
	  song_curr = lay_global_anchor[lay_act_side];
	  while(song_curr) {
	    if(song_curr->convert) {
	      if(song_chg_fields.artist) {
		if(song_curr->artist) free(song_curr->artist);
		song_curr->artist = (char *) malloc(sizeof(char) * (strlen(song_chg_fields.artist)+1));
		if(! song_curr->artist) {
		  perror("malloc");
		  wuuush(1);
		}
		strcpy(song_curr->artist, song_chg_fields.artist);
	      }
	      if(song_chg_fields.title) {
		if(song_curr->title) free(song_curr->title);
		song_curr->title = (char *) malloc(sizeof(char) * (strlen(song_chg_fields.title)+1));
		if(! song_curr->title) {
		  perror("malloc");
		  wuuush(1);
		}
		strcpy(song_curr->title, song_chg_fields.title);
	      }
	      if(song_chg_fields.album) {
		if(song_curr->album) free(song_curr->album);
		song_curr->album = (char *) malloc(sizeof(char) * (strlen(song_chg_fields.album)+1));
		if(! song_curr->album) {
		  perror("malloc");
		  wuuush(1);
		}
		strcpy(song_curr->album, song_chg_fields.album);
	      }
	      if(song_chg_fields.comment) {
		if(song_curr->comment) free(song_curr->comment);
		song_curr->comment = (char *) malloc(sizeof(char) * (strlen(song_chg_fields.comment)+1));
		if(! song_curr->comment) {
		  perror("malloc");
		  wuuush(1);
		}
		strcpy(song_curr->comment, song_chg_fields.comment);
	      }
	      if(song_chg_fields.year  != -1) song_curr->year   = song_chg_fields.year;
	      if(song_chg_fields.genre != -1) song_curr->genre  = song_chg_fields.genre;
	      if(song_chg_fields.toc   != 0)  song_curr->on_fly = song_chg_fields.on_fly;
	      if(song_chg_fields.fn_auto)     song_curr->sampler= song_chg_fields.sampler;
	      filenm_generate(song_curr);
	    }
	    song_curr = song_curr->next;
	  }
	  if(song_chg_fields.artist)  free(song_chg_fields.artist);
	  song_chg_fields.artist  = NULL;
	  if(song_chg_fields.title)   free(song_chg_fields.title);
	  song_chg_fields.title   = NULL;
	  if(song_chg_fields.album)   free(song_chg_fields.album);
	  song_chg_fields.album   = NULL;
	  if(song_chg_fields.comment) free(song_chg_fields.comment);
	  song_chg_fields.comment = NULL;
	  song_chg_fields.year    = -1;
	  song_chg_fields.genre   = -1;
	  song_chg_fields.toc     = 0;
	  song_chg_fields.fn_auto = FALSE;
	  free_field_select(&anchor);
	  anchor     = NULL;
	  loaded_def = TRUE;
	  use_old    = FALSE;
	  break;
	  
	case 123:    /* set for all tracks */
	  song_curr = lay_global_anchor[lay_act_side];
	  while(song_curr) {
	    if(song_chg_fields.artist) {
	      if(song_curr->artist) free(song_curr->artist);
	      song_curr->artist = (char *) malloc(sizeof(char) * (strlen(song_chg_fields.artist)+1));
	      if(! song_curr->artist) {
		perror("malloc");
		wuuush(1);
	      }
	      strcpy(song_curr->artist, song_chg_fields.artist);
	    }
	    if(song_chg_fields.title) {
	      if(song_curr->title) free(song_curr->title);
	      song_curr->title = (char *) malloc(sizeof(char) * (strlen(song_chg_fields.title)+1));
	      if(! song_curr->title) {
		perror("malloc");
		wuuush(1);
	      }
	      strcpy(song_curr->title, song_chg_fields.title);
	    }
	    if(song_chg_fields.album) {
	      if(song_curr->album) free(song_curr->album);
	      song_curr->album = (char *) malloc(sizeof(char) * (strlen(song_chg_fields.album)+1));
	      if(! song_curr->album) {
		perror("malloc");
		wuuush(1);
	      }
	      strcpy(song_curr->album, song_chg_fields.album);
	    }
	    if(song_chg_fields.comment) {
	      if(song_curr->comment) free(song_curr->comment);
	      song_curr->comment = (char *) malloc(sizeof(char) * (strlen(song_chg_fields.comment)+1));
	      if(! song_curr->comment) {
		perror("malloc");
		wuuush(1);
	      }
	      strcpy(song_curr->comment, song_chg_fields.comment);
	    }
	    if(song_chg_fields.year  != -1) song_curr->year   = song_chg_fields.year;
	    if(song_chg_fields.genre != -1) song_curr->genre  = song_chg_fields.genre;
	    if(song_chg_fields.toc   != 0)  song_curr->on_fly = song_chg_fields.on_fly;
	    if(song_chg_fields.fn_auto)     song_curr->sampler= song_chg_fields.sampler;
	    filenm_generate(song_curr);
	    song_curr = song_curr->next;
	  }
	  if(song_chg_fields.artist)  free(song_chg_fields.artist);
	  song_chg_fields.artist  = NULL;
	  if(song_chg_fields.title)   free(song_chg_fields.title);
	  song_chg_fields.title   = NULL;
	  if(song_chg_fields.album)   free(song_chg_fields.album);
	  song_chg_fields.album   = NULL;
	  if(song_chg_fields.comment) free(song_chg_fields.comment);
	  song_chg_fields.comment = NULL;
	  song_chg_fields.year    = -1;
	  song_chg_fields.genre   = -1;
	  song_chg_fields.toc     = 0;
	  song_chg_fields.fn_auto = FALSE;
	  free_field_select(&anchor);
	  anchor     = NULL;
	  loaded_def = TRUE;
	  use_old    = FALSE;
	  break;
      }  /* END OF SWITCH - enter pressed */
    }    /* END OF ELSE - enter pressed */
  }      /* END OF WHILE */
  
  free_field_select(&anchor);
  if(song_chg_fields.artist)  free(song_chg_fields.artist);
  if(song_chg_fields.title)   free(song_chg_fields.title);
  if(song_chg_fields.album)   free(song_chg_fields.album);
  if(song_chg_fields.comment) free(song_chg_fields.comment);
}

