/*
 * Decompiled with CFR 0.152.
 */
package com.idiominc.ws.opentopic.fo.i18n;

import com.idiominc.ws.opentopic.fo.i18n.Alphabet;
import com.idiominc.ws.opentopic.fo.i18n.Configuration;
import com.idiominc.ws.opentopic.fo.i18n.ProcessException;
import java.util.ArrayList;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MultilanguagePreprocessor {
    private static final String NAMESPACE_URL = "http://www.idiominc.com/opentopic/i18n";
    private static final String PREFIX = "opentopic-i18n";
    private static final String TEXT_FRAGMENT = "text-fragment";
    private static final String CHAR_SET = "char-set";
    private final Configuration configuration;
    private XMLUtils xmlUtils;

    public MultilanguagePreprocessor(Configuration theTheConfiguration) {
        if (null == theTheConfiguration) {
            throw new IllegalArgumentException("Configuration argument may not be null");
        }
        this.configuration = theTheConfiguration;
    }

    public void setXmlUtils(XMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
    }

    public Document process(Document theInput) throws ProcessException {
        Document doc = this.xmlUtils.newDocument();
        Element rootElement = theInput.getDocumentElement();
        Node node = this.processCurrNode(rootElement, doc)[0];
        doc.appendChild(node);
        doc.getDocumentElement().setAttribute("xmlns:opentopic-i18n", NAMESPACE_URL);
        return doc;
    }

    private Node[] processCurrNode(Node theNode, Document theTargetDocument) {
        if (theNode.getNodeType() == 3) {
            return this.processTextNode((Text)theNode, theTargetDocument);
        }
        Node result = theTargetDocument.importNode(theNode, false);
        NodeList childNodes = theNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node[] processedNodes;
            for (Node node : processedNodes = this.processCurrNode(childNodes.item(i), theTargetDocument)) {
                result.appendChild(node);
            }
        }
        return new Node[]{result};
    }

    private Node[] processTextNode(Text theTextNode, Document theTargetDocument) {
        ArrayList<Node> resultNodeList = new ArrayList<Node>();
        String nodeValue = theTextNode.getNodeValue();
        if (null != nodeValue) {
            int processedPosition = 0;
            Alphabet currentAlphabet = null;
            char[] chars = nodeValue.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char aChar = chars[i];
                Alphabet alphabetForChar = this.configuration.getAlphabetForChar(aChar);
                if (null != alphabetForChar && alphabetForChar.equals(currentAlphabet) || null == alphabetForChar && null == currentAlphabet) continue;
                String string = nodeValue.substring(processedPosition, i);
                Node child = this.createChildNode(currentAlphabet, theTargetDocument, string);
                resultNodeList.add(child);
                currentAlphabet = alphabetForChar;
                processedPosition = i;
            }
            Node childNode = this.createChildNode(currentAlphabet, theTargetDocument, nodeValue.substring(processedPosition));
            resultNodeList.add(childNode);
        }
        return resultNodeList.toArray(new Node[resultNodeList.size()]);
    }

    private Node createChildNode(Alphabet theCurrentAlphabet, Document theTargetDocument, String theString) {
        Node child;
        if (null != theCurrentAlphabet) {
            Element element = theTargetDocument.createElementNS(NAMESPACE_URL, TEXT_FRAGMENT);
            element.setPrefix(PREFIX);
            String charSet = theCurrentAlphabet.getName();
            element.setAttribute(CHAR_SET, charSet);
            Text textNode = theTargetDocument.createTextNode(theString);
            element.appendChild(textNode);
            child = element;
        } else {
            child = theTargetDocument.createTextNode(theString);
        }
        return child;
    }
}

