/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <cstdlib>
#include <cstdio>
#include "SDL.h"
#include "SDL_net.h"
#include <unistd.h>
#include <getopt.h>
//#include <readline/readline.h>
//#include <readline/history.h>
#include "game_server.h"
#include "globals.h"
#include "config.h"

using namespace std;

game_server *server;

void print_license()
{
  printf ("Kajaani kombat server %s %s\n",
	  VERSION, COPYRIGHT);
}

void print_usage()
{
  printf ("Usage: kajaani-kombat-server -a num [-p port] [-n num_castles] [-w num_wins]\n");
}

/*
void print_help()
{
  printf ("Server commands:\n");
  printf ("q\t-\tShutdown server\n");
  printf ("s\t-\tStart game\n");
}

void start_console()
{
  char *line;
  bool running = false;

  while (1)
	{
	  line = readline ("server:>");
	  if (strlen (line) > 0)
		add_history (line);
	  switch (line[0])
		{
 		case 'q':
		  printf ("Server shutting down .. waiting for player threads to disconnect\n");
		  printf ("Disconnect ok. shutdown .. cu later alligator\n");
		  exit(0);
		  break;
		case 's':
		  if ( !running ) {
		    running = true;
		    printf ("Game starting ...\n");
		    server->start_game();
		    running = false;
		  }
		  else {
		    printf( "Game already running...\n" );
		  }
		  break;
		default:
		  print_help();
		  break;
		}
	  free (line);
	  line = NULL;
	}
}
*/

int main (int argc, char **argv)
{
  int c, option_index;
  int port = atoi( config::DEFAULT_PORT );
  IPaddress ip;
  int num = 0;
  int castles = 7;
  int wins = 1;

  static struct option long_options[] =
	{
	  {"port", 1, 0, 0},
	};

  print_license();
  if (argc > 9)
	{
	  print_usage();
	  exit(0);
	}

  while (1)
	{
	  
	  c = getopt_long (argc, argv, "a:p:n:w:", long_options, &option_index);
	  
	  if (c == -1)
		break;

	  switch (c)
		{
		case 0:
		case 'a':
		  num = atoi(optarg);
		  if (num < 1)
			{
			  print_usage();
			  exit(0);
			}
		  break;
		case 1:
		case 'p':
		  port = atoi(optarg);
		  if (port < 1)
			{
			  print_usage();
			  exit(0);
			}
		  break;
		case 2:
		case 'n':
		  castles = atoi(optarg);
		  if (castles < 1)
		    {
		      print_usage();
		      exit(0);
		    }
		  break;
		case 3:
		case 'w':
		  wins = atoi(optarg);
		  if (wins < 1)
		    {
		      print_usage();
		      exit(0);
		    }
		  break;
		default:
		  print_usage();
		  exit(0);
		}
	}
  /* ok .. options parsed. Initialize sdl & sdl_net! */
  if (num == 0)
    {
      print_usage();
      exit(0);
    }

  if( SDL_Init(0) == -1)
	{
	  fprintf(stderr, "SDL init failed: %s\n",SDL_GetError());
	  exit(1);
	}

  atexit (SDL_Quit);

  if (SDLNet_Init() == -1)
	{
	  fprintf (stderr, "SDLNet init failed: %s\n", SDLNet_GetError());
	  exit(1);
	}

  atexit (SDLNet_Quit);

  /* initializing done .. try to lookup host & bind port */

  if (SDLNet_ResolveHost (&ip, NULL, port) == -1)
	{
	  fprintf (stderr, "Error resolving host: %s\n", SDLNet_GetError());
	  exit(1);
	}

  /* initialize server */
  while (true)
    {
      try {
	printf ("Trying to start server..\n");
	server = new game_server(ip, castles, wins);
	server->init_net();
      
	printf ("Server initialized on port %d\n", port);

	// if running interactively, start console
	/*	if (num == 0)
	  start_console();
	*/
	//	else 
	//  {
	    printf ("Waiting for %d players to join, will auto-start after it\n", num);
	    while (true) 
	      {
		if (server->no_players() == num)
		  {
		    server->start_game();
		    break;
		  }
		else
		  SDL_Delay(100);
		// probe for disconnected players.
		server->probe_disconnected_players();
	      }
	    //	  }
	delete server;
      }
      catch (string &s)
	{
	  fprintf (stderr, "Error starting server: %s .. delaying and trying again.\n", s.c_str());
	  SDL_Delay(1000);
	}
    }// while(true)

  return 0;
}
