/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __ROTOZOOM_H
#define __ROTOZOOM_H

#include "SDL.h"
#include "terrain.h"
#include "lookup.h"
#include "interpolation.h"

/**
 * Class for rotozooming.
 *
 * \author Tommi Tervonen <tommi@medusa.tutka.net>
 */
class rotozoom
{
 public:
   /**
    * Constructor.
    *
    * \param lut pointer to lookup table-object to be used by this rotozoomer.
    */
   rotozoom (const lookup *lut);
   
  /**
   * Performs the rotozooming & blitting.
   *
   * \param scale Scaling value (1.0 = original size).
   * \param angle Rotation angle (in normal degrees).
   * \param dest Surface to blit the result. Must be in 32bpp format.
   * \param src Surface to rotozoom & blit. Must be in 32bpp format.
   * \param center Pixel-coordinate of center of dest-surface where to blit.
   */
   void rotatescale_blit (float scale, int angle, SDL_Surface *dest, SDL_Surface *src, const coord & center) const;
  
 protected:
  const lookup * lut; // sin & cos lookup-table

};

#endif
