/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class CredentialsProviderUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private final URIish uri;
    private final CredentialsProvider provider;
    private String password;
    private String passphrase;

    public CredentialsProviderUserInfo(Session session, CredentialsProvider credentialsProvider) {
        this.uri = CredentialsProviderUserInfo.createURI(session);
        this.provider = credentialsProvider;
    }

    private static URIish createURI(Session session) {
        URIish uri = new URIish();
        uri = uri.setScheme("ssh");
        uri = uri.setUser(session.getUserName());
        uri = uri.setHost(session.getHost());
        uri = uri.setPort(session.getPort());
        return uri;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getPassphrase() {
        return this.passphrase;
    }

    @Override
    public boolean promptPassphrase(String msg) {
        CredentialItem.StringType v = this.newPrompt(msg);
        if (this.provider.get(this.uri, v)) {
            this.passphrase = v.getValue();
            return true;
        }
        this.passphrase = null;
        return false;
    }

    @Override
    public boolean promptPassword(String msg) {
        CredentialItem.Password p = new CredentialItem.Password(msg);
        if (this.provider.get(this.uri, p)) {
            this.password = new String(p.getValue());
            return true;
        }
        this.password = null;
        return false;
    }

    private CredentialItem.StringType newPrompt(String msg) {
        return new CredentialItem.StringType(msg, true);
    }

    @Override
    public boolean promptYesNo(String msg) {
        CredentialItem.YesNoType v = new CredentialItem.YesNoType(msg);
        return this.provider.get(this.uri, v) && v.getValue();
    }

    @Override
    public void showMessage(String msg) {
        this.provider.get(this.uri, new CredentialItem.InformationalMessage(msg));
    }

    @Override
    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        CredentialItem.StringType[] v = new CredentialItem.StringType[prompt.length];
        for (int i = 0; i < prompt.length; ++i) {
            v[i] = new CredentialItem.StringType(prompt[i], !echo[i]);
        }
        ArrayList<CredentialItem> items = new ArrayList<CredentialItem>();
        if (instruction != null && instruction.length() > 0) {
            items.add(new CredentialItem.InformationalMessage(instruction));
        }
        items.addAll(Arrays.asList(v));
        if (!this.provider.get(this.uri, items)) {
            return null;
        }
        String[] result = new String[v.length];
        for (int i = 0; i < v.length; ++i) {
            result[i] = v[i].getValue();
        }
        return result;
    }
}

