/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.versionmapping;

import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.internal.component.local.model.ProjectComponentSelectorInternal;
import org.gradle.util.Path;

public class DefaultVariantVersionMappingStrategy
implements VariantVersionMappingStrategyInternal {
    private final ConfigurationContainer configurations;
    private final ProjectDependencyPublicationResolver projectResolver;
    private boolean usePublishedVersions;
    private Configuration targetConfiguration;

    public DefaultVariantVersionMappingStrategy(ConfigurationContainer configurations, ProjectDependencyPublicationResolver projectResolver) {
        this.configurations = configurations;
        this.projectResolver = projectResolver;
    }

    @Override
    public void fromResolutionResult() {
        this.usePublishedVersions = true;
    }

    @Override
    public void fromResolutionOf(Configuration configuration) {
        this.usePublishedVersions = true;
        this.targetConfiguration = configuration;
    }

    @Override
    public void fromResolutionOf(String configurationName) {
        this.fromResolutionOf(this.configurations.getByName(configurationName));
    }

    @Override
    public ModuleVersionIdentifier maybeResolveVersion(String group, String module, Path identityPath) {
        if (!this.usePublishedVersions || this.targetConfiguration == null) {
            return null;
        }
        ResolutionResult resolutionResult = this.targetConfiguration.getIncoming().getResolutionResult();
        Set resolvedComponentResults = resolutionResult.getAllComponents();
        for (ResolvedComponentResult selected : resolvedComponentResults) {
            ModuleVersionIdentifier moduleVersion = selected.getModuleVersion();
            if (moduleVersion == null || !group.equals(moduleVersion.getGroup()) || !module.equals(moduleVersion.getName())) continue;
            return moduleVersion;
        }
        Set allDependencies = resolutionResult.getAllDependencies();
        for (DependencyResult dependencyResult : allDependencies) {
            ProjectComponentSelectorInternal pcs;
            ModuleComponentSelector requested;
            if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
            ComponentSelector rcs = dependencyResult.getRequested();
            ResolvedComponentResult selected = ((ResolvedDependencyResult)dependencyResult).getSelected();
            if (!(rcs instanceof ModuleComponentSelector ? (requested = (ModuleComponentSelector)rcs).getGroup().equals(group) && requested.getModule().equals(module) : rcs instanceof ProjectComponentSelector && (pcs = (ProjectComponentSelectorInternal)rcs).getIdentityPath().equals((Object)identityPath))) continue;
            return this.getModuleVersionId(selected);
        }
        return null;
    }

    @Nullable
    private ModuleVersionIdentifier getModuleVersionId(ResolvedComponentResult selected) {
        if (selected.getId() instanceof ProjectComponentIdentifier) {
            Path identityPath = ((ProjectComponentIdentifierInternal)selected.getId()).getIdentityPath();
            return (ModuleVersionIdentifier)this.projectResolver.resolve(ModuleVersionIdentifier.class, identityPath);
        }
        return selected.getModuleVersion();
    }

    public void setTargetConfiguration(Configuration target) {
        this.targetConfiguration = target;
    }
}

