/*
 * Decompiled with CFR 0.152.
 */
package scala.pickling.binary;

import scala.Array$;
import scala.Predef$;
import scala.math.package$;
import scala.pickling.binary.UnsafeMemory$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d!B\u0001\u0003\u0003\u0003I!\u0001\u0004\"j]\u0006\u0014\u0018pT;uaV$(BA\u0002\u0005\u0003\u0019\u0011\u0017N\\1ss*\u0011QAB\u0001\ta&\u001c7\u000e\\5oO*\tq!A\u0003tG\u0006d\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\r\u001b\u00051\u0011BA\u0007\u0007\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u00011\t!F\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0016\u0003Y\u00012aC\f\u001a\u0013\tAbAA\u0003BeJ\f\u0017\u0010\u0005\u0002\f5%\u00111D\u0002\u0002\u0005\u0005f$X\rC\u0003\u001e\u0001\u0019\u0005a$\u0001\bf]N,(/Z\"ba\u0006\u001c\u0017\u000e^=\u0015\u0005}\u0011\u0003CA\u0006!\u0013\t\tcA\u0001\u0003V]&$\b\"B\u0012\u001d\u0001\u0004!\u0013\u0001C2ba\u0006\u001c\u0017\u000e^=\u0011\u0005-)\u0013B\u0001\u0014\u0007\u0005\rIe\u000e\u001e\u0005\u0006Q\u00011\t!K\u0001\baV$()\u001f;f)\ty\"\u0006C\u0003,O\u0001\u0007\u0011$A\u0003wC2,X\rC\u0003.\u0001\u0019\u0005a&A\u0004qkR\u001c\u0005.\u0019:\u0015\u0005}y\u0003\"B\u0016-\u0001\u0004\u0001\u0004CA\u00062\u0013\t\u0011dA\u0001\u0003DQ\u0006\u0014\b\"\u0002\u001b\u0001\r\u0003)\u0014\u0001\u00039viNCwN\u001d;\u0015\u0005}1\u0004\"B\u00164\u0001\u00049\u0004CA\u00069\u0013\tIdAA\u0003TQ>\u0014H\u000fC\u0003<\u0001\u0019\u0005A(\u0001\u0004qkRLe\u000e\u001e\u000b\u0003?uBQa\u000b\u001eA\u0002\u0011BQa\u0010\u0001\u0007\u0002\u0001\u000bq\u0001];u\u0019>tw\r\u0006\u0002 \u0003\")1F\u0010a\u0001\u0005B\u00111bQ\u0005\u0003\t\u001a\u0011A\u0001T8oO\")a\t\u0001D\u0001\u000f\u0006A\u0001/\u001e;GY>\fG\u000f\u0006\u0002 \u0011\")1&\u0012a\u0001\u0013B\u00111BS\u0005\u0003\u0017\u001a\u0011QA\u00127pCRDQ!\u0014\u0001\u0007\u00029\u000b\u0011\u0002];u\t>,(\r\\3\u0015\u0005}y\u0005\"B\u0016M\u0001\u0004\u0001\u0006CA\u0006R\u0013\t\u0011fA\u0001\u0004E_V\u0014G.\u001a\u0005\u0006)\u00021\t!V\u0001\taV$()\u001f;fgR\u0019qD\u0016-\t\u000b]\u001b\u0006\u0019\u0001\f\u0002\u000b\tLH/Z:\t\u000be\u001b\u0006\u0019\u0001\u0013\u0002\u00071,g\u000eC\u0003\\\u0001\u0011\u0005A,\u0001\u0006qkR\u0014un\u001c7fC:$\"aH/\t\u000b-R\u0006\u0019\u00010\u0011\u0005-y\u0016B\u00011\u0007\u0005\u001d\u0011un\u001c7fC:DQA\u0019\u0001\u0005\u0002\r\f\u0011\u0002];u'R\u0014\u0018N\\4\u0015\u0005}!\u0007\"B\u0016b\u0001\u0004)\u0007C\u00014j\u001d\tYq-\u0003\u0002i\r\u00051\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tAg\u0001C\u0004n\u0001\t\u0007I\u0011\u00038\u0002\u0013\rDWO\\6TSj,W#\u0001\u0013\t\rA\u0004\u0001\u0015!\u0003%\u0003)\u0019\u0007.\u001e8l'&TX\r\t\u0005\be\u0002\u0011\r\u0011\"\u0005\u0016\u0003\u0015\u0019\u0007.\u001e8l\u0011\u0019!\b\u0001)A\u0005-\u000511\r[;oW\u0002BQA\u001e\u0001\u0005\u0012]\fq\u0002];u\u0003J\u0014\u0018-\u001f\"z\u0007\",hn[\u000b\u0003qz$baH=\u0002\u0010\u0005M\u0001\"\u0002>v\u0001\u0004Y\u0018aA1seB\u00191b\u0006?\u0011\u0005utH\u0002\u0001\u0003\u0007\u007fV\u0014\r!!\u0001\u0003\u0003Q\u000bB!a\u0001\u0002\nA\u00191\"!\u0002\n\u0007\u0005\u001daAA\u0004O_RD\u0017N\\4\u0011\u0007-\tY!C\u0002\u0002\u000e\u0019\u0011a!\u00118z-\u0006d\u0007BBA\tk\u0002\u0007!)\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0007\u0003+)\b\u0019\u0001\u0013\u0002\u000f\u0015dGoU5{K\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011\u0001\u00049vi\nKH/Z!se\u0006LHcA\u0010\u0002\u001e!11&a\u0006A\u0002YAq!!\t\u0001\t\u0003\t\u0019#A\bqkR\u0014un\u001c7fC:\f%O]1z)\ry\u0012Q\u0005\u0005\bW\u0005}\u0001\u0019AA\u0014!\rYqC\u0018\u0005\b\u0003W\u0001A\u0011AA\u0017\u00031\u0001X\u000f^\"iCJ\f%O]1z)\ry\u0012q\u0006\u0005\bW\u0005%\u0002\u0019AA\u0019!\rYq\u0003\r\u0005\b\u0003k\u0001A\u0011AA\u001c\u00035\u0001X\u000f^*i_J$\u0018I\u001d:bsR\u0019q$!\u000f\t\u000f-\n\u0019\u00041\u0001\u0002<A\u00191bF\u001c\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B\u0005Y\u0001/\u001e;J]R\f%O]1z)\ry\u00121\t\u0005\bW\u0005u\u0002\u0019AA#!\rYq\u0003\n\u0005\b\u0003\u0013\u0002A\u0011AA&\u00035\u0001X\u000f\u001e$m_\u0006$\u0018I\u001d:bsR\u0019q$!\u0014\t\u000f-\n9\u00051\u0001\u0002PA\u00191bF%\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005a\u0001/\u001e;M_:<\u0017I\u001d:bsR\u0019q$a\u0016\t\u000f-\n\t\u00061\u0001\u0002ZA\u00191b\u0006\"\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`\u0005q\u0001/\u001e;E_V\u0014G.Z!se\u0006LHcA\u0010\u0002b!91&a\u0017A\u0002\u0005\r\u0004cA\u0006\u0018!\u0002")
public abstract class BinaryOutput {
    private final int chunkSize;
    private final byte[] chunk = (byte[])Array$.MODULE$.ofDim(this.chunkSize(), ClassTag$.MODULE$.Byte());

    public abstract byte[] result();

    public abstract void ensureCapacity(int var1);

    public abstract void putByte(byte var1);

    public abstract void putChar(char var1);

    public abstract void putShort(short var1);

    public abstract void putInt(int var1);

    public abstract void putLong(long var1);

    public abstract void putFloat(float var1);

    public abstract void putDouble(double var1);

    public abstract void putBytes(byte[] var1, int var2);

    public void putBoolean(boolean value) {
        if (value) {
            this.putByte((byte)1);
        } else {
            this.putByte((byte)0);
        }
    }

    public void putString(String value) {
        byte[] bytes = value.getBytes("UTF-8");
        this.putByteArray(bytes);
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    public byte[] chunk() {
        return this.chunk;
    }

    public <T> void putArrayByChunk(Object arr, long offset, int eltSize) {
        int nbrElt = ScalaRunTime$.MODULE$.array_length(arr);
        this.putInt(nbrElt);
        long srcOffset = offset;
        int toCopy = nbrElt * eltSize;
        while (toCopy > 0) {
            int byteLen = package$.MODULE$.min(this.chunkSize(), toCopy);
            UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset, this.chunk(), UnsafeMemory$.MODULE$.byteArrayOffset(), byteLen);
            toCopy -= byteLen;
            srcOffset += (long)byteLen;
            this.putBytes(this.chunk(), byteLen);
        }
    }

    public void putByteArray(byte[] value) {
        int size = Predef$.MODULE$.byteArrayOps(value).size();
        this.putInt(size);
        this.putBytes(value, size);
    }

    public void putBooleanArray(boolean[] value) {
        this.putArrayByChunk(value, UnsafeMemory$.MODULE$.booleanArrayOffset(), 1);
    }

    public void putCharArray(char[] value) {
        this.putArrayByChunk(value, UnsafeMemory$.MODULE$.charArrayOffset(), 2);
    }

    public void putShortArray(short[] value) {
        this.putArrayByChunk(value, UnsafeMemory$.MODULE$.shortArrayOffset(), 2);
    }

    public void putIntArray(int[] value) {
        this.putArrayByChunk(value, UnsafeMemory$.MODULE$.intArrayOffset(), 4);
    }

    public void putFloatArray(float[] value) {
        this.putArrayByChunk(value, UnsafeMemory$.MODULE$.floatArrayOffset(), 4);
    }

    public void putLongArray(long[] value) {
        this.putArrayByChunk(value, UnsafeMemory$.MODULE$.longArrayOffset(), 8);
    }

    public void putDoubleArray(double[] value) {
        this.putArrayByChunk(value, UnsafeMemory$.MODULE$.doubleArrayOffset(), 8);
    }

    public BinaryOutput() {
        this.chunkSize = 1024;
    }
}

