/* University dataset from
Schulte, Oliver, and Hassan Khosravi. "Learning graphical models for relational data via lattice search." Machine Learning 88.3 (2012): 331-368.

Downloaded from 
http://www.cs.sfu.ca/~oschulte/jbn/dataset.html
*/

/** <examples>
?- induce([f1,f2,f3,f4],P),test(P,[f5],LL,AUCROC,ROC,AUCPR,PR). % learn the structure and the parameters and test the result
*/

:- use_module(library(slipcover)).

:- if(current_predicate(use_rendering/1)).
:- use_rendering(c3).
:- use_rendering(lpad).
:- endif.

:-sc.

:- set_sc(verbosity,1).
:- set_sc(depth_bound,false).
:- set_sc(neg_ex,given).

bg([]).

in([]).

fold(f1,[f1]).
fold(f2,[f2]).
fold(f3,[f3]).
fold(f4,[f4]).
fold(f5,[f5]).


output(rating/2).

input(capability/3).

input(salary/3).

input(diff/2).

input(popularity/2).

input(rating/2).

input(teachingability/2).

input(grade/3).

input(sat/3).

input(intelligence/2).

input(ranking/2).

input(b_registration/2).

input(b_ra/2).

determination(rating/2,rating/2).

determination(rating/2,capability/3).

determination(rating/2,salary/3).

determination(rating/2,diff/2).

determination(rating/2,popularity/2).

determination(rating/2,rating/2).

determination(rating/2,teachingability/2).

determination(rating/2,grade/3).

determination(rating/2,sat/3).

determination(rating/2,intelligence/2).

determination(rating/2,ranking/2).

determination(rating/2,b_registration/2).

determination(rating/2,b_ra/2).


modeb(*,b_registration(+course,-st)).
modeb(*,b_registration(-course,+st)).

modeb(*,b_ra(-pr,+st)).
modeb(*,b_ra(+pr,-st)).


modeh(*,rating(+course,rating_1)).
modeh(*,rating(+course,rating_2)).

modeb(*,diff(+course,-diff)).
modeb(*,diff(+course,-#diff)).

modeb(*,grade(+st,+course,-grade)).
modeb(*,grade(+st,+course,-#grade)).
modeb(*,sat(+st,+course,-sat)).
modeb(*,sat(+st,+course,-#sat)).

modeb(*,intelligence(+st,-int)).
modeb(*,intelligence(+st,-#int)).

modeb(*,ranking(+st,-rank)).
modeb(*,ranking(+st,-#rank)).

modeb(*,teachingability(+pr,-tab)).
modeb(*,teachingability(+pr,-#tab)).

modeb(*,popularity(+pr,-pop)).
modeb(*,popularity(+pr,-#pop)).

banned([rating(A,B)],[rating(A,B)]).
begin(model(f1)).
capability(prof_id_5,student_id_5,capability_1).
capability(prof_id_6,student_id_5,capability_2).
capability(prof_id_7,student_id_7,capability_4).
capability(prof_id_7,student_id_8,capability_4).
capability(prof_id_6,student_id_8,capability_4).
capability(prof_id_6,student_id_9,capability_4).
capability(prof_id_9,student_id_10,capability_3).
capability(prof_id_7,student_id_11,capability_1).
capability(prof_id_8,student_id_12,capability_1).
capability(prof_id_8,student_id_13,capability_2).
capability(prof_id_5,student_id_14,capability_2).
capability(prof_id_6,student_id_15,capability_1).
capability(prof_id_6,student_id_16,capability_2).
capability(prof_id_4,student_id_17,capability_3).
capability(prof_id_5,student_id_18,capability_3).
capability(prof_id_7,student_id_19,capability_5).
capability(prof_id_7,student_id_20,capability_1).
capability(prof_id_8,student_id_21,capability_3).
capability(prof_id_7,student_id_22,capability_3).
capability(prof_id_6,student_id_23,capability_5).
capability(prof_id_6,student_id_24,capability_5).
capability(prof_id_6,student_id_25,capability_5).
capability(prof_id_5,student_id_26,capability_4).
capability(prof_id_5,student_id_27,capability_3).
capability(prof_id_5,student_id_28,capability_3).
salary(prof_id_5,student_id_5,salary_low).
salary(prof_id_6,student_id_5,salary_low).
salary(prof_id_7,student_id_7,salary_high).
salary(prof_id_7,student_id_8,salary_high).
salary(prof_id_6,student_id_8,salary_high).
salary(prof_id_6,student_id_9,salary_high).
salary(prof_id_9,student_id_10,salary_high).
salary(prof_id_7,student_id_11,salary_med).
salary(prof_id_8,student_id_12,salary_med).
salary(prof_id_8,student_id_13,salary_med).
salary(prof_id_5,student_id_14,salary_low).
salary(prof_id_6,student_id_15,salary_med).
salary(prof_id_6,student_id_16,salary_med).
salary(prof_id_4,student_id_17,salary_med).
salary(prof_id_5,student_id_18,salary_high).
salary(prof_id_7,student_id_19,salary_high).
salary(prof_id_7,student_id_20,salary_low).
salary(prof_id_8,student_id_21,salary_low).
salary(prof_id_7,student_id_22,salary_med).
salary(prof_id_6,student_id_23,salary_high).
salary(prof_id_6,student_id_24,salary_high).
salary(prof_id_6,student_id_25,salary_high).
salary(prof_id_5,student_id_26,salary_high).
salary(prof_id_5,student_id_27,salary_med).
salary(prof_id_5,student_id_28,salary_med).
diff(course_id_4,diff_1).
diff(course_id_5,diff_2).
diff(course_id_6,diff_1).
diff(course_id_7,diff_2).
diff(course_id_8,diff_1).
diff(course_id_9,diff_2).
diff(course_id_10,diff_1).
diff(course_id_11,diff_2).
diff(course_id_12,diff_1).
diff(course_id_13,diff_2).
popularity(prof_id_4,popularity_2).
popularity(prof_id_5,popularity_2).
popularity(prof_id_6,popularity_2).
popularity(prof_id_7,popularity_2).
popularity(prof_id_8,popularity_1).
popularity(prof_id_9,popularity_1).
teachingability(prof_id_4,teachingability_3).
teachingability(prof_id_5,teachingability_3).
teachingability(prof_id_6,teachingability_3).
teachingability(prof_id_7,teachingability_2).
teachingability(prof_id_8,teachingability_2).
teachingability(prof_id_9,teachingability_2).
grade(course_id_4,student_id_4,grade_1).
grade(course_id_4,student_id_6,grade_1).
grade(course_id_4,student_id_7,grade_1).
grade(course_id_4,student_id_12,grade_2).
grade(course_id_4,student_id_18,grade_2).
grade(course_id_4,student_id_29,grade_3).
grade(course_id_4,student_id_38,grade_4).
grade(course_id_4,student_id_40,grade_1).
grade(course_id_5,student_id_4,grade_1).
grade(course_id_5,student_id_5,grade_2).
grade(course_id_5,student_id_6,grade_2).
grade(course_id_5,student_id_15,grade_2).
grade(course_id_5,student_id_18,grade_3).
grade(course_id_5,student_id_25,grade_3).
grade(course_id_5,student_id_29,grade_4).
grade(course_id_5,student_id_34,grade_3).
grade(course_id_5,student_id_38,grade_4).
grade(course_id_5,student_id_39,grade_1).
grade(course_id_5,student_id_41,grade_1).
grade(course_id_6,student_id_4,grade_1).
grade(course_id_6,student_id_6,grade_1).
grade(course_id_6,student_id_7,grade_1).
grade(course_id_6,student_id_9,grade_1).
grade(course_id_6,student_id_13,grade_1).
grade(course_id_6,student_id_19,grade_2).
grade(course_id_6,student_id_25,grade_3).
grade(course_id_6,student_id_30,grade_4).
grade(course_id_6,student_id_41,grade_1).
grade(course_id_7,student_id_4,grade_2).
grade(course_id_7,student_id_5,grade_2).
grade(course_id_7,student_id_9,grade_2).
grade(course_id_7,student_id_15,grade_2).
grade(course_id_7,student_id_20,grade_2).
grade(course_id_7,student_id_30,grade_4).
grade(course_id_7,student_id_40,grade_1).
grade(course_id_8,student_id_5,grade_1).
grade(course_id_8,student_id_6,grade_1).
grade(course_id_8,student_id_9,grade_1).
grade(course_id_8,student_id_10,grade_1).
grade(course_id_8,student_id_11,grade_2).
grade(course_id_8,student_id_14,grade_1).
grade(course_id_8,student_id_20,grade_3).
grade(course_id_8,student_id_22,grade_3).
grade(course_id_8,student_id_30,grade_4).
grade(course_id_8,student_id_41,grade_1).
grade(course_id_9,student_id_6,grade_1).
grade(course_id_9,student_id_10,grade_2).
grade(course_id_9,student_id_12,grade_2).
grade(course_id_9,student_id_15,grade_2).
grade(course_id_9,student_id_23,grade_2).
grade(course_id_9,student_id_31,grade_3).
grade(course_id_9,student_id_33,grade_3).
grade(course_id_9,student_id_35,grade_3).
grade(course_id_10,student_id_6,grade_1).
grade(course_id_10,student_id_11,grade_1).
grade(course_id_10,student_id_14,grade_1).
grade(course_id_10,student_id_17,grade_3).
grade(course_id_10,student_id_18,grade_1).
grade(course_id_10,student_id_23,grade_2).
grade(course_id_10,student_id_32,grade_3).
grade(course_id_10,student_id_36,grade_4).
grade(course_id_11,student_id_7,grade_2).
grade(course_id_11,student_id_8,grade_1).
grade(course_id_11,student_id_14,grade_2).
grade(course_id_11,student_id_16,grade_2).
grade(course_id_11,student_id_17,grade_2).
grade(course_id_11,student_id_23,grade_3).
grade(course_id_11,student_id_28,grade_4).
grade(course_id_11,student_id_32,grade_4).
grade(course_id_11,student_id_37,grade_3).
grade(course_id_11,student_id_41,grade_2).
grade(course_id_12,student_id_8,grade_1).
grade(course_id_12,student_id_10,grade_1).
grade(course_id_12,student_id_11,grade_1).
grade(course_id_12,student_id_17,grade_2).
grade(course_id_12,student_id_21,grade_1).
grade(course_id_12,student_id_22,grade_2).
grade(course_id_12,student_id_23,grade_1).
grade(course_id_12,student_id_24,grade_1).
grade(course_id_12,student_id_26,grade_2).
grade(course_id_12,student_id_28,grade_3).
grade(course_id_12,student_id_33,grade_4).
grade(course_id_12,student_id_37,grade_4).
grade(course_id_13,student_id_7,grade_2).
grade(course_id_13,student_id_14,grade_2).
grade(course_id_13,student_id_16,grade_3).
grade(course_id_13,student_id_21,grade_2).
grade(course_id_13,student_id_26,grade_3).
grade(course_id_13,student_id_27,grade_3).
grade(course_id_13,student_id_33,grade_4).
grade(course_id_13,student_id_37,grade_4).
grade(course_id_13,student_id_41,grade_2).
sat(course_id_4,student_id_4,sat_1).
sat(course_id_4,student_id_6,sat_1).
sat(course_id_4,student_id_7,sat_1).
sat(course_id_4,student_id_12,sat_2).
sat(course_id_4,student_id_18,sat_2).
sat(course_id_4,student_id_29,sat_2).
sat(course_id_4,student_id_38,sat_3).
sat(course_id_4,student_id_40,sat_1).
sat(course_id_5,student_id_4,sat_1).
sat(course_id_5,student_id_5,sat_2).
sat(course_id_5,student_id_6,sat_2).
sat(course_id_5,student_id_15,sat_1).
sat(course_id_5,student_id_18,sat_2).
sat(course_id_5,student_id_25,sat_2).
sat(course_id_5,student_id_29,sat_3).
sat(course_id_5,student_id_34,sat_2).
sat(course_id_5,student_id_38,sat_3).
sat(course_id_5,student_id_39,sat_1).
sat(course_id_5,student_id_41,sat_1).
sat(course_id_6,student_id_4,sat_1).
sat(course_id_6,student_id_6,sat_1).
sat(course_id_6,student_id_7,sat_1).
sat(course_id_6,student_id_9,sat_1).
sat(course_id_6,student_id_13,sat_1).
sat(course_id_6,student_id_19,sat_3).
sat(course_id_6,student_id_25,sat_3).
sat(course_id_6,student_id_30,sat_3).
sat(course_id_6,student_id_41,sat_1).
sat(course_id_7,student_id_4,sat_1).
sat(course_id_7,student_id_5,sat_2).
sat(course_id_7,student_id_9,sat_2).
sat(course_id_7,student_id_15,sat_1).
sat(course_id_7,student_id_20,sat_2).
sat(course_id_7,student_id_30,sat_3).
sat(course_id_7,student_id_40,sat_1).
sat(course_id_8,student_id_5,sat_1).
sat(course_id_8,student_id_6,sat_1).
sat(course_id_8,student_id_9,sat_2).
sat(course_id_8,student_id_10,sat_1).
sat(course_id_8,student_id_11,sat_2).
sat(course_id_8,student_id_14,sat_1).
sat(course_id_8,student_id_20,sat_3).
sat(course_id_8,student_id_22,sat_2).
sat(course_id_8,student_id_30,sat_3).
sat(course_id_8,student_id_41,sat_1).
sat(course_id_9,student_id_6,sat_1).
sat(course_id_9,student_id_10,sat_2).
sat(course_id_9,student_id_12,sat_1).
sat(course_id_9,student_id_15,sat_1).
sat(course_id_9,student_id_23,sat_2).
sat(course_id_9,student_id_31,sat_2).
sat(course_id_9,student_id_33,sat_2).
sat(course_id_9,student_id_35,sat_2).
sat(course_id_10,student_id_6,sat_1).
sat(course_id_10,student_id_11,sat_2).
sat(course_id_10,student_id_14,sat_1).
sat(course_id_10,student_id_17,sat_3).
sat(course_id_10,student_id_18,sat_1).
sat(course_id_10,student_id_23,sat_1).
sat(course_id_10,student_id_32,sat_2).
sat(course_id_10,student_id_36,sat_3).
sat(course_id_11,student_id_7,sat_1).
sat(course_id_11,student_id_8,sat_1).
sat(course_id_11,student_id_14,sat_1).
sat(course_id_11,student_id_16,sat_1).
sat(course_id_11,student_id_17,sat_1).
sat(course_id_11,student_id_23,sat_3).
sat(course_id_11,student_id_28,sat_3).
sat(course_id_11,student_id_32,sat_3).
sat(course_id_11,student_id_37,sat_3).
sat(course_id_11,student_id_41,sat_2).
sat(course_id_12,student_id_8,sat_1).
sat(course_id_12,student_id_10,sat_1).
sat(course_id_12,student_id_11,sat_2).
sat(course_id_12,student_id_17,sat_2).
sat(course_id_12,student_id_21,sat_1).
sat(course_id_12,student_id_22,sat_1).
sat(course_id_12,student_id_23,sat_1).
sat(course_id_12,student_id_24,sat_1).
sat(course_id_12,student_id_26,sat_3).
sat(course_id_12,student_id_28,sat_2).
sat(course_id_12,student_id_33,sat_3).
sat(course_id_12,student_id_37,sat_3).
sat(course_id_13,student_id_7,sat_1).
sat(course_id_13,student_id_14,sat_2).
sat(course_id_13,student_id_16,sat_2).
sat(course_id_13,student_id_21,sat_2).
sat(course_id_13,student_id_26,sat_3).
sat(course_id_13,student_id_27,sat_2).
sat(course_id_13,student_id_33,sat_3).
sat(course_id_13,student_id_37,sat_3).
sat(course_id_13,student_id_41,sat_2).
intelligence(student_id_4,intelligence_3).
intelligence(student_id_5,intelligence_3).
intelligence(student_id_6,intelligence_3).
intelligence(student_id_7,intelligence_3).
intelligence(student_id_8,intelligence_3).
intelligence(student_id_9,intelligence_3).
intelligence(student_id_10,intelligence_3).
intelligence(student_id_11,intelligence_3).
intelligence(student_id_12,intelligence_2).
intelligence(student_id_13,intelligence_2).
intelligence(student_id_14,intelligence_2).
intelligence(student_id_15,intelligence_2).
intelligence(student_id_16,intelligence_2).
intelligence(student_id_17,intelligence_2).
intelligence(student_id_18,intelligence_2).
intelligence(student_id_19,intelligence_2).
intelligence(student_id_20,intelligence_2).
intelligence(student_id_21,intelligence_2).
intelligence(student_id_22,intelligence_2).
intelligence(student_id_23,intelligence_2).
intelligence(student_id_24,intelligence_2).
intelligence(student_id_25,intelligence_1).
intelligence(student_id_26,intelligence_1).
intelligence(student_id_27,intelligence_1).
intelligence(student_id_28,intelligence_1).
intelligence(student_id_29,intelligence_1).
intelligence(student_id_30,intelligence_1).
intelligence(student_id_31,intelligence_1).
intelligence(student_id_32,intelligence_1).
intelligence(student_id_33,intelligence_1).
intelligence(student_id_34,intelligence_1).
intelligence(student_id_35,intelligence_1).
intelligence(student_id_36,intelligence_1).
intelligence(student_id_37,intelligence_1).
intelligence(student_id_38,intelligence_1).
intelligence(student_id_39,intelligence_3).
intelligence(student_id_40,intelligence_3).
intelligence(student_id_41,intelligence_3).
ranking(student_id_4,ranking_1).
ranking(student_id_5,ranking_1).
ranking(student_id_6,ranking_2).
ranking(student_id_7,ranking_1).
ranking(student_id_8,ranking_1).
ranking(student_id_9,ranking_2).
ranking(student_id_10,ranking_1).
ranking(student_id_11,ranking_2).
ranking(student_id_12,ranking_2).
ranking(student_id_13,ranking_2).
ranking(student_id_14,ranking_2).
ranking(student_id_15,ranking_3).
ranking(student_id_16,ranking_3).
ranking(student_id_17,ranking_3).
ranking(student_id_18,ranking_3).
ranking(student_id_19,ranking_3).
ranking(student_id_20,ranking_3).
ranking(student_id_21,ranking_2).
ranking(student_id_22,ranking_4).
ranking(student_id_23,ranking_3).
ranking(student_id_24,ranking_2).
ranking(student_id_25,ranking_4).
ranking(student_id_26,ranking_4).
ranking(student_id_27,ranking_4).
ranking(student_id_28,ranking_4).
ranking(student_id_29,ranking_5).
ranking(student_id_30,ranking_5).
ranking(student_id_31,ranking_5).
ranking(student_id_32,ranking_5).
ranking(student_id_33,ranking_5).
ranking(student_id_34,ranking_4).
ranking(student_id_35,ranking_4).
ranking(student_id_36,ranking_5).
ranking(student_id_37,ranking_5).
ranking(student_id_38,ranking_5).
ranking(student_id_39,ranking_1).
ranking(student_id_40,ranking_1).
ranking(student_id_41,ranking_1).
b_registration(course_id_4,student_id_4).
b_registration(course_id_4,student_id_6).
b_registration(course_id_4,student_id_7).
b_registration(course_id_4,student_id_12).
b_registration(course_id_4,student_id_18).
b_registration(course_id_4,student_id_29).
b_registration(course_id_4,student_id_38).
b_registration(course_id_4,student_id_40).
b_registration(course_id_5,student_id_4).
b_registration(course_id_5,student_id_5).
b_registration(course_id_5,student_id_6).
b_registration(course_id_5,student_id_15).
b_registration(course_id_5,student_id_18).
b_registration(course_id_5,student_id_25).
b_registration(course_id_5,student_id_29).
b_registration(course_id_5,student_id_34).
b_registration(course_id_5,student_id_38).
b_registration(course_id_5,student_id_39).
b_registration(course_id_5,student_id_41).
b_registration(course_id_6,student_id_4).
b_registration(course_id_6,student_id_6).
b_registration(course_id_6,student_id_7).
b_registration(course_id_6,student_id_9).
b_registration(course_id_6,student_id_13).
b_registration(course_id_6,student_id_19).
b_registration(course_id_6,student_id_25).
b_registration(course_id_6,student_id_30).
b_registration(course_id_6,student_id_41).
b_registration(course_id_7,student_id_4).
b_registration(course_id_7,student_id_5).
b_registration(course_id_7,student_id_9).
b_registration(course_id_7,student_id_15).
b_registration(course_id_7,student_id_20).
b_registration(course_id_7,student_id_30).
b_registration(course_id_7,student_id_40).
b_registration(course_id_8,student_id_5).
b_registration(course_id_8,student_id_6).
b_registration(course_id_8,student_id_9).
b_registration(course_id_8,student_id_10).
b_registration(course_id_8,student_id_11).
b_registration(course_id_8,student_id_14).
b_registration(course_id_8,student_id_20).
b_registration(course_id_8,student_id_22).
b_registration(course_id_8,student_id_30).
b_registration(course_id_8,student_id_41).
b_registration(course_id_9,student_id_6).
b_registration(course_id_9,student_id_10).
b_registration(course_id_9,student_id_12).
b_registration(course_id_9,student_id_15).
b_registration(course_id_9,student_id_23).
b_registration(course_id_9,student_id_31).
b_registration(course_id_9,student_id_33).
b_registration(course_id_9,student_id_35).
b_registration(course_id_10,student_id_6).
b_registration(course_id_10,student_id_11).
b_registration(course_id_10,student_id_14).
b_registration(course_id_10,student_id_17).
b_registration(course_id_10,student_id_18).
b_registration(course_id_10,student_id_23).
b_registration(course_id_10,student_id_32).
b_registration(course_id_10,student_id_36).
b_registration(course_id_11,student_id_7).
b_registration(course_id_11,student_id_8).
b_registration(course_id_11,student_id_14).
b_registration(course_id_11,student_id_16).
b_registration(course_id_11,student_id_17).
b_registration(course_id_11,student_id_23).
b_registration(course_id_11,student_id_28).
b_registration(course_id_11,student_id_32).
b_registration(course_id_11,student_id_37).
b_registration(course_id_11,student_id_41).
b_registration(course_id_12,student_id_8).
b_registration(course_id_12,student_id_10).
b_registration(course_id_12,student_id_11).
b_registration(course_id_12,student_id_17).
b_registration(course_id_12,student_id_21).
b_registration(course_id_12,student_id_22).
b_registration(course_id_12,student_id_23).
b_registration(course_id_12,student_id_24).
b_registration(course_id_12,student_id_26).
b_registration(course_id_12,student_id_28).
b_registration(course_id_12,student_id_33).
b_registration(course_id_12,student_id_37).
b_registration(course_id_13,student_id_7).
b_registration(course_id_13,student_id_14).
b_registration(course_id_13,student_id_16).
b_registration(course_id_13,student_id_21).
b_registration(course_id_13,student_id_26).
b_registration(course_id_13,student_id_27).
b_registration(course_id_13,student_id_33).
b_registration(course_id_13,student_id_37).
b_registration(course_id_13,student_id_41).
b_ra(prof_id_5,student_id_5).
b_ra(prof_id_6,student_id_5).
b_ra(prof_id_7,student_id_7).
b_ra(prof_id_7,student_id_8).
b_ra(prof_id_6,student_id_8).
b_ra(prof_id_6,student_id_9).
b_ra(prof_id_9,student_id_10).
b_ra(prof_id_7,student_id_11).
b_ra(prof_id_8,student_id_12).
b_ra(prof_id_8,student_id_13).
b_ra(prof_id_5,student_id_14).
b_ra(prof_id_6,student_id_15).
b_ra(prof_id_6,student_id_16).
b_ra(prof_id_4,student_id_17).
b_ra(prof_id_5,student_id_18).
b_ra(prof_id_7,student_id_19).
b_ra(prof_id_7,student_id_20).
b_ra(prof_id_8,student_id_21).
b_ra(prof_id_7,student_id_22).
b_ra(prof_id_6,student_id_23).
b_ra(prof_id_6,student_id_24).
b_ra(prof_id_6,student_id_25).
b_ra(prof_id_5,student_id_26).
b_ra(prof_id_5,student_id_27).
b_ra(prof_id_5,student_id_28).
rating(course_id_6,rating_2).
rating(course_id_9,rating_2).
neg(rating(course_id_6,rating_1)).
neg(rating(course_id_9,rating_1)).
end_mod(model(f1)).
begin(model(f2)).
capability(prof_id_5,student_id_5,capability_1).
capability(prof_id_6,student_id_5,capability_2).
capability(prof_id_7,student_id_7,capability_4).
capability(prof_id_7,student_id_8,capability_4).
capability(prof_id_6,student_id_8,capability_4).
capability(prof_id_6,student_id_9,capability_4).
capability(prof_id_9,student_id_10,capability_3).
capability(prof_id_7,student_id_11,capability_1).
capability(prof_id_8,student_id_12,capability_1).
capability(prof_id_8,student_id_13,capability_2).
capability(prof_id_5,student_id_14,capability_2).
capability(prof_id_6,student_id_15,capability_1).
capability(prof_id_6,student_id_16,capability_2).
capability(prof_id_4,student_id_17,capability_3).
capability(prof_id_5,student_id_18,capability_3).
capability(prof_id_7,student_id_19,capability_5).
capability(prof_id_7,student_id_20,capability_1).
capability(prof_id_8,student_id_21,capability_3).
capability(prof_id_7,student_id_22,capability_3).
capability(prof_id_6,student_id_23,capability_5).
capability(prof_id_6,student_id_24,capability_5).
capability(prof_id_6,student_id_25,capability_5).
capability(prof_id_5,student_id_26,capability_4).
capability(prof_id_5,student_id_27,capability_3).
capability(prof_id_5,student_id_28,capability_3).
salary(prof_id_5,student_id_5,salary_low).
salary(prof_id_6,student_id_5,salary_low).
salary(prof_id_7,student_id_7,salary_high).
salary(prof_id_7,student_id_8,salary_high).
salary(prof_id_6,student_id_8,salary_high).
salary(prof_id_6,student_id_9,salary_high).
salary(prof_id_9,student_id_10,salary_high).
salary(prof_id_7,student_id_11,salary_med).
salary(prof_id_8,student_id_12,salary_med).
salary(prof_id_8,student_id_13,salary_med).
salary(prof_id_5,student_id_14,salary_low).
salary(prof_id_6,student_id_15,salary_med).
salary(prof_id_6,student_id_16,salary_med).
salary(prof_id_4,student_id_17,salary_med).
salary(prof_id_5,student_id_18,salary_high).
salary(prof_id_7,student_id_19,salary_high).
salary(prof_id_7,student_id_20,salary_low).
salary(prof_id_8,student_id_21,salary_low).
salary(prof_id_7,student_id_22,salary_med).
salary(prof_id_6,student_id_23,salary_high).
salary(prof_id_6,student_id_24,salary_high).
salary(prof_id_6,student_id_25,salary_high).
salary(prof_id_5,student_id_26,salary_high).
salary(prof_id_5,student_id_27,salary_med).
salary(prof_id_5,student_id_28,salary_med).
diff(course_id_4,diff_1).
diff(course_id_5,diff_2).
diff(course_id_6,diff_1).
diff(course_id_7,diff_2).
diff(course_id_8,diff_1).
diff(course_id_9,diff_2).
diff(course_id_10,diff_1).
diff(course_id_11,diff_2).
diff(course_id_12,diff_1).
diff(course_id_13,diff_2).
popularity(prof_id_4,popularity_2).
popularity(prof_id_5,popularity_2).
popularity(prof_id_6,popularity_2).
popularity(prof_id_7,popularity_2).
popularity(prof_id_8,popularity_1).
popularity(prof_id_9,popularity_1).
teachingability(prof_id_4,teachingability_3).
teachingability(prof_id_5,teachingability_3).
teachingability(prof_id_6,teachingability_3).
teachingability(prof_id_7,teachingability_2).
teachingability(prof_id_8,teachingability_2).
teachingability(prof_id_9,teachingability_2).
grade(course_id_4,student_id_4,grade_1).
grade(course_id_4,student_id_6,grade_1).
grade(course_id_4,student_id_7,grade_1).
grade(course_id_4,student_id_12,grade_2).
grade(course_id_4,student_id_18,grade_2).
grade(course_id_4,student_id_29,grade_3).
grade(course_id_4,student_id_38,grade_4).
grade(course_id_4,student_id_40,grade_1).
grade(course_id_5,student_id_4,grade_1).
grade(course_id_5,student_id_5,grade_2).
grade(course_id_5,student_id_6,grade_2).
grade(course_id_5,student_id_15,grade_2).
grade(course_id_5,student_id_18,grade_3).
grade(course_id_5,student_id_25,grade_3).
grade(course_id_5,student_id_29,grade_4).
grade(course_id_5,student_id_34,grade_3).
grade(course_id_5,student_id_38,grade_4).
grade(course_id_5,student_id_39,grade_1).
grade(course_id_5,student_id_41,grade_1).
grade(course_id_6,student_id_4,grade_1).
grade(course_id_6,student_id_6,grade_1).
grade(course_id_6,student_id_7,grade_1).
grade(course_id_6,student_id_9,grade_1).
grade(course_id_6,student_id_13,grade_1).
grade(course_id_6,student_id_19,grade_2).
grade(course_id_6,student_id_25,grade_3).
grade(course_id_6,student_id_30,grade_4).
grade(course_id_6,student_id_41,grade_1).
grade(course_id_7,student_id_4,grade_2).
grade(course_id_7,student_id_5,grade_2).
grade(course_id_7,student_id_9,grade_2).
grade(course_id_7,student_id_15,grade_2).
grade(course_id_7,student_id_20,grade_2).
grade(course_id_7,student_id_30,grade_4).
grade(course_id_7,student_id_40,grade_1).
grade(course_id_8,student_id_5,grade_1).
grade(course_id_8,student_id_6,grade_1).
grade(course_id_8,student_id_9,grade_1).
grade(course_id_8,student_id_10,grade_1).
grade(course_id_8,student_id_11,grade_2).
grade(course_id_8,student_id_14,grade_1).
grade(course_id_8,student_id_20,grade_3).
grade(course_id_8,student_id_22,grade_3).
grade(course_id_8,student_id_30,grade_4).
grade(course_id_8,student_id_41,grade_1).
grade(course_id_9,student_id_6,grade_1).
grade(course_id_9,student_id_10,grade_2).
grade(course_id_9,student_id_12,grade_2).
grade(course_id_9,student_id_15,grade_2).
grade(course_id_9,student_id_23,grade_2).
grade(course_id_9,student_id_31,grade_3).
grade(course_id_9,student_id_33,grade_3).
grade(course_id_9,student_id_35,grade_3).
grade(course_id_10,student_id_6,grade_1).
grade(course_id_10,student_id_11,grade_1).
grade(course_id_10,student_id_14,grade_1).
grade(course_id_10,student_id_17,grade_3).
grade(course_id_10,student_id_18,grade_1).
grade(course_id_10,student_id_23,grade_2).
grade(course_id_10,student_id_32,grade_3).
grade(course_id_10,student_id_36,grade_4).
grade(course_id_11,student_id_7,grade_2).
grade(course_id_11,student_id_8,grade_1).
grade(course_id_11,student_id_14,grade_2).
grade(course_id_11,student_id_16,grade_2).
grade(course_id_11,student_id_17,grade_2).
grade(course_id_11,student_id_23,grade_3).
grade(course_id_11,student_id_28,grade_4).
grade(course_id_11,student_id_32,grade_4).
grade(course_id_11,student_id_37,grade_3).
grade(course_id_11,student_id_41,grade_2).
grade(course_id_12,student_id_8,grade_1).
grade(course_id_12,student_id_10,grade_1).
grade(course_id_12,student_id_11,grade_1).
grade(course_id_12,student_id_17,grade_2).
grade(course_id_12,student_id_21,grade_1).
grade(course_id_12,student_id_22,grade_2).
grade(course_id_12,student_id_23,grade_1).
grade(course_id_12,student_id_24,grade_1).
grade(course_id_12,student_id_26,grade_2).
grade(course_id_12,student_id_28,grade_3).
grade(course_id_12,student_id_33,grade_4).
grade(course_id_12,student_id_37,grade_4).
grade(course_id_13,student_id_7,grade_2).
grade(course_id_13,student_id_14,grade_2).
grade(course_id_13,student_id_16,grade_3).
grade(course_id_13,student_id_21,grade_2).
grade(course_id_13,student_id_26,grade_3).
grade(course_id_13,student_id_27,grade_3).
grade(course_id_13,student_id_33,grade_4).
grade(course_id_13,student_id_37,grade_4).
grade(course_id_13,student_id_41,grade_2).
sat(course_id_4,student_id_4,sat_1).
sat(course_id_4,student_id_6,sat_1).
sat(course_id_4,student_id_7,sat_1).
sat(course_id_4,student_id_12,sat_2).
sat(course_id_4,student_id_18,sat_2).
sat(course_id_4,student_id_29,sat_2).
sat(course_id_4,student_id_38,sat_3).
sat(course_id_4,student_id_40,sat_1).
sat(course_id_5,student_id_4,sat_1).
sat(course_id_5,student_id_5,sat_2).
sat(course_id_5,student_id_6,sat_2).
sat(course_id_5,student_id_15,sat_1).
sat(course_id_5,student_id_18,sat_2).
sat(course_id_5,student_id_25,sat_2).
sat(course_id_5,student_id_29,sat_3).
sat(course_id_5,student_id_34,sat_2).
sat(course_id_5,student_id_38,sat_3).
sat(course_id_5,student_id_39,sat_1).
sat(course_id_5,student_id_41,sat_1).
sat(course_id_6,student_id_4,sat_1).
sat(course_id_6,student_id_6,sat_1).
sat(course_id_6,student_id_7,sat_1).
sat(course_id_6,student_id_9,sat_1).
sat(course_id_6,student_id_13,sat_1).
sat(course_id_6,student_id_19,sat_3).
sat(course_id_6,student_id_25,sat_3).
sat(course_id_6,student_id_30,sat_3).
sat(course_id_6,student_id_41,sat_1).
sat(course_id_7,student_id_4,sat_1).
sat(course_id_7,student_id_5,sat_2).
sat(course_id_7,student_id_9,sat_2).
sat(course_id_7,student_id_15,sat_1).
sat(course_id_7,student_id_20,sat_2).
sat(course_id_7,student_id_30,sat_3).
sat(course_id_7,student_id_40,sat_1).
sat(course_id_8,student_id_5,sat_1).
sat(course_id_8,student_id_6,sat_1).
sat(course_id_8,student_id_9,sat_2).
sat(course_id_8,student_id_10,sat_1).
sat(course_id_8,student_id_11,sat_2).
sat(course_id_8,student_id_14,sat_1).
sat(course_id_8,student_id_20,sat_3).
sat(course_id_8,student_id_22,sat_2).
sat(course_id_8,student_id_30,sat_3).
sat(course_id_8,student_id_41,sat_1).
sat(course_id_9,student_id_6,sat_1).
sat(course_id_9,student_id_10,sat_2).
sat(course_id_9,student_id_12,sat_1).
sat(course_id_9,student_id_15,sat_1).
sat(course_id_9,student_id_23,sat_2).
sat(course_id_9,student_id_31,sat_2).
sat(course_id_9,student_id_33,sat_2).
sat(course_id_9,student_id_35,sat_2).
sat(course_id_10,student_id_6,sat_1).
sat(course_id_10,student_id_11,sat_2).
sat(course_id_10,student_id_14,sat_1).
sat(course_id_10,student_id_17,sat_3).
sat(course_id_10,student_id_18,sat_1).
sat(course_id_10,student_id_23,sat_1).
sat(course_id_10,student_id_32,sat_2).
sat(course_id_10,student_id_36,sat_3).
sat(course_id_11,student_id_7,sat_1).
sat(course_id_11,student_id_8,sat_1).
sat(course_id_11,student_id_14,sat_1).
sat(course_id_11,student_id_16,sat_1).
sat(course_id_11,student_id_17,sat_1).
sat(course_id_11,student_id_23,sat_3).
sat(course_id_11,student_id_28,sat_3).
sat(course_id_11,student_id_32,sat_3).
sat(course_id_11,student_id_37,sat_3).
sat(course_id_11,student_id_41,sat_2).
sat(course_id_12,student_id_8,sat_1).
sat(course_id_12,student_id_10,sat_1).
sat(course_id_12,student_id_11,sat_2).
sat(course_id_12,student_id_17,sat_2).
sat(course_id_12,student_id_21,sat_1).
sat(course_id_12,student_id_22,sat_1).
sat(course_id_12,student_id_23,sat_1).
sat(course_id_12,student_id_24,sat_1).
sat(course_id_12,student_id_26,sat_3).
sat(course_id_12,student_id_28,sat_2).
sat(course_id_12,student_id_33,sat_3).
sat(course_id_12,student_id_37,sat_3).
sat(course_id_13,student_id_7,sat_1).
sat(course_id_13,student_id_14,sat_2).
sat(course_id_13,student_id_16,sat_2).
sat(course_id_13,student_id_21,sat_2).
sat(course_id_13,student_id_26,sat_3).
sat(course_id_13,student_id_27,sat_2).
sat(course_id_13,student_id_33,sat_3).
sat(course_id_13,student_id_37,sat_3).
sat(course_id_13,student_id_41,sat_2).
intelligence(student_id_4,intelligence_3).
intelligence(student_id_5,intelligence_3).
intelligence(student_id_6,intelligence_3).
intelligence(student_id_7,intelligence_3).
intelligence(student_id_8,intelligence_3).
intelligence(student_id_9,intelligence_3).
intelligence(student_id_10,intelligence_3).
intelligence(student_id_11,intelligence_3).
intelligence(student_id_12,intelligence_2).
intelligence(student_id_13,intelligence_2).
intelligence(student_id_14,intelligence_2).
intelligence(student_id_15,intelligence_2).
intelligence(student_id_16,intelligence_2).
intelligence(student_id_17,intelligence_2).
intelligence(student_id_18,intelligence_2).
intelligence(student_id_19,intelligence_2).
intelligence(student_id_20,intelligence_2).
intelligence(student_id_21,intelligence_2).
intelligence(student_id_22,intelligence_2).
intelligence(student_id_23,intelligence_2).
intelligence(student_id_24,intelligence_2).
intelligence(student_id_25,intelligence_1).
intelligence(student_id_26,intelligence_1).
intelligence(student_id_27,intelligence_1).
intelligence(student_id_28,intelligence_1).
intelligence(student_id_29,intelligence_1).
intelligence(student_id_30,intelligence_1).
intelligence(student_id_31,intelligence_1).
intelligence(student_id_32,intelligence_1).
intelligence(student_id_33,intelligence_1).
intelligence(student_id_34,intelligence_1).
intelligence(student_id_35,intelligence_1).
intelligence(student_id_36,intelligence_1).
intelligence(student_id_37,intelligence_1).
intelligence(student_id_38,intelligence_1).
intelligence(student_id_39,intelligence_3).
intelligence(student_id_40,intelligence_3).
intelligence(student_id_41,intelligence_3).
ranking(student_id_4,ranking_1).
ranking(student_id_5,ranking_1).
ranking(student_id_6,ranking_2).
ranking(student_id_7,ranking_1).
ranking(student_id_8,ranking_1).
ranking(student_id_9,ranking_2).
ranking(student_id_10,ranking_1).
ranking(student_id_11,ranking_2).
ranking(student_id_12,ranking_2).
ranking(student_id_13,ranking_2).
ranking(student_id_14,ranking_2).
ranking(student_id_15,ranking_3).
ranking(student_id_16,ranking_3).
ranking(student_id_17,ranking_3).
ranking(student_id_18,ranking_3).
ranking(student_id_19,ranking_3).
ranking(student_id_20,ranking_3).
ranking(student_id_21,ranking_2).
ranking(student_id_22,ranking_4).
ranking(student_id_23,ranking_3).
ranking(student_id_24,ranking_2).
ranking(student_id_25,ranking_4).
ranking(student_id_26,ranking_4).
ranking(student_id_27,ranking_4).
ranking(student_id_28,ranking_4).
ranking(student_id_29,ranking_5).
ranking(student_id_30,ranking_5).
ranking(student_id_31,ranking_5).
ranking(student_id_32,ranking_5).
ranking(student_id_33,ranking_5).
ranking(student_id_34,ranking_4).
ranking(student_id_35,ranking_4).
ranking(student_id_36,ranking_5).
ranking(student_id_37,ranking_5).
ranking(student_id_38,ranking_5).
ranking(student_id_39,ranking_1).
ranking(student_id_40,ranking_1).
ranking(student_id_41,ranking_1).
b_registration(course_id_4,student_id_4).
b_registration(course_id_4,student_id_6).
b_registration(course_id_4,student_id_7).
b_registration(course_id_4,student_id_12).
b_registration(course_id_4,student_id_18).
b_registration(course_id_4,student_id_29).
b_registration(course_id_4,student_id_38).
b_registration(course_id_4,student_id_40).
b_registration(course_id_5,student_id_4).
b_registration(course_id_5,student_id_5).
b_registration(course_id_5,student_id_6).
b_registration(course_id_5,student_id_15).
b_registration(course_id_5,student_id_18).
b_registration(course_id_5,student_id_25).
b_registration(course_id_5,student_id_29).
b_registration(course_id_5,student_id_34).
b_registration(course_id_5,student_id_38).
b_registration(course_id_5,student_id_39).
b_registration(course_id_5,student_id_41).
b_registration(course_id_6,student_id_4).
b_registration(course_id_6,student_id_6).
b_registration(course_id_6,student_id_7).
b_registration(course_id_6,student_id_9).
b_registration(course_id_6,student_id_13).
b_registration(course_id_6,student_id_19).
b_registration(course_id_6,student_id_25).
b_registration(course_id_6,student_id_30).
b_registration(course_id_6,student_id_41).
b_registration(course_id_7,student_id_4).
b_registration(course_id_7,student_id_5).
b_registration(course_id_7,student_id_9).
b_registration(course_id_7,student_id_15).
b_registration(course_id_7,student_id_20).
b_registration(course_id_7,student_id_30).
b_registration(course_id_7,student_id_40).
b_registration(course_id_8,student_id_5).
b_registration(course_id_8,student_id_6).
b_registration(course_id_8,student_id_9).
b_registration(course_id_8,student_id_10).
b_registration(course_id_8,student_id_11).
b_registration(course_id_8,student_id_14).
b_registration(course_id_8,student_id_20).
b_registration(course_id_8,student_id_22).
b_registration(course_id_8,student_id_30).
b_registration(course_id_8,student_id_41).
b_registration(course_id_9,student_id_6).
b_registration(course_id_9,student_id_10).
b_registration(course_id_9,student_id_12).
b_registration(course_id_9,student_id_15).
b_registration(course_id_9,student_id_23).
b_registration(course_id_9,student_id_31).
b_registration(course_id_9,student_id_33).
b_registration(course_id_9,student_id_35).
b_registration(course_id_10,student_id_6).
b_registration(course_id_10,student_id_11).
b_registration(course_id_10,student_id_14).
b_registration(course_id_10,student_id_17).
b_registration(course_id_10,student_id_18).
b_registration(course_id_10,student_id_23).
b_registration(course_id_10,student_id_32).
b_registration(course_id_10,student_id_36).
b_registration(course_id_11,student_id_7).
b_registration(course_id_11,student_id_8).
b_registration(course_id_11,student_id_14).
b_registration(course_id_11,student_id_16).
b_registration(course_id_11,student_id_17).
b_registration(course_id_11,student_id_23).
b_registration(course_id_11,student_id_28).
b_registration(course_id_11,student_id_32).
b_registration(course_id_11,student_id_37).
b_registration(course_id_11,student_id_41).
b_registration(course_id_12,student_id_8).
b_registration(course_id_12,student_id_10).
b_registration(course_id_12,student_id_11).
b_registration(course_id_12,student_id_17).
b_registration(course_id_12,student_id_21).
b_registration(course_id_12,student_id_22).
b_registration(course_id_12,student_id_23).
b_registration(course_id_12,student_id_24).
b_registration(course_id_12,student_id_26).
b_registration(course_id_12,student_id_28).
b_registration(course_id_12,student_id_33).
b_registration(course_id_12,student_id_37).
b_registration(course_id_13,student_id_7).
b_registration(course_id_13,student_id_14).
b_registration(course_id_13,student_id_16).
b_registration(course_id_13,student_id_21).
b_registration(course_id_13,student_id_26).
b_registration(course_id_13,student_id_27).
b_registration(course_id_13,student_id_33).
b_registration(course_id_13,student_id_37).
b_registration(course_id_13,student_id_41).
b_ra(prof_id_5,student_id_5).
b_ra(prof_id_6,student_id_5).
b_ra(prof_id_7,student_id_7).
b_ra(prof_id_7,student_id_8).
b_ra(prof_id_6,student_id_8).
b_ra(prof_id_6,student_id_9).
b_ra(prof_id_9,student_id_10).
b_ra(prof_id_7,student_id_11).
b_ra(prof_id_8,student_id_12).
b_ra(prof_id_8,student_id_13).
b_ra(prof_id_5,student_id_14).
b_ra(prof_id_6,student_id_15).
b_ra(prof_id_6,student_id_16).
b_ra(prof_id_4,student_id_17).
b_ra(prof_id_5,student_id_18).
b_ra(prof_id_7,student_id_19).
b_ra(prof_id_7,student_id_20).
b_ra(prof_id_8,student_id_21).
b_ra(prof_id_7,student_id_22).
b_ra(prof_id_6,student_id_23).
b_ra(prof_id_6,student_id_24).
b_ra(prof_id_6,student_id_25).
b_ra(prof_id_5,student_id_26).
b_ra(prof_id_5,student_id_27).
b_ra(prof_id_5,student_id_28).
rating(course_id_8,rating_2).
rating(course_id_12,rating_1).
neg(rating(course_id_8,rating_1)).
neg(rating(course_id_12,rating_2)).
end_mod(model(f2)).
begin(model(f3)).
capability(prof_id_5,student_id_5,capability_1).
capability(prof_id_6,student_id_5,capability_2).
capability(prof_id_7,student_id_7,capability_4).
capability(prof_id_7,student_id_8,capability_4).
capability(prof_id_6,student_id_8,capability_4).
capability(prof_id_6,student_id_9,capability_4).
capability(prof_id_9,student_id_10,capability_3).
capability(prof_id_7,student_id_11,capability_1).
capability(prof_id_8,student_id_12,capability_1).
capability(prof_id_8,student_id_13,capability_2).
capability(prof_id_5,student_id_14,capability_2).
capability(prof_id_6,student_id_15,capability_1).
capability(prof_id_6,student_id_16,capability_2).
capability(prof_id_4,student_id_17,capability_3).
capability(prof_id_5,student_id_18,capability_3).
capability(prof_id_7,student_id_19,capability_5).
capability(prof_id_7,student_id_20,capability_1).
capability(prof_id_8,student_id_21,capability_3).
capability(prof_id_7,student_id_22,capability_3).
capability(prof_id_6,student_id_23,capability_5).
capability(prof_id_6,student_id_24,capability_5).
capability(prof_id_6,student_id_25,capability_5).
capability(prof_id_5,student_id_26,capability_4).
capability(prof_id_5,student_id_27,capability_3).
capability(prof_id_5,student_id_28,capability_3).
salary(prof_id_5,student_id_5,salary_low).
salary(prof_id_6,student_id_5,salary_low).
salary(prof_id_7,student_id_7,salary_high).
salary(prof_id_7,student_id_8,salary_high).
salary(prof_id_6,student_id_8,salary_high).
salary(prof_id_6,student_id_9,salary_high).
salary(prof_id_9,student_id_10,salary_high).
salary(prof_id_7,student_id_11,salary_med).
salary(prof_id_8,student_id_12,salary_med).
salary(prof_id_8,student_id_13,salary_med).
salary(prof_id_5,student_id_14,salary_low).
salary(prof_id_6,student_id_15,salary_med).
salary(prof_id_6,student_id_16,salary_med).
salary(prof_id_4,student_id_17,salary_med).
salary(prof_id_5,student_id_18,salary_high).
salary(prof_id_7,student_id_19,salary_high).
salary(prof_id_7,student_id_20,salary_low).
salary(prof_id_8,student_id_21,salary_low).
salary(prof_id_7,student_id_22,salary_med).
salary(prof_id_6,student_id_23,salary_high).
salary(prof_id_6,student_id_24,salary_high).
salary(prof_id_6,student_id_25,salary_high).
salary(prof_id_5,student_id_26,salary_high).
salary(prof_id_5,student_id_27,salary_med).
salary(prof_id_5,student_id_28,salary_med).
diff(course_id_4,diff_1).
diff(course_id_5,diff_2).
diff(course_id_6,diff_1).
diff(course_id_7,diff_2).
diff(course_id_8,diff_1).
diff(course_id_9,diff_2).
diff(course_id_10,diff_1).
diff(course_id_11,diff_2).
diff(course_id_12,diff_1).
diff(course_id_13,diff_2).
popularity(prof_id_4,popularity_2).
popularity(prof_id_5,popularity_2).
popularity(prof_id_6,popularity_2).
popularity(prof_id_7,popularity_2).
popularity(prof_id_8,popularity_1).
popularity(prof_id_9,popularity_1).
teachingability(prof_id_4,teachingability_3).
teachingability(prof_id_5,teachingability_3).
teachingability(prof_id_6,teachingability_3).
teachingability(prof_id_7,teachingability_2).
teachingability(prof_id_8,teachingability_2).
teachingability(prof_id_9,teachingability_2).
grade(course_id_4,student_id_4,grade_1).
grade(course_id_4,student_id_6,grade_1).
grade(course_id_4,student_id_7,grade_1).
grade(course_id_4,student_id_12,grade_2).
grade(course_id_4,student_id_18,grade_2).
grade(course_id_4,student_id_29,grade_3).
grade(course_id_4,student_id_38,grade_4).
grade(course_id_4,student_id_40,grade_1).
grade(course_id_5,student_id_4,grade_1).
grade(course_id_5,student_id_5,grade_2).
grade(course_id_5,student_id_6,grade_2).
grade(course_id_5,student_id_15,grade_2).
grade(course_id_5,student_id_18,grade_3).
grade(course_id_5,student_id_25,grade_3).
grade(course_id_5,student_id_29,grade_4).
grade(course_id_5,student_id_34,grade_3).
grade(course_id_5,student_id_38,grade_4).
grade(course_id_5,student_id_39,grade_1).
grade(course_id_5,student_id_41,grade_1).
grade(course_id_6,student_id_4,grade_1).
grade(course_id_6,student_id_6,grade_1).
grade(course_id_6,student_id_7,grade_1).
grade(course_id_6,student_id_9,grade_1).
grade(course_id_6,student_id_13,grade_1).
grade(course_id_6,student_id_19,grade_2).
grade(course_id_6,student_id_25,grade_3).
grade(course_id_6,student_id_30,grade_4).
grade(course_id_6,student_id_41,grade_1).
grade(course_id_7,student_id_4,grade_2).
grade(course_id_7,student_id_5,grade_2).
grade(course_id_7,student_id_9,grade_2).
grade(course_id_7,student_id_15,grade_2).
grade(course_id_7,student_id_20,grade_2).
grade(course_id_7,student_id_30,grade_4).
grade(course_id_7,student_id_40,grade_1).
grade(course_id_8,student_id_5,grade_1).
grade(course_id_8,student_id_6,grade_1).
grade(course_id_8,student_id_9,grade_1).
grade(course_id_8,student_id_10,grade_1).
grade(course_id_8,student_id_11,grade_2).
grade(course_id_8,student_id_14,grade_1).
grade(course_id_8,student_id_20,grade_3).
grade(course_id_8,student_id_22,grade_3).
grade(course_id_8,student_id_30,grade_4).
grade(course_id_8,student_id_41,grade_1).
grade(course_id_9,student_id_6,grade_1).
grade(course_id_9,student_id_10,grade_2).
grade(course_id_9,student_id_12,grade_2).
grade(course_id_9,student_id_15,grade_2).
grade(course_id_9,student_id_23,grade_2).
grade(course_id_9,student_id_31,grade_3).
grade(course_id_9,student_id_33,grade_3).
grade(course_id_9,student_id_35,grade_3).
grade(course_id_10,student_id_6,grade_1).
grade(course_id_10,student_id_11,grade_1).
grade(course_id_10,student_id_14,grade_1).
grade(course_id_10,student_id_17,grade_3).
grade(course_id_10,student_id_18,grade_1).
grade(course_id_10,student_id_23,grade_2).
grade(course_id_10,student_id_32,grade_3).
grade(course_id_10,student_id_36,grade_4).
grade(course_id_11,student_id_7,grade_2).
grade(course_id_11,student_id_8,grade_1).
grade(course_id_11,student_id_14,grade_2).
grade(course_id_11,student_id_16,grade_2).
grade(course_id_11,student_id_17,grade_2).
grade(course_id_11,student_id_23,grade_3).
grade(course_id_11,student_id_28,grade_4).
grade(course_id_11,student_id_32,grade_4).
grade(course_id_11,student_id_37,grade_3).
grade(course_id_11,student_id_41,grade_2).
grade(course_id_12,student_id_8,grade_1).
grade(course_id_12,student_id_10,grade_1).
grade(course_id_12,student_id_11,grade_1).
grade(course_id_12,student_id_17,grade_2).
grade(course_id_12,student_id_21,grade_1).
grade(course_id_12,student_id_22,grade_2).
grade(course_id_12,student_id_23,grade_1).
grade(course_id_12,student_id_24,grade_1).
grade(course_id_12,student_id_26,grade_2).
grade(course_id_12,student_id_28,grade_3).
grade(course_id_12,student_id_33,grade_4).
grade(course_id_12,student_id_37,grade_4).
grade(course_id_13,student_id_7,grade_2).
grade(course_id_13,student_id_14,grade_2).
grade(course_id_13,student_id_16,grade_3).
grade(course_id_13,student_id_21,grade_2).
grade(course_id_13,student_id_26,grade_3).
grade(course_id_13,student_id_27,grade_3).
grade(course_id_13,student_id_33,grade_4).
grade(course_id_13,student_id_37,grade_4).
grade(course_id_13,student_id_41,grade_2).
sat(course_id_4,student_id_4,sat_1).
sat(course_id_4,student_id_6,sat_1).
sat(course_id_4,student_id_7,sat_1).
sat(course_id_4,student_id_12,sat_2).
sat(course_id_4,student_id_18,sat_2).
sat(course_id_4,student_id_29,sat_2).
sat(course_id_4,student_id_38,sat_3).
sat(course_id_4,student_id_40,sat_1).
sat(course_id_5,student_id_4,sat_1).
sat(course_id_5,student_id_5,sat_2).
sat(course_id_5,student_id_6,sat_2).
sat(course_id_5,student_id_15,sat_1).
sat(course_id_5,student_id_18,sat_2).
sat(course_id_5,student_id_25,sat_2).
sat(course_id_5,student_id_29,sat_3).
sat(course_id_5,student_id_34,sat_2).
sat(course_id_5,student_id_38,sat_3).
sat(course_id_5,student_id_39,sat_1).
sat(course_id_5,student_id_41,sat_1).
sat(course_id_6,student_id_4,sat_1).
sat(course_id_6,student_id_6,sat_1).
sat(course_id_6,student_id_7,sat_1).
sat(course_id_6,student_id_9,sat_1).
sat(course_id_6,student_id_13,sat_1).
sat(course_id_6,student_id_19,sat_3).
sat(course_id_6,student_id_25,sat_3).
sat(course_id_6,student_id_30,sat_3).
sat(course_id_6,student_id_41,sat_1).
sat(course_id_7,student_id_4,sat_1).
sat(course_id_7,student_id_5,sat_2).
sat(course_id_7,student_id_9,sat_2).
sat(course_id_7,student_id_15,sat_1).
sat(course_id_7,student_id_20,sat_2).
sat(course_id_7,student_id_30,sat_3).
sat(course_id_7,student_id_40,sat_1).
sat(course_id_8,student_id_5,sat_1).
sat(course_id_8,student_id_6,sat_1).
sat(course_id_8,student_id_9,sat_2).
sat(course_id_8,student_id_10,sat_1).
sat(course_id_8,student_id_11,sat_2).
sat(course_id_8,student_id_14,sat_1).
sat(course_id_8,student_id_20,sat_3).
sat(course_id_8,student_id_22,sat_2).
sat(course_id_8,student_id_30,sat_3).
sat(course_id_8,student_id_41,sat_1).
sat(course_id_9,student_id_6,sat_1).
sat(course_id_9,student_id_10,sat_2).
sat(course_id_9,student_id_12,sat_1).
sat(course_id_9,student_id_15,sat_1).
sat(course_id_9,student_id_23,sat_2).
sat(course_id_9,student_id_31,sat_2).
sat(course_id_9,student_id_33,sat_2).
sat(course_id_9,student_id_35,sat_2).
sat(course_id_10,student_id_6,sat_1).
sat(course_id_10,student_id_11,sat_2).
sat(course_id_10,student_id_14,sat_1).
sat(course_id_10,student_id_17,sat_3).
sat(course_id_10,student_id_18,sat_1).
sat(course_id_10,student_id_23,sat_1).
sat(course_id_10,student_id_32,sat_2).
sat(course_id_10,student_id_36,sat_3).
sat(course_id_11,student_id_7,sat_1).
sat(course_id_11,student_id_8,sat_1).
sat(course_id_11,student_id_14,sat_1).
sat(course_id_11,student_id_16,sat_1).
sat(course_id_11,student_id_17,sat_1).
sat(course_id_11,student_id_23,sat_3).
sat(course_id_11,student_id_28,sat_3).
sat(course_id_11,student_id_32,sat_3).
sat(course_id_11,student_id_37,sat_3).
sat(course_id_11,student_id_41,sat_2).
sat(course_id_12,student_id_8,sat_1).
sat(course_id_12,student_id_10,sat_1).
sat(course_id_12,student_id_11,sat_2).
sat(course_id_12,student_id_17,sat_2).
sat(course_id_12,student_id_21,sat_1).
sat(course_id_12,student_id_22,sat_1).
sat(course_id_12,student_id_23,sat_1).
sat(course_id_12,student_id_24,sat_1).
sat(course_id_12,student_id_26,sat_3).
sat(course_id_12,student_id_28,sat_2).
sat(course_id_12,student_id_33,sat_3).
sat(course_id_12,student_id_37,sat_3).
sat(course_id_13,student_id_7,sat_1).
sat(course_id_13,student_id_14,sat_2).
sat(course_id_13,student_id_16,sat_2).
sat(course_id_13,student_id_21,sat_2).
sat(course_id_13,student_id_26,sat_3).
sat(course_id_13,student_id_27,sat_2).
sat(course_id_13,student_id_33,sat_3).
sat(course_id_13,student_id_37,sat_3).
sat(course_id_13,student_id_41,sat_2).
intelligence(student_id_4,intelligence_3).
intelligence(student_id_5,intelligence_3).
intelligence(student_id_6,intelligence_3).
intelligence(student_id_7,intelligence_3).
intelligence(student_id_8,intelligence_3).
intelligence(student_id_9,intelligence_3).
intelligence(student_id_10,intelligence_3).
intelligence(student_id_11,intelligence_3).
intelligence(student_id_12,intelligence_2).
intelligence(student_id_13,intelligence_2).
intelligence(student_id_14,intelligence_2).
intelligence(student_id_15,intelligence_2).
intelligence(student_id_16,intelligence_2).
intelligence(student_id_17,intelligence_2).
intelligence(student_id_18,intelligence_2).
intelligence(student_id_19,intelligence_2).
intelligence(student_id_20,intelligence_2).
intelligence(student_id_21,intelligence_2).
intelligence(student_id_22,intelligence_2).
intelligence(student_id_23,intelligence_2).
intelligence(student_id_24,intelligence_2).
intelligence(student_id_25,intelligence_1).
intelligence(student_id_26,intelligence_1).
intelligence(student_id_27,intelligence_1).
intelligence(student_id_28,intelligence_1).
intelligence(student_id_29,intelligence_1).
intelligence(student_id_30,intelligence_1).
intelligence(student_id_31,intelligence_1).
intelligence(student_id_32,intelligence_1).
intelligence(student_id_33,intelligence_1).
intelligence(student_id_34,intelligence_1).
intelligence(student_id_35,intelligence_1).
intelligence(student_id_36,intelligence_1).
intelligence(student_id_37,intelligence_1).
intelligence(student_id_38,intelligence_1).
intelligence(student_id_39,intelligence_3).
intelligence(student_id_40,intelligence_3).
intelligence(student_id_41,intelligence_3).
ranking(student_id_4,ranking_1).
ranking(student_id_5,ranking_1).
ranking(student_id_6,ranking_2).
ranking(student_id_7,ranking_1).
ranking(student_id_8,ranking_1).
ranking(student_id_9,ranking_2).
ranking(student_id_10,ranking_1).
ranking(student_id_11,ranking_2).
ranking(student_id_12,ranking_2).
ranking(student_id_13,ranking_2).
ranking(student_id_14,ranking_2).
ranking(student_id_15,ranking_3).
ranking(student_id_16,ranking_3).
ranking(student_id_17,ranking_3).
ranking(student_id_18,ranking_3).
ranking(student_id_19,ranking_3).
ranking(student_id_20,ranking_3).
ranking(student_id_21,ranking_2).
ranking(student_id_22,ranking_4).
ranking(student_id_23,ranking_3).
ranking(student_id_24,ranking_2).
ranking(student_id_25,ranking_4).
ranking(student_id_26,ranking_4).
ranking(student_id_27,ranking_4).
ranking(student_id_28,ranking_4).
ranking(student_id_29,ranking_5).
ranking(student_id_30,ranking_5).
ranking(student_id_31,ranking_5).
ranking(student_id_32,ranking_5).
ranking(student_id_33,ranking_5).
ranking(student_id_34,ranking_4).
ranking(student_id_35,ranking_4).
ranking(student_id_36,ranking_5).
ranking(student_id_37,ranking_5).
ranking(student_id_38,ranking_5).
ranking(student_id_39,ranking_1).
ranking(student_id_40,ranking_1).
ranking(student_id_41,ranking_1).
b_registration(course_id_4,student_id_4).
b_registration(course_id_4,student_id_6).
b_registration(course_id_4,student_id_7).
b_registration(course_id_4,student_id_12).
b_registration(course_id_4,student_id_18).
b_registration(course_id_4,student_id_29).
b_registration(course_id_4,student_id_38).
b_registration(course_id_4,student_id_40).
b_registration(course_id_5,student_id_4).
b_registration(course_id_5,student_id_5).
b_registration(course_id_5,student_id_6).
b_registration(course_id_5,student_id_15).
b_registration(course_id_5,student_id_18).
b_registration(course_id_5,student_id_25).
b_registration(course_id_5,student_id_29).
b_registration(course_id_5,student_id_34).
b_registration(course_id_5,student_id_38).
b_registration(course_id_5,student_id_39).
b_registration(course_id_5,student_id_41).
b_registration(course_id_6,student_id_4).
b_registration(course_id_6,student_id_6).
b_registration(course_id_6,student_id_7).
b_registration(course_id_6,student_id_9).
b_registration(course_id_6,student_id_13).
b_registration(course_id_6,student_id_19).
b_registration(course_id_6,student_id_25).
b_registration(course_id_6,student_id_30).
b_registration(course_id_6,student_id_41).
b_registration(course_id_7,student_id_4).
b_registration(course_id_7,student_id_5).
b_registration(course_id_7,student_id_9).
b_registration(course_id_7,student_id_15).
b_registration(course_id_7,student_id_20).
b_registration(course_id_7,student_id_30).
b_registration(course_id_7,student_id_40).
b_registration(course_id_8,student_id_5).
b_registration(course_id_8,student_id_6).
b_registration(course_id_8,student_id_9).
b_registration(course_id_8,student_id_10).
b_registration(course_id_8,student_id_11).
b_registration(course_id_8,student_id_14).
b_registration(course_id_8,student_id_20).
b_registration(course_id_8,student_id_22).
b_registration(course_id_8,student_id_30).
b_registration(course_id_8,student_id_41).
b_registration(course_id_9,student_id_6).
b_registration(course_id_9,student_id_10).
b_registration(course_id_9,student_id_12).
b_registration(course_id_9,student_id_15).
b_registration(course_id_9,student_id_23).
b_registration(course_id_9,student_id_31).
b_registration(course_id_9,student_id_33).
b_registration(course_id_9,student_id_35).
b_registration(course_id_10,student_id_6).
b_registration(course_id_10,student_id_11).
b_registration(course_id_10,student_id_14).
b_registration(course_id_10,student_id_17).
b_registration(course_id_10,student_id_18).
b_registration(course_id_10,student_id_23).
b_registration(course_id_10,student_id_32).
b_registration(course_id_10,student_id_36).
b_registration(course_id_11,student_id_7).
b_registration(course_id_11,student_id_8).
b_registration(course_id_11,student_id_14).
b_registration(course_id_11,student_id_16).
b_registration(course_id_11,student_id_17).
b_registration(course_id_11,student_id_23).
b_registration(course_id_11,student_id_28).
b_registration(course_id_11,student_id_32).
b_registration(course_id_11,student_id_37).
b_registration(course_id_11,student_id_41).
b_registration(course_id_12,student_id_8).
b_registration(course_id_12,student_id_10).
b_registration(course_id_12,student_id_11).
b_registration(course_id_12,student_id_17).
b_registration(course_id_12,student_id_21).
b_registration(course_id_12,student_id_22).
b_registration(course_id_12,student_id_23).
b_registration(course_id_12,student_id_24).
b_registration(course_id_12,student_id_26).
b_registration(course_id_12,student_id_28).
b_registration(course_id_12,student_id_33).
b_registration(course_id_12,student_id_37).
b_registration(course_id_13,student_id_7).
b_registration(course_id_13,student_id_14).
b_registration(course_id_13,student_id_16).
b_registration(course_id_13,student_id_21).
b_registration(course_id_13,student_id_26).
b_registration(course_id_13,student_id_27).
b_registration(course_id_13,student_id_33).
b_registration(course_id_13,student_id_37).
b_registration(course_id_13,student_id_41).
b_ra(prof_id_5,student_id_5).
b_ra(prof_id_6,student_id_5).
b_ra(prof_id_7,student_id_7).
b_ra(prof_id_7,student_id_8).
b_ra(prof_id_6,student_id_8).
b_ra(prof_id_6,student_id_9).
b_ra(prof_id_9,student_id_10).
b_ra(prof_id_7,student_id_11).
b_ra(prof_id_8,student_id_12).
b_ra(prof_id_8,student_id_13).
b_ra(prof_id_5,student_id_14).
b_ra(prof_id_6,student_id_15).
b_ra(prof_id_6,student_id_16).
b_ra(prof_id_4,student_id_17).
b_ra(prof_id_5,student_id_18).
b_ra(prof_id_7,student_id_19).
b_ra(prof_id_7,student_id_20).
b_ra(prof_id_8,student_id_21).
b_ra(prof_id_7,student_id_22).
b_ra(prof_id_6,student_id_23).
b_ra(prof_id_6,student_id_24).
b_ra(prof_id_6,student_id_25).
b_ra(prof_id_5,student_id_26).
b_ra(prof_id_5,student_id_27).
b_ra(prof_id_5,student_id_28).
rating(course_id_11,rating_1).
rating(course_id_4,rating_2).
neg(rating(course_id_11,rating_2)).
neg(rating(course_id_4,rating_1)).
end_mod(model(f3)).
begin(model(f4)).
capability(prof_id_5,student_id_5,capability_1).
capability(prof_id_6,student_id_5,capability_2).
capability(prof_id_7,student_id_7,capability_4).
capability(prof_id_7,student_id_8,capability_4).
capability(prof_id_6,student_id_8,capability_4).
capability(prof_id_6,student_id_9,capability_4).
capability(prof_id_9,student_id_10,capability_3).
capability(prof_id_7,student_id_11,capability_1).
capability(prof_id_8,student_id_12,capability_1).
capability(prof_id_8,student_id_13,capability_2).
capability(prof_id_5,student_id_14,capability_2).
capability(prof_id_6,student_id_15,capability_1).
capability(prof_id_6,student_id_16,capability_2).
capability(prof_id_4,student_id_17,capability_3).
capability(prof_id_5,student_id_18,capability_3).
capability(prof_id_7,student_id_19,capability_5).
capability(prof_id_7,student_id_20,capability_1).
capability(prof_id_8,student_id_21,capability_3).
capability(prof_id_7,student_id_22,capability_3).
capability(prof_id_6,student_id_23,capability_5).
capability(prof_id_6,student_id_24,capability_5).
capability(prof_id_6,student_id_25,capability_5).
capability(prof_id_5,student_id_26,capability_4).
capability(prof_id_5,student_id_27,capability_3).
capability(prof_id_5,student_id_28,capability_3).
salary(prof_id_5,student_id_5,salary_low).
salary(prof_id_6,student_id_5,salary_low).
salary(prof_id_7,student_id_7,salary_high).
salary(prof_id_7,student_id_8,salary_high).
salary(prof_id_6,student_id_8,salary_high).
salary(prof_id_6,student_id_9,salary_high).
salary(prof_id_9,student_id_10,salary_high).
salary(prof_id_7,student_id_11,salary_med).
salary(prof_id_8,student_id_12,salary_med).
salary(prof_id_8,student_id_13,salary_med).
salary(prof_id_5,student_id_14,salary_low).
salary(prof_id_6,student_id_15,salary_med).
salary(prof_id_6,student_id_16,salary_med).
salary(prof_id_4,student_id_17,salary_med).
salary(prof_id_5,student_id_18,salary_high).
salary(prof_id_7,student_id_19,salary_high).
salary(prof_id_7,student_id_20,salary_low).
salary(prof_id_8,student_id_21,salary_low).
salary(prof_id_7,student_id_22,salary_med).
salary(prof_id_6,student_id_23,salary_high).
salary(prof_id_6,student_id_24,salary_high).
salary(prof_id_6,student_id_25,salary_high).
salary(prof_id_5,student_id_26,salary_high).
salary(prof_id_5,student_id_27,salary_med).
salary(prof_id_5,student_id_28,salary_med).
diff(course_id_4,diff_1).
diff(course_id_5,diff_2).
diff(course_id_6,diff_1).
diff(course_id_7,diff_2).
diff(course_id_8,diff_1).
diff(course_id_9,diff_2).
diff(course_id_10,diff_1).
diff(course_id_11,diff_2).
diff(course_id_12,diff_1).
diff(course_id_13,diff_2).
popularity(prof_id_4,popularity_2).
popularity(prof_id_5,popularity_2).
popularity(prof_id_6,popularity_2).
popularity(prof_id_7,popularity_2).
popularity(prof_id_8,popularity_1).
popularity(prof_id_9,popularity_1).
teachingability(prof_id_4,teachingability_3).
teachingability(prof_id_5,teachingability_3).
teachingability(prof_id_6,teachingability_3).
teachingability(prof_id_7,teachingability_2).
teachingability(prof_id_8,teachingability_2).
teachingability(prof_id_9,teachingability_2).
grade(course_id_4,student_id_4,grade_1).
grade(course_id_4,student_id_6,grade_1).
grade(course_id_4,student_id_7,grade_1).
grade(course_id_4,student_id_12,grade_2).
grade(course_id_4,student_id_18,grade_2).
grade(course_id_4,student_id_29,grade_3).
grade(course_id_4,student_id_38,grade_4).
grade(course_id_4,student_id_40,grade_1).
grade(course_id_5,student_id_4,grade_1).
grade(course_id_5,student_id_5,grade_2).
grade(course_id_5,student_id_6,grade_2).
grade(course_id_5,student_id_15,grade_2).
grade(course_id_5,student_id_18,grade_3).
grade(course_id_5,student_id_25,grade_3).
grade(course_id_5,student_id_29,grade_4).
grade(course_id_5,student_id_34,grade_3).
grade(course_id_5,student_id_38,grade_4).
grade(course_id_5,student_id_39,grade_1).
grade(course_id_5,student_id_41,grade_1).
grade(course_id_6,student_id_4,grade_1).
grade(course_id_6,student_id_6,grade_1).
grade(course_id_6,student_id_7,grade_1).
grade(course_id_6,student_id_9,grade_1).
grade(course_id_6,student_id_13,grade_1).
grade(course_id_6,student_id_19,grade_2).
grade(course_id_6,student_id_25,grade_3).
grade(course_id_6,student_id_30,grade_4).
grade(course_id_6,student_id_41,grade_1).
grade(course_id_7,student_id_4,grade_2).
grade(course_id_7,student_id_5,grade_2).
grade(course_id_7,student_id_9,grade_2).
grade(course_id_7,student_id_15,grade_2).
grade(course_id_7,student_id_20,grade_2).
grade(course_id_7,student_id_30,grade_4).
grade(course_id_7,student_id_40,grade_1).
grade(course_id_8,student_id_5,grade_1).
grade(course_id_8,student_id_6,grade_1).
grade(course_id_8,student_id_9,grade_1).
grade(course_id_8,student_id_10,grade_1).
grade(course_id_8,student_id_11,grade_2).
grade(course_id_8,student_id_14,grade_1).
grade(course_id_8,student_id_20,grade_3).
grade(course_id_8,student_id_22,grade_3).
grade(course_id_8,student_id_30,grade_4).
grade(course_id_8,student_id_41,grade_1).
grade(course_id_9,student_id_6,grade_1).
grade(course_id_9,student_id_10,grade_2).
grade(course_id_9,student_id_12,grade_2).
grade(course_id_9,student_id_15,grade_2).
grade(course_id_9,student_id_23,grade_2).
grade(course_id_9,student_id_31,grade_3).
grade(course_id_9,student_id_33,grade_3).
grade(course_id_9,student_id_35,grade_3).
grade(course_id_10,student_id_6,grade_1).
grade(course_id_10,student_id_11,grade_1).
grade(course_id_10,student_id_14,grade_1).
grade(course_id_10,student_id_17,grade_3).
grade(course_id_10,student_id_18,grade_1).
grade(course_id_10,student_id_23,grade_2).
grade(course_id_10,student_id_32,grade_3).
grade(course_id_10,student_id_36,grade_4).
grade(course_id_11,student_id_7,grade_2).
grade(course_id_11,student_id_8,grade_1).
grade(course_id_11,student_id_14,grade_2).
grade(course_id_11,student_id_16,grade_2).
grade(course_id_11,student_id_17,grade_2).
grade(course_id_11,student_id_23,grade_3).
grade(course_id_11,student_id_28,grade_4).
grade(course_id_11,student_id_32,grade_4).
grade(course_id_11,student_id_37,grade_3).
grade(course_id_11,student_id_41,grade_2).
grade(course_id_12,student_id_8,grade_1).
grade(course_id_12,student_id_10,grade_1).
grade(course_id_12,student_id_11,grade_1).
grade(course_id_12,student_id_17,grade_2).
grade(course_id_12,student_id_21,grade_1).
grade(course_id_12,student_id_22,grade_2).
grade(course_id_12,student_id_23,grade_1).
grade(course_id_12,student_id_24,grade_1).
grade(course_id_12,student_id_26,grade_2).
grade(course_id_12,student_id_28,grade_3).
grade(course_id_12,student_id_33,grade_4).
grade(course_id_12,student_id_37,grade_4).
grade(course_id_13,student_id_7,grade_2).
grade(course_id_13,student_id_14,grade_2).
grade(course_id_13,student_id_16,grade_3).
grade(course_id_13,student_id_21,grade_2).
grade(course_id_13,student_id_26,grade_3).
grade(course_id_13,student_id_27,grade_3).
grade(course_id_13,student_id_33,grade_4).
grade(course_id_13,student_id_37,grade_4).
grade(course_id_13,student_id_41,grade_2).
sat(course_id_4,student_id_4,sat_1).
sat(course_id_4,student_id_6,sat_1).
sat(course_id_4,student_id_7,sat_1).
sat(course_id_4,student_id_12,sat_2).
sat(course_id_4,student_id_18,sat_2).
sat(course_id_4,student_id_29,sat_2).
sat(course_id_4,student_id_38,sat_3).
sat(course_id_4,student_id_40,sat_1).
sat(course_id_5,student_id_4,sat_1).
sat(course_id_5,student_id_5,sat_2).
sat(course_id_5,student_id_6,sat_2).
sat(course_id_5,student_id_15,sat_1).
sat(course_id_5,student_id_18,sat_2).
sat(course_id_5,student_id_25,sat_2).
sat(course_id_5,student_id_29,sat_3).
sat(course_id_5,student_id_34,sat_2).
sat(course_id_5,student_id_38,sat_3).
sat(course_id_5,student_id_39,sat_1).
sat(course_id_5,student_id_41,sat_1).
sat(course_id_6,student_id_4,sat_1).
sat(course_id_6,student_id_6,sat_1).
sat(course_id_6,student_id_7,sat_1).
sat(course_id_6,student_id_9,sat_1).
sat(course_id_6,student_id_13,sat_1).
sat(course_id_6,student_id_19,sat_3).
sat(course_id_6,student_id_25,sat_3).
sat(course_id_6,student_id_30,sat_3).
sat(course_id_6,student_id_41,sat_1).
sat(course_id_7,student_id_4,sat_1).
sat(course_id_7,student_id_5,sat_2).
sat(course_id_7,student_id_9,sat_2).
sat(course_id_7,student_id_15,sat_1).
sat(course_id_7,student_id_20,sat_2).
sat(course_id_7,student_id_30,sat_3).
sat(course_id_7,student_id_40,sat_1).
sat(course_id_8,student_id_5,sat_1).
sat(course_id_8,student_id_6,sat_1).
sat(course_id_8,student_id_9,sat_2).
sat(course_id_8,student_id_10,sat_1).
sat(course_id_8,student_id_11,sat_2).
sat(course_id_8,student_id_14,sat_1).
sat(course_id_8,student_id_20,sat_3).
sat(course_id_8,student_id_22,sat_2).
sat(course_id_8,student_id_30,sat_3).
sat(course_id_8,student_id_41,sat_1).
sat(course_id_9,student_id_6,sat_1).
sat(course_id_9,student_id_10,sat_2).
sat(course_id_9,student_id_12,sat_1).
sat(course_id_9,student_id_15,sat_1).
sat(course_id_9,student_id_23,sat_2).
sat(course_id_9,student_id_31,sat_2).
sat(course_id_9,student_id_33,sat_2).
sat(course_id_9,student_id_35,sat_2).
sat(course_id_10,student_id_6,sat_1).
sat(course_id_10,student_id_11,sat_2).
sat(course_id_10,student_id_14,sat_1).
sat(course_id_10,student_id_17,sat_3).
sat(course_id_10,student_id_18,sat_1).
sat(course_id_10,student_id_23,sat_1).
sat(course_id_10,student_id_32,sat_2).
sat(course_id_10,student_id_36,sat_3).
sat(course_id_11,student_id_7,sat_1).
sat(course_id_11,student_id_8,sat_1).
sat(course_id_11,student_id_14,sat_1).
sat(course_id_11,student_id_16,sat_1).
sat(course_id_11,student_id_17,sat_1).
sat(course_id_11,student_id_23,sat_3).
sat(course_id_11,student_id_28,sat_3).
sat(course_id_11,student_id_32,sat_3).
sat(course_id_11,student_id_37,sat_3).
sat(course_id_11,student_id_41,sat_2).
sat(course_id_12,student_id_8,sat_1).
sat(course_id_12,student_id_10,sat_1).
sat(course_id_12,student_id_11,sat_2).
sat(course_id_12,student_id_17,sat_2).
sat(course_id_12,student_id_21,sat_1).
sat(course_id_12,student_id_22,sat_1).
sat(course_id_12,student_id_23,sat_1).
sat(course_id_12,student_id_24,sat_1).
sat(course_id_12,student_id_26,sat_3).
sat(course_id_12,student_id_28,sat_2).
sat(course_id_12,student_id_33,sat_3).
sat(course_id_12,student_id_37,sat_3).
sat(course_id_13,student_id_7,sat_1).
sat(course_id_13,student_id_14,sat_2).
sat(course_id_13,student_id_16,sat_2).
sat(course_id_13,student_id_21,sat_2).
sat(course_id_13,student_id_26,sat_3).
sat(course_id_13,student_id_27,sat_2).
sat(course_id_13,student_id_33,sat_3).
sat(course_id_13,student_id_37,sat_3).
sat(course_id_13,student_id_41,sat_2).
intelligence(student_id_4,intelligence_3).
intelligence(student_id_5,intelligence_3).
intelligence(student_id_6,intelligence_3).
intelligence(student_id_7,intelligence_3).
intelligence(student_id_8,intelligence_3).
intelligence(student_id_9,intelligence_3).
intelligence(student_id_10,intelligence_3).
intelligence(student_id_11,intelligence_3).
intelligence(student_id_12,intelligence_2).
intelligence(student_id_13,intelligence_2).
intelligence(student_id_14,intelligence_2).
intelligence(student_id_15,intelligence_2).
intelligence(student_id_16,intelligence_2).
intelligence(student_id_17,intelligence_2).
intelligence(student_id_18,intelligence_2).
intelligence(student_id_19,intelligence_2).
intelligence(student_id_20,intelligence_2).
intelligence(student_id_21,intelligence_2).
intelligence(student_id_22,intelligence_2).
intelligence(student_id_23,intelligence_2).
intelligence(student_id_24,intelligence_2).
intelligence(student_id_25,intelligence_1).
intelligence(student_id_26,intelligence_1).
intelligence(student_id_27,intelligence_1).
intelligence(student_id_28,intelligence_1).
intelligence(student_id_29,intelligence_1).
intelligence(student_id_30,intelligence_1).
intelligence(student_id_31,intelligence_1).
intelligence(student_id_32,intelligence_1).
intelligence(student_id_33,intelligence_1).
intelligence(student_id_34,intelligence_1).
intelligence(student_id_35,intelligence_1).
intelligence(student_id_36,intelligence_1).
intelligence(student_id_37,intelligence_1).
intelligence(student_id_38,intelligence_1).
intelligence(student_id_39,intelligence_3).
intelligence(student_id_40,intelligence_3).
intelligence(student_id_41,intelligence_3).
ranking(student_id_4,ranking_1).
ranking(student_id_5,ranking_1).
ranking(student_id_6,ranking_2).
ranking(student_id_7,ranking_1).
ranking(student_id_8,ranking_1).
ranking(student_id_9,ranking_2).
ranking(student_id_10,ranking_1).
ranking(student_id_11,ranking_2).
ranking(student_id_12,ranking_2).
ranking(student_id_13,ranking_2).
ranking(student_id_14,ranking_2).
ranking(student_id_15,ranking_3).
ranking(student_id_16,ranking_3).
ranking(student_id_17,ranking_3).
ranking(student_id_18,ranking_3).
ranking(student_id_19,ranking_3).
ranking(student_id_20,ranking_3).
ranking(student_id_21,ranking_2).
ranking(student_id_22,ranking_4).
ranking(student_id_23,ranking_3).
ranking(student_id_24,ranking_2).
ranking(student_id_25,ranking_4).
ranking(student_id_26,ranking_4).
ranking(student_id_27,ranking_4).
ranking(student_id_28,ranking_4).
ranking(student_id_29,ranking_5).
ranking(student_id_30,ranking_5).
ranking(student_id_31,ranking_5).
ranking(student_id_32,ranking_5).
ranking(student_id_33,ranking_5).
ranking(student_id_34,ranking_4).
ranking(student_id_35,ranking_4).
ranking(student_id_36,ranking_5).
ranking(student_id_37,ranking_5).
ranking(student_id_38,ranking_5).
ranking(student_id_39,ranking_1).
ranking(student_id_40,ranking_1).
ranking(student_id_41,ranking_1).
b_registration(course_id_4,student_id_4).
b_registration(course_id_4,student_id_6).
b_registration(course_id_4,student_id_7).
b_registration(course_id_4,student_id_12).
b_registration(course_id_4,student_id_18).
b_registration(course_id_4,student_id_29).
b_registration(course_id_4,student_id_38).
b_registration(course_id_4,student_id_40).
b_registration(course_id_5,student_id_4).
b_registration(course_id_5,student_id_5).
b_registration(course_id_5,student_id_6).
b_registration(course_id_5,student_id_15).
b_registration(course_id_5,student_id_18).
b_registration(course_id_5,student_id_25).
b_registration(course_id_5,student_id_29).
b_registration(course_id_5,student_id_34).
b_registration(course_id_5,student_id_38).
b_registration(course_id_5,student_id_39).
b_registration(course_id_5,student_id_41).
b_registration(course_id_6,student_id_4).
b_registration(course_id_6,student_id_6).
b_registration(course_id_6,student_id_7).
b_registration(course_id_6,student_id_9).
b_registration(course_id_6,student_id_13).
b_registration(course_id_6,student_id_19).
b_registration(course_id_6,student_id_25).
b_registration(course_id_6,student_id_30).
b_registration(course_id_6,student_id_41).
b_registration(course_id_7,student_id_4).
b_registration(course_id_7,student_id_5).
b_registration(course_id_7,student_id_9).
b_registration(course_id_7,student_id_15).
b_registration(course_id_7,student_id_20).
b_registration(course_id_7,student_id_30).
b_registration(course_id_7,student_id_40).
b_registration(course_id_8,student_id_5).
b_registration(course_id_8,student_id_6).
b_registration(course_id_8,student_id_9).
b_registration(course_id_8,student_id_10).
b_registration(course_id_8,student_id_11).
b_registration(course_id_8,student_id_14).
b_registration(course_id_8,student_id_20).
b_registration(course_id_8,student_id_22).
b_registration(course_id_8,student_id_30).
b_registration(course_id_8,student_id_41).
b_registration(course_id_9,student_id_6).
b_registration(course_id_9,student_id_10).
b_registration(course_id_9,student_id_12).
b_registration(course_id_9,student_id_15).
b_registration(course_id_9,student_id_23).
b_registration(course_id_9,student_id_31).
b_registration(course_id_9,student_id_33).
b_registration(course_id_9,student_id_35).
b_registration(course_id_10,student_id_6).
b_registration(course_id_10,student_id_11).
b_registration(course_id_10,student_id_14).
b_registration(course_id_10,student_id_17).
b_registration(course_id_10,student_id_18).
b_registration(course_id_10,student_id_23).
b_registration(course_id_10,student_id_32).
b_registration(course_id_10,student_id_36).
b_registration(course_id_11,student_id_7).
b_registration(course_id_11,student_id_8).
b_registration(course_id_11,student_id_14).
b_registration(course_id_11,student_id_16).
b_registration(course_id_11,student_id_17).
b_registration(course_id_11,student_id_23).
b_registration(course_id_11,student_id_28).
b_registration(course_id_11,student_id_32).
b_registration(course_id_11,student_id_37).
b_registration(course_id_11,student_id_41).
b_registration(course_id_12,student_id_8).
b_registration(course_id_12,student_id_10).
b_registration(course_id_12,student_id_11).
b_registration(course_id_12,student_id_17).
b_registration(course_id_12,student_id_21).
b_registration(course_id_12,student_id_22).
b_registration(course_id_12,student_id_23).
b_registration(course_id_12,student_id_24).
b_registration(course_id_12,student_id_26).
b_registration(course_id_12,student_id_28).
b_registration(course_id_12,student_id_33).
b_registration(course_id_12,student_id_37).
b_registration(course_id_13,student_id_7).
b_registration(course_id_13,student_id_14).
b_registration(course_id_13,student_id_16).
b_registration(course_id_13,student_id_21).
b_registration(course_id_13,student_id_26).
b_registration(course_id_13,student_id_27).
b_registration(course_id_13,student_id_33).
b_registration(course_id_13,student_id_37).
b_registration(course_id_13,student_id_41).
b_ra(prof_id_5,student_id_5).
b_ra(prof_id_6,student_id_5).
b_ra(prof_id_7,student_id_7).
b_ra(prof_id_7,student_id_8).
b_ra(prof_id_6,student_id_8).
b_ra(prof_id_6,student_id_9).
b_ra(prof_id_9,student_id_10).
b_ra(prof_id_7,student_id_11).
b_ra(prof_id_8,student_id_12).
b_ra(prof_id_8,student_id_13).
b_ra(prof_id_5,student_id_14).
b_ra(prof_id_6,student_id_15).
b_ra(prof_id_6,student_id_16).
b_ra(prof_id_4,student_id_17).
b_ra(prof_id_5,student_id_18).
b_ra(prof_id_7,student_id_19).
b_ra(prof_id_7,student_id_20).
b_ra(prof_id_8,student_id_21).
b_ra(prof_id_7,student_id_22).
b_ra(prof_id_6,student_id_23).
b_ra(prof_id_6,student_id_24).
b_ra(prof_id_6,student_id_25).
b_ra(prof_id_5,student_id_26).
b_ra(prof_id_5,student_id_27).
b_ra(prof_id_5,student_id_28).
rating(course_id_13,rating_1).
rating(course_id_7,rating_2).
neg(rating(course_id_13,rating_2)).
neg(rating(course_id_7,rating_1)).
end_mod(model(f4)).
begin(model(f5)).
capability(prof_id_5,student_id_5,capability_1).
capability(prof_id_6,student_id_5,capability_2).
capability(prof_id_7,student_id_7,capability_4).
capability(prof_id_7,student_id_8,capability_4).
capability(prof_id_6,student_id_8,capability_4).
capability(prof_id_6,student_id_9,capability_4).
capability(prof_id_9,student_id_10,capability_3).
capability(prof_id_7,student_id_11,capability_1).
capability(prof_id_8,student_id_12,capability_1).
capability(prof_id_8,student_id_13,capability_2).
capability(prof_id_5,student_id_14,capability_2).
capability(prof_id_6,student_id_15,capability_1).
capability(prof_id_6,student_id_16,capability_2).
capability(prof_id_4,student_id_17,capability_3).
capability(prof_id_5,student_id_18,capability_3).
capability(prof_id_7,student_id_19,capability_5).
capability(prof_id_7,student_id_20,capability_1).
capability(prof_id_8,student_id_21,capability_3).
capability(prof_id_7,student_id_22,capability_3).
capability(prof_id_6,student_id_23,capability_5).
capability(prof_id_6,student_id_24,capability_5).
capability(prof_id_6,student_id_25,capability_5).
capability(prof_id_5,student_id_26,capability_4).
capability(prof_id_5,student_id_27,capability_3).
capability(prof_id_5,student_id_28,capability_3).
salary(prof_id_5,student_id_5,salary_low).
salary(prof_id_6,student_id_5,salary_low).
salary(prof_id_7,student_id_7,salary_high).
salary(prof_id_7,student_id_8,salary_high).
salary(prof_id_6,student_id_8,salary_high).
salary(prof_id_6,student_id_9,salary_high).
salary(prof_id_9,student_id_10,salary_high).
salary(prof_id_7,student_id_11,salary_med).
salary(prof_id_8,student_id_12,salary_med).
salary(prof_id_8,student_id_13,salary_med).
salary(prof_id_5,student_id_14,salary_low).
salary(prof_id_6,student_id_15,salary_med).
salary(prof_id_6,student_id_16,salary_med).
salary(prof_id_4,student_id_17,salary_med).
salary(prof_id_5,student_id_18,salary_high).
salary(prof_id_7,student_id_19,salary_high).
salary(prof_id_7,student_id_20,salary_low).
salary(prof_id_8,student_id_21,salary_low).
salary(prof_id_7,student_id_22,salary_med).
salary(prof_id_6,student_id_23,salary_high).
salary(prof_id_6,student_id_24,salary_high).
salary(prof_id_6,student_id_25,salary_high).
salary(prof_id_5,student_id_26,salary_high).
salary(prof_id_5,student_id_27,salary_med).
salary(prof_id_5,student_id_28,salary_med).
diff(course_id_4,diff_1).
diff(course_id_5,diff_2).
diff(course_id_6,diff_1).
diff(course_id_7,diff_2).
diff(course_id_8,diff_1).
diff(course_id_9,diff_2).
diff(course_id_10,diff_1).
diff(course_id_11,diff_2).
diff(course_id_12,diff_1).
diff(course_id_13,diff_2).
popularity(prof_id_4,popularity_2).
popularity(prof_id_5,popularity_2).
popularity(prof_id_6,popularity_2).
popularity(prof_id_7,popularity_2).
popularity(prof_id_8,popularity_1).
popularity(prof_id_9,popularity_1).
teachingability(prof_id_4,teachingability_3).
teachingability(prof_id_5,teachingability_3).
teachingability(prof_id_6,teachingability_3).
teachingability(prof_id_7,teachingability_2).
teachingability(prof_id_8,teachingability_2).
teachingability(prof_id_9,teachingability_2).
grade(course_id_4,student_id_4,grade_1).
grade(course_id_4,student_id_6,grade_1).
grade(course_id_4,student_id_7,grade_1).
grade(course_id_4,student_id_12,grade_2).
grade(course_id_4,student_id_18,grade_2).
grade(course_id_4,student_id_29,grade_3).
grade(course_id_4,student_id_38,grade_4).
grade(course_id_4,student_id_40,grade_1).
grade(course_id_5,student_id_4,grade_1).
grade(course_id_5,student_id_5,grade_2).
grade(course_id_5,student_id_6,grade_2).
grade(course_id_5,student_id_15,grade_2).
grade(course_id_5,student_id_18,grade_3).
grade(course_id_5,student_id_25,grade_3).
grade(course_id_5,student_id_29,grade_4).
grade(course_id_5,student_id_34,grade_3).
grade(course_id_5,student_id_38,grade_4).
grade(course_id_5,student_id_39,grade_1).
grade(course_id_5,student_id_41,grade_1).
grade(course_id_6,student_id_4,grade_1).
grade(course_id_6,student_id_6,grade_1).
grade(course_id_6,student_id_7,grade_1).
grade(course_id_6,student_id_9,grade_1).
grade(course_id_6,student_id_13,grade_1).
grade(course_id_6,student_id_19,grade_2).
grade(course_id_6,student_id_25,grade_3).
grade(course_id_6,student_id_30,grade_4).
grade(course_id_6,student_id_41,grade_1).
grade(course_id_7,student_id_4,grade_2).
grade(course_id_7,student_id_5,grade_2).
grade(course_id_7,student_id_9,grade_2).
grade(course_id_7,student_id_15,grade_2).
grade(course_id_7,student_id_20,grade_2).
grade(course_id_7,student_id_30,grade_4).
grade(course_id_7,student_id_40,grade_1).
grade(course_id_8,student_id_5,grade_1).
grade(course_id_8,student_id_6,grade_1).
grade(course_id_8,student_id_9,grade_1).
grade(course_id_8,student_id_10,grade_1).
grade(course_id_8,student_id_11,grade_2).
grade(course_id_8,student_id_14,grade_1).
grade(course_id_8,student_id_20,grade_3).
grade(course_id_8,student_id_22,grade_3).
grade(course_id_8,student_id_30,grade_4).
grade(course_id_8,student_id_41,grade_1).
grade(course_id_9,student_id_6,grade_1).
grade(course_id_9,student_id_10,grade_2).
grade(course_id_9,student_id_12,grade_2).
grade(course_id_9,student_id_15,grade_2).
grade(course_id_9,student_id_23,grade_2).
grade(course_id_9,student_id_31,grade_3).
grade(course_id_9,student_id_33,grade_3).
grade(course_id_9,student_id_35,grade_3).
grade(course_id_10,student_id_6,grade_1).
grade(course_id_10,student_id_11,grade_1).
grade(course_id_10,student_id_14,grade_1).
grade(course_id_10,student_id_17,grade_3).
grade(course_id_10,student_id_18,grade_1).
grade(course_id_10,student_id_23,grade_2).
grade(course_id_10,student_id_32,grade_3).
grade(course_id_10,student_id_36,grade_4).
grade(course_id_11,student_id_7,grade_2).
grade(course_id_11,student_id_8,grade_1).
grade(course_id_11,student_id_14,grade_2).
grade(course_id_11,student_id_16,grade_2).
grade(course_id_11,student_id_17,grade_2).
grade(course_id_11,student_id_23,grade_3).
grade(course_id_11,student_id_28,grade_4).
grade(course_id_11,student_id_32,grade_4).
grade(course_id_11,student_id_37,grade_3).
grade(course_id_11,student_id_41,grade_2).
grade(course_id_12,student_id_8,grade_1).
grade(course_id_12,student_id_10,grade_1).
grade(course_id_12,student_id_11,grade_1).
grade(course_id_12,student_id_17,grade_2).
grade(course_id_12,student_id_21,grade_1).
grade(course_id_12,student_id_22,grade_2).
grade(course_id_12,student_id_23,grade_1).
grade(course_id_12,student_id_24,grade_1).
grade(course_id_12,student_id_26,grade_2).
grade(course_id_12,student_id_28,grade_3).
grade(course_id_12,student_id_33,grade_4).
grade(course_id_12,student_id_37,grade_4).
grade(course_id_13,student_id_7,grade_2).
grade(course_id_13,student_id_14,grade_2).
grade(course_id_13,student_id_16,grade_3).
grade(course_id_13,student_id_21,grade_2).
grade(course_id_13,student_id_26,grade_3).
grade(course_id_13,student_id_27,grade_3).
grade(course_id_13,student_id_33,grade_4).
grade(course_id_13,student_id_37,grade_4).
grade(course_id_13,student_id_41,grade_2).
sat(course_id_4,student_id_4,sat_1).
sat(course_id_4,student_id_6,sat_1).
sat(course_id_4,student_id_7,sat_1).
sat(course_id_4,student_id_12,sat_2).
sat(course_id_4,student_id_18,sat_2).
sat(course_id_4,student_id_29,sat_2).
sat(course_id_4,student_id_38,sat_3).
sat(course_id_4,student_id_40,sat_1).
sat(course_id_5,student_id_4,sat_1).
sat(course_id_5,student_id_5,sat_2).
sat(course_id_5,student_id_6,sat_2).
sat(course_id_5,student_id_15,sat_1).
sat(course_id_5,student_id_18,sat_2).
sat(course_id_5,student_id_25,sat_2).
sat(course_id_5,student_id_29,sat_3).
sat(course_id_5,student_id_34,sat_2).
sat(course_id_5,student_id_38,sat_3).
sat(course_id_5,student_id_39,sat_1).
sat(course_id_5,student_id_41,sat_1).
sat(course_id_6,student_id_4,sat_1).
sat(course_id_6,student_id_6,sat_1).
sat(course_id_6,student_id_7,sat_1).
sat(course_id_6,student_id_9,sat_1).
sat(course_id_6,student_id_13,sat_1).
sat(course_id_6,student_id_19,sat_3).
sat(course_id_6,student_id_25,sat_3).
sat(course_id_6,student_id_30,sat_3).
sat(course_id_6,student_id_41,sat_1).
sat(course_id_7,student_id_4,sat_1).
sat(course_id_7,student_id_5,sat_2).
sat(course_id_7,student_id_9,sat_2).
sat(course_id_7,student_id_15,sat_1).
sat(course_id_7,student_id_20,sat_2).
sat(course_id_7,student_id_30,sat_3).
sat(course_id_7,student_id_40,sat_1).
sat(course_id_8,student_id_5,sat_1).
sat(course_id_8,student_id_6,sat_1).
sat(course_id_8,student_id_9,sat_2).
sat(course_id_8,student_id_10,sat_1).
sat(course_id_8,student_id_11,sat_2).
sat(course_id_8,student_id_14,sat_1).
sat(course_id_8,student_id_20,sat_3).
sat(course_id_8,student_id_22,sat_2).
sat(course_id_8,student_id_30,sat_3).
sat(course_id_8,student_id_41,sat_1).
sat(course_id_9,student_id_6,sat_1).
sat(course_id_9,student_id_10,sat_2).
sat(course_id_9,student_id_12,sat_1).
sat(course_id_9,student_id_15,sat_1).
sat(course_id_9,student_id_23,sat_2).
sat(course_id_9,student_id_31,sat_2).
sat(course_id_9,student_id_33,sat_2).
sat(course_id_9,student_id_35,sat_2).
sat(course_id_10,student_id_6,sat_1).
sat(course_id_10,student_id_11,sat_2).
sat(course_id_10,student_id_14,sat_1).
sat(course_id_10,student_id_17,sat_3).
sat(course_id_10,student_id_18,sat_1).
sat(course_id_10,student_id_23,sat_1).
sat(course_id_10,student_id_32,sat_2).
sat(course_id_10,student_id_36,sat_3).
sat(course_id_11,student_id_7,sat_1).
sat(course_id_11,student_id_8,sat_1).
sat(course_id_11,student_id_14,sat_1).
sat(course_id_11,student_id_16,sat_1).
sat(course_id_11,student_id_17,sat_1).
sat(course_id_11,student_id_23,sat_3).
sat(course_id_11,student_id_28,sat_3).
sat(course_id_11,student_id_32,sat_3).
sat(course_id_11,student_id_37,sat_3).
sat(course_id_11,student_id_41,sat_2).
sat(course_id_12,student_id_8,sat_1).
sat(course_id_12,student_id_10,sat_1).
sat(course_id_12,student_id_11,sat_2).
sat(course_id_12,student_id_17,sat_2).
sat(course_id_12,student_id_21,sat_1).
sat(course_id_12,student_id_22,sat_1).
sat(course_id_12,student_id_23,sat_1).
sat(course_id_12,student_id_24,sat_1).
sat(course_id_12,student_id_26,sat_3).
sat(course_id_12,student_id_28,sat_2).
sat(course_id_12,student_id_33,sat_3).
sat(course_id_12,student_id_37,sat_3).
sat(course_id_13,student_id_7,sat_1).
sat(course_id_13,student_id_14,sat_2).
sat(course_id_13,student_id_16,sat_2).
sat(course_id_13,student_id_21,sat_2).
sat(course_id_13,student_id_26,sat_3).
sat(course_id_13,student_id_27,sat_2).
sat(course_id_13,student_id_33,sat_3).
sat(course_id_13,student_id_37,sat_3).
sat(course_id_13,student_id_41,sat_2).
intelligence(student_id_4,intelligence_3).
intelligence(student_id_5,intelligence_3).
intelligence(student_id_6,intelligence_3).
intelligence(student_id_7,intelligence_3).
intelligence(student_id_8,intelligence_3).
intelligence(student_id_9,intelligence_3).
intelligence(student_id_10,intelligence_3).
intelligence(student_id_11,intelligence_3).
intelligence(student_id_12,intelligence_2).
intelligence(student_id_13,intelligence_2).
intelligence(student_id_14,intelligence_2).
intelligence(student_id_15,intelligence_2).
intelligence(student_id_16,intelligence_2).
intelligence(student_id_17,intelligence_2).
intelligence(student_id_18,intelligence_2).
intelligence(student_id_19,intelligence_2).
intelligence(student_id_20,intelligence_2).
intelligence(student_id_21,intelligence_2).
intelligence(student_id_22,intelligence_2).
intelligence(student_id_23,intelligence_2).
intelligence(student_id_24,intelligence_2).
intelligence(student_id_25,intelligence_1).
intelligence(student_id_26,intelligence_1).
intelligence(student_id_27,intelligence_1).
intelligence(student_id_28,intelligence_1).
intelligence(student_id_29,intelligence_1).
intelligence(student_id_30,intelligence_1).
intelligence(student_id_31,intelligence_1).
intelligence(student_id_32,intelligence_1).
intelligence(student_id_33,intelligence_1).
intelligence(student_id_34,intelligence_1).
intelligence(student_id_35,intelligence_1).
intelligence(student_id_36,intelligence_1).
intelligence(student_id_37,intelligence_1).
intelligence(student_id_38,intelligence_1).
intelligence(student_id_39,intelligence_3).
intelligence(student_id_40,intelligence_3).
intelligence(student_id_41,intelligence_3).
ranking(student_id_4,ranking_1).
ranking(student_id_5,ranking_1).
ranking(student_id_6,ranking_2).
ranking(student_id_7,ranking_1).
ranking(student_id_8,ranking_1).
ranking(student_id_9,ranking_2).
ranking(student_id_10,ranking_1).
ranking(student_id_11,ranking_2).
ranking(student_id_12,ranking_2).
ranking(student_id_13,ranking_2).
ranking(student_id_14,ranking_2).
ranking(student_id_15,ranking_3).
ranking(student_id_16,ranking_3).
ranking(student_id_17,ranking_3).
ranking(student_id_18,ranking_3).
ranking(student_id_19,ranking_3).
ranking(student_id_20,ranking_3).
ranking(student_id_21,ranking_2).
ranking(student_id_22,ranking_4).
ranking(student_id_23,ranking_3).
ranking(student_id_24,ranking_2).
ranking(student_id_25,ranking_4).
ranking(student_id_26,ranking_4).
ranking(student_id_27,ranking_4).
ranking(student_id_28,ranking_4).
ranking(student_id_29,ranking_5).
ranking(student_id_30,ranking_5).
ranking(student_id_31,ranking_5).
ranking(student_id_32,ranking_5).
ranking(student_id_33,ranking_5).
ranking(student_id_34,ranking_4).
ranking(student_id_35,ranking_4).
ranking(student_id_36,ranking_5).
ranking(student_id_37,ranking_5).
ranking(student_id_38,ranking_5).
ranking(student_id_39,ranking_1).
ranking(student_id_40,ranking_1).
ranking(student_id_41,ranking_1).
b_registration(course_id_4,student_id_4).
b_registration(course_id_4,student_id_6).
b_registration(course_id_4,student_id_7).
b_registration(course_id_4,student_id_12).
b_registration(course_id_4,student_id_18).
b_registration(course_id_4,student_id_29).
b_registration(course_id_4,student_id_38).
b_registration(course_id_4,student_id_40).
b_registration(course_id_5,student_id_4).
b_registration(course_id_5,student_id_5).
b_registration(course_id_5,student_id_6).
b_registration(course_id_5,student_id_15).
b_registration(course_id_5,student_id_18).
b_registration(course_id_5,student_id_25).
b_registration(course_id_5,student_id_29).
b_registration(course_id_5,student_id_34).
b_registration(course_id_5,student_id_38).
b_registration(course_id_5,student_id_39).
b_registration(course_id_5,student_id_41).
b_registration(course_id_6,student_id_4).
b_registration(course_id_6,student_id_6).
b_registration(course_id_6,student_id_7).
b_registration(course_id_6,student_id_9).
b_registration(course_id_6,student_id_13).
b_registration(course_id_6,student_id_19).
b_registration(course_id_6,student_id_25).
b_registration(course_id_6,student_id_30).
b_registration(course_id_6,student_id_41).
b_registration(course_id_7,student_id_4).
b_registration(course_id_7,student_id_5).
b_registration(course_id_7,student_id_9).
b_registration(course_id_7,student_id_15).
b_registration(course_id_7,student_id_20).
b_registration(course_id_7,student_id_30).
b_registration(course_id_7,student_id_40).
b_registration(course_id_8,student_id_5).
b_registration(course_id_8,student_id_6).
b_registration(course_id_8,student_id_9).
b_registration(course_id_8,student_id_10).
b_registration(course_id_8,student_id_11).
b_registration(course_id_8,student_id_14).
b_registration(course_id_8,student_id_20).
b_registration(course_id_8,student_id_22).
b_registration(course_id_8,student_id_30).
b_registration(course_id_8,student_id_41).
b_registration(course_id_9,student_id_6).
b_registration(course_id_9,student_id_10).
b_registration(course_id_9,student_id_12).
b_registration(course_id_9,student_id_15).
b_registration(course_id_9,student_id_23).
b_registration(course_id_9,student_id_31).
b_registration(course_id_9,student_id_33).
b_registration(course_id_9,student_id_35).
b_registration(course_id_10,student_id_6).
b_registration(course_id_10,student_id_11).
b_registration(course_id_10,student_id_14).
b_registration(course_id_10,student_id_17).
b_registration(course_id_10,student_id_18).
b_registration(course_id_10,student_id_23).
b_registration(course_id_10,student_id_32).
b_registration(course_id_10,student_id_36).
b_registration(course_id_11,student_id_7).
b_registration(course_id_11,student_id_8).
b_registration(course_id_11,student_id_14).
b_registration(course_id_11,student_id_16).
b_registration(course_id_11,student_id_17).
b_registration(course_id_11,student_id_23).
b_registration(course_id_11,student_id_28).
b_registration(course_id_11,student_id_32).
b_registration(course_id_11,student_id_37).
b_registration(course_id_11,student_id_41).
b_registration(course_id_12,student_id_8).
b_registration(course_id_12,student_id_10).
b_registration(course_id_12,student_id_11).
b_registration(course_id_12,student_id_17).
b_registration(course_id_12,student_id_21).
b_registration(course_id_12,student_id_22).
b_registration(course_id_12,student_id_23).
b_registration(course_id_12,student_id_24).
b_registration(course_id_12,student_id_26).
b_registration(course_id_12,student_id_28).
b_registration(course_id_12,student_id_33).
b_registration(course_id_12,student_id_37).
b_registration(course_id_13,student_id_7).
b_registration(course_id_13,student_id_14).
b_registration(course_id_13,student_id_16).
b_registration(course_id_13,student_id_21).
b_registration(course_id_13,student_id_26).
b_registration(course_id_13,student_id_27).
b_registration(course_id_13,student_id_33).
b_registration(course_id_13,student_id_37).
b_registration(course_id_13,student_id_41).
b_ra(prof_id_5,student_id_5).
b_ra(prof_id_6,student_id_5).
b_ra(prof_id_7,student_id_7).
b_ra(prof_id_7,student_id_8).
b_ra(prof_id_6,student_id_8).
b_ra(prof_id_6,student_id_9).
b_ra(prof_id_9,student_id_10).
b_ra(prof_id_7,student_id_11).
b_ra(prof_id_8,student_id_12).
b_ra(prof_id_8,student_id_13).
b_ra(prof_id_5,student_id_14).
b_ra(prof_id_6,student_id_15).
b_ra(prof_id_6,student_id_16).
b_ra(prof_id_4,student_id_17).
b_ra(prof_id_5,student_id_18).
b_ra(prof_id_7,student_id_19).
b_ra(prof_id_7,student_id_20).
b_ra(prof_id_8,student_id_21).
b_ra(prof_id_7,student_id_22).
b_ra(prof_id_6,student_id_23).
b_ra(prof_id_6,student_id_24).
b_ra(prof_id_6,student_id_25).
b_ra(prof_id_5,student_id_26).
b_ra(prof_id_5,student_id_27).
b_ra(prof_id_5,student_id_28).
rating(course_id_10,rating_2).
rating(course_id_5,rating_2).
neg(rating(course_id_10,rating_1)).
neg(rating(course_id_5,rating_1)).
end_mod(model(f5)).
