/*******************************************************************************
 * Copyright (c) Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0 
 *******************************************************************************/

package org.osgi.service.zigbee.descriptions;

/**
 * This interface represents a ZigBee device description.
 * 
 * @author $Id: d9b14c3b72929cccfe87e787624d3efd402bc628 $
 */
public interface ZigBeeDeviceDescription {

	/**
	 * Returns the device identifier.
	 * 
	 * @return the device identifier.
	 */
	public int getId();

	/**
	 * Returns the device name.
	 * 
	 * @return the device name.
	 */
	public String getName();

	/**
	 * Returns the device version.
	 * 
	 * @return the device version.
	 */
	public Integer getVersion();

	/**
	 * Returns the profile identifier.
	 * 
	 * @return the profile identifier.
	 */
	public int getProfileId();

	/**
	 * Returns an array of server cluster descriptions.
	 * 
	 * @return an array of server cluster descriptions.
	 */
	public ZCLClusterDescription[] getServerClustersDescriptions();

	/**
	 * Returns an array of client cluster descriptions.
	 * 
	 * @return an array of client cluster descriptions.
	 */
	public ZCLClusterDescription[] getClientClustersDescriptions();

}
