// This file is part of Desktop App Toolkit,
// a set of libraries for developing nice desktop applications.
//
// For license and copyright information please follow this link:
// https://github.com/desktop-app/legal/blob/master/LEGAL
//
#pragma once

#include <crl/common/crl_common_config.h>

#include <crl/common/crl_common_queue.h>
#include <atomic>

#ifndef CRL_USE_COMMON_QUEUE
#define CRL_USE_COMMON_QUEUE
#endif // !CRL_USE_COMMON_QUEUE

namespace crl::details {

extern queue *MainQueue;
extern std::atomic<int> MainQueueCounter;

class main_queue_pointer {
public:
	main_queue_pointer() {
		grab();
	}

	void create(main_queue_processor processor);

	explicit operator bool() const {
		return _pointer != nullptr;
	}

	queue *operator->() const {
		return _pointer;
	}

	~main_queue_pointer() {
		ungrab();
	}

private:
	void grab();
	void ungrab();

	queue *_pointer = nullptr;

};

} // namespace crl::details

namespace crl {

void init_main_queue(main_queue_processor processor);

inline void wrap_main_queue(main_queue_wrapper wrapper) {
	// If wrapping is needed here, it can be done inside processor.
}

template <typename Callable>
inline void on_main(Callable &&callable) {
	if (const auto main = details::main_queue_pointer()) {
		main->async(std::forward<Callable>(callable));
	}
}

template <typename Callable>
inline void on_main_sync(Callable &&callable) {
	if (const auto main = details::main_queue_pointer()) {
		main->sync(std::forward<Callable>(callable));
	}
}

} // namespace crl
