/* -*- Mode: C++; c-basic-offset: 2; tab-width: 2; indent-tabs-mode: nil -*-
 * 
 * Quadra, an action puzzle game
 * Copyright (C) 1998-2000  Ludus Design
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "stringtable.h"

#include <memory.h>
#include <stdio.h>
#include <stdlib.h>

Stringtable *stringtable = NULL;

Stringtable::Stringtable(const ResName& nam) {
	mustfree=true;
	Res_doze res(nam);
	buf = new char[res.size()+1];
	memcpy(buf, res.buf(), res.size());
	parse(buf, res.size());
}

Stringtable::Stringtable(uint8_t *b, uint32_t size) {
	mustfree=false;
	parse((char *)b, size);
}

void Stringtable::parse(char *buf, uint32_t size) {
	uint32_t ptr;
	int index;

	ptr = 0;
	num = 0;

	while(ptr < size) {
		if(buf[ptr] == 10)
			num++;
		ptr++;
	}

	/* the == 13 && != 10 is to prevent losing a single char line */
	if((buf[size-1] != 10) ||
		 (buf[size-1] == 13 &&
			buf[size-2] != 10))
		num++;

	/* with a fence, so that we don't segfault */
	buf[size] = 0;

	table = new char*[num];

	ptr = 0;
	index = 0;

	while(index < num) {
		table[index] = &buf[ptr];

		while(ptr < size) {
			if(buf[ptr] == 10) { // for UNIX (just a '10')
				buf[ptr] = 0;
				ptr++;
				break;
			}
			if(buf[ptr] == 13) { // for DOZE (a '13', THEN a '10')
				buf[ptr] = 0;
				ptr++;
				if((ptr < size) && (buf[ptr] == 10)) {
					buf[ptr] = 0;
					ptr++;
				}
				break;
			}
			ptr++;
		}
		index++;
	}
}

Stringtable::~Stringtable() {
	delete[] table;
	if(mustfree)
		delete[] buf;
}
