/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha2

import (
	v1alpha2 "k8s.io/api/resource/v1alpha2"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PodSchedulingContextLister helps list PodSchedulingContexts.
// All objects returned here must be treated as read-only.
type PodSchedulingContextLister interface {
	// List lists all PodSchedulingContexts in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha2.PodSchedulingContext, err error)
	// PodSchedulingContexts returns an object that can list and get PodSchedulingContexts.
	PodSchedulingContexts(namespace string) PodSchedulingContextNamespaceLister
	PodSchedulingContextListerExpansion
}

// podSchedulingContextLister implements the PodSchedulingContextLister interface.
type podSchedulingContextLister struct {
	indexer cache.Indexer
}

// NewPodSchedulingContextLister returns a new PodSchedulingContextLister.
func NewPodSchedulingContextLister(indexer cache.Indexer) PodSchedulingContextLister {
	return &podSchedulingContextLister{indexer: indexer}
}

// List lists all PodSchedulingContexts in the indexer.
func (s *podSchedulingContextLister) List(selector labels.Selector) (ret []*v1alpha2.PodSchedulingContext, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha2.PodSchedulingContext))
	})
	return ret, err
}

// PodSchedulingContexts returns an object that can list and get PodSchedulingContexts.
func (s *podSchedulingContextLister) PodSchedulingContexts(namespace string) PodSchedulingContextNamespaceLister {
	return podSchedulingContextNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PodSchedulingContextNamespaceLister helps list and get PodSchedulingContexts.
// All objects returned here must be treated as read-only.
type PodSchedulingContextNamespaceLister interface {
	// List lists all PodSchedulingContexts in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha2.PodSchedulingContext, err error)
	// Get retrieves the PodSchedulingContext from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha2.PodSchedulingContext, error)
	PodSchedulingContextNamespaceListerExpansion
}

// podSchedulingContextNamespaceLister implements the PodSchedulingContextNamespaceLister
// interface.
type podSchedulingContextNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PodSchedulingContexts in the indexer for a given namespace.
func (s podSchedulingContextNamespaceLister) List(selector labels.Selector) (ret []*v1alpha2.PodSchedulingContext, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha2.PodSchedulingContext))
	})
	return ret, err
}

// Get retrieves the PodSchedulingContext from the indexer for a given namespace and name.
func (s podSchedulingContextNamespaceLister) Get(name string) (*v1alpha2.PodSchedulingContext, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha2.Resource("podschedulingcontext"), name)
	}
	return obj.(*v1alpha2.PodSchedulingContext), nil
}
