// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllTCPCheckBackendOKCode is the HTTP code returned for type ReplaceAllTCPCheckBackendOK
const ReplaceAllTCPCheckBackendOKCode int = 200

/*
ReplaceAllTCPCheckBackendOK All TCP Check lines replaced

swagger:response replaceAllTcpCheckBackendOK
*/
type ReplaceAllTCPCheckBackendOK struct {

	/*
	  In: Body
	*/
	Payload models.TCPChecks `json:"body,omitempty"`
}

// NewReplaceAllTCPCheckBackendOK creates ReplaceAllTCPCheckBackendOK with default headers values
func NewReplaceAllTCPCheckBackendOK() *ReplaceAllTCPCheckBackendOK {

	return &ReplaceAllTCPCheckBackendOK{}
}

// WithPayload adds the payload to the replace all Tcp check backend o k response
func (o *ReplaceAllTCPCheckBackendOK) WithPayload(payload models.TCPChecks) *ReplaceAllTCPCheckBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp check backend o k response
func (o *ReplaceAllTCPCheckBackendOK) SetPayload(payload models.TCPChecks) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPCheckBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPChecks{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllTCPCheckBackendAcceptedCode is the HTTP code returned for type ReplaceAllTCPCheckBackendAccepted
const ReplaceAllTCPCheckBackendAcceptedCode int = 202

/*
ReplaceAllTCPCheckBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAllTcpCheckBackendAccepted
*/
type ReplaceAllTCPCheckBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.TCPChecks `json:"body,omitempty"`
}

// NewReplaceAllTCPCheckBackendAccepted creates ReplaceAllTCPCheckBackendAccepted with default headers values
func NewReplaceAllTCPCheckBackendAccepted() *ReplaceAllTCPCheckBackendAccepted {

	return &ReplaceAllTCPCheckBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Tcp check backend accepted response
func (o *ReplaceAllTCPCheckBackendAccepted) WithReloadID(reloadID string) *ReplaceAllTCPCheckBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Tcp check backend accepted response
func (o *ReplaceAllTCPCheckBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Tcp check backend accepted response
func (o *ReplaceAllTCPCheckBackendAccepted) WithPayload(payload models.TCPChecks) *ReplaceAllTCPCheckBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp check backend accepted response
func (o *ReplaceAllTCPCheckBackendAccepted) SetPayload(payload models.TCPChecks) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPCheckBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPChecks{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllTCPCheckBackendBadRequestCode is the HTTP code returned for type ReplaceAllTCPCheckBackendBadRequest
const ReplaceAllTCPCheckBackendBadRequestCode int = 400

/*
ReplaceAllTCPCheckBackendBadRequest Bad request

swagger:response replaceAllTcpCheckBackendBadRequest
*/
type ReplaceAllTCPCheckBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllTCPCheckBackendBadRequest creates ReplaceAllTCPCheckBackendBadRequest with default headers values
func NewReplaceAllTCPCheckBackendBadRequest() *ReplaceAllTCPCheckBackendBadRequest {

	return &ReplaceAllTCPCheckBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Tcp check backend bad request response
func (o *ReplaceAllTCPCheckBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllTCPCheckBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Tcp check backend bad request response
func (o *ReplaceAllTCPCheckBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Tcp check backend bad request response
func (o *ReplaceAllTCPCheckBackendBadRequest) WithPayload(payload *models.Error) *ReplaceAllTCPCheckBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp check backend bad request response
func (o *ReplaceAllTCPCheckBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPCheckBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllTCPCheckBackendDefault General Error

swagger:response replaceAllTcpCheckBackendDefault
*/
type ReplaceAllTCPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllTCPCheckBackendDefault creates ReplaceAllTCPCheckBackendDefault with default headers values
func NewReplaceAllTCPCheckBackendDefault(code int) *ReplaceAllTCPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllTCPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all TCP check backend default response
func (o *ReplaceAllTCPCheckBackendDefault) WithStatusCode(code int) *ReplaceAllTCPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all TCP check backend default response
func (o *ReplaceAllTCPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all TCP check backend default response
func (o *ReplaceAllTCPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllTCPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all TCP check backend default response
func (o *ReplaceAllTCPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all TCP check backend default response
func (o *ReplaceAllTCPCheckBackendDefault) WithPayload(payload *models.Error) *ReplaceAllTCPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all TCP check backend default response
func (o *ReplaceAllTCPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
