*See the full release notes on the official documentation website: https://www.elastic.co/guide/en/elasticsearch/client/ruby-api/current/release_notes.html*

## 8.19.0 Release notes

[[release_notes_8_19]]
=== 8.19 Release notes

[discrete]
[[release_notes_8_19_0]]
## 8.19.0 Release notes

#### Client

Tested versions of Ruby for 8.19.0: Ruby (MRI) 3.1, 3.2, 3.3, 3.4. JRuby 9.3, JRuby 9.4 and JRuby 10.

#### API changes

* `cluster.get_component_template` - Adds `flat_settings` boolean parameter, return settings in flat format (default: false). Adds `settings_filter` String parameter, filter out results, for example to filter out sensitive information.
* `cluster.put_component_template` - Removes `timeout` parameter, adds `cause` String parameter, used defined reason for creation.
* `create` - Adds `require_alias` and `require_data_stream` boolean parameters, to specify required type to be created.
* `eql.search` - Adds `ccs_minimize_roundtrips`, `ignore_unavailable`, `allow_no_indices` boolean parameters and `expand_wildcards` String parameter.
* `esql.async_query` - Adds `allow_partial_results` boolean parameter.
* `esql.async_query_get` - Adds `format` String parameter (e.g. json, yaml).
* `esql.query` -  Adds `allow_partial_results` boolean parameter.
* `indices.recovery` - Adds `ignore_unavailable`, `allow_no_indices` boolean parameters and `expand_wildcards` String parameter.
* `msearch` - Adds `ignore_unavailable`, `ignore_throttled`, `allow_no_indices`, `include_named_queries_score` boolean parameters, `expand_wildcards` String parameter and `routing`, a comma-separated list of specific routing values.
* `open_point_in_time` - Adds `max_concurrent_shard_requests` parameter, the number of concurrent shard requests per node executed concurrently when opening this point-in-time
* `reindex` - Adds `require_alias` boolean parameter.
* `search_mvt` - Adds `grid_agg` String parameter, aggregation used to create a grid for `field`.
* `snapshot.repository_analyze` - Adds `register_operation_count` parameter, the minimum number of linearizable register operations to perform in total.

Time parameters `master_timeout` and `timeout` have been added to the following APIs:

* `index_lifecycle_management`:
** `delete_lifecycle`
** `get_lifecycle`
** `put_lifecycle`
** `start`
** `stop`
** `explain_lifecycle` - Only `master_timeout`

* `ingest`:
** `delete_geoip_database`
** `delete_ip_location_database`
** `put_geoip_database`
** `put_ip_location_database`

#### New APIs

* `indices.delete_data_stream_options` - Deletes the data stream options of the selected data streams.
* `indices.get_data_stream_options` - Returns the data stream options of the selected data streams.
* `indices.get_data_stream_settings` - Gets a data stream's settings.
* `indices.put_data_stream_options` - Updates the data stream options of the selected data streams.
* `indices.put_data_stream_settings` - Updates a data stream's settings.
* `inference.put_amazonsagemaker` - Configure an Amazon SageMaker inference endpoint.
* `inference.put_custom` - Configure a custom inference endpoint.
* `inference.put_deepseek` - Configure a DeepSeek inference endpoint.


## 8.18.0 Release notes

### API

#### New APIs:

* `esql.async_query_stop` - Stops a previously submitted async query request given its ID and collects the results.
* `inference.chat_completion_unified` - Perform chat completion inference
* `inference.completion` - Perform completion inference
* `inference.put_alibabacloud` - Configure an AlibabaCloud AI Search inference endpoint
* `inference.put_amazonbedrock` - Configure an Amazon Bedrock inference endpoint
* `inference.put_anthropic` - Configure an Anthropic inference endpoint
* `inference.put_azureaistudio` - Configure an Azure AI Studio inference endpoint
* `inference.put_azureopenai` - Configure an Azure OpenAI inference endpoint
* `inference.put_cohere` - Configure a Cohere inference endpoint
* `inference.put_elasticsearch` - Configure an Elasticsearch inference endpoint
* `inference.put_elser` - Configure an ELSER inference endpoint
* `inference.put_googleaistudio` - Configure a Google AI Studio inference endpoint
* `inference.put_googlevertexai` - Configure a Google Vertex AI inference endpoint
* `inference.put_hugging_face` - Configure a HuggingFace inference endpoint
* `inference.put_jinaai` - Configure a JinaAI inference endpoint
* `inference.put_mistral` - Configure a Mistral inference endpoint
* `inference.put_openai` - Configure an OpenAI inference endpoint
* `inference.put_voyageai` - Configure a VoyageAI inference endpoint
* `inference.put_watsonx` - Configure a Watsonx inference endpoint
* `inference.rerank` - Perform reranking inference
* `inference.sparse_embedding` - Perform sparse embedding inference
* `inference.stream_inference` renamed to `inference.stream_completion` - Perform streaming completion inference.
* `inference.text_embedding` - Perform text embedding inference

#### Updated APIs:

* `bulk`, `create`, `index`, `update` - Add Boolean parameter `:include_source_on_error`, if to include the document source in the error message in case of parsing errors (defaults to true).
* `cat.segments`
  * Adds  Boolean parameter `:local`, return local information, do not retrieve the state from master node (default: false).
  * Adds Time parameter `:master_timeout`, explicit operation timeout for connection to master node.
* `cat.tasks`
  * Adds Time parameter `:timeout`, period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
  * Adds Boolean parameter `:wait_for_completion`, if `true`, the request blocks until the task has completed.
* `eql.search`
  * Adds Boolean parameter `:allow_partial_search_results`, control whether the query should keep running in case of shard failures, and return partial results.
  * Adds Boolean parameter `:allow_partial_sequence_results`, control whether a sequence query should return partial results or no results at all in case of shard failures. This option has effect only if [allow_partial_search_results] is true.
* `index_lifecycle_management.delete_lifecycle`, `index_lifecycle_management.explain_lifecycle`, `index_lifecycle_management.get_lifecycle`, `index_lifecycle_management.put_lifecycle`, `index_lifecycle_management.start`, `index_lifecycle_management.stop`, remove `:master_timeout`, `:timeout` parameters.
* `indices.resolve_cluster` - Adds `:timeout` parameter, `:name` no longer a required parameter.
* `indices.rollover` - Removes target_failure_store parameter.
* `ingest.delete_geoip_database`, `ingest.delete_ip_location_database`, `put_geoip_database`, `put_ip_location_database` remove `:master_timeout`, `:timeout` parameters.
* `machine_learning.start_trained_model_deployment` - Adds body request parameter, the settings for the trained model deployment.


## 8.17.2 Release notes

### API

#### New APIs:

* `esql.async_query_delete`
* `indices.get_data_lifecycle_stats`
* `inference.update`
* `security.delegate_pki`

#### Updated APIs:

* `async_search.submit` - Adds `keep_alive` Time parameter.
* `indices.put_template` - Adds `cause` String parameter.
* `xpack.info` - Adds `human` parameter for human-readable information.
* Timeout parameters updated:
  * `:master_timeout` (Time), explicit operation timeout for connection to master node.
  * `:timeout` (Time), explicit operation timeout.
    * Added to:
      * `index_lifecycle_management.delete_lifecycle` - adds both.
      * `index_lifecycle_management.delete_lifecycle` - adds `master_timeout`.
      * `index_lifecycle_management.get_lifecycle` - adds both.
      * `index_lifecycle_management.put_lifecycle` - adds both.
      * `index_lifecycle_management.start` - adds both.
      * `index_lifecycle_management.stop` - adds both.
      * `ingest.delete_geoip_database` - adds both.
      * `ingest.delete_geoip_location_database` - adds both.
      * `ingest.put_geoip_database` - adds both.
      * `ingest.put_ip_location_database` - adds both.
      * `license.post_start_trial` - removes `timeout`.
      * `shutdown.delete_node` - adds both.
      * `shutdown.put_node` - adds both.
      * `snapshot_lifecycle_management.delete_lifecycle` - adds both.
      * `snapshot_lifecycle_management.execute_lifecycle` - adds both.
      * `snapshot_lifecycle_management.execute_retention` - adds both.
      * `snapshot_lifecycle_management.get_lifecycle` - adds both.
      * `snapshot_lifecycle_management.get_stats` - adds both.
      * `snapshot_lifecycle_management.get_status` - adds both.
      * `snapshot_lifecycle_management.put_lifecycle` - adds both.

#### APIs promoted from Experimental to Stable:

* `inference.delete`
* `inference.get`
* `inference.inference`
* `inference.put`
* `inference.stream_inference`

## 8.17.1 Release notes

### Client

* Fixes ScrollHelper issue #2556 - There was a bug where an additional search (with scroll) request was made to Elasticsearch for each resulting hit. It was rewritten so that the docs are retrieved as needed and the Helper instance doesn't store documents internally, with big savings in memory and requests to Elasticsearch.

## 8.17.0 Release notes

### Client
* Tested versions of Ruby for 8.17.0: Ruby (MRI) 3.1, 3.2 and 3.3. JRuby 9.3 and JRuby 9.4.

### API

#### API changes
* `async_search.submit` - Removes `keep_alive` parameter. Adds:
  * `ccs_minimize_roundtrips` (Boolean): When doing a cross-cluster search, setting it to true may improve overall search latency, particularly when searching clusters with a large number of shards. However, when set to true, the progress of searches on the remote clusters will not be received until the search finishes on all clusters.
  * `rest_total_hits_as_int` (Boolean): Indicates whether hits.total should be rendered as an integer or an object in the rest search response.
* `open_point_in_time` - Adds `allow_partial_search_results` (Boolean) parameter: Specify whether to tolerate shards missing when creating the point-in-time, or otherwise throw an exception (default: false).


## 8.16.0 Release notes

### Client
* Tested versions of Ruby for 8.16.0: Ruby (MRI) 3.1, 3.2 and 3.3. JRuby 9.3 and JRuby 9.4.

### API

#### API changes

* `capabilities` - Adds `local_only` boolean parameter: True if only the node being called should be considered.
* `cluster.stats`- Removes `flat_settings` parameter, adds `include_remotes` boolean parameter: Include remote cluster data into the response (default: false)
* `indices.get_data_stream` - Adds `verbose` boolean parameter: Whether the maximum timestamp for each data stream should be calculated and returned (default: false). Adds `master_timeout` (see below).
* `query_rules.delete_ruleset` - Accepts `ignore: 404` common parameter.

##### Timeout parameters:

These parameters have been added to several APIs:

* `master_timeout` timeout for processing on master node.
* `timeout` timeout for acknowledgement of update from all nodes in cluster parameters.

Added in:

* `indices.create_data_stream` - both.
* `indices.delete_data_stream` - `master_timeout`.
* `indices.get_data_lifecycle` - `master_timeout`.
* `indices.get_data_stream` - `master_timeout`.
* `indices.migrate_to_data_stream` - both.
* `indices.promote_data_stream` - `master_timeout`.
* `search_shards` - `master_timeout`.

#### APIs Promoted from Experimental to Stable:

* `indices.delete_data_lifecycle`
* `indices.explain_data_lifecycle`
* `indices.get_data_lifecycle`
* `indices.put_data_lifecycle`
* `security.create_cross_cluster_api_key`
* `security.update_cross_cluster_api_key`

#### New APIs

* `ingest.delete_ip_location_database` - Deletes an ip location database configuration.
* `ingest.get_ip_location_database` - Returns the specified ip location database configuration.
* `ingest.put_ip_location_database` - Puts the configuration for a ip location database to be downloaded.


#### New Experimental APIs

* `inference.stream_inference` - Perform streaming inference.
* `query_rules.test` - Tests a query ruleset to identify the rules that would match input criteria.


## 8.15.0 Release notes

### Client
* Tested versions of Ruby for 8.15.0: Ruby (MRI) 3.0, 3.1, 3.2 and 3.3. JRuby 9.3 and JRuby 9.4.

#### API changes

* `snapshot.delete` - Adds `wait_for_completion` Boolean parameter, should this request wait until the operation has completed before returning.
* `cluster.allocation_explain` - `body` is no longer a required parameter.
* `connector.put` - (experimental API) `body` and `connector_id` no longer required parameters.
* `machine_learning.update_trained_model_deployment` has been promoted to stable from Beta. Adds Integer parameter `number_of_allocations`, updates the model deployment to this number of allocations.

##### `master_timeout` and `timeout` parameters

These parameters have been added to several APIs:

* `master_timeout` timeout for processing on master node.
* `timeout` timeout for acknowledgement of update from all nodes in cluster parameters.

The APIs:

* `autoscaling.delete_autoscaling_policy` - both.
* `autoscaling.get_autoscaling_capacity`- `master_timeout`.
* `get_autoscaling_policy` - `master_timeout`.
* `put_autoscaling_policy` - both.
* `enrich.delete_policy` - `master_timeout`.
* `enrich.execute_policy` - `master_timeout`.
* `enrich.get_policy` - `master_timeout`.
* `enrich.put_policy` - `master_timeout`.
* `enrich.stats` - `master_timeout`.
* `features.reset_features` - `master_timeout`.
* `license.delete` - both.
* `license.post` - both.
* `license.post_start_basic` - both.
* `license.post_start_trial` - both.
* `security.get_settings` - `master_timeout`.
* `security.update_settings` - both.
* `shutdown.get_node` - `master_timeout`.
* `snapshot_lifecycle_management.start` - both.
* `snapshot_lifecycle_management.stop` - both.
* `watcher.get_settings` - `master_timeout`.
* `watcher.start` - `master_timeout`.
* `watcher.stop` - `master_timeout`.
* `watcher.update_settings` - both.

##### Inference APIs have been renamed:

* `inference.delete_model` => `inference.delete`. Also adds two new parameters:
  * `dry_run` (Boolean), if true the endpoint will not be deleted and a list of ingest processors which reference this endpoint will be returned.
  * `force` (Boolean), if true the endpoint will be forcefully stopped (regardless of whether or not it is referenced by any ingest processors or semantic text fields).
* `inference.get_model` => `inference.get`
* `inference.put_model` => `inference.put`

##### Query Rules parameters consolidated

Changes in `query_ruleset` and `query_rules` APIs, these have been combined into the `query_rules` namespace:

* `query_rules.delete_ruleset` - Renamed from `query_ruleset.delete`, promoted from experimental to stable.
* `query_rules.delete_rule` - Deletes an individual query rule within a ruleset.
* `query_rules.get_rule` - Returns the details about an individual query rule within a ruleset.
* `query_rules.get_ruleset` - Renamed from `query_ruleset.get`, promoted from experimental to stable.
* `query_rules.list_rulesets` - Renamed from `query_ruleset.list`, promoted from experimental to stable.
* `query_rules.put_rule` - Creates or updates a query rule within a ruleset.
* `query_rules.put_ruleset` - Renamed from `query_ruleset.put_ruleset`, promoted from experimental to stable.

#### New APIs:

* `ingest.delete_geoip_database` - Deletes a geoip database configuration.
* `ingest.get_geoip_database` - Returns geoip database configuration.
* `ingest.put_geoip_database` - Puts the configuration for a geoip database to be downloaded.
* `security.bulk_delete_role` - Bulk delete roles in the native realm.
* `security.bulk_put_role` - Bulk adds and updates roles in the native realm.
* `security.query_role` - Retrieves information for Roles using a subset of query DSL.
* `transform.get_node_stats` - Retrieves transform usage information for transform nodes.

#### New Experimental APIs:

* `connector.sync_job_claim` - Claims a connector sync job.
* `connector.update_features` - Updates the connector features in the connector document.

### Development

- Added a build using [es-test-runner-ruby](https://github.com/elastic/es-test-runner-ruby) and [Elasticsearch Clients Tests](https://github.com/elastic/elasticsearch-clients-tests) which will replace the Elasticsearch YAML test runner.

## 8.14.0 Release notes

### Client
* Tested versions of Ruby for 8.14.0: Ruby (MRI) 3.0, 3.1, 3.2 and 3.3. JRuby 9.3 and JRuby 9.4.

### API

API changes:

- All Connector APIs have been migrated to one common namespace `connector`:
  - `connector_secret.delete` -> `connector.secret_delete`
  - `connector_secret.get` -> `connector.secret_get`
  - `connector_secret.post` -> `connector.secret_post`
  - `connector_secret.put` -> `connector.secret_put`
  - `connector_sync_job.cancel` -> `connector.sync_job_cancel`
  - `connector_sync_job.check_in` -> `connector.sync_job_check_in`
  - `connector_sync_job.delete` -> `connector.sync_job_delete`
  - `connector_sync_job.error` -> `connector.sync_job_error`
  - `connector_sync_job.get` -> `connector.sync_job_get`
  - `connector_sync_job.post` -> `connector.sync_job_post`
  - `connector_sync_job.update_stats` -> `connector.sync_job_update_stats`

- `connector.delete` - Adds Boolean parameter `:delete_sync_jobs`: Determines whether associated sync jobs are also deleted.
- `cross_cluster_replication.delete_auto_follow_pattern`, `cross_cluster_replication.follow`, `cross_cluster_replication.follow_info`, `cross_cluster_replication.get_auto_follow_pattern`, `cross_cluster_replication.pause_auto_follow_pattern`, `cross_cluster_replication.pause_follow`, `cross_cluster_replication.put_auto_follow_pattern`, `cross_cluster_replication.resume_auto_follow_pattern`, `cross_cluster_replication.resume_follow`, `cross_cluster_replication.stats`, `cross_cluster_replication.unfollow` - Add Time parameter `:master_timeout`:  Explicit operation timeout for connection to master node.
- `cross_cluster_replication.follow_stats`, `cross_cluster_replication.forget_follower`, `cross_cluster_replication.stats` - Add Time parameter `:timeout`: Explicit operation timeout.
- `indices/rollover` - Adds Boolean parameter `:target_failure` If set to true, the rollover action will be applied on the failure store of the data stream.
- `inference.get_model` - Parameter `inference_id` no longer required.
- `search_application.search` - Adds Boolean parameter `:typed_keys`: Specify whether aggregation and suggester names should be prefixed by their respective types in the response.
- `security.get_api_key`, `security.query_api_keys` - Add Boolean parameter `:with_profile_uid`: flag to also retrieve the API Key's owner profile uid, if it exists.

New APIs:

- `profiling.topn_functions` - Extracts a list of topN functions from Universal Profiling.
- `text_structure.find_field_structure` - Finds the structure of a text field in an index.
- `text_structure/find_message_structure`- Finds the structure of a list of messages. The messages must contain data that is suitable to be ingested into Elasticsearch.

APIs Migrated from experimental to stable:

- `esql.async_query`
- `esql.query`

New Experimental APIs:

- `connector.update_active_filtering` - Activates the draft filtering rules if they are in a validated state.
- `connector.update_filtering_validation` - Updates the validation info of the draft filtering rules.

## 8.13.0 Release notes

### Client
* Tested versions of Ruby for 8.13.0: Ruby (MRI) 3.0, 3.1, 3.2 and 3.3. JRuby 9.3 and JRuby 9.4.

### Experimental ES|QL Helper

This version provides a new experimental Helper for the ES|QL `query` API. Please check out [the documentation](https://www.elastic.co/guide/en/elasticsearch/client/ruby-api/current/Helpers.html#esql-helper) and [open an issue](https://github.com/elastic/elasticsearch-ruby/issues/new/choose) if you encounter any problems or have any feedback.

### API

API Changes:

* `async_search.status` - adds Time `:keep_alive` parameter: Specify the time interval in which the results (partial or final) for this search will be available.
* `bulk` - adds boolean `:require_data_stream` parameter: When true, requires the destination to be a data stream (existing or to-be-created). Default is false.
* `connector.list` - Adds the following parameters:
  * `:index_name` (List): A comma-separated list of connector index names to fetch connector documents for.
  * `:connector_name` (List): A comma-separated list of connector names to fetch connector documents for.
  * `:service_type` (List):  A comma-separated list of connector service types to fetch connector documents for.
  * `:query` (String): A search string for querying connectors, filtering results by matching against connector names, descriptions, and index names.
* `esql.query` - adds boolean `:drop_null_columns` parameter: Should entirely null columns be removed from the results? Their name and type will be returning in a new `all_columns` section.
* `field_caps` - Adds `:include_empty_fields` boolean parameter: Include empty fields in result.
* `index` - adds boolean `:require_data_stream` parameter: When true, requires the destination to be a data stream (existing or to-be-created). Default is false.
* `indices.rollover` - adds boolean `:lazy` parameter: If set to true, the rollover action will only mark a data stream to signal that it needs to be rolled over at the next write. Only allowed on data streams.
* connector_sync_job.list - adds List `:job_type` parameter: A comma-separated list of job types.
* `inference.delete_model`, `inference.get_model`, `inference.inference`, `inference.put_model`: renames `:model_id` parameter to `:inference_id`.
* `termvector` will show a warning since it's been deprecated. Please use the plural version, `termvectors`.

New APIs:

* `indices.resolve_cluster` - Resolves the specified index expressions to return information about each cluster, including the local cluster, if included.
* `profiling.flamegraph` - Extracts a UI-optimized structure to render flamegraphs from Universal Profiling.
* `profiling.stacktraces` - Extracts raw stacktrace information from Universal Profiling.
* `security.query_user` - Retrieves information for Users using a subset of query DSL
* `text_structure.test_grok_pattern` - Tests a Grok pattern on some text.

APIs Migrated from experimental to stable:

* `synonyms.delete_synonym`
* `synonyms.delete_synonym_rule`
* `synonyms.get_synonym`
* `synonyms.get_synonym_rule`
* `synonyms.get_synonyms_sets`
* `synonyms.put_synonym`
* `synonyms.put_synonym_rule`

New Experimental APIs:

* `connector.update_api_key_id` - Updates the API key id and/or API key secret id fields in the connector document.
* `connector.update_index_name` - Updates the index name of the connector.
* `connector.update_native` - Updates the is_native flag of the connector.
* `connector.update_service_type` - Updates the service type of the connector.
* `connector.update_status` - Updates the status of the connector.
* `esql.async_query` - Executes an ESQL request asynchronously
* `esql.async_query_get` - Retrieves the results of a previously submitted async query request given its ID.

New Experimental namespace `connector_secret`:

* `connector_secret.delete` - Deletes a connector secret.
* `connector_secret.get` - Retrieves a secret stored by Connectors.
* `connector_secret.post` - Creates a secret for a Connector.
* `connector_secret.put` - Creates or updates a secret for a Connector.

### Development

* Migrated from `byebug` to `debug`.
* Added extra testing for OpenTelemetry.

## 8.12.0 Release notes

### Client

* Tested versions of Ruby for 8.12.0: Ruby (MRI) 3.0, 3.1, 3.2 and 3.3. JRuby 9.3 and JRuby 9.4.

### API

API Changes:

* `bulk` - Adds boolean `:list_executed_pipelines` parameter: Sets `list_executed_pipelines` for all incoming documents. Defaults to unset (false).
* `indices.put_settings` - Adds boolean `:reopen` parameter: Whether to close and reopen the index to apply non-dynamic settings. If set to `true` the indices to which the settings are being applied will be closed temporarily and then reopened in order to apply the changes. The default is `false`.
* `open_point_in_time` - Adds Hash `:body` parameter: an index_filter specified with the Query DSL.
* `security.get_api_key` - Adds boolean `:active_only` parameter: flag to limit response to only active (not invalidated or expired) API keys.

#### New APIs

New API for [Universal profiling](https://www.elastic.co/guide/en/observability/8.12/universal-profiling.html):

* `profiling.status` - Returns basic information about the status of Universal Profiling.


New experimental API:

* `simulate.ingest` - Simulates running ingest with example documents. See: https://www.elastic.co/guide/en/elasticsearch/reference/8.12/simulate-ingest-api.html

##### Connectors API

Version 8.12 introduces the experimental [Connectors API](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/connector-apis.html). Use the following APIs to manage connectors:

* `connector.post` - Creates a connector. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/create-connector-api.html)
* `connector.put` - Creates or updates a connector. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/create-connector-api.html)
* `connector.delete` - Deletes a connector. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/delete-connector-api.html)
* `connector.get` - Returns the details about a connector. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/get-connector-api.html)
* `connector.list` - Lists all connectors. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/list-connector-api.html)
* `connector.check_in` - Updates the last_seen timestamp in the connector document. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/check-in-connector-api.html)
* `connector.update_configuration` - Updates the connector configuration. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/update-connector-configuration-api.html)
* `connector.update_error` - Updates the error field in the connector document. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/update-connector-error-api.html)
* `connector.update_filtering` - Updates the filtering field in the connector document. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/update-connector-filtering-api.html)
* `connector.last_sync` - Updates the stats of last sync in the connector document. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/update-connector-last-sync-api.html)
* `connector.update_name` - Updates the name and/or description fields in the connector document. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/update-connector-name-description-api.html)
* `connector.update_pipeline` - Updates the pipeline field in the connector document. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/update-connector-pipeline-api.html)
* `connector.update_scheduling` - Updates the scheduling field in the connector document. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/update-connector-scheduling-api.html)

Use the following APIs to manage sync jobs:

* `connector_sync_job.cancel` - Cancels a connector sync job. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/cancel-connector-sync-job-api.html)
* `connector_sync_job.check_in` - Checks in a connector sync job (refreshes 'last_seen'). See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/check-in-connector-sync-job-api.html)
* `connector_sync_job.delete` - Deletes a connector sync job. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/delete-connector-sync-job-api.html)
* `connector_sync_job.error` - Sets an error for a connector sync job. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/set-connector-sync-job-error-api.html)
* `connector_sync_job.get` - Returns the details about a connector sync job. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/get-connector-sync-job-api.html)
* `connector_sync_job.list` - Lists all connector sync jobs. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/list-connector-sync-jobs-api.html)
* `connector_sync_job.post` - Creates a connector sync job. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/create-connector-sync-job-api.html)
* `connector_sync_job.update_stats` - Updates the stats fields in the connector sync job document. See [documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.12/set-connector-sync-job-stats-api.html)



## 8.11.0 Release notes

### Client

* Tested versions of Ruby for 8.11.0: Ruby (MRI) 3.0, 3.1 and 3.2. JRuby 9.3 and JRuby 9.4.
* Adds native support for *Open Telemetry*. See Open Telemetry for documentation.
* Improved documentation, now you can find more examples in Ruby in the [REST API reference](https://www.elastic.co/guide/en/elasticsearch/reference/8.11/rest-apis.html).

### API

New Experimental APIs:
- `esql.query` - Executes an ESQL request.
- `inference.delete_model` - Delete model in the Inference API.
- `inference.get_model` - Get a model in the Inference API.
- `inference.inference` - Perform inference on a model.
- `inference.put_model` - Configure a model for use in the Inference API.

## 8.10.0 Release notes

### Client
* Tested versions of Ruby for 8.10.0: Ruby (MRI) 3.0, 3.1 and 3.2. JRuby 9.3 and JRuby 9.4.

### API

#### New Experimental APIs, for internal use:
- `fleet.delete_secret`
- `fleet.get_secret`
- `fleet.post_secret`

#### New stable APIs:
- `security.get_settings` - Retrieve settings for the security system indices
- `security.update_settings` - Update settings for the security system indices

#### New Experimental API:
- `query_ruleset.list` List query rulesets.

#### API Changes:
- `indices.reload_search_analyzers` - Adds parameter `resource` changed resource to reload analyzers from if applicable

Promoted from Experimental to Beta:
- `security.create_cross_cluster_api_key`
- `security.update_cross_cluster_api_key`

#### Synonyms namespace update:

All synonym related APIs have been moved to the `synonyms` namespace and some of the endpoints have been renamed, as well as their parameters:
- `synonyms.delete` => `synonyms.delete_synonym` - requires `id`, the id of the synonyms set to be deleted.
- `synonyms.get` => `synonyms.get_synonym` - requires `id`, the name of the synonyms set to be retrieved.
- `synonyms_set.get_synonyms_sets` => `synonyms.get_synonyms_sets`
- `synonyms.put` => `synonyms.put_synonym` - requires `id` of the synonyms set to be created or updated.
- `synonym_rule.put` => `synonyms.put_synonym_rule` - Parameters changed to `set_id` (the id of the synonym set to be updated with the synonym rule) and `rule_id` (the id of the synonym rule to be updated or created).
- New Experimental API `synonyms.delete_synonym_rule` - Deletes a synonym rule in a synonym set
- New Experimental API `synonyms.get_synonym_rule` - Retrieves a synonym rule from a synonym set

## 8.9.0 Release notes

### Client

* Tested versions of Ruby for 8.9.0: Ruby (MRI) 3.0, 3.1 and 3.2. JRuby 9.3 and JRuby 9.4.
* Updated product validation. The code for the product validation was refactored in a few ways:
  * Just check header, does not check the version of the server.
  * Warns only once when there's a general server error.
  * Removes the call to '/' (client.info) when doing the first request, checking on the first actual request from the client.
* Fixes User-Agent code. In the migration to 8.x, the user agent code was extracted into transport, since we're now using that library in other projects. So for the Elasticsearch Client, the user-agent would be reported as the one defined in elastic-transport. This release fixes the issue and brings back the user agent in the format that was being used in 7.x

### Helpers

This release introduces two new Helpers in the client:

* BulkHelper - This helper provides a better developer experience when using the Bulk API. At its simplest, you can send it a collection of hashes in an array, and it will bulk ingest them into {es}.
* ScrollHelper - This helper provides an easy way to get results from a Scroll.

See [Helpers](https://www.elastic.co/guide/en/elasticsearch/client/ruby-api/current/Helpers.html) to read more about them.

### API

#### New APIs

* `cluster.info` - Returns different information about the cluster.

#### New Experimental APIs and namespaces:

This functionality is Experimental and may be changed or removed completely in a future release. Elastic will take a best effort approach to fix any issues, but experimental features are not subject to the support SLA of official GA features.

* New namespace: `query_ruleset`
  * `query_ruleset.delete` - Deletes a query ruleset.
  * `query_ruleset.get` - Returns the details about a query ruleset.
  * `query_ruleset.put` - Creates or updates a query ruleset.
* New API: `search_application.render_query` Renders a query for given search application search parameters.
* New API: `security.create_cross_cluster_api_key` -  Creates a cross-cluster API key for API key based remote cluster access.
* New API: `security.upate_cross_cluster_api_key` - Updates attributes of an existing cross-cluster API key.
* New namespace: `synonyms`
  * `synonyms.delete`- Deletes a synonym set
  * `synonyms.get` - Retrieves a synonym set
  * `synonyms.put` - Creates or updates a synonyms set
* New namespace: `synonym_rule`
  * `synonym_rule.put` - Creates or updates a synonym rule in a synonym set
* New namespace: `synonyms`
  * `synonyms_set.get` - Retrieves a summary of all defined synonym sets

## 8.8.0 Release notes

- Tested versions of Ruby for 8.8.0: Ruby (MRI) 3.0, 3.1 and **3.2**. JRuby 9.3 and JRuby 9.4.

### API

- Updates development dependency `minitest-reporters` to `>= 1.6` to include showing failures at the end of the test run.

#### New APIs

- `watcher.get_settings` - Retrieve settings for the watcher system index.
- `watcher.update_settings` - Update settings for the watcher system index.

#### New Experimental APIs

- `indices.delete_data_lifecycle`- Deletes the data lifecycle of the selected data streams
- `indices.explain_data_lifecycle` - Retrieves information about the index's current DLM lifecycle, such as any potential encountered error, time since creation etc.
- `indices.get_data_lifecycle` - Returns the data lifecycle of the selected data streams.
- `indices.put_data_lifecycle` - Updates the data lifecycle of the selected data streams.
- `search_application.delete` - Deletes a search application.
- `search_application.delete_behavioral_analytics` - Delete a behavioral analytics collection.
- `search_application.get` - Returns the details about a search application.
- `search_application.get_behavioral_analytics` - Returns the existing behavioral analytics collections.
- `search_application.list` - Returns the existing search applications.
- `search_application.post_behavioral_analytics_event` - Creates a behavioral analytics event for existing collection.
- `search_application.put` - Creates or updates a search application.
- `search_application.put_behavioral_analytics` - Creates a behavioral analytics collection.
- `search_application.search` - Perform a search against a search application.

#### API Changes

- `clear_scroll` now works with the argument `ignore: 404`. [Issue on GitHub](https://github.com/elastic/elasticsearch-ruby/issues/2067).
- The code generator was updated to fix a bug for `ignore: 404`. APIs that were supposed to support this wouldn't parse the parameters correctly. The support it now: `security.get_role`, `watcher.delete_watch`
- `cluster.get_component_template`, `indices.get_data_stream`, `indices.get_index_template`, `indices.simulate_index_template`, `indices.simulate_template` - Add `include_defaults` (Boolean) parameter: Return all default configurations for the component template (default: false).
- `machine_learning.put_trained_model` - Adds `wait_for_completion` (Boolean) parameter: Whether to wait for all child operations(e.g. model download) to complete, before returning or not (default: false).
- `machine_learning.start_trained_model_deployment` - Adds `deployiment_id` (String) parameter: The Id of the new deployment. Defaults to the model_id if not set.
- `search` - Adds `include_named_queries_score` (Boolean) parameter: Indicates whether hit.matched_queries should be rendered as a map that includes the name of the matched query associated with its score (true) or as an array containing the name of the matched queries (false).
- `transform.delete_transform` - Adds `delete_dest_index` (Boolean) parameter: When `true`, the destination index is deleted together with the transform. The default value is `false`, meaning that the destination index will not be deleted.

## 8.7.1 Release notes

### API Bugfix

- Updates `logstash.get_pipeline`, fixed in the specification `id` is not a required parameter, so removes raising `ArgumentError` when id is not present.

## 8.7.0 Release notes

- Tested versions of Ruby for 8.7.0: Ruby (MRI) 2.7, 3.0, 3.1 and **3.2**. JRuby 9.3 and JRuby 9.4. Ruby 2.7's end of life is coming in a few days, so this'll probably be the last release to test for Ruby 2.7.

### New APIs

- `health_report` - Returns the health of the cluster.
- `transform.schedule_now_transform` - Schedules now a transform.

### API Changes

- `transform.get_transform_stats` - Adds `timeout` (Time) parameter. Controls the time to wait for the stats.
- `transform.start_transform` - Adds `from` (String) parameter. Restricts the set of transformed entities to those changed after this time.
- `ml.delete_job`, `ml.reset_job` - Add `delete_user_annotations` (Boolean) parameter. Should annotations added by the user be deleted.
- `ml.clear_trained_model_deployment_cache`, `ml.infer_trained_model`, `ml.put_trained_model_definition_part`, `ml.put_trained_model_vocabulary`, `ml.start_trained_model_deployment`, `ml.stop_trained_model_deployment` - These APIs are no longer in Beta.

## 8.6.0 Release notes

- Tested versions of Ruby for 8.6.0: Ruby (MRI) 2.7, 3.0, 3.1 and **3.2**. JRuby 9.3 and **JRuby 9.4**.

### New APIs

- `update_trained_model_deployment` - Updates certain properties of trained model deployment (This functionality is in Beta and is subject to change).

### API Changes

- `cluster.reroute` - `:metric` parameter adds `none` as an option.
- `ml.start_trained_model_deployment` - New parameter `:priority` (String), the deployment priority


## 8.5.2 Release notes

### API Bugfix

Fixes `security.create_service_token` API, uses `POST` when token name isn't present.
Thanks [@carlosdelest](https://github.com/carlosdelest) for reporting in [#1961](https://github.com/elastic/elasticsearch-ruby/pull/1961).

## 8.5.1 Release notes

### Bugfix

Fixes bug when instantiating client with `api_key`: When passing in `api_key` and `transport_options` that don't include headers to the client, the `api_key` code would overwrite the arguments passed in for `transport_options`. This was fixed in [this Pull Request](https://github.com/elastic/elasticsearch-ruby/pull/1941/files).
Thanks [svdasein](https://github.com/svdasein) for reporting in [#1940](https://github.com/elastic/elasticsearch-ruby/issues/1940).

## 8.5.0 Release notes

- Tested versions of Ruby for 8.5.0: Ruby (MRI) 2.7, 3.0 and 3.1, JRuby 9.3.

### Client

With the latest release of `elastic-transport` - `v8.1.0` - this gem now supports Faraday v2. Elasticsearch Ruby has an open dependency on `elastic-transport` (`'elastic-transport', '~> 8'`), so when you upgrade your gems, `8.1.0` will be installed. This supports both Faraday v1 and Faraday v2. The main change on dependencies when using Faraday v2 is all adapters, except for the default `net_http` one, have been moved out of Faraday into separate gems. This means if you're not using the default adapter and you migrate to Faraday v2, you'll need to add the adapter gems to your Gemfile.

These are the gems required for the different adapters with Faraday 2, instead of the libraries on which they were based:
```
# HTTPCLient
gem 'faraday-httpclient'

# NetHTTPPersistent
gem 'faraday-net_http_persistent'

# Patron
gem 'faraday-patron'

# Typhoeus
gem 'faraday-typhoeus'
```

Things should work fine if you migrate to Faraday 2 as long as you include the adapter (unless you're using the default one `net-http`), but worst case scenario, you can always lock the version of Faraday in your project to 1.x:
`gem 'faraday', '~> 1'`

Be aware if migrating to Faraday v2 that it requires at least Ruby `2.6`, unlike Faraday v1 which requires `2.4`.

*Troubleshooting*

If you see a message like:
`:adapter is not registered on Faraday::Adapter (Faraday::Error)`
Then you probably need to include the adapter library in your gemfile and require it.

Please [submit an issue](https://github.com/elastic/elasticsearch-ruby/issues) if you encounter any problems.

### API

#### New APIs

- `machine_learning.clear_trained_model_deployment_cache` - Clear the cached results from a trained model deployment (Beta).
- `security.bulk_update_api_keys` - Updates the attributes of multiple existing API keys.

#### API Changes

- `rollup.rollup` renamed to `indices.downsample`. The method now receives the `index` to downsample (Required) and instead of `rollup_index`, use target_index as the index to store downsampled data.

- `security.get_api_key` and `security.query_api_keys` add `:with_limited_by` flag to show the limited-by role descriptors of API Keys.
- `security.get_user` adds `:with_profile_uid` flag to retrieve profile uid (if exists) associated to the user.
- `security.get_user_profile` now retrieves user profiles for given unique ID(s). `:uid` is now a list of comma-separated list of unique identifier for user profiles.
- `text_structure.find_structure` adds `:ecs_compatibility`, optional parameter to specify the compatibility mode with ECS Grok patterns - may be either 'v1' or 'disabled'.

Machine learning APIs promoted from *Experimental* to *Beta*:

- `machine_learning.clear_trained_model_deployment_cache.rb`
- `machine_learning.infer_trained_model.rb`
- `machine_learning.put_trained_model_definition_part.rb`
- `machine_learning.put_trained_model_vocabulary.rb`
- `machine_learning.start_trained_model_deployment.rb`
- `machine_learning.stop_trained_model_deployment.rb`

Security usef profile APIs promoted from *Experimental* to *Stable*:

- `security/activate_user_profile`
- `security/disable_user_profile`
- `security/enable_user_profile`
- `security/get_user_profile`
- `security/has_privileges_user_profile`
- `security/suggest_user_profile`
- `security/update_user_profile_data`


## 8.4.0 Release Notes

- Tested versions of Ruby for 8.4.0: Ruby (MRI) 2.7, 3.0 and 3.1, JRuby 9.3.

### API

#### New APIs

* `security.update_api_key` - Updates attributes of an existing API key. [Documentation](https://www.elastic.co/guide/en/elasticsearch/reference/8.4/security-api-update-api-key.html).

#### API Changes

* `get` - Adds new parameter `force_synthetic_source` (Boolean) Should this request force synthetic _source? Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance. Fetches with this enabled will be slower the enabling synthetic source natively in the index.
* `machine_learning.start_trained_model_deployment` - Adds new parameter `cache_size` (String) A byte-size value for configuring the inference cache size. For example, 20mb.
* `mget` - Adds new parameter `force_synthetic_source` (Boolean) Should this request force synthetic _source? Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance. Fetches with this enabled will be slower the enabling synthetic source natively in the index.
* `search` - Adds new parameter `force_synthetic_source` (Boolean) Should this request force synthetic _source? Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance. Fetches with this enabled will be slower the enabling synthetic source natively in the index.
* `snapshot.get` - Adds new parameters:
  * `sort` (String) Allows setting a sort order for the result. Defaults to start_time (options: start_time, duration, name, repository, index_count, shard_count, failed_shard_count).
  * `size` (Integer) Maximum number of snapshots to return. Defaults to 0 which means return all that match without limit.
  * `order` (String) Sort order (options: asc, desc).
  * `from_sort_value` (String) Value of the current sort column at which to start retrieval.
  * `after` (String) Offset identifier to start pagination from as returned by the 'next' field in the response body.
  * `offset` (Integer) Numeric offset to start pagination based on the snapshots matching the request. Defaults to 0.
  * `slm_policy_filter` (String) Filter snapshots by a comma-separated list of SLM policy names that snapshots belong to. Accepts wildcards. Use the special pattern '_none' to match snapshots without an SLM policy.

## 8.3.0 Release Notes

- Tested versions of Ruby for 8.3.0: Ruby (MRI) 2.7, 3.0 and 3.1, JRuby 9.3.

### API

- Added build hash to auto generated code. The code generator obtains the git hash from the Elasticsearch specification and adds it as a comment in the code. This allows us to track the version for each generated class.
- Updated for compatibility with Elasticsearch 8.3's API.

#### API Changes

* `cluster.delete_voting_config_exclusions`, `cluster.post_voting_config_exclusions` - Add new parameter `master_timeout` (Time) Timeout for submitting request to master.
* `machine_learning.infer_trained_model_deployment` is renamed to `machine_learning.infer_trained_model`. The url `/_ml/trained_models/{model_id}/deployment/_infer` is deprecated since 8.3, use `/_ml/trained_models/{model_id}/_infer` instead.
* `machine_learning.preview_datafeed` - Adds new parameters:
  * `start` (String) The start time from where the datafeed preview should begin
  * `end` (String) The end time when the datafeed preview should stop
* `machine_learning.start_trained_model_deployment` - Adds new parameters:
  * `number_of_allocations` (Integer) The number of model allocations on each node where the model is deployed.
  * `threads_per_allocation` (Integer) The number of threads used by each model allocation during inference.
  * `queue_capacity` (Integer) Controls how many inference requests are allowed in the queue at a time.
* `search_mvt` - Adds new parameter: `with_labels` (Boolean) If true, the hits and aggs layers will contain additional point features with suggested label positions for the original features
* `snapshot.get` - Adds new parameter: `index_names` (Boolean) Whether to include the name of each index in the snapshot. Defaults to true.

#### New Experimental APIs
* `security.has_privileges_user_profile` Determines whether the users associated with the specified profile IDs have all the requested privileges

## 8.2.2 Release notes

- Updates dependency on `elastic-transport` to `~> 8.0`

## 8.2.1 Release notes

No release, no changes on the client.

## 8.2.0

- Tested versions of Ruby for 8.2.0: Ruby (MRI) 2.7, 3.0 and 3.1, JRuby 9.3.

### API

Updated for compatibility with Elasticsearch 8.2's API.

#### New parameters:

* `field_caps`
  - `filters` An optional set of filters: can include +metadata,-metadata,-nested,-multifield,-parent
  - `types` Only return results for fields that have one of the types in the list

#### New APIs:

- `cat.component_templates` - Returns information about existing component_templates templates.
- `ml.get_memory_stats` - Returns information on how ML is using memory.

#### New Experimental APIs:

- `security.activate_user_profile` - Creates or updates the user profile on behalf of another user.
- `security.disable_user_profile` -  Disables a user profile so it's not visible in user profile searches.
- `security.enable_user_profile` -  Enables a user profile so it's visible in user profile searches.
- `security.get_user_profile` -  Retrieves a user profile for the given unique ID.
- `security.suggest_user_profiles` - Get suggestions for user profiles that match specified search criteria.
- `security.update_user_profile_data` - Update application specific data for the user profile of the given unique ID.

## 8.1.2, 8.0.1

### API

- Fixes an issue with the generated API code. When updating the code generator for 8.x, the order of `arguments.clone` in the generated code was changed. This would make it so that we would modify the parameters passed in before cloning them, which is undesired. Issue: [#1727](https://github.com/elastic/elasticsearch-ruby/issues/1727).

## 8.1.1

No release, no changes on the client.

## 8.1.0

- Tested versions of Ruby for 8.1.0: Ruby (MRI) 2.6, 2.7, 3.0 and 3.1, JRuby 9.3.

### API

Updated for compatibility with Elasticsearch 8.1's API.

#### New parameters:
- `indices.forcemerge` - `wait_for_completion` Should the request wait until the force merge is completed.
- `indices.get` - `features` Return only information on specified index features (options: aliases, mappings, settings).
- `ingest.put_pipeline` `if_version` (Integer), required version for optimistic concurrency control for pipeline updates.
- `ml.delete_trained_model` - `timeout` controls the amount of time to wait for the model to be deleted. `force` (Boolean) true if the model should be forcefully deleted.
- `ml.stop_trained_model_deployment` -  `allow_no_match` whether to ignore if a wildcard expression matches no deployments. (This includes `_all` string or when no deployments have been specified). `force` true if the deployment should be forcefully stopped. Adds `body` parameter, the stop deployment parameters.
- `nodes.hot_threads` - `sort` the sort order for 'cpu' type (default: total) (options: cpu, total)

#### Updated parameters:
- `indices.get_index_template` - `name` is now a String, a pattern that returned template names must match.
- `knn_search` - `index` removes option to use empty string to perform the operation on all indices.
- `ml.close_job`, `ml.get_job_stats`, `ml.get_jobs`, `ml.get_overall_buckets` - Remove `allow_no_jobs` parameter.
- `ml.get_datafeed_stats`, `ml.get_datafeeds` - Remove `allow_no_datafeeds` parameter.
- `nodes.hot_threads` - `type` parameter adds `mem` option.
- `nodes.info` - `metric` updated to use `_all` to retrieve all metrics and `_none` to retrieve the node identity without any additional metrics. (options: settings, os, process, jvm, thread_pool, transport, http, plugins, ingest, indices, aggregations, _all, _none). `index_metric` option `shards` changes to `shard_stats`.
- `open_point_in_time` - `keep_alive` is now a required parameter.
- `search_mvt` - `grid_type` parameter adds `centroid` option in addition to `grid` and `point`.

- New experimental APIs, designed for internal use by the fleet server project: `fleet.search`, `fleet.msearch`.

#### New APIs
- OpenID Connect Authentication: `security.oidc_authenticate`, `security.oidc_logout`, `security.oidc_prepare_authentication`.
- `transform.reset_transform`.


## 8.0.0

First release for the `8.x` branch with a few major changes.

- Tested versions of Ruby for 8.0.0: Ruby (MRI) 2.6, 2.7, 3.0 and 3.1, JRuby 9.3.

### Client

#### Elastic Transport

The code for the dependency `elasticsearch-transport` has been promoted to [its own repository](https://github.com/elastic/elastic-transport-ruby/) and the project and gem have been renamed to [`elastic-transport`](https://rubygems.org/gems/elastic-transport). This gem now powers [`elasticsearch`](https://rubygems.org/gems/elasticsearch) and [`elastic-enterprise-search`](https://rubygems.org/gems/elastic-enterprise-search). The `elasticsearch-transport` gem won't be maintained after the last release in the `7.x` branch, in favour of `elastic-transport`.

This will allow us to better address maintainance in both clients and the library itself.

### API

The `elasticsearch-api` library has been generated based on the Elasticsearch 8.0.0 REST specification.

#### X-Pack Deprecation

X-Pack has been deprecated. The `elasticsearch-xpack` gem will no longer be maintained after the last release in the `7.x` branch. The "X-Pack" integration library codebase was merged into `elasticsearch-api`. All the functionality is available from `elasticsearch-api`. The `xpack` namespace was removed for accessing any APIs other than `_xpack` (`client.xpack.info`) and `_xpack/usage` (`client.xpack.usage`). But APIs which were previously available through the `xpack` namespace e.g.: `client.xpack.machine_learning` are now only available directly: `client.machine_learning`.

#### Parameter checking was removed

The code in `elasticsearch-api` will no longer validate all the parameters sent. It will only validate the required parameters such as those needed to build the path for the request. But other API parameters are going to be validated by Elasticsearch. This provides better forwards and backwards compatibility in the client.

#### Response object

In previous versions of the client, calling an API endpoint would return the JSON body of the response. With `8.0`, we are returning a new Response object `Elasticsearch::API::Response`. It still behaves like a Hash to maintain backwards compatibility, but adds the `status` and `headers` methods from the `Elastic::Transport:Transport::Response` object:

```ruby
elastic_ruby(main)> response = client.info
=> #<Elasticsearch::API::Response:0x000055752b0c50a8
 @response=
  #<Elastic::Transport::Transport::Response:0x000055752b0c50f8
   @body=
    {"name"=>"instance",
     "cluster_name"=>"elasticsearch-8-0-0-SNAPSHOT-rest-test",
     "cluster_uuid"=>"oIfRARuYRGuVYybjxQJ87w",
     "version"=>
      {"number"=>"8.0.0-SNAPSHOT",
       "build_flavor"=>"default",
       "build_type"=>"docker",
       "build_hash"=>"7e23c54eb31cc101d1a4811b9ab9c4fd33ed6a8d",
       "build_date"=>"2021-11-04T00:21:32.464485627Z",
       "build_snapshot"=>true,
       "lucene_version"=>"9.0.0",
       "minimum_wire_compatibility_version"=>"7.16.0",
       "minimum_index_compatibility_version"=>"7.0.0"},
     "tagline"=>"You Know, for Search"},
   @headers={"X-elastic-product"=>"Elasticsearch", "content-type"=>"application/json", "content-length"=>"567"},
   @status=200>>
elastic_ruby(main)> response.status
=> 200
elastic_ruby(main)> response.headers
=> {"X-elastic-product"=>"Elasticsearch", "content-type"=>"application/json", "content-length"=>"567"}
elastic_ruby(main)> response['name']
=> "instance"
elastic_ruby(main)> response['tagline']
=> "You Know, for Search"
```

Please [let us know if you find any issues](https://github.com/elastic/elasticsearch-ruby/issues).
