/*
 *   mwmload.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmspcfc.h>
#include <mwmcntnd.h>
#include <psv8itcb.h>
#include <mwmcapi.h>
#include <v42itcb.h>
#include <stddef.h>
#include <sys/timeb.h>
#include <time.h>
#include <mwqservr.h>
#include "mww32.h"
/*#include <pbmplus.h>*/
#include <mwave.h>

HANDLE  hModemMutex = (HANDLE)NULL;

static char szThisFile[] = "MWMLOAD.C";

HIPC   hTemphipc = NULL;

ULONG  mwmLoadV34(PMWM_DSPINFO pmwmDspInfo, BOOL bAutomoding);

void OutputDebugString(char *pszString)
{
 //{ MW_SYSLOG_1(TRACE_MWMLW32,"*****ODS::%s\n", pszString);  }
}


#define MODNAME "MWMODEM"
void dprintf(char *szFormat, ...)
{
  /*if (usDebugWindow)
  {*/
    struct timeb timebuffer;
    char *timeline;

    char ach[256];

      if(usShowTimeStamp)
      {
        ftime( &timebuffer );
        timeline = ctime( &(timebuffer.time) );
        sprintf(ach, "%.8s.%u ", timeline+11, timebuffer.millitm);
        strcat(ach, MODNAME ": ");
      }
      else
        strcpy(ach, MODNAME ": ");

    vsprintf(ach+strlen(ach),szFormat,(char *)(&szFormat+1));
    strcat(ach, "\r\n");

    OutputDebugString(ach);
 /* } */
}



ULONG FAR PASCAL SetupCallProgress(HMTASK hmtCallProg);

typedef ULONG ( FAR PASCAL *LPSETUPCALLPROGRESS)(HMTASK hmtCallProg);

ULONG mwmLoadCallProgress(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadCallProgress entry\n");  }


  ulRC = mwmCntndLoadModule(pmwmDspInfo,"CALLPROG","CALLPROG",
                            &pmwmDspInfo->hmodCallProg,szThisFile,__LINE__);
  if (ulRC)
    return ulRC;

  /*************************************************************************/
  /* Get CallProg Task handle                                              */
  /*************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodCallProg, "CALLPROG",
                             &pmwmDspInfo->hmtCallProg);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  /*************************************************************************/
  /* Get CallProgMove Task handle                                          */
  /*************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodCallProg, "MOVE",
                             &pmwmDspInfo->hmtCallProgMove);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  ulRC = mwmSpcfcSetUpCP_Parms(pmwmDspInfo, pmwmDspInfo->hmtCallProg);
  if (ulRC)
    return(ulRC);

  /*************************************************************************/
  /* Call Progress ITCB to Modem Control.                                  */
  /*************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtCallProg,"CPITCB",pmwmDspInfo->hmctlTask,"CPITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT", pmwmDspInfo->hmtCallProgMove,"MOVEIN", 0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  ulRC = dspChangeModuleState(pmwmDspInfo->hmodCallProg, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadCallProgress exit\n");  }


  return 0;
}

/*****************************************************************************/
/* Controls the initial load of the modem configuration.                     */
/* This routine is called in 2 ways.                                         */
/*  1.  From mwmCntndLoadModem during original load time.                    */
/*  2.  From mwmSpcfcNSClientProc after a power management "RESUME"          */
/*      or "DSP_INIT" event.                                                 */
/*****************************************************************************/
ULONG mwmLoadConfiguration(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC;
  USHORT usParserMode;


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadConfiguration entry\n");  }


  pmwmDspInfo->bSuspending = FALSE;

  /***************************************************************************/
  /* Query the current Parser Mode....this is CLASS2 or MODEM.               */
  /* using this information, we know which modules to load now.              */
  /***************************************************************************/
  ulRC = mwmParseQueryParserMode(&usParserMode);
  if (ulRC)
    return ulRC;



  /***************************************************************************/
  /* Load the Disciminator Base function.                                    */
  /* This group of modules will be loaded first no matter which state is     */
  /* being loaded.                                                           */
  /***************************************************************************/
  ulRC = mwmLoadDiscrimBase(pmwmDspInfo);
  if (ulRC)
    return ulRC;

  pmwmDspInfo->ulDiscrimState = 1;

  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
  {
    (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"discrim.snp");
  }


  /***************************************************************************/
  /* If Slim base mode, only the base functions will be loaded.              */
  /* Otherwise, we will load the full setup...either class 2 or modem mode.  */
  /***************************************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_SLIMBASE)         // MTS=SB
  {
//    if (usParserMode & FEATURE_CLASS2)
    if (usParserMode & MWM_MODE_CLASS2_FAX)
    {
      /***********************************************************************/
      /* Switch from Discriminator-Modem to Discriminator-Class 2            */
      /* This routine actually unloads the Async task, and loads the         */
      /* class2 task.                                                        */
      /* This may seem silly since the ASYNC task was just loaded, however,  */
      /* in the general case, We need to keep the number of states minimal.  */
      /* This extra load/unload takes place only in a few configurations,    */
      /* and it won't take much extra time.                                  */
      /***********************************************************************/
      ulRC = mwmFaxDiscrimToClassxDiscrim(pmwmDspInfo, 2);
      if (ulRC)
        return ulRC;

      ulRC = mwmFaxSetFCLASS( pmwmDspInfo, 2 );
      if (ulRC)
        return ulRC;

    }
  }
  else
  {
//    if (usParserMode & FEATURE_CLASS2)
    if (usParserMode & MWM_MODE_CLASS2_FAX)
    {
      /***********************************************************************/
      /* Load the full Class 2 system.                                       */
      /* Since we are in Modem-Discrim state now, we need 3 state changes... */
      /*   1. Modem-Discrim  to Class2-Discrim                               */
      /*   2. Class2-Discrim to Dial                                         */
      /*   3. Class2-Dial    to Class2                                       */
      /***********************************************************************/
      ulRC = mwmFaxDiscrimToClassxDiscrim(pmwmDspInfo, 2);
      if (ulRC)
        return ulRC;

      ulRC = mwmLoadDiscrimToDial(pmwmDspInfo);
      if (ulRC)
        return ulRC;

      ulRC = mwmFaxDialToClass2(pmwmDspInfo);
      if (ulRC)
        return ulRC;
    }
    else
    {
      /***********************************************************************/
      /* This is the standard full modem configuration.  (No Discrim)        */
      /* Since we are currently in Modem-Discrim state, we need to make 1    */
      /* state change...                                                     */
      /***********************************************************************/
      ulRC = mwmLoadDiscrimToDial(pmwmDspInfo);
      if (ulRC)
        return ulRC;

      ulRC = mwmLoadDialToModem(pmwmDspInfo);
      if (ulRC)
        return ulRC;
    }
  }
  mwmCntndLoadComplete(pmwmDspInfo, 1);                      /* MTS RADD */

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadConfiguration exit\n");  }


  return 0;
}



/*****************************************************************************/
/* The Discriminator Base consists of the following tasks:                   */
/*  1. Modem Control ------|                                                 */
/*  2. Dummy Datapump -----|--MODEM.DSP                                      */
/*  3. Dummy Async --------|                                                 */
/*  4. Protocol Supervisor-|                                                 */
/*  5. Async ----------------ASYNC.DSP                                       */
/*  6. CallerID -------------CALLERID.DSP (maybe)                            */
/*                                                                           */
/* In addition to these loads, this routine connects the MCTL-Driver IPC     */
/*                                                                           */
/* This routine loads these modules and makes the proper connections.        */
/*****************************************************************************/
ULONG mwmLoadDiscrimBase(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC;
//  HIPC   hIPC;
  ULONG  ulAddress = 0;
  ULONG  ulAllowedFunctions1 = 0;
//  USHORT usParserMode = 0;
  USHORT usTempValue = 0;


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDiscrimBase entry\n");  }



  /***************************************************************************/
  /* MTS 3889                                                                */
  /* Call WtQueryItem just to make sure that the database has been read into */
  /* memory.  This works around a problem where my IPC 4 and application time*/
  /* processing both call WtQuery functions at the same time.                */
  /* This problem has only been noticed in Win-OS/2, however, it seems like  */
  /* a possibility in other environments as well.                            */
  /***************************************************************************/
  WtQueryItem(NULL,
              WT_ALLOWED_FUNC_1,
              &ulAllowedFunctions1);
  /***************************************************************************/
  /* End MTS 3889                                                            */
  /***************************************************************************/



  /***************************************************************************/
  /* Load the Modules                                                        */
  /***************************************************************************/
  ulRC = mwmCntndLoadModule(pmwmDspInfo,"MAINFILE","MODEM",&pmwmDspInfo->hmodModem,szThisFile,__LINE__);
  if (ulRC)
    return ulRC;

  /***************************************************************************/
  /* Get handle to MDMCTL task                                               */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodModem, "MCTL", &pmwmDspInfo->hmctlTask);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Get handle to ProtSupr Task.                                            */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodModem, "PROTSUPR", &pmwmDspInfo->hmtProtSupr);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /* MTS 4086                                                                */
  /* Free the %TT Segment before loading anything else                       */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmctlTask,
                                "MDMTTSEG",
                                &pmwmDspInfo->hsegPercentTT);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegPercentTT);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegPercentTT = 0;


  /***************************************************************************/
  /* MTS 5153                                                                */
  /* Free the DIALT Segment before loading anything else                     */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmctlTask,
                                "MDMDIALT",
                                &pmwmDspInfo->hsegMCTLDIALT);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLDIALT);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegMCTLDIALT = 0;


  /***************************************************************************/
  /* Free the CLASS1 Segment before loading anything else                    */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmctlTask,
                                "MDMSUBS1",
                                &pmwmDspInfo->hsegMCTLSUBS1);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLSUBS1);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegMCTLSUBS1 = 0;

  /***************************************************************************/
  /* 11/20/96 Tim ... Class 2 restructure.                                   */
  /* Free the CLASS2 Segment before loading anything else                    */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmctlTask,
                                "MDMFAX00",
                                &pmwmDspInfo->hsegMCTLFAX00);
  if (ulRC)
  {
    if (ulRC != DSP_NAME_NOT_FOUND) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    } else {
      pmwmDspInfo->hsegMCTLFAX00 = 0;
    } /* endif */
  }

  if (pmwmDspInfo->hsegMCTLFAX00) {
    ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLFAX00);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegMCTLFAX00 = 0;
  } /* endif */

  /***************************************************************************/
  /* Free the CLASS8 Segment before loading anything else                    */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmctlTask,
                                "MDMCTL08",
                                &pmwmDspInfo->hsegMCTLCTL08);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLCTL08);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegMCTLCTL08 = 0;

  /***************************************************************************/
  /* Free the CLASS80 Segment before loading anything else                   */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmctlTask,
                                "VVIEW_CS",
                                &pmwmDspInfo->hsegMCTLCTL80);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLCTL80);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegMCTLCTL80 = 0;

  ulRC = mwmCntndLoadModule(pmwmDspInfo,"ASYNC","ASYNC",&pmwmDspInfo->hmodAsync,szThisFile,__LINE__);
  if (ulRC)
    return ulRC;

  /***************************************************************************/
  /* Get handle to ASYNC  task                                               */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodAsync, "ASYNC", &pmwmDspInfo->hasyTask);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Free the Async Extra Segments before loading anything else              */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hasyTask,
                                "ECMPROC",
                                &pmwmDspInfo->hsegAsyncECMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegAsyncECMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegAsyncECMPROC = 0;


  /***************************************************************************/
  /* Free the Async Extra Segments before loading anything else              */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hasyTask,
                                "ACMPROC",
                                &pmwmDspInfo->hsegAsyncACMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegAsyncACMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegAsyncACMPROC = 0;



  /***************************************************************************/
  /***************************************************************************/
  /* ITCB Connections                                                        */
  /***************************************************************************/
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hasyTask,"ASYNITCB",pmwmDspInfo->hmctlTask,"ASYNITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /*********************************************************************
  ** MTS 7757 - 02/12/97 DR
  ** Connect the ITCB for V.80 Handset Snooping
  **********************************************************************/
  if (pmwmDspInfo->bCIDCapability && pmwmDspInfo->bV80HandsetSnoop) {
    ulRC=dspConnectITCB(NULL, "PRIVATE_ITCB_FOR_CID",
                        pmwmDspInfo->hmctlTask, "PRIVATE_ITCB_FOR_CID");
    if (ulRC != DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__, MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC=dspConnectITCB(NULL, "VIOITCB",
                        pmwmDspInfo->hmctlTask, "VIOITCB");
    if (ulRC != DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__, MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  } /* endif */



  /***************************************************************************/
  /* Connect GPC's                                                           */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"ATCMD",pmwmDspInfo->hmctlTask,"ATCMD",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmctlTask,"ATRESP",pmwmDspInfo->hasyTask,"ATRESP",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /* Now that all of the tasks have been loaded, It is time to call the      */
  /* AT Parser Initialization function.                                      */
  /***************************************************************************/
  ulRC = mwmParseGetTaskInfo(pmwmDspInfo->hmctlTask, pmwmDspInfo->hmtProtSupr );
  if (ulRC)
    return ulRC;


  /***************************************************************************/
  /* DCR 2635                                                                */
  /* Tell Modem Control which features are loaded.                           */
  /***************************************************************************/

  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "FEATURES", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &pmwmDspInfo->ulFeaturesToLoad, 2,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* If the INI file indicates that we should send dummy DTMF tones when     */
  /* CI tone is detected, set the flag in modem control.                     */
  /***************************************************************************/
  if( GetPrivateProfileInt("FEATURES","DTMFHACK",0,INIFile ) ) {
    ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "VBBB",
                             &ulAddress);
    if (ulRC!=DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC );
      return ulRC;
    } /* endif */

    usTempValue = 0xFFFF;
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usTempValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC );
      return ulRC;
    } /* endif */
  } /* endif */

  /**********************************************************************
  ** If the INI file indicates that we should allow checking for over-
  ** current/over-coltage conditions, set the flag in modem control.
  ***********************************************************************/
  pmwmDspInfo->bOverVoltageTestingEnabled = FALSE;
  if( GetPrivateProfileInt("FEATURES","OVERVOLTTEST",0,INIFile ) ) {
    ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "DO_OVERVOLT_TEST",
                             &ulAddress);
    if (ulRC!=DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC );
      return ulRC;
    } /* endif */

    usTempValue = 0xFFFF;
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usTempValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC );
      return ulRC;
    } /* endif */

    pmwmDspInfo->bOverVoltageTestingEnabled = TRUE;

  } /* endif */

  /***************************************************************************/
  /*                                                                         */
  /* If discrim mode but we haven't opened the discriminator yet, open it.   */
  /* If open fails, don't use discriminator.                                 */
  /*                                                                         */
  /***************************************************************************/

  /***************************************************************************/
  /* 04/25/95                                                                */
  /* Check to see if we are in Class 2 mode (this would be a resume.)        */
  /* Set the fclass variable appropriately.                                  */
  /* NOTE: We cannot do this here! We would be setting FCLASS before the     */
  /* Class 2 Async replacement is loaded and before the correct segment is   */
  /* loaded into modem control.                                              */
  /***************************************************************************/
//  ulRC = mwmParseQueryParserMode(&usParserMode);
//  if (ulRC)
//    return ulRC;
//
//  if (usParserMode & MWM_MODE_CLASS2_FAX)
//  {
//    ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "FCLASS", &ulAddress);
//    if (ulRC!=DSP_NOERROR)
//    {
//      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                     MWM_DSP_ERROR, ulRC);
//      return(ulRC);
//    }
//
//    usTempValue = 2;
//
//    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
//                          &usTempValue, 1,
//                          DSP_MEMXFER_DATA_WRITE);
//    if (ulRC!=DSP_NOERROR)
//    {
//      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
//                     MWM_DSP_ERROR, ulRC);
//      return(ulRC);
//    }
//  }




  /***************************************************************************/
  /* Connect routine to MDMCTL IPC                                           */
  /***************************************************************************/
  ulRC = mwmParseConnectIPC(pmwmDspInfo->hmctlTask, &pmwmDspInfo->hmctlIPC, 0);  // 0 means MCTL...1 means V34

  hTemphipc = pmwmDspInfo->hmctlIPC;

  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspChangeModuleState(pmwmDspInfo->hmodModem, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspChangeModuleState(pmwmDspInfo->hmodAsync, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /* Make sure we have the UART Task Handle...                               */
  /***************************************************************************/
  if (!pmwmDspInfo->hmtUART)
  {
    ulRC = mwmSpcfcQueryUARTTaskHandle(pmwmDspInfo,&pmwmDspInfo->hmtUART);
    if (ulRC)
    {
      return (ulRC);
    }
  }

  /* Load caller ID based upon the #CID setting */
  if( pmwmDspInfo->bCIDCapability )
  {
    ulRC = mwmCidlLoad(pmwmDspInfo, mwmCidpQueryCid()); /* load caller ID */
    if (ulRC)
      return ulRC;
  }

  /* Load distinctive ring based upon the -SDR setting */
  if( pmwmDspInfo->bDRingCapability )
  {
    ulRC = mwmCidlLoadDRing(pmwmDspInfo, mwmCidpQueryDRing()); /* load dist. ring */
    if (ulRC)
      return ulRC;
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDiscrimBase exit\n");  }


  return 0;
}

ULONG mwmLoadDiscrimToDial(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC = 0;
  ULONG ulAddress = 0;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDiscrimToDial entry\n");  }


  /* Load caller ID based upon the #CID setting */
  if( pmwmDspInfo->bCIDCapability )
  {
    ulRC = mwmCidlLoad(pmwmDspInfo, 0l); /* unload caller ID */
    if (ulRC)
      return ulRC;
  }

  /* unload distinctive ring  */
  if( pmwmDspInfo->bDRingCapability )
  {
    ulRC = mwmCidlLoadDRing(pmwmDspInfo, 0L); /* unload dist. ring */
    if (ulRC)
      return ulRC;
  }

  mwmLoadSetCurrentSpeed(pmwmDspInfo);


  if ((pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34) |
      (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V32TER) |
      (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V32BIS) )
  {
     /************************************************************************/
     /* Kick everyone out now.  Chances are we will have to kick them out    */
     /* later anyway.  This gives us a better chance at preventing memory    */
     /* fragmentation problems                                               */
     /************************************************************************/
     mwmCntndContend(pmwmDspInfo, 0);
  }

//  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
//  {
//    (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"rad1.snp");
//  }


//  MessageBox(NULL,"Just after creating rad1.snp\n",NULL,MB_TASKMODAL | MB_OK);

  /***************************************************************************/
  /* 07/24/95                                                                */
  /* MTS 5153                                                                */
  /* Get the Address of the DIALT Segment Pointer.                           */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "ADRDIALT", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  /***************************************************************************/
  /* 07/24/95                                                                */
  /* MTS 5153                                                                */
  /* Dynamically load MCTLs DIALT Segment                                    */
  /***************************************************************************/
  ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                             "MAINFILE",
                             "MDMDIALT",
                             "MDMDIALT",
                             pmwmDspInfo->hmctlTask,
                             &pmwmDspInfo->hsegMCTLDIALT,
                             ulAddress,
                             szThisFile , __LINE__, MWM_MUSTHAVE );
  if (ulRC)
    return (ulRC);


  ulRC = mwmLoadInterpolator(pmwmDspInfo);
  if (ulRC)
    return ulRC;

  ulRC = mwmLoadCallProgress(pmwmDspInfo);
  if (ulRC)
    return ulRC;

//  ulRC = mwmCntndLoadModule(pmwmDspInfo,"INTERP","C96",&pmwmDspInfo->hmodInterpolator,szThisFile,__LINE__);
//  if (ulRC)
//    return ulRC;



//  ulRC = mwmCntndLoadModule(pmwmDspInfo,"CALLPROG","CALLPROG",&pmwmDspInfo->hmodCallProg,szThisFile,__LINE__);
//  if (ulRC)
//    return ulRC;

  /***************************************************************************/
  /* Get CallProg Task handle                                                */
  /***************************************************************************/
//  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodCallProg, "CALLPROG",
//                             &pmwmDspInfo->hmtCallProg);
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC);
//    return(ulRC);
//  }

  /***************************************************************************/
  /* Get CallProgMove Task handle                                            */
  /***************************************************************************/
//  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodCallProg, "MOVE",
//                             &pmwmDspInfo->hmtCallProgMove);
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC);
//    return(ulRC);
//  }



//  ulRC = mwmSpcfcSetUpCP_Parms(pmwmDspInfo, pmwmDspInfo->hmtCallProg);
//  if (ulRC)
//    return(ulRC);



  /***************************************************************************/
  /* Get handle to INTERP task                                               */
  /***************************************************************************/
//  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodInterpolator, "C96", &pmwmDspInfo->hinterpTask);
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }




  /***************************************************************************/
  /***************************************************************************/
  /* ITCB Connections                                                        */
  /***************************************************************************/
  /***************************************************************************/
//  ulRC=dspConnectITCB(pmwmDspInfo->hinterpTask,"C96ITCB",pmwmDspInfo->hmctlTask,"C96ITCB");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }

  /***************************************************************************/
  /* Call Progress ITCB to Modem Control.                                    */
  /***************************************************************************/
//  ulRC=dspConnectITCB(pmwmDspInfo->hmtCallProg,"CPITCB",pmwmDspInfo->hmctlTask,"CPITCB");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  /***************************************************************************/
  /* Make GPC Connections...                                                 */
  /***************************************************************************/
//  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",pmwmDspInfo->hinterpTask,"SIGIN",0,NULL,
//                        pmwmDspInfo, szThisFile,__LINE__ );
//  if (ulRC)
//    return(ulRC);

//  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hinterpTask,"SIGOUT",NULL,"CDDAC_INPUT",0,NULL,
//                          pmwmDspInfo, szThisFile,__LINE__ );
//  if (ulRC)
//    return(ulRC);

//  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",pmwmDspInfo->hmtCallProgMove,"MOVEIN",0,NULL,
//                          pmwmDspInfo, szThisFile,__LINE__ );
//  if (ulRC)
//    return(ulRC);



//  ulRC = dspChangeModuleState(pmwmDspInfo->hmodInterpolator, DSP_ACTIVATE_ACTIVE );
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }

//  ulRC = dspChangeModuleState(pmwmDspInfo->hmodCallProg, DSP_ACTIVATE_ACTIVE );
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
  {
    (*(pfnWriteDSPSnapshot))(pmwmDspInfo->hDSP,"dial.snp");
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDiscrimToDial exit\n");  }


  return 0;
}

/*****************************************************************************/
/* If the specified module is loaded on the DSP, adjust the speed to the     */
/* lower of the current speed and the speed given in the ini file for this   */
/* module                                                                    */
/*****************************************************************************/
ULONG  mwmLoadAdjustSpeed(PMWM_DSPINFO pmwmDspInfo, PULONG pulCurrSpeed,
                          char *pszStartupSpeed,
                          char *pszModName)
{
  ULONG    ulTmpSpeed;
  RC       ulRC;
  HMOD     hmodx;
  ULONG    ulTempModemPriority;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadAdjustSpeed entry\n");  }


  ulRC = dspNameToModuleHandle( pszModName, &hmodx);
  if (ulRC == DSP_NOERROR)
  {
    if (!strcmp(pszModName,"Synth"))
    {
      /***********************************************************************/
      /* 05/02/96                                                            */
      /* MTS 6601 Try to bump MIDI synth at a low priority before giving up. */
      /* ...Look, this wasn't my idea....                                    */
      /***********************************************************************/
      ulTempModemPriority = pmwmDspInfo->ulModemPriority;

      pmwmDspInfo->ulModemPriority = pmwmDspInfo->ulModemPriorityMIDIGameMode;

      mwmCntndContend(pmwmDspInfo, 0);

      pmwmDspInfo->ulModemPriority = ulTempModemPriority;

      /***********************************************************************/
      /* Check AGAIN to see if the synth is still here...                    */
      /***********************************************************************/
      ulRC = dspNameToModuleHandle( pszModName, &hmodx);
    }

    if (ulRC == DSP_NOERROR)
    {
      ulTmpSpeed = GetPrivateProfileInt("STARTUP",pszStartupSpeed, 64000,
                                         INIFile);

      switch(ulTmpSpeed)
      {
        case 2400:
          ulTmpSpeed = MW_START2400;      break;
        case 9600:
          ulTmpSpeed = MW_START9600;      break;
        case 14400:
          ulTmpSpeed = MW_START14400;     break;
        case 19200:
          ulTmpSpeed = MW_START19200;     break;
        case 28800:
        case 33600:
          if (pmwmDspInfo->ulInstalledFeatures & FEATURE_V34EM) {
            ulTmpSpeed = MW_START33600;
          } else {
            ulTmpSpeed = MW_START28800;
          } /* endif */
          break;
        case 64000:
          ulTmpSpeed = MW_START64000;     break;
        default:
          ulTmpSpeed = *pulCurrSpeed;     break;
      }

      DPF("%s is already loaded, Cur speed = %ld, compat. speed = %ld" ,
          pszModName, *pulCurrSpeed, ulTmpSpeed);

      *pulCurrSpeed = min( *pulCurrSpeed, ulTmpSpeed);

    }
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadAdjustSpeed exit\n");  }


  return 0;
}

ULONG  mwmLoadSetCurrentSpeed(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulCurrSpeed;
  ULONG ulRC;
  REGISTERS Registers;
  const int fTemp = TRUE;
  USHORT usFCLASS;
  USHORT usSubMode;

  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed entry, pmwmDspInfo->ulLongTermFeatures %lx\n",pmwmDspInfo->ulLongTermFeatures);  }


  if (pmwmDspInfo->ulLongTermFeatures & FEATURE_PCM)
    ulCurrSpeed = MW_START64000;
  else if (pmwmDspInfo->ulLongTermFeatures & FEATURE_V34EM)
    ulCurrSpeed = MW_START33600;
  else if (pmwmDspInfo->ulLongTermFeatures & FEATURE_V34)
    ulCurrSpeed = MW_START28800;
  else if (pmwmDspInfo->ulLongTermFeatures & FEATURE_V32TER)
    ulCurrSpeed = MW_START19200;
  else if (pmwmDspInfo->ulLongTermFeatures & FEATURE_V32BIS)
    ulCurrSpeed = MW_START14400;
  else if (pmwmDspInfo->ulLongTermFeatures & FEATURE_V32)
    ulCurrSpeed = MW_START9600;
  else
    ulCurrSpeed = MW_START2400;


  ulRC=mwmParseQueryModemRegisters(&Registers);
  if (ulRC) return ulRC;

  /***************************************************************************/
  /* MTS 6129 04/30/96                                                       */
  /* If V.23 is enabled, then ignore above settings, and force speed to      */
  /* "2400".  This will turn off automode.                                   */
  /* Since V.23 is "almost" like V.22bis, we can fake out most of the modem  */
  /* driver and all of modem control to treat this like a V.22bis connection */
  /***************************************************************************/
  { MW_SYSLOG_3(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed,ulFeaturesToLoad %lx ulDialingModem %lx \n",
		pmwmDspInfo->ulFeaturesToLoad, pmwmDspInfo->ulDialingModem);  }

  if ((pmwmDspInfo->ulFeaturesToLoad   & FEATURE_V23) &&
      (pmwmDspInfo->ulDialingModem))
    {
      ulCurrSpeed = MW_START2400;              // Don't allow any automoding this call.
      { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed entry, setting ulCurrSpeed to MW_START2400 %x\n",MW_START2400);  }
      
      pmwmDspInfo->ulFeaturesToLoad &= ~FEATURE_V42PRELOAD;  /* MTS 7414 */
      pmwmDspInfo->ulFeaturesToLoad &= ~FEATURE_MNPPRELOAD;  /* MTS 7414 */
      mwmSpcfcSetProtocol(pmwmDspInfo, 0, 1);  // Turn off MNP and V.42 for this call.
    }
  else
    {
      /*************************************************************************/
      /* MTS 6939 05/23/96 Tim                                                 */
      /*                                                                       */
      /* Either we are not dialing, or V.23 is not enabled.                    */
      /* In either case, we don't want V.23                                    */
      /*                                                                       */
      /* In the case of answering (!Dialing), we need to disable V.23 for this */
      /* call.                                                                 */
      /* If it was not enabled, there will be no change by making this call... */
      /*************************************************************************/
      pmwmDspInfo->ulFeaturesToLoad &= ~FEATURE_V23;
      ulRC = mwmSpcfcSetFeatures(pmwmDspInfo, 1);
      if (ulRC)
	return (ulRC);
      
    }
  
  // if V.80 mode, disable MNP/V.42 via mwmSpcfcSetProtocol
  // (just like V.23 above, except don't disable the preload flags)
  if (pmwmDspInfo->ulFeaturesToLoad   & FEATURE_V80)   // if v80 enabled
    {
      ulRC = mwmFaxGetFCLASS(pmwmDspInfo, &usFCLASS, &usSubMode);
      if (ulRC!=DSP_NOERROR)
	{
	  return(ulRC);
	}
      if (usFCLASS == 0 && usSubMode == 1)  // if we're in v80 mode
	{
	  mwmSpcfcSetProtocol(pmwmDspInfo, 0, 1);  // Turn off MNP and V.42 for this call.
	} /* endif */
    } /* endif */
  
  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed entry, ulCurrSpeed0 %lx\n",ulCurrSpeed);  }
  
  ulRC = mwmLoadAdjustSpeed(pmwmDspInfo, &ulCurrSpeed, "SB_Speed",    "sbbios");
  if (ulRC)
    return (ulRC);
  
  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed entry, ulCurrSpeed1 %lx\n",ulCurrSpeed);  }
  
  ulRC = mwmLoadAdjustSpeed(pmwmDspInfo, &ulCurrSpeed, "SBP_Speed",   "sbpbios");
  if (ulRC)
    return (ulRC);
  
  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed entry, ulCurrSpeed2 %lx\n",ulCurrSpeed);  }
  
  ulRC = mwmLoadAdjustSpeed(pmwmDspInfo, &ulCurrSpeed, "Synth_Speed", "Synth");
  if (ulRC)
    return (ulRC);
  
  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed entry, ulCurrSpeed3 %lx\n",ulCurrSpeed);  }
  
  /*************************************************************************/
  /* 06/08/95                                                              */
  /* MTS 5297 Step back speed for MPEG                                     */
  /*************************************************************************/
  ulRC = mwmLoadAdjustSpeed(pmwmDspInfo, &ulCurrSpeed, "MPEG_Speed", "MPEGA");
  if (ulRC)
    return (ulRC);
  
  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed entry, ulCurrSpeed4 %lx\n",ulCurrSpeed);  }
  
  /*************************************************************************/
  /* 05/01/95                                                              */
  /* Check S30 to see if we need to lower max speed.                       */
  /* S30 bit definitions....                                               */
  /*  15-4   Reserved.                                                     */
  /*     3   Disable V.34                                                  */
  /*     2   Disable V.34 and V.32bis                                      */
  /*     1   Disable V.8 (Not implemented...)                              */
  /*     0   Disable CI  (Not implemented...)                              */
  /*************************************************************************/
  /* Bit 3 means no V.34...set max speed at or below 14400                 */
  /*************************************************************************/
  // MTS6384 if (Registers.S[30] & 0x0008)
  { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed entry, SV34  %x\n",Registers.SV34[0]);  } 
  if (Registers.SV34[0] & 0x0008)
    {
      ulCurrSpeed = min(MW_START14400,ulCurrSpeed);
      { MW_SYSLOG_ERROR(LOG_ERR,"mwmload::mwmLoadSetCurrent Speed, setting ulCurrSpeed to %lx after SV34[0] bit 3 was on!!\n", ulCurrSpeed); }
    }
  
  /*************************************************************************/
  /* Bit 2 means no V.34 or V.32bis...set max speed at 2400                */
  /*************************************************************************/
  // MTS6384 if (Registers.S[30] & 0x0004)
  if (Registers.SV34[0] & 0x0004)
    {
      ulCurrSpeed = min(MW_START2400,ulCurrSpeed);
      { MW_SYSLOG_ERROR(LOG_ERR,"mwmload::mwmLoadSetCurrent Speed, setting ulCurrSpeed to %lx after SV34[0] bit 2 was on!!\n", ulCurrSpeed); }
    }
  
  /*************************************************************************/
  /* Set new speed, but don't set long term features                       */
  /*************************************************************************/
  /*  if (ulCurrSpeed != 6) {
      ulCurrSpeed=6;
      { MW_SYSLOG_ERROR(LOG_ERR,"mwmload::mwmLoadSetCurrent Speed, resetting ulCurrSpeed to %x!!\n", ulCurrSpeed); }
      } */
    
    mwmSpcfcSetSpeed(pmwmDspInfo, (USHORT)ulCurrSpeed, fTemp);
    
    { MW_SYSLOG_2(TRACE_MWMLW32,"mwmload::mwmLoadSetCurrentSpeed exit, ulCurrSpeed %lx\n",ulCurrSpeed);  }
    
    
    return 0;
}


/*****************************************************************************/
/* This routine conditionally loads the following modules on top of the      */
/* Discriminator Base.                                                       */
/*  1. V22            ----V22.DSP                                            */
/*  2. V32            ----V32.DSP, V32BIS.DSP, V32TER.DSP, or V34.DSP        */
/*  5. V42            ----V42.DSP                                            */
/*  7. Call Progress --------CPROG.DSP                                       */
/*  8. Interpolator ---------C96441.DSP                                      */
/*  9.  VDETECT       ----VDETECT.DSP                                        */
/*                                                                           */
/* 3/02/94 - don't load these until we get the connection.                   */
/*  3. MNP            ----MNP.DSP                                            */
/*  4. MNP5           ----MNP5.DSP                                           */
/*  6. V42BIS         ----V42BIS.DSP                                         */
/* This routine loads these modules and makes the proper connections.        */
/*****************************************************************************/
ULONG mwmLoadDialToModem(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC;
  USHORT usTempValue;
  ULONG  ulAddress;
  USHORT usValue = 0;
  ULONG  usDoConnectV34 = 1;
  ULONG  usDoConnectV32 = 1;
  USHORT usUseV32BISStubTask = 0;
  USHORT usCoreChunkAddress = 0;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDialToModem entry\n");  }


  /***************************************************************************/
  /* 04/26/95 MTS 3073                                                       */
  /* Allocate the CORECHUNK which will be needed by V.32bis and V.34         */
  /* This chunk must be 1792 words long instead of the 768 words used by the */
  /* rest of the chunks.                                                     */
  /* The first 256 words                                                     */
  /***************************************************************************/
  ulRC = mwmPoolAllocateCoreChunk(pmwmDspInfo, &usCoreChunkAddress);
  if (ulRC)
    return ulRC;


  { MW_SYSLOG_3(TRACE_MWMLW32,"mwmload::mwmLoadDialToModem ulFeaturesToLoad %lx hmodV34 %lx\n",pmwmDspInfo->ulFeaturesToLoad,(unsigned long)pmwmDspInfo->hmodV34);  }
  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34 ) &&
      (!pmwmDspInfo->hmodV34))
  {
    ulRC = mwmLoadV34(pmwmDspInfo, FALSE);
    if (ulRC) {
      return(ulRC);
    } /* endif */
  }
  else
    usDoConnectV34 = 0;


  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE ) &&
      (pmwmDspInfo->hmodVDP) )
    /*************************************************************************/
    /* If V.32 is already loaded, then we can assume V32STATIC.              */
    /* In this case, we don't need to reconnect V.32 to the rest of the      */
    /* system.                                                               */
    /*************************************************************************/
    usDoConnectV32 = 0;

//  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
//  {
//    (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"rad2.snp");
//  }

  /***************************************************************************/
  /* Determine which (if any) of the High Speed Datapumps to load.           */
  /***************************************************************************/
  if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V32 ) &&
       (!pmwmDspInfo->hmodVDP) )
  {
    ulRC = mwmCntndLoadModule(pmwmDspInfo,"V32FILE","V32",&pmwmDspInfo->hmodVDP,szThisFile,__LINE__);
    if (ulRC)
      return ulRC;

  }
  else
  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V32BIS ) &&
      (!pmwmDspInfo->hmodVDP) )
  {

    /*******************************************************************
    ** Check to see if we should load the V.32bis Stub Task   DR 1/10/97
    ********************************************************************/
    if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V32BISSTUB ) {
      DPF("Using the V.32bis Stub Task...");
      usUseV32BISStubTask = 1;
      ulRC = mwmCntndLoadModule(pmwmDspInfo, "V32STUB", "V32STUB", &pmwmDspInfo->hmodVDP,szThisFile,__LINE__);
      if (ulRC)
        return ulRC;

      ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "V32SFLAG", &ulAddress);
      if (ulRC!=DSP_NOERROR) {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      } /* endif */

      usValue = 0xFFFF;
      ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                            &usValue, 1, DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR) {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      } /* endif */

    } else {
      ulRC = mwmCntndLoadModule(pmwmDspInfo,"DATAPUMP1","V32",&pmwmDspInfo->hmodVDP,szThisFile,__LINE__);
      if (ulRC)
       return ulRC;
    } /* endif */

  }
  else
  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V32TER ) &&
      (!pmwmDspInfo->hmodVDP) )
  {
    ulRC = mwmCntndLoadModule(pmwmDspInfo,"DATAPUMP2","V32",&pmwmDspInfo->hmodVDP,szThisFile,__LINE__);
    if (ulRC)
      return ulRC;

  }





  /***************************************************************************/
  /* Get vdp task handle                                                     */
  /* ...If ANY of the high speed pumps are loaded.                           */
  /* Give the stub task a different name if it was loaded.    1/10/97        */
  /***************************************************************************/
  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE )
  {
    if (!usUseV32BISStubTask) {
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodVDP, "V32", &pmwmDspInfo->hvdpTask);
    } else {
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodVDP, "V32STUB", &pmwmDspInfo->hvdpTask);
    } /* endif */

    if (ulRC != DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    } /* endif */
  }

  /***************************************************************************/
  /* Free the V32 segments if it was loaded here...                          */
  /***************************************************************************/
  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE ) &&
      (usDoConnectV32))
  {
    ulRC = mwmPumpsFreeVDPSegments(pmwmDspInfo);
    if (ulRC)
      return ulRC;
  }



  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 ) &&
      ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42PRELOAD) )
//  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 )
  {
    ulRC = mwmCntndLoadModule(pmwmDspInfo,"V42","V42",&pmwmDspInfo->hmodV42,szThisFile,__LINE__);
    if (ulRC)
      return ulRC;
    /*************************************************************************/
    /* Get v42PKT Task handle                                                */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "V42PKT", &pmwmDspInfo->hmtV42PKT);
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }



    /*************************************************************************/
    /* Get LAPDLC Task handle                                                */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "DLC", &pmwmDspInfo->hmtV42LAPDLC);
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }

    /*************************************************************************/
    /* Get V42MAC Task handle                                                */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "V42MAC", &pmwmDspInfo->hmtV42MAC);
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }

    /*************************************************************************/
    /* Get LAPDLCxmit Task handle.  Not always present in V42!               */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "DLCxmit", &pmwmDspInfo->hmtV42LAPDLCxmit);
    if (ulRC != DSP_NOERROR)
    {
      pmwmDspInfo->hmtV42LAPDLCxmit = NULL;
    }

    /*************************************************************************/
    /* Get V42MACxmit Task handle.  Not always present in V42!               */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "V42MACxmit", &pmwmDspInfo->hmtV42MACxmit);
    if (ulRC != DSP_NOERROR)
    {
       pmwmDspInfo->hmtV42MACxmit = NULL;
    }


    /***********************************************************************/
    /* Get the Address of the UI_addr Segment Pointer.                     */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtV42PKT, "UI_addr", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }


    ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmtV42PKT,
                                  "UI_SEG",
                                  &pmwmDspInfo->hsegV42UI_seg);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }


    /*************************************************************************/
    /* Free the UI_seg until we need it for ONLINE state                     */
    /*************************************************************************/
    ulRC = dspFreeSegment(pmwmDspInfo->hsegV42UI_seg);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegV42UI_seg = 0;
  }




  /***************************************************************************/
  /* Only load MNP here if we are NOT an Automode modem....otherwise, we will*/
  /* load it during negotiation.                                             */
  /***************************************************************************/
  if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP ) &&
       (pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNPPRELOAD) )
  {
    ulRC = mwmCntndLoadModule(pmwmDspInfo,"MNP","MNP",&pmwmDspInfo->hmodMNP,szThisFile,__LINE__);
    if (ulRC)
      return ulRC;

    /*************************************************************************/
    /* Get MNP Task handle                                                   */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodMNP, "MNP", &pmwmDspInfo->hmtMNP);
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
  }




  /***************************************************************************/
  /* 04/30/96 If V.23 is enabled, then we should use it instead of V.22bis...*/
  /* MTS 6129                                                                */
  /***************************************************************************/
  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V23 )
  {
    ulRC = mwmCntndLoadModule(pmwmDspInfo,"V23","V22",&pmwmDspInfo->hmodV22,szThisFile,__LINE__);
    if (ulRC)
      return ulRC;
  }
  else
  {
    // This must be a standard V.22bis setup, load V.22bis...
    ulRC = mwmCntndLoadModule(pmwmDspInfo,"V22FILE","V22",&pmwmDspInfo->hmodV22,szThisFile,__LINE__);
    if (ulRC)
      return ulRC;
  }


  /***************************************************************************/
  /* Get v22 Task handle                                                     */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV22, "V22", &pmwmDspInfo->hv22Task);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = mwmLoadPSV8ITCBSettings(pmwmDspInfo);
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /* if V.8 flag is set, load the V.8 task...                                */
  /***************************************************************************/
  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V8 )
  {
    ulRC = mwmLoadV8AndConnect(pmwmDspInfo);
    if (ulRC)
      return(ulRC);
  }



  /***************************************************************************/
  /* If MNP is loaded, make the appropriate connections.                     */
  /* These connections will depend on whether V.42 is loaded.                */
  /* If V.42 is loaded, it (by default) connected to the Datapump.           */
  /***************************************************************************/
  /***************************************************************************/
  /* Only load MNP here if we are NOT an Automode modem....otherwise, we will*/
  /* load it during negotiation.                                             */
  /***************************************************************************/
  /***************************************************************************/
  /* MTS 3239  .. Check to make sure MNP needs to be loaded...in addition to */
  /*           checking if it is to be PREloaded.                            */
  /***************************************************************************/
  if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP ) &&
       ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNPPRELOAD )  )
  {
//    ulRC = mwmLoadMakeMNPConnections(pmwmDspInfo,2400);
    ulRC = mwmLoadMakeMNPConnections(pmwmDspInfo,pmwmDspInfo->hv22Task);
    if (ulRC)
      return ulRC;
  } // if MNP


  /***************************************************************************/
  /* If V.42 is loaded, make the appropriate connections.                    */
  /***************************************************************************/
  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 ) &&
      ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42PRELOAD) )
  {
    ulRC = mwmLoadMakeV42Connections(pmwmDspInfo,pmwmDspInfo->hv22Task);
    if (ulRC)
      return ulRC;
  } // if MNP


  /***************************************************************************/
  /* Connect Datapump to whatever modem is available.                        */
  /* This call must be made after all other modules are loaded, because      */
  /* connections from the datapump(s) to the other modules are made in this  */
  /* routine.                                                                */
  /***************************************************************************/
  ulRC = mwmPumpsMakeV22Connections(pmwmDspInfo);
  if (ulRC)
   return ulRC;

  /*************************************************************
  ** Let V.22 know which V.34 data pump is loaded.
  **************************************************************/
  usValue = pmwmDspInfo->usPCMValue & FEATURE_X2;
  //if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {
  //  usValue = pmwmDspInfo->usPCMValue;
  //} /* endif */

  ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hv22Task,
                                "PCMCTL", DSP_MEMXFER_DATA_WRITE, 1,
                                &usValue, szThisFile, __LINE__ );
  if (ulRC != DSP_NOERROR) {
    return(ulRC);
  } /* endif */



  if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE ) &&
       (usDoConnectV32) )
  {
    /* Add V.32bis Stub Task Condition  DR 1/10/97 */
    ulRC = mwmPumpsMakeVDPConnections(pmwmDspInfo, usUseV32BISStubTask);
    if (ulRC)
     return ulRC;
  }

  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34 ) &&
      (usDoConnectV34))
  {
    ulRC = mwmPumpsMakeV34Connections(pmwmDspInfo);
    if (ulRC)
     return ulRC;
  }




  /***************************************************************************/
  /* Switch from Dummy to V.22 Datapump.                                     */
  /***************************************************************************/
  ulRC = mwmLoadSwapDatapumpITCB(pmwmDspInfo, 1);
  if (ulRC)
    return ulRC;



  /***************************************************************************/
  /* Activate modules...                                                     */
  /***************************************************************************/
  ulRC = dspChangeModuleState(pmwmDspInfo->hmodV22, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodVDP, DSP_ACTIVATE_ACTIVE );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34 )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodV34, DSP_ACTIVATE_ACTIVE );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  /***************************************************************************/
  /* Only load MNP here if we are NOT an Automode modem....otherwise, we will*/
  /* load it during negotiation.                                             */
  /***************************************************************************/
  /***************************************************************************/
  /* MTS 3239                                                                */
  /***************************************************************************/
  if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP ) &&
       ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNPPRELOAD ) )
  {
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodMNP, DSP_ACTIVATE_ACTIVE );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }


  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 ) &&
      ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42PRELOAD) )
//  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 )
  {

    ulRC = dspChangeModuleState(pmwmDspInfo->hmodV42, DSP_ACTIVATE_ACTIVE );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  /***************************************************************************/
  /* Set AUTOMODE flag                                                       */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "AUTOMODE", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE )
    usTempValue=1;
  else
    usTempValue=0;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  /***************************************************************************/
  /* Set LOADDONE flag                                                       */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "LOADDONE", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  usTempValue = 1;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
  {
    (*(pfnWriteDSPSnapshot))(pmwmDspInfo->hDSP,"modem.snp");
  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDialToModem exit\n");  }


  return 0;
}


/****************************************************************************/
/* Load the C96 interpolator (9.6-44K) on systems without the VOICE96 dac   */
/* and connect it to the 44.1 CDDAC input.                                  */
/*                                                                          */
/* If the VOICE96 dac is available, load the C96F task which just does gain */
/* control.                                                                 */
/****************************************************************************/
ULONG mwmLoadInterpolator(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC = 0;
  char  *pszInterp[] = {"INTERP",      "INTERPF" };
  char  *pszInst[]   = {"C96",         "C96F" };
  char  *pszDAC[]  =   {"CDDAC_INPUT", "VOICE96_INPUT" };
  int   INTERP = 0;
  ULONG ulMeioData = 0;         // init since older MEIOs don't
  ULONG ulMeioDataSize = sizeof (ulMeioData);

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadInterpolator entry\n");  }


  ulRC = dspMeioQuery( hMEIO, QADAPTER, &ulMeioDataSize, &ulMeioData);
  if (!ulRC &&
       ulMeioData & MACF_V96)
  {
     DPF("Use v96 interp");
     INTERP = 1;
  }

  ulRC = mwmCntndLoadModule(pmwmDspInfo,pszInterp[INTERP],pszInst[INTERP],&pmwmDspInfo->hmodInterpolator,szThisFile,__LINE__);
  if (ulRC)
    return ulRC;

  /***************************************************************************/
  /* Get handle to INTERP task                                               */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodInterpolator, "C96", &pmwmDspInfo->hinterpTask);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hinterpTask,"C96ITCB",pmwmDspInfo->hmctlTask,"C96ITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",pmwmDspInfo->hinterpTask,"SIGIN",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hinterpTask,"SIGOUT",NULL,pszDAC[INTERP],0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);




  ulRC = dspChangeModuleState(pmwmDspInfo->hmodInterpolator, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadInterpolator exit\n");  }


  return 0;
}



/*****************************************************************************/
/* This routine responds to the "ECC Protocols Selected" IPC from MCTL.      */
/* Currently defined as CNTLSTAT = 13                                        */
/* Functions of this routine:                                                */
/*  1. Unload any unneeded EC task (MNP or V.42).                            */
/*  2. Load the proper compression task.  (MNP5 or V.42BIS)                  */
/*  3. Change MNP/V.42/Async/UART cycles.                                    */
/*****************************************************************************/
ULONG mwmLoadCarrierDetectToProtocol(PMWM_DSPINFO pmwmDspInfo)
{

  ULONG              ulAddressSTATUS = 0;
  ULONG              ulAddress = 0;
  USHORT             usValue = 0;
  MWM_MODEM_STATUS   ModemStatus;
  USHORT             usMaxLineSpeed=0;
  ULONG   ulRC;
  #ifdef DEBUG
  char pszDebugString[80] = "\0";
  #endif


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadCarrierDetectToProtocol entry\n");  }



  /***************************************************************************/
  /* Get the Modem Status (So that we will know what ECC Protocols were      */
  /* selected).                                                              */
  /***************************************************************************/
   ulRC = mwmSpcfcQueryModemStatus(pmwmDspInfo,&ModemStatus,&ulAddressSTATUS);
   if (ulRC!=DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC );
     return ulRC;
   }

  #ifdef DEBUG
  sprintf(pszDebugString,"PROTOCOL: 0x%04x ",ModemStatus.usProtocol);
  if (ModemStatus.usProtocol & MWM_STATUS_V22BIS_CONNECT)
    strcat(pszDebugString,"V.22bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V32BIS_CONNECT)
    strcat(pszDebugString,"V.32bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT)
    strcat(pszDebugString,"V.34 ");
  if (ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT)
    strcat(pszDebugString,"PCM ");
  if (ModemStatus.usProtocol & MWM_STATUS_MNP_CONNECT)
    strcat(pszDebugString,"MNP ");
  if (ModemStatus.usProtocol & MWM_STATUS_MNP5_CONNECT)
    strcat(pszDebugString,"MNP5 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V42_CONNECT)
    strcat(pszDebugString,"V.42 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V42BIS_CONNECT)
    strcat(pszDebugString,"V.42bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V120_CONNECT)
    strcat(pszDebugString,"V.120 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT)    //$8
    strcat(pszDebugString,"V.80 ");

  DPF(pszDebugString);
  #endif /* DEBUG */

  pmwmDspInfo->usConnectSpeed = ModemStatus.usLineSpeed;
  mwmParsePostMessage( WM_MWM_UPDATE_STATUS, MWM_STATE_CONNECT, 1);


  /***************************************************************************/
  /*  1. Unload any unneeded EC task (MNP or V.42).                          */
  /***************************************************************************/
  if (!(ModemStatus.usProtocol & MWM_STATUS_MNP_CONNECT))
  {
    if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP)
    {
      /***********************************************************************/
      /* MTS 2948                                                            */
      /* Reset MNP loaded flag to 0.                                         */
      /***********************************************************************/
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "MNP", &ulAddress);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }


     usValue = 0;

      ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                            &usValue, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }


      if (pmwmDspInfo->hmodMNP) {
        ulRC = dspFreeModule(pmwmDspInfo->hmodMNP);
        if (ulRC!=DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR,
                         ulRC );
          return ulRC;
        }
        pmwmDspInfo->hmodMNP = 0;
        pmwmDspInfo->hmtMNP  = 0;
      } /* endif */
    }
  }

  if (!(ModemStatus.usProtocol & MWM_STATUS_V42_CONNECT) )
  {
    if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42)
    {

      /***********************************************************************/
      /* MTS 2948                                                            */
      /* Reset V42 loaded flag to 0.                                         */
      /***********************************************************************/
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "V42", &ulAddress);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }


     usValue = 0;

      ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                            &usValue, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }

      if (pmwmDspInfo->hmodV42) {
        ulRC = dspFreeModule(pmwmDspInfo->hmodV42);
        if (ulRC!=DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR,
                         ulRC );
          return ulRC;
        }
        pmwmDspInfo->hmodV42      = 0;
        pmwmDspInfo->hmtV42PKT    = 0;
        pmwmDspInfo->hmtV42MAC    = 0;
        pmwmDspInfo->hmtV42LAPDLC = 0;
        pmwmDspInfo->hmtV42MACxmit    = 0;
        pmwmDspInfo->hmtV42LAPDLCxmit = 0;
      } /* endif */
    }
  }


  /***************************************************************************/
  /*  Allow error feedback from MNP to pump via MNPITCB                      */
  /***************************************************************************/
  if (ModemStatus.usProtocol & MWM_STATUS_MNP_CONNECT)
  {
    /*****************************************************************************/
    /* CMVC 1356 Connect this ITCB only for V.34 or V.90 connections             */
    /*****************************************************************************/
    if (pmwmDspInfo->hmodV34 && strcmp(pmwmDspInfo->achV34ModuleName, "X2"))
    {

       /* Disconnect from V42CTL */
       ulRC=dspDisconnectITCB(pmwmDspInfo->hmtProtSupr,"V42CTL",
                              pmwmDspInfo->hmtV34,"V42ITCB");

       ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"MNPITCB",
                           pmwmDspInfo->hmtV34,"V42ITCB");
       if (ulRC != DSP_NOERROR)
       {
         mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                        MWM_DSP_ERROR,
                        ulRC);
         return(ulRC);
       }

    }
  }





  /***************************************************************************/
  /* Check to make sure we have the right number of V.42bis segments         */
  /* allocated.                                                              */
  /***************************************************************************/
  ulRC = mwmPoolCleanupAfterNegotiation(pmwmDspInfo, &ModemStatus);
  if (ulRC)
    return ulRC;

  /***************************************************************************/
  /*  2. Load the proper compression task.  (MNP5 or V.42BIS)                */
  /***************************************************************************/
  if (ModemStatus.usProtocol & MWM_STATUS_V42BIS_CONNECT)
  {
    // 4/2/99 - If we fail to load, drop the call gracefully.
    ulRC = mwmCntndLoadModuleOptional(pmwmDspInfo,"V42BIS","V42BIS",&pmwmDspInfo->hmodV42bis,szThisFile,__LINE__, MWM_NOTREQD);
    if (ulRC)
    {
       DPF("ERROR! Failed to load V.42bis.\n");
       return ulRC;
    }

    /*************************************************************************/
    /* Get V.42bis Task handle                                               */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42bis, "V42BIS", &pmwmDspInfo->hmtV42bis);
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }



    /*************************************************************************/
    /* Connect V.42bis to Async on top...  Active EC Task on bottom.         */
    /*************************************************************************/
    ulRC = mwmLoadMakeV42bisConnections(pmwmDspInfo, &ModemStatus);
    if (ulRC)
      return ulRC;

    ulRC = dspChangeModuleState(pmwmDspInfo->hmodV42bis, DSP_ACTIVATE_ACTIVE );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }
  else if (ModemStatus.usProtocol & MWM_STATUS_MNP5_CONNECT)
  {
    ulRC = mwmCntndLoadModule(pmwmDspInfo,"MNP5","MNP5",&pmwmDspInfo->hmodMNP5,szThisFile,__LINE__);
    if (ulRC)
      return ulRC;

    /*************************************************************************/
    /* Get MNP5 Task handle                                                  */
    /*************************************************************************/
    ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodMNP5, "MNP5", &pmwmDspInfo->hmtMNP5);
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }

    /*************************************************************************/
    /* Connect MNP5 task to Async on Top...                                  */
    /*************************************************************************/
    ulRC = mwmLoadMakeMNP5Connections(pmwmDspInfo);
    if (ulRC)
      return ulRC;

    ulRC = dspChangeModuleState(pmwmDspInfo->hmodMNP5, DSP_ACTIVATE_ACTIVE );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }
  else
  {
    /*************************************************************************/
    /* 3/09/94                                                               */
    /* Connect Async Directly to the Protocol Task.                          */
    /* Figure out which protocol to connect to, if neither protocol is       */
    /* connected, then this is a straight ASYNC modem.  In this case, the    */
    /* DP to ASYNC connections transfer the data, we don't need to make any  */
    /* connections here.                                                     */
    /*************************************************************************/
    if (ModemStatus.usProtocol & MWM_STATUS_V42_CONNECT)
    {
      ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV42PKT,"RUSERDAT",
                         pmwmDspInfo->hasyTask,"RMNPOCT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
      if (ulRC)
        return(ulRC);

      ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"XMNPOCT",
                         pmwmDspInfo->hmtV42PKT,"XUSERDAT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
      if (ulRC)
        return(ulRC);
    }
    if (ModemStatus.usProtocol & MWM_STATUS_MNP_CONNECT)
    {
      ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMNP,"RMNPOCT",
                              pmwmDspInfo->hasyTask,"RMNPOCT",0,NULL,
                              pmwmDspInfo, szThisFile,__LINE__ );
      if (ulRC)
        return(ulRC);

      /***********************************************************************/
      /* We can always count on ASYNC                                        */
      /***********************************************************************/
      ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"XMNPOCT",
                              pmwmDspInfo->hmtMNP,"XMNPOCT",0,NULL,
                              pmwmDspInfo, szThisFile,__LINE__ );
      if (ulRC)
        return(ulRC);
    }
  }



  /***************************************************************************/
  /* Unload the interpolator here...Call progress was unloaded when we moved */
  /* from the modem to the line speed state.                                 */
  /* (at the same time V.22 was unloaded)                                    */
  /***************************************************************************/
// This is now done in LineSpeedToCarrierDetect
//  ulRC = dspFreeModule(pmwmDspInfo->hmodInterpolator);
//  if (ulRC!=DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC );
//    return ulRC;
//  }
//  pmwmDspInfo->hinterpTask      = 0;
//  pmwmDspInfo->hmodInterpolator = 0;


  /***************************************************************************/
  /* if this is a V.42 connection, load the UI_seg                           */
  /***************************************************************************/
  if (ModemStatus.usProtocol & MWM_STATUS_V42_CONNECT )
  {

    /***********************************************************************/
    /* Get the Address of the XID_addr Segment Pointer.                  $K*/
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtV42PKT, "XID_addr",          //$K
                             &ulAddress);                                 //$K
    if (ulRC!=DSP_NOERROR)                                                //$K
    {                                                                     //$K
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,                   //$K
                     MWM_DSP_ERROR, ulRC);                                //$K
      return(ulRC);                                                       //$K
    }                                                                     //$K
                                                                          //$K
    usValue = 0;                                                          //$K
                                                                          //$K
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,                   //$K
                          &usValue, 1,                                    //$K
                          DSP_MEMXFER_DATA_WRITE);                        //$K
    if (ulRC!=DSP_NOERROR)                                                //$K
    {                                                                     //$K
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,                   //$K
                     MWM_DSP_ERROR, ulRC);                                //$K
      return(ulRC);                                                       //$K
    }                                                                     //$K
                                                                          //$K
                                                                          //$K
    ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmtV42PKT,                 //$K
                                  "XID_SEG",                              //$K
                                  &pmwmDspInfo->hsegV42XID_seg);          //$K
    if (ulRC)                                                             //$K
    {                                                                     //$K
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,                   //$K
                     MWM_DSP_ERROR,                                       //$K
                     ulRC);                                               //$K
      return(ulRC);                                                       //$K
    }                                                                     //$K
                                                                          //$K
                                                                          //$K
    /*************************************************************************/
    /* Free the XID_seg since it is no longer needed                       $K*/
    /*************************************************************************/
    ulRC = dspFreeSegment(pmwmDspInfo->hsegV42XID_seg);                   //$K
    if (ulRC)                                                             //$K
    {                                                                     //$K
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,                   //$K
                     MWM_DSP_ERROR,                                       //$K
                     ulRC);                                               //$K
      return(ulRC);                                                       //$K
    }                                                                     //$K
    pmwmDspInfo->hsegV42XID_seg = 0;                                      //$K
                                                                          //$K
                                                                          //$K
    /***********************************************************************/
    /* Get the Handle of the MACDET Segment.                             $K*/
    /***********************************************************************/
                                                                          //$K
    ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmtV42MAC,                 //$K
                                  "MACDET",                               //$K
                                  &pmwmDspInfo->hsegV42DET_seg);          //$K
    if (ulRC)                                                             //$K
    {                                                                     //$K
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,                   //$K
                     MWM_DSP_ERROR,                                       //$K
                     ulRC);                                               //$K
      return(ulRC);                                                       //$K
    }                                                                     //$K
                                                                          //$K
                                                                          //$K
    /*************************************************************************/
    /* Free the MACDET segment since it is no longer needed.  This segment   */
    /* doesn't require a pointer to be zeroed since the segment cannot be    */
    /* branched into after this time.                                      $K*/
    /*************************************************************************/
    ulRC = dspFreeSegment(pmwmDspInfo->hsegV42DET_seg);                   //$K
    if (ulRC)                                                             //$K
    {                                                                     //$K
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,                   //$K
                     MWM_DSP_ERROR,                                       //$K
                     ulRC);                                               //$K
      return(ulRC);                                                       //$K
    }                                                                     //$K
    pmwmDspInfo->hsegV42DET_seg = 0;                                      //$K
                                                                          //$K
    /*************************************************************************/
    /* Get the Address of the UI_addr Segment Pointer.                       */
    /*************************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtV42PKT, "UI_addr", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    /*************************************************************************/
    /* Load the V.42 online UI Segment                                       */
    /*************************************************************************/
    ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                               "V42",
                               "UI_SEG",
                               "UI_SEG",
                               pmwmDspInfo->hmtV42PKT,
                               &pmwmDspInfo->hsegV42UI_seg,
                               ulAddress,
                               szThisFile , __LINE__, MWM_MUSTHAVE );
    if (ulRC)
      return (ulRC);

  }

  if (!(ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT))    /* if not v.80 mode */ //$8
  {

    /***************************************************************************
    ** Adjust the Async pacing now that we know the protocol and the connected
    ** speed. This will allow the pacing to be lowered from an assumed higher
    ** value the first time it was set.
    ****************************************************************************/
    switch (ModemStatus.usProtocol &
            (MWM_STATUS_V22BIS_CONNECT | MWM_STATUS_V32BIS_CONNECT |
             MWM_STATUS_V34_CONNECT | MWM_STATUS_PCM_CONNECT) )
    {
      case MWM_STATUS_V22BIS_CONNECT:
        usMaxLineSpeed = 2400;
        break;
      case MWM_STATUS_V32BIS_CONNECT:
        usMaxLineSpeed = 14400;
        break;
      case MWM_STATUS_V34_CONNECT:
        usMaxLineSpeed = 33600;
        break;
      case MWM_STATUS_PCM_CONNECT:
        usMaxLineSpeed = 64000;
        break;
    } /* endswitch */

    ulRC = mwmSpcfcSetAsyncPace( pmwmDspInfo, usMaxLineSpeed );
    if (ulRC) {
      return(ulRC);
    } /* endif */


    /***************************************************************************/
    /* If either MNP or V.42, load the Async ECMPROC.                          */
    /* Otherwise, load the Async ACMPROC                                       */
    /***************************************************************************/
    if (ModemStatus.usProtocol & (MWM_STATUS_V42_CONNECT | MWM_STATUS_MNP_CONNECT) )
    {
      /*************************************************************************/
      /* Get the Address of the Async Segment Pointer.                         */
      /*************************************************************************/
      ulRC = dspLabelToAddress(pmwmDspInfo->hasyTask, "PTR_ECM_SEG", &ulAddress);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }

      /*************************************************************************/
      /* Load the Async online code.                                           */
      /*************************************************************************/
      ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                                 "ASYNC",
                                 "ECMPROC",
                                 "ECMPROC",
                                 pmwmDspInfo->hasyTask,
                                 &pmwmDspInfo->hsegAsyncECMPROC,
                                 ulAddress,
                                 szThisFile , __LINE__, MWM_MUSTHAVE );
      if (ulRC)
        return (ulRC);
    }
    else
    {
      /*************************************************************************/
      /* Get the Address of the Async Segment Pointer.                         */
      /*************************************************************************/
      ulRC = dspLabelToAddress(pmwmDspInfo->hasyTask, "PTR_ACM_SEG", &ulAddress);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }

      /*************************************************************************/
      /* Load the %TT Segment                                                  */
      /*************************************************************************/
      ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                                 "ASYNC",
                                 "ACMPROC",
                                 "ACMPROC",
                                 pmwmDspInfo->hasyTask,
                                 &pmwmDspInfo->hsegAsyncACMPROC,
                                 ulAddress,
                                 szThisFile , __LINE__, MWM_MUSTHAVE );
      if (ulRC)
        return (ulRC);
    }
    /***************************************************************************/
    /*  3. Change Async/UART cycles.                                           */
    /***************************************************************************/
    ulRC = mwmSpcfcCarrierDetectToProtocolCPFAdjust(pmwmDspInfo,ModemStatus.usProtocol);
    if (ulRC)
      return ulRC;


  }

  ulRC = mwmcmsgWriteConnectMessage(pmwmDspInfo,&ModemStatus);
  if (ulRC)
    return ulRC;

  /*************************************************************************
  ** 11/26/96 - If Call Progress is still loaded, unload it.
  **************************************************************************/
  if (pmwmDspInfo->hmodCallProg) {
    ulRC = dspFreeModule(pmwmDspInfo->hmodCallProg);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    pmwmDspInfo->hmtCallProgMove = 0;
    pmwmDspInfo->hmtCallProg     = 0;
    pmwmDspInfo->hmodCallProg    = 0;
  } /* endif */

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadCarrierDetectToProtocol exit\n");  }


  return 0;
}





ULONG mwmLoadMakeMEIOConnections(PMWM_DSPINFO pmwmDspInfo)
{
  USHORT usLineAvailable = 1;
  ULONG  ulRC;
  ULONG ulMeioData = 0;         // init since older MEIOs don't
  ULONG  ulMeioDataSize = sizeof (ulMeioData);

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeMEIOConnections entry\n");  }


  mwmCidlInit(pmwmDspInfo);      /* Initialize caller ID variables */
  mwmCidlInitDRing(pmwmDspInfo); /*   and distinctive ring         */

  pmwmDspInfo->usMEIOToggle = GetPrivateProfileInt("FEATURES","MEIOTOGGLE",0,INIFile);

  /***************************************************************************/
  /* Connect to the V96 DAC if available, or the speaker if not.             */
  /*                                                                         */
  /***************************************************************************/
  ulRC = dspMeioQuery( hMEIO, QADAPTER, &ulMeioDataSize, &ulMeioData);
  if (!ulRC &&
       ulMeioData & MACF_V96)
  {
     DPF("Connecting meio for v96 dac");
     ulRC = mwmCntndMEIOConnect(&pmwmDspInfo->hConnect3,V96DAC_1,LINEOUT_L1,
                              0,ON, 0,
                              pmwmDspInfo,
                              MWM_STR_PHONE_LINE_IN_USE, szThisFile,__LINE__);

     ulRC = dspMeioConnect(hMEIO,&pmwmDspInfo->hConnect4, V96DAC_1,INTSPKROUT_L1,
                           0,ON,0);
  }
  else
  {
     DPF("Connecting meio for cd dac");
     if (!pmwmDspInfo->usMEIOToggle) {
       ulRC = mwmCntndMEIOConnect(&pmwmDspInfo->hConnect3,CDDAC_S1,LINEOUT_S1,
                                0,ON, 0,
                                pmwmDspInfo,
                                MWM_STR_PHONE_LINE_IN_USE, szThisFile,__LINE__);

       ulRC = dspMeioConnect(hMEIO,&pmwmDspInfo->hConnect4, CDDAC_S1,INTSPKROUT_L1,
                             0,ON,0);
     } /* endif */
  }
  DPF("mwmLoad hConnect3 = 0x%lx, hConnect4 0x%lx",pmwmDspInfo->hConnect3, pmwmDspInfo->hConnect4);

  if (mwmSpcfcQueryPhoneLine(pmwmDspInfo, &usLineAvailable))
    {
      return 1;
    }

  if (!usLineAvailable)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_USER_MESSAGE,
                     (ULONG)MWM_STR_PHONE_LINE_IN_USE);
      return 1;
    }
  /*************************************************************************/
  /* Connections to the Phone line.                                        */
  /* These connections are only made if the discriminator is NOT loaded.   */
  /* Otherwise, the connections are made by the discriminator for us.      */
  /*************************************************************************/
  ulRC = mwmCntndMEIOConnect(&pmwmDspInfo->hConnect1,TELEDAC_1,TELEOUT_1,
			     MY_OWNER_PORT|MY_USER_PORT|MY_CONNECTION,
			     UNCHANGED, 0,
			     pmwmDspInfo,
			     MWM_STR_PHONE_LINE_IN_USE, szThisFile,__LINE__);
  
  if (ulRC != MEIO_NOERROR)    // Check the error codes
    return(ulRC);
  
  
  // Connect HANDIN to TELEOUT.  The owner will be shared, and
  // the user and connections as well.
  //
  ulRC = mwmCntndMEIOConnect(&pmwmDspInfo->hConnect2,HANDIN_1,TELEOUT_1,
			     MY_USER_PORT|MY_CONNECTION, UNCHANGED, 0,
			     pmwmDspInfo,
			     MWM_STR_HANDSET_IN_USE, szThisFile,__LINE__);
  if (ulRC != MEIO_NOERROR)    // Check the error codes
    return(ulRC);
  
  
  mwmCidlCheck(pmwmDspInfo);      /* See if caller ID supported */
  mwmCidlCheckDRing(pmwmDspInfo); /*  or distinctive ring       */
  

  /***************************************************************************/
  /* PTR 1711                                                                */
  /* 12/03/93                                                                */
  /* Add this connection so that the UART cycles can be updated later.       */
  /***************************************************************************/
  ulRC = mwmCntndMEIOConnect(&pmwmDspInfo->hConnectUart,COMMTX_1,UARTOUT_1,
                            MY_OWNER_PORT|MY_USER_PORT|MY_CONNECTION,UNCHANGED,0,
                            pmwmDspInfo,
                            MWM_STR_COM_IN_USE, szThisFile,__LINE__);
  if (ulRC != MEIO_NOERROR)    // Check the error codes
     return(ulRC);

  pmwmDspInfo->usUARTMode = USE_UART;


  /*****************************************************************************/
  /* MTS 3188                                                                  */
  /* Set the UART to 1                                                         */
  /* This call should only be needed temporarily until we get a new UART build */
  /*****************************************************************************/
//  if (pmwmDspInfo->usUARTMode & USE_UART)
//  {
//    USHORT usFailed;
//    ulRC = mwmCntndSetUART(pmwmDspInfo, 1L*11000L/8L, MWM_MUSTHAVE,
//                           &usFailed,szThisFile,__LINE__);
//    if (usFailed)
//      return ulRC;
//  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeMEIOConnections exit\n");  }

  return 0;
}



/*****************************************************************************/
/* MTS 3159 Add Line Speed Parameter so that we can control which Datapump   */
/* the XMNPDATA and RMNPDATA GPCs are connected to.                          */
/*****************************************************************************/
//ULONG mwmLoadMakeMNPConnections(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed)
ULONG mwmLoadMakeMNPConnections(PMWM_DSPINFO pmwmDspInfo, HMTASK hmtDatapump)
{
  ULONG  ulRC;
  char   achBuffer[60]  = "\0";


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeMNPConnections entry\n");  }


  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMNP,"XMNPDATA",
                          hmtDatapump,"XMNPDATA",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  ulRC=mwmCntndConnectGPC(hmtDatapump,"RMNPDATA",
                          pmwmDspInfo->hmtMNP,"RMNPDATA",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"MNPCITCB",
                      pmwmDspInfo->hmtMNP,"MNPCITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"MNPITCB",
                      pmwmDspInfo->hmtMNP,"MNPITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"DETECT",
                      pmwmDspInfo->hmtMNP,"DETECT");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"VDETECT",
                      pmwmDspInfo->hmtMNP,"VDETECT");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* MTS 2948                                                                */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"EXISTITCB",
                      pmwmDspInfo->hmtMNP,"EXISTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  if (hMWQueryClient)
  {
    GetPrivateProfileString("MWQUERY","MNP", "0",
                             achBuffer,
                             60,
                             INIFile);
    if (strlen(achBuffer))
    {
      /*******************************************************************/
      /* Request mwquery to execute script command                       */
      /*******************************************************************/
    }
  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeMNPConnections exit\n");  }


  return 0;
}


ULONG mwmLoadMakeMNP5Connections(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC;
  char   achBuffer[60]  = "\0";

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeMNP5Connections entry\n");  }


  /*************************************************************************/
  /* Connect directly to Async.                                            */
  /*************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMNP5,"RMNP5OCT",
                          pmwmDspInfo->hasyTask,"RMNPOCT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"XMNPOCT",
                          pmwmDspInfo->hmtMNP5,"XMNP5OCT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  /***************************************************************************/
  /* Connect MNP5 to the MNP on the bottom (Protocol) side                   */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMNP,"RMNPOCT",
                          pmwmDspInfo->hmtMNP5,"RMNP5DATA",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMNP5,"XMNP5DATA",
                          pmwmDspInfo->hmtMNP,"XMNPOCT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);



  /***************************************************************************/
  /* Make the rest of the MNP5 connections...                                */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"MNPCITCB",
                      pmwmDspInfo->hmtMNP5,"MNPCITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* MTS 2948                                                                */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"EXISTITCB",
                      pmwmDspInfo->hmtMNP5,"EXISTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  if (hMWQueryClient)
  {
    GetPrivateProfileString("MWQUERY","MNP5", "0",
                             achBuffer,
                             60,
                             INIFile);
    if (strlen(achBuffer))
    {
      /*******************************************************************/
      /* Request mwquery to execute script command                       */
      /*******************************************************************/
    }
  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeMNP5Connections exit\n");  }


  return 0;
}


ULONG mwmLoadMakeV42Connections(PMWM_DSPINFO pmwmDspInfo, HMTASK hmtDatapump)
{
  ULONG  ulRC;
  char   achBuffer[60]  = "\0";

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeV42Connections entry\n");  }


      ulRC=mwmCntndConnectGPC(hmtDatapump,"RMNPDATA",
                              pmwmDspInfo->hmtV42MAC,"MAC_RECV",0,NULL,
                              pmwmDspInfo, szThisFile,__LINE__ );
      if (ulRC)
        return(ulRC);

      /*************************************************************************/
      /* Connect XMIT side directly to V.42                                    */
      /*************************************************************************/
      ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV42MAC,"MAC_XMT",
                              hmtDatapump,"XV42DATA",0,NULL,
                              pmwmDspInfo, szThisFile,__LINE__ );
      if (ulRC)
        return(ulRC);



  /***************************************************************************/
  /* Make the rest of the V.42 connections...                                */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"MNPCITCB",
                      pmwmDspInfo->hmtV42PKT,"MNPCITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"MNPCITCB",
                      pmwmDspInfo->hmtV42MAC,"MNPCITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"DETECT",
                      pmwmDspInfo->hmtV42MAC,"DETECT");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"V42CTL",
                      pmwmDspInfo->hmtV42PKT,"V42CTL");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"V42CTL",
                      pmwmDspInfo->hmtV42MAC,"V42CTL");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"V42CTL",
                      pmwmDspInfo->hmtV42LAPDLC,"V42CTL");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /* MTS 2948                                                                */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"EXISTITCB",
                      pmwmDspInfo->hmtV42PKT,"EXISTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* MTS 2948                                                                */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"EXISTITCB",
                      pmwmDspInfo->hmtV42MAC,"EXISTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  if (hMWQueryClient)
  {
    GetPrivateProfileString("MWQUERY","V42", "0",
                             achBuffer,
                             60,
                             INIFile);
    if (strlen(achBuffer))
    {
      /*******************************************************************/
      /* Request mwquery to execute script command                       */
      /*******************************************************************/
    }
  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeV42Connections exit\n");  }



  return 0;
}





ULONG mwmLoadMakeV42bisConnections(PMWM_DSPINFO pmwmDspInfo, MWM_MODEM_STATUS *pModemStatus)
{
  ULONG  ulRC;
  char   achBuffer[60]  = "\0";

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeV42bisConnections entry\n");  }


  /***************************************************************************/
  /* Connect V42bis to the "Base" of the compression tower.                  */
  /* In this case...Async                                                    */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV42bis,"RV42BOCT",
                          pmwmDspInfo->hasyTask,"RMNPOCT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"XMNPOCT",
                          pmwmDspInfo->hmtV42bis,"XV42BOCT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /* Connect V.42bis to the correct Protocol Task (bottom side).             */
  /***************************************************************************/

  /***************************************************************************/
  /* 3/11/94  PTR 2919                                                       */
  /***************************************************************************/
  if (pModemStatus->usProtocol & MWM_STATUS_V42_CONNECT)
  {
    /*************************************************************************/
    /* Connect V.42 to V.42bis                                               */
    /*************************************************************************/
    ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV42PKT,"RUSERDAT",
                            pmwmDspInfo->hmtV42bis,"RV42BDATA",0,NULL,
                            pmwmDspInfo, szThisFile,__LINE__ );
    if (ulRC)
      return(ulRC);

    ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV42bis,"XV42BDATA",
                            pmwmDspInfo->hmtV42PKT,"XUSERDAT",0,NULL,
                            pmwmDspInfo, szThisFile,__LINE__ );
    if (ulRC)
      return(ulRC);
  }
//else if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP)
  /***************************************************************************/
  /* 3/11/94  PTR 2919                                                       */
  /***************************************************************************/
  else if (pModemStatus->usProtocol & MWM_STATUS_MNP_CONNECT)
  {
    /*************************************************************************/
    /*************************************************************************/
    ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMNP,"RMNPOCT",
                            pmwmDspInfo->hmtV42bis,"RV42BDATA",0,NULL,
                            pmwmDspInfo, szThisFile,__LINE__ );
    if (ulRC)
      return(ulRC);

    /*************************************************************************/
    /*************************************************************************/
    ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV42bis,"XV42BDATA",
                            pmwmDspInfo->hmtMNP,"XMNPOCT",0,NULL,
                            pmwmDspInfo, szThisFile,__LINE__ );
    if (ulRC)
      return(ulRC);
  }


  /***************************************************************************/
  /* Make the rest of the required V42BIS connections...                     */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"MNPCITCB",
                      pmwmDspInfo->hmtV42bis,"MNPCITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /* Connect V.42bis to the Block of Pointers for the Memory pool.           */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"BLKPTR_ITCB",
                      pmwmDspInfo->hmtV42bis,"BLKPTR_ITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /* MTS 2948                                                                */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"EXISTITCB",
                      pmwmDspInfo->hmtV42bis,"EXISTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }



  if (hMWQueryClient)
  {
    GetPrivateProfileString("MWQUERY","V42BIS", "0",
                             achBuffer,
                             60,
                             INIFile);
    if (strlen(achBuffer))
    {
      /*******************************************************************/
      /* Request mwquery to execute script command                       */
      /*******************************************************************/
    }
  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMakeV42bisConnections exit\n");  }



  return 0;
}













ULONG mwmLoadDialToDiscrim(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDialToDiscrim entry\n");  }


  /*************************************************************************/
  /* Remove The Interpolator                                               */
  /*************************************************************************/
  if (pmwmDspInfo->hmodInterpolator !=0) //$E
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodInterpolator);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    pmwmDspInfo->hinterpTask      = 0;
    pmwmDspInfo->hmodInterpolator = 0;
  }

  /*************************************************************************/
  /* Remove Call Progress.                                                 */
  /*************************************************************************/
  if (pmwmDspInfo->hmodCallProg != 0) //$E
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodCallProg);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    pmwmDspInfo->hmtCallProgMove = 0;
    pmwmDspInfo->hmtCallProg     = 0;
    pmwmDspInfo->hmodCallProg    = 0;
  }


  if (pmwmDspInfo->hsegMCTLDIALT != 0) //$E
  {
    ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLDIALT);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
    pmwmDspInfo->hsegMCTLDIALT = 0;
  }

  /* Load caller ID based upon the #CID setting */
  if( pmwmDspInfo->bCIDCapability )
  {
    ulRC = mwmCidlLoad(pmwmDspInfo, mwmCidpQueryCid()); /* load caller ID */
    if (ulRC)
      return ulRC;
  }

  /* Load distinctive ring based upon the -SDR setting */
  if( pmwmDspInfo->bDRingCapability )
  {
    ulRC = mwmCidlLoadDRing(pmwmDspInfo, mwmCidpQueryDRing()); /* load dist. ring */
    if (ulRC)
      return ulRC;
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDialToDiscrim exit\n");  }


  return 0;
}



ULONG mwmLoadModemToDial(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG     ulRC;
  ULONG     ulAddress = 0;
  USHORT    usValue = 0;


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadModemToDial entry\n");  }


  /***************************************************************************/
  /* Swap to Dummy Datapump ITCB                                             */
  /***************************************************************************/
  ulRC = mwmLoadSwapDatapumpITCB(pmwmDspInfo, 0);
  if (ulRC)
    return ulRC;

  /***************************************************************************/
  /* Unload Modem Tasks which are not needed in Discriminator mode...        */
  /***************************************************************************/


  /***************************************************************************/
  /* 04/26/95 MTS 3073                                                       */
  /* Free the CORECHUNK 1792 word Data block used by the datapumps.          */
  /***************************************************************************/
  if (pmwmDspInfo->ahsegMemPool[0])
  {
    ulRC = mwmPoolFreeCoreChunk(pmwmDspInfo);
    if (ulRC)
      return ulRC;
  }



  /***************************************************************************/
  /* Free MNP Task                                                           */
  /***************************************************************************/
//  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP)
  if ( ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP ) &&
       (pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNPPRELOAD) )
  {

    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset MNP loaded flag to 0.                                         */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "MNP", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }


    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    if (pmwmDspInfo->hmodMNP) {
      ulRC = dspFreeModule(pmwmDspInfo->hmodMNP);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC );
        return ulRC;
      }
      pmwmDspInfo->hmodMNP = 0;
      pmwmDspInfo->hmtMNP  = 0;
    } /* endif */
  }


  /***************************************************************************/
  /* Free V.42 tasks...                                                      */
  /***************************************************************************/
  if (( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 ) &&
      ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42PRELOAD) )
//  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42)
  {

    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset V42 loaded flag to 0.                                         */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "V42", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }


    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    if (pmwmDspInfo->hmodV42) {
      ulRC = dspFreeModule(pmwmDspInfo->hmodV42);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC );
        return ulRC;
      }
      pmwmDspInfo->hmodV42       = 0;
      pmwmDspInfo->hmtV42PKT     = 0;
      pmwmDspInfo->hmtV42LAPDLC  = 0;
      pmwmDspInfo->hmtV42MAC     = 0;
      pmwmDspInfo->hmtV42LAPDLCxmit = 0;
      pmwmDspInfo->hmtV42MACxmit    =0;
    } /* endif */
  }


  /***************************************************************************/
  /* Free V22 Module                                                         */
  /***************************************************************************/

  /***********************************************************************/
  /* MTS 2948                                                            */
  /* Reset V22 loaded flag to 0.                                         */
  /***********************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "V22", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  usValue = 0;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  if (pmwmDspInfo->hmodV22)
  {
    ulRC = dspFreeModule(pmwmDspInfo->hmodV22);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    pmwmDspInfo->hv22Task = 0;
    pmwmDspInfo->hmodV22  = 0;
  } /* endif */



  /***************************************************************************/
  /* Free V34 Module                                                         */
  /***************************************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34)
  {
    if (pmwmDspInfo->hmodV34)
    {
      ulRC = dspFreeModule(pmwmDspInfo->hmodV34);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC );
        return ulRC;
      }
      pmwmDspInfo->hmtV34   = 0;
      pmwmDspInfo->hmodV34  = 0;
    }
  }

  /***************************************************************************/
  /* Free V8  Module                                                         */
  /***************************************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V8 )
  {
    if (pmwmDspInfo->hmodV8 )
    {
      ulRC = dspFreeModule(pmwmDspInfo->hmodV8 );
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC );
        return ulRC;
      }
      pmwmDspInfo->hmtV8    = 0;
      pmwmDspInfo->hmodV8   = 0;
    }
  }


  /***************************************************************************/
  /* Free VDP Module                                                         */
  /***************************************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE)
  {
    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset VDP loaded flag to 0.                                         */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "VDP", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }


    if (pmwmDspInfo->hmodVDP)
    {
      ulRC = dspFreeModule(pmwmDspInfo->hmodVDP);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC );
        return ulRC;
      }
      pmwmDspInfo->hvdpTask = 0;
      pmwmDspInfo->hmodVDP  = 0;
    }
  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadModemToDial exit\n");  }


  return 0;
}


ULONG mwmLoadLineSpeedToCarrierDetect(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG              ulAddressSTATUS = 0;
  USHORT             usMaxLineSpeed=0;
  MWM_MODEM_STATUS   ModemStatus;
  ULONG   ulRC;
  #ifdef DEBUG
  char pszDebugString[80] = "\0";
  #endif


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadLineSpeedToCarrierDetect entry\n");  }



  /***************************************************************************/
  /* Get the Modem Status (So that we will know what ECC Protocols were      */
  /* selected).                                                              */
  /***************************************************************************/
   ulRC = mwmSpcfcQueryModemStatus(pmwmDspInfo,&ModemStatus,&ulAddressSTATUS);
   if (ulRC!=DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC );
     return ulRC;
   }

  #ifdef DEBUG
  sprintf(pszDebugString,"Line Speed: %u  PROT_COL 0x%04x ",ModemStatus.usLineSpeed,
                                                            ModemStatus.usProtocol);
  if (ModemStatus.usProtocol & MWM_STATUS_V22BIS_CONNECT)
    strcat(pszDebugString,"V.22bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V32BIS_CONNECT)
    strcat(pszDebugString,"V.32bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT)
    strcat(pszDebugString,"V.34 ");
  if (ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT)
    strcat(pszDebugString,"PCM ");
  if (ModemStatus.usProtocol & MWM_STATUS_MNP_CONNECT)
    strcat(pszDebugString,"MNP ");
  if (ModemStatus.usProtocol & MWM_STATUS_MNP5_CONNECT)
    strcat(pszDebugString,"MNP5 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V42_CONNECT)
    strcat(pszDebugString,"V.42 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V42BIS_CONNECT)
    strcat(pszDebugString,"V.42bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V120_CONNECT)
    strcat(pszDebugString,"V.120 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT)     //$7
    strcat(pszDebugString,"V.80 ");

  DPF(pszDebugString);
  #endif /* DEBUG */

  switch (ModemStatus.usProtocol & (MWM_STATUS_V22BIS_CONNECT | MWM_STATUS_V32BIS_CONNECT |
                                    MWM_STATUS_V34_CONNECT | MWM_STATUS_PCM_CONNECT) )
  {
    case MWM_STATUS_V22BIS_CONNECT:
      usMaxLineSpeed = 2400;
      break;
//    case FEATURE_V32BIS: /* 14400 */
    case MWM_STATUS_V32BIS_CONNECT:
      usMaxLineSpeed = 14400;
      break;
//    case FEATURE_V32TER: /* 19200 */
    case MWM_STATUS_V34_CONNECT:
      usMaxLineSpeed = 33600;
      break;
    case MWM_STATUS_PCM_CONNECT:
      usMaxLineSpeed = 64000;
      break;
  }



  /***************************************************************************/
  /* Unload the interpolator here...Call progress was unloaded when we moved */
  /* from the modem to the line speed state.                                 */
  /* (at the same time V.22 was unloaded)                                    */
  /***************************************************************************/
  if (pmwmDspInfo->hmodInterpolator) {
    ulRC = dspFreeModule(pmwmDspInfo->hmodInterpolator);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    pmwmDspInfo->hinterpTask      = 0;
    pmwmDspInfo->hmodInterpolator = 0;
  } /* endif */

  /***************************************************************************/
  /* If MNP is installed, set the MNP Cycles appropriately.                  */
  /***************************************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP)
  {
    if (!(ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT))   //$7 if not v80 mode
    {
      ulRC = mwmSpcfcSetMNPCycles(pmwmDspInfo, usMaxLineSpeed, MWM_DETECTION_CPF);
      if (ulRC)
        return ulRC;
    }
  }





	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadLineSpeedToCarrierDetect exit\n");  }


  return 0;
}





#define fixAPIENTRY  _far _pascal _export _loadds

ULONG   /*fix*/APIENTRY QueryClientProc(ULONG  dwConversationId,
                                      USHORT wMessage,
                                      ULONG  lParam,
                                      USHORT wSize,
                                      void FAR *pBuffer)
{

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::QueryClientProc entry\n");  }

  dwConversationId = dwConversationId;
  wSize = wSize;
  pBuffer = pBuffer;
  wMessage = wMessage;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::QueryClientProc exit\n");  }



  return 0;
}



ULONG mwmLoadModemToDpCycles(PMWM_DSPINFO pmwmDspInfo)   //$G
{
  ULONG        ulRC = 0;
  ULONG        ulAddressSTATUS = 0;
  ULONG        ulAddress;
  USHORT       usValue;
  MWM_MODEM_STATUS ModemStatus;
  USHORT       ausMCDPITCB[20];

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadModemToDpCycles entry\n");  }


  /***********************************************************************
  ** Clear the PUMPSWAP flag, which will be set only if we have to do
  ** a dynamic pump reload.
  ************************************************************************/
  usValue = 0;
  ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hmctlTask,
                                "PUMPSWAP", DSP_MEMXFER_DATA_WRITE, 1,
                                &usValue, szThisFile, __LINE__);
  if (ulRC)
    return ulRC;

  /***********************************************************************/
  /* Do DP CPF Adjustment to "startup"                                   */
  /***********************************************************************/
  ulRC = mwmSpcfcQueryModemStatus(pmwmDspInfo,&ModemStatus,&ulAddressSTATUS);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC );
    return ulRC;
  }

  switch(ModemStatus.usProtocol & 0x0380)
  {
    case 0x0200:
      ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,pmwmDspInfo->hvdpTask, "SLEEPCPF");
      if (ulRC)
        return ulRC;

      /***********************************************************************/
      /* Load ASYNC2X in place of ASYNC                                      */
      /***********************************************************************/
      ulRC = mwmLoadSwapAsync(pmwmDspInfo, ASYNC2X);
      if (ulRC)
        return ulRC;

      /*******************************************************************
      ** V.90/x2 AutoModing. If the V.90 pump is loaded, and PCMCAP
      ** indicates that the remote modem supports only x2, then unload
      ** the V.90 pump and load the x2 pump.
      ********************************************************************/
      if ((pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) &&
          (pmwmDspInfo->usPCMValue & (FEATURE_V90 | FEATURE_PCM_SYMMETRIC)) &&
          (pmwmDspInfo->usPCMValue & FEATURE_X2) ) {

        ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hv22Task, "PCMCAP",
                                      DSP_MEMXFER_DATA_READ, 1, &usValue, szThisFile, __LINE__);
        if (ulRC)
          return ulRC;

        if (usValue == 1) {

          DPF("Unloading V.90...");
          ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hmtV34, "MCTLMODE",
                                        DSP_MEMXFER_DATA_READ, 19, ausMCDPITCB, szThisFile, __LINE__);
          if (ulRC)
            return ulRC;

          ulRC = dspChangeModuleState(pmwmDspInfo->hmodV34, DSP_ACTIVATE_STANDBY );
          if (ulRC != DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC);
            return(ulRC);
          } /* endif */

          ulRC = dspFreeModule(pmwmDspInfo->hmodV34);
          if (!ulRC)  {
            pmwmDspInfo->hmodV34 = NULL;
            pmwmDspInfo->hmtV34  = NULL;
          } /* endif */

          ulRC = mwmLoadV34(pmwmDspInfo, TRUE);
          if (ulRC)
            return ulRC;

          ulRC = mwmPumpsMakeV34Connections(pmwmDspInfo);
          if (ulRC)
            return ulRC;

          ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hmtV34, "MCTLMODE",
                                        DSP_MEMXFER_DATA_WRITE, 19, ausMCDPITCB, szThisFile, __LINE__);
          if (ulRC)
            return ulRC;

          usValue = 1;
          ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hmctlTask, "PUMPSWAP",
                                        DSP_MEMXFER_DATA_WRITE, 1, &usValue, szThisFile, __LINE__);
          if (ulRC)
            return ulRC;

          ulRC = dspChangeModuleState(pmwmDspInfo->hmodV34, DSP_ACTIVATE_ACTIVE );
          if (ulRC != DSP_NOERROR)
          {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC);
            return(ulRC);
          }

        } /* endif */
      } /* endif */


      /*******************************************************************/
      /* Increase Datapump Cycles                                        */
      /* 11/20/96 - Use different label for 17-MIPS systems              */
      /*******************************************************************/
      if (!pmwmDspInfo->us17MIPS) {
        ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,pmwmDspInfo->hmtV34, "STARTUPCPF");
      } else {
        ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,pmwmDspInfo->hmtV34, "STARTUPCPF17");
      } /* endif */
      if (ulRC)
        return ulRC;
      break;
    case 0x0100:
      /*******************************************************************/
      /* Decrease V.34                                                   */
      /*******************************************************************/
      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34)
      {
        ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,pmwmDspInfo->hmtV34, "SLEEPCPF");
        if (ulRC)
          return ulRC;

        ulRC = dspChangeModuleState(pmwmDspInfo->hmodV34, DSP_ACTIVATE_STANDBY );
        if (ulRC != DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        }
      }



      /*******************************************************************/
      /* Increase Datapump Cycles                                        */
      /*******************************************************************/
      /**********************************************************
      ** If the Stub task was loaded, unload it and load the
      ** regular V.32bis task and do all the setup for it.
      ***********************************************************/
      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V32BISSTUB) {

        if (pmwmDspInfo->hmodVDP) {

          /* Put the Stub task into Standby state */
          ulRC = dspChangeModuleState(pmwmDspInfo->hmodVDP, DSP_ACTIVATE_STANDBY );
          if (ulRC != DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC);
            return(ulRC);
          } /* endif */

          /* Unload the Stub task */
          ulRC = dspFreeModule(pmwmDspInfo->hmodVDP);
          if (ulRC!=DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR,
                           ulRC );
            return ulRC;
          } /* endif */
          pmwmDspInfo->hvdpTask = 0;
          pmwmDspInfo->hmodVDP  = 0;
        } /* endif */

        /* Load the real V.32bis datapump */
        ulRC = mwmCntndLoadModule(pmwmDspInfo,"DATAPUMP1","V32",&pmwmDspInfo->hmodVDP,szThisFile,__LINE__);
        if (ulRC)
          return ulRC;

        /* Get the V32 task handle */
        ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodVDP, "V32", &pmwmDspInfo->hvdpTask);
        if (ulRC != DSP_NOERROR) {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        } /* endif */

        /* Free the V.32bis segments */
        ulRC = mwmPumpsFreeVDPSegments(pmwmDspInfo);
        if (ulRC)
          return ulRC;

        /* Set the Flag in the V.32bis task so it knows we used the Stub task */
        ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "V32STUBFLAG", &ulAddress);
        if (ulRC!=DSP_NOERROR) {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        } /* endif */

        usValue = 1;
        ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                              &usValue, 1, DSP_MEMXFER_DATA_WRITE);
        if (ulRC!=DSP_NOERROR) {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        } /* endif */

        /* Make the ITCB and GPC Connections for the real V.32bis */
        ulRC = mwmPumpsMakeVDPConnections(pmwmDspInfo, FALSE);
        if (ulRC)
          return ulRC;

        /* Increase the datapump cycles */
        ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,pmwmDspInfo->hvdpTask, "STARTUPCPF");
        if (ulRC)
          return ulRC;

        /* Activate the real V.32bis */
        ulRC = dspChangeModuleState(pmwmDspInfo->hmodVDP, DSP_ACTIVATE_ACTIVE );
        if (ulRC != DSP_NOERROR) {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        } /* endif */

      } else {
        ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,pmwmDspInfo->hvdpTask, "STARTUPCPF");
        if (ulRC)
          return ulRC;
      } /* endif */
      break;
   default:
      break;
  }/* end If High Speed Connection */

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadModemToDpCycles exit\n");  }


  return ulRC;

}



ULONG mwmLoadDpCyclesToLineSpeed(PMWM_DSPINFO pmwmDspInfo, USHORT usDontLoadProtocols) //$G

{
  ULONG              ulAddressSTATUS = 0;
  ULONG              ulAddress = 0;
  HMTASK             hmtInUsePump = 0;

  USHORT             usValue;
  MWM_MODEM_STATUS   ModemStatus;
  ULONG              ulRC;
  ULONG              ulCurrSlashNVal;
  REGISTERS          Registers;
  #ifdef DEBUG
  char               pszDebugString[80] = "\0";
  #endif
  USHORT             usUseV34Dynasegs;
  ULONG              ulCurrentCPF = 0;
  ULONG              ulMaxCPF     = 0;
  LONG               lDeltaCPF    = 0;
  ULONG              ulDesiredCPF = 0;
  LONG               lCPFDelta    = 0;
  HSEG               hsegRECEIVEDATA;


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDpCyclesToLineSpeed entry\n");  }


  /***************************************************************************/
  /* Get the Modem Status (So that we will know what ECC Protocols were      */
  /* selected).                                                              */
  /***************************************************************************/
   ulRC = mwmSpcfcQueryModemStatus(pmwmDspInfo,&ModemStatus,&ulAddressSTATUS);
   if (ulRC!=DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC );
     return ulRC;
   }


  #ifdef DEBUG
  sprintf(pszDebugString,"Line Speed: %u  PROT_COL 0x%04x ",ModemStatus.usLineSpeed,
                                                            ModemStatus.usProtocol);
  if (ModemStatus.usProtocol & MWM_STATUS_V22BIS_CONNECT)
    strcat(pszDebugString,"V.22bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V32BIS_CONNECT)
    strcat(pszDebugString,"V.32bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT)
    strcat(pszDebugString,"V.34 ");
  if (ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT)   //$6
    strcat(pszDebugString,"PCM ");
  if (ModemStatus.usProtocol & MWM_STATUS_MNP_CONNECT)
    strcat(pszDebugString,"MNP ");
  if (ModemStatus.usProtocol & MWM_STATUS_MNP5_CONNECT)
    strcat(pszDebugString,"MNP5 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V42_CONNECT)
    strcat(pszDebugString,"V.42 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V42BIS_CONNECT)
    strcat(pszDebugString,"V.42bis ");
  if (ModemStatus.usProtocol & MWM_STATUS_V120_CONNECT)
    strcat(pszDebugString,"V.120 ");
  if (ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT)   //$6
    strcat(pszDebugString,"V.80 ");

// $add new check for v80 bit; use this from here on.

  DPF(pszDebugString);
  #endif /* DEBUG */



  mwmParsePostMessage( WM_MWM_UPDATE_STATUS, MWM_STATE_NEGOTIATING, 0);



  if (ModemStatus.usProtocol & MWM_STATUS_V32BIS_CONNECT)
    hmtInUsePump = pmwmDspInfo->hvdpTask;
  else
  if (ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT)
    hmtInUsePump = pmwmDspInfo->hmtV34;
  else
  if (ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT)
    hmtInUsePump = pmwmDspInfo->hmtV34;
  else
  {
    hmtInUsePump = pmwmDspInfo->hv22Task;

    ulRC = mwmSpcfcSetFeatures(pmwmDspInfo, 1); 
    if (ulRC)
      return (ulRC);
  }

  /* Do this now so that V.34 VOD MNP/V.42bis suppression may work */
  ulRC = mwmParseQueryModemRegisters(&Registers);                        //$L
  if (ulRC)                                                              //$L
    return ulRC;                                                         //$L

  ulCurrSlashNVal = Registers.SlashN;              // get slashN value
  if (usDontLoadProtocols)
  {
    ulCurrSlashNVal = 0;
  }

// DPF("ulCurrSlashNValfromreg: %x", ulCurrSlashNVal);

  usValue = GetPrivateProfileInt("DEBUG","IGNORESLASHN",
                                              0,INIFile );
  if (!usValue || usDontLoadProtocols)
  {
    mwmSpcfcSetProtocol(pmwmDspInfo, (USHORT)ulCurrSlashNVal, 1);  //New funct
  }


  /*********************************************************
  ** If we are running the PCM Client modem, then force the
  ** V.42bis dictionary size to 512 words.
  **
  ** 07/22/98 - Allow for separate limits for V.90 and x2.
  **********************************************************/
  if ( (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) &&
       (ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT ||
        ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT) ) {

    if ((pmwmDspInfo->usPCMValue & FEATURE_V90) && !pmwmDspInfo->bV90x2AutomodingDone) {
      usValue = GetPrivateProfileInt("OPTIONS", "V90DICTLIMIT", 0, INIFile);

      /* MNP will not fit with V.90 and a dictionary bigger than 512 */
      if (ulCurrSlashNVal == 2 || ulCurrSlashNVal == 3)
      {
         usValue = 512;
      }
    } else {
      usValue = GetPrivateProfileInt("OPTIONS", "X2DICTLIMIT", 0, INIFile);
    } /* endif */

    if (usValue == 512) {
      mwmParseSetQuoteN(0);
    } else if ((usValue == 1024) && (Registers.QuoteN > 1)) {
      mwmParseSetQuoteN(1);
    } /* endif */
  } /* endif */



  /***************************************************************************/
  /* If this is a High speed connection, dump the low speed Datapump, and    */
  /* Connect the GPCs to the High Speed.                                     */
  /***************************************************************************/
//  if (ModemStatus.usLineSpeed > 2400)
  if (!(ModemStatus.usProtocol & MWM_STATUS_V22BIS_CONNECT))
  {

    /***********************************************************************/
    /* MTS 2948                                                            */
    /* Reset V22 loaded flag to 0.                                         */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "V22", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 0;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }


    if (pmwmDspInfo->hmodV22) {
      ulRC = dspFreeModule(pmwmDspInfo->hmodV22);
      if (ulRC)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC);
        return ulRC;
      }
      pmwmDspInfo->hmodV22 = NULL;
      pmwmDspInfo->hv22Task = NULL;
    } /* endif */


    /***********************************************************************/
    /* 05/19/95                                                            */
    /* MTS 5149                                                            */
    /* Move this code from the end of IPC 6 to now...just after            */
    /* V.22bis is unloaded.                                                */
    /*                                                                     */
    /***********************************************************************/
    /***********************************************************************/
    /* Increase Datapump Cycles                                            */
    /* 02/20/96 make the call just once with the hmtInUsePump handle       */
    /* instead of twice with v32bis or v34 handle...                       */
    /* MTS 7515 If it's a V.34 connection and conditions are all there     */
    /* for a V.34EM connection and Dynasegs are disabled, add the extra    */
    /* cycles needed for V.34 Enhanced Mode here.                          */
    /***********************************************************************/
    usUseV34Dynasegs = pmwmDspInfo->usDynaSegmValue;
    if ( ( ((ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT) && pmwmDspInfo->bV34EMConnectionPossible) ||
           ((ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT) && pmwmDspInfo->bPCMConnectionPossible) ) &&
         (!usUseV34Dynasegs) ) {

      /* Get the current cycle count. */
      ulRC = mwmSpcfcGetTaskCPF( pmwmDspInfo,
                                 pmwmDspInfo->hmtV34,
                                 &ulCurrentCPF,
                                 szThisFile,__LINE__);
      if (ulRC)
         return ulRC;

      /* Get the Max CPF value used by the task */
      /* 11/20/96 - Use different label for 17-MIPS systems */
      if (!pmwmDspInfo->us17MIPS) {
        ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                  "MAXCPF",
                                  &ulAddress);
      } else {
        ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                  "MAXCPF17",
                                  &ulAddress);
      } /* endif */

      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC );
        return ulRC;
      }

      ulRC = dspMemTransfer( pmwmDspInfo->hDSP,
                             ulAddress,
                             &ulMaxCPF, 1,
                             DSP_MEMXFER_DATA_READ);

      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC );
        return ulRC;
      }

      /* Get the Delta CPF needed for Enhanced Mode */
      ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                "DELTACPFEM",
                                &ulAddress);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC );
        return ulRC;
      }
      ulRC = dspMemTransfer( pmwmDspInfo->hDSP,
                             ulAddress,
                             &lDeltaCPF, 1,
                             DSP_MEMXFER_DATA_READ);

      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC );
        return ulRC;
      }



#ifdef DEBUG
      sprintf(pszDebugString, "V.34: Current CPF=%lu MAXCPF=%lu Delta CPFEM=%ld", ulCurrentCPF, ulMaxCPF, lDeltaCPF );
      DPF(pszDebugString);
#endif

      /* Calculate the desired number of CPF */
      ulDesiredCPF = ulMaxCPF + lDeltaCPF;

      /* Calculate the change needed to the current CPF count */
      lCPFDelta = (LONG) (((LONG)ulDesiredCPF) - ((LONG)ulCurrentCPF));

      /* If an adjustment is needed, change the CPF count */
      if (lCPFDelta != 0) {
        ulRC=mwmCntndChangeCPF( pmwmDspInfo,
                                pmwmDspInfo->hmtV34,
                                lCPFDelta, MWM_MUSTHAVE); /* MTS RADD */
        if (ulRC!=DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC );
          return ulRC;
        }
      } /* endif */

      pmwmDspInfo->bV34EMResponseReceived = TRUE;
      pmwmDspInfo->bV34EMConnectionEstablished = TRUE;

    /***************************************************************
    ** 11/20/96 - If we have a V.34 connection on a 17-MIPS
    ** platform, use MAXCPF17 instead.
    ****************************************************************/
    } else if ( (ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT) &&
                (pmwmDspInfo->us17MIPS) ) {
      ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,hmtInUsePump, "MAXCPF17");
      if (ulRC)
        return ulRC;
    } else {
      ulRC = mwmSpcfcSetDPCPF(pmwmDspInfo,hmtInUsePump, "MAXCPF");
      if (ulRC)
        return ulRC;
    } /* endif */



    /***********************************************************************/
    /* 05/19/95                                                            */
    /* MTS 5149                                                            */
    /* Write PRTCLVAL=1 since I just finished raising the DP CPFs to the   */
    /* max.                                                                */
    /***********************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "PRTCLVAL", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    usValue = 1;

    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usValue, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }



    /*************************************************************************/
    /* MTS 4416                                                              */
    /* Unload V.8 if it is loaded...                                         */
    /*************************************************************************/
    if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V8 )
    {
      if (pmwmDspInfo->hmodV8) {
        ulRC = dspFreeModule(pmwmDspInfo->hmodV8);
        if (ulRC)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR,
                         ulRC);
          return ulRC;
        }
        pmwmDspInfo->hmodV8  = NULL;
        pmwmDspInfo->hmtV8   = NULL;
      } /* endif */
    }


    /*************************************************************************/
    /* $$ Save space by unloading Call progress here...                      */
    /*************************************************************************/
    if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE)
    {
      if (pmwmDspInfo->hmodCallProg) {
        ulRC = dspFreeModule(pmwmDspInfo->hmodCallProg);
        if (ulRC!=DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR,
                         ulRC );
          return ulRC;
        }
        pmwmDspInfo->hmtCallProgMove = 0;
        pmwmDspInfo->hmtCallProg     = 0;
        pmwmDspInfo->hmodCallProg    = 0;
      } /* endif */
    }

    /*************************************************************************/
    /* Load up the Necessary V.32bis segments here.                          */
    /*************************************************************************/
    if (ModemStatus.usProtocol & MWM_STATUS_V32BIS_CONNECT)
    {

      /***********************************************************************/
      /* Free V.34 Task if it is loaded.                                     */
      /***********************************************************************/
      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34)
      {
        /***********************************************************************/
        /* MTS 2948                                                            */
        /* Reset VDP loaded flag to 0.                                         */
        /***********************************************************************/
        ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "VDP", &ulAddress);
        if (ulRC!=DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        }

        usValue = 0;

        ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                              &usValue, 1,
                              DSP_MEMXFER_DATA_WRITE);
        if (ulRC!=DSP_NOERROR)
        {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        }

        if (pmwmDspInfo->hmodV34) {
          ulRC = dspFreeModule(pmwmDspInfo->hmodV34);
          if (!ulRC)
          {
            pmwmDspInfo->hmodV34 = NULL;
            pmwmDspInfo->hmtV34  = NULL;
          }
        } /* endif */
      }



      /***********************************************************************/
      /* Load up the extra segments needed by V.32bis                        */
      /***********************************************************************/
      ulRC = mwmPumpsLoadVDPSegments(pmwmDspInfo);
      if (ulRC)
        return ulRC;
    }
    else
      if ( (ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT) ||
           (ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT) )
    {
      /***********************************************************************/
      /* Free the V.32bis task.                                              */
      /***********************************************************************/
      /***********************************************************************/
      /* MTS 2948                                                            */
      /* Reset VDP loaded flag to 0.                                         */
      /***********************************************************************/
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "VDP", &ulAddress);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }

      usValue = 0;

      ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                            &usValue, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }


      if (pmwmDspInfo->hmodVDP) {
        ulRC = dspFreeModule(pmwmDspInfo->hmodVDP);
        if (!ulRC)
        {
          pmwmDspInfo->hmodVDP = NULL;
          pmwmDspInfo->hvdpTask = NULL;
        }
      } /* endif */

      /***********************************************************************/
      /* Load up the extra segments needed by V.34                          */
      /***********************************************************************/
      if (usUseV34Dynasegs != 2) {
        ulRC = mwmPumpsLoadV34Segments(pmwmDspInfo, ALL_CODE_SEGMENTS);
        if (ulRC)
          return ulRC;
      } /* endif */

    }

          
    if (!(ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT))   //$6
      {
        ulRC=dspConnectITCB(hmtInUsePump,"DPITCB",pmwmDspInfo->hasyTask,"DPITCB");
        if (ulRC != DSP_NOERROR)
	  {
	    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
			   MWM_DSP_ERROR, ulRC);
	    return ulRC;
	  }
	
	
        ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"XMITDATA",hmtInUsePump,"XMITDATA",0,NULL,
                                pmwmDspInfo, szThisFile,__LINE__ );
        if (ulRC)
          return(ulRC);
	
        ulRC=mwmCntndConnectGPC(hmtInUsePump,"RCVDATA",pmwmDspInfo->hasyTask,"RCVDATA",0,NULL,
                                pmwmDspInfo, szThisFile,__LINE__ );
        if (ulRC)
          return(ulRC);
      } /* endif */
    
  }
  else /* This is a low speed connection */
  {
    /*************************************************************************/
    /* Dump the high speed datapump.                                         */
    /*************************************************************************/
    if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE )
    {

      /***********************************************************************/
      /* MTS 2948                                                            */
      /* Reset VDP loaded flag to 0.                                         */
      /***********************************************************************/
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "VDP", &ulAddress);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }

      usValue = 0;

      ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                            &usValue, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }


      if (pmwmDspInfo->hmodVDP) {
        ulRC = dspFreeModule(pmwmDspInfo->hmodVDP);
        if (!ulRC)
        {
          pmwmDspInfo->hmodVDP = NULL;
          pmwmDspInfo->hvdpTask = NULL;
        }
      } /* endif */

      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34)
      {
        if (pmwmDspInfo->hmodV34) {
          ulRC = dspFreeModule(pmwmDspInfo->hmodV34);
          if (!ulRC)
          {
            pmwmDspInfo->hmodV34 = NULL;
            pmwmDspInfo->hmtV34  = NULL;
          }
        } /* endif */
      }
    }
  }




  /********************************************************************/
  /* MTS 5873 Query Registers to get SlashN Value                     */
  /********************************************************************/
//ulRC = mwmParseQueryModemRegisters(&Registers);
//if (ulRC)
//  return ulRC;

//ulCurrSlashNVal = Registers.SlashN;              // get slashN value
//if (usDontLoadProtocols)
//{
//  ulCurrSlashNVal = 0;
//}

  /*************************************************************************/
  /* MTS 5873 Set new protocol, but don't set long term features           */
  /*************************************************************************/
// DPF("ulCurrSlashNValfromreg: %x", ulCurrSlashNVal);


//usValue = GetPrivateProfileInt("DEBUG","IGNORESLASHN",
//                                            0,INIFile );
//if (!usValue || usDontLoadProtocols)
//{
//  mwmSpcfcSetProtocol(pmwmDspInfo, (USHORT)ulCurrSlashNVal, 1);  //New funct
//}



  ulRC = dspFreeSegment(pmwmDspInfo->hsegMCTLDIALT);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegMCTLDIALT = 0;


  /*******************************************************************
  ** 11/20/96
  ** Load the PHASE34 Dynaseg for V.34
  ********************************************************************/
  if ( ((ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT) ||
        (ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT)) &&
       (!pmwmDspInfo->bPercentTTMode)  ) {
    if ((pmwmDspInfo->usDynaSegmValue==2) && (pmwmDspInfo->ulDSPAddrV34DYNASEGS)) {
      if (! (pmwmDspInfo->usDSDebugValue & DSDEBUG_PHASE34) ) {
        ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "PHASE34", OFFSET_PHASE34, szThisFile , __LINE__, MWM_MUSTHAVE);
        if (ulRC) {
          return(ulRC);
        } /* endif */
      } /* endif */

      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {

        /****************************************************
        ** Load X2PHASE34D and X2PHASE34.
        ** Note that the data segment must be loaded first
        ** as the code assumes the data is present when it
        ** runs.
        *****************************************************/
        if (pmwmDspInfo->usPCMValue & (FEATURE_X2 | FEATURE_V90)) {
          if (! (pmwmDspInfo->usDSDebugValue & DSDEBUG_X2PHASE34) ) {
            ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "X2PHASE34D", OFFSET_X2PHASE34D, szThisFile , __LINE__, MWM_MUSTHAVE);
            if (ulRC) {
              return(ulRC);
            } /* endif */

            ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "X2PHASE34", OFFSET_X2PHASE34, szThisFile , __LINE__, MWM_MUSTHAVE);
            if (ulRC) {
              return(ulRC);
            } /* endif */
          } /* endif */
        } /* endif */
      } /* endif */
    } /* endif */
  } /* endif */

  /*******************************************************************
  ********************************************************************/
  if ( ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT ||
       ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT ) {
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "MNPGPC_P", &ulAddress);
    if (ulRC!=DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC );
      return ulRC;
    } /* endif */

    ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                               pmwmDspInfo->achV34ModuleName,
                               "RECEIVEDATA",
                               "RECEIVEDATA",
                               pmwmDspInfo->hmtV34,
                               &hsegRECEIVEDATA,
                               ulAddress,
                               szThisFile , __LINE__, MWM_MUSTHAVE );

    if (ulRC) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__, MWM_DSP_ERROR, ulRC);
      return(ulRC);
    } /* endif */
  } /* endif */


  if (!(ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT))   /* if not in v.80 mode  */ //$8
  {                                                         /* skip v.42, MNP,  */
                                                            /* processing           */

  /***************************************************************************/
  /* MTS 5215                                                                */
  /* Only need to make the following connection changes if this is a         */
  /* HS Connection.                                                          */
  /***************************************************************************/

  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42 )
  {
    if (! (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V42PRELOAD) )
    {
      ulRC = mwmCntndLoadModule(pmwmDspInfo,"V42","V42",
                                &pmwmDspInfo->hmodV42,szThisFile,__LINE__);
      if (ulRC)
        return ulRC;
      /*********************************************************************/
      /* Get v42PKT Task handle                                            */
      /*********************************************************************/
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "V42PKT", &pmwmDspInfo->hmtV42PKT);
      if (ulRC != DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC);
        return(ulRC);
      }

      /*********************************************************************/
      /* Get LAPDLC Task handle                                            */
      /*********************************************************************/
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "DLC", &pmwmDspInfo->hmtV42LAPDLC);
      if (ulRC != DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC);
        return(ulRC);
      }

      /*********************************************************************/
      /* Get V42MAC Task handle                                            */
      /*********************************************************************/
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "V42MAC", &pmwmDspInfo->hmtV42MAC);
      if (ulRC != DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC);
        return(ulRC);
      }

      /*************************************************************************/
      /* Get LAPDLCxmit Task handle.  Not always present in V42!               */
      /*************************************************************************/
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "DLCxmit", &pmwmDspInfo->hmtV42LAPDLCxmit);
      if (ulRC != DSP_NOERROR)
      {
        pmwmDspInfo->hmtV42LAPDLCxmit = NULL;
      }

      /*************************************************************************/
      /* Get V42MACxmit Task handle.  Not always present in V42!               */
      /*************************************************************************/
      ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV42, "V42MACxmit", &pmwmDspInfo->hmtV42MACxmit);
      if (ulRC != DSP_NOERROR)
      {
         pmwmDspInfo->hmtV42MACxmit = NULL;
      }

      /***********************************************************************/
      /* Get the Address of the UI_addr Segment Pointer.                     */
      /***********************************************************************/
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV42PKT, "UI_addr", &ulAddress);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }

      usValue = 0;

      ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                            &usValue, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }




      ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmtV42PKT,
                                    "UI_SEG",
                                    &pmwmDspInfo->hsegV42UI_seg);
      if (ulRC)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC);
        return(ulRC);
      }


      /***********************************************************************/
      /* Free the UI_seg until we need it for ONLINE state                   */
      /***********************************************************************/
      ulRC = dspFreeSegment(pmwmDspInfo->hsegV42UI_seg);
      if (ulRC)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR,
                       ulRC);
        return(ulRC);
      }
      pmwmDspInfo->hsegV42UI_seg = 0;



//      ulRC = mwmLoadMakeV42Connections(pmwmDspInfo, ModemStatus.usLineSpeed);
      ulRC = mwmLoadMakeV42Connections(pmwmDspInfo, hmtInUsePump);
      if (ulRC)
        return ulRC;

      ulRC = dspChangeModuleState(pmwmDspInfo->hmodV42, DSP_ACTIVATE_ACTIVE );
      if (ulRC != DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } // If !V42PRELOAD
    else
    {
//      if (ModemStatus.usLineSpeed > 2400)
      if (!(ModemStatus.usProtocol & MWM_STATUS_V22BIS_CONNECT) )
      {
	{
	  ulRC=mwmCntndConnectGPC(hmtInUsePump,"RMNPDATA",
                                  pmwmDspInfo->hmtV42MAC,"MAC_RECV",0,NULL,
                                  pmwmDspInfo, szThisFile,__LINE__ );
          if (ulRC)
            return(ulRC);

          ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV42MAC,"MAC_XMT",
                                  hmtInUsePump,"XV42DATA",0,NULL,
                                  pmwmDspInfo, szThisFile,__LINE__ );
          if (ulRC)
            return(ulRC);
        } 
      } // if HS Connection (> 2400)
    } //else V42PRELOAD
  } // end...if V.42





  /***************************************************************************/
  /* 3/03/94                                                                 */
  /* If we are an automode modem (both datapumps), then we are loading MNP   */
  /* only after we unload the unused datapump.  If the user has selected a   */
  /* 2400 configuration, then we load MNP at startup.   This is an attempt   */
  /* To keep the DS,IS, and MIPs relatively constant.  In the V.22bis setup, */
  /* there would be nothing to unload to free up space for MNP, so we must   */
  /* load it initially.                                                      */
  /*                                                                         */
  /* If this is an Automode Modem (with MNP) then load MNP.                  */
  /***************************************************************************/
  /***************************************************************************/
  /* MTS 3239..check for MNP here (as well as MNPPRELOAD)                    */
  /***************************************************************************/
  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP )
  {
    if ( !(pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNPPRELOAD) )
    {

      /****************************************************************
      ** We load MNP here only if:
      ** PCM is not enabled OR
      ** DYNASEGM != 2 AND
      ** We have a V.34 or V.PCM connection
      *****************************************************************/
      if ( !( (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) &&
               pmwmDspInfo->usDynaSegmValue == 2 &&
              ((ModemStatus.usProtocol & MWM_STATUS_V34_CONNECT) ||
               (ModemStatus.usProtocol & MWM_STATUS_PCM_CONNECT)) ) ) {

        ulRC = mwmLoadMNP(pmwmDspInfo, hmtInUsePump, MWM_MUSTHAVE);
        if (ulRC)
          return ulRC;

      } /* endif */
    }
    else
    {
      /*************************************************************************/
      /* MNP Was preloaded and connected, so if the LineSpeed is higher than   */
      /* 2400, we must move the connections to the high speed pump.            */
      /*************************************************************************/
//      if (ModemStatus.usLineSpeed > 2400)
      if (!(ModemStatus.usProtocol & MWM_STATUS_V22BIS_CONNECT))
      {
        {
          ulRC=mwmCntndConnectGPC(hmtInUsePump,"RMNPDATA",
                                  pmwmDspInfo->hmtMNP,"RMNPDATA",0,NULL,
                                  pmwmDspInfo, szThisFile,__LINE__ );
          if (ulRC)
            return(ulRC);

          ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtMNP,"XMNPDATA",
                                  hmtInUsePump,"XMNPDATA",0,NULL,
                                  pmwmDspInfo, szThisFile,__LINE__ );
          if (ulRC)
            return(ulRC);
        } 
      } //if>2400
    }  //if MNPPRELOAD
  } //if MNP


  /***************************************************************************/
  /*  Change Datapump/MNP/V.42 cycles.                                       */
  /***************************************************************************/
  ulRC = mwmSpcfcModemToLineSpeedCPFAdjust(pmwmDspInfo,ModemStatus.usProtocol);
  if (ulRC)
    return ulRC;


  } /* end if not v.80 mode */ //$8


  ulRC =  mwmPoolAllocInitialECBuffer(pmwmDspInfo);
  if (ulRC)
    return ulRC;

  if (ModemStatus.usProtocol & MWM_STATUS_V80_CONNECT)   //$H
  {
     ulRC = mwmV80LCyclesAdjustToLineSpeed(pmwmDspInfo, ModemStatus.usProtocol, 1); //$F G
     if (ulRC)
       return ulRC;
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadDpCyclesToLineSpeed exit\n");  }


  return (0);  // No Error
}




ULONG mwmLoadSwapToDummyAsync(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC;
  ULONG  ulAddress;
  USHORT usTempValue;
  USHORT usCount;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadSwapToDummyAsync entry\n");  }


  /***************************************************************************/
  /* Swap Real Async ITCB to Dummy Async.                                    */
  /* -Set ASYNCDUM = 1                                                       */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "ASYNCDUM", &ulAddress);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  usTempValue = 1;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }





  /***************************************************************************/
  /* Swap the Async ITCBs.  Set SWAPASYN = FFFF                              */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "SWAPASYN", &ulAddress);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  usTempValue = 0xFFFF;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }

  /***************************************************************************/
  /* Before we unload Async module, we must check to make sure that    */
  /* MCTL has successfully swapped to the Dummy Async ITCB.                  */
  /***************************************************************************/
  usTempValue = 0xFFFF;
  usCount = 0;
  while (usTempValue && (usCount < 10000) )
  {
    /*************************************************************************/
    /* Read the SWAPASYN  variable.                                          */
    /*************************************************************************/
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usTempValue, 1,
                          DSP_MEMXFER_DATA_READ);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    usCount++;
  }
  /***************************************************************************/
  /* If we timed out...show an error message, and return.                    */
  /***************************************************************************/
  if (usCount == 10000)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   (ULONG)usTempValue );
    return ulRC;
  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadSwapToDummyAsync exit\n");  }


  return 0;
}


ULONG mwmLoadSwapToRealAsync(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG   ulRC;
  ULONG   ulAddress;
  USHORT  usTempValue;
  USHORT  usCount;


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadSwapToRealAsync entry\n");  }


  /***************************************************************************/
  /* Swap Dummy Async ITCB to Real Async.                                    */
  /* -Set ASYNCDUM = 0                                                       */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "ASYNCDUM", &ulAddress);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  usTempValue = 0;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }

  /***************************************************************************/
  /* Swap the Async ITCBs.  Set SWAPASYN = FFFF                              */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "SWAPASYN", &ulAddress);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  usTempValue = 0xFFFF;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }



  /***************************************************************************/
  /* Before we Activate the Class 2 module, we must check to make sure that  */
  /* MCTL has successfully swapped from the Dummy Async ITCB.                */
  /***************************************************************************/
  usTempValue = 0xFFFF;
  usCount = 0;
  while (usTempValue && (usCount < 10000) )
  {
    /*************************************************************************/
    /* Read the SWAPASYN variable.                                           */
    /*************************************************************************/
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usTempValue, 1,
                          DSP_MEMXFER_DATA_READ);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    usCount++;
  }
  /***************************************************************************/
  /* If we timed out...show an error message, and return.                    */
  /***************************************************************************/
  if (usCount == 10000)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   (ULONG)usTempValue );
    return ulRC;
  }

  /***************************************************************************/
  /* Activate the UART Task ...                                              */
  /***************************************************************************/
//  ulRC = dspChangeTaskState(pmwmDspInfo->hmtUART, DSP_ACTIVATE_ACTIVE);
//  if (ulRC)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC );
//    return (ulRC);
//  }


	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadSwapToRealAsync exit\n");  }


  return 0;
}

/***********************************************************************/
/* mwmLoadSwapAsync                                                    */
/*                                                                     */
/* This function will swap ASYNC2X for ASYNC and vice versa.           */
/*                                                                     */
/* usFastOrSlow = 1 -> load ASYNC2X                                    */
/* usFastOrSlow = 0 -> load ASYNC                                      */
/***********************************************************************/
ULONG mwmLoadSwapAsync(PMWM_DSPINFO pmwmDspInfo, USHORT usFastOrSlow)
{
  ULONG ulRC;
  char  *pszAsync;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadSwapAsync entry\n");  }


  ulRC = 0;

  DPF("mwmLoadSwapAsync");

  /***************************************************************************/
  /* Do nothing if this feature is not enabled                               */
  /***************************************************************************/
  if (!(pmwmDspInfo->ulFeaturesToLoad & FEATURE_ASYNC2X))
     return ulRC;

  /***************************************************************************/
  /* Do nothing if ASYNC is not currently loaded                             */
  /***************************************************************************/
  if(pmwmDspInfo->hmodAsync == NULL)
  {
     DPF("mwmLoadSwapAsync:  ASYNC task not currently loaded!");
     return ulRC;
  }

  if (usFastOrSlow == ASYNC2X)
     pszAsync = "ASYNC2X";
  else
     pszAsync = "ASYNC";

  DPF("mwmLoadSwapAsync:  Loading %s", pszAsync);

  /***************************************************************************/
  /* Put the UART Task in standby                                            */
  /***************************************************************************/
  ulRC = dspChangeTaskState(pmwmDspInfo->hmtUART, DSP_ACTIVATE_STANDBY);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

    /***************************************************************************/
    /* Put Async in Standby...                                                 */
    /***************************************************************************/
    ulRC = dspChangeModuleState(pmwmDspInfo->hmodAsync, DSP_ACTIVATE_STANDBY);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return (ulRC);
    }

    /***************************************************************************/
    /* Swap to the dummy Async ITCB                                            */
    /***************************************************************************/
    ulRC = mwmLoadSwapToDummyAsync(pmwmDspInfo);
    if (ulRC)
      return ulRC;


    ulRC = dspFreeModule(pmwmDspInfo->hmodAsync);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    pmwmDspInfo->hmodAsync = 0;
    pmwmDspInfo->hasyTask = 0;


  /***************************************************************************/
  /* Load the Async Module.                                                  */
  /***************************************************************************/
  ulRC = mwmCntndLoadModule(pmwmDspInfo,pszAsync,pszAsync,&pmwmDspInfo->hmodAsync,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

  /***************************************************************************/
  /* Get the Async Task Handle                                               */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodAsync, "ASYNC", &pmwmDspInfo->hasyTask);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }


  /***************************************************************************/
  /* MTS 5143                                                                */
  /* Free the Async Extra Segments before loading anything else              */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hasyTask,
                                "ECMPROC",
                                &pmwmDspInfo->hsegAsyncECMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegAsyncECMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegAsyncECMPROC = 0;


  /***************************************************************************/
  /* Free the Async Extra Segments before loading anything else              */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hasyTask,
                                "ACMPROC",
                                &pmwmDspInfo->hsegAsyncACMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  ulRC = dspFreeSegment(pmwmDspInfo->hsegAsyncACMPROC);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }
  pmwmDspInfo->hsegAsyncACMPROC = 0;




  /***************************************************************************/
  /* ITCB Connections                                                        */
  /***************************************************************************/
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hasyTask,"ASYNITCB",pmwmDspInfo->hmctlTask,"ASYNITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  /***************************************************************************/
  /*    ASYNC..ATCMD              CONNECT   MCTL..ATCMD                      */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"ATCMD",pmwmDspInfo->hmctlTask,"ATCMD",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  /***************************************************************************/
  /*    MCTL..ATRESP              CONNECT   ASYNC..ATRESP                    */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmctlTask,"ATRESP",pmwmDspInfo->hasyTask,"ATRESP",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);






  /***************************************************************************/
  /* Swap from the Dummy Async to the ASYNC ITCB                             */
  /***************************************************************************/
  ulRC = mwmLoadSwapToRealAsync(pmwmDspInfo);
  if (ulRC)
    return ulRC;



  /***************************************************************************/
  /* Activate the ASYNC Module                                               */
  /***************************************************************************/
   ulRC = dspChangeModuleState(pmwmDspInfo->hmodAsync, DSP_ACTIVATE_ACTIVE );
   if (ulRC != DSP_NOERROR)
   {
     mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                    MWM_DSP_ERROR, ulRC);
     return(ulRC);
   }

  /***************************************************************************/
  /* Activate the UART Task                                                  */
  /***************************************************************************/
  ulRC = dspChangeTaskState(pmwmDspInfo->hmtUART, DSP_ACTIVATE_ACTIVE);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadSwapAsync exit\n");  }


  return ulRC;
}


//ULONG mwmLoadSwapToDummyDatapump(PMWM_DSPINFO pmwmDspInfo)
//{
//  ULONG  ulRC;
//  ULONG  ulAddress;
//  USHORT usTempValue;
//  ULONG  ulCount;
//
//
//  /***************************************************************************/
//  /* Swap Real Datapump to Dummy Datapump.                                   */
//  /* -Set MODEM = 0                                                          */
//  /***************************************************************************/
//  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "MODEM", &ulAddress);
//  if (ulRC)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC );
//    return (ulRC);
//  }
//
//  usTempValue = 0;
//
//  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
//                        &usTempValue, 1,
//                        DSP_MEMXFER_DATA_WRITE);
//  if (ulRC!=DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC );
//    return ulRC;
//  }
//
//  /***************************************************************************/
//  /* Swap the Datapump ITCBs.  Set SWAP_DP = FFFF                            */
//  /***************************************************************************/
//  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "SWAP_DP", &ulAddress);
//  if (ulRC)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC );
//    return (ulRC);
//  }
//
//  usTempValue = 0xFFFF;
//
//  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
//                        &usTempValue, 1,
//                        DSP_MEMXFER_DATA_WRITE);
//  if (ulRC!=DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   ulRC );
//    return ulRC;
//  }
//
//
//
//
//  /***************************************************************************/
//  /* Before we remove the Datapump module, we must check to make sure that   */
//  /* MCTL has successfully swapped to the Dummy Datapump. ITCB.              */
//  /***************************************************************************/
//  usTempValue = 0xFFFF;
//  ulCount = 0;
//  while (usTempValue && (ulCount < 100000) )
//  {
//    /*************************************************************************/
//    /* Read the SWAP_DP  variable.                                           */
//    /*************************************************************************/
//    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
//                          &usTempValue, 1,
//                          DSP_MEMXFER_DATA_READ);
//    if (ulRC!=DSP_NOERROR)
//    {
//      mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                     MWM_DSP_ERROR,
//                     ulRC );
//      return ulRC;
//    }
//    ulCount++;
//  }
//  /***************************************************************************/
//  /* If we timed out...show an error message, and return.                    */
//  /***************************************************************************/
//  if (ulCount == 100000)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR,
//                   (ULONG)usTempValue );
//    return ulRC;
//  }
//
//  return 0;
//}
//
//



/*****************************************************************************/
/* The usDPToUse comes directly from the definition                          */
/*                                                                           */
/*  1 = V.22                                                                 */
/*  0 = Dummy DPITCB                                                         */
/* -1 = V.32bis                                                              */
/* -2 = V.34                                                                 */
/*****************************************************************************/
ULONG mwmLoadSwapDatapumpITCB(PMWM_DSPINFO pmwmDspInfo, USHORT usDPToUse)
{
  ULONG  ulRC;
  ULONG  ulAddress;
  USHORT usTempValue;
  ULONG  ulCount;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadSwapDatapumpITCB entry\n");  }


  /***************************************************************************/
  /* Swap MDMCTL from Dummy Datapump to the real V.22bis datapump            */
  /***************************************************************************/
  /***************************************************************************/
  /* Next, Set MODEM = 1                                                     */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "MODEM", &ulAddress);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

//  usTempValue = 1;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
//                        &usTempValue, 1,
                        &usDPToUse, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }





  /***************************************************************************/
  /* Swap the Datapumps.  Set SWAP_DP = FFFF                                 */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "SWAP_DP", &ulAddress);
  if (ulRC)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return (ulRC);
  }

  usTempValue = 0xFFFF;

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usTempValue, 1,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC );
    return ulRC;
  }



  /***************************************************************************/
  /* Before we Activate MCTL module, we must check to make sure that         */
  /* MCTL has successfully swapped from  the Dummy Datapump.                 */
  /***************************************************************************/
  usTempValue = 0xFFFF;
  ulCount = 0;
  while (usTempValue && (ulCount < 100000) )
  {
    /*************************************************************************/
    /* Read the SWAPASYN  variable.                                           */
    /*************************************************************************/
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usTempValue, 1,
                          DSP_MEMXFER_DATA_READ);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC );
      return ulRC;
    }
    ulCount++;
  }
  /***************************************************************************/
  /* If we timed out...show an error message, and return.                    */
  /***************************************************************************/
  if (ulCount == 100000)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   (ULONG)usTempValue );
    return ulRC;
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadSwapDatapumpITCB exit\n");  }


  return 0;
}



ULONG mwmLoadV8AndConnect(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC = 0;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadV8AndConnect entry\n");  }


  ulRC = mwmCntndLoadModule(pmwmDspInfo,"V8","V8",&pmwmDspInfo->hmodV8,szThisFile,__LINE__);
  if (ulRC)
    return ulRC;


  /***************************************************************************/
  /* Get v8 Task handle                                                      */
  /***************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV8, "V8", &pmwmDspInfo->hmtV8);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Make V.8 connections...                                                 */
  /***************************************************************************/
  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV8,"XMITDATA",
                          pmwmDspInfo->hv22Task,"XMITV8",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hv22Task,"RCVDATA",
                          pmwmDspInfo->hmtV8,"RCVDATA",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);

  ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"DPV8ITCB",
                      pmwmDspInfo->hmtV8   ,"DPV8ITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"DPITCB",
                    pmwmDspInfo->hmtV8   ,"DPITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"PSV8ITCB",
                      pmwmDspInfo->hmtV8      ,"PSV8ITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmctlTask,"OREGITCB",                      //$2
                      pmwmDspInfo->hmtV8    ,"OREGITCB");
  if (ulRC != DSP_NOERROR)
  {
    DPF("WARNING:  OREGITCB.MCTL.MODEM to OREGITCB.V8.V8 itcb connection failed.\n");
  }

//  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"PSV8ITCB",
//                      pmwmDspInfo->hmctlTask  ,"PSV8ITCB");
//  if (ulRC != DSP_NOERROR)
//  {
//    mwmHandleError(pmwmDspInfo->pInstanceInfo,szThisFile,__LINE__,
//                   MWM_DSP_ERROR, ulRC);
//    return(ulRC);
//  }


  ulRC = dspChangeModuleState(pmwmDspInfo->hmodV8, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadV8AndConnect exit\n");  }


  return 0;
}

ULONG mwmLoadV34(PMWM_DSPINFO pmwmDspInfo, BOOL bAutomoding)
{

  ULONG ulRC;
  ULONG ulAddress;
  USHORT usValue;
  USHORT usUseV34Dynasegs = 0;
  HSEG   hsegRECEIVEDATA = 0;
  HIPC   hIPC;
  USHORT usNECCENTER = 0;
  USHORT usFDXECUP;
  REGISTERS Registers;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadV34 entry\n");  }


  if (!bAutomoding) {
    pmwmDspInfo->bV90x2AutomodingDone  = FALSE;
  } else {
    pmwmDspInfo->bV90x2AutomodingDone  = TRUE;
  } /* endif */

  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {
    if ((pmwmDspInfo->usPCMValue & FEATURE_V90) && !bAutomoding) {
      strcpy(pmwmDspInfo->achV34ModuleName, "V90");
    } else {
      strcpy(pmwmDspInfo->achV34ModuleName, "X2");
    } /* endif */
  } else {
    strcpy(pmwmDspInfo->achV34ModuleName, "V34");
  } /* endif */

  DPF("Loading module %s",pmwmDspInfo->achV34ModuleName);
  ulRC = mwmCntndLoadModule(pmwmDspInfo,pmwmDspInfo->achV34ModuleName,"V34",&pmwmDspInfo->hmodV34,szThisFile,__LINE__);
  if (ulRC)
    return ulRC;

  /*************************************************************************/
  /* Get v34 Task handle                                                   */
  /*************************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodV34, "V34", &pmwmDspInfo->hmtV34);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  /*********************************************************************
  ** Get the address of X2DATAMODES
  **********************************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {
    ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34, "X2DATAMODES",
                              &pmwmDspInfo->ulDSPAddrX2Datamodes);
    if (ulRC != DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    } /* endif */
  } /* endif */

  /*********************************************************************
  ** Get the address of BITRATER, BITRATEX
  **********************************************************************/
  ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34, "BITRATER",
                            &pmwmDspInfo->ulDSPAddrBitrateR);
  if (ulRC != DSP_NOERROR) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  } /* endif */

  ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34, "BITRATEX",
                            &pmwmDspInfo->ulDSPAddrBitrateX);
  if (ulRC != DSP_NOERROR) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  } /* endif */

  /*********************************************************************
  ** Get the address of V34EMCTL
  **********************************************************************/
  pmwmDspInfo->ulDSPAddrV34EMCtrl = 0;
  usValue = 0;
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "V34EMCTL", &pmwmDspInfo->ulDSPAddrV34EMCtrl);
  if ( ulRC != DSP_NOERROR ) {
    // Ignore bad return code here...
    ulRC = 0;
    pmwmDspInfo->bV34EMConnectionPossible = FALSE;
    DPF("Could not retrieve V.34EM label.");
  } else {
    if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34EM) {
      usValue = 1;
    } /* endif */

    ulRC = dspMemTransfer( pmwmDspInfo->hDSP,
                           pmwmDspInfo->ulDSPAddrV34EMCtrl,
                           &usValue, 1,
                           DSP_MEMXFER_DATA_WRITE );

    if (ulRC!=DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  } /* endif */

  /* MTS 7369 - Initialize the Modem control V34EMCTL flag */
  ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hmctlTask,
                                "V34EMCTL", DSP_MEMXFER_DATA_WRITE, 1,
                                &usValue, szThisFile, __LINE__);
  if (ulRC) {
    return(ulRC);
  } /* endif */

  /*********************************************************************
  ** Get the address of V34PCMCTL
  **********************************************************************/
  pmwmDspInfo->ulDSPAddrPCMCtrl = 0;
  usValue = 0;
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "PCMCTL", &pmwmDspInfo->ulDSPAddrPCMCtrl);

  if ( ulRC != DSP_NOERROR ) {
    // Ignore bad return code here...
    ulRC = 0;
    pmwmDspInfo->ulDSPAddrPCMCtrl = 0;
    pmwmDspInfo->bPCMConnectionPossible = FALSE;
    DPF("Could not retrieve PCMCTL label.");
  } else {
    if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {
      usValue = pmwmDspInfo->usPCMValue;
    } /* endif */

    ulRC = dspMemTransfer( pmwmDspInfo->hDSP,
                           pmwmDspInfo->ulDSPAddrPCMCtrl,
                           &usValue, 1,
                           DSP_MEMXFER_DATA_WRITE );

    if (ulRC != DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    } /* endif */
  } /* endif */

  /* MTS 7369 - Set the Modem control PCMCTL flag also */
  ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hmctlTask,
                                "PCMCTL", DSP_MEMXFER_DATA_WRITE, 1,
                                &usValue, szThisFile, __LINE__ );
  if (ulRC != DSP_NOERROR) {
    return(ulRC);
  } /* endif */


  /*********************************************************************/
  /* Get the address of DYNASEGS no matter what since the              */
  /* NECCENTER variable is contained in the dynasegs structure         */
  /*********************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "DYNASEGS", &pmwmDspInfo->ulDSPAddrV34DYNASEGS);
  if (ulRC!=DSP_NOERROR)
  {
    // Ignore bad return code here...
    ulRC = 0;
    pmwmDspInfo->ulDSPAddrV34DYNASEGS = 0;
  }

  usNECCENTER = GetPrivateProfileInt("FEATURES","NECCENTER", 0,
                                     INIFile);
  if ((usNECCENTER) && (pmwmDspInfo->ulDSPAddrV34DYNASEGS))
  {
    /***********************************************************************/
    /* Set the NECCENTER location as specified in the mwm???.ini           */
    /***********************************************************************/
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, pmwmDspInfo->ulDSPAddrV34DYNASEGS+2,
                          &usNECCENTER, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

  }



  /*************************************************************************/
  /* V.34 Dynasegs.                                                        */
  /* MTS 7795 - Use the internal DynaSegm Value instead of reading the     */
  /* value from the INI file.                              02/17/97 DR     */
  /*************************************************************************/
  usUseV34Dynasegs = pmwmDspInfo->usDynaSegmValue;
  if ((usUseV34Dynasegs) && (pmwmDspInfo->ulDSPAddrV34DYNASEGS))
  {
    /***********************************************************************/
    /* Try to connect the V.34 IPC                                         */
    /***********************************************************************/
    ulRC = mwmParseConnectIPC(pmwmDspInfo->hmtV34, &hIPC, 1);  // 0 means MCTL...1 means V34
    if (ulRC == DSP_NOERROR)
    {

      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "DYNASEG_TABLE", &pmwmDspInfo->ulDSPAddrV34DYNASEG_TABLE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }


      ulRC = dspMemTransfer(pmwmDspInfo->hDSP, pmwmDspInfo->ulDSPAddrV34DYNASEGS,
                            &usUseV34Dynasegs, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }

      /********************************************************************
      ** Unload V.34 Data Segments
      ** Before unloading the Data Segments, get the sizes of the segments
      ** that are being unloaded for later use.
      *********************************************************************/
      ulRC = mwmPoolDummyV34Segments(pmwmDspInfo, 0);
      if (ulRC)
        return(ulRC);

      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {
        if (pmwmDspInfo->usPCMValue & (FEATURE_X2 | FEATURE_V90)) {
          ulRC = mwmPumpsFreeX2DataSegments(pmwmDspInfo);
          if (ulRC)
            return(ulRC);
        } /* endif */
      } /* endif */

      ulRC = mwmPumpsFreeV34DataSegments(pmwmDspInfo);
      if (ulRC)
        return(ulRC);

      /*********************************************************************/
      /* Unload the DATAMODEINIT Segment                                   */
      /*********************************************************************/
      ulRC = mwmPumpsFreeV34DynaSeg(pmwmDspInfo, "DATAMODEINIT", OFFSET_DATAMODEINIT,
                                    szThisFile, __LINE__ );
      if (ulRC) {
        return(ulRC);
      } /* endif */
    }
    else
    {
      usUseV34Dynasegs = 0;
      DPF("Could not connect to the V.34 IPC");
    }

  }

  /*******************************************************************
  ** 11/20/96
  ** New DynaSegs
  ** MTS 7795 - Use the internal DynaSegm Value instead of reading the
  ** value from the INI file.                              02/17/97 DR
  ********************************************************************/
  if (!pmwmDspInfo->bPercentTTMode) {
    if ((pmwmDspInfo->usDynaSegmValue==2) && (pmwmDspInfo->ulDSPAddrV34DYNASEGS)) {

      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {

        if (pmwmDspInfo->usPCMValue & (FEATURE_X2 | FEATURE_V90)) {
          /*********************************************************************
          ** Unload the X2PHASE34 Segment
          **********************************************************************/
          if (! (pmwmDspInfo->usDSDebugValue & DSDEBUG_X2PHASE34) ) {
            ulRC = mwmPumpsFreeV34DynaSeg(pmwmDspInfo, "X2PHASE34", OFFSET_X2PHASE34,
                                          szThisFile, __LINE__ );
            if (ulRC) {
              return(ulRC);
            } /* endif */

            /*********************************************************************
            ** Unload the X2PHASE34D Segment
            **********************************************************************/
            ulRC = mwmPumpsFreeV34DynaSeg(pmwmDspInfo, "X2PHASE34D", OFFSET_X2PHASE34D,
                                          szThisFile, __LINE__ );
            if (ulRC) {
              return(ulRC);
            } /* endif */
          } /* endif */
        } /* endif */
      } /* endif */

      /*********************************************************************
      ** Unload the PHASE34 Segment
      **********************************************************************/
      if (! (pmwmDspInfo->usDSDebugValue & DSDEBUG_PHASE34) ) {
        ulRC = mwmPumpsFreeV34DynaSeg(pmwmDspInfo, "PHASE34", OFFSET_PHASE34,
                                      szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */
      } /* endif */
    } /* endif */
  } /* endif */

  /*********************************************************
  ** Unload the RECEIVEDATA DynaSegment.   01/13/97 DR
  **********************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmtV34, "RECEIVEDATA", &hsegRECEIVEDATA );
  if (ulRC != DSP_NOERROR) {
    if (ulRC == DSP_NAME_NOT_FOUND) {
      hsegRECEIVEDATA = 0;
    } else {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    } /* endif */
  } /* endif */

  if (hsegRECEIVEDATA) {
    ulRC = dspFreeSegment( hsegRECEIVEDATA );
    if (ulRC != DSP_NOERROR) {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    } /* endif */
  } /* endif */


  /*********************************************************
  ** 17 MIPS platform support. If a 17 MIPS platform,
  ** change the MIN_FDXECUP_P value.
  **********************************************************/
  usFDXECUP = GetPrivateProfileInt( "OPTIONS", "FDXECUPP", 0, INIFile);
  if (usFDXECUP) {
    ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34, "MIN_FDXECUP_P", &ulAddress);
    if (ulRC == DSP_NOERROR) {
      ulRC = dspMemTransfer( pmwmDspInfo->hDSP, ulAddress, &usFDXECUP, 1,
                             DSP_MEMXFER_DATA_WRITE);
    } else {
      DPF("MIN_FDXECUP_P label not found!");
    } /* endif */
  } /* endif */

  /*********************************************************
  ** Unload DATAMODE1, 2, 3 segments.
  **********************************************************/
  ulRC = mwmPumpsFreeV34Segments(pmwmDspInfo);
  if (ulRC)
    return ulRC;

  /*****************************************************
  ** Set the pump's a-law/mu-law flag.
  ******************************************************/
  if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {
    ulRC = mwmParseQueryModemRegisters(&Registers);
    if (ulRC)
      return ulRC;

    if (Registers.S60) {
      DPF("Setting for a-law.");
    } else {
      DPF("Setting for mu-law.");
    } /* endif */
    ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hmtV34,
                                  "ALAWFLAG", DSP_MEMXFER_DATA_WRITE, 1,
                                  &Registers.S60, szThisFile, __LINE__);
    if (ulRC) {
      return(ulRC);
    } /* endif */
  } /* endif */

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadV34 exit\n");  }


  return(0);

}


ULONG mwmLoadMNP(PMWM_DSPINFO pmwmDspInfo, HMTASK hTask, USHORT usMustHave)
{
  ULONG ulRC = 0;
  REGISTERS Registers;
  ULONG ulCurrSlashNValue;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMNP entry\n");  }


  DPF("mwmLoadMNP with pump %s", pmwmDspInfo->achV34ModuleName);

  ulRC = mwmCntndLoadModuleOptional(pmwmDspInfo, "MNP", "MNP", &pmwmDspInfo->hmodMNP,
                                    szThisFile, __LINE__, usMustHave);
  if (ulRC) {

    if (usMustHave == MWM_MUSTHAVE) {
      return ulRC;

    } else {

      DPF("Unable to load MNP (rc = %lx). Clearing FEATURES bit.", ulRC);

      ulRC = mwmParseQueryModemRegisters(&Registers);
      if (ulRC)
        return ulRC;

      ulCurrSlashNValue = Registers.SlashN;

      mwmSpcfcSetProtocol(pmwmDspInfo, ulCurrSlashNValue-2, 1);

      /* Indicate successful completion. */
      return 0;

    } /* endif */
  } /* endif */

  /******************************************************************
  ** Get MNP Task handle
  *******************************************************************/
  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodMNP, "MNP", &pmwmDspInfo->hmtMNP);
  if (ulRC != DSP_NOERROR) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__, MWM_DSP_ERROR, ulRC);
    return(ulRC);
  } /* endif */

  /*****************************************************************
  ** If MNP is loaded, make the appropriate connections.
  ** These connections will depend on whether V.42 is loaded.
  ** If V.42 is loaded, it (by default) connected to the Datapump.
  ******************************************************************/
  ulRC = mwmLoadMakeMNPConnections(pmwmDspInfo, hTask);
  if (ulRC)
    return ulRC;

  ulRC = dspChangeModuleState(pmwmDspInfo->hmodMNP, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  } /* endif */

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadMNP exit\n");  }


  return(0);

}


ULONG mwmLoadPSV8ITCBSettings( PMWM_DSPINFO pmwmDspInfo )
{

  ULONG  ulRC = 0;
  ULONG  ulAddress;
  USHORT usMODULAT1Value;
  USHORT usGSTNValue;
  USHORT usVPCMValue;

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadPSV8ITCBSettings entry\n");  }


  /***************************************************************************
  ** Set the values in PSV8ITCB that V.8 is going to need.
  ****************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtProtSupr, "ITCBPSV8", &ulAddress);
  if (ulRC) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,MWM_DSP_ERROR, ulRC);
    return (ulRC);
  } /* endif */

  if ( (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) &&
       (pmwmDspInfo->usPCMValue & FEATURE_V90) &&
       (pmwmDspInfo->usDialOrAnswerFlag == DIAL) ) {
    usMODULAT1Value = 0x02CA;
    usGSTNValue     = 0x021A;
    usVPCMValue     = 0x024E;
    DPF("Setting up PSV8ITCB for V.90 dial mode.");
  } else {
    usMODULAT1Value = 0x028A;
    usGSTNValue     = 0x821A;
    usVPCMValue     = 0x824E;
    DPF("Setting up PSV8ITCB for non-V.90 mode.");
  } /* endif */

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, (ulAddress + offsetof(PSV8ITCB, MODULAT1)),
                        &usMODULAT1Value, 1, DSP_MEMXFER_DATA_WRITE);
  if (ulRC) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,MWM_DSP_ERROR, ulRC);
    return ulRC;
  } /* endif */

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, (ulAddress + offsetof(PSV8ITCB, GSTN)),
                        &usGSTNValue, 1, DSP_MEMXFER_DATA_WRITE);
  if (ulRC) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,MWM_DSP_ERROR, ulRC);
    return (ulRC);
  } /* endif */

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, (ulAddress + offsetof(PSV8ITCB, VPCM)),
                        &usVPCMValue, 1, DSP_MEMXFER_DATA_WRITE);
  if (ulRC) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,MWM_DSP_ERROR, ulRC);
    return ulRC;
  } /* endif */

	{ MW_SYSLOG_1(TRACE_MWMLW32,"mwmload::mwmLoadPSV8ITCBSettings exit\n");  }


  return(0);
}

