// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/storagebase/proposer_kv.proto

/*
	Package storagebase is a generated protocol buffer package.

	It is generated from these files:
		storage/storagebase/proposer_kv.proto
		storage/storagebase/state.proto

	It has these top-level messages:
		Split
		Merge
		ChangeReplicas
		ComputeChecksum
		Compaction
		SuggestedCompaction
		ReplicatedEvalResult
		WriteBatch
		LogicalOpLog
		RaftCommand
		ReplicaState
		RangeInfo
		CommandQueuesSnapshot
*/
package storagebase

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_storage_engine_enginepb1 "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"
import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Split is emitted when a Replica commits a split trigger. It signals that the
// Replica has prepared the on-disk state for both the left and right hand
// sides of the split, and that the left hand side Replica should be updated as
// well as the right hand side created.
type Split struct {
	cockroach_roachpb1.SplitTrigger `protobuf:"bytes,1,opt,name=trigger,embedded=trigger" json:"trigger"`
	// RHSDelta holds the statistics for what was written to what is now the
	// right-hand side of the split during the batch which executed it.
	// The on-disk state of the right-hand side is already correct, but the
	// Store must learn about this delta to update its counters appropriately.
	RHSDelta cockroach_storage_engine_enginepb1.MVCCStats `protobuf:"bytes,2,opt,name=rhs_delta,json=rhsDelta" json:"rhs_delta"`
}

func (m *Split) Reset()                    { *m = Split{} }
func (m *Split) String() string            { return proto.CompactTextString(m) }
func (*Split) ProtoMessage()               {}
func (*Split) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{0} }

// Merge is emitted by a Replica which commits a transaction with
// a MergeTrigger (i.e. absorbs its right neighbor).
type Merge struct {
	cockroach_roachpb1.MergeTrigger `protobuf:"bytes,1,opt,name=trigger,embedded=trigger" json:"trigger"`
}

func (m *Merge) Reset()                    { *m = Merge{} }
func (m *Merge) String() string            { return proto.CompactTextString(m) }
func (*Merge) ProtoMessage()               {}
func (*Merge) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{1} }

// ChangeReplicas is emitted by a Replica which commits a transaction with
// a ChangeReplicasTrigger.
type ChangeReplicas struct {
	cockroach_roachpb1.ChangeReplicasTrigger `protobuf:"bytes,1,opt,name=trigger,embedded=trigger" json:"trigger"`
}

func (m *ChangeReplicas) Reset()                    { *m = ChangeReplicas{} }
func (*ChangeReplicas) ProtoMessage()               {}
func (*ChangeReplicas) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{2} }

// ComputeChecksum is emitted when a ComputeChecksum request is evaluated. It
// instructs the replica to compute a checksum at the time the command is
// applied.
type ComputeChecksum struct {
	// ChecksumID is a handle by which the checksum can be retrieved in a later
	// CollectChecksum request.
	ChecksumID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=checksum_id,json=checksumId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"checksum_id"`
	// SaveSnapshot indicates that the snapshot used to compute the checksum
	// should be saved so that a diff of divergent replicas can later be computed.
	SaveSnapshot bool `protobuf:"varint,2,opt,name=save_snapshot,json=saveSnapshot,proto3" json:"save_snapshot,omitempty"`
}

func (m *ComputeChecksum) Reset()                    { *m = ComputeChecksum{} }
func (m *ComputeChecksum) String() string            { return proto.CompactTextString(m) }
func (*ComputeChecksum) ProtoMessage()               {}
func (*ComputeChecksum) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{3} }

// Compaction holds core details about a suggested compaction.
type Compaction struct {
	// bytes indicates the expected space reclamation from compaction.
	Bytes int64 `protobuf:"varint,1,opt,name=bytes,proto3" json:"bytes,omitempty"`
	// suggested_at is nanoseconds since the epoch.
	SuggestedAtNanos int64 `protobuf:"varint,2,opt,name=suggested_at_nanos,json=suggestedAtNanos,proto3" json:"suggested_at_nanos,omitempty"`
}

func (m *Compaction) Reset()                    { *m = Compaction{} }
func (m *Compaction) String() string            { return proto.CompactTextString(m) }
func (*Compaction) ProtoMessage()               {}
func (*Compaction) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{4} }

// SuggestedCompaction holds start and end keys in conjunction with
// the compaction details.
type SuggestedCompaction struct {
	StartKey   github_com_cockroachdb_cockroach_pkg_roachpb.Key `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.Key" json:"start_key,omitempty"`
	EndKey     github_com_cockroachdb_cockroach_pkg_roachpb.Key `protobuf:"bytes,2,opt,name=end_key,json=endKey,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.Key" json:"end_key,omitempty"`
	Compaction `protobuf:"bytes,3,opt,name=compaction,embedded=compaction" json:"compaction"`
}

func (m *SuggestedCompaction) Reset()                    { *m = SuggestedCompaction{} }
func (m *SuggestedCompaction) String() string            { return proto.CompactTextString(m) }
func (*SuggestedCompaction) ProtoMessage()               {}
func (*SuggestedCompaction) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{5} }

// ReplicatedEvalResult is the structured information which together with
// a RocksDB WriteBatch constitutes the proposal payload in proposer-evaluated
// KV. For the majority of proposals, we expect ReplicatedEvalResult to be
// trivial; only changes to the metadata state (splits, merges, rebalances,
// leases, log truncation, ...) of the Replica or certain special commands must
// sideline information here based on which all Replicas must take action.
type ReplicatedEvalResult struct {
	// The start and end key of the proposal's range. Since VersionNoRaftProposalKeys
	// these are no longer used, but the fields are preserved so they can be populated
	// for versions beneath this. See #16075.
	DeprecatedStartKey github_com_cockroachdb_cockroach_pkg_roachpb.RKey `protobuf:"bytes,14,opt,name=deprecated_start_key,json=deprecatedStartKey,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RKey" json:"deprecated_start_key,omitempty"`
	DeprecatedEndKey   github_com_cockroachdb_cockroach_pkg_roachpb.RKey `protobuf:"bytes,15,opt,name=deprecated_end_key,json=deprecatedEndKey,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RKey" json:"deprecated_end_key,omitempty"`
	// Whether to block concurrent readers while processing the proposal data.
	BlockReads bool `protobuf:"varint,1,opt,name=block_reads,json=blockReads,proto3" json:"block_reads,omitempty"`
	// Updates to the Replica's ReplicaState. By convention and as outlined on
	// the comment on the ReplicaState message, this field is sparsely populated
	// and any field set overwrites the corresponding field in the state, perhaps
	// with additional side effects (for instance on a descriptor update).
	State           *ReplicaState    `protobuf:"bytes,2,opt,name=state" json:"state,omitempty"`
	Split           *Split           `protobuf:"bytes,3,opt,name=split" json:"split,omitempty"`
	Merge           *Merge           `protobuf:"bytes,4,opt,name=merge" json:"merge,omitempty"`
	ComputeChecksum *ComputeChecksum `protobuf:"bytes,21,opt,name=compute_checksum,json=computeChecksum" json:"compute_checksum,omitempty"`
	IsLeaseRequest  bool             `protobuf:"varint,6,opt,name=is_lease_request,json=isLeaseRequest,proto3" json:"is_lease_request,omitempty"`
	// Duplicates BatchRequest.Timestamp for proposer-evaluated KV. Used
	// to verify the validity of the command (for lease coverage and GC
	// threshold).
	Timestamp            cockroach_util_hlc.Timestamp `protobuf:"bytes,8,opt,name=timestamp" json:"timestamp"`
	IsConsistencyRelated bool                         `protobuf:"varint,9,opt,name=is_consistency_related,json=isConsistencyRelated,proto3" json:"is_consistency_related,omitempty"`
	// The stats delta corresponding to the data in this WriteBatch. On
	// a split, contains only the contributions to the left-hand side.
	DeprecatedDelta *cockroach_storage_engine_enginepb1.MVCCStats    `protobuf:"bytes,10,opt,name=deprecated_delta,json=deprecatedDelta" json:"deprecated_delta,omitempty"`
	Delta           cockroach_storage_engine_enginepb.MVCCStatsDelta `protobuf:"bytes,18,opt,name=delta" json:"delta"`
	ChangeReplicas  *ChangeReplicas                                  `protobuf:"bytes,12,opt,name=change_replicas,json=changeReplicas" json:"change_replicas,omitempty"`
	RaftLogDelta    int64                                            `protobuf:"varint,13,opt,name=raft_log_delta,json=raftLogDelta,proto3" json:"raft_log_delta,omitempty"`
	AddSSTable      *ReplicatedEvalResult_AddSSTable                 `protobuf:"bytes,17,opt,name=add_sstable,json=addSstable" json:"add_sstable,omitempty"`
	// suggested_compactions are sent to the engine's compactor to
	// reclaim storage space after garbage collection or cleared /
	// rebalanced ranges.
	SuggestedCompactions []SuggestedCompaction `protobuf:"bytes,19,rep,name=suggested_compactions,json=suggestedCompactions" json:"suggested_compactions"`
	// This is the proposal timestamp for the active lease while evaluating a lease request.
	// It will be used to make sure we know if a lease was extended after we sent out the request
	// but before we tried to apply it.
	PrevLeaseProposal *cockroach_util_hlc.Timestamp `protobuf:"bytes,20,opt,name=prev_lease_proposal,json=prevLeaseProposal" json:"prev_lease_proposal,omitempty"`
}

func (m *ReplicatedEvalResult) Reset()                    { *m = ReplicatedEvalResult{} }
func (m *ReplicatedEvalResult) String() string            { return proto.CompactTextString(m) }
func (*ReplicatedEvalResult) ProtoMessage()               {}
func (*ReplicatedEvalResult) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{6} }

// AddSSTable is a side effect that must execute before the Raft application
// is committed. It must be idempotent to account for an ill-timed crash after
// applying the side effect, but before committing the batch.
//
// TODO(tschottdorf): additionally, after the crash, the node must not serve
// traffic until the persisted committed log has fully applied. Otherwise, we
// risk exposing data created through such a side effect whose corresponding
// Raft command hasn't committed yet. This isn't so much an issue with AddSSTable
// since these Ranges are not user-visible, but it is a general concern assuming
// other such side effects are added.
type ReplicatedEvalResult_AddSSTable struct {
	Data  []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	CRC32 uint32 `protobuf:"varint,2,opt,name=crc32,proto3" json:"crc32,omitempty"`
}

func (m *ReplicatedEvalResult_AddSSTable) Reset()         { *m = ReplicatedEvalResult_AddSSTable{} }
func (m *ReplicatedEvalResult_AddSSTable) String() string { return proto.CompactTextString(m) }
func (*ReplicatedEvalResult_AddSSTable) ProtoMessage()    {}
func (*ReplicatedEvalResult_AddSSTable) Descriptor() ([]byte, []int) {
	return fileDescriptorProposerKv, []int{6, 0}
}

// WriteBatch is the serialized representation of a RocksDB write
// batch. A wrapper message is used so that the absence of the field
// can be distinguished from a zero-length batch, and so structs
// containing pointers to it can be compared with the == operator.
type WriteBatch struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *WriteBatch) Reset()                    { *m = WriteBatch{} }
func (m *WriteBatch) String() string            { return proto.CompactTextString(m) }
func (*WriteBatch) ProtoMessage()               {}
func (*WriteBatch) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{7} }

// LogicalOpLog is a log of logical MVCC operations. A wrapper message
// is used so that the absence of the field can be distinguished from a
// zero-length batch, and so structs containing pointers to it can be
// compared with the == operator.
type LogicalOpLog struct {
	Ops []cockroach_storage_engine_enginepb.MVCCLogicalOp `protobuf:"bytes,1,rep,name=ops" json:"ops"`
}

func (m *LogicalOpLog) Reset()                    { *m = LogicalOpLog{} }
func (m *LogicalOpLog) String() string            { return proto.CompactTextString(m) }
func (*LogicalOpLog) ProtoMessage()               {}
func (*LogicalOpLog) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{8} }

// RaftCommand is the message written to the raft log. It contains
// some metadata about the proposal itself, then either a BatchRequest
// (legacy mode) or a ReplicatedEvalResult + WriteBatch
// (proposer-evaluated KV mode).
type RaftCommand struct {
	// proposer_replica is the replica which proposed this command, to be
	// used for lease validation.
	ProposerReplica cockroach_roachpb.ReplicaDescriptor `protobuf:"bytes,2,opt,name=proposer_replica,json=proposerReplica" json:"proposer_replica"`
	// proposer_lease_seq is provided to verify at raft command apply-time
	// that the lease under which the command was proposed remains in effect.
	//
	// To see why lease verification downstream of Raft is required, consider the
	// following example:
	// - replica 1 receives a client request for a write
	// - replica 1 checks the lease; the write is permitted
	// - replica 1 proposes the command
	// - time passes, replica 2 commits a new lease
	// - the command applies on replica 1
	// - replica 2 serves anomalous reads which don't see the write
	// - the command applies on replica 2
	ProposerLeaseSequence github_com_cockroachdb_cockroach_pkg_roachpb.LeaseSequence `protobuf:"varint,6,opt,name=proposer_lease_sequence,json=proposerLeaseSequence,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.LeaseSequence" json:"proposer_lease_sequence,omitempty"`
	// deprecated_proposer_lease served the same purpose as proposer_lease_seq.
	// As of VersionLeaseSequence, it is no longer in use.
	//
	// However, unless we add a check that all existing Raft logs on all nodes
	// in the cluster contain only "new" leases, we won't be able to remove the
	// legacy code.
	DeprecatedProposerLease *cockroach_roachpb1.Lease `protobuf:"bytes,5,opt,name=deprecated_proposer_lease,json=deprecatedProposerLease" json:"deprecated_proposer_lease,omitempty"`
	// When the command is applied, its result is an error if the lease log
	// counter has already reached (or exceeded) max_lease_index.
	//
	// The lease index is a reorder protection mechanism - we don't want Raft
	// commands (proposed by a single node, the one with proposer_lease) executing
	// in a different order than the one in which the corresponding KV requests
	// were evaluated and the commands were proposed. This is important because
	// the CommandQueue does not fully serialize commands - mostly when it comes
	// to updates to the internal state of the range (this should be re-evaluated
	// once proposer-evaluated KV is completed - see #10413).
	// Similar to the Raft applied index, it is strictly increasing, but may have
	// gaps. A command will only apply successfully if its max_lease_index has not
	// been surpassed by the Range's applied lease index (in which case the
	// command may need to be retried, that is, regenerated with a higher
	// max_lease_index). When the command applies, the new lease index will
	// increase to max_lease_index (so a potential later replay will fail).
	//
	// This mechanism was introduced as a simpler alternative to using the Raft
	// applied index, which is fraught with complexity due to the need to predict
	// exactly the log position at which a command will apply, even when the Raft
	// leader is not colocated with the lease holder (which usually proposes all
	// commands).
	//
	// Pinning the lease-index to the assigned slot (as opposed to allowing gaps
	// as we do now) is an interesting venue to explore from the standpoint of
	// parallelization: One could hope to enforce command ordering in that way
	// (without recourse to a higher-level locking primitive such as the command
	// queue). This is a hard problem: First of all, managing the pending
	// commands gets more involved; a command must not be removed if others have
	// been added after it, and on removal, the assignment counters must be
	// updated accordingly. Managing retry of proposals becomes trickier as
	// well as that uproots whatever ordering was originally envisioned.
	MaxLeaseIndex uint64 `protobuf:"varint,4,opt,name=max_lease_index,json=maxLeaseIndex,proto3" json:"max_lease_index,omitempty"`
	// replicated_eval_result is a set of structured information that instructs
	// replicated state changes to the part of a Range's replicated state machine
	// that exists outside of RocksDB.
	ReplicatedEvalResult ReplicatedEvalResult `protobuf:"bytes,13,opt,name=replicated_eval_result,json=replicatedEvalResult" json:"replicated_eval_result"`
	// write_batch is a RocksDB WriteBatch that will be applied to RockDB during
	// the application of the Raft command. The batch can be thought of as a
	// series of replicated instructions that inform a RocksDB engine on how to
	// change.
	WriteBatch *WriteBatch `protobuf:"bytes,14,opt,name=write_batch,json=writeBatch" json:"write_batch,omitempty"`
	// logical_op_log contains a series of logical MVCC operations that correspond
	// to the physical operations being made in the write_batch.
	LogicalOpLog *LogicalOpLog `protobuf:"bytes,15,opt,name=logical_op_log,json=logicalOpLog" json:"logical_op_log,omitempty"`
}

func (m *RaftCommand) Reset()                    { *m = RaftCommand{} }
func (m *RaftCommand) String() string            { return proto.CompactTextString(m) }
func (*RaftCommand) ProtoMessage()               {}
func (*RaftCommand) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{9} }

func init() {
	proto.RegisterType((*Split)(nil), "cockroach.storage.storagebase.Split")
	proto.RegisterType((*Merge)(nil), "cockroach.storage.storagebase.Merge")
	proto.RegisterType((*ChangeReplicas)(nil), "cockroach.storage.storagebase.ChangeReplicas")
	proto.RegisterType((*ComputeChecksum)(nil), "cockroach.storage.storagebase.ComputeChecksum")
	proto.RegisterType((*Compaction)(nil), "cockroach.storage.storagebase.Compaction")
	proto.RegisterType((*SuggestedCompaction)(nil), "cockroach.storage.storagebase.SuggestedCompaction")
	proto.RegisterType((*ReplicatedEvalResult)(nil), "cockroach.storage.storagebase.ReplicatedEvalResult")
	proto.RegisterType((*ReplicatedEvalResult_AddSSTable)(nil), "cockroach.storage.storagebase.ReplicatedEvalResult.AddSSTable")
	proto.RegisterType((*WriteBatch)(nil), "cockroach.storage.storagebase.WriteBatch")
	proto.RegisterType((*LogicalOpLog)(nil), "cockroach.storage.storagebase.LogicalOpLog")
	proto.RegisterType((*RaftCommand)(nil), "cockroach.storage.storagebase.RaftCommand")
}
func (this *Split) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Split)
	if !ok {
		that2, ok := that.(Split)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SplitTrigger.Equal(&that1.SplitTrigger) {
		return false
	}
	if !this.RHSDelta.Equal(&that1.RHSDelta) {
		return false
	}
	return true
}
func (this *Merge) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Merge)
	if !ok {
		that2, ok := that.(Merge)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MergeTrigger.Equal(&that1.MergeTrigger) {
		return false
	}
	return true
}
func (this *ChangeReplicas) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ChangeReplicas)
	if !ok {
		that2, ok := that.(ChangeReplicas)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ChangeReplicasTrigger.Equal(&that1.ChangeReplicasTrigger) {
		return false
	}
	return true
}
func (this *ComputeChecksum) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ComputeChecksum)
	if !ok {
		that2, ok := that.(ComputeChecksum)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ChecksumID.Equal(that1.ChecksumID) {
		return false
	}
	if this.SaveSnapshot != that1.SaveSnapshot {
		return false
	}
	return true
}
func (this *Compaction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Compaction)
	if !ok {
		that2, ok := that.(Compaction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Bytes != that1.Bytes {
		return false
	}
	if this.SuggestedAtNanos != that1.SuggestedAtNanos {
		return false
	}
	return true
}
func (this *SuggestedCompaction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SuggestedCompaction)
	if !ok {
		that2, ok := that.(SuggestedCompaction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.StartKey, that1.StartKey) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	if !this.Compaction.Equal(&that1.Compaction) {
		return false
	}
	return true
}
func (this *ReplicatedEvalResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicatedEvalResult)
	if !ok {
		that2, ok := that.(ReplicatedEvalResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.DeprecatedStartKey, that1.DeprecatedStartKey) {
		return false
	}
	if !bytes.Equal(this.DeprecatedEndKey, that1.DeprecatedEndKey) {
		return false
	}
	if this.BlockReads != that1.BlockReads {
		return false
	}
	if !this.State.Equal(that1.State) {
		return false
	}
	if !this.Split.Equal(that1.Split) {
		return false
	}
	if !this.Merge.Equal(that1.Merge) {
		return false
	}
	if !this.ComputeChecksum.Equal(that1.ComputeChecksum) {
		return false
	}
	if this.IsLeaseRequest != that1.IsLeaseRequest {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	if this.IsConsistencyRelated != that1.IsConsistencyRelated {
		return false
	}
	if !this.DeprecatedDelta.Equal(that1.DeprecatedDelta) {
		return false
	}
	if !this.Delta.Equal(&that1.Delta) {
		return false
	}
	if !this.ChangeReplicas.Equal(that1.ChangeReplicas) {
		return false
	}
	if this.RaftLogDelta != that1.RaftLogDelta {
		return false
	}
	if !this.AddSSTable.Equal(that1.AddSSTable) {
		return false
	}
	if len(this.SuggestedCompactions) != len(that1.SuggestedCompactions) {
		return false
	}
	for i := range this.SuggestedCompactions {
		if !this.SuggestedCompactions[i].Equal(&that1.SuggestedCompactions[i]) {
			return false
		}
	}
	if !this.PrevLeaseProposal.Equal(that1.PrevLeaseProposal) {
		return false
	}
	return true
}
func (this *ReplicatedEvalResult_AddSSTable) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicatedEvalResult_AddSSTable)
	if !ok {
		that2, ok := that.(ReplicatedEvalResult_AddSSTable)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if this.CRC32 != that1.CRC32 {
		return false
	}
	return true
}
func (m *Split) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Split) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.SplitTrigger.Size()))
	n1, err := m.SplitTrigger.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.RHSDelta.Size()))
	n2, err := m.RHSDelta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *Merge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Merge) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.MergeTrigger.Size()))
	n3, err := m.MergeTrigger.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func (m *ChangeReplicas) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeReplicas) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.ChangeReplicasTrigger.Size()))
	n4, err := m.ChangeReplicasTrigger.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	return i, nil
}

func (m *ComputeChecksum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeChecksum) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.ChecksumID.Size()))
	n5, err := m.ChecksumID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.SaveSnapshot {
		dAtA[i] = 0x10
		i++
		if m.SaveSnapshot {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Compaction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Compaction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Bytes != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.Bytes))
	}
	if m.SuggestedAtNanos != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.SuggestedAtNanos))
	}
	return i, nil
}

func (m *SuggestedCompaction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SuggestedCompaction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StartKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.Compaction.Size()))
	n6, err := m.Compaction.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	return i, nil
}

func (m *ReplicatedEvalResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicatedEvalResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.BlockReads {
		dAtA[i] = 0x8
		i++
		if m.BlockReads {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.State != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.State.Size()))
		n7, err := m.State.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Split != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.Split.Size()))
		n8, err := m.Split.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Merge != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.Merge.Size()))
		n9, err := m.Merge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.IsLeaseRequest {
		dAtA[i] = 0x30
		i++
		if m.IsLeaseRequest {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	dAtA[i] = 0x42
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.Timestamp.Size()))
	n10, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if m.IsConsistencyRelated {
		dAtA[i] = 0x48
		i++
		if m.IsConsistencyRelated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DeprecatedDelta != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.DeprecatedDelta.Size()))
		n11, err := m.DeprecatedDelta.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.ChangeReplicas != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.ChangeReplicas.Size()))
		n12, err := m.ChangeReplicas.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.RaftLogDelta != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.RaftLogDelta))
	}
	if len(m.DeprecatedStartKey) > 0 {
		dAtA[i] = 0x72
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.DeprecatedStartKey)))
		i += copy(dAtA[i:], m.DeprecatedStartKey)
	}
	if len(m.DeprecatedEndKey) > 0 {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.DeprecatedEndKey)))
		i += copy(dAtA[i:], m.DeprecatedEndKey)
	}
	if m.AddSSTable != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.AddSSTable.Size()))
		n13, err := m.AddSSTable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	dAtA[i] = 0x92
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.Delta.Size()))
	n14, err := m.Delta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	if len(m.SuggestedCompactions) > 0 {
		for _, msg := range m.SuggestedCompactions {
			dAtA[i] = 0x9a
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintProposerKv(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.PrevLeaseProposal != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.PrevLeaseProposal.Size()))
		n15, err := m.PrevLeaseProposal.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.ComputeChecksum != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.ComputeChecksum.Size()))
		n16, err := m.ComputeChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *ReplicatedEvalResult_AddSSTable) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicatedEvalResult_AddSSTable) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.CRC32 != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.CRC32))
	}
	return i, nil
}

func (m *WriteBatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteBatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *LogicalOpLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogicalOpLog) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ops) > 0 {
		for _, msg := range m.Ops {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProposerKv(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RaftCommand) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftCommand) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x12
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.ProposerReplica.Size()))
	n17, err := m.ProposerReplica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	if m.MaxLeaseIndex != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.MaxLeaseIndex))
	}
	if m.DeprecatedProposerLease != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.DeprecatedProposerLease.Size()))
		n18, err := m.DeprecatedProposerLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.ProposerLeaseSequence != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.ProposerLeaseSequence))
	}
	dAtA[i] = 0x6a
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.ReplicatedEvalResult.Size()))
	n19, err := m.ReplicatedEvalResult.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	if m.WriteBatch != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.WriteBatch.Size()))
		n20, err := m.WriteBatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.LogicalOpLog != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.LogicalOpLog.Size()))
		n21, err := m.LogicalOpLog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	return i, nil
}

func encodeVarintProposerKv(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Split) Size() (n int) {
	var l int
	_ = l
	l = m.SplitTrigger.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	l = m.RHSDelta.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	return n
}

func (m *Merge) Size() (n int) {
	var l int
	_ = l
	l = m.MergeTrigger.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	return n
}

func (m *ChangeReplicas) Size() (n int) {
	var l int
	_ = l
	l = m.ChangeReplicasTrigger.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	return n
}

func (m *ComputeChecksum) Size() (n int) {
	var l int
	_ = l
	l = m.ChecksumID.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	if m.SaveSnapshot {
		n += 2
	}
	return n
}

func (m *Compaction) Size() (n int) {
	var l int
	_ = l
	if m.Bytes != 0 {
		n += 1 + sovProposerKv(uint64(m.Bytes))
	}
	if m.SuggestedAtNanos != 0 {
		n += 1 + sovProposerKv(uint64(m.SuggestedAtNanos))
	}
	return n
}

func (m *SuggestedCompaction) Size() (n int) {
	var l int
	_ = l
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovProposerKv(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovProposerKv(uint64(l))
	}
	l = m.Compaction.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	return n
}

func (m *ReplicatedEvalResult) Size() (n int) {
	var l int
	_ = l
	if m.BlockReads {
		n += 2
	}
	if m.State != nil {
		l = m.State.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.Split != nil {
		l = m.Split.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.Merge != nil {
		l = m.Merge.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.IsLeaseRequest {
		n += 2
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	if m.IsConsistencyRelated {
		n += 2
	}
	if m.DeprecatedDelta != nil {
		l = m.DeprecatedDelta.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.ChangeReplicas != nil {
		l = m.ChangeReplicas.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.RaftLogDelta != 0 {
		n += 1 + sovProposerKv(uint64(m.RaftLogDelta))
	}
	l = len(m.DeprecatedStartKey)
	if l > 0 {
		n += 1 + l + sovProposerKv(uint64(l))
	}
	l = len(m.DeprecatedEndKey)
	if l > 0 {
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.AddSSTable != nil {
		l = m.AddSSTable.Size()
		n += 2 + l + sovProposerKv(uint64(l))
	}
	l = m.Delta.Size()
	n += 2 + l + sovProposerKv(uint64(l))
	if len(m.SuggestedCompactions) > 0 {
		for _, e := range m.SuggestedCompactions {
			l = e.Size()
			n += 2 + l + sovProposerKv(uint64(l))
		}
	}
	if m.PrevLeaseProposal != nil {
		l = m.PrevLeaseProposal.Size()
		n += 2 + l + sovProposerKv(uint64(l))
	}
	if m.ComputeChecksum != nil {
		l = m.ComputeChecksum.Size()
		n += 2 + l + sovProposerKv(uint64(l))
	}
	return n
}

func (m *ReplicatedEvalResult_AddSSTable) Size() (n int) {
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.CRC32 != 0 {
		n += 1 + sovProposerKv(uint64(m.CRC32))
	}
	return n
}

func (m *WriteBatch) Size() (n int) {
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovProposerKv(uint64(l))
	}
	return n
}

func (m *LogicalOpLog) Size() (n int) {
	var l int
	_ = l
	if len(m.Ops) > 0 {
		for _, e := range m.Ops {
			l = e.Size()
			n += 1 + l + sovProposerKv(uint64(l))
		}
	}
	return n
}

func (m *RaftCommand) Size() (n int) {
	var l int
	_ = l
	l = m.ProposerReplica.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	if m.MaxLeaseIndex != 0 {
		n += 1 + sovProposerKv(uint64(m.MaxLeaseIndex))
	}
	if m.DeprecatedProposerLease != nil {
		l = m.DeprecatedProposerLease.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.ProposerLeaseSequence != 0 {
		n += 1 + sovProposerKv(uint64(m.ProposerLeaseSequence))
	}
	l = m.ReplicatedEvalResult.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	if m.WriteBatch != nil {
		l = m.WriteBatch.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.LogicalOpLog != nil {
		l = m.LogicalOpLog.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	return n
}

func sovProposerKv(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozProposerKv(x uint64) (n int) {
	return sovProposerKv(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Split) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Split: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Split: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SplitTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RHSDelta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RHSDelta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Merge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Merge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Merge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MergeTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeReplicas) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangeReplicas: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangeReplicas: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeReplicasTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChangeReplicasTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeChecksum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComputeChecksum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComputeChecksum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChecksumID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChecksumID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SaveSnapshot", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SaveSnapshot = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Compaction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Compaction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Compaction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bytes", wireType)
			}
			m.Bytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Bytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuggestedAtNanos", wireType)
			}
			m.SuggestedAtNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SuggestedAtNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SuggestedCompaction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SuggestedCompaction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SuggestedCompaction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Compaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicatedEvalResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicatedEvalResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicatedEvalResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockReads", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BlockReads = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.State == nil {
				m.State = &ReplicaState{}
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Split", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Split == nil {
				m.Split = &Split{}
			}
			if err := m.Split.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Merge == nil {
				m.Merge = &Merge{}
			}
			if err := m.Merge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsLeaseRequest", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsLeaseRequest = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsConsistencyRelated", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsConsistencyRelated = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedDelta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedDelta == nil {
				m.DeprecatedDelta = &cockroach_storage_engine_enginepb1.MVCCStats{}
			}
			if err := m.DeprecatedDelta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChangeReplicas == nil {
				m.ChangeReplicas = &ChangeReplicas{}
			}
			if err := m.ChangeReplicas.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftLogDelta", wireType)
			}
			m.RaftLogDelta = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftLogDelta |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedStartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeprecatedStartKey = append(m.DeprecatedStartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.DeprecatedStartKey == nil {
				m.DeprecatedStartKey = []byte{}
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedEndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeprecatedEndKey = append(m.DeprecatedEndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.DeprecatedEndKey == nil {
				m.DeprecatedEndKey = []byte{}
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSSTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddSSTable == nil {
				m.AddSSTable = &ReplicatedEvalResult_AddSSTable{}
			}
			if err := m.AddSSTable.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Delta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuggestedCompactions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SuggestedCompactions = append(m.SuggestedCompactions, SuggestedCompaction{})
			if err := m.SuggestedCompactions[len(m.SuggestedCompactions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevLeaseProposal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PrevLeaseProposal == nil {
				m.PrevLeaseProposal = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.PrevLeaseProposal.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComputeChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ComputeChecksum == nil {
				m.ComputeChecksum = &ComputeChecksum{}
			}
			if err := m.ComputeChecksum.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicatedEvalResult_AddSSTable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSSTable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSSTable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CRC32", wireType)
			}
			m.CRC32 = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CRC32 |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteBatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteBatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteBatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogicalOpLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogicalOpLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogicalOpLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ops", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ops = append(m.Ops, cockroach_storage_engine_enginepb.MVCCLogicalOp{})
			if err := m.Ops[len(m.Ops)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftCommand) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftCommand: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftCommand: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposerReplica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ProposerReplica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxLeaseIndex", wireType)
			}
			m.MaxLeaseIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxLeaseIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedProposerLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedProposerLease == nil {
				m.DeprecatedProposerLease = &cockroach_roachpb1.Lease{}
			}
			if err := m.DeprecatedProposerLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposerLeaseSequence", wireType)
			}
			m.ProposerLeaseSequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProposerLeaseSequence |= (github_com_cockroachdb_cockroach_pkg_roachpb.LeaseSequence(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicatedEvalResult", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReplicatedEvalResult.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteBatch == nil {
				m.WriteBatch = &WriteBatch{}
			}
			if err := m.WriteBatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogicalOpLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LogicalOpLog == nil {
				m.LogicalOpLog = &LogicalOpLog{}
			}
			if err := m.LogicalOpLog.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProposerKv(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthProposerKv
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowProposerKv
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipProposerKv(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthProposerKv = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProposerKv   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("storage/storagebase/proposer_kv.proto", fileDescriptorProposerKv) }

var fileDescriptorProposerKv = []byte{
	// 1349 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0xcf, 0x73, 0xd3, 0xc6,
	0x17, 0x8f, 0x63, 0x3b, 0x28, 0xcf, 0x89, 0x6d, 0x16, 0x03, 0xfa, 0x32, 0x43, 0xc4, 0x04, 0xf8,
	0x4e, 0xbe, 0xf3, 0xa5, 0x32, 0x24, 0xf4, 0xc2, 0x81, 0x99, 0xd8, 0x61, 0x4a, 0x4c, 0x92, 0xc2,
	0x3a, 0x40, 0x7f, 0x1c, 0x34, 0x6b, 0x69, 0x91, 0xd5, 0xc8, 0x92, 0xaa, 0x5d, 0x1b, 0xf2, 0x5f,
	0xb4, 0x3d, 0xf5, 0xd4, 0x72, 0xec, 0xad, 0xff, 0x06, 0x47, 0x8e, 0x9d, 0x1e, 0x3c, 0xad, 0x7b,
	0xe9, 0xdf, 0xc0, 0x74, 0x3a, 0x9d, 0x5d, 0xad, 0x2c, 0xa5, 0xa4, 0xc4, 0x29, 0x97, 0x58, 0x7a,
	0xbb, 0xef, 0xf3, 0xde, 0xbe, 0xf7, 0x3e, 0x9f, 0x55, 0xe0, 0x3a, 0xe3, 0x61, 0x4c, 0x5c, 0xda,
	0x54, 0xbf, 0x3d, 0xc2, 0x68, 0x33, 0x8a, 0xc3, 0x28, 0x64, 0x34, 0xb6, 0x0e, 0x46, 0x66, 0x14,
	0x87, 0x3c, 0x44, 0x97, 0xed, 0xd0, 0x3e, 0x88, 0x43, 0x62, 0xf7, 0x4d, 0xb5, 0xd1, 0xcc, 0x39,
	0x5c, 0x42, 0x72, 0x29, 0xea, 0x35, 0x1d, 0xc2, 0x49, 0xe2, 0x72, 0xe9, 0x42, 0x6a, 0x1b, 0x50,
	0x4e, 0x72, 0xf6, 0xd5, 0x34, 0x22, 0x0d, 0x5c, 0x2f, 0x48, 0x7f, 0xc4, 0xbe, 0x91, 0x6d, 0xab,
	0x3d, 0x57, 0xdf, 0xb5, 0x67, 0x43, 0x6d, 0x32, 0x8e, 0x4b, 0x9d, 0x71, 0xc2, 0xa9, 0xda, 0xa0,
	0x0f, 0xb9, 0xe7, 0x37, 0xfb, 0xbe, 0xdd, 0xe4, 0xde, 0x80, 0x32, 0x4e, 0x06, 0x91, 0x5a, 0x69,
	0xb8, 0xa1, 0x1b, 0xca, 0xc7, 0xa6, 0x78, 0x4a, 0xac, 0xab, 0x3f, 0x16, 0xa0, 0xdc, 0x8d, 0x7c,
	0x8f, 0xa3, 0x36, 0x9c, 0xe1, 0xb1, 0xe7, 0xba, 0x34, 0xd6, 0x0b, 0x57, 0x0a, 0x6b, 0x95, 0x75,
	0xc3, 0xcc, 0x0a, 0xa0, 0xce, 0x65, 0xca, 0xad, 0xfb, 0xc9, 0xb6, 0x96, 0xf6, 0x6a, 0x6c, 0xcc,
	0xbd, 0x1e, 0x1b, 0x05, 0x9c, 0x7a, 0xa2, 0xcf, 0x61, 0x31, 0xee, 0x33, 0xcb, 0xa1, 0x3e, 0x27,
	0xfa, 0xbc, 0x84, 0xb9, 0x61, 0xbe, 0x5d, 0xc7, 0xe4, 0x6c, 0x66, 0x7a, 0x44, 0x73, 0xf7, 0x49,
	0xbb, 0xdd, 0xe5, 0x84, 0xb3, 0x56, 0x5d, 0x60, 0x4e, 0xc6, 0x86, 0x86, 0xef, 0x77, 0xb7, 0x04,
	0x0a, 0xd6, 0xe2, 0x3e, 0x93, 0x4f, 0x77, 0x4a, 0xbf, 0xbf, 0x34, 0x0a, 0xab, 0x18, 0xca, 0xbb,
	0x34, 0x76, 0xe9, 0x6c, 0x09, 0xcb, 0xad, 0xff, 0x9c, 0xb0, 0xc2, 0xec, 0x43, 0xb5, 0xdd, 0x27,
	0x81, 0x4b, 0x31, 0x8d, 0x7c, 0xcf, 0x26, 0x0c, 0xed, 0xfc, 0x1d, 0x7c, 0xed, 0x18, 0xf0, 0xa3,
	0x3e, 0xef, 0x88, 0xa2, 0x7d, 0xfb, 0xd2, 0x98, 0x93, 0x91, 0x7e, 0x28, 0x40, 0xad, 0x1d, 0x0e,
	0xa2, 0x21, 0xa7, 0xed, 0x3e, 0xb5, 0x0f, 0xd8, 0x70, 0x80, 0xbe, 0x80, 0x8a, 0xad, 0x9e, 0x2d,
	0xcf, 0x91, 0xf1, 0x96, 0x5a, 0xdb, 0x02, 0xe5, 0xe7, 0xb1, 0xb1, 0xe1, 0x7a, 0xbc, 0x3f, 0xec,
	0x99, 0x76, 0x38, 0x68, 0x4e, 0x33, 0x70, 0x7a, 0xd9, 0x73, 0x33, 0x3a, 0x70, 0x9b, 0xb2, 0xeb,
	0xc3, 0xa1, 0xe7, 0x98, 0x8f, 0x1f, 0x6f, 0x6f, 0x4d, 0xc6, 0x06, 0xa4, 0xe8, 0xdb, 0x5b, 0x18,
	0x52, 0xf4, 0x6d, 0x07, 0x5d, 0x85, 0x65, 0x46, 0x46, 0xd4, 0x62, 0x01, 0x89, 0x58, 0x3f, 0xe4,
	0xb2, 0x49, 0x1a, 0x5e, 0x12, 0xc6, 0xae, 0xb2, 0xa9, 0xa2, 0x3c, 0x01, 0x10, 0x99, 0x12, 0x9b,
	0x7b, 0x61, 0x80, 0x1a, 0x50, 0xee, 0x1d, 0x72, 0xca, 0x64, 0x7a, 0x45, 0x9c, 0xbc, 0xa0, 0x1b,
	0x80, 0xd8, 0xd0, 0x75, 0x29, 0xe3, 0xd4, 0xb1, 0x08, 0xb7, 0x02, 0x12, 0x84, 0x4c, 0x62, 0x16,
	0x71, 0x7d, 0xba, 0xb2, 0xc9, 0xf7, 0x84, 0x5d, 0xe1, 0x7e, 0x33, 0x0f, 0xe7, 0xba, 0xe9, 0x52,
	0x2e, 0xc2, 0x23, 0x58, 0x64, 0x9c, 0xc4, 0xdc, 0x3a, 0xa0, 0x87, 0xaa, 0x08, 0xb7, 0xdf, 0x8c,
	0x8d, 0x9b, 0x33, 0x15, 0x20, 0x6d, 0xc9, 0x03, 0x7a, 0x88, 0x35, 0x09, 0xf3, 0x80, 0x1e, 0xa2,
	0x5d, 0x38, 0x43, 0x03, 0x47, 0x02, 0xce, 0xbf, 0x07, 0xe0, 0x02, 0x0d, 0x1c, 0x01, 0xd7, 0x05,
	0xb0, 0xa7, 0xf9, 0xea, 0x45, 0x39, 0x17, 0xff, 0x33, 0xdf, 0x29, 0x13, 0x66, 0x76, 0xc0, 0xdc,
	0x60, 0xe4, 0x60, 0x54, 0x51, 0xfe, 0x00, 0x68, 0xa8, 0x41, 0xe2, 0xd4, 0xb9, 0x37, 0x22, 0x3e,
	0xa6, 0x6c, 0xe8, 0x73, 0x64, 0x40, 0xa5, 0xe7, 0x87, 0xf6, 0x81, 0x15, 0x53, 0xe2, 0x24, 0xd5,
	0xd7, 0x30, 0x48, 0x13, 0x16, 0x16, 0xb4, 0x09, 0x65, 0x29, 0x00, 0x8a, 0x6e, 0xff, 0x3f, 0x21,
	0x1f, 0x15, 0x44, 0xb0, 0x8d, 0xe2, 0xc4, 0x13, 0xdd, 0x81, 0x32, 0x13, 0xc4, 0x56, 0x47, 0xba,
	0x76, 0x02, 0x84, 0x14, 0x01, 0x9c, 0xb8, 0x08, 0xdf, 0x81, 0xe0, 0x98, 0x5e, 0x9a, 0xc9, 0x57,
	0xf2, 0x11, 0x27, 0x2e, 0x68, 0x0d, 0xea, 0x1e, 0xb3, 0x7c, 0x4a, 0x18, 0xb5, 0x62, 0xfa, 0xe5,
	0x90, 0x32, 0xae, 0x2f, 0xc8, 0x03, 0x56, 0x3d, 0xb6, 0x23, 0xcc, 0x38, 0xb1, 0xa2, 0x4d, 0x58,
	0x9c, 0xea, 0x99, 0xae, 0xc9, 0x48, 0x97, 0x73, 0x91, 0xc4, 0xf8, 0x9b, 0x7d, 0xdf, 0x36, 0xf7,
	0xd3, 0x4d, 0xad, 0x92, 0x28, 0x36, 0xce, 0xbc, 0xd0, 0x6d, 0xb8, 0xe0, 0x31, 0xcb, 0x0e, 0x03,
	0xe6, 0x31, 0x4e, 0x03, 0xfb, 0xd0, 0x8a, 0xa9, 0x2f, 0x8a, 0xad, 0x2f, 0xca, 0x90, 0x0d, 0x8f,
	0xb5, 0xb3, 0x45, 0x9c, 0xac, 0xa1, 0xa7, 0x50, 0x77, 0x68, 0x14, 0x53, 0xd9, 0x16, 0xa5, 0x6b,
	0x70, 0x7a, 0x5d, 0xc3, 0xb5, 0x0c, 0x45, 0x8a, 0x19, 0x7a, 0x02, 0x35, 0x5b, 0xca, 0x87, 0x15,
	0x2b, 0xfd, 0xd0, 0x97, 0x24, 0xee, 0x07, 0x27, 0x0d, 0xd4, 0x11, 0xd1, 0xc1, 0x55, 0xfb, 0xa8,
	0x70, 0x5d, 0x83, 0x6a, 0x4c, 0x9e, 0x71, 0xcb, 0x0f, 0x5d, 0x95, 0xee, 0xb2, 0x64, 0xe3, 0x92,
	0xb0, 0xee, 0x84, 0x6e, 0x12, 0xdd, 0x85, 0x46, 0xee, 0x58, 0x19, 0xed, 0xaa, 0x92, 0x25, 0x1f,
	0xbe, 0x19, 0x1b, 0xb7, 0x4e, 0xc5, 0x12, 0x2c, 0x68, 0x82, 0x32, 0xc8, 0x6e, 0xca, 0x40, 0x1b,
	0x72, 0x56, 0x2b, 0x25, 0x63, 0xed, 0x7d, 0xc2, 0xe4, 0x1a, 0x72, 0x2f, 0xe1, 0x65, 0x08, 0x15,
	0xe2, 0x38, 0x16, 0x63, 0x9c, 0xf4, 0x7c, 0xaa, 0x9f, 0x95, 0x75, 0xbc, 0x3b, 0x1b, 0x11, 0x8e,
	0xb0, 0xcd, 0xdc, 0x74, 0x9c, 0x6e, 0x77, 0x5f, 0xa0, 0xb4, 0xaa, 0x42, 0x45, 0xb3, 0x77, 0x0c,
	0xc4, 0x71, 0xba, 0x49, 0x04, 0xb4, 0x0b, 0xe5, 0xa4, 0xb6, 0x48, 0x86, 0xba, 0x75, 0x9a, 0x51,
	0x90, 0x0d, 0x50, 0xe3, 0x99, 0xa0, 0xa0, 0x01, 0x9c, 0xcf, 0x54, 0x34, 0x93, 0x06, 0xa6, 0x9f,
	0xbb, 0x52, 0x5c, 0xab, 0xac, 0xaf, 0x9f, 0xc4, 0xc7, 0xb7, 0xc5, 0x54, 0xe1, 0x37, 0xd8, 0xdb,
	0x4b, 0x0c, 0xed, 0xc2, 0xb9, 0x28, 0xa6, 0x23, 0x45, 0xbc, 0xe4, 0xc3, 0x87, 0xf8, 0x7a, 0x63,
	0x06, 0x5a, 0xe1, 0xb3, 0xc2, 0x53, 0x52, 0xf3, 0xa1, 0xf2, 0x43, 0x9f, 0x42, 0xdd, 0x4e, 0x6e,
	0x34, 0x2b, 0xbd, 0x68, 0xf4, 0xf3, 0x12, 0xcb, 0x9c, 0x41, 0x1b, 0x73, 0x17, 0x21, 0xae, 0xd9,
	0x47, 0x0d, 0x97, 0x3e, 0x82, 0x5c, 0x07, 0x10, 0x82, 0x92, 0xf8, 0xa6, 0x4a, 0xee, 0x06, 0x2c,
	0x9f, 0x91, 0x01, 0x65, 0x3b, 0xb6, 0x37, 0xd6, 0xa5, 0xfa, 0x2d, 0xb7, 0x16, 0x27, 0x63, 0xa3,
	0xdc, 0xc6, 0xed, 0x8d, 0x75, 0x9c, 0xd8, 0x13, 0x79, 0x4d, 0xfe, 0x76, 0x4a, 0x5a, 0xb9, 0xbe,
	0xd0, 0x29, 0x69, 0x67, 0xea, 0x5a, 0xa7, 0xa4, 0xd5, 0xeb, 0x67, 0x3b, 0x0b, 0xda, 0xd7, 0x7b,
	0xf5, 0xef, 0xf6, 0x56, 0xaf, 0x00, 0x3c, 0x8d, 0x3d, 0x4e, 0x5b, 0x84, 0xdb, 0xfd, 0xe3, 0x02,
	0xad, 0x7e, 0x02, 0x4b, 0x3b, 0xa1, 0xeb, 0xd9, 0xc4, 0xff, 0x38, 0xda, 0x09, 0x5d, 0x74, 0x1f,
	0x8a, 0x61, 0x24, 0xf4, 0x58, 0x74, 0xe8, 0xe6, 0x8c, 0x03, 0x30, 0x45, 0x50, 0xfd, 0x11, 0x10,
	0xab, 0x7f, 0x96, 0xa0, 0x82, 0xc9, 0x33, 0xde, 0x0e, 0x07, 0x03, 0x12, 0x38, 0xe8, 0x31, 0xd4,
	0xa7, 0x1f, 0xa3, 0x4a, 0x1b, 0x94, 0xb6, 0x5f, 0x3b, 0xe6, 0x1b, 0x44, 0x8d, 0xf1, 0x16, 0x65,
	0x76, 0xec, 0x45, 0x3c, 0x8c, 0x15, 0x74, 0x2d, 0xc5, 0x50, 0x1b, 0xd0, 0x7f, 0xa1, 0x36, 0x20,
	0x2f, 0x54, 0xd3, 0xbd, 0xc0, 0xa1, 0x2f, 0xa4, 0x64, 0x97, 0xf0, 0xf2, 0x80, 0xbc, 0x90, 0x1d,
	0xdd, 0x16, 0x46, 0xb4, 0x0f, 0xff, 0xc9, 0x31, 0x76, 0x9a, 0x89, 0xf4, 0xd3, 0xcb, 0x32, 0x0f,
	0xfd, 0x98, 0x3c, 0x12, 0xb9, 0xbe, 0x98, 0xb9, 0x3e, 0x54, 0x9e, 0x72, 0x01, 0x8d, 0xe0, 0xe2,
	0x51, 0x28, 0x8b, 0x09, 0x69, 0x0f, 0x6c, 0x2a, 0x15, 0xbf, 0xd8, 0xba, 0xfb, 0x66, 0x6c, 0xdc,
	0x39, 0x95, 0x18, 0x48, 0xe0, 0xae, 0x42, 0xc1, 0xe7, 0xa3, 0x7c, 0xbc, 0xd4, 0x8c, 0x42, 0xb8,
	0x10, 0x4f, 0x89, 0x6e, 0xd1, 0x11, 0xf1, 0xad, 0x58, 0x52, 0x5d, 0xca, 0x62, 0x65, 0x7d, 0xe3,
	0x5f, 0xa8, 0x44, 0x4a, 0xae, 0xf8, 0xb8, 0xfb, 0xba, 0x03, 0x95, 0xe7, 0x62, 0x92, 0xac, 0x9e,
	0x18, 0x25, 0x29, 0xa8, 0x27, 0x7f, 0x24, 0x64, 0xb3, 0x87, 0xe1, 0x79, 0x36, 0x87, 0x8f, 0xa0,
	0xea, 0x27, 0x13, 0x63, 0x85, 0x91, 0x50, 0x74, 0x29, 0x9c, 0x27, 0xdf, 0xf1, 0xf9, 0x41, 0xc5,
	0x4b, 0x7e, 0xee, 0xad, 0x53, 0xd2, 0x8a, 0xf5, 0x52, 0xa7, 0xa4, 0x15, 0xea, 0xf3, 0xc9, 0xf0,
	0x7f, 0xbf, 0xd7, 0xba, 0xfe, 0xea, 0xd7, 0x95, 0xb9, 0x57, 0x93, 0x95, 0xc2, 0xeb, 0xc9, 0x4a,
	0xe1, 0xa7, 0xc9, 0x4a, 0xe1, 0x97, 0xc9, 0x4a, 0xe1, 0xab, 0xdf, 0x56, 0xe6, 0x3e, 0xab, 0xe4,
	0x50, 0x7b, 0x0b, 0xf2, 0x3f, 0x86, 0x8d, 0xbf, 0x02, 0x00, 0x00, 0xff, 0xff, 0x15, 0xf7, 0xe2,
	0xf1, 0x3f, 0x0d, 0x00, 0x00,
}
