- Feature Name:
- Status: draft/in-progress/completed/rejected/obsolete/postponed
- Start Date: YYYY-MM-DD
- Authors:
- RFC PR: (PR # after acceptance of initial draft)
- Cockroach Issue: (one or more # from the issue tracker)

**Remember, you can submit a PR with your RFC before the text is
complete. Refer to the [README](README.md#rfc-process) for details.**

# Summary

One paragraph explanation of the proposed change.

Suggested contents:
- What is being proposed
- Why (short reason)
- How (short plan)
- Impact

# Motivation

Why are we doing this? What use cases does it support? What is the expected outcome?

# Guide-level explanation

How do we teach this?

Explain the proposal as if it was already included in the project and
you were teaching it to another CockroachDB programmer. That generally means:

- Introducing new named concepts.
- Explaining the feature largely in terms of examples. Take into account that a product manager (PM) will want to connect back the work introduced by the RFC with user stories. Whenever practical, do ask PMs if they already have user stories that relate to the proposed work, and do approach PMs to attract user buy-in and mindshare if applicable.
- Explaining how CockroachDB contributors and users should think about
  the feature, and how it should impact the way they use
  CockroachDB. It should explain the impact as concretely as possible.
- If applicable, provide sample error messages, deprecation warnings, or migration guidance.
- If applicable, describe the differences between teaching this to
  existing roachers and new roachers.

For implementation-oriented RFCs (e.g. for core internals), this
section should focus on how contributors should think about
the change, and give examples of its concrete impact. For policy RFCs,
this section should provide an example-driven introduction to the
policy, and explain its impact in concrete terms.

# Reference-level explanation

This is the technical portion of the RFC. Explain the design in sufficient detail that:

(You may replace the section title if the intent stays clear.)

- Its interaction with other features is clear.
- It covers where this feature may be surfaced in other areas of the product
   - If the change influences a user-facing interface, make sure to preserve consistent user experience (UX). Prefer to avoid UX changes altogether unless the RFC also argues for a clear UX benefit to users. If UX has to change, then prefer changes that match the UX for related features, to give a clear impression to users of homogeneous CLI / GUI elements. Avoid UX surprises at all costs. If in doubt, ask for input from other engineers with past UX design experience and from your design department.
- It considers how to monitor the success and quality of the feature.
   - Your RFC must consider and propose a set of metrics to be collected, if applicable, and suggest which metrics would be useful to users and which need to be exposed in a public interface.
   - Your RFC should outline how you propose to investigate when users run into related issues in production. If you propose new data structures, suggest how they should be checked for consistency. If you propose new asynchronous subsystems, suggest how a user can observe their state via tracing. In general, think about how your coworkers and users will gain access to the internals of the change after it has happened to either gain understanding during execution or troubleshoot problems.
- It is reasonably clear how the feature would be implemented.
- Corner cases are dissected by example.

The section should return to the examples given in the previous
section, and explain more fully how the detailed proposal makes those
examples work.

## Detailed design

What / how.

Outline both "how it works" and "what needs to be changed and in which order to get there."

Describe the overview of the design, and then explain each part of the
implementation in enough detail that reviewers will be able to
identify any missing pieces. Make sure to call out interactions with
other active RFCs.

## Drawbacks

Why should we *not* do this?

If applicable, list mitigating factors that may make each drawback acceptable.

Investigate the consequences of the proposed change onto other areas of CockroachDB. If other features are impacted, especially UX, list this impact as a reason not to do the change. If possible, also investigate and suggest mitigating actions that would reduce the impact. You can for example consider additional validation testing, additional documentation or doc changes, new user research, etc.

Also investigate the consequences of the proposed change on performance. Pay especially attention to the risk that introducing a possible performance improvement in one area can slow down another area in an unexpected way. Examine all the current "consumers" of the code path you are proposing to change and consider whether the performance of any of them may be negatively impacted by the proposed change. List all these consequences as possible drawbacks.

## Rationale and Alternatives

This section is extremely important. See the
[README](README.md#rfc-process) file for details.

- Why is this design the best in the space of possible designs?
- What other designs have been considered and what is the rationale for not choosing them?
- What is the impact of not doing this?

## Unresolved questions

- What parts of the design do you expect to resolve through the RFC
  process before this gets merged?
- What parts of the design do you expect to resolve through the
  implementation of this feature before stabilization?
- What related issues do you consider out of scope for this RFC that
  could be addressed in the future independently of the solution that
  comes out of this RFC?
