dnl config.m4 for extension parallel

PHP_ARG_ENABLE(parallel, whether to enable parallel support,
[  --enable-parallel          Enable parallel support], no)

PHP_ARG_ENABLE(parallel-dev, whether to enable parallel developer build flags,
[  --enable-parallel-dev      Enable parallel developer flags], no, no)

PHP_ARG_ENABLE(parallel-address-sanitizer, whether to enable address sanitizer flags for parallel,
[  --enable-parallel-address-sanitizer Enable address sanitizer flags for parallel], no, no)

PHP_ARG_ENABLE(parallel-gcov, whether to enable gcov for parallel,
[  --enable-parallel-gcov              Enable gcov for parallel], no, no)

if test "$PHP_PARALLEL" != "no"; then

  if test -z "$PHP_VERSION_ID"; then
    PHP_VERSION_ID=$($PHP_CONFIG --vernum);
  fi
  AC_MSG_CHECKING([PHP version]);
  if test $PHP_VERSION_ID -lt 80000; then
    AC_MSG_ERROR([parallel requires PHP 8.0+]);
  fi
  AC_MSG_RESULT([$PHP_VERSION_ID])

  AC_MSG_CHECKING([for ZTS])
  if test "$PHP_THREAD_SAFETY" != "no"; then
    AC_MSG_RESULT([ok])
  else
    AC_MSG_ERROR([parallel requires ZTS, please use PHP with ZTS enabled])
  fi

  AC_DEFINE(HAVE_PARALLEL, 1, [ Have parallel support ])

  AC_MSG_CHECKING([support for __atomic_add_fetch])
  AC_LINK_IFELSE([AC_LANG_PROGRAM([], [[
    int variable = 1;
    return (__atomic_add_fetch(&variable, 1, __ATOMIC_SEQ_CST)) ? 1 : 0;
  ]])], [
    AC_MSG_RESULT([yes])
    AC_DEFINE(HAVE_BUILTIN_ATOMIC_CPP11, 1, [Define to 1 if supports __atomic_add_fetch()])
  ], [
    AC_MSG_RESULT([no])
  ])

  if test "$PHP_PARALLEL_DEV" != "no"; then
    AX_CHECK_COMPILE_FLAG(-Werror,                  _MAINTAINER_CFLAGS="$_MAINTAINER_CFLAGS -Werror")
    AX_CHECK_COMPILE_FLAG(-Werror=format-security,  _MAINTAINER_CFLAGS="$_MAINTAINER_CFLAGS -Werror=format-security")
    AX_CHECK_COMPILE_FLAG(-Wno-unused-parameter,    _MAINTAINER_CFLAGS="$_MAINTAINER_CFLAGS -Wno-unused-parameter")
    AX_CHECK_COMPILE_FLAG(-fstack-protector,        _MAINTAINER_CFLAGS="$_MAINTAINER_CFLAGS -fstack-protector")
    AX_CHECK_COMPILE_FLAG(-fstack-protector-strong, _MAINTAINER_CFLAGS="$_MAINTAINER_CFLAGS -fstack-protector-strong")
  fi

  if test "$PHP_PARALLEL_ADDRESS_SANITIZER" != "no"; then
    AX_CHECK_COMPILE_FLAG(-fsanitize=address,       _MAINTAINER_CFLAGS="$_MAINTAINER_CFLAGS -fsanitize=address")
    AX_CHECK_COMPILE_FLAG(-fno-omit-frame-pointer,  _MAINTAINER_CFLAGS="$_MAINTAINER_CFLAGS -fno-omit-frame-pointer")
  fi

  if test "$PHP_PARALLEL_GCOV" != "no"; then
    AX_CHECK_COMPILE_FLAG(-fprofile-arcs,           EXTRA_CFLAGS="$EXTRA_CFLAGS -fprofile-arcs")
    AX_CHECK_COMPILE_FLAG(-ftest-coverage,          EXTRA_CFLAGS="$EXTRA_CFLAGS -ftest-coverage")
  fi

  PHP_NEW_EXTENSION(parallel, php_parallel.c src/exceptions.c src/monitor.c src/parallel.c src/runtime.c src/scheduler.c src/future.c src/copy.c src/check.c src/dependencies.c src/cache.c src/channel.c src/link.c src/handlers.c src/events.c src/poll.c src/loop.c src/event.c src/input.c src/sync.c, $ext_shared,, "-Wall -DZEND_ENABLE_STATIC_TSRMLS_CACHE=1 $_MAINTAINER_CFLAGS")

  PHP_ADD_BUILD_DIR($ext_builddir/src, 1)
  PHP_ADD_INCLUDE($ext_srcdir)

  if test "$PHP_PARALLEL_GCOV" != "no"; then
    PHP_SUBST(EXTRA_CFLAGS)
  fi
fi
