/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_JSDL
#define GUARD_JSDL

#include <SDL.h>
#include <SDL_mixer.h>

#include <string>
#include <fstream>

using std::string;

class JamesSDL {
public:
	JamesSDL(): screen(0), loadingSurface(0), theMusic(0) {}

	void Init();
	void ResetVideo();

	void BitmapHDtoFile(const string& filename);
	void BitmapColorConvert(Uint16 newColor);
	void FlipHorizontal();
	void BitmapCloseFile();

	SDL_Surface* BitmapFiletoSurface(int x, int y, int w, int h, Uint16 transparency = 0);
	SDL_Surface* BitmapHDtoSurface(const string& filename, int x, int y, int w, int h, Uint16 transparency = 0);

	//not references because SDL_FillRect clips the actual destRect you send it
	void BltFill(SDL_Rect destRect, Uint16 fillColor);
	void Blt(SDL_Surface* src, SDL_Rect destRect);
	void BltPart(SDL_Surface* src, SDL_Rect& srcRect, SDL_Rect destRect);

	bool DrawCircle(Sint16 x, Sint16 y, Sint16 r, Uint32 color);

	void Flip();
	void ForceFlip();
	void LockBack();
	void UnlockBack();

	Uint16 MapRGB(int r, int g, int b);
	void UshortToRGB(Uint16 theColor, Uint8& giveR, Uint8& giveG, Uint8& giveB);

	void Shutdown();

	//Music:

	//also frees any old music playing
	void LoadMusic(const string& filename);
	void PlayMusic();
	void StopMusic();

	SDL_Surface* screen;
	Uint8* keyboard;
	string musicName;

private:
	SDL_Surface* loadingSurface;
	Mix_Music* theMusic;
};

#endif

