/*
  File: menu.h

  Copyright (C) 2007
  Marcin 'Morgoth' Kurek <morgoth6@box43.pl>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef MENU_H
#define MENU_H

#ifndef LIST_H
#include "list.h"
#endif /* LIST_H */

/*
 * Sections
 */

enum
{
	/* Standard */
	SECTION_IGNORE = 0,
	SECTION_UNKNOWN = 1,

	/* ... */
	SECTION_VERSION,
	SECTION_SETTINGS,
	SECTION_TITLE,
	SECTION_SECTION,

};

static const char *Sections[] = {
	/* Standard */
	0,
	0,

	/* ... */
	"[VERSION]",
	"[SETTINGS]",
	"[TITLE]",
	"[SECTION]",
};

static const int BSections[] = {
	/* Standard */
	0,
	0,

	/* ... */
	1 << 2,
	1 << 3,
	1 << 4,
	1 << 5,
};

/*
 * MenuDescriptorNode
 */

struct MenuDescriptorNode
{
	char line[256];				// Should be enough
	int id;
};

/*
 * Menu Node
 */

struct MenuNode
{
	/* Node */
	struct Node node;

	/* Data */
	char title[FILE_BUF_SIZE];
	char command[FILE_BUF_SIZE];
};

/*
 * BootMenu
 */

struct BootMenu
{
	/* Settings */
	int version;
	int timeout;
	int abortok;
	int def;
	int rem_v2;

	/* ... */
	char title[FILE_BUF_SIZE];
	struct List list;

	/* Counter */
	int nodes;
};

/*
 * ID's
 */

enum
{
	/* Standard */
	ID_END = 0,
	ID_ORDINARY = 1,

	/* ... */
	ID_ID,
	ID_BOOTNUM,
	ID_BOOTDEF,
	ID_BOOTDELAY,
	ID_TITLEP,
	ID_TITLE,
	ID_LABELS,
	ID_COMMANDS,
	ID_ABORT,
	ID_REM_V2,
};

/*
 * Externs
 */

extern const struct MenuDescriptorNode Menu0[];
extern const struct MenuDescriptorNode Menu1[];

#endif /* MENU_H */
