/*
 * precise_trajectories.c --- make trajectories more precise
 *
 * Copyright (c) 2001, 2002 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2002-12-28 15:05:39 pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include	"precise_trajectories.h"
#include	"pcpj.h"
#include	"types.h"
#include	"explorat.h"
#include	"distance.h"

void
precise_trajectories( unsigned int	index,
		      unsigned int	move_index )
{
    piece_t*		p = &ListeSures[ index ];
    square_t		origin_square ;
    piece_type_t	piece_type ;
    distance_t		nb_spare_moves ;
    distance_t		first_distance ;

    /*
     * TODO : Pawns must be tested after promotion.
     */
    while ( index < NbSures + NbRestantes
	    && p->distance[ move_index ] <= 1 )
    {
	move_index++;
	if ( move_index == p->nbDestination )
	{
	    index++;
	    p++;
	    move_index = 0 ;
	}
    }

    if ( index == NbSures + NbRestantes )
    {
	explorationCoups( MainLimiteTrajet );
	return ;
    }

    origin_square = ( move_index == 0 )
	? p->caseInitiale : p->destination[ move_index - 1 ];
    piece_type = p->typePiece ;
    nb_spare_moves = ( p->camp == BLANC )
	? NbCoupsBlancsRestants : NbCoupsNoirsRestants ;


    if ( piece_type == PION )
    {
	if ( p->casePromotion != CASE_PAS_DE_PROMOTION )
	{
	    int i ;
	    for ( i = 0 ; i < move_index ; i++ )
	    {
		if ( p->destination[ i ] == p->casePromotion )
		{
		    piece_type = p->typePromotion ;
		    break ;
		}
	    }
	}
	if ( piece_type == PION )
	{
	    if ( p->pieceCapturee[ move_index ] != PAS_DE_CAPTURE )
	    {
		int i ;
		square_t intermediate_square = p->destination[ move_index ];
		distance_t previous = p->distance[ move_index ];

		if ( p->camp == BLANC )
		{
		    intermediate_square -= 16 ;
		}
		else
		{
		    intermediate_square += 16 ;
		}
		if ( column( origin_square ) > column( intermediate_square ) )
		{
		    intermediate_square++;
		}
		else
		{
		    intermediate_square--;
		}

		for ( i = p->nbDestination ; i > move_index ; i-- )
		{
		    p->destination[ i ]   = p->destination[ i - 1 ];
		    p->pieceCapturee[ i ] = p->pieceCapturee[ i - 1 ];
		    p->distance[ i ]      = p->distance[ i - 1 ];
		}
		p->destination[ move_index ]   = intermediate_square ;
		p->pieceCapturee[ move_index ] = PAS_DE_CAPTURE ;
		p->distance[ move_index ]--;
		p->distance[ move_index + 1 ] = 1 ;
		p->nbDestination++;

		if ( move_index + 1 == p->nbDestination )
		{
		    precise_trajectories( index + 1, 0 );
		}
		else
		{
		    precise_trajectories( index, move_index + 1 );
		}

		p->nbDestination--;
		for ( i = move_index ; i < p->nbDestination ; i++ )
		{
		    p->destination[ i ]   = p->destination[ i + 1 ];
		    p->pieceCapturee[ i ] = p->pieceCapturee[ i + 1 ];
		    p->distance[ i ]      = p->distance[ i + 1 ];
		}
		p->distance[ move_index ] = previous ;
	    }
	    else
	    {
		if ( move_index + 1 == p->nbDestination )
		{
		    precise_trajectories( index + 1, 0 );
		}
		else
		{
		    precise_trajectories( index, move_index + 1 );
		}
	    }
	    return ;
	}
    }

    for ( first_distance = 1 ;
	  first_distance < p->distance[ move_index ] ;
	  first_distance++ )
    {
	square_t	square ;
	square_t	intermediate_square = CASE_ARRIVEE_QUELCONQUE ;

	for ( square = a1 ; square <= h8 ; square++ )
	{
	    if ( square != p->destination[ move_index ]
		 && distance( piece_type, p->camp, origin_square, square )
		 == first_distance
		 && distance( piece_type,
			      p->camp,
			      square,
			      p->destination[ move_index ] ) + first_distance
		 <= p->distance[ move_index ] + nb_spare_moves )
	    {
		if ( intermediate_square == CASE_ARRIVEE_QUELCONQUE )
		{
		    intermediate_square = square ;
		}
		else
		{
		    intermediate_square = CASE_ARRIVEE_QUELCONQUE ;
		    break ;
		}
	    }
	}

	if ( intermediate_square != CASE_ARRIVEE_QUELCONQUE )
	{
	    unsigned int	i ;

	    p->distance[ move_index ] -= first_distance ;
	    for ( i = p->nbDestination ; i > move_index ; i-- )
	    {
		p->destination[ i ]   = p->destination[ i - 1 ];
		p->pieceCapturee[ i ] = p->pieceCapturee[ i - 1 ];
		p->distance[ i ]      = p->distance[ i - 1 ];
	    }
	    p->destination[ move_index ]   = intermediate_square ;
	    p->pieceCapturee[ move_index ] = PAS_DE_CAPTURE ;
	    p->distance[ move_index ] 	   = first_distance ;
	    p->nbDestination++;

	    if ( move_index + 1 == p->nbDestination )
	    {
		precise_trajectories( index + 1, 0 );
	    }
	    else
	    {
		precise_trajectories( index, move_index + 1 );
	    }

	    p->nbDestination--;
	    for ( i = move_index ; i < p->nbDestination ; i++ )
	    {
		p->destination[ i ]   = p->destination[ i + 1 ];
		p->pieceCapturee[ i ] = p->pieceCapturee[ i + 1 ];
		p->distance[ i ]      = p->distance[ i + 1 ];
	    }
	    p->distance[ move_index ] += first_distance ;

	    break ;
	}
    }

    if ( first_distance == p->distance[ move_index ] )
    {
	if ( move_index + 1 == p->nbDestination )
	{
	    precise_trajectories( index + 1, 0 );
	}
	else
	{
	    precise_trajectories( index, move_index + 1 );
	}
    }
}

