/*
 * expltype.h --- Data structure for move exploration.
 *
 * Copyright (c) 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2001-04-16 18:22:15 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef	EXPLTYPE_H
#define	EXPLTYPE_H

#include	"types.h"

typedef struct
{
    square_t		board[ 8 * 16 ];
    square_t		pieces_squares[ NOMBRE_MAXIMUM_DE_PIECES ];
    piece_type_t	pieces_types  [ NOMBRE_MAXIMUM_DE_PIECES ];

    piece_t		pieces[ NOMBRE_MAXIMUM_DE_PIECES ];

    unsigned int	nb_moving_pieces ;

    unsigned int	white_moves ;
    unsigned int	black_moves ;

    unsigned int	white_spare_moves ;
    unsigned int	black_spare_moves ;

    unsigned int	white_pieces_to_capture ;
    unsigned int	black_pieces_to_capture ;

    /* Destination squares of bloquing pieces */
    square_t		squares[ 4 ];

    /* Index in `pieces' of bloquing pieces */
    piece_index_t	index  [ 4 ];

    /* Indicates what pieces are bloquing in the tables : one bit per piece, the
     * bit corresponding to the index : if piece at squares[ 0 ] is bloquing,
     * bit 0 is set, etc...  The table then gives the index in `distances' of
     * the table to use.
     */
    unsigned int	current_square_flags ;
    unsigned int	square_flags[ 16 ];

    /* For each configuration of the 4 bloquing pieces, we have one distance
     * table.
     */
    distance_tables_t	distances[ 16 ];

    /* What distance tables are used */
    unsigned int	stack_indexes[ 5 ];
    unsigned int	current_stack_index ;

    /* Limit in single moves for the -k option */
    unsigned int	number_of_moves_limit ;

} exploration_t ;

#ifndef EXTERN_EXPLORATION
#define EXTERN_EXPLORATION extern
#endif

EXTERN_EXPLORATION	piece_t*	White_king ;
EXTERN_EXPLORATION	piece_t*	Black_king ;

#endif /* EXPLTYPE_H */
