/*
 * distance.h --- distance package.
 *
 * Copyright (c) 1997, 98, 99, 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2002-12-13 18:06:44 pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef	DISTANCE_H
#define	DISTANCE_H

#include	"types.h"
#include	"dis_type.h"

extern	distance_t*		Tableau_Distance_Actuel;

/*--------------------------------------------------------------------------*/

#define distance_table( tableau, type_piece, camp, caseDep, caseArr)	\
	( tableau[ type_piece * SIZE_PIECE +				\
		 ( camp == BLANC ? 0 : SIZE_PIECE / 2) +		\
		 ( ( row( caseDep ) >> 1 ) + column( caseDep ) ) *	\
		 SIZE_ECHIQUIER + caseArr ] )

#define distance(type_piece, camp, caseDep, caseArr)			\
	distance_table( Tableau_Distance_Actuel, type_piece, camp, caseDep, caseArr )

/*distance_t	distance(piece_type_t piece, colour_t camp, square_t caseDep, square_t caseArr);*/
distance_t	distancePion(colour_t camp, square_t caseDep, square_t caseArr);
void		distCreeTabPionRoiCavalier(distance_t* distance_table);
void		distCreeTabPiece(distance_t* distance_table);
void		distance_create_table(distance_t* distance_table);

void		distance_create_table_for_squares(
    distance_t*		distance_table,
    square_t*		king_squares,
    unsigned int	nb_king_squares,
    square_t*		pawn_squares,
    unsigned int	nb_pawn_squares,
    square_t*		queen_squares,
    unsigned int	nb_queen_squares,
    square_t*		rook_squares,
    unsigned int	nb_rook_squares,
    square_t*		bishop_squares,
    unsigned int	nb_bishop_squares,
    square_t*		knight_squares,
    unsigned int	nb_knight_squares );

void		distance_push(distance_t* distance_table);
void		distance_pop();
distance_t	distance_delta(piece_type_t type_piece,
			       colour_t     camp,
			       square_t     case_depart,
			       square_t     case_arrivee);

#endif /* DISTANCE_H */
