#include "bool.h"
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#include <stdio.h>
#include "util.h"
#include "socket.h"
#include "main.h"

int sok_send(int sok, struct timeval *tv, const void *msg, size_t msglen)
{
	fd_set sokset;
	struct timeval tvbak;
	ssize_t ret;
	ssize_t pos = 0;
	ssize_t left = (ssize_t)msglen;

	if (tv)
		memcpy(&tvbak, tv, sizeof(struct timeval));
	while (left > 0) {
		do {
			/* char * == 1 byte */
			ret = write(sok, (char *)msg+pos, left);
		} while (ret==-1 && errno==EINTR);
		if (ret==-1) {
			if (errno!=EAGAIN)
				return SOK_FAILED;
			do {
				if (tv)
					memcpy(tv, &tvbak, 
							sizeof(struct timeval));
				FD_ZERO(&sokset);
				FD_SET(sok, &sokset);
				ret = select(sok+1, NULL, &sokset, NULL, tv);
			} while (ret==-1 && errno==EINTR);
			switch(ret) {
			case -1: return SOK_FAILED;
			case 0: return SOK_TIMEOUT;
			default: break;
			}
		} else
			left -= ret;
			pos += ret;
	}
	return SOK_SUCCESS;
}

int sok_recv(int sok, struct timeval *tv, void *msg, size_t bufsize)
{
	fd_set sokset;
	struct timeval tvbak;
	ssize_t ret;
	ssize_t pos = 0;
	ssize_t left = (ssize_t)bufsize;

	if (tv)
		memcpy(&tvbak, tv, sizeof(struct timeval));
	while (left > 0) {
		do {
			/* char * == 1 byte */
			ret = read(sok, (char *)msg+pos, left);
		} while (ret==-1 && errno==EINTR);
		if (ret==-1) {
			if (errno!=EAGAIN)
				return SOK_FAILED;
			do {
				if (tv)
					memcpy(tv, &tvbak, 
							sizeof(struct timeval));
				FD_ZERO(&sokset);
				FD_SET(sok, &sokset);
				ret = select(sok+1, &sokset, NULL, NULL, tv);
			} while (ret==-1 && errno==EINTR);
			switch(ret) {
		   	case -1: return SOK_FAILED;
			case 0: return SOK_TIMEOUT;
			default: break;
			}
		} else if (ret==0) {
			return SOK_FAILED; /* EOF */
		} else  {
			left -= ret;
			pos += ret;
		}
	}
	return SOK_SUCCESS;
}

char *makepeername_alloc(int sok)
{
	char *name;
	struct sockaddr_in peerstruct;
	int peerlen = sizeof(struct sockaddr_in);

	memset(peerstruct.sin_zero, 0, sizeof(peerstruct.sin_zero));
	if (-1==getpeername(sok, (struct sockaddr *)&peerstruct, &peerlen)) {
		notice_err("getpeername failed");
		return NULL;
	}
	if (alloc_copy(&name, inet_ntoa(peerstruct.sin_addr))) {
		notice("getting peername failed\n");
		name = NULL;
	}
	return name;
}
