#include "bool.h"
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
/* these must not include <unistd.h> */
#include "util.h"
#include "auth.h"
#include "main.h"

/* crypt */
#ifndef __USE_XOPEN
# define __USE_XOPEN
#endif
#ifndef _XOPEN_SOURCE
# define _XOPEN_SOURCE
#endif
#include <unistd.h>

bool invalid_username(mmap_area user);
bool findchrline(const char *s, char *good, char *bad, size_t *len, size_t n);

bool auth_getaccount(const char *user, mmap_area authfile, struct account *ac)
{
	do {
		authfile = auth_getline(ac, authfile);
		if (!authfile.data)
			return TRUE; /* account not found */
	} while (ac->user.len!=strlen(user) ||
			0!=strncmp(user, ac->user.data, ac->user.len));
	return FALSE;
}

mmap_area auth_getline(struct account *ac, mmap_area start)
{
	mmap_area curr;

	curr.data = start.data;
	curr.len = start.len;

	/* user */
	ac->user.data = curr.data;
	if (findchrline(curr.data, ":!", "\n", &ac->user.len, curr.len)) {
		curr.len = 0; /* end of authfile flag */
		curr.data = NULL;
		return curr;
	}
	curr.data = ac->user.data + ac->user.len;
	curr.len -= ac->user.len;

	/* lock */
	ac->lock = curr.data;
	curr.data = ac->lock + 1;
	curr.len -= 1;

	/* pass */
	ac->crypass.data = curr.data;
	if (findchrline(curr.data, "\n", "", &ac->crypass.len, curr.len)) {
		notice("end of authfile is missing a newline\n");
		curr.len = 1; /* error flag */
		curr.data = NULL;
		return curr;
	}
	curr.data = ac->crypass.data + ac->crypass.len;
	curr.len -= ac->crypass.len;

	/* newline */
	curr.data += 1;
	curr.len -= 1;
	
	return curr;
}

bool auth_checkpass(const char *plainpw, mmap_area crypass)
{
	char *test;
	char salt[3];
	if (crypass.len < 2)
		return TRUE; /* e.g. "user:*" */
	if (crypass.data[0]=='$') {
		/* MD5 or Blowfish */
		test = (char *)crypt(plainpw, crypass.data);
	} else {
		/* DES */
		strncpy(salt, crypass.data, 2); salt[2] = '\0';
		test = (char *)crypt(plainpw, salt);
	}
	if (0!=strncmp(test, crypass.data, crypass.len))
		return TRUE;
	return FALSE;
}

bool invalid_authfile(mmap_area authfile)
{
	struct account ac;
	authfile = auth_getline(&ac, authfile);
	while (authfile.data) {
		if (invalid_username(ac.user)) {
			notice("username '%.*s' in authfile is invalid\n",
					(int)ac.user.len, ac.user.data);
			return TRUE;
		}
		authfile = auth_getline(&ac, authfile);
	}
	if (authfile.len!=0) {
		notice("newline missing from end of authfile\n");
		return TRUE;
	}
	return FALSE;
}

#if 1
/* Backwards compatibility. Using the old style "%username"
 * (e.g. "%tim" or "%%all"). */
bool was_a_username(char *username)
{
	/* old-style always started with % */
	if (username[0]!='%') 
		return FALSE;
	if (username[1]=='%')
		return TRUE; /* old-style meta-user */
	/* Either a new-style meta-user or we're using old-style with a user
	 * called "con", "all" or "unknown". We can't do anything to handle
	 * the second case. */
	if (0==strcmp("%con", username) ||
			0==strcmp("%all", username) ||
			0==strcmp("%unknown", username)) {
		return FALSE;
	}
	return TRUE;
}
#endif

bool is_a_username(char firstchar)
{
	const char VALID_FIRST[] =	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
					"abcdefghijklmnopqrstuvwxyz"
					"%";
	if(strchr(VALID_FIRST, firstchar))
		return TRUE;
	return FALSE;
}
	
bool invalid_username(mmap_area user)
{
	size_t i;
	const char VALID[] =		"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
					"abcdefghijklmnopqrstuvwxyz"
					"0123456789"
					"_-";
	if (user.len==0)
		return TRUE;
	if (!is_a_username(user.data[0]))
		return TRUE;
	for (i=1; i < user.len; ++i) {
		if (!strchr(VALID, user.data[i]))
			return TRUE;
	}
	return FALSE;
}

/* Set /len/ to the number of characters in /s/ before any of /good/ are
 * found.
 * 
 * The search stops and returns TRUE (leaving len unchanged) if
 * 	1) We hit any of the chars in /bad/.
 * 	2) We have searched through /n/ characters.
 * 	3) We hit \0.
 *
 * The search stops, returns FALSE and sets /len/ to the number of characters
 * we've searched through if
 * 	1) We reach any of the chars in /good/.
 */
bool findchrline(const char *s, char *good, char *bad, size_t *len, size_t n)
{
	const char *pt;
	char *tmp;
	for (pt=s; *pt && n; ++pt, --n) {
		for (tmp=bad; *tmp; ++tmp) {
			if (*pt==*tmp)
				return TRUE;
		}
		for (tmp=good; *tmp; ++tmp) {
			if (*pt==*tmp) {
				*len = pt-s;
				return FALSE;
			}
		}
	}
	return TRUE;
}
