" Vim syntax file 
" Language:     Dwun config file
" Maintainer:   Tim Sutherland <timsuth@ihug.co.nz>
" Last change:  15/Oct/2000
" Version Info: 0.12

" clear any unwanted syntax defs
syn clear

syn case ignore
syn keyword dwunrcStatement	 port bind maxcon redials keepalive onconnect
syn keyword dwunrcStatement	 ondisconnect hostmask authfile command_logfile
syn keyword dwunrcStatement	 logfile pidfile commandon commandoff external
syn keyword dwunrcStatement	 pre_commandon post_commandon disconnect_wait
syn keyword dwunrcBoolean	 debug staydropped

syn match dwunrcComment		"^#.*$"
syn region dwunrcArg		start=+ + end="$" oneline
" all dwunrc numbers are integers
syn match dwunrcNum		" [0-9]*$"

if !exists("did_dwun_syntax_inits")
        let did_dwun_syntax_inits = 1
        " The default methods for highlighting.  Can be overridden later
        hi link dwunrcStatement	Keyword
        hi link dwunrcComment	Comment
	hi link dwunrcArg	String
	hi link dwunrcNum	Number
	hi link dwunrcBoolean   Boolean
endif

let b:current_syntax = "dwun"

" vim:ts=8
