/*  $Id: Controller.h,v 1.17 2024/04/08 03:43:44 sarrazip Exp $
    Controller.h - Source of commands from the user.

    afternoonstalker - A robot-killing video game.
    Copyright (C) 2001-2012 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA  02110-1301, USA.
*/

#ifndef _H_Controller
#define _H_Controller

#include <flatzebra/KeyState.h>
#include <flatzebra/Joystick.h>


class Controller
{
public:

    Controller();

    ~Controller();

    void processKey(SDL_Keycode keysym, bool pressed);

    bool isMenuRequested() const
    {
        return menuKS.isPressed() || pauseKS.isPressed() || joystick.buttonJustPressed(pauseBI);
    }

    bool isRightRequested() const
    {
        return rightKS.isPressed() || joystick.getXAxisDisplacement() > 0;
    }

    bool isLeftRequested() const
    {
        return leftKS.isPressed() || joystick.getXAxisDisplacement() < 0;
    }

    bool isUpRequested() const
    {
        return upKS.isPressed() || joystick.getYAxisDisplacement() < 0;
    }

    bool isDownRequested() const
    {
        return downKS.isPressed() || joystick.getYAxisDisplacement() > 0;
    }

    bool isShootRequested() const
    {
        return shootKS.justPressed();
    }

    bool isShootRightRequested() const
    {
        return shootRightKS.justPressed() || joystick.buttonJustPressed(shootRightBI);
    }

    bool isShootLeftRequested() const
    {
        return shootLeftKS.justPressed() || joystick.buttonJustPressed(shootLeftBI);
    }

    bool isShootUpRequested() const
    {
        return shootUpKS.justPressed() || joystick.buttonJustPressed(shootUpBI);
    }

    bool isShootDownRequested() const
    {
        return shootDownKS.justPressed() || joystick.buttonJustPressed(shootDownBI);
    }

    bool isNextMenuEntryRequested() const
    {
        return rightKS.justPressed();
    }

    bool isPrevMenuEntryRequested() const
    {
        return leftKS.justPressed();
    }

    bool isMenuSelectionRequested() const
    {
        return selectKS.justPressed() || joystick.buttonJustPressed(startBI);
    }

    bool isMenuReturnRequested() const
    {
        return menuKS.justPressed();
    }

    bool isFullScreenToggleRequested() const
    {
        return fullScreenKS.justPressed();
    }

    void update();

private:

    flatzebra::KeyState menuKS;
    flatzebra::KeyState leftKS;
    flatzebra::KeyState rightKS;
    flatzebra::KeyState upKS;
    flatzebra::KeyState downKS;
    flatzebra::KeyState selectKS;
    flatzebra::KeyState shootKS;
    flatzebra::KeyState pauseKS;
    flatzebra::KeyState shootLeftKS;
    flatzebra::KeyState shootRightKS;
    flatzebra::KeyState shootUpKS;
    flatzebra::KeyState shootDownKS;
    flatzebra::KeyState fullScreenKS;
    flatzebra::Joystick joystick;

    // Joystick button indexes:
    int shootLeftBI;
    int shootRightBI;
    int shootUpBI;
    int shootDownBI;
    int startBI;
    int pauseBI;
};


#endif  /* _H_Controller */
