/* ex: set ro ft=c: -*- buffer-read-only:t -*-
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically from 'compilers/imcc/imcc.y'
 * by tools/build/fixup_gen_file.pl.
 *
 * Any changes made here will be lost!
 *
 */
/* HEADERIZER HFILE: none */
/* HEADERIZER STOP */
/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "compilers/imcc/imcc.y" /* yacc.c:339  */

/*
 * imcc.y
 *
 * Intermediate Code Compiler for Parrot.
 *
 * Copyright (C) 2002 Melvin Smith <melvin.smith@mindspring.com>
 * Copyright (C) 2002-2014, Parrot Foundation.
 *
 * Grammar of the PIR language parser.
 *
 *
 */

/*

=pod

=head1 NAME

compilers/imcc/imcc.y - Intermediate Code Compiler for Parrot.

=head1 DESCRIPTION

This file contains the grammar of the PIR language parser.

=cut

*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define _PARSER
#define PARSER_MAIN
#include "imc.h"
#include "parrot/dynext.h"
#include "pmc/pmc_callcontext.h"
#include "pbc.h"
#include "parser.h"
#include "optimizer.h"
#include "instructions.h"
#include "symreg.h"

/* prevent declarations of malloc() and free() in the generated parser. */
#define YYMALLOC
#define YYFREE(Ptr) do { /* empty */; } while (0)

#ifndef YYENABLE_NLS
#  define YYENABLE_NLS 0
#endif

#ifndef YYLTYPE_IS_TRIVIAL
#  define YYLTYPE_IS_TRIVIAL 0
#endif

/* HEADERIZER HFILE: compilers/imcc/imc.h */

/* HEADERIZER BEGIN: static */
/* Don't modify between HEADERIZER BEGIN / HEADERIZER END.  Your changes will be lost. */

static void add_pcc_named_arg(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void add_pcc_named_arg_var(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void add_pcc_named_param(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void add_pcc_named_result(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void add_pcc_named_return(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void adv_named_set(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

static void adv_named_set_u(
    ARGMOD(imc_info_t *imcc),
    ARGIN(const char *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

static void begin_return_or_yield(ARGMOD(imc_info_t *imcc), int yield)
        __attribute__nonnull__(1)
        FUNC_MODIFIES(*imcc);

static void clear_state(ARGMOD(imc_info_t *imcc))
        __attribute__nonnull__(1)
        FUNC_MODIFIES(*imcc);

static void do_loadlib(ARGMOD(imc_info_t *imcc), ARGIN(const char *lib))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction* func_ins(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(SymReg *lhs),
    ARGIN(const char *op),
    ARGMOD(SymReg **r),
    int n,
    int keyv,
    int emit)
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        __attribute__nonnull__(5)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit)
        FUNC_MODIFIES(*r);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction * iINDEXFETCH(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(SymReg *r0),
    ARGIN(SymReg *r1),
    ARGIN(SymReg *r2))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        __attribute__nonnull__(5)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction * iINDEXSET(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(SymReg *r0),
    ARGIN(SymReg *r1),
    ARGIN(SymReg *r2))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        __attribute__nonnull__(5)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit);

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static Instruction * iLABEL(
    ARGMOD(imc_info_t *imcc),
    ARGMOD_NULLOK(IMC_Unit *unit),
    ARGMOD(SymReg *r0))
        __attribute__nonnull__(1)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit)
        FUNC_MODIFIES(*r0);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static const char * inv_op(ARGIN(const char *op))
        __attribute__nonnull__(1);

PARROT_IGNORABLE_RESULT
PARROT_CANNOT_RETURN_NULL
static Instruction * iSUBROUTINE(
    ARGMOD(imc_info_t *imcc),
    ARGMOD_NULLOK(IMC_Unit *unit),
    ARGMOD(SymReg *r))
        __attribute__nonnull__(1)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit)
        FUNC_MODIFIES(*r);

PARROT_IGNORABLE_RESULT
PARROT_CAN_RETURN_NULL
static Instruction * MK_I(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(const char *fmt),
    int n,
    ...)
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction* mk_pmc_const_named(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(const char *name),
    ARGMOD(SymReg *left),
    ARGIN(const char *constant))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        __attribute__nonnull__(5)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit)
        FUNC_MODIFIES(*left);

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static SymReg * mk_sub_address_fromc(
    ARGMOD(imc_info_t *imcc),
    ARGIN(const char *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static SymReg * mk_sub_address_u(
    ARGMOD(imc_info_t *imcc),
    ARGIN(const char *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

static void set_lexical(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *r),
    ARGMOD(SymReg *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*r)
        FUNC_MODIFIES(*name);

#define ASSERT_ARGS_add_pcc_named_arg __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_add_pcc_named_arg_var __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_add_pcc_named_param __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_add_pcc_named_result __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_add_pcc_named_return __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_adv_named_set __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(name))
#define ASSERT_ARGS_adv_named_set_u __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(name))
#define ASSERT_ARGS_begin_return_or_yield __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc))
#define ASSERT_ARGS_clear_state __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc))
#define ASSERT_ARGS_do_loadlib __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(lib))
#define ASSERT_ARGS_func_ins __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(lhs) \
    , PARROT_ASSERT_ARG(op) \
    , PARROT_ASSERT_ARG(r))
#define ASSERT_ARGS_iINDEXFETCH __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(r0) \
    , PARROT_ASSERT_ARG(r1) \
    , PARROT_ASSERT_ARG(r2))
#define ASSERT_ARGS_iINDEXSET __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(r0) \
    , PARROT_ASSERT_ARG(r1) \
    , PARROT_ASSERT_ARG(r2))
#define ASSERT_ARGS_iLABEL __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(r0))
#define ASSERT_ARGS_inv_op __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(op))
#define ASSERT_ARGS_iSUBROUTINE __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(r))
#define ASSERT_ARGS_MK_I __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(fmt))
#define ASSERT_ARGS_mk_pmc_const_named __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(left) \
    , PARROT_ASSERT_ARG(constant))
#define ASSERT_ARGS_mk_sub_address_fromc __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(name))
#define ASSERT_ARGS_mk_sub_address_u __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(name))
#define ASSERT_ARGS_set_lexical __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(r) \
    , PARROT_ASSERT_ARG(name))
/* Don't modify between HEADERIZER BEGIN / HEADERIZER END.  Your changes will be lost. */
/* HEADERIZER END: static */

#undef YYDEBUG
#define YYDEBUG 1
#define YYERROR_VERBOSE 1

/* Warning: parser is probably not reentrant */

/*
 * Choosing instructions for Parrot is pretty easy since many are
 * polymorphic.
 */


/*

=over 4

=item C<static Instruction * MK_I(imc_info_t *imcc, IMC_Unit *unit, const char
*fmt, int n, ...)>

build and emitb instruction by INS. fmt may contain:

  op %s, %s # comment

or just

  op

NOTE: Most usage of this function is with
imcc->cur_unit, but there are some
exceptions. Thus, we can't easily factorize that piece of
code.

=cut

 */

PARROT_IGNORABLE_RESULT
PARROT_CAN_RETURN_NULL
static Instruction *
MK_I(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit), ARGIN(const char *fmt), int n, ...)
{
    ASSERT_ARGS(MK_I)
    char opname[64];
    char *p;
    const char *q;
    va_list ap;
    SymReg *r[IMCC_MAX_FIX_REGS];
    int i;

    for (p = opname, q = fmt; *q && *q != ' ';)
        *p++ = *q++;
    *p = '\0';
    if (!*q)
        fmt = NULL;
    else
        fmt = ++q;
#ifdef OPDEBUG
    fprintf(stderr, "op '%s' format '%s' (%d)\n", opname, fmt?:"", n);
#endif
    va_start(ap, n);
    i = 0;
    for (i = 0; i < n; ++i) {
        r[i] = va_arg(ap, SymReg *);
    }
    va_end(ap);
    return INS(imcc, unit, opname, fmt, r, n, imcc->keyvec, 1);
}

/*

=item C<static Instruction* mk_pmc_const_named(imc_info_t *imcc, IMC_Unit *unit,
const char *name, SymReg *left, const char *constant)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction*
mk_pmc_const_named(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit),
    ARGIN(const char *name), ARGMOD(SymReg *left), ARGIN(const char *constant))
{
    ASSERT_ARGS(mk_pmc_const_named)
    SymReg *rhs;
    SymReg *r[3];
    char   *const_name;
    const int ascii       = (*constant == '\'' || *constant == '"');
    char   *unquoted_name = mem_sys_strdup(name + 1);
    size_t  name_length   = strlen(unquoted_name) - 1;

    unquoted_name[name_length] = 0;

    if (left->type == VTADDRESS) {      /* IDENTIFIER */
        if (imcc->state->pasm_file) {
            IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                        "Ident as PMC constant",
                        " %s\n", left->name);
        }
        left->type = VTIDENTIFIER;
        left->set = 'P';
    }
    r[0] = left;
    if (ascii) {
        /* strip delimiters */
        const_name = mem_sys_strdup(constant + 1);
        const_name[strlen(const_name) - 1] = 0;
    }
    else {
        const_name = mem_sys_strdup(constant);
    }

    /* With an empty name here, like .const '' $Pxx = "constant"
       can only be a Sub. name_length = 0 matches all */
    if ((strncmp(unquoted_name, "Sub",       name_length) == 0)
    ||  (strncmp(unquoted_name, "Coroutine", name_length) == 0)) {
        rhs = mk_const(imcc, const_name, 'p');
        if (!ascii)
            rhs->type |= VT_ENCODED;
        rhs->usage    |= U_FIXUP | U_SUBID_LOOKUP;
    }
    else if (strncmp(unquoted_name, "LexInfo", name_length) == 0) {
        rhs = mk_const(imcc, const_name, 'l');
        if (!ascii)
            rhs->type |= VT_ENCODED;
        rhs->usage    |= U_FIXUP | U_LEXINFO_LOOKUP;
    }
    else {
        rhs = mk_const(imcc, const_name, 'P');
    }

    r[1]          = rhs;
    rhs->pmc_type = Parrot_pmc_get_type_str(imcc->interp,
        Parrot_str_new(imcc->interp, unquoted_name, name_length));

    mem_sys_free(unquoted_name);
    mem_sys_free(const_name);

    return INS(imcc, unit, "set_p_pc", "", r, 2, 0, 1);
}

/*

=item C<static Instruction* func_ins(imc_info_t *imcc, IMC_Unit *unit, SymReg
*lhs, const char *op, SymReg **r, int n, int keyv, int emit)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction*
func_ins(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit), ARGIN(SymReg *lhs),
        ARGIN(const char *op), ARGMOD(SymReg **r), int n, int keyv, int emit)
{
    ASSERT_ARGS(func_ins)
    int i;
    /* shift regs up by 1 */
    for (i = n - 1; i >= 0; --i)
        r[i+1] = r[i];
    r[0] = lhs;
    /* shift keyvec */
    keyv <<= 1;
    return INS(imcc, unit, op, "", r, n+1, keyv, emit);
}

/*

=item C<static void clear_state(imc_info_t *imcc)>

=cut

*/

static void
clear_state(ARGMOD(imc_info_t *imcc))
{
    ASSERT_ARGS(clear_state)
    imcc -> nargs = 0;
    imcc -> keyvec = 0;
}

/*

=item C<Instruction * INS_LABEL(imc_info_t *imcc, IMC_Unit *unit, SymReg *r0,
int emit)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
Instruction *
INS_LABEL(ARGMOD(imc_info_t *imcc), ARGMOD_NULLOK(IMC_Unit *unit),
        ARGMOD(SymReg *r0), int emit)
{
    ASSERT_ARGS(INS_LABEL)

    Instruction * const ins = _mk_instruction("", "%s:", 1, &r0, 0);
    ins->type               = ITLABEL;
    r0->first_ins           = ins;

    if (emit)
        emitb(imcc, unit, ins);

    return ins;
}

/*

=item C<static Instruction * iLABEL(imc_info_t *imcc, IMC_Unit *unit, SymReg
*r0)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static Instruction *
iLABEL(ARGMOD(imc_info_t *imcc), ARGMOD_NULLOK(IMC_Unit *unit),
        ARGMOD(SymReg *r0))
{
    ASSERT_ARGS(iLABEL)
    Instruction * const i = INS_LABEL(imcc, unit, r0, 1);
    i->line               = imcc->line;

    clear_state(imcc);
    return i;
}

/*

=item C<static Instruction * iSUBROUTINE(imc_info_t *imcc, IMC_Unit *unit,
SymReg *r)>

=cut

*/

PARROT_IGNORABLE_RESULT
PARROT_CANNOT_RETURN_NULL
static Instruction *
iSUBROUTINE(ARGMOD(imc_info_t *imcc), ARGMOD_NULLOK(IMC_Unit *unit), ARGMOD(SymReg *r))
{
    ASSERT_ARGS(iSUBROUTINE)
    Instruction * const i = iLABEL(imcc, unit, r);
    i->type              |= ITPCCPARAM;

    r->type    = (r->type & VT_ENCODED) ? VT_PCC_SUB|VT_ENCODED : VT_PCC_SUB;
    r->pcc_sub = mem_gc_allocate_zeroed_typed(imcc->interp, pcc_sub_t);

    imcc->cur_call = r;
    i->line = imcc->line;

    add_namespace(imcc, unit);
    return i;
}

/*

=item C<static Instruction * iINDEXFETCH(imc_info_t *imcc, IMC_Unit *unit,
SymReg *r0, SymReg *r1, SymReg *r2)>

substr or X = P[key]

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction *
iINDEXFETCH(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit), ARGIN(SymReg *r0),
        ARGIN(SymReg *r1), ARGIN(SymReg *r2))
{
    ASSERT_ARGS(iINDEXFETCH)
    imcc -> keyvec |= KEY_BIT(2);
    return MK_I(imcc, unit, "set %s, %s[%s]", 3, r0, r1, r2);
}

/*

=item C<static Instruction * iINDEXSET(imc_info_t *imcc, IMC_Unit *unit, SymReg
*r0, SymReg *r1, SymReg *r2)>

substr or P[key] = X

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction *
iINDEXSET(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit), ARGIN(SymReg *r0),
        ARGIN(SymReg *r1), ARGIN(SymReg *r2))
{
    ASSERT_ARGS(iINDEXSET)
    if (r0->set == 'P') {
        imcc->keyvec |= KEY_BIT(1);
        MK_I(imcc, unit, "set %s[%s], %s", 3, r0, r1, r2);
    }
    else
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
            "unsupported indexed set op\n");

    return NULL;
}

/*

=item C<static const char * inv_op(const char *op)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static const char *
inv_op(ARGIN(const char *op))
{
    ASSERT_ARGS(inv_op)
    int n;
    return get_neg_op(op, &n);
}

/*

=item C<Instruction * IMCC_create_itcall_label(imc_info_t *imcc)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
Instruction *
IMCC_create_itcall_label(ARGMOD(imc_info_t *imcc))
{
    ASSERT_ARGS(IMCC_create_itcall_label)
    char         name[128];
    SymReg      *r;
    Instruction *i;

    snprintf(name, sizeof (name), "%cpcc_sub_call_%d", IMCC_INTERNAL_CHAR,
        imcc->cnr++);

    r       = mk_pcc_sub(imcc, name, 0);
    i       = iLABEL(imcc, imcc->cur_unit, r);
    i->type = ITCALL | ITPCCSUB;

    imcc->cur_call = r;

    return i;
}

/*

=item C<static SymReg * mk_sub_address_fromc(imc_info_t *imcc, const char
*name)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static SymReg *
mk_sub_address_fromc(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
{
    ASSERT_ARGS(mk_sub_address_fromc)
    /* name is a quoted sub name */
    SymReg *r;
    char   *name_copy;

    /* interpolate only if the first character is a double-quote */
    if (*name == '"') {
        STRING *unescaped = Parrot_str_unescape(imcc->interp, name, '"', NULL);
        name_copy         = Parrot_str_to_cstring(imcc->interp, unescaped);
    }
    else {
        name_copy = mem_sys_strdup(name);
        name_copy[strlen(name) - 1] = 0;
    }

    r = mk_sub_address(imcc, name_copy + 1);
    mem_sys_free(name_copy);

    return r;
}

/*

=item C<static SymReg * mk_sub_address_u(imc_info_t *imcc, const char *name)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static SymReg *
mk_sub_address_u(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
{
    ASSERT_ARGS(mk_sub_address_u)
    SymReg * const r = mk_sub_address(imcc, name);
    r->type         |= VT_ENCODED;

    return r;
}

/*

=item C<void IMCC_itcall_sub(imc_info_t *imcc, SymReg *sub)>

=cut

*/

void
IMCC_itcall_sub(ARGMOD(imc_info_t *imcc), ARGIN(SymReg *sub))
{
    ASSERT_ARGS(IMCC_itcall_sub)
    imcc->cur_call->pcc_sub->sub = sub;

    if (imcc->cur_obj) {
        if (imcc->cur_obj->set != 'P')
            IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR, "object isn't a PMC");

        imcc->cur_call->pcc_sub->object = imcc->cur_obj;
        imcc->cur_obj = NULL;
    }
}


/*

=item C<static void begin_return_or_yield(imc_info_t *imcc, int yield)>

=cut

*/

static void
begin_return_or_yield(ARGMOD(imc_info_t *imcc), int yield)
{
    ASSERT_ARGS(begin_return_or_yield)
    Instruction *i;
    Instruction * const ins = imcc->cur_unit->instructions;
    char                name[128];

    if (!ins || !ins->symregs[0] || !(ins->symregs[0]->type & VT_PCC_SUB))
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                    "yield or return directive outside pcc subroutine\n");
    ins->symregs[0]->pcc_sub->yield = yield;
    snprintf(name, sizeof (name), yield ? "%cpcc_sub_yield_%d" : "%cpcc_sub_ret_%d",
            IMCC_INTERNAL_CHAR, imcc->cnr++);
    imcc->sr_return = mk_pcc_sub(imcc, name, 0);
    i = iLABEL(imcc, imcc->cur_unit, imcc->sr_return);
    i->type = yield ? ITPCCSUB | ITLABEL | ITPCCYIELD : ITPCCSUB | ITLABEL ;
    imcc->asm_state = yield ? AsmInYield : AsmInReturn;
}

/*

=item C<static void set_lexical(imc_info_t *imcc, SymReg *r, SymReg *name)>

=cut

*/

static void
set_lexical(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *r), ARGMOD(SymReg *name))
{
    ASSERT_ARGS(set_lexical)

    r->usage |= U_LEXICAL;

    IMCC_debug(imcc, DEBUG_MKCONST, "#    .lex '%s'\n", name->name);
    if (name == r->reg)
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
            "register %s already declared as lexical %s", r->name, name->name);

    /* chain all names in r->reg */
    name->reg    = r->reg;
    r->reg       = name;
    name->usage |= U_LEXICAL;
    r->use_count++;
}


/*

=item C<static void add_pcc_named_arg(imc_info_t *imcc, SymReg *cur_call, SymReg
*name, SymReg *value)>

=cut

*/

static void
add_pcc_named_arg(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_arg)
    name->type  |= VT_NAMED;

    add_pcc_arg(imcc, cur_call, name);
    add_pcc_arg(imcc, cur_call, value);
}

/*

=item C<static void add_pcc_named_arg_var(imc_info_t *imcc, SymReg *cur_call,
SymReg *name, SymReg *value)>

=cut

*/

static void
add_pcc_named_arg_var(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_arg_var)
    name->type |= VT_NAMED;
    add_pcc_arg(imcc, cur_call, name);
    add_pcc_arg(imcc, cur_call, value);
}

/*

=item C<static void add_pcc_named_result(imc_info_t *imcc, SymReg *cur_call,
SymReg *name, SymReg *value)>

=cut

*/

static void
add_pcc_named_result(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_result)
    name->type |= VT_NAMED;

    add_pcc_result(imcc, cur_call, name);
    add_pcc_result(imcc, cur_call, value);
}

/*

=item C<static void add_pcc_named_param(imc_info_t *imcc, SymReg *cur_call,
SymReg *name, SymReg *value)>

=cut

*/

static void
add_pcc_named_param(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_param)
    name->type |= VT_NAMED;

    add_pcc_arg(imcc, cur_call, name);
    add_pcc_arg(imcc, cur_call, value);
}

/*

=item C<static void add_pcc_named_return(imc_info_t *imcc, SymReg *cur_call,
SymReg *name, SymReg *value)>

=cut

*/

static void
add_pcc_named_return(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_return)
    name->type |= VT_NAMED;

    add_pcc_result(imcc, cur_call, name);
    add_pcc_result(imcc, cur_call, value);
}

/*

=item C<static void adv_named_set(imc_info_t *imcc, const char *name)>

=item C<static void adv_named_set_u(imc_info_t *imcc, const char *name)>

Sets the name of the current named argument.

C<adv_named_set_u> is the Unicode version of this function.

=cut

*/

static void
adv_named_set(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
{
    ASSERT_ARGS(adv_named_set)
    if (imcc->adv_named_id)
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                    "Named parameter with more than one name.\n");

    imcc->adv_named_id = mk_const(imcc, name, 'S');
}

static void
adv_named_set_u(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
{
    ASSERT_ARGS(adv_named_set_u)
    if (imcc->adv_named_id)
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                    "Named parameter with more than one name.\n");

    imcc->adv_named_id = mk_const(imcc, name, 'U');
}

/*

=item C<static void do_loadlib(imc_info_t *imcc, const char *lib)>

=cut

*/

static void
do_loadlib(ARGMOD(imc_info_t *imcc), ARGIN(const char *lib))
{
    ASSERT_ARGS(do_loadlib)
    STRING * const s = Parrot_str_unescape(imcc->interp, lib + 1, '"', NULL);
    PMC    * const lib_pmc = Parrot_dyn_load_lib(imcc->interp, s, NULL);
    if (PMC_IS_NULL(lib_pmc) || !VTABLE_get_bool(imcc->interp, lib_pmc)) {
        IMCC_fataly(imcc, EXCEPTION_LIBRARY_ERROR,
            "loadlib directive could not find library `%S'", s);
    }

    /* store non-dynoplib library deps here, dynoplibs are treated separately for now */
    /* TODO: This is very ugly and heavily nested. Can we avoid this? */
    if (!STRING_equal(imcc->interp,
            VTABLE_get_string(imcc->interp,
                Parrot_pmc_getprop(imcc->interp, lib_pmc,
                    Parrot_str_new_constant(imcc->interp, "_type"))),
            Parrot_str_new_constant(imcc->interp, "Ops")))
        imcc_pbc_add_libdep(imcc, s);
}

/* HEADERIZER STOP */


#line 1114 "compilers/imcc/imcparser.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "imcparser.h".  */
#ifndef YY_YY_COMPILERS_IMCC_IMCPARSER_H_INCLUDED
# define YY_YY_COMPILERS_IMCC_IMCPARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    LOW_PREC = 258,
    PARAM = 259,
    SOL = 260,
    HLL = 261,
    GOTO = 262,
    ARG = 263,
    IF = 264,
    UNLESS = 265,
    PNULL = 266,
    SET_RETURN = 267,
    SET_YIELD = 268,
    ADV_FLAT = 269,
    ADV_SLURPY = 270,
    ADV_OPTIONAL = 271,
    ADV_OPT_FLAG = 272,
    ADV_NAMED = 273,
    ADV_ARROW = 274,
    ADV_INVOCANT = 275,
    ADV_CALL_SIG = 276,
    NAMESPACE = 277,
    DOT_METHOD = 278,
    SUB = 279,
    SYM = 280,
    LOCAL = 281,
    LEXICAL = 282,
    CONST = 283,
    ANNOTATE = 284,
    GLOBAL_CONST = 285,
    PLUS_ASSIGN = 286,
    MINUS_ASSIGN = 287,
    MUL_ASSIGN = 288,
    DIV_ASSIGN = 289,
    CONCAT_ASSIGN = 290,
    BAND_ASSIGN = 291,
    BOR_ASSIGN = 292,
    BXOR_ASSIGN = 293,
    FDIV = 294,
    FDIV_ASSIGN = 295,
    MOD_ASSIGN = 296,
    SHR_ASSIGN = 297,
    SHL_ASSIGN = 298,
    SHR_U_ASSIGN = 299,
    SHIFT_LEFT = 300,
    SHIFT_RIGHT = 301,
    INTV = 302,
    FLOATV = 303,
    STRINGV = 304,
    PMCV = 305,
    LOG_XOR = 306,
    RELOP_EQ = 307,
    RELOP_NE = 308,
    RELOP_GT = 309,
    RELOP_GTE = 310,
    RELOP_LT = 311,
    RELOP_LTE = 312,
    RESULT = 313,
    RETURN = 314,
    TAILCALL = 315,
    YIELDT = 316,
    GET_RESULTS = 317,
    POW = 318,
    SHIFT_RIGHT_U = 319,
    LOG_AND = 320,
    LOG_OR = 321,
    COMMA = 322,
    ESUB = 323,
    DOTDOT = 324,
    PCC_BEGIN = 325,
    PCC_END = 326,
    PCC_CALL = 327,
    PCC_SUB = 328,
    PCC_BEGIN_RETURN = 329,
    PCC_END_RETURN = 330,
    PCC_BEGIN_YIELD = 331,
    PCC_END_YIELD = 332,
    INVOCANT = 333,
    MAIN = 334,
    LOAD = 335,
    INIT = 336,
    IMMEDIATE = 337,
    POSTCOMP = 338,
    METHOD = 339,
    ANON = 340,
    OUTER = 341,
    NEED_LEX = 342,
    MULTI = 343,
    SUBTAG = 344,
    VTABLE_METHOD = 345,
    LOADLIB = 346,
    SUB_INSTANCE_OF = 347,
    SUBID = 348,
    NS_ENTRY = 349,
    LABEL = 350,
    EMIT = 351,
    EOM = 352,
    IREG = 353,
    NREG = 354,
    SREG = 355,
    PREG = 356,
    IDENTIFIER = 357,
    REG = 358,
    MACRO = 359,
    ENDM = 360,
    STRINGC = 361,
    INTC = 362,
    FLOATC = 363,
    USTRINGC = 364,
    PARROT_OP = 365,
    VAR = 366,
    LINECOMMENT = 367,
    FILECOMMENT = 368,
    CONCAT = 369,
    DOT = 370
  };
#endif
/* Tokens.  */
#define LOW_PREC 258
#define PARAM 259
#define SOL 260
#define HLL 261
#define GOTO 262
#define ARG 263
#define IF 264
#define UNLESS 265
#define PNULL 266
#define SET_RETURN 267
#define SET_YIELD 268
#define ADV_FLAT 269
#define ADV_SLURPY 270
#define ADV_OPTIONAL 271
#define ADV_OPT_FLAG 272
#define ADV_NAMED 273
#define ADV_ARROW 274
#define ADV_INVOCANT 275
#define ADV_CALL_SIG 276
#define NAMESPACE 277
#define DOT_METHOD 278
#define SUB 279
#define SYM 280
#define LOCAL 281
#define LEXICAL 282
#define CONST 283
#define ANNOTATE 284
#define GLOBAL_CONST 285
#define PLUS_ASSIGN 286
#define MINUS_ASSIGN 287
#define MUL_ASSIGN 288
#define DIV_ASSIGN 289
#define CONCAT_ASSIGN 290
#define BAND_ASSIGN 291
#define BOR_ASSIGN 292
#define BXOR_ASSIGN 293
#define FDIV 294
#define FDIV_ASSIGN 295
#define MOD_ASSIGN 296
#define SHR_ASSIGN 297
#define SHL_ASSIGN 298
#define SHR_U_ASSIGN 299
#define SHIFT_LEFT 300
#define SHIFT_RIGHT 301
#define INTV 302
#define FLOATV 303
#define STRINGV 304
#define PMCV 305
#define LOG_XOR 306
#define RELOP_EQ 307
#define RELOP_NE 308
#define RELOP_GT 309
#define RELOP_GTE 310
#define RELOP_LT 311
#define RELOP_LTE 312
#define RESULT 313
#define RETURN 314
#define TAILCALL 315
#define YIELDT 316
#define GET_RESULTS 317
#define POW 318
#define SHIFT_RIGHT_U 319
#define LOG_AND 320
#define LOG_OR 321
#define COMMA 322
#define ESUB 323
#define DOTDOT 324
#define PCC_BEGIN 325
#define PCC_END 326
#define PCC_CALL 327
#define PCC_SUB 328
#define PCC_BEGIN_RETURN 329
#define PCC_END_RETURN 330
#define PCC_BEGIN_YIELD 331
#define PCC_END_YIELD 332
#define INVOCANT 333
#define MAIN 334
#define LOAD 335
#define INIT 336
#define IMMEDIATE 337
#define POSTCOMP 338
#define METHOD 339
#define ANON 340
#define OUTER 341
#define NEED_LEX 342
#define MULTI 343
#define SUBTAG 344
#define VTABLE_METHOD 345
#define LOADLIB 346
#define SUB_INSTANCE_OF 347
#define SUBID 348
#define NS_ENTRY 349
#define LABEL 350
#define EMIT 351
#define EOM 352
#define IREG 353
#define NREG 354
#define SREG 355
#define PREG 356
#define IDENTIFIER 357
#define REG 358
#define MACRO 359
#define ENDM 360
#define STRINGC 361
#define INTC 362
#define FLOATC 363
#define USTRINGC 364
#define PARROT_OP 365
#define VAR 366
#define LINECOMMENT 367
#define FILECOMMENT 368
#define CONCAT 369
#define DOT 370

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 1049 "compilers/imcc/imcc.y" /* yacc.c:355  */

    IdList * idlist;
    int t;
    char * s;
    SymReg * sr;
    Instruction *i;

#line 1392 "compilers/imcc/imcparser.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif



int yyparse (void *yyscanner, imc_info_t *imcc);

#endif /* !YY_YY_COMPILERS_IMCC_IMCPARSER_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1406 "compilers/imcc/imcparser.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  26
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   616

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  132
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  128
/* YYNRULES -- Number of rules.  */
#define YYNRULES  331
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  521

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   370

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       4,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   123,     2,     2,     2,   129,   130,     2,
     121,   122,   127,   126,     2,   125,     2,   128,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   120,
       2,   117,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   118,     2,   119,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   131,     2,   124,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1140,  1140,  1144,  1145,  1149,  1150,  1151,  1157,  1163,
    1164,  1165,  1169,  1170,  1179,  1191,  1204,  1204,  1213,  1213,
    1222,  1223,  1227,  1228,  1232,  1233,  1234,  1235,  1236,  1237,
    1238,  1241,  1241,  1249,  1248,  1259,  1263,  1283,  1287,  1291,
    1291,  1303,  1305,  1309,  1324,  1325,  1329,  1329,  1339,  1340,
    1349,  1353,  1357,  1348,  1369,  1371,  1368,  1398,  1423,  1428,
    1431,  1436,  1444,  1445,  1446,  1447,  1448,  1459,  1470,  1475,
    1479,  1486,  1497,  1503,  1512,  1518,  1527,  1533,  1542,  1548,
    1557,  1565,  1570,  1580,  1582,  1587,  1586,  1612,  1613,  1617,
    1618,  1622,  1623,  1627,  1628,  1632,  1640,  1648,  1649,  1650,
    1651,  1652,  1653,  1654,  1655,  1656,  1657,  1658,  1659,  1660,
    1664,  1669,  1676,  1677,  1690,  1695,  1696,  1704,  1705,  1705,
    1715,  1716,  1720,  1721,  1722,  1723,  1724,  1725,  1726,  1731,
    1731,  1734,  1742,  1742,  1748,  1749,  1754,  1762,  1763,  1768,
    1776,  1780,  1785,  1784,  1797,  1798,  1802,  1803,  1813,  1818,
    1828,  1837,  1838,  1850,  1854,  1855,  1857,  1858,  1859,  1860,
    1864,  1865,  1869,  1870,  1874,  1886,  1887,  1898,  1905,  1914,
    1923,  1924,  1925,  1925,  1938,  1956,  1962,  1962,  1969,  1970,
    1970,  1976,  1982,  1986,  1992,  1994,  1995,  1996,  1997,  1998,
    2002,  2003,  2004,  2005,  2009,  2011,  2014,  2017,  2019,  2022,
    2029,  2028,  2037,  2038,  2039,  2040,  2049,  2050,  2051,  2055,
    2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2065,
    2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,  2075,
    2076,  2077,  2083,  2082,  2094,  2097,  2108,  2109,  2110,  2111,
    2112,  2113,  2114,  2115,  2116,  2117,  2118,  2119,  2124,  2133,
    2134,  2135,  2136,  2142,  2156,  2162,  2168,  2178,  2177,  2186,
    2187,  2197,  2207,  2213,  2218,  2237,  2241,  2242,  2246,  2247,
    2248,  2250,  2256,  2265,  2269,  2279,  2285,  2295,  2300,  2304,
    2305,  2309,  2313,  2317,  2324,  2328,  2332,  2339,  2340,  2344,
    2345,  2346,  2347,  2348,  2349,  2353,  2354,  2358,  2359,  2363,
    2364,  2368,  2369,  2376,  2383,  2384,  2385,  2389,  2390,  2394,
    2395,  2399,  2400,  2404,  2405,  2409,  2409,  2419,  2419,  2431,
    2432,  2440,  2447,  2448,  2449,  2450,  2451,  2455,  2456,  2460,
    2461,  2462
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "LOW_PREC", "'\\n'", "PARAM", "SOL",
  "HLL", "GOTO", "ARG", "IF", "UNLESS", "PNULL", "SET_RETURN", "SET_YIELD",
  "ADV_FLAT", "ADV_SLURPY", "ADV_OPTIONAL", "ADV_OPT_FLAG", "ADV_NAMED",
  "ADV_ARROW", "ADV_INVOCANT", "ADV_CALL_SIG", "NAMESPACE", "DOT_METHOD",
  "SUB", "SYM", "LOCAL", "LEXICAL", "CONST", "ANNOTATE", "GLOBAL_CONST",
  "PLUS_ASSIGN", "MINUS_ASSIGN", "MUL_ASSIGN", "DIV_ASSIGN",
  "CONCAT_ASSIGN", "BAND_ASSIGN", "BOR_ASSIGN", "BXOR_ASSIGN", "FDIV",
  "FDIV_ASSIGN", "MOD_ASSIGN", "SHR_ASSIGN", "SHL_ASSIGN", "SHR_U_ASSIGN",
  "SHIFT_LEFT", "SHIFT_RIGHT", "INTV", "FLOATV", "STRINGV", "PMCV",
  "LOG_XOR", "RELOP_EQ", "RELOP_NE", "RELOP_GT", "RELOP_GTE", "RELOP_LT",
  "RELOP_LTE", "RESULT", "RETURN", "TAILCALL", "YIELDT", "GET_RESULTS",
  "POW", "SHIFT_RIGHT_U", "LOG_AND", "LOG_OR", "COMMA", "ESUB", "DOTDOT",
  "PCC_BEGIN", "PCC_END", "PCC_CALL", "PCC_SUB", "PCC_BEGIN_RETURN",
  "PCC_END_RETURN", "PCC_BEGIN_YIELD", "PCC_END_YIELD", "INVOCANT", "MAIN",
  "LOAD", "INIT", "IMMEDIATE", "POSTCOMP", "METHOD", "ANON", "OUTER",
  "NEED_LEX", "MULTI", "SUBTAG", "VTABLE_METHOD", "LOADLIB",
  "SUB_INSTANCE_OF", "SUBID", "NS_ENTRY", "LABEL", "EMIT", "EOM", "IREG",
  "NREG", "SREG", "PREG", "IDENTIFIER", "REG", "MACRO", "ENDM", "STRINGC",
  "INTC", "FLOATC", "USTRINGC", "PARROT_OP", "VAR", "LINECOMMENT",
  "FILECOMMENT", "CONCAT", "DOT", "'='", "'['", "']'", "';'", "'('", "')'",
  "'!'", "'~'", "'-'", "'+'", "'*'", "'/'", "'%'", "'&'", "'|'", "$accept",
  "program", "compilation_units", "compilation_unit", "pragma",
  "annotate_directive", "hll_def", "constdef", "$@1", "pmc_const", "$@2",
  "any_string", "pasmcode", "pasmline", "pasm_inst", "$@3", "$@4",
  "pasm_args", "emit", "$@5", "opt_pasmcode", "class_namespace",
  "maybe_ns", "nslist", "$@6", "_nslist", "sub", "$@7", "$@8", "$@9",
  "sub_param", "$@10", "$@11", "sub_param_type_def", "multi",
  "multi_types", "multi_type", "subtag", "subtags", "outer", "vtable",
  "method", "ns_entry_name", "instanceof", "subid", "sub_body",
  "pcc_sub_call", "@12", "opt_label", "opt_invocant", "sub_proto",
  "sub_proto_list", "proto", "pcc_call", "pcc_args", "pcc_arg",
  "pcc_results", "pcc_result", "$@13", "paramtype_list", "paramtype",
  "pcc_ret", "$@14", "pcc_yield", "$@15", "pcc_returns", "pcc_yields",
  "pcc_return", "pcc_set_yield", "pcc_return_many", "$@16",
  "return_or_yield", "var_returns", "statements", "helper_clear_state",
  "statement", "labels", "_labels", "label", "instruction", "id_list",
  "id_list_id", "labeled_inst", "$@17", "$@18", "$@19", "type",
  "assignment", "@20", "un_op", "bin_op", "get_results", "@21",
  "op_assign", "assign_op", "func_assign", "the_sub", "sub_call", "@22",
  "arglist", "arg", "argtype_list", "argtype", "result", "targetlist",
  "conditional_statement", "unless_statement", "if_statement",
  "comma_or_goto", "relop", "target", "vars", "_vars", "_var_or_i",
  "sub_label_op_c", "sub_label_op", "label_op", "var_or_i", "var",
  "keylist", "$@23", "keylist_force", "$@24", "_keylist", "key", "reg",
  "stringc", "const", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,    10,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    61,    91,    93,
      59,    40,    41,    33,   126,    45,    43,    42,    47,    37,
      38,   124
};
# endif

#define YYPACT_NINF -415

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-415)))

#define YYTABLE_NINF -253

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      83,  -415,   -86,   -68,  -415,  -415,   -33,  -415,    72,    85,
      83,  -415,  -415,    79,  -415,  -415,  -415,  -415,  -415,   -10,
     122,    59,   218,   127,    63,  -415,  -415,  -415,  -415,  -415,
      24,    35,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
    -415,  -415,  -415,    47,  -415,  -415,  -415,   147,  -415,  -415,
    -415,  -415,   125,  -415,    54,  -415,    27,    77,  -415,  -415,
    -415,  -415,    66,  -415,   437,    62,    80,  -415,  -415,  -415,
     369,    82,  -415,   187,    73,  -415,    35,  -415,  -415,  -415,
    -415,  -415,    74,  -415,    84,  -415,    88,    98,    99,   103,
     112,   115,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
     189,   437,  -415,   186,   387,  -415,  -415,  -415,  -415,  -415,
    -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,   126,   437,
    -415,   354,  -415,    53,   -66,   -36,    91,    94,   128,    53,
      53,  -415,  -415,  -415,  -415,  -415,  -415,    89,  -415,   144,
     153,  -415,  -415,   137,  -415,   202,  -415,  -415,  -415,  -415,
     150,   151,   152,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
     -50,  -415,  -415,   -28,   154,   161,   163,   164,    22,    53,
    -415,  -415,   172,   369,  -415,   354,  -415,  -415,  -415,   178,
     369,   -36,  -415,   198,  -415,  -415,  -415,  -415,  -415,  -415,
     199,   305,  -415,  -415,  -415,  -415,   244,    33,    18,  -415,
    -415,  -415,  -415,   194,  -415,   196,  -415,  -415,   194,  -415,
    -415,   218,   248,  -415,  -415,  -415,   313,   200,  -415,   369,
    -415,   314,   216,   186,  -415,   -67,   180,   286,   369,  -415,
      57,   213,  -415,  -415,   504,  -415,  -415,   321,   322,   329,
    -415,  -415,  -415,   354,  -415,  -415,  -415,  -415,  -415,  -415,
     226,   330,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
    -415,   367,  -415,  -415,  -415,  -415,  -415,   369,   188,   369,
     188,  -415,   218,   280,   287,   218,   218,  -415,   243,   237,
    -415,  -415,  -415,  -415,   242,  -415,  -415,   239,  -415,  -415,
    -415,  -415,   369,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
    -415,   434,   228,  -415,   369,  -415,   235,   355,  -415,  -415,
    -415,  -415,  -415,  -415,  -415,  -415,   -67,   369,   356,   -67,
     369,   259,   114,   114,   263,   264,   242,  -415,  -415,  -415,
     348,  -415,   -26,  -415,   448,   462,  -415,  -415,  -415,  -415,
    -415,  -415,   249,   250,   354,  -415,  -415,  -415,   369,  -415,
     -73,   385,   255,  -415,  -415,  -415,  -415,   254,  -415,  -415,
     -67,  -415,   361,   -67,  -415,   370,  -415,   312,  -415,  -415,
    -415,   266,   267,   -15,    26,    12,     6,   114,   315,   274,
     235,   377,   -11,  -415,  -415,   393,    -9,  -415,   398,  -415,
    -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
    -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
    -415,  -415,  -415,  -415,  -415,   369,   303,    64,  -415,   -67,
    -415,   -67,   259,   186,   186,  -415,   369,   369,   308,   417,
    -415,   369,  -415,   425,  -415,   369,  -415,   426,  -415,   413,
    -415,   504,   369,   476,  -415,    39,   369,   490,  -415,   369,
     316,  -415,   369,   323,   324,  -415,  -415,  -415,  -415,  -415,
    -415,   430,   369,    77,  -415,  -415,  -415,  -415,  -415,   114,
     326,  -415,   416,  -415,  -415,   327,  -415,  -415,  -415,   424,
    -415,  -415,  -415,  -415,  -415,  -415,  -415,     7,  -415,   455,
      39,    39,  -415,   462,   369,    71,   369,  -415,   369,   113,
    -415,    31,  -415,   338,   345,  -415,   470,  -415,   114,  -415,
     471,  -415,  -415,  -415,  -415,   218,  -415,  -415,   259,   235,
    -415
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,    11,     0,     0,    50,    16,     0,    39,     0,     0,
       2,     3,    10,     0,     6,     8,     5,     7,    15,    46,
       0,     0,     0,     0,   160,     9,     1,     4,    12,    45,
       0,     0,    43,   307,   305,   306,   308,    51,   304,   190,
     191,   192,   193,     0,    13,    18,   164,     0,    27,    26,
      30,    29,   160,    22,     0,    28,    31,   161,   163,    44,
     327,   328,    47,    48,    91,     0,     0,    25,    23,    40,
       0,     0,    33,     0,     0,   162,     0,    97,    95,    96,
      98,    99,    76,   100,     0,   101,     0,     0,    74,     0,
      81,    78,   102,   103,   104,   105,   106,   107,   108,   109,
       0,    92,    93,     0,     0,   322,   323,   324,   325,   326,
     329,   330,   295,   313,    35,   296,   331,   314,     0,    91,
      24,   297,    49,     0,     0,    59,     0,     0,     0,     0,
       0,    52,    94,    17,   309,   310,   311,     0,   312,     0,
       0,   317,    32,   313,    38,   298,   300,   301,    20,    21,
       0,     0,     0,    62,    63,    65,    64,    66,    67,   315,
       0,    61,    71,     0,     0,     0,     0,     0,   153,     0,
      36,    34,     0,     0,   315,     0,    77,    73,    72,     0,
       0,     0,    58,     0,    69,    75,    80,    82,    79,    54,
       0,     0,   158,   157,   159,   154,     0,   153,     0,   151,
      19,   303,   321,   318,   319,     0,   299,    68,   316,    60,
      70,     0,     0,   156,    53,   152,     0,   189,   155,     0,
     302,     0,     0,     0,   166,     0,     0,     0,     0,   172,
       0,   176,   179,   144,     0,   145,   232,     0,     0,     0,
     249,   250,   251,   297,   200,   178,   186,   187,   188,   131,
       0,     0,   170,   202,   203,   204,   257,   185,   171,   280,
     279,   252,   320,    55,   120,    14,   182,     0,     0,     0,
       0,   184,     0,     0,     0,     0,     0,   181,   252,     0,
      85,   129,   132,   183,   278,   142,   165,     0,   236,   237,
     238,   239,     0,   242,   243,   244,   241,   240,   245,   246,
     247,     0,     0,   315,     0,    56,    57,     0,   288,   289,
     290,   291,   292,   293,   294,   287,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   278,   112,   134,   137,
       0,   276,     0,   120,   146,   259,   235,   255,   254,   256,
     253,   205,   327,   328,   297,   206,   207,   208,     0,   199,
     313,   194,     0,   234,   122,   123,   124,   125,   128,   121,
       0,   284,     0,     0,   283,     0,   169,   173,   167,   174,
     175,     0,     0,     0,    89,     0,     0,     0,     0,     0,
     273,   327,     0,   147,   266,   327,     0,   261,   266,   248,
     195,   214,   223,   224,   228,   217,   218,   219,   220,   221,
     222,   215,   225,   226,   227,   216,   315,   231,   209,   210,
     211,   212,   213,   229,   230,     0,     0,     0,   286,     0,
     282,     0,     0,     0,     0,   233,     0,     0,     0,     0,
     135,     0,   130,     0,   138,     0,   133,     0,   277,     0,
     274,     0,     0,     0,   143,   265,     0,     0,   258,     0,
       0,   196,     0,     0,     0,   285,   281,   168,   177,   180,
     114,     0,     0,    87,   113,   266,   136,   266,   139,     0,
       0,   148,   327,   149,   268,   269,   270,   267,   264,   327,
     260,   263,   197,   198,   126,   127,    90,     0,   115,     0,
     140,   141,   275,   259,     0,     0,     0,   111,     0,     0,
      88,     0,   150,     0,     0,   262,     0,   118,     0,    86,
       0,   201,   272,   271,   110,     0,   120,   116,     0,   117,
     119
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -415,  -415,  -415,   472,    -1,  -415,  -415,  -415,  -415,   275,
    -415,   -96,  -415,   428,  -415,  -415,  -415,   149,  -415,  -415,
    -415,     8,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
    -415,  -415,  -415,  -415,  -415,  -415,   320,  -415,  -415,  -415,
    -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
     383,  -415,   403,  -415,  -415,  -415,  -415,  -415,  -415,  -326,
    -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,  -415,
    -415,  -415,  -415,  -415,  -415,   309,   307,  -415,   -56,  -415,
    -415,  -414,  -415,  -415,  -415,  -415,  -207,  -415,  -415,  -415,
    -415,  -415,  -415,  -415,  -415,  -415,    67,  -225,  -415,    14,
    -310,  -401,  -415,   162,   203,  -415,  -415,  -415,   269,   272,
    -119,   300,  -415,   376,  -415,   252,  -219,   450,   -70,  -169,
    -415,  -415,  -415,   379,   346,  -415,   -14,  -100
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     9,    10,    11,    12,   194,    13,    14,    22,    51,
      66,   150,    52,    53,    73,    74,   119,   142,    15,    24,
      54,    16,    20,    30,    31,    62,    17,    21,    64,   168,
     195,   211,   305,   221,    92,   160,   161,    93,   163,    94,
      95,    96,    97,    98,    99,   196,   246,   327,   488,   428,
     100,   101,   102,   463,   374,   429,   499,   510,   515,   306,
     359,   247,   328,   248,   329,   375,   376,   433,   437,   249,
     334,   250,   382,   197,   198,   199,    56,    57,    58,   218,
     367,   368,   251,   272,   275,   276,    43,   252,   284,   348,
     415,   253,   279,   254,   304,   255,   256,   257,   287,   386,
     387,   445,   477,   331,   332,   258,   259,   260,   316,   317,
     113,   144,   145,   146,    37,    38,   136,   147,   138,   179,
     180,   172,   173,   203,   204,   115,   116,   117
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     114,    75,   143,   133,   222,   205,   266,   380,   457,   277,
     434,   497,   153,   154,   155,   156,   430,    63,   181,   216,
     435,    18,  -160,    50,   383,   431,  -160,   189,  -160,  -160,
    -160,   -37,    55,   166,   167,   426,   134,   151,   189,    70,
     183,   152,   378,   301,   135,  -160,  -160,  -160,  -252,  -160,
      19,    50,   190,   378,   474,    71,   143,   443,   475,   447,
      55,   476,   122,   190,   490,   321,   491,   157,   324,   325,
       2,   158,   182,   200,    23,   498,    25,   349,  -160,  -160,
    -160,  -160,   159,    28,   436,    26,     3,     1,   432,  -160,
       2,   -83,    45,  -160,   184,  -160,   379,   361,   261,   447,
     364,    72,   -84,   202,   520,   427,     3,   425,     4,    29,
     202,   444,     5,   448,    46,   278,   460,  -160,  -160,  -160,
    -160,  -160,  -160,   265,   143,  -160,    32,   191,  -160,  -160,
    -160,    44,     2,   473,   352,   192,   193,   480,   191,  -160,
     507,   418,    60,    59,   420,    61,   192,   193,     3,   202,
      65,    67,    69,   511,    45,     6,   268,   270,   271,    46,
     148,   -41,    33,   149,   273,   333,    34,   274,    47,    35,
      36,   453,   508,    46,   454,     6,    48,    49,   503,   103,
       7,   504,   339,   350,   121,   509,    76,   104,     8,   118,
     519,   120,   267,   131,   139,   123,   308,   307,   162,   318,
     455,   164,   456,   369,   370,   124,   169,   333,   225,   125,
     226,   227,   228,   105,   106,   107,   108,     6,   109,   126,
     127,    46,   336,   -42,   128,   143,   112,   229,   230,   231,
      47,   232,   351,   129,   353,   165,   130,   450,    48,    49,
     341,   309,   310,   311,   312,   313,   314,   362,   170,   171,
     365,   354,   355,   356,   357,   174,   315,   358,   438,   333,
     233,   234,   235,   236,   384,   388,    39,    40,    41,    42,
     175,   237,   176,   177,   178,   238,   185,   239,   390,   105,
     106,   107,   108,   186,   109,   187,   188,    60,   110,   111,
      61,   201,   112,    60,   110,   111,    61,   207,   269,   105,
     106,   107,   108,   240,   109,   210,   212,   241,   518,   213,
     242,   243,   112,   214,   219,   220,   223,   224,   263,   264,
     -18,   244,   278,   458,   459,   280,   281,   105,   106,   107,
     108,   240,   109,   282,   286,   342,   110,   111,   343,   344,
     112,   105,   106,   107,   108,   451,   109,   285,   322,   330,
     492,   345,   346,   347,   112,   323,   384,   461,   326,   301,
     335,   465,   366,   360,   363,   467,   371,   372,   377,   419,
    -250,  -251,   471,   384,   416,   417,   478,   384,   421,   481,
     422,   462,   483,   423,   424,   105,   106,   107,   108,   516,
     109,   441,   487,    60,   110,   111,    61,   442,   112,   288,
     289,   290,   291,   292,   293,   294,   295,   489,   296,   297,
     298,   299,   300,   446,   105,   106,   107,   108,   449,   109,
     452,   464,   439,   388,   502,   391,   505,   112,   506,   466,
     468,   392,   393,   469,   486,   482,   494,   394,   395,   396,
     397,   398,   399,   400,   496,   484,   485,   493,   495,   401,
     402,   403,   404,   105,   106,   107,   108,   134,   109,   500,
     512,    60,   110,   111,    61,   135,   112,   513,   105,   106,
     107,   108,   141,   109,   514,   517,    60,   110,   111,    61,
      68,   112,    27,   301,   302,   303,   105,   106,   107,   108,
     134,   109,   245,   389,    60,   110,   111,    61,   135,   112,
     405,   209,   140,   406,   132,   217,   215,   501,   470,   407,
     408,   409,   410,   411,   412,   413,   414,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,   373,
      89,    90,    91,   105,   106,   107,   108,    33,   109,   319,
     440,   337,   320,   283,   338,    36,   112,   105,   106,   107,
     108,   206,   109,   340,   137,   381,   110,   111,    61,   208,
     112,   105,   106,   107,   108,   262,   109,     0,     0,   385,
     110,   111,    61,     0,   112,   105,   106,   107,   108,     0,
     109,     0,     0,   472,   110,   111,    61,     0,   112,   105,
     106,   107,   108,     0,   109,     0,     0,   479,   110,   111,
      61,     0,   112,   105,   106,   107,   108,   240,   109,     0,
       0,   241,     0,     0,   242,     0,   112
};

static const yytype_int16 yycheck[] =
{
      70,    57,   121,   103,   211,   174,   225,   333,   422,   234,
       4,     4,    48,    49,    50,    51,     4,    31,    68,     1,
      14,   107,     4,    24,   334,    13,     8,     5,    10,    11,
      12,     4,    24,   129,   130,     9,   103,   103,     5,    12,
      68,   107,    68,   116,   111,    27,    28,    29,   121,    31,
     118,    52,    30,    68,    15,    28,   175,    68,    19,    68,
      52,    22,    76,    30,   465,   272,   467,   103,   275,   276,
       7,   107,   122,   169,   107,    68,     4,   302,    60,    61,
      62,    63,   118,     4,    78,     0,    23,     4,    76,    71,
       7,    69,    29,    75,   122,    77,   122,   316,   217,    68,
     319,    74,    69,   173,   518,    79,    23,   122,    25,   119,
     180,   122,    29,   122,    96,   234,   426,    99,   100,   101,
     102,   103,   104,   223,   243,   107,     4,   105,   110,   111,
     112,     4,     7,   443,   303,   113,   114,   447,   105,   121,
      27,   360,   107,   119,   363,   110,   113,   114,    23,   219,
     103,     4,    98,   122,    29,    92,   226,   227,   228,    96,
     107,    98,   103,   110,   107,   284,   107,   110,   105,   110,
     111,   107,    59,    96,   110,    92,   113,   114,   107,   117,
      97,   110,   301,   302,   111,    72,   120,   107,   105,   107,
     516,     4,    12,     4,    68,   121,     8,   267,   107,   269,
     419,   107,   421,   322,   323,   121,   117,   326,     8,   121,
      10,    11,    12,    99,   100,   101,   102,    92,   104,   121,
     121,    96,   292,    98,   121,   344,   112,    27,    28,    29,
     105,    31,   302,   121,   304,   107,   121,   406,   113,   114,
      12,    53,    54,    55,    56,    57,    58,   317,   104,    96,
     320,    16,    17,    18,    19,   118,    68,    22,   377,   378,
      60,    61,    62,    63,   334,   335,    48,    49,    50,    51,
      68,    71,   122,   122,   122,    75,   122,    77,   348,    99,
     100,   101,   102,   122,   104,   122,   122,   107,   108,   109,
     110,   119,   112,   107,   108,   109,   110,   119,    12,    99,
     100,   101,   102,   103,   104,   107,   107,   107,   515,     4,
     110,   111,   112,    69,   120,   119,    68,     4,     4,   103,
     107,   121,   441,   423,   424,     4,     4,    99,   100,   101,
     102,   103,   104,     4,     4,   107,   108,   109,   110,   111,
     112,    99,   100,   101,   102,   415,   104,   121,    68,   107,
     469,   123,   124,   125,   112,    68,   426,   427,   121,   116,
     121,   431,   103,     8,     8,   435,   103,   103,    20,     8,
     121,   121,   442,   443,   119,   121,   446,   447,     8,   449,
      68,    73,   452,   117,   117,    99,   100,   101,   102,   508,
     104,   117,   462,   107,   108,   109,   110,    20,   112,    32,
      33,    34,    35,    36,    37,    38,    39,   463,    41,    42,
      43,    44,    45,    20,    99,   100,   101,   102,    20,   104,
     117,     4,   107,   493,   494,    40,   496,   112,   498,     4,
       4,    46,    47,    20,     4,   119,    20,    52,    53,    54,
      55,    56,    57,    58,    20,   122,   122,   121,   121,    64,
      65,    66,    67,    99,   100,   101,   102,   103,   104,     4,
     122,   107,   108,   109,   110,   111,   112,   122,    99,   100,
     101,   102,   118,   104,     4,     4,   107,   108,   109,   110,
      52,   112,    10,   116,   117,   118,    99,   100,   101,   102,
     103,   104,   217,   344,   107,   108,   109,   110,   111,   112,
     115,   181,   119,   118,   101,   198,   197,   493,   441,   124,
     125,   126,   127,   128,   129,   130,   131,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,   326,
      93,    94,    95,    99,   100,   101,   102,   103,   104,   270,
     378,   107,   270,   243,   110,   111,   112,    99,   100,   101,
     102,   175,   104,   301,   104,   107,   108,   109,   110,   180,
     112,    99,   100,   101,   102,   219,   104,    -1,    -1,   107,
     108,   109,   110,    -1,   112,    99,   100,   101,   102,    -1,
     104,    -1,    -1,   107,   108,   109,   110,    -1,   112,    99,
     100,   101,   102,    -1,   104,    -1,    -1,   107,   108,   109,
     110,    -1,   112,    99,   100,   101,   102,   103,   104,    -1,
      -1,   107,    -1,    -1,   110,    -1,   112
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     4,     7,    23,    25,    29,    92,    97,   105,   133,
     134,   135,   136,   138,   139,   150,   153,   158,   107,   118,
     154,   159,   140,   107,   151,     4,     0,   135,     4,   119,
     155,   156,     4,   103,   107,   110,   111,   246,   247,    48,
      49,    50,    51,   218,     4,    29,    96,   105,   113,   114,
     136,   141,   144,   145,   152,   153,   208,   209,   210,   119,
     107,   110,   157,   258,   160,   103,   142,     4,   145,    98,
      12,    28,    74,   146,   147,   210,   120,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    93,
      94,    95,   166,   169,   171,   172,   173,   174,   175,   176,
     182,   183,   184,   117,   107,    99,   100,   101,   102,   104,
     108,   109,   112,   242,   250,   257,   258,   259,   107,   148,
       4,   111,   258,   121,   121,   121,   121,   121,   121,   121,
     121,     4,   184,   259,   103,   111,   248,   249,   250,    68,
     182,   118,   149,   242,   243,   244,   245,   249,   107,   110,
     143,   103,   107,    48,    49,    50,    51,   103,   107,   118,
     167,   168,   107,   170,   107,   107,   143,   143,   161,   117,
     104,    96,   253,   254,   118,    68,   122,   122,   122,   251,
     252,    68,   122,    68,   122,   122,   122,   122,   122,     5,
      30,   105,   113,   114,   137,   162,   177,   205,   206,   207,
     143,   119,   250,   255,   256,   251,   245,   119,   255,   168,
     107,   163,   107,     4,    69,   207,     1,   208,   211,   120,
     119,   165,   218,    68,     4,     8,    10,    11,    12,    27,
      28,    29,    31,    60,    61,    62,    63,    71,    75,    77,
     103,   107,   110,   111,   121,   141,   178,   193,   195,   201,
     203,   214,   219,   223,   225,   227,   228,   229,   237,   238,
     239,   242,   256,     4,   103,   259,   248,    12,   250,    12,
     250,   250,   215,   107,   110,   216,   217,   229,   242,   224,
       4,     4,     4,   243,   220,   121,     4,   230,    32,    33,
      34,    35,    36,    37,    38,    39,    41,    42,    43,    44,
      45,   116,   117,   118,   226,   164,   191,   250,     8,    53,
      54,    55,    56,    57,    58,    68,   240,   241,   250,   240,
     241,   218,    68,    68,   218,   218,   121,   179,   194,   196,
     107,   235,   236,   242,   202,   121,   250,   107,   110,   242,
     247,    12,   107,   110,   111,   123,   124,   125,   221,   229,
     242,   250,   251,   250,    16,    17,    18,    19,    22,   192,
       8,   248,   250,     8,   248,   250,   103,   212,   213,   242,
     242,   103,   103,   236,   186,   197,   198,    20,    68,   122,
     191,   107,   204,   232,   250,   107,   231,   232,   250,   149,
     250,    40,    46,    47,    52,    53,    54,    55,    56,    57,
      58,    64,    65,    66,    67,   115,   118,   124,   125,   126,
     127,   128,   129,   130,   131,   222,   119,   121,   248,     8,
     248,     8,    68,   117,   117,   122,     9,    79,   181,   187,
       4,    13,    76,   199,     4,    14,    78,   200,   242,   107,
     235,   117,    20,    68,   122,   233,    20,    68,   122,    20,
     251,   250,   117,   107,   110,   248,   248,   213,   259,   259,
     232,   250,    73,   185,     4,   250,     4,   250,     4,    20,
     228,   250,   107,   232,    15,    19,    22,   234,   250,   107,
     232,   250,   119,   250,   122,   122,     4,   250,   180,   210,
     233,   233,   242,   121,    20,   121,    20,     4,    68,   188,
       4,   231,   250,   107,   110,   250,   250,    27,    59,    72,
     189,   122,   122,   122,     4,   190,   242,     4,   218,   191,
     213
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   132,   133,   134,   134,   135,   135,   135,   135,   135,
     135,   135,   136,   136,   137,   138,   140,   139,   142,   141,
     143,   143,   144,   144,   145,   145,   145,   145,   145,   145,
     145,   147,   146,   148,   146,   146,   146,   146,   149,   151,
     150,   152,   152,   153,   154,   154,   156,   155,   157,   157,
     159,   160,   161,   158,   163,   164,   162,   165,   166,   167,
     167,   167,   168,   168,   168,   168,   168,   168,   168,   169,
     170,   170,   171,   171,   172,   172,   173,   173,   174,   174,
     175,   176,   176,   177,   177,   179,   178,   180,   180,   181,
     181,   182,   182,   183,   183,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     185,   185,   186,   186,   187,   188,   188,   189,   190,   189,
     191,   191,   192,   192,   192,   192,   192,   192,   192,   194,
     193,   193,   196,   195,   197,   197,   197,   198,   198,   198,
     199,   200,   202,   201,   203,   203,   204,   204,   204,   204,
     204,   205,   205,   206,   207,   207,   207,   207,   207,   207,
     208,   208,   209,   209,   210,   211,   211,   212,   212,   213,
     214,   214,   215,   214,   214,   214,   216,   214,   214,   217,
     214,   214,   214,   214,   214,   214,   214,   214,   214,   214,
     218,   218,   218,   218,   219,   219,   219,   219,   219,   219,
     220,   219,   219,   219,   219,   219,   221,   221,   221,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   224,   223,   225,   225,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   227,   228,
     228,   228,   228,   228,   228,   228,   228,   230,   229,   231,
     231,   231,   231,   231,   231,   232,   233,   233,   234,   234,
     234,   234,   234,   235,   236,   236,   236,   236,   236,   237,
     237,   238,   238,   238,   239,   239,   239,   240,   240,   241,
     241,   241,   241,   241,   241,   242,   242,   243,   243,   244,
     244,   245,   245,   245,   246,   246,   246,   247,   247,   248,
     248,   249,   249,   250,   250,   252,   251,   254,   253,   255,
     255,   256,   257,   257,   257,   257,   257,   258,   258,   259,
     259,   259
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     2,     1,     1,     1,     1,     2,
       1,     1,     2,     3,     4,     2,     0,     6,     0,     6,
       1,     1,     1,     2,     3,     2,     1,     1,     1,     1,
       1,     0,     3,     0,     4,     2,     4,     0,     1,     0,
       4,     0,     1,     3,     3,     2,     0,     2,     1,     3,
       0,     0,     0,     9,     0,     0,     5,     3,     4,     0,
       3,     1,     1,     1,     1,     1,     1,     1,     3,     4,
       3,     1,     4,     4,     1,     4,     1,     4,     1,     4,
       4,     1,     4,     0,     1,     0,     9,     0,     2,     0,
       3,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     3,     0,     3,     2,     0,     3,     3,     0,     4,
       0,     2,     1,     1,     1,     1,     4,     4,     1,     0,
       5,     1,     0,     5,     0,     2,     3,     0,     2,     3,
       3,     3,     0,     5,     1,     1,     0,     1,     3,     3,
       5,     1,     2,     0,     1,     2,     2,     1,     1,     1,
       0,     1,     2,     1,     1,     3,     2,     1,     3,     1,
       1,     1,     0,     4,     4,     4,     0,     6,     1,     0,
       6,     2,     2,     2,     2,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     3,     4,     5,     6,     6,     3,
       0,     9,     1,     1,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     1,
       1,     1,     1,     3,     3,     3,     3,     0,     5,     0,
       3,     1,     5,     3,     3,     2,     0,     2,     1,     1,
       1,     4,     4,     2,     3,     5,     1,     3,     0,     1,
       1,     6,     5,     4,     4,     6,     5,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     3,
       1,     1,     4,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     0,     2,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (yyscanner, imcc, YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, yyscanner, imcc); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, void *yyscanner, imc_info_t *imcc)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  YYUSE (yyscanner);
  YYUSE (imcc);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, void *yyscanner, imc_info_t *imcc)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yyscanner, imcc);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule, void *yyscanner, imc_info_t *imcc)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              , yyscanner, imcc);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, yyscanner, imcc); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, void *yyscanner, imc_info_t *imcc)
{
  YYUSE (yyvaluep);
  YYUSE (yyscanner);
  YYUSE (imcc);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void *yyscanner, imc_info_t *imcc)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, yyscanner, imcc);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1140 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { if (yynerrs) YYABORT; (yyval.i) = 0; }
#line 2948 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 5:
#line 1149 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[0].i); }
#line 2954 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 6:
#line 1150 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[0].i); }
#line 2960 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 7:
#line 1152 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = (yyvsp[0].i);
           imc_close_unit(imcc, imcc->cur_unit);
           imcc->cur_unit = 0;
         }
#line 2970 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 8:
#line 1158 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = (yyvsp[0].i);
           imc_close_unit(imcc, imcc->cur_unit);
           imcc->cur_unit = 0;
         }
#line 2980 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 9:
#line 1163 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 2986 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 10:
#line 1164 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 2992 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 11:
#line 1165 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 2998 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 12:
#line 1169 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 3004 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 13:
#line 1171 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = 0;
           do_loadlib(imcc, (yyvsp[-1].s));
           mem_sys_free((yyvsp[-1].s));
         }
#line 3014 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 14:
#line 1180 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
          /* We'll want to store an entry while emitting instructions, so just
           * store annotation like it's an instruction. */
          SymReg * const key = mk_const(imcc, (yyvsp[-2].s), 'S');
          (yyval.i) = MK_I(imcc, imcc->cur_unit, ".annotate", 2, key, (yyvsp[0].sr));
          mem_sys_free((yyvsp[-2].s));
        }
#line 3026 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 15:
#line 1192 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            STRING * const hll_name = Parrot_str_unescape(imcc->interp, (yyvsp[0].s) + 1, '"', NULL);
            Parrot_pcc_set_HLL(imcc->interp, CURRENT_CONTEXT(imcc->interp),
                Parrot_hll_register_HLL(imcc->interp, hll_name));

            imcc->cur_namespace = NULL;
            mem_sys_free((yyvsp[0].s));
            (yyval.t) = 0;
         }
#line 3040 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 16:
#line 1204 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->is_def = 1; }
#line 3046 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 17:
#line 1205 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
             mk_const_ident(imcc, (yyvsp[-2].s), (yyvsp[-3].t), (yyvsp[0].sr), 1);
             mem_sys_free((yyvsp[-2].s));
             imcc->is_def = 0;
         }
#line 3056 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 18:
#line 1213 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->is_def = 1; }
#line 3062 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 19:
#line 1214 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = mk_pmc_const_named(imcc, imcc->cur_unit, (yyvsp[-3].s), (yyvsp[-2].sr), (yyvsp[0].s));
           mem_sys_free((yyvsp[-3].s));
           mem_sys_free((yyvsp[0].s));
           imcc->is_def = 0;
         }
#line 3073 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 24:
#line 1232 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0;  }
#line 3079 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 25:
#line 1233 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0;  }
#line 3085 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 26:
#line 1234 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0;  }
#line 3091 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 27:
#line 1235 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0;  }
#line 3097 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 28:
#line 1236 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[0].i); }
#line 3103 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 31:
#line 1241 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { clear_state(imcc); }
#line 3109 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 32:
#line 1243 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = INS(imcc, imcc->cur_unit, (yyvsp[-1].s), 0, imcc->regs,
                    imcc->nargs, imcc -> keyvec, 1);
            mem_sys_free((yyvsp[-1].s));
         }
#line 3119 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 33:
#line 1249 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imc_close_unit(imcc, imcc->cur_unit);
           imcc->cur_unit = imc_open_unit(imcc, IMC_PASM);
         }
#line 3128 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 34:
#line 1254 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = iSUBROUTINE(imcc, imcc->cur_unit, mk_sub_label(imcc, (yyvsp[0].s)));
           imcc->cur_call->pcc_sub->pragma = (yyvsp[-1].t);
           mem_sys_free((yyvsp[0].s));
         }
#line 3138 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 35:
#line 1260 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "null", 1, (yyvsp[0].sr));
         }
#line 3146 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 36:
#line 1264 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           char   *name;
           SymReg *n;
           SymReg *r    = mk_pasm_reg(imcc, (yyvsp[0].s));
           if (*(yyvsp[-2].s) == '"') {
               STRING *unescaped = Parrot_str_unescape(imcc->interp, (yyvsp[-2].s) + 1, '"', NULL);
               name              = Parrot_str_to_cstring(imcc->interp, unescaped);
           }
           else {
               name = mem_sys_strdup((yyvsp[-2].s) + 1);
               name[strlen(name) - 1] = 0;
           }
           n = mk_const(imcc, name, 'S');
           set_lexical(imcc, r, n);
           (yyval.i) = 0;
           mem_sys_free((yyvsp[-2].s));
           mem_sys_free((yyvsp[0].s));
           mem_sys_free(name);
         }
#line 3170 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 37:
#line 1283 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0;}
#line 3176 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 39:
#line 1291 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->cur_unit = imc_open_unit(imcc, IMC_PASM); }
#line 3182 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 40:
#line 1294 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           /* if (optimizer_level & OPT_PASM)
                         imc_compile_unit(interp, imcc->cur_unit);
                         emit_flush(interp);
           */
           (yyval.i) = 0;
         }
#line 3194 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 43:
#line 1310 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           int re_open = 0;
           (yyval.i) = 0;
           if (imcc->state->pasm_file && imcc->cur_namespace) {
               imc_close_unit(imcc, imcc->cur_unit);
               re_open = 1;
           }
           imcc->cur_namespace = (yyvsp[-1].sr);
           if (re_open)
               imcc->cur_unit = imc_open_unit(imcc, IMC_PASM);
         }
#line 3210 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 44:
#line 1324 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[-1].sr); }
#line 3216 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 45:
#line 1325 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = NULL; }
#line 3222 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 46:
#line 1329 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc->nkeys    = 0;
         }
#line 3230 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 47:
#line 1333 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = link_keys(imcc, imcc->nkeys, imcc->keys, 0);
         }
#line 3238 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 48:
#line 1339 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->keys[imcc->nkeys++] = (yyvsp[0].sr); }
#line 3244 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 49:
#line 1341 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc->keys[imcc->nkeys++] = (yyvsp[0].sr);
           (yyval.sr) = imcc->keys[0];
         }
#line 3253 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 50:
#line 1349 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc->cur_unit = imc_open_unit(imcc, IMC_PCCSUB);
         }
#line 3261 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 51:
#line 1353 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           iSUBROUTINE(imcc, imcc->cur_unit, (yyvsp[0].sr));
         }
#line 3269 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 52:
#line 1357 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
          imcc->cur_call->pcc_sub->pragma = (yyvsp[-1].t);
          if (!imcc->cur_unit->instructions->symregs[0]->subid) {
            imcc->cur_unit->instructions->symregs[0]->subid =
                imcc->cur_unit->instructions->symregs[0];
          }
        }
#line 3281 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 53:
#line 1364 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; imcc->cur_call = NULL; }
#line 3287 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 54:
#line 1369 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->is_def = 1; }
#line 3293 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 55:
#line 1371 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if (/* IMCC_INFO(interp)->cur_unit->last_ins->op
           ||  */ !(imcc->cur_unit->last_ins->type & ITPCCPARAM)) {
               SymReg *r;
               Instruction *i;
               char name[128];
               snprintf(name, sizeof (name), "%cpcc_params_%d",
                        IMCC_INTERNAL_CHAR, imcc->cnr++);
               r = mk_symreg(imcc, name, 0);
               r->type    = VT_PCC_SUB;
               r->pcc_sub = mem_gc_allocate_zeroed_typed(imcc->interp, pcc_sub_t);
               i = iLABEL(imcc, imcc->cur_unit, r);
               imcc->cur_call = r;
               i->type = ITPCCPARAM;
           }
           if (imcc->adv_named_id) {
                 add_pcc_named_param(imcc, imcc->cur_call,
                                     imcc->adv_named_id, (yyvsp[-1].sr));
                 imcc->adv_named_id = NULL;
           }
           else
               add_pcc_arg(imcc, imcc->cur_call, (yyvsp[-1].sr));
         }
#line 3321 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 56:
#line 1394 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->is_def = 0; }
#line 3327 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 57:
#line 1399 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if ((yyvsp[0].t) & VT_OPT_FLAG && (yyvsp[-2].t) != 'I') {
               const char *type;
               switch ((yyvsp[-2].t)) {
                    case 'N': type = "num";     break;
                    case 'S': type = "string";  break;
                    case 'P': type = "pmc";     break;
                    default:  type = "strange"; break;
               }

               IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                   ":opt_flag parameter must be of type 'int', not '%s'", type);
           }
           if ((yyvsp[0].t) & VT_NAMED && !((yyvsp[0].t) & VT_FLAT) && !imcc->adv_named_id)
               adv_named_set(imcc, (yyvsp[-1].s));
           (yyval.sr) = mk_ident(imcc, (yyvsp[-1].s), (yyvsp[-2].t), VTIDENTIFIER);
           (yyval.sr)->type |= (yyvsp[0].t);
           mem_sys_free((yyvsp[-1].s));
          }
#line 3351 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 58:
#line 1423 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 0; }
#line 3357 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 59:
#line 1428 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           add_pcc_multi(imcc, imcc->cur_call, NULL);
         }
#line 3365 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 60:
#line 1432 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = 0;
           add_pcc_multi(imcc, imcc->cur_call, (yyvsp[0].sr));
         }
#line 3374 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 61:
#line 1437 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = 0;
           add_pcc_multi(imcc, imcc->cur_call, (yyvsp[0].sr));
         }
#line 3383 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 62:
#line 1444 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_const(imcc, "INTVAL",   'S'); }
#line 3389 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 63:
#line 1445 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_const(imcc, "FLOATVAL", 'S'); }
#line 3395 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 64:
#line 1446 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_const(imcc, "PMC",      'S'); }
#line 3401 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 65:
#line 1447 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_const(imcc, "STRING",   'S'); }
#line 3407 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 66:
#line 1449 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           SymReg *r;
           if (strcmp((yyvsp[0].s), "_") != 0)
               r = mk_const(imcc, (yyvsp[0].s), 'S');
           else {
               r = mk_const(imcc, "PMC", 'S');
           }
           mem_sys_free((yyvsp[0].s));
           (yyval.sr) = r;
         }
#line 3422 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 67:
#line 1460 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           SymReg *r;
           if (strcmp((yyvsp[0].s), "\"_\"") == 0 || strcmp((yyvsp[0].s), "'_'") == 0)
               r = mk_const(imcc, "PMC", 'S');
           else {
               r = mk_const(imcc, (yyvsp[0].s), 'S');
           }
           mem_sys_free((yyvsp[0].s));
           (yyval.sr) = r;
         }
#line 3437 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 68:
#line 1470 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[-1].sr); }
#line 3443 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 69:
#line 1475 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 0; }
#line 3449 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 70:
#line 1480 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           SymReg * const r = mk_const(imcc, (yyvsp[0].s), 'S');
           add_pcc_flag_str(imcc, imcc->cur_call, r);
           mem_sys_free((yyvsp[0].s));
           (yyval.sr) = r;
         }
#line 3460 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 71:
#line 1487 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           SymReg * const r = mk_const(imcc, (yyvsp[0].s), 'S');
           add_pcc_flag_str(imcc, imcc->cur_call, r);
           mem_sys_free((yyvsp[0].s));
           (yyval.sr) = r;
         }
#line 3471 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 72:
#line 1498 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = 0;
           imcc->cur_unit->outer = mk_sub_address_fromc(imcc, (yyvsp[-1].s));
           mem_sys_free((yyvsp[-1].s));
         }
#line 3481 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 73:
#line 1504 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = 0;
           imcc->cur_unit->outer = mk_const(imcc, (yyvsp[-1].s), 'S');
           mem_sys_free((yyvsp[-1].s));
         }
#line 3491 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 74:
#line 1513 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = P_VTABLE;
           imcc->cur_unit->vtable_name      = NULL;
           imcc->cur_unit->is_vtable_method = 1;
         }
#line 3501 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 75:
#line 1519 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = P_VTABLE;
           imcc->cur_unit->vtable_name      = (yyvsp[-1].s);
           imcc->cur_unit->is_vtable_method = 1;
         }
#line 3511 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 76:
#line 1528 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = P_METHOD;
           imcc->cur_unit->method_name = NULL;
           imcc->cur_unit->is_method   = 1;
         }
#line 3521 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 77:
#line 1534 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = P_METHOD;
           imcc->cur_unit->method_name = (yyvsp[-1].s);
           imcc->cur_unit->is_method   = 1;
         }
#line 3531 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 78:
#line 1543 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = P_NSENTRY;
           imcc->cur_unit->ns_entry_name     = NULL;
           imcc->cur_unit->has_ns_entry_name = 1;
         }
#line 3541 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 79:
#line 1549 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = P_NSENTRY;
           imcc->cur_unit->ns_entry_name = (yyvsp[-1].s);
           imcc->cur_unit->has_ns_entry_name = 1;
         }
#line 3551 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 80:
#line 1558 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = 0;
           imcc->cur_unit->instance_of = (yyvsp[-1].s);
         }
#line 3560 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 81:
#line 1566 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.t) = 0;
           imcc->cur_unit->subid = NULL;
         }
#line 3569 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 82:
#line 1571 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           SymReg *r = mk_const(imcc, (yyvsp[-1].s), 'S');
           (yyval.t) = 0;
           imcc->cur_unit->subid = r;
           imcc->cur_unit->instructions->symregs[0]->subid = r;
           mem_sys_free((yyvsp[-1].s));
         }
#line 3581 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 85:
#line 1587 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           char name[128];
           SymReg *r;
           Instruction *i;

           snprintf(name, sizeof (name), "%cpcc_sub_call_%d",
                   IMCC_INTERNAL_CHAR, imcc->cnr++);
           (yyval.sr) = r = mk_pcc_sub(imcc, name, 0);
           /* this mid rule action has the semantic value of the
            * sub SymReg.
            * This is used below to append args & results
            */
           i = iLABEL(imcc, imcc->cur_unit, r);
           imcc->cur_call = r;
           i->type = ITPCCSUB;
         }
#line 3602 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 86:
#line 1608 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; imcc->cur_call = NULL; }
#line 3608 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 87:
#line 1612 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = NULL; imcc->cur_call->pcc_sub->label = 0; }
#line 3614 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 88:
#line 1613 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = NULL; imcc->cur_call->pcc_sub->label = 1; }
#line 3620 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 89:
#line 1617 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = NULL; }
#line 3626 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 90:
#line 1618 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = NULL;  imcc->cur_call->pcc_sub->object = (yyvsp[-1].sr); }
#line 3632 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 91:
#line 1622 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 0; }
#line 3638 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 93:
#line 1627 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = (yyvsp[0].t); }
#line 3644 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 94:
#line 1628 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = (yyvsp[-1].t) | (yyvsp[0].t); }
#line 3650 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 95:
#line 1632 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
                (yyval.t) = P_LOAD;
                /*
                SymReg * const r = mk_const(imcc, "load", 'S');
                add_pcc_flag_str(imcc, imcc->cur_call, r);
                $$ = r;
                */
            }
#line 3663 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 96:
#line 1640 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
                (yyval.t) = P_INIT;
                /*
                SymReg * const r = mk_const(imcc, "load", 'S');
                add_pcc_flag_str(imcc, imcc->cur_call, r);
                $$ = r;
                */
            }
#line 3676 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 97:
#line 1648 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = P_MAIN; }
#line 3682 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 98:
#line 1649 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = P_IMMEDIATE; }
#line 3688 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 99:
#line 1650 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = P_POSTCOMP; }
#line 3694 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 100:
#line 1651 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = P_ANON; }
#line 3700 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 101:
#line 1652 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = P_NEED_LEX; }
#line 3706 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 110:
#line 1665 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           add_pcc_sub(imcc->cur_call, (yyvsp[-3].sr));
           add_pcc_cc(imcc->cur_call, (yyvsp[-1].sr));
         }
#line 3715 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 111:
#line 1670 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           add_pcc_sub(imcc->cur_call, (yyvsp[-1].sr));
         }
#line 3723 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 112:
#line 1676 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = 0; }
#line 3729 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 113:
#line 1678 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
                 if (imcc->adv_named_id) {
                     add_pcc_named_param(imcc, imcc->cur_call,
                                    imcc->adv_named_id, (yyvsp[-1].sr));
                     imcc->adv_named_id = NULL;
                 }
                 else
                     add_pcc_arg(imcc, imcc->cur_call, (yyvsp[-1].sr));
            }
#line 3743 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 114:
#line 1690 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[0].sr); }
#line 3749 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 115:
#line 1695 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = 0; }
#line 3755 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 116:
#line 1697 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if ((yyvsp[-1].sr))
               add_pcc_result(imcc, imcc->cur_call, (yyvsp[-1].sr));
         }
#line 3764 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 117:
#line 1704 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[-1].sr); (yyval.sr)->type |= (yyvsp[0].t); }
#line 3770 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 118:
#line 1705 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->is_def = 1; }
#line 3776 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 119:
#line 1706 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           IdList * const l = (yyvsp[0].idlist);
           (void)mk_ident(imcc, l->id, (yyvsp[-1].t), VTIDENTIFIER);
           imcc->is_def = 0;
           (yyval.sr) = 0;
         }
#line 3787 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 120:
#line 1715 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 0; }
#line 3793 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 121:
#line 1716 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = (yyvsp[-1].t) | (yyvsp[0].t); }
#line 3799 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 122:
#line 1720 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = VT_FLAT;   }
#line 3805 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 123:
#line 1721 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = VT_OPTIONAL; }
#line 3811 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 124:
#line 1722 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = VT_OPT_FLAG; }
#line 3817 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 125:
#line 1723 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = VT_NAMED; }
#line 3823 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 126:
#line 1724 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { adv_named_set(imcc, (yyvsp[-1].s));   (yyval.t) = VT_NAMED; mem_sys_free((yyvsp[-1].s)); }
#line 3829 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 127:
#line 1725 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { adv_named_set_u(imcc, (yyvsp[-1].s)); (yyval.t) = VT_NAMED; mem_sys_free((yyvsp[-1].s)); }
#line 3835 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 128:
#line 1726 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = VT_CALL_SIG; }
#line 3841 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 129:
#line 1731 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { begin_return_or_yield(imcc, 0); }
#line 3847 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 130:
#line 1733 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; imcc->asm_state = AsmDefault; }
#line 3853 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 131:
#line 1735 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc->asm_state = AsmDefault;
           (yyval.i) = 0;
         }
#line 3862 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 132:
#line 1742 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { begin_return_or_yield(imcc, 1); }
#line 3868 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 133:
#line 1744 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; imcc->asm_state = AsmDefault; }
#line 3874 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 134:
#line 1748 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = 0; }
#line 3880 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 135:
#line 1750 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if ((yyvsp[-1].sr))
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[-1].sr));
         }
#line 3889 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 136:
#line 1755 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if ((yyvsp[-1].sr))
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[-1].sr));
         }
#line 3898 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 137:
#line 1762 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = 0; }
#line 3904 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 138:
#line 1764 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if ((yyvsp[-1].sr))
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[-1].sr));
         }
#line 3913 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 139:
#line 1769 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if ((yyvsp[-1].sr))
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[-1].sr));
         }
#line 3922 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 140:
#line 1776 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[-1].sr); (yyval.sr)->type |= (yyvsp[0].t); }
#line 3928 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 141:
#line 1780 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[-1].sr); (yyval.sr)->type |= (yyvsp[0].t); }
#line 3934 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 142:
#line 1785 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
          if (imcc->asm_state == AsmDefault)
              begin_return_or_yield(imcc, (yyvsp[-1].t));
        }
#line 3943 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 143:
#line 1790 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
          imcc->asm_state = AsmDefault;
          (yyval.t) = 0;
        }
#line 3952 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 144:
#line 1797 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 0; }
#line 3958 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 145:
#line 1798 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 1; }
#line 3964 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 146:
#line 1802 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 3970 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 147:
#line 1804 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if (imcc->adv_named_id) {
               add_pcc_named_return(imcc, imcc->sr_return,
                                    imcc->adv_named_id, (yyvsp[0].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[0].sr));
         }
#line 3984 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 148:
#line 1814 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            SymReg * const name = mk_const(imcc, (yyvsp[-2].s), 'S');
            add_pcc_named_return(imcc, imcc->sr_return, name, (yyvsp[0].sr));
         }
#line 3993 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 149:
#line 1819 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if (imcc->adv_named_id) {
               add_pcc_named_return(imcc, imcc->sr_return,
                                    imcc->adv_named_id, (yyvsp[0].sr));
               imcc->adv_named_id = NULL;
             }
             else
                 add_pcc_result(imcc, imcc->sr_return, (yyvsp[0].sr));
         }
#line 4007 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 150:
#line 1829 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           SymReg * const name = mk_const(imcc, (yyvsp[-2].s), 'S');
           add_pcc_named_return(imcc, imcc->sr_return, name, (yyvsp[0].sr));
         }
#line 4016 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 153:
#line 1850 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { clear_state(imcc); }
#line 4022 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 154:
#line 1854 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 4028 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 155:
#line 1856 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[0].i); }
#line 4034 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 156:
#line 1857 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 4040 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 157:
#line 1858 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 4046 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 158:
#line 1859 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 4052 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 159:
#line 1860 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[0].i); }
#line 4058 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 160:
#line 1864 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = NULL; }
#line 4064 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 164:
#line 1875 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
             Instruction * const i = iLABEL(imcc, imcc->cur_unit,
                    mk_local_label(imcc, (yyvsp[0].s)));
             mem_sys_free((yyvsp[0].s));
             (yyval.i) = i;
         }
#line 4075 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 165:
#line 1886 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[-1].i); }
#line 4081 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 166:
#line 1888 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           if (yynerrs >= PARROT_MAX_RECOVER_ERRORS) {
               IMCC_warning(imcc, "Too many errors. Correct some first.\n");
               YYABORT;
           }
           yyerrok;
         }
#line 4093 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 167:
#line 1899 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           IdList* const l = (yyvsp[0].idlist);
           l->next = NULL;
           (yyval.idlist) = l;
         }
#line 4103 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 168:
#line 1906 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           IdList* const l = (yyvsp[0].idlist);
           l->next = (yyvsp[-2].idlist);
           (yyval.idlist) = l;
         }
#line 4113 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 169:
#line 1915 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           IdList* const l = mem_gc_allocate_n_zeroed_typed(imcc->interp, 1, IdList);
           l->id           = (yyvsp[0].s);
           (yyval.idlist) = l;
         }
#line 4123 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 172:
#line 1925 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->is_def = 1; }
#line 4129 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 173:
#line 1926 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           IdList *l = (yyvsp[0].idlist);
           while (l) {
               IdList *l1;
               mk_ident(imcc, l->id, (yyvsp[-1].t), VTIDENTIFIER);
               l1 = l;
               l  = l->next;
               mem_sys_free(l1->id);
               mem_sys_free(l1);
           }
           imcc->is_def = 0; (yyval.i) = 0;
         }
#line 4146 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 174:
#line 1939 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           SymReg *n;
           char   *name;
           if (*(yyvsp[-2].s) == '"') {
               STRING *unescaped = Parrot_str_unescape(imcc->interp, (yyvsp[-2].s) + 1, '"', NULL);
               name              = Parrot_str_to_cstring(imcc->interp, unescaped);
           }
           else {
               name = mem_sys_strdup((yyvsp[-2].s) + 1);
               name[strlen(name) - 1] = 0;
           }
           n = mk_const(imcc, name, 'S');
           set_lexical(imcc, (yyvsp[0].sr), n);
           (yyval.i) = 0;
           mem_sys_free((yyvsp[-2].s));
           mem_sys_free(name);
         }
#line 4168 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 175:
#line 1957 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           SymReg *n = mk_const(imcc, (yyvsp[-2].s), 'U');
           set_lexical(imcc, (yyvsp[0].sr), n); (yyval.i) = 0;
           mem_sys_free((yyvsp[-2].s));
         }
#line 4178 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 176:
#line 1962 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->is_def = 1; }
#line 4184 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 177:
#line 1963 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           mk_const_ident(imcc, (yyvsp[-2].s), (yyvsp[-3].t), (yyvsp[0].sr), 0);
           imcc->is_def = 0;
           mem_sys_free((yyvsp[-2].s));
         }
#line 4194 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 179:
#line 1970 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->is_def = 1; }
#line 4200 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 180:
#line 1971 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           mk_const_ident(imcc, (yyvsp[-2].s), (yyvsp[-3].t), (yyvsp[0].sr), 1);
           imcc->is_def = 0;
           mem_sys_free((yyvsp[-2].s));
         }
#line 4210 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 181:
#line 1977 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = NULL;
           imcc->cur_call->pcc_sub->tailcall = 1;
           imcc->cur_call = NULL;
         }
#line 4220 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 182:
#line 1983 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            (yyval.i) = MK_I(imcc, imcc->cur_unit, "branch", 1, (yyvsp[0].sr));
         }
#line 4228 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 183:
#line 1987 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = INS(imcc, imcc->cur_unit, (yyvsp[-1].s), 0, imcc->regs, imcc->nargs,
                    imcc->keyvec, 1);
           mem_sys_free((yyvsp[-1].s));
         }
#line 4238 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 184:
#line 1992 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, "null", 1, (yyvsp[0].sr));
                    (yyval.i)->type = ITPUREFUNC; }
#line 4245 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 185:
#line 1994 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; imcc->cur_call = NULL; }
#line 4251 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 186:
#line 1995 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0; }
#line 4257 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 189:
#line 1998 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = 0;}
#line 4263 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 190:
#line 2002 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {(yyval.t) = 'I'; }
#line 4269 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 191:
#line 2003 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 'N'; }
#line 4275 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 192:
#line 2004 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 'S'; }
#line 4281 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 193:
#line 2005 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 'P'; }
#line 4287 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 194:
#line 2010 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, "set", 2, (yyvsp[-2].sr), (yyvsp[0].sr));  }
#line 4293 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 195:
#line 2012 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, (yyvsp[-1].s), 2, (yyvsp[-3].sr), (yyvsp[0].sr));
              (yyval.i)->type = ITPUREFUNC; }
#line 4300 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 196:
#line 2015 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, (yyvsp[-1].s), 3, (yyvsp[-4].sr), (yyvsp[-2].sr), (yyvsp[0].sr));
              (yyval.i)->type = ITPUREFUNC; }
#line 4307 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 197:
#line 2018 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = iINDEXFETCH(imcc, imcc->cur_unit, (yyvsp[-5].sr), (yyvsp[-3].sr), (yyvsp[-1].sr)); }
#line 4313 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 198:
#line 2020 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = iINDEXSET(imcc, imcc->cur_unit, (yyvsp[-5].sr), (yyvsp[-3].sr), (yyvsp[0].sr)); }
#line 4319 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 199:
#line 2023 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           add_pcc_result(imcc, (yyvsp[0].i)->symregs[0], (yyvsp[-2].sr));
           imcc->cur_call = NULL;
           (yyval.i) = 0;
         }
#line 4329 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 200:
#line 2029 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = IMCC_create_itcall_label(imcc);
         }
#line 4337 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 201:
#line 2033 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           IMCC_itcall_sub(imcc, (yyvsp[-3].sr));
           imcc->cur_call = NULL;
         }
#line 4346 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 205:
#line 2041 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "null", 1, (yyvsp[-2].sr));
           (yyval.i)->type = ITPUREFUNC;
         }
#line 4355 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 206:
#line 2049 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"not"; }
#line 4361 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 207:
#line 2050 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"bnot"; }
#line 4367 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 208:
#line 2051 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"neg"; }
#line 4373 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 209:
#line 2055 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"sub"; }
#line 4379 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 210:
#line 2056 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"add"; }
#line 4385 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 211:
#line 2057 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"mul"; }
#line 4391 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 212:
#line 2058 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"div"; }
#line 4397 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 213:
#line 2059 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"mod"; }
#line 4403 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 214:
#line 2060 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"fdiv"; }
#line 4409 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 215:
#line 2061 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"pow"; }
#line 4415 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 216:
#line 2062 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"concat"; }
#line 4421 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 217:
#line 2063 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"iseq"; }
#line 4427 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 218:
#line 2064 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"isne"; }
#line 4433 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 219:
#line 2065 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"isgt"; }
#line 4439 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 220:
#line 2066 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"isge"; }
#line 4445 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 221:
#line 2067 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"islt"; }
#line 4451 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 222:
#line 2068 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"isle"; }
#line 4457 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 223:
#line 2069 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"shl"; }
#line 4463 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 224:
#line 2070 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"shr"; }
#line 4469 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 225:
#line 2071 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"lsr"; }
#line 4475 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 226:
#line 2072 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"and"; }
#line 4481 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 227:
#line 2073 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"or"; }
#line 4487 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 228:
#line 2074 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"xor"; }
#line 4493 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 229:
#line 2075 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"band"; }
#line 4499 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 230:
#line 2076 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"bor"; }
#line 4505 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 231:
#line 2077 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"bxor"; }
#line 4511 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 232:
#line 2083 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = IMCC_create_itcall_label(imcc);
           (yyval.i)->type &= ~ITCALL;
           (yyval.i)->type |= ITRESULT;
         }
#line 4521 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 233:
#line 2088 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {  (yyval.i) = 0; }
#line 4527 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 234:
#line 2095 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, (yyvsp[-1].s), 2, (yyvsp[-2].sr), (yyvsp[0].sr));
           (yyval.i)->type = ITPUREFUNC; }
#line 4534 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 235:
#line 2098 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
             if ((yyvsp[-2].sr)->set == 'P')
                 (yyval.i) = MK_I(imcc, imcc->cur_unit, "concat", 2, (yyvsp[-2].sr), (yyvsp[0].sr));
             else
                 (yyval.i) = MK_I(imcc, imcc->cur_unit, "concat", 3, (yyvsp[-2].sr), (yyvsp[-2].sr), (yyvsp[0].sr));
             (yyval.i)->type = ITPUREFUNC;
         }
#line 4546 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 236:
#line 2108 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"add"; }
#line 4552 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 237:
#line 2109 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"sub"; }
#line 4558 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 238:
#line 2110 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"mul"; }
#line 4564 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 239:
#line 2111 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"div"; }
#line 4570 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 240:
#line 2112 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"mod"; }
#line 4576 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 241:
#line 2113 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"fdiv"; }
#line 4582 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 242:
#line 2114 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"band"; }
#line 4588 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 243:
#line 2115 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"bor"; }
#line 4594 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 244:
#line 2116 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"bxor"; }
#line 4600 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 245:
#line 2117 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"shr"; }
#line 4606 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 246:
#line 2118 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"shl"; }
#line 4612 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 247:
#line 2119 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"lsr"; }
#line 4618 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 248:
#line 2125 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
        (yyval.i) = func_ins(imcc, imcc->cur_unit, (yyvsp[-3].sr), (yyvsp[-1].s), imcc -> regs,
                      imcc -> nargs, imcc -> keyvec, 1);
         mem_sys_free((yyvsp[-1].s));
       }
#line 4628 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 249:
#line 2133 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_sub_address(imcc, (yyvsp[0].s));       mem_sys_free((yyvsp[0].s)); }
#line 4634 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 250:
#line 2134 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_sub_address_fromc(imcc, (yyvsp[0].s)); mem_sys_free((yyvsp[0].s)); }
#line 4640 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 251:
#line 2135 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_sub_address_u(imcc, (yyvsp[0].s));     mem_sys_free((yyvsp[0].s)); }
#line 4646 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 252:
#line 2137 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = (yyvsp[0].sr);
           if ((yyvsp[0].sr)->set != 'P')
               IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR, "Sub isn't a PMC");
         }
#line 4656 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 253:
#line 2143 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            /* disallow bareword method names; SREG name constants are fine */
            const char * const name = (yyvsp[0].sr)->name;
            if (!((yyvsp[0].sr)->type & VTREG)) {
                if (*name != '\'' && *name != '\"')
                    IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                        "Bareword method name '%s' not allowed in PIR",
                        name);
            }

            imcc->cur_obj = (yyvsp[-2].sr);
            (yyval.sr) = (yyvsp[0].sr);
        }
#line 4674 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 254:
#line 2157 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            imcc->cur_obj = (yyvsp[-2].sr);
            (yyval.sr) = mk_const(imcc, (yyvsp[0].s), 'U');
            mem_sys_free((yyvsp[0].s));
         }
#line 4684 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 255:
#line 2163 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            imcc->cur_obj = (yyvsp[-2].sr);
            (yyval.sr) = mk_const(imcc, (yyvsp[0].s), 'S');
            mem_sys_free((yyvsp[0].s));
         }
#line 4694 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 256:
#line 2169 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            imcc->cur_obj = (yyvsp[-2].sr);
            (yyval.sr) = (yyvsp[0].sr);
        }
#line 4703 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 257:
#line 2178 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = IMCC_create_itcall_label(imcc);
           IMCC_itcall_sub(imcc, (yyvsp[0].sr));
         }
#line 4712 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 258:
#line 2182 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[-3].i); }
#line 4718 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 259:
#line 2186 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = 0; }
#line 4724 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 260:
#line 2188 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = 0;
           if (imcc->adv_named_id) {
               add_pcc_named_arg(imcc, imcc->cur_call, imcc->adv_named_id, (yyvsp[0].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_arg(imcc, imcc->cur_call, (yyvsp[0].sr));
         }
#line 4738 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 261:
#line 2198 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = 0;
           if (imcc->adv_named_id) {
               add_pcc_named_arg(imcc, imcc->cur_call, imcc->adv_named_id, (yyvsp[0].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_arg(imcc, imcc->cur_call, (yyvsp[0].sr));
         }
#line 4752 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 262:
#line 2208 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = 0;
           add_pcc_named_arg(imcc, imcc->cur_call, mk_const(imcc, (yyvsp[-2].s), 'S'), (yyvsp[0].sr));
           mem_sys_free((yyvsp[-2].s));
         }
#line 4762 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 263:
#line 2214 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = 0;
           add_pcc_named_arg_var(imcc, imcc->cur_call, (yyvsp[-2].sr), (yyvsp[0].sr));
         }
#line 4771 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 264:
#line 2228 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = 0;
           add_pcc_named_arg(imcc, imcc->cur_call,
                mk_const(imcc, (yyvsp[-2].s), 'S'), (yyvsp[0].sr));
           mem_sys_free((yyvsp[-2].s));
         }
#line 4782 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 265:
#line 2237 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[-1].sr); (yyval.sr)->type |= (yyvsp[0].t); }
#line 4788 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 266:
#line 2241 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 0; }
#line 4794 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 267:
#line 2242 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = (yyvsp[-1].t) | (yyvsp[0].t); }
#line 4800 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 268:
#line 2246 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = VT_FLAT;     }
#line 4806 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 269:
#line 2247 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = VT_NAMED;    }
#line 4812 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 270:
#line 2248 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = VT_CALL_SIG; }
#line 4818 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 271:
#line 2251 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            adv_named_set_u(imcc, (yyvsp[-1].s));
            mem_sys_free((yyvsp[-1].s));
            (yyval.t) = 0;
        }
#line 4828 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 272:
#line 2257 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            adv_named_set(imcc, (yyvsp[-1].s));
            mem_sys_free((yyvsp[-1].s));
            (yyval.t) = 0;
        }
#line 4838 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 273:
#line 2265 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[-1].sr); (yyval.sr)->type |= (yyvsp[0].t); }
#line 4844 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 274:
#line 2270 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = 0;
           if (imcc->adv_named_id) {
               add_pcc_named_result(imcc, imcc->cur_call, imcc->adv_named_id, (yyvsp[0].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_result(imcc, imcc->cur_call, (yyvsp[0].sr));
         }
#line 4858 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 275:
#line 2280 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
            add_pcc_named_result(imcc, imcc->cur_call,
                    mk_const(imcc, (yyvsp[-2].s), 'S'), (yyvsp[0].sr));
            mem_sys_free((yyvsp[-2].s));
         }
#line 4868 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 276:
#line 2286 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = 0;
           if (imcc->adv_named_id) {
               add_pcc_named_result(imcc, imcc->cur_call, imcc->adv_named_id, (yyvsp[0].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_result(imcc, imcc->cur_call, (yyvsp[0].sr));
         }
#line 4882 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 277:
#line 2296 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           add_pcc_named_result(imcc, imcc->cur_call, mk_const(imcc, (yyvsp[-2].s), 'S'), (yyvsp[0].sr));
           mem_sys_free((yyvsp[-2].s));
         }
#line 4891 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 278:
#line 2300 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = 0; }
#line 4897 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 279:
#line 2304 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[0].i); }
#line 4903 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 280:
#line 2305 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.i) = (yyvsp[0].i); }
#line 4909 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 281:
#line 2310 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, inv_op((yyvsp[-3].s)), 3, (yyvsp[-4].sr), (yyvsp[-2].sr), (yyvsp[0].sr));
         }
#line 4917 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 282:
#line 2314 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "unless_null", 2, (yyvsp[-2].sr), (yyvsp[0].sr));
         }
#line 4925 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 283:
#line 2318 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "unless", 2, (yyvsp[-2].sr), (yyvsp[0].sr));
         }
#line 4933 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 284:
#line 2325 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "if", 2, (yyvsp[-2].sr), (yyvsp[0].sr));
         }
#line 4941 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 285:
#line 2329 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, (yyvsp[-3].s), 3, (yyvsp[-4].sr), (yyvsp[-2].sr), (yyvsp[0].sr));
         }
#line 4949 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 286:
#line 2333 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "if_null", 2, (yyvsp[-2].sr), (yyvsp[0].sr));
         }
#line 4957 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 287:
#line 2339 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 0; }
#line 4963 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 288:
#line 2340 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.t) = 0; }
#line 4969 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 289:
#line 2344 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"eq"; }
#line 4975 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 290:
#line 2345 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"ne"; }
#line 4981 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 291:
#line 2346 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"gt"; }
#line 4987 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 292:
#line 2347 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"ge"; }
#line 4993 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 293:
#line 2348 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"lt"; }
#line 4999 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 294:
#line 2349 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.s) = (char *)"le"; }
#line 5005 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 297:
#line 2358 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = NULL; }
#line 5011 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 298:
#line 2359 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[0].sr); }
#line 5017 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 299:
#line 2363 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = imcc->regs[0]; }
#line 5023 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 301:
#line 2368 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->regs[imcc->nargs++] = (yyvsp[0].sr); }
#line 5029 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 302:
#line 2370 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc -> regs[imcc->nargs++] = (yyvsp[-3].sr);
           imcc -> keyvec |= KEY_BIT(imcc->nargs);
           imcc -> regs[imcc->nargs++] = (yyvsp[-1].sr);
           (yyval.sr) = (yyvsp[-3].sr);
         }
#line 5040 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 303:
#line 2377 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc -> regs[imcc->nargs++] = (yyvsp[-1].sr);
           (yyval.sr) = (yyvsp[-1].sr);
         }
#line 5049 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 305:
#line 2384 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_sub_address_fromc(imcc, (yyvsp[0].s)); mem_sys_free((yyvsp[0].s)); }
#line 5055 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 306:
#line 2385 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_sub_address_u(imcc, (yyvsp[0].s));     mem_sys_free((yyvsp[0].s)); }
#line 5061 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 307:
#line 2389 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_sub_address(imcc, (yyvsp[0].s)); mem_sys_free((yyvsp[0].s)); }
#line 5067 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 308:
#line 2390 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_sub_address(imcc, (yyvsp[0].s)); mem_sys_free((yyvsp[0].s)); }
#line 5073 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 309:
#line 2394 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_label_address(imcc, (yyvsp[0].s)); mem_sys_free((yyvsp[0].s)); }
#line 5079 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 310:
#line 2395 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_label_address(imcc, (yyvsp[0].s)); mem_sys_free((yyvsp[0].s)); }
#line 5085 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 315:
#line 2409 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc->nkeys    = 0;
         }
#line 5093 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 316:
#line 2413 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = link_keys(imcc, imcc->nkeys, imcc->keys, 0);
         }
#line 5101 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 317:
#line 2419 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc->nkeys = 0;
         }
#line 5109 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 318:
#line 2423 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = link_keys(imcc,
                          imcc->nkeys,
                          imcc->keys, 1);
         }
#line 5119 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 319:
#line 2431 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { imcc->keys[imcc->nkeys++] = (yyvsp[0].sr); }
#line 5125 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 320:
#line 2433 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           imcc->keys[imcc->nkeys++] = (yyvsp[0].sr);
           (yyval.sr) = imcc->keys[0];
         }
#line 5134 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 321:
#line 2441 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    {
           (yyval.sr) = (yyvsp[0].sr);
         }
#line 5142 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 322:
#line 2447 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_symreg(imcc, (yyvsp[0].s), 'I'); }
#line 5148 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 323:
#line 2448 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_symreg(imcc, (yyvsp[0].s), 'N'); }
#line 5154 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 324:
#line 2449 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_symreg(imcc, (yyvsp[0].s), 'S'); }
#line 5160 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 325:
#line 2450 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_symreg(imcc, (yyvsp[0].s), 'P'); }
#line 5166 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 326:
#line 2451 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_pasm_reg(imcc, (yyvsp[0].s)); mem_sys_free((yyvsp[0].s)); }
#line 5172 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 327:
#line 2455 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_const(imcc, (yyvsp[0].s), 'S'); mem_sys_free((yyvsp[0].s)); }
#line 5178 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 328:
#line 2456 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_const(imcc, (yyvsp[0].s), 'U'); mem_sys_free((yyvsp[0].s)); }
#line 5184 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 329:
#line 2460 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_const(imcc, (yyvsp[0].s), 'I'); mem_sys_free((yyvsp[0].s)); }
#line 5190 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 330:
#line 2461 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = mk_const(imcc, (yyvsp[0].s), 'N'); mem_sys_free((yyvsp[0].s)); }
#line 5196 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;

  case 331:
#line 2462 "compilers/imcc/imcc.y" /* yacc.c:1646  */
    { (yyval.sr) = (yyvsp[0].sr); }
#line 5202 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
    break;


#line 5206 "compilers/imcc/imcparser.c" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (yyscanner, imcc, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yyscanner, imcc, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, yyscanner, imcc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yyscanner, imcc);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (yyscanner, imcc, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, yyscanner, imcc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp, yyscanner, imcc);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 2466 "compilers/imcc/imcc.y" /* yacc.c:1906  */


/* I need this prototype somewhere... */
char *yyget_text(yyscan_t yyscanner);

/* I do not like this function, but, atm, it is the only way I can
 * make the code in yyerror work without segfault on some specific
 * cases.
 */
/* int yyholds_char(yyscan_t yyscanner); */

int yyerror(void *yyscanner, ARGMOD(imc_info_t *imcc), const char *s)
{
    /* If the error occurr in the end of the buffer (I mean, the last
     * token was already read), yyget_text will return a pointer
     * outside the bison buffer, and thus, not "accessible" by
     * us. This means it may segfault. */
    const char * const chr = yyget_text((yyscan_t)yyscanner);

    /* IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR, s); */
    /* --- This was called before, not sure if I should call some
           similar function that does not die like this one. */

    /* Basically, if current token is a newline, it mean the error was
     * before the newline, and thus, line is the line *after* the
     * error. Instead of duplicating code for both cases (the 'newline' and
     * non-newline case, do the test twice; efficiency is not important when
     * we have an error anyway. */
    if (!at_eof(yyscanner)) {
        IMCC_warning(imcc, "error:imcc:%s", s);

        /* don't print the current token if it is a newline */
        if (*chr != '\n')
            IMCC_warning(imcc, " ('%s')", chr);

        IMCC_print_inc(imcc);
    }

    /* scanner is at EOF; just to be sure, don't print "current" token */
    else {
        IMCC_warning(imcc, "error:imcc:%s", s);
        IMCC_print_inc(imcc);
    }

    return 0;
}

/*

=back

 */
/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4 cinoptions='\:2=2' :
 */
