/* Generator is (c) James Ponder, 1997-2001 http://www.squish.net/generator/ */
#ifndef _TAB68K_H_
#define _TAB68K_H_

#include "generator.h"

const char *condition_table[] = {
  "T", "F",
  "HI", "LS",
  "CC", "CS",
  "NE", "EQ",
  "VC", "VS",
  "PL", "MI",
  "GE", "LT",
  "GT", "LE"
};

t_mnemonic_table mnemonic_table[] = {
  { i_ILLG,     "ILLEGAL" },
  { i_OR,       "OR" },
  { i_ORSR,     "ORSR" },
  { i_AND,      "AND" },
  { i_ANDSR,    "ANDSR" },
  { i_EOR,      "EOR" },
  { i_EORSR,    "EORSR" },
  { i_SUB,      "SUB" },
  { i_SUBA,     "SUBA" },
  { i_SUBX,     "SUBX" },
  { i_ADD,      "ADD" },
  { i_ADDA,     "ADDA" },
  { i_ADDX,     "ADDX" },
  { i_MULU,     "MULU" },
  { i_MULS,     "MULS" },
  { i_CMP,      "CMP" },
  { i_CMPA,     "CMPA" },
  { i_BTST,     "BTST" },
  { i_BCHG,     "BCHG" },
  { i_BCLR,     "BCLR" },
  { i_BSET,     "BSET" },
  { i_MOVE,     "MOVE" },
  { i_MOVEA,    "MOVEA" },
  { i_MOVEPMR,  "MOVEPMR" },
  { i_MOVEPRM,  "MOVEPRM" },
  { i_MOVEFSR,  "MOVEFSR" },
  { i_MOVETSR,  "MOVETSR" },
  { i_MOVEMRM,  "MOVEMRM" },
  { i_MOVEMMR,  "MOVEMMR" },
  { i_MOVETUSP, "MOVETUSP" },
  { i_MOVEFUSP, "MOVEFUSP" },
  { i_NEG,      "NEG" },
  { i_NEGX,     "NEGX" },
  { i_CLR,      "CLR" },
  { i_NOT,      "NOT" },
  { i_ABCD,     "ABCD" },
  { i_SBCD,     "SBCD" },
  { i_NBCD,     "NBCD" },
  { i_SWAP,     "SWAP" },
  { i_PEA,      "PEA" },
  { i_LEA,      "LEA" },
  { i_EXT,      "EXT" },
  { i_EXG,      "EXG" },
  { i_TST,      "TST" },
  { i_TAS,      "TAS" },
  { i_CHK,      "CHK" },
  { i_TRAPV,    "TRAPV" },
  { i_TRAP,     "TRAP" },
  { i_RESET,    "RESET" },
  { i_NOP,      "NOP" },
  { i_STOP,     "STOP" },
  { i_LINK,     "LINK" },
  { i_UNLK,     "UNLK" },
  { i_RTE,      "RTE" },
  { i_RTS,      "RTS" },
  { i_RTR,      "RTR" },
  { i_JSR,      "JSR" },
  { i_JMP,      "JMP" },
  { i_Scc,      "Scc" },
  { i_SF,       "SF" },
  { i_DBcc,     "DBcc" },
  { i_DBRA,     "DBRA" },
  { i_Bcc,      "Bcc" },
  { i_BSR,      "BSR" },
  { i_DIVU,     "DIVU" },
  { i_DIVS,     "DIVS" },
  { i_ASR,      "ASR" },
  { i_LSR,      "LSR" },
  { i_ROXR,     "ROXR" },
  { i_ROR,      "ROR" },
  { i_ASL,      "ASL" },
  { i_LSL,      "LSL" },
  { i_ROXL,     "ROXL" },
  { i_ROL,      "ROL" },
  { i_LINE10,   "LINE10" },
  { i_LINE15,   "LINE15" },
  { i_ILLG,     "" },
};

#endif
