// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#include "google/cloud/storageinsights/v1/internal/storage_insights_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace storageinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

StorageInsightsTracingConnection::StorageInsightsTracingConnection(
    std::shared_ptr<storageinsights_v1::StorageInsightsConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsTracingConnection::ListReportConfigs(
    google::cloud::storageinsights::v1::ListReportConfigsRequest request) {
  auto span = internal::MakeSpan(
      "storageinsights_v1::StorageInsightsConnection::ListReportConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListReportConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::storageinsights::v1::ReportConfig>(std::move(span),
                                                        std::move(sr));
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsTracingConnection::GetReportConfig(
    google::cloud::storageinsights::v1::GetReportConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "storageinsights_v1::StorageInsightsConnection::GetReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetReportConfig(request));
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsTracingConnection::CreateReportConfig(
    google::cloud::storageinsights::v1::CreateReportConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "storageinsights_v1::StorageInsightsConnection::CreateReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateReportConfig(request));
}

StatusOr<google::cloud::storageinsights::v1::ReportConfig>
StorageInsightsTracingConnection::UpdateReportConfig(
    google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "storageinsights_v1::StorageInsightsConnection::UpdateReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateReportConfig(request));
}

Status StorageInsightsTracingConnection::DeleteReportConfig(
    google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "storageinsights_v1::StorageInsightsConnection::DeleteReportConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteReportConfig(request));
}

StreamRange<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsTracingConnection::ListReportDetails(
    google::cloud::storageinsights::v1::ListReportDetailsRequest request) {
  auto span = internal::MakeSpan(
      "storageinsights_v1::StorageInsightsConnection::ListReportDetails");
  internal::OTelScope scope(span);
  auto sr = child_->ListReportDetails(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::storageinsights::v1::ReportDetail>(std::move(span),
                                                        std::move(sr));
}

StatusOr<google::cloud::storageinsights::v1::ReportDetail>
StorageInsightsTracingConnection::GetReportDetail(
    google::cloud::storageinsights::v1::GetReportDetailRequest const& request) {
  auto span = internal::MakeSpan(
      "storageinsights_v1::StorageInsightsConnection::GetReportDetail");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetReportDetail(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<storageinsights_v1::StorageInsightsConnection>
MakeStorageInsightsTracingConnection(
    std::shared_ptr<storageinsights_v1::StorageInsightsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<StorageInsightsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1_internal
}  // namespace cloud
}  // namespace google
