// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedidentities/v1/managed_identities_service.proto

#include "google/cloud/managedidentities/v1/internal/managed_identities_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/managedidentities/v1/managed_identities_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace managedidentities_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ManagedIdentitiesServiceMetadata::ManagedIdentitiesServiceMetadata(
    std::shared_ptr<ManagedIdentitiesServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::longrunning::Operation>>
ManagedIdentitiesServiceMetadata::AsyncCreateMicrosoftAdDomain(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::managedidentities::v1::CreateMicrosoftAdDomainRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateMicrosoftAdDomain(cq, std::move(context),
                                              std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ManagedIdentitiesServiceMetadata::CreateMicrosoftAdDomain(
    grpc::ClientContext& context, Options options,
    google::cloud::managedidentities::v1::CreateMicrosoftAdDomainRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateMicrosoftAdDomain(context, options, request);
}

StatusOr<google::cloud::managedidentities::v1::ResetAdminPasswordResponse>
ManagedIdentitiesServiceMetadata::ResetAdminPassword(
    grpc::ClientContext& context, Options const& options,
    google::cloud::managedidentities::v1::ResetAdminPasswordRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ResetAdminPassword(context, options, request);
}

StatusOr<google::cloud::managedidentities::v1::ListDomainsResponse>
ManagedIdentitiesServiceMetadata::ListDomains(
    grpc::ClientContext& context, Options const& options,
    google::cloud::managedidentities::v1::ListDomainsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDomains(context, options, request);
}

StatusOr<google::cloud::managedidentities::v1::Domain>
ManagedIdentitiesServiceMetadata::GetDomain(
    grpc::ClientContext& context, Options const& options,
    google::cloud::managedidentities::v1::GetDomainRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDomain(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ManagedIdentitiesServiceMetadata::AsyncUpdateDomain(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::managedidentities::v1::UpdateDomainRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("domain.name=",
                           internal::UrlEncode(request.domain().name())));
  return child_->AsyncUpdateDomain(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation>
ManagedIdentitiesServiceMetadata::UpdateDomain(
    grpc::ClientContext& context, Options options,
    google::cloud::managedidentities::v1::UpdateDomainRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("domain.name=",
                           internal::UrlEncode(request.domain().name())));
  return child_->UpdateDomain(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ManagedIdentitiesServiceMetadata::AsyncDeleteDomain(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::managedidentities::v1::DeleteDomainRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteDomain(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation>
ManagedIdentitiesServiceMetadata::DeleteDomain(
    grpc::ClientContext& context, Options options,
    google::cloud::managedidentities::v1::DeleteDomainRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteDomain(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ManagedIdentitiesServiceMetadata::AsyncAttachTrust(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::managedidentities::v1::AttachTrustRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncAttachTrust(cq, std::move(context), std::move(options),
                                  request);
}

StatusOr<google::longrunning::Operation>
ManagedIdentitiesServiceMetadata::AttachTrust(
    grpc::ClientContext& context, Options options,
    google::cloud::managedidentities::v1::AttachTrustRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AttachTrust(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ManagedIdentitiesServiceMetadata::AsyncReconfigureTrust(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::managedidentities::v1::ReconfigureTrustRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncReconfigureTrust(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ManagedIdentitiesServiceMetadata::ReconfigureTrust(
    grpc::ClientContext& context, Options options,
    google::cloud::managedidentities::v1::ReconfigureTrustRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ReconfigureTrust(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ManagedIdentitiesServiceMetadata::AsyncDetachTrust(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::managedidentities::v1::DetachTrustRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDetachTrust(cq, std::move(context), std::move(options),
                                  request);
}

StatusOr<google::longrunning::Operation>
ManagedIdentitiesServiceMetadata::DetachTrust(
    grpc::ClientContext& context, Options options,
    google::cloud::managedidentities::v1::DetachTrustRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DetachTrust(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ManagedIdentitiesServiceMetadata::AsyncValidateTrust(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::managedidentities::v1::ValidateTrustRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncValidateTrust(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation>
ManagedIdentitiesServiceMetadata::ValidateTrust(
    grpc::ClientContext& context, Options options,
    google::cloud::managedidentities::v1::ValidateTrustRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ValidateTrust(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ManagedIdentitiesServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> ManagedIdentitiesServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void ManagedIdentitiesServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void ManagedIdentitiesServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                                   Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedidentities_v1_internal
}  // namespace cloud
}  // namespace google
