// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkehub/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEHUB_V1_GKE_HUB_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEHUB_V1_GKE_HUB_CLIENT_H

#include "google/cloud/gkehub/v1/gke_hub_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace gkehub_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The GKE Hub service handles the registration of many Kubernetes clusters to
/// Google Cloud, and the management of multi-cluster features over those
/// clusters.
///
/// The GKE Hub service operates on the following resources:
///
/// * [Membership][google.cloud.gkehub.v1.Membership]
/// * [Feature][google.cloud.gkehub.v1.Feature]
///
/// GKE Hub is currently available in the global region and all regions in
/// https://cloud.google.com/compute/docs/regions-zones. Feature is only
/// available in global region while membership is global region and all the
/// regions.
///
/// **Membership management may be non-trivial:** it is recommended to use one
/// of the Google-provided client libraries or tools where possible when working
/// with Membership resources.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.gkehub.v1.Feature]:
/// @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
/// [google.cloud.gkehub.v1.Membership]:
/// @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
///
class GkeHubClient {
 public:
  explicit GkeHubClient(std::shared_ptr<GkeHubConnection> connection,
                        Options opts = {});
  ~GkeHubClient();

  ///@{
  /// @name Copy and move support
  GkeHubClient(GkeHubClient const&) = default;
  GkeHubClient& operator=(GkeHubClient const&) = default;
  GkeHubClient(GkeHubClient&&) = default;
  GkeHubClient& operator=(GkeHubClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(GkeHubClient const& a, GkeHubClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(GkeHubClient const& a, GkeHubClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists Memberships in a given project and location.
  ///
  /// @param parent  Required. The parent (project and location) where the Memberships will be
  ///  listed. Specified in the format `projects/*/locations/*`.
  ///  `projects/*/locations/-` list memberships in all the regions.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkehub.v1.Membership], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.ListMembershipsRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L196}
  /// [google.cloud.gkehub.v1.Membership]: @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::gkehub::v1::Membership> ListMemberships(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Memberships in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.ListMembershipsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkehub.v1.Membership], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.ListMembershipsRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L196}
  /// [google.cloud.gkehub.v1.Membership]: @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::gkehub::v1::Membership> ListMemberships(
      google::cloud::gkehub::v1::ListMembershipsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Features in a given project and location.
  ///
  /// @param parent  Required. The parent (project and location) where the Features will be listed.
  ///  Specified in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkehub.v1.Feature], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.Feature]: @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
  /// [google.cloud.gkehub.v1.ListFeaturesRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L457}
  ///
  // clang-format on
  StreamRange<google::cloud::gkehub::v1::Feature> ListFeatures(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Features in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.ListFeaturesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.gkehub.v1.Feature], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.Feature]: @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
  /// [google.cloud.gkehub.v1.ListFeaturesRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L457}
  ///
  // clang-format on
  StreamRange<google::cloud::gkehub::v1::Feature> ListFeatures(
      google::cloud::gkehub::v1::ListFeaturesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a Membership.
  ///
  /// @param name  Required. The Membership resource name in the format
  ///  `projects/*/locations/*/memberships/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkehub.v1.Membership])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.GetMembershipRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L259}
  /// [google.cloud.gkehub.v1.Membership]: @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::gkehub::v1::Membership> GetMembership(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a Membership.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.GetMembershipRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkehub.v1.Membership])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.GetMembershipRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L259}
  /// [google.cloud.gkehub.v1.Membership]: @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::gkehub::v1::Membership> GetMembership(
      google::cloud::gkehub::v1::GetMembershipRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Feature.
  ///
  /// @param name  Required. The Feature resource name in the format
  ///  `projects/*/locations/*/features/*`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkehub.v1.Feature])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.Feature]: @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
  /// [google.cloud.gkehub.v1.GetFeatureRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L511}
  ///
  // clang-format on
  StatusOr<google::cloud::gkehub::v1::Feature> GetFeature(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.GetFeatureRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkehub.v1.Feature])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.Feature]: @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
  /// [google.cloud.gkehub.v1.GetFeatureRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L511}
  ///
  // clang-format on
  StatusOr<google::cloud::gkehub::v1::Feature> GetFeature(
      google::cloud::gkehub::v1::GetFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Membership.
  ///
  /// **This is currently only supported for GKE clusters on Google Cloud**.
  /// To register other clusters, follow the instructions at
  /// https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
  ///
  /// @param parent  Required. The parent (project and location) where the Memberships will be
  ///  created. Specified in the format `projects/*/locations/*`.
  /// @param resource  Required. The membership to create.
  /// @param membership_id  Required. Client chosen ID for the membership. `membership_id` must be a
  ///  valid RFC 1123 compliant DNS label:
  ///  @n
  ///    1. At most 63 characters in length
  ///    2. It must consist of lower case alphanumeric characters or `-`
  ///    3. It must start and end with an alphanumeric character
  ///  @n
  ///  Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
  ///  with a maximum length of 63 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.Membership] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.CreateMembershipRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L271}
  /// [google.cloud.gkehub.v1.Membership]: @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Membership>> CreateMembership(
      std::string const& parent,
      google::cloud::gkehub::v1::Membership const& resource,
      std::string const& membership_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMembership
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMembership(
      NoAwaitTag, std::string const& parent,
      google::cloud::gkehub::v1::Membership const& resource,
      std::string const& membership_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Membership.
  ///
  /// **This is currently only supported for GKE clusters on Google Cloud**.
  /// To register other clusters, follow the instructions at
  /// https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.CreateMembershipRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.Membership] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.CreateMembershipRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L271}
  /// [google.cloud.gkehub.v1.Membership]: @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Membership>> CreateMembership(
      google::cloud::gkehub::v1::CreateMembershipRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMembership
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMembership(
      NoAwaitTag,
      google::cloud::gkehub::v1::CreateMembershipRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMembership
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Membership>> CreateMembership(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Adds a new Feature.
  ///
  /// @param parent  Required. The parent (project and location) where the Feature will be created.
  ///  Specified in the format `projects/*/locations/*`.
  /// @param resource  The Feature resource to create.
  /// @param feature_id  The ID of the feature to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.Feature] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.CreateFeatureRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L522}
  /// [google.cloud.gkehub.v1.Feature]: @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Feature>> CreateFeature(
      std::string const& parent,
      google::cloud::gkehub::v1::Feature const& resource,
      std::string const& feature_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFeature
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateFeature(
      NoAwaitTag, std::string const& parent,
      google::cloud::gkehub::v1::Feature const& resource,
      std::string const& feature_id, Options opts = {});

  // clang-format off
  ///
  /// Adds a new Feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.CreateFeatureRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.Feature] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.CreateFeatureRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L522}
  /// [google.cloud.gkehub.v1.Feature]: @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Feature>> CreateFeature(
      google::cloud::gkehub::v1::CreateFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFeature
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateFeature(
      NoAwaitTag,
      google::cloud::gkehub::v1::CreateFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFeature
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Feature>> CreateFeature(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Removes a Membership.
  ///
  /// **This is currently only supported for GKE clusters on Google Cloud**.
  /// To unregister other clusters, follow the instructions at
  /// https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
  ///
  /// @param name  Required. The Membership resource name in the format
  ///  `projects/*/locations/*/memberships/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.DeleteMembershipRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L312}
  /// [google.cloud.gkehub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L624}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
  DeleteMembership(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMembership
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMembership(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Removes a Membership.
  ///
  /// **This is currently only supported for GKE clusters on Google Cloud**.
  /// To unregister other clusters, follow the instructions at
  /// https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.DeleteMembershipRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.DeleteMembershipRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L312}
  /// [google.cloud.gkehub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L624}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
  DeleteMembership(
      google::cloud::gkehub::v1::DeleteMembershipRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMembership
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMembership(
      NoAwaitTag,
      google::cloud::gkehub::v1::DeleteMembershipRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMembership
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
  DeleteMembership(google::longrunning::Operation const& operation,
                   Options opts = {});

  // clang-format off
  ///
  /// Removes a Feature.
  ///
  /// @param name  Required. The Feature resource name in the format
  ///  `projects/*/locations/*/features/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.DeleteFeatureRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L554}
  /// [google.cloud.gkehub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L624}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>> DeleteFeature(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFeature
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteFeature(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Removes a Feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.DeleteFeatureRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.DeleteFeatureRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L554}
  /// [google.cloud.gkehub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L624}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>> DeleteFeature(
      google::cloud::gkehub::v1::DeleteFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFeature
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteFeature(
      NoAwaitTag,
      google::cloud::gkehub::v1::DeleteFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFeature
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>> DeleteFeature(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing Membership.
  ///
  /// @param name  Required. The Membership resource name in the format
  ///  `projects/*/locations/*/memberships/*`.
  /// @param resource  Required. Only fields specified in update_mask are updated.
  ///  If you specify a field in the update_mask but don't specify its value here
  ///  that field will be deleted.
  ///  If you are updating a map field, set the value of a key to null or empty
  ///  string to delete the key from the map. It's not possible to update a key's
  ///  value to the empty string.
  ///  If you specify the update_mask to be a special path "*", fully replaces all
  ///  user-modifiable fields to match `resource`.
  /// @param update_mask  Required. Mask of fields to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.Membership] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.Membership]: @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
  /// [google.cloud.gkehub.v1.UpdateMembershipRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L344}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Membership>> UpdateMembership(
      std::string const& name,
      google::cloud::gkehub::v1::Membership const& resource,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMembership
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMembership(
      NoAwaitTag, std::string const& name,
      google::cloud::gkehub::v1::Membership const& resource,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing Membership.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.UpdateMembershipRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.Membership] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.Membership]: @googleapis_reference_link{google/cloud/gkehub/v1/membership.proto#L32}
  /// [google.cloud.gkehub.v1.UpdateMembershipRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L344}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Membership>> UpdateMembership(
      google::cloud::gkehub::v1::UpdateMembershipRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMembership
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMembership(
      NoAwaitTag,
      google::cloud::gkehub::v1::UpdateMembershipRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMembership
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Membership>> UpdateMembership(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing Feature.
  ///
  /// @param name  Required. The Feature resource name in the format
  ///  `projects/*/locations/*/features/*`.
  /// @param resource  Only fields specified in update_mask are updated.
  ///  If you specify a field in the update_mask but don't specify its value here
  ///  that field will be deleted.
  ///  If you are updating a map field, set the value of a key to null or empty
  ///  string to delete the key from the map. It's not possible to update a key's
  ///  value to the empty string.
  ///  If you specify the update_mask to be a special path "*", fully replaces all
  ///  user-modifiable fields to match `resource`.
  /// @param update_mask  Mask of fields to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.Feature] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.Feature]: @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
  /// [google.cloud.gkehub.v1.UpdateFeatureRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L585}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Feature>> UpdateFeature(
      std::string const& name,
      google::cloud::gkehub::v1::Feature const& resource,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFeature
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateFeature(
      NoAwaitTag, std::string const& name,
      google::cloud::gkehub::v1::Feature const& resource,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing Feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.UpdateFeatureRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.gkehub.v1.Feature] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.Feature]: @googleapis_reference_link{google/cloud/gkehub/v1/feature.proto#L34}
  /// [google.cloud.gkehub.v1.UpdateFeatureRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L585}
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Feature>> UpdateFeature(
      google::cloud::gkehub::v1::UpdateFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFeature
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateFeature(
      NoAwaitTag,
      google::cloud::gkehub::v1::UpdateFeatureRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFeature
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::gkehub::v1::Feature>> UpdateFeature(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Generates the manifest for deployment of the GKE connect agent.
  ///
  /// **This method is used internally by Google-provided libraries.**
  /// Most clients should not need to call this method directly.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.gkehub.v1.GenerateConnectManifestRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.gkehub.v1.GenerateConnectManifestResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.gkehub.v1.GenerateConnectManifestRequest]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L387}
  /// [google.cloud.gkehub.v1.GenerateConnectManifestResponse]: @googleapis_reference_link{google/cloud/gkehub/v1/service.proto#L430}
  ///
  // clang-format on
  StatusOr<google::cloud::gkehub::v1::GenerateConnectManifestResponse>
  GenerateConnectManifest(
      google::cloud::gkehub::v1::GenerateConnectManifestRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<GkeHubConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkehub_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEHUB_V1_GKE_HUB_CLIENT_H
