// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/engine_service.proto

#include "google/cloud/discoveryengine/v1/engine_connection.h"
#include "google/cloud/discoveryengine/v1/engine_options.h"
#include "google/cloud/discoveryengine/v1/internal/engine_connection_impl.h"
#include "google/cloud/discoveryengine/v1/internal/engine_option_defaults.h"
#include "google/cloud/discoveryengine/v1/internal/engine_stub_factory.h"
#include "google/cloud/discoveryengine/v1/internal/engine_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EngineServiceConnection::~EngineServiceConnection() = default;

future<StatusOr<google::cloud::discoveryengine::v1::Engine>>
EngineServiceConnection::CreateEngine(
    google::cloud::discoveryengine::v1::CreateEngineRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::Engine>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> EngineServiceConnection::CreateEngine(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateEngineRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::Engine>>
EngineServiceConnection::CreateEngine(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::Engine>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
EngineServiceConnection::DeleteEngine(
    google::cloud::discoveryengine::v1::DeleteEngineRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> EngineServiceConnection::DeleteEngine(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteEngineRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
EngineServiceConnection::DeleteEngine(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::discoveryengine::v1::Engine>
EngineServiceConnection::UpdateEngine(
    google::cloud::discoveryengine::v1::UpdateEngineRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::discoveryengine::v1::Engine>
EngineServiceConnection::GetEngine(
    google::cloud::discoveryengine::v1::GetEngineRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::discoveryengine::v1::Engine>
EngineServiceConnection::ListEngines(
    google::cloud::discoveryengine::v1::
        ListEnginesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::discoveryengine::v1::Engine>>();
}

std::shared_ptr<EngineServiceConnection> MakeEngineServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 EngineServicePolicyOptionList>(options,
                                                                __func__);
  options = discoveryengine_v1_internal::EngineServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = discoveryengine_v1_internal::CreateDefaultEngineServiceStub(
      std::move(auth), options);
  return discoveryengine_v1_internal::MakeEngineServiceTracingConnection(
      std::make_shared<
          discoveryengine_v1_internal::EngineServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
