// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/agent.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_AGENTS_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_AGENTS_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/dialogflow/v2/agent.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <google/protobuf/struct.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AgentsStub {
 public:
  virtual ~AgentsStub() = 0;

  virtual StatusOr<google::cloud::dialogflow::v2::Agent> GetAgent(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::GetAgentRequest const& request) = 0;

  virtual StatusOr<google::cloud::dialogflow::v2::Agent> SetAgent(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::SetAgentRequest const& request) = 0;

  virtual Status DeleteAgent(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::DeleteAgentRequest const& request) = 0;

  virtual StatusOr<google::cloud::dialogflow::v2::SearchAgentsResponse>
  SearchAgents(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::SearchAgentsRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncTrainAgent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::dialogflow::v2::TrainAgentRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> TrainAgent(
      grpc::ClientContext& context, Options options,
      google::cloud::dialogflow::v2::TrainAgentRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncExportAgent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::dialogflow::v2::ExportAgentRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> ExportAgent(
      grpc::ClientContext& context, Options options,
      google::cloud::dialogflow::v2::ExportAgentRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncImportAgent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::dialogflow::v2::ImportAgentRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> ImportAgent(
      grpc::ClientContext& context, Options options,
      google::cloud::dialogflow::v2::ImportAgentRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncRestoreAgent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::dialogflow::v2::RestoreAgentRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> RestoreAgent(
      grpc::ClientContext& context, Options options,
      google::cloud::dialogflow::v2::RestoreAgentRequest const& request) = 0;

  virtual StatusOr<google::cloud::dialogflow::v2::ValidationResult>
  GetValidationResult(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::GetValidationResultRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultAgentsStub : public AgentsStub {
 public:
  DefaultAgentsStub(
      std::unique_ptr<google::cloud::dialogflow::v2::Agents::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  StatusOr<google::cloud::dialogflow::v2::Agent> GetAgent(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::GetAgentRequest const& request) override;

  StatusOr<google::cloud::dialogflow::v2::Agent> SetAgent(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::SetAgentRequest const& request) override;

  Status DeleteAgent(grpc::ClientContext& context, Options const& options,
                     google::cloud::dialogflow::v2::DeleteAgentRequest const&
                         request) override;

  StatusOr<google::cloud::dialogflow::v2::SearchAgentsResponse> SearchAgents(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::SearchAgentsRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncTrainAgent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::dialogflow::v2::TrainAgentRequest const& request) override;

  StatusOr<google::longrunning::Operation> TrainAgent(
      grpc::ClientContext& context, Options options,
      google::cloud::dialogflow::v2::TrainAgentRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncExportAgent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::dialogflow::v2::ExportAgentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ExportAgent(
      grpc::ClientContext& context, Options options,
      google::cloud::dialogflow::v2::ExportAgentRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncImportAgent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::dialogflow::v2::ImportAgentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ImportAgent(
      grpc::ClientContext& context, Options options,
      google::cloud::dialogflow::v2::ImportAgentRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncRestoreAgent(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::dialogflow::v2::RestoreAgentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> RestoreAgent(
      grpc::ClientContext& context, Options options,
      google::cloud::dialogflow::v2::RestoreAgentRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::v2::ValidationResult> GetValidationResult(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dialogflow::v2::GetValidationResultRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::dialogflow::v2::Agents::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_AGENTS_STUB_H
