// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/synonymset_service.proto

#include "google/cloud/contentwarehouse/v1/internal/synonym_set_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SynonymSetServiceTracingConnection::SynonymSetServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::SynonymSetServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::contentwarehouse::v1::SynonymSet>
SynonymSetServiceTracingConnection::CreateSynonymSet(
    google::cloud::contentwarehouse::v1::CreateSynonymSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::SynonymSetServiceConnection::CreateSynonymSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSynonymSet(request));
}

StatusOr<google::cloud::contentwarehouse::v1::SynonymSet>
SynonymSetServiceTracingConnection::GetSynonymSet(
    google::cloud::contentwarehouse::v1::GetSynonymSetRequest const& request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::SynonymSetServiceConnection::GetSynonymSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSynonymSet(request));
}

StatusOr<google::cloud::contentwarehouse::v1::SynonymSet>
SynonymSetServiceTracingConnection::UpdateSynonymSet(
    google::cloud::contentwarehouse::v1::UpdateSynonymSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::SynonymSetServiceConnection::UpdateSynonymSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSynonymSet(request));
}

Status SynonymSetServiceTracingConnection::DeleteSynonymSet(
    google::cloud::contentwarehouse::v1::DeleteSynonymSetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::SynonymSetServiceConnection::DeleteSynonymSet");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteSynonymSet(request));
}

StreamRange<google::cloud::contentwarehouse::v1::SynonymSet>
SynonymSetServiceTracingConnection::ListSynonymSets(
    google::cloud::contentwarehouse::v1::ListSynonymSetsRequest request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::SynonymSetServiceConnection::ListSynonymSets");
  internal::OTelScope scope(span);
  auto sr = child_->ListSynonymSets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::contentwarehouse::v1::SynonymSet>(std::move(span),
                                                       std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<contentwarehouse_v1::SynonymSetServiceConnection>
MakeSynonymSetServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::SynonymSetServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<SynonymSetServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
