// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/snapshot_settings/v1/snapshot_settings.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SNAPSHOT_SETTINGS_V1_INTERNAL_SNAPSHOT_SETTINGS_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SNAPSHOT_SETTINGS_V1_INTERNAL_SNAPSHOT_SETTINGS_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/snapshot_settings/v1/internal/snapshot_settings_rest_stub.h"
#include "google/cloud/compute/snapshot_settings/v1/internal/snapshot_settings_retry_traits.h"
#include "google/cloud/compute/snapshot_settings/v1/snapshot_settings_connection.h"
#include "google/cloud/compute/snapshot_settings/v1/snapshot_settings_connection_idempotency_policy.h"
#include "google/cloud/compute/snapshot_settings/v1/snapshot_settings_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/global_operations/v1/global_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_snapshot_settings_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SnapshotSettingsRestConnectionImpl
    : public compute_snapshot_settings_v1::SnapshotSettingsConnection {
 public:
  ~SnapshotSettingsRestConnectionImpl() override = default;

  SnapshotSettingsRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          compute_snapshot_settings_v1_internal::SnapshotSettingsRestStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::cpp::compute::v1::SnapshotSettings>
  GetSnapshotSettings(google::cloud::cpp::compute::snapshot_settings::v1::
                          GetSnapshotSettingsRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchSnapshotSettings(
      google::cloud::cpp::compute::snapshot_settings::v1::
          PatchSnapshotSettingsRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> PatchSnapshotSettings(
      NoAwaitTag, google::cloud::cpp::compute::snapshot_settings::v1::
                      PatchSnapshotSettingsRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchSnapshotSettings(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

 private:
  static std::unique_ptr<
      compute_snapshot_settings_v1::SnapshotSettingsRetryPolicy>
  retry_policy(Options const& options) {
    return options
        .get<compute_snapshot_settings_v1::SnapshotSettingsRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options
        .get<
            compute_snapshot_settings_v1::SnapshotSettingsBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<
      compute_snapshot_settings_v1::SnapshotSettingsConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_snapshot_settings_v1::
                 SnapshotSettingsConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options
        .get<
            compute_snapshot_settings_v1::SnapshotSettingsPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      compute_snapshot_settings_v1_internal::SnapshotSettingsRestStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_snapshot_settings_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SNAPSHOT_SETTINGS_V1_INTERNAL_SNAPSHOT_SETTINGS_REST_CONNECTION_IMPL_H
