// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/backend_services/v1/backend_services.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_BACKEND_SERVICES_V1_INTERNAL_BACKEND_SERVICES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_BACKEND_SERVICES_V1_INTERNAL_BACKEND_SERVICES_TRACING_CONNECTION_H

#include "google/cloud/compute/backend_services/v1/backend_services_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_backend_services_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class BackendServicesTracingConnection
    : public compute_backend_services_v1::BackendServicesConnection {
 public:
  ~BackendServicesTracingConnection() override = default;

  explicit BackendServicesTracingConnection(
      std::shared_ptr<compute_backend_services_v1::BackendServicesConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddSignedUrlKey(
      google::cloud::cpp::compute::backend_services::v1::
          AddSignedUrlKeyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> AddSignedUrlKey(
      NoAwaitTag, google::cloud::cpp::compute::backend_services::v1::
                      AddSignedUrlKeyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddSignedUrlKey(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::BackendServicesScopedList>>
  AggregatedListBackendServices(
      google::cloud::cpp::compute::backend_services::v1::
          AggregatedListBackendServicesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteBackendService(google::cloud::cpp::compute::backend_services::v1::
                           DeleteBackendServiceRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteBackendService(
      NoAwaitTag, google::cloud::cpp::compute::backend_services::v1::
                      DeleteBackendServiceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteBackendService(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteSignedUrlKey(google::cloud::cpp::compute::backend_services::v1::
                         DeleteSignedUrlKeyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteSignedUrlKey(
      NoAwaitTag, google::cloud::cpp::compute::backend_services::v1::
                      DeleteSignedUrlKeyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteSignedUrlKey(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::BackendService> GetBackendService(
      google::cloud::cpp::compute::backend_services::v1::
          GetBackendServiceRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::BackendServiceGroupHealth>
  GetHealth(
      google::cloud::cpp::compute::backend_services::v1::GetHealthRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> GetIamPolicy(
      google::cloud::cpp::compute::backend_services::v1::
          GetIamPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertBackendService(google::cloud::cpp::compute::backend_services::v1::
                           InsertBackendServiceRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> InsertBackendService(
      NoAwaitTag, google::cloud::cpp::compute::backend_services::v1::
                      InsertBackendServiceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertBackendService(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<google::cloud::cpp::compute::v1::BackendService>
  ListBackendServices(google::cloud::cpp::compute::backend_services::v1::
                          ListBackendServicesRequest request) override;

  StreamRange<google::cloud::cpp::compute::v1::BackendService> ListUsable(
      google::cloud::cpp::compute::backend_services::v1::ListUsableRequest
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchBackendService(google::cloud::cpp::compute::backend_services::v1::
                          PatchBackendServiceRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> PatchBackendService(
      NoAwaitTag, google::cloud::cpp::compute::backend_services::v1::
                      PatchBackendServiceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchBackendService(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetEdgeSecurityPolicy(
      google::cloud::cpp::compute::backend_services::v1::
          SetEdgeSecurityPolicyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> SetEdgeSecurityPolicy(
      NoAwaitTag, google::cloud::cpp::compute::backend_services::v1::
                      SetEdgeSecurityPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetEdgeSecurityPolicy(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> SetIamPolicy(
      google::cloud::cpp::compute::backend_services::v1::
          SetIamPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetSecurityPolicy(google::cloud::cpp::compute::backend_services::v1::
                        SetSecurityPolicyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> SetSecurityPolicy(
      NoAwaitTag, google::cloud::cpp::compute::backend_services::v1::
                      SetSecurityPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetSecurityPolicy(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
  TestIamPermissions(google::cloud::cpp::compute::backend_services::v1::
                         TestIamPermissionsRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  UpdateBackendService(google::cloud::cpp::compute::backend_services::v1::
                           UpdateBackendServiceRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> UpdateBackendService(
      NoAwaitTag, google::cloud::cpp::compute::backend_services::v1::
                      UpdateBackendServiceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  UpdateBackendService(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

 private:
  std::shared_ptr<compute_backend_services_v1::BackendServicesConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_backend_services_v1::BackendServicesConnection>
MakeBackendServicesTracingConnection(
    std::shared_ptr<compute_backend_services_v1::BackendServicesConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_backend_services_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_BACKEND_SERVICES_V1_INTERNAL_BACKEND_SERVICES_TRACING_CONNECTION_H
