// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/cloudquotas/v1/cloudquotas.proto

#include "google/cloud/cloudquotas/v1/internal/cloud_quotas_option_defaults.h"
#include "google/cloud/cloudquotas/v1/cloud_quotas_connection.h"
#include "google/cloud/cloudquotas/v1/cloud_quotas_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudquotas_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options CloudQuotasDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_CLOUD_QUOTAS_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_CLOUD_QUOTAS_AUTHORITY", "cloudquotas.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<cloudquotas_v1::CloudQuotasRetryPolicyOption>()) {
    options.set<cloudquotas_v1::CloudQuotasRetryPolicyOption>(
        cloudquotas_v1::CloudQuotasLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<cloudquotas_v1::CloudQuotasBackoffPolicyOption>()) {
    options.set<cloudquotas_v1::CloudQuotasBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<
          cloudquotas_v1::CloudQuotasConnectionIdempotencyPolicyOption>()) {
    options.set<cloudquotas_v1::CloudQuotasConnectionIdempotencyPolicyOption>(
        cloudquotas_v1::MakeDefaultCloudQuotasConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudquotas_v1_internal
}  // namespace cloud
}  // namespace google
