// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_CONNECTION_IMPL_H

#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_core_connection.h"
#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_core_connection_idempotency_policy.h"
#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_core_options.h"
#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_core_retry_traits.h"
#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_core_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CloudControlsPartnerCoreConnectionImpl
    : public cloudcontrolspartner_v1::CloudControlsPartnerCoreConnection {
 public:
  ~CloudControlsPartnerCoreConnectionImpl() override = default;

  CloudControlsPartnerCoreConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          cloudcontrolspartner_v1_internal::CloudControlsPartnerCoreStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::cloudcontrolspartner::v1::Workload> GetWorkload(
      google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
          request) override;

  StreamRange<google::cloud::cloudcontrolspartner::v1::Workload> ListWorkloads(
      google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest request)
      override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::Customer> GetCustomer(
      google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
          request) override;

  StreamRange<google::cloud::cloudcontrolspartner::v1::Customer> ListCustomers(
      google::cloud::cloudcontrolspartner::v1::ListCustomersRequest request)
      override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
  GetEkmConnections(
      google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
  GetPartnerPermissions(
      google::cloud::cloudcontrolspartner::v1::
          GetPartnerPermissionsRequest const& request) override;

  StreamRange<google::cloud::cloudcontrolspartner::v1::AccessApprovalRequest>
  ListAccessApprovalRequests(
      google::cloud::cloudcontrolspartner::v1::ListAccessApprovalRequestsRequest
          request) override;

  StatusOr<google::cloud::cloudcontrolspartner::v1::Partner> GetPartner(
      google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const& request)
      override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      cloudcontrolspartner_v1_internal::CloudControlsPartnerCoreStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_INTERNAL_CLOUD_CONTROLS_PARTNER_CORE_CONNECTION_IMPL_H
