// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apigateway/v1/apigateway_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_V1_INTERNAL_API_GATEWAY_METADATA_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_V1_INTERNAL_API_GATEWAY_METADATA_DECORATOR_H

#include "google/cloud/apigateway/v1/internal/api_gateway_stub.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace apigateway_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ApiGatewayServiceMetadata : public ApiGatewayServiceStub {
 public:
  ~ApiGatewayServiceMetadata() override = default;
  ApiGatewayServiceMetadata(
      std::shared_ptr<ApiGatewayServiceStub> child,
      std::multimap<std::string, std::string> fixed_metadata,
      std::string api_client_header = "");

  StatusOr<google::cloud::apigateway::v1::ListGatewaysResponse> ListGateways(
      grpc::ClientContext& context, Options const& options,
      google::cloud::apigateway::v1::ListGatewaysRequest const& request)
      override;

  StatusOr<google::cloud::apigateway::v1::Gateway> GetGateway(
      grpc::ClientContext& context, Options const& options,
      google::cloud::apigateway::v1::GetGatewayRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateGateway(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::CreateGatewayRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateGateway(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::CreateGatewayRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateGateway(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::UpdateGatewayRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateGateway(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::UpdateGatewayRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteGateway(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::DeleteGatewayRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteGateway(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::DeleteGatewayRequest const& request)
      override;

  StatusOr<google::cloud::apigateway::v1::ListApisResponse> ListApis(
      grpc::ClientContext& context, Options const& options,
      google::cloud::apigateway::v1::ListApisRequest const& request) override;

  StatusOr<google::cloud::apigateway::v1::Api> GetApi(
      grpc::ClientContext& context, Options const& options,
      google::cloud::apigateway::v1::GetApiRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateApi(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::CreateApiRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateApi(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::CreateApiRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateApi(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::UpdateApiRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateApi(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::UpdateApiRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteApi(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::DeleteApiRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteApi(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::DeleteApiRequest const& request) override;

  StatusOr<google::cloud::apigateway::v1::ListApiConfigsResponse>
  ListApiConfigs(grpc::ClientContext& context, Options const& options,
                 google::cloud::apigateway::v1::ListApiConfigsRequest const&
                     request) override;

  StatusOr<google::cloud::apigateway::v1::ApiConfig> GetApiConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::apigateway::v1::GetApiConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateApiConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::CreateApiConfigRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateApiConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::CreateApiConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateApiConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::UpdateApiConfigRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateApiConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::UpdateApiConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteApiConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::apigateway::v1::DeleteApiConfigRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteApiConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::apigateway::v1::DeleteApiConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  void SetMetadata(grpc::ClientContext& context, Options const& options,
                   std::string const& request_params);
  void SetMetadata(grpc::ClientContext& context, Options const& options);

  std::shared_ptr<ApiGatewayServiceStub> child_;
  std::multimap<std::string, std::string> fixed_metadata_;
  std::string api_client_header_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apigateway_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_V1_INTERNAL_API_GATEWAY_METADATA_DECORATOR_H
