// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apigateway/v1/apigateway_service.proto

#include "google/cloud/apigateway/v1/internal/api_gateway_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/apigateway/v1/apigateway_service.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace apigateway_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ApiGatewayServiceLogging::ApiGatewayServiceLogging(
    std::shared_ptr<ApiGatewayServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::apigateway::v1::ListGatewaysResponse>
ApiGatewayServiceLogging::ListGateways(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apigateway::v1::ListGatewaysRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apigateway::v1::ListGatewaysRequest const& request) {
        return child_->ListGateways(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::apigateway::v1::Gateway>
ApiGatewayServiceLogging::GetGateway(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apigateway::v1::GetGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::GetGatewayRequest const& request) {
        return child_->GetGateway(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncCreateGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::CreateGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apigateway::v1::CreateGatewayRequest const& request) {
        return child_->AsyncCreateGateway(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
ApiGatewayServiceLogging::CreateGateway(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::CreateGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apigateway::v1::CreateGatewayRequest const& request) {
        return child_->CreateGateway(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncUpdateGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::UpdateGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apigateway::v1::UpdateGatewayRequest const& request) {
        return child_->AsyncUpdateGateway(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
ApiGatewayServiceLogging::UpdateGateway(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::UpdateGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apigateway::v1::UpdateGatewayRequest const& request) {
        return child_->UpdateGateway(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncDeleteGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::DeleteGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::apigateway::v1::DeleteGatewayRequest const& request) {
        return child_->AsyncDeleteGateway(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
ApiGatewayServiceLogging::DeleteGateway(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::DeleteGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apigateway::v1::DeleteGatewayRequest const& request) {
        return child_->DeleteGateway(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::apigateway::v1::ListApisResponse>
ApiGatewayServiceLogging::ListApis(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apigateway::v1::ListApisRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::ListApisRequest const& request) {
        return child_->ListApis(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::apigateway::v1::Api> ApiGatewayServiceLogging::GetApi(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apigateway::v1::GetApiRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::GetApiRequest const& request) {
        return child_->GetApi(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncCreateApi(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::CreateApiRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::apigateway::v1::CreateApiRequest const& request) {
        return child_->AsyncCreateApi(cq, std::move(context),
                                      std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> ApiGatewayServiceLogging::CreateApi(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::CreateApiRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::CreateApiRequest const& request) {
        return child_->CreateApi(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncUpdateApi(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::UpdateApiRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::apigateway::v1::UpdateApiRequest const& request) {
        return child_->AsyncUpdateApi(cq, std::move(context),
                                      std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> ApiGatewayServiceLogging::UpdateApi(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::UpdateApiRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::UpdateApiRequest const& request) {
        return child_->UpdateApi(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncDeleteApi(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::DeleteApiRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::apigateway::v1::DeleteApiRequest const& request) {
        return child_->AsyncDeleteApi(cq, std::move(context),
                                      std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> ApiGatewayServiceLogging::DeleteApi(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::DeleteApiRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::DeleteApiRequest const& request) {
        return child_->DeleteApi(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::apigateway::v1::ListApiConfigsResponse>
ApiGatewayServiceLogging::ListApiConfigs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apigateway::v1::ListApiConfigsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apigateway::v1::ListApiConfigsRequest const& request) {
        return child_->ListApiConfigs(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::apigateway::v1::ApiConfig>
ApiGatewayServiceLogging::GetApiConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apigateway::v1::GetApiConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::apigateway::v1::GetApiConfigRequest const& request) {
        return child_->GetApiConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncCreateApiConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::CreateApiConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::apigateway::v1::CreateApiConfigRequest const&
                 request) {
        return child_->AsyncCreateApiConfig(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
ApiGatewayServiceLogging::CreateApiConfig(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::CreateApiConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::CreateApiConfigRequest const&
                 request) {
        return child_->CreateApiConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncUpdateApiConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::UpdateApiConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::apigateway::v1::UpdateApiConfigRequest const&
                 request) {
        return child_->AsyncUpdateApiConfig(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
ApiGatewayServiceLogging::UpdateApiConfig(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::UpdateApiConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::UpdateApiConfigRequest const&
                 request) {
        return child_->UpdateApiConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncDeleteApiConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apigateway::v1::DeleteApiConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::apigateway::v1::DeleteApiConfigRequest const&
                 request) {
        return child_->AsyncDeleteApiConfig(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
ApiGatewayServiceLogging::DeleteApiConfig(
    grpc::ClientContext& context, Options options,
    google::cloud::apigateway::v1::DeleteApiConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::apigateway::v1::DeleteApiConfigRequest const&
                 request) {
        return child_->DeleteApiConfig(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
ApiGatewayServiceLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> ApiGatewayServiceLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apigateway_v1_internal
}  // namespace cloud
}  // namespace google
