// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/prediction_service.proto

#include "google/cloud/aiplatform/v1/internal/prediction_logging_decorator.h"
#include "google/cloud/internal/async_read_write_stream_logging.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/internal/streaming_read_rpc_logging.h"
#include "google/cloud/status_or.h"
#include <google/cloud/aiplatform/v1/prediction_service.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PredictionServiceLogging::PredictionServiceLogging(
    std::shared_ptr<PredictionServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::aiplatform::v1::PredictResponse>
PredictionServiceLogging::Predict(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::PredictRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::PredictRequest const& request) {
        return child_->Predict(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::api::HttpBody> PredictionServiceLogging::RawPredict(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::RawPredictRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::RawPredictRequest const& request) {
        return child_->RawPredict(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

std::unique_ptr<
    google::cloud::internal::StreamingReadRpc<google::api::HttpBody>>
PredictionServiceLogging::StreamRawPredict(
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::aiplatform::v1::StreamRawPredictRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::StreamRawPredictRequest const& request)
          -> std::unique_ptr<google::cloud::internal::StreamingReadRpc<
              google::api::HttpBody>> {
        auto stream =
            child_->StreamRawPredict(std::move(context), options, request);
        if (stream_logging_) {
          stream =
              std::make_unique<google::cloud::internal::StreamingReadRpcLogging<
                  google::api::HttpBody>>(
                  std::move(stream), tracing_options_,
                  google::cloud::internal::RequestIdForLogging());
        }
        return stream;
      },
      std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::aiplatform::v1::DirectPredictResponse>
PredictionServiceLogging::DirectPredict(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::DirectPredictRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::aiplatform::v1::DirectPredictRequest const& request) {
        return child_->DirectPredict(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::aiplatform::v1::DirectRawPredictResponse>
PredictionServiceLogging::DirectRawPredict(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::DirectRawPredictRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::DirectRawPredictRequest const&
                 request) {
        return child_->DirectRawPredict(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamDirectPredictRequest,
    google::cloud::aiplatform::v1::StreamDirectPredictResponse>>
PredictionServiceLogging::AsyncStreamDirectPredict(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  using LoggingStream =
      ::google::cloud::internal::AsyncStreamingReadWriteRpcLogging<
          google::cloud::aiplatform::v1::StreamDirectPredictRequest,
          google::cloud::aiplatform::v1::StreamDirectPredictResponse>;

  auto request_id = google::cloud::internal::RequestIdForLogging();
  GCP_LOG(DEBUG) << __func__ << "(" << request_id << ")";
  auto stream = child_->AsyncStreamDirectPredict(cq, std::move(context),
                                                 std::move(options));
  if (stream_logging_) {
    stream = std::make_unique<LoggingStream>(
        std::move(stream), tracing_options_, std::move(request_id));
  }
  return stream;
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamDirectRawPredictRequest,
    google::cloud::aiplatform::v1::StreamDirectRawPredictResponse>>
PredictionServiceLogging::AsyncStreamDirectRawPredict(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  using LoggingStream =
      ::google::cloud::internal::AsyncStreamingReadWriteRpcLogging<
          google::cloud::aiplatform::v1::StreamDirectRawPredictRequest,
          google::cloud::aiplatform::v1::StreamDirectRawPredictResponse>;

  auto request_id = google::cloud::internal::RequestIdForLogging();
  GCP_LOG(DEBUG) << __func__ << "(" << request_id << ")";
  auto stream = child_->AsyncStreamDirectRawPredict(cq, std::move(context),
                                                    std::move(options));
  if (stream_logging_) {
    stream = std::make_unique<LoggingStream>(
        std::move(stream), tracing_options_, std::move(request_id));
  }
  return stream;
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamingPredictRequest,
    google::cloud::aiplatform::v1::StreamingPredictResponse>>
PredictionServiceLogging::AsyncStreamingPredict(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  using LoggingStream =
      ::google::cloud::internal::AsyncStreamingReadWriteRpcLogging<
          google::cloud::aiplatform::v1::StreamingPredictRequest,
          google::cloud::aiplatform::v1::StreamingPredictResponse>;

  auto request_id = google::cloud::internal::RequestIdForLogging();
  GCP_LOG(DEBUG) << __func__ << "(" << request_id << ")";
  auto stream =
      child_->AsyncStreamingPredict(cq, std::move(context), std::move(options));
  if (stream_logging_) {
    stream = std::make_unique<LoggingStream>(
        std::move(stream), tracing_options_, std::move(request_id));
  }
  return stream;
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::cloud::aiplatform::v1::StreamingPredictResponse>>
PredictionServiceLogging::ServerStreamingPredict(
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::aiplatform::v1::StreamingPredictRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::StreamingPredictRequest const& request)
          -> std::unique_ptr<google::cloud::internal::StreamingReadRpc<
              google::cloud::aiplatform::v1::StreamingPredictResponse>> {
        auto stream = child_->ServerStreamingPredict(std::move(context),
                                                     options, request);
        if (stream_logging_) {
          stream =
              std::make_unique<google::cloud::internal::StreamingReadRpcLogging<
                  google::cloud::aiplatform::v1::StreamingPredictResponse>>(
                  std::move(stream), tracing_options_,
                  google::cloud::internal::RequestIdForLogging());
        }
        return stream;
      },
      std::move(context), options, request, __func__, tracing_options_);
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamingRawPredictRequest,
    google::cloud::aiplatform::v1::StreamingRawPredictResponse>>
PredictionServiceLogging::AsyncStreamingRawPredict(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  using LoggingStream =
      ::google::cloud::internal::AsyncStreamingReadWriteRpcLogging<
          google::cloud::aiplatform::v1::StreamingRawPredictRequest,
          google::cloud::aiplatform::v1::StreamingRawPredictResponse>;

  auto request_id = google::cloud::internal::RequestIdForLogging();
  GCP_LOG(DEBUG) << __func__ << "(" << request_id << ")";
  auto stream = child_->AsyncStreamingRawPredict(cq, std::move(context),
                                                 std::move(options));
  if (stream_logging_) {
    stream = std::make_unique<LoggingStream>(
        std::move(stream), tracing_options_, std::move(request_id));
  }
  return stream;
}

StatusOr<google::cloud::aiplatform::v1::ExplainResponse>
PredictionServiceLogging::Explain(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ExplainRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::ExplainRequest const& request) {
        return child_->Explain(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::aiplatform::v1::GenerateContentResponse>
PredictionServiceLogging::GenerateContent(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GenerateContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::GenerateContentRequest const&
                 request) {
        return child_->GenerateContent(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::cloud::aiplatform::v1::GenerateContentResponse>>
PredictionServiceLogging::StreamGenerateContent(
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::aiplatform::v1::GenerateContentRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::GenerateContentRequest const& request)
          -> std::unique_ptr<google::cloud::internal::StreamingReadRpc<
              google::cloud::aiplatform::v1::GenerateContentResponse>> {
        auto stream =
            child_->StreamGenerateContent(std::move(context), options, request);
        if (stream_logging_) {
          stream =
              std::make_unique<google::cloud::internal::StreamingReadRpcLogging<
                  google::cloud::aiplatform::v1::GenerateContentResponse>>(
                  std::move(stream), tracing_options_,
                  google::cloud::internal::RequestIdForLogging());
        }
        return stream;
      },
      std::move(context), options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
