/*
    This file is part of Cute Chess.
    Copyright (C) 2008-2018 Cute Chess authors

    Cute Chess is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Cute Chess is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Cute Chess.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "standardboard.h"
#include "westernzobrist.h"
#include "syzygytablebase.h"

namespace {

// Zobrist keys for Polyglot opening book compatibility
// Specs: http://alpha.uhasselt.be/Research/Algebra/Toga/book_format.html
const quint64 s_keys[] = {
	Q_UINT64_C(0xF8D626AAAF278509), Q_UINT64_C(0x2218DBC13AB50C2A),
	Q_UINT64_C(0xEB7284FF06058ED8), Q_UINT64_C(0x588B4C4C77A4044D),
	Q_UINT64_C(0xC2366DF16A5D128C), Q_UINT64_C(0x6AF41C8BC3CD3747),
	Q_UINT64_C(0xC44724AA3113C398), Q_UINT64_C(0x65B1CB16D7E82B11),
	Q_UINT64_C(0xE1B9337AEC4F3258), Q_UINT64_C(0xDA9FBBC453B39DD6),
	Q_UINT64_C(0x30C7DA4974856499), Q_UINT64_C(0x6F1BF73106135133),
	Q_UINT64_C(0xF0690786D0FA4CF3), Q_UINT64_C(0xFCF7C2FAEC36AE5),
	Q_UINT64_C(0x7036FB645C8022D1), Q_UINT64_C(0xE86CB406094DC561),
	Q_UINT64_C(0x5BEE2A1AA2E82902), Q_UINT64_C(0xF37B2423D265081),
	Q_UINT64_C(0xAA80DD12DFC6514), Q_UINT64_C(0xFA30772D72E666B4),
	Q_UINT64_C(0x604A1A6573CBAC2A), Q_UINT64_C(0x7F2524F4A8D61248),
	Q_UINT64_C(0x5CE9158221105F1), Q_UINT64_C(0x600B95C509709C15),
	Q_UINT64_C(0x7A7BFC26A3776A9B), Q_UINT64_C(0x3C3903FBBB72F5F6),
	Q_UINT64_C(0xF14B0802E1794CA1), Q_UINT64_C(0x4103F9F6900BF8FE),
	Q_UINT64_C(0x684A7079EF22B8D5), Q_UINT64_C(0xBFF71E2DDCDA4CE4),
	Q_UINT64_C(0x539AC6E19DD9546C), Q_UINT64_C(0xA5D4CE1041B2F3E2),
	Q_UINT64_C(0xB5DB4F70B4BF100C), Q_UINT64_C(0x62633036B52BA698),
	Q_UINT64_C(0x4B69B89A24C35FFF), Q_UINT64_C(0x735A9D8CC92BFC1E),
	Q_UINT64_C(0x5FE719284468DA36), Q_UINT64_C(0xE37E4D40DFC80DB7),
	Q_UINT64_C(0xB5E3FA1D4FFB0FC3), Q_UINT64_C(0x2DBDCEE01B3B710F),
	Q_UINT64_C(0x9192DA2A8BA59244), Q_UINT64_C(0x1B85755B5078FC8),
	Q_UINT64_C(0x70CC73D90BC26E24), Q_UINT64_C(0xE21A6B35DF0C3AD7),
	Q_UINT64_C(0x3A93D8B2806962), Q_UINT64_C(0x1C99DED33CB890A1),
	Q_UINT64_C(0xCF3145DE0ADD4289), Q_UINT64_C(0xD0E4427A5514FB72),
	Q_UINT64_C(0x77C621CC9FB3A483), Q_UINT64_C(0x67A34DAC4356550B),
	Q_UINT64_C(0xFD8295313B655A34), Q_UINT64_C(0xD46E962F1991A4D7),
	Q_UINT64_C(0x69AE242C10381AA1), Q_UINT64_C(0x8FDCA3ADE6CB188E),
	Q_UINT64_C(0x8D020DB131D50BF5), Q_UINT64_C(0x1B4BBBCE736A0986),
	Q_UINT64_C(0x9A42919B79473F2E), Q_UINT64_C(0x85E62C39F15CED02),
	Q_UINT64_C(0x9761B6F309189C64), Q_UINT64_C(0xF21F2E77914B4387),
	Q_UINT64_C(0x1CF27C68ACBD3509), Q_UINT64_C(0x69B491A7F7411B53),
	Q_UINT64_C(0xFA2BC6B2D6FCE1F8), Q_UINT64_C(0x1E2929786E30A7B4),
	Q_UINT64_C(0x7452ED65CCD9B3B7), Q_UINT64_C(0xFCE3344D3B2AD7EE),
	Q_UINT64_C(0x34C7D78C383BF9D7), Q_UINT64_C(0x3F2D645159E1E84F),
	Q_UINT64_C(0xD284281BECF6678C), Q_UINT64_C(0x469EA956C1D8FEC1),
	Q_UINT64_C(0x7819A719C9D1D9D1), Q_UINT64_C(0xF7A2045F5D685F3A),
	Q_UINT64_C(0x70CC73D90BC26E24), Q_UINT64_C(0xE21A6B35DF0C3AD7),
	Q_UINT64_C(0x3A93D8B2806962), Q_UINT64_C(0x1C99DED33CB890A1),
	Q_UINT64_C(0xCF3145DE0ADD4289), Q_UINT64_C(0xD0E4427A5514FB72),
	Q_UINT64_C(0x77C621CC9FB3A483), Q_UINT64_C(0x67A34DAC4356550B),
	Q_UINT64_C(0xDC2476AFF0D52080), Q_UINT64_C(0x975EBFE9E7404DF2),
	Q_UINT64_C(0x49D4A7E27FE30DF4), Q_UINT64_C(0x8009BFCA4EE4919B),
	Q_UINT64_C(0xEE8CA80EE2FD32E8), Q_UINT64_C(0xEBADFC49B577F881),
	Q_UINT64_C(0xF587E73F1A460573), Q_UINT64_C(0x60D166CEA131A27),
	Q_UINT64_C(0xA84AE7ABE1CAE939), Q_UINT64_C(0x453019A09B558064),
	Q_UINT64_C(0x3CA4940AF9E05E35), Q_UINT64_C(0x6C4C7F1E2275A0F0),
	Q_UINT64_C(0xB22AD8F4637056D8), Q_UINT64_C(0xC69F68C241DAF1E),
	Q_UINT64_C(0x3EED55D6988DAEFA), Q_UINT64_C(0x48BBAD7E68ECC8DD),
	Q_UINT64_C(0x4B520209CCEDE632), Q_UINT64_C(0xFF3A5C1C94308909),
	Q_UINT64_C(0x46813A0F9DE6940F), Q_UINT64_C(0x2C8B6238D13E6BCA),
	Q_UINT64_C(0xB0302CFC591E7C05), Q_UINT64_C(0x39CB94C51143B2E),
	Q_UINT64_C(0x1466DB569D0E96CA), Q_UINT64_C(0x70CDF56D8F082C6A),
	Q_UINT64_C(0xA5A19C4046E69125), Q_UINT64_C(0xC927A74ED9FB8E9A),
	Q_UINT64_C(0xF70DF0133E1F22A6), Q_UINT64_C(0xEF4BB86EC7466519),
	Q_UINT64_C(0x61D3BC1D115290E8), Q_UINT64_C(0x2128480FCB477CC5),
	Q_UINT64_C(0x57B1C98CA121C26D), Q_UINT64_C(0x1E75156F3932E738),
	Q_UINT64_C(0xC50243B023BFDFE6), Q_UINT64_C(0xAAFE82F42080867B),
	Q_UINT64_C(0xEEA184F941C8AAC3), Q_UINT64_C(0x9D7C10B078EDA916),
	Q_UINT64_C(0x5D77C0E4A928E18B), Q_UINT64_C(0x19B7A15CD4A74C02),
	Q_UINT64_C(0x49A00DB17E45B832), Q_UINT64_C(0xE2AB6120AC0236B9),
	Q_UINT64_C(0x40F4F33B6A247E73), Q_UINT64_C(0xE2F3E6EDD24D21D3),
	Q_UINT64_C(0xFE15E66AA22062A3), Q_UINT64_C(0xEC6AE23CEC076287),
	Q_UINT64_C(0x8169D1C0E896C6C4), Q_UINT64_C(0xAD4D06AF5A7D5603),
	Q_UINT64_C(0x701C04A64A8CC670), Q_UINT64_C(0x11E38538D90C03B3),
	Q_UINT64_C(0x45B23F95E930EE), Q_UINT64_C(0xA6FEB860A3AB76B),
	Q_UINT64_C(0xEFC9975564391505), Q_UINT64_C(0xA56D274B00CFCDF4),
	Q_UINT64_C(0x22D144A3888E887C), Q_UINT64_C(0x98B072469BA02ECE),
	Q_UINT64_C(0xAD657F11D45BDC09), Q_UINT64_C(0xB4383B8BA3E081E7),
	Q_UINT64_C(0x93D9CED1D7D22DA8), Q_UINT64_C(0xA15768E68D493ABB),
	Q_UINT64_C(0x8389B00D9C3F6932), Q_UINT64_C(0x2E52251C1483DB15),
	Q_UINT64_C(0x1E94588F067A2554), Q_UINT64_C(0x1C934904428EFB93),
	Q_UINT64_C(0x355B0C4FA499C296), Q_UINT64_C(0x6B9832D7C9F49057),
	Q_UINT64_C(0xBF291744075B5985), Q_UINT64_C(0x76CBDC2080364F6A),
	Q_UINT64_C(0x1F567418B0539258), Q_UINT64_C(0x6B7A2DC25E963317),
	Q_UINT64_C(0x7D72727048E2348), Q_UINT64_C(0xD67C019C98196BDB),
	Q_UINT64_C(0x880F48854DC6366A), Q_UINT64_C(0x56D7DBDCFA1D9B11),
	Q_UINT64_C(0xD093B0437CB44CF0), Q_UINT64_C(0x7408FA85B650A350),
	Q_UINT64_C(0xF0ADF4281F4E99EE), Q_UINT64_C(0xD0DF2775B9D642D7),
	Q_UINT64_C(0x4D6978048EEBCCCE), Q_UINT64_C(0x80639ABA4603457D),
	Q_UINT64_C(0x5BA462A34CB7CE4B), Q_UINT64_C(0xD805147E57FD32AD),
	Q_UINT64_C(0x7E4B4DDF0FD35977), Q_UINT64_C(0x5FA1B4368A490281),
	Q_UINT64_C(0x10028B42778E4F7E), Q_UINT64_C(0x1FFF44A562725454),
	Q_UINT64_C(0x2BA069825600EED8), Q_UINT64_C(0xCEC1B09404A7B1B3),
	Q_UINT64_C(0xE9C48EBAC803580A), Q_UINT64_C(0xCE63248DAF8C3088),
	Q_UINT64_C(0x4A9E8E87D395E250), Q_UINT64_C(0x30C82C81472F0B5),
	Q_UINT64_C(0xFCBEFD9E8FFE31E6), Q_UINT64_C(0xFA7F62A7CF7E6C66),
	Q_UINT64_C(0xEE332516CBF94DDA), Q_UINT64_C(0xDC43B56586DF7533),
	Q_UINT64_C(0x842ECC0E62CF10E2), Q_UINT64_C(0x5DEF79767D143DB3),
	Q_UINT64_C(0xEF91CCEAB9143AD9), Q_UINT64_C(0x17D75D2615EFC214),
	Q_UINT64_C(0x9051392BFB803EE9), Q_UINT64_C(0x61AF84E88FDA46D0),
	Q_UINT64_C(0xC6BB593042443AE5), Q_UINT64_C(0xDB210584AF2D0B51),
	Q_UINT64_C(0x64E9E54C5B557E40), Q_UINT64_C(0x758AD1A3E10E3280),
	Q_UINT64_C(0x3BDAFF9731CCB9BC), Q_UINT64_C(0x22873E9DAE58C19A),
	Q_UINT64_C(0x8F636073B36AA638), Q_UINT64_C(0x1E3B7919B5F64A0A),
	Q_UINT64_C(0x8DD9454B0D6FA0FE), Q_UINT64_C(0x6ACDF3DFC3831FC9),
	Q_UINT64_C(0x6D8A459B1F3335DA), Q_UINT64_C(0x452F31C631004B86),
	Q_UINT64_C(0x32E70EA39DCE95D2), Q_UINT64_C(0x110818A60069CCFA),
	Q_UINT64_C(0xBF4EFC5B66CA977), Q_UINT64_C(0x32EF4C91912831D1),
	Q_UINT64_C(0x66C8B9AA15E86A28), Q_UINT64_C(0x92B7CBB2AC7A9B63),
	Q_UINT64_C(0xB565CD2069B502CF), Q_UINT64_C(0xF355599EAA2AE71B),
	Q_UINT64_C(0x42A6A1E985CDB97F), Q_UINT64_C(0x3F3682CE22F2FBB),
	Q_UINT64_C(0x4E1CED2EF6EE615B), Q_UINT64_C(0x6CC7BCB70B641C91),
	Q_UINT64_C(0x90C0FAB0BF5010D8), Q_UINT64_C(0x8CD75C27306E4DB1),
	Q_UINT64_C(0x1E0C436937D20067), Q_UINT64_C(0x1C7300ABFD162539),
	Q_UINT64_C(0xC2065EB6430AF3CF), Q_UINT64_C(0xF4AA3F25CBB92983),
	Q_UINT64_C(0x62567AAA1DB4BC28), Q_UINT64_C(0xFF30541B33A88B88),
	Q_UINT64_C(0xF165B587DF898190), Q_UINT64_C(0x7FD8A7C292FE74F8),
	Q_UINT64_C(0xFBA47DA7BBE9DF63), Q_UINT64_C(0xE2A880EF685F3FBA),
	Q_UINT64_C(0xFC7EFAFF94613194), Q_UINT64_C(0xC2A0F80F93E49A1D),
	Q_UINT64_C(0x462DAEDE8E151DDC), Q_UINT64_C(0x31D71DCE64B2C310),
	Q_UINT64_C(0x2B2B69C8422A0B77), Q_UINT64_C(0x41758C3B596725ED),
	Q_UINT64_C(0x5622C33655E30889), Q_UINT64_C(0xBAF396C59202CD19),
	Q_UINT64_C(0x2581485AB0A79857), Q_UINT64_C(0x6C3B6A75035F1950),
	Q_UINT64_C(0xC4F2E1B25B5A5E4F), Q_UINT64_C(0x3B802B14F676E241),
	Q_UINT64_C(0x75334C46C0C39CBA), Q_UINT64_C(0xAE535625CD027654),
	Q_UINT64_C(0x4A54B219BED31776), Q_UINT64_C(0xD17CF23AC984A340),
	Q_UINT64_C(0xEAB0EF82596A5A98), Q_UINT64_C(0x27165370463CFD96),
	Q_UINT64_C(0xE494CF37BF604462), Q_UINT64_C(0x89AD899BB87CF392),
	Q_UINT64_C(0xC206A930DD9D545B), Q_UINT64_C(0xD485674342D2F9C0),
	Q_UINT64_C(0xC6DC0BAD1F60D2EE), Q_UINT64_C(0xE6380242C6A258BD),
	Q_UINT64_C(0x3168F1BFF7B6523F), Q_UINT64_C(0xE99BB165BE4B9168),
	Q_UINT64_C(0x1F288ADD342A325F), Q_UINT64_C(0x62304F84DAF00713),
	Q_UINT64_C(0x91ED3830CD824660), Q_UINT64_C(0x7C0C5A9C43E71513),
	Q_UINT64_C(0xE63D0CF134ED60FB), Q_UINT64_C(0xEB9D8CE975CAD458),
	Q_UINT64_C(0xEBCBD55438244E6), Q_UINT64_C(0x50174CCA7323820A),
	Q_UINT64_C(0xFBE65FDB809DCC41), Q_UINT64_C(0x91D9F734EDEC0AB8),
	Q_UINT64_C(0x47DE68A2C0DF79E9), Q_UINT64_C(0x1BEF78D259EA950A),
	Q_UINT64_C(0xC66432B7E212040E), Q_UINT64_C(0x930319772C1B1519),
	Q_UINT64_C(0x552B25132B54484B), Q_UINT64_C(0x1F0EED2E495E0ECD),
	Q_UINT64_C(0xFE5BB7280EA71A6B), Q_UINT64_C(0x1783659B3EF4A334),
	Q_UINT64_C(0xA368E3314C31840), Q_UINT64_C(0x5DF55FAB131AAB66),
	Q_UINT64_C(0x1EF6E6DBB1961EC9), Q_UINT64_C(0x53BBA33AD35D9F15),
	Q_UINT64_C(0x397335EB683ECC89), Q_UINT64_C(0x714870EEF35B1C15),
	Q_UINT64_C(0xC20284FC4945C6E5), Q_UINT64_C(0xB724CFA9C2D7EDFD),
	Q_UINT64_C(0xA58F2584EF4B94EC), Q_UINT64_C(0xA57E6339DD2CF3A0),
	Q_UINT64_C(0xE51C77A135C3CEB9), Q_UINT64_C(0x95A32E0270BD8867),
	Q_UINT64_C(0x2E02C6B75F1EC0D3), Q_UINT64_C(0xAD7280420953C5E4),
	Q_UINT64_C(0x85C027362E00250C), Q_UINT64_C(0xC62BE2AAB5599548),
	Q_UINT64_C(0x7408F599C803A81C), Q_UINT64_C(0xE8A73464627A644A),
	Q_UINT64_C(0x5F225601F06FD5E8), Q_UINT64_C(0x587CD6E8B05169CF),
	Q_UINT64_C(0x4EAA5CF8F952977), Q_UINT64_C(0xAD59815BBD235544),
	Q_UINT64_C(0x7E74D4C8320B31AA), Q_UINT64_C(0xBA27FC7D573185EE),
	Q_UINT64_C(0x72D573066DFAB1BC), Q_UINT64_C(0x1FE9902A0968CE97),
	Q_UINT64_C(0x9FFA62BDB9B1AD7C), Q_UINT64_C(0x533531D7F7676A27),
	Q_UINT64_C(0x523FF0A8E1515C4), Q_UINT64_C(0x8F421D96343F28A0),
	Q_UINT64_C(0x8CAD5777EAAF46F1), Q_UINT64_C(0x95B420D699209A26),
	Q_UINT64_C(0x657BB149385AB45D), Q_UINT64_C(0xD877E14D2F2143E2),
	Q_UINT64_C(0x4985BBADB6F8F6AF), Q_UINT64_C(0x6CAD1EE1FF694986),
	Q_UINT64_C(0xF47322256CB5264F), Q_UINT64_C(0x809D6A67AFE7677B),
	Q_UINT64_C(0xA9602D6BD1CCA665), Q_UINT64_C(0x5826BB90E646C574),
	Q_UINT64_C(0x9565482631DB26B6), Q_UINT64_C(0xD2A85A04128BFFF3),
	Q_UINT64_C(0x942406C9ED5BD624), Q_UINT64_C(0xC05B8E994D168218),
	Q_UINT64_C(0xE10EDA0530E3E631), Q_UINT64_C(0x529FBDA0A1CF2006),
	Q_UINT64_C(0xA89D9ACC0FEC08E2), Q_UINT64_C(0xD81DC3313AA13F30),
	Q_UINT64_C(0xAA9F4E0BE0BFE0C8), Q_UINT64_C(0xE3E6059865BEA717),
	Q_UINT64_C(0x1484E560353113C8), Q_UINT64_C(0xB5E40C1D5C0D475C),
	Q_UINT64_C(0xD7E51E7A3B8559CB), Q_UINT64_C(0xCCF4EE1B8973ED72),
	Q_UINT64_C(0x9B0B198FEA6F6038), Q_UINT64_C(0xB98B632A5827298),
	Q_UINT64_C(0xE5B90B71F790EBF0), Q_UINT64_C(0x282E5F49BB45820B),
	Q_UINT64_C(0x433B1753B3F0CE45), Q_UINT64_C(0x2FE4541E4C47579B),
	Q_UINT64_C(0xC6B16DA110C55D18), Q_UINT64_C(0x6533C6666AAC1FFA),
	Q_UINT64_C(0xC135EB857DB33D07), Q_UINT64_C(0x7DEF2D1998EB3CB4),
	Q_UINT64_C(0xAE111E05A3AF9412), Q_UINT64_C(0x756B95DBEB257F85),
	Q_UINT64_C(0x29275967DD7F53AD), Q_UINT64_C(0xEA81639DC476D2B2),
	Q_UINT64_C(0x9C4FCB9A6F418D3C), Q_UINT64_C(0x7CE9868DA369D7BE),
	Q_UINT64_C(0xB5872CFB353FBB01), Q_UINT64_C(0xE1ACF60A2A9D651F),
	Q_UINT64_C(0xFB8351C2E8B7BDB0), Q_UINT64_C(0x7C405F4C9F221C8E),
	Q_UINT64_C(0xFCE6AB71021DE98), Q_UINT64_C(0xA6DE79D191C5BFF),
	Q_UINT64_C(0x27E335014D1B9C9A), Q_UINT64_C(0xD90F3E4CD5F89197),
	Q_UINT64_C(0xC7661934556BA7A8), Q_UINT64_C(0xA83D7DF0D6894E69),
	Q_UINT64_C(0x8210B39249842AF9), Q_UINT64_C(0x17BBCC1A6D735787),
	Q_UINT64_C(0xC3D661A849C875C8), Q_UINT64_C(0xDC53F25423C66F19),
	Q_UINT64_C(0xF96C75380BC02186), Q_UINT64_C(0x21CBAFD4C0D6848),
	Q_UINT64_C(0x247010A03E5CF51C), Q_UINT64_C(0x6C11ED84379DC9AE),
	Q_UINT64_C(0xD16FB42BBDA90271), Q_UINT64_C(0xFD023F3F1F453A83),
	Q_UINT64_C(0x3D882B6F10446821), Q_UINT64_C(0x4072D1701BD415D6),
	Q_UINT64_C(0xFD7189C606734992), Q_UINT64_C(0xC8C62376C9652D78),
	Q_UINT64_C(0x201E5F2B698D5E95), Q_UINT64_C(0xE1B16D9EC0A5C5E3),
	Q_UINT64_C(0xEACF54BBF3975A22), Q_UINT64_C(0x990E3AB6B17FA0E6),
	Q_UINT64_C(0x7E682E91F1AAAF2), Q_UINT64_C(0x4CE0BBEA52F42178),
	Q_UINT64_C(0x86C188FA02E320DF), Q_UINT64_C(0xB1E5EC76AE342E4D),
	Q_UINT64_C(0xA52E99E5554B6AFD), Q_UINT64_C(0x12B19D5E941DA1B4),
	Q_UINT64_C(0xAAF76C4E9CA21862), Q_UINT64_C(0xA5144587F1792BC4),
	Q_UINT64_C(0x6CC6E30EB7F77E6F), Q_UINT64_C(0x36572065655FAE54),
	Q_UINT64_C(0xCAE0A3DAA1E06FA3), Q_UINT64_C(0x3FEB48F4895E1584),
	Q_UINT64_C(0xA88CCAB0FA4EE30), Q_UINT64_C(0x8DAB1841E2F84C40),
	Q_UINT64_C(0xFB7A00C8043BE013), Q_UINT64_C(0x5ED9E2DC2215AF7B),
	Q_UINT64_C(0x8DB0CBCCA0F68FE7), Q_UINT64_C(0x4D51E47230B867C1),
	Q_UINT64_C(0x6775C508E1CCD5D8), Q_UINT64_C(0xFA1A2DA3AD9C5B65),
	Q_UINT64_C(0xB2A20BB50E9B0C4B), Q_UINT64_C(0x6FDEB94102560E30),
	Q_UINT64_C(0x29E5701B728E2B83), Q_UINT64_C(0xDC35D9130F2E8A1),
	Q_UINT64_C(0x7A8501FB0246C854), Q_UINT64_C(0x2EB80C6E325C99B8),
	Q_UINT64_C(0x84B84C9705BA4A7), Q_UINT64_C(0x572E25237895BBCB),
	Q_UINT64_C(0x2499DDCB8A52E8D4), Q_UINT64_C(0x9F9227406C0ECACC),
	Q_UINT64_C(0x5BDD304652451E16), Q_UINT64_C(0xD204D3662CB12D20),
	Q_UINT64_C(0xEFA7333DD025C3A0), Q_UINT64_C(0x502008F4E361A790),
	Q_UINT64_C(0x5422878B6D63A28D), Q_UINT64_C(0x57EA1309901E3799),
	Q_UINT64_C(0x810E4472184B75B), Q_UINT64_C(0x848A726F601132A8),
	Q_UINT64_C(0x4F04EDFBFB4B90B6), Q_UINT64_C(0x45347400D78B8B56),
	Q_UINT64_C(0xC7B0F97213872C20), Q_UINT64_C(0xC2E9CE1F78DB4DD7),
	Q_UINT64_C(0x90915126A34565D), Q_UINT64_C(0xD98CBB3F1D1E57D9),
	Q_UINT64_C(0x4370428AD3DDCD87), Q_UINT64_C(0xDA78167267F99DF0),
	Q_UINT64_C(0xBE5DAAE58DD48A2C), Q_UINT64_C(0x35664CD7D5E5EF77),
	Q_UINT64_C(0x65BDC6AB5BC4A633), Q_UINT64_C(0x4019C83C9D2750F3),
	Q_UINT64_C(0x3BB65C74B4733445), Q_UINT64_C(0x98189972C1BA5539),
	Q_UINT64_C(0x270186D9E59D9A63), Q_UINT64_C(0xA9D90E5BCFDF6640),
	Q_UINT64_C(0x41A9FD29A12AD630), Q_UINT64_C(0x291BDB539A97875C),
	Q_UINT64_C(0x87B9659D303F5B0D), Q_UINT64_C(0x657DBFC811A0AA0A),
	Q_UINT64_C(0x38BE0CC6BDE6A582), Q_UINT64_C(0xC673A82DAE6972AB),
	Q_UINT64_C(0x3A6EA0C46BBBC661), Q_UINT64_C(0xF40CC7C8FC32C0F2),
	Q_UINT64_C(0x5CB7D55A6B7E6E1E), Q_UINT64_C(0xB43566E858D291EE),
	Q_UINT64_C(0x59B312AF98C8FD2F), Q_UINT64_C(0x18386F803BCD7F8C),
	Q_UINT64_C(0x798D98841D271DE3), Q_UINT64_C(0xDD57C06F11890520),
	Q_UINT64_C(0x1A319D7F23B6C58B), Q_UINT64_C(0xD373A11484002A84),
	Q_UINT64_C(0x919772C4E816976A), Q_UINT64_C(0x323EA2EB344DDF45),
	Q_UINT64_C(0xA88210C9C9DD12E7), Q_UINT64_C(0xE82DCA0C000905CC),
	Q_UINT64_C(0x5F80536DBC65CB37), Q_UINT64_C(0xB6E83C64A8C63920),
	Q_UINT64_C(0xD8C32EA7B317196D), Q_UINT64_C(0x9D3D8176072F6C7B),
	Q_UINT64_C(0xFD901B89A5707920), Q_UINT64_C(0x2F76A55E7FE24053),
	Q_UINT64_C(0x8CBC6C6D65F67CC2), Q_UINT64_C(0x501BBC4CC57B461A),
	Q_UINT64_C(0xE0E16D79C9AE0CAF), Q_UINT64_C(0x7F562EC9CDD3982F),
	Q_UINT64_C(0xC96310A34702F396), Q_UINT64_C(0xCFC362F4430B5EF3),
	Q_UINT64_C(0x2B6FF9ABAACC7BFC), Q_UINT64_C(0x7814AC5F6C1D2FBD),
	Q_UINT64_C(0xAF9EEB17929C7ABC), Q_UINT64_C(0x657116BFB38E6A42),
	Q_UINT64_C(0x6753FDA13F3F34DE), Q_UINT64_C(0x506896E24E95219A),
	Q_UINT64_C(0x95FBBA6BCF739011), Q_UINT64_C(0x2716168415F038F8),
	Q_UINT64_C(0x6EBE6D2348C29003), Q_UINT64_C(0xD814EBE4AECD6AF8),
	Q_UINT64_C(0x1AC33A0A4AA38554), Q_UINT64_C(0xEBD9BD4229A232C6),
	Q_UINT64_C(0x2209FF676F997607), Q_UINT64_C(0x1E6C0A1E87B5FC8F),
	Q_UINT64_C(0xA32B40FCFEFFB73A), Q_UINT64_C(0x9E66241A90494EAD),
	Q_UINT64_C(0xFAC0229EB8F94673), Q_UINT64_C(0xBFD1BE58EDE3B1A3),
	Q_UINT64_C(0xB62A31D30FE88C52), Q_UINT64_C(0xEA005EB1550946B3),
	Q_UINT64_C(0xA32BC4D3A932CD9), Q_UINT64_C(0xBE4508CD24443F17),
	Q_UINT64_C(0x40653286D15285B), Q_UINT64_C(0xDDDDE1C07985BEF4),
	Q_UINT64_C(0x5B92A09DBAE97D5C), Q_UINT64_C(0x18A000D5196CBA60),
	Q_UINT64_C(0x6B0E272EE83882EF), Q_UINT64_C(0x94185A2DD7788052),
	Q_UINT64_C(0x3AF09C275811C225), Q_UINT64_C(0x4B4899C3007D1F4A),
	Q_UINT64_C(0x2AC4FEA59959C8BD), Q_UINT64_C(0x54B2AAAB423CDB5B),
	Q_UINT64_C(0x5FE4256A910C51B), Q_UINT64_C(0xC97524AE38F9B925),
	Q_UINT64_C(0x78786D407892D92F), Q_UINT64_C(0xCAE6F59E1A19D47F),
	Q_UINT64_C(0x6FB3810952C4733), Q_UINT64_C(0xFDAF8AA047D33586),
	Q_UINT64_C(0x81EC2DDD030DDFAF), Q_UINT64_C(0xFA7240FCF173F90F),
	Q_UINT64_C(0x9F2BCB0B9616F985), Q_UINT64_C(0xE550E9BC77E2CB8D),
	Q_UINT64_C(0xF036ABBB3C626752), Q_UINT64_C(0x60D465941613203A),
	Q_UINT64_C(0xFDE3F2A16A014E7C), Q_UINT64_C(0xDD179BEA2693EEFD),
	Q_UINT64_C(0x1005D553EBF8DF4A), Q_UINT64_C(0x1B11CBC06B7694CE),
	Q_UINT64_C(0xE1AEE68F33F3AEDF), Q_UINT64_C(0x19D605AC0BB75EBA),
	Q_UINT64_C(0x53B3F5ECA1E49AB1), Q_UINT64_C(0xA7B919CEE0D922A7),
	Q_UINT64_C(0xC9DEF1ACA9E566C4), Q_UINT64_C(0xA21FA08BBA43F7C3),
	Q_UINT64_C(0xDA2DFFF4767F9DF7), Q_UINT64_C(0xA429F6E915699B51),
	Q_UINT64_C(0x5559358491F4020C), Q_UINT64_C(0xA6C6DD2AD5A90CE),
	Q_UINT64_C(0x799E81F05BC93F31), Q_UINT64_C(0x86536B8CF3428A8C),
	Q_UINT64_C(0x97D7374C60087B73), Q_UINT64_C(0xA246637CFF328532),
	Q_UINT64_C(0x43FCAE60CC0EBA0), Q_UINT64_C(0x920E449535DD359E),
	Q_UINT64_C(0x70EB093B15B290CC), Q_UINT64_C(0x73A1921916591CBD),
	Q_UINT64_C(0xCE1AE056E48417C9), Q_UINT64_C(0x5C002D0C209583CE),
	Q_UINT64_C(0xB9FD7620E7316243), Q_UINT64_C(0x5A7E8A57DB91B77),
	Q_UINT64_C(0xB5889C6E15630A75), Q_UINT64_C(0x4A750A09CE9573F7),
	Q_UINT64_C(0xCF464CEC899A2F8A), Q_UINT64_C(0xF538639CE705B824),
	Q_UINT64_C(0x3C79A0FF5580EF7F), Q_UINT64_C(0xEDE6C87F8477609D),
	Q_UINT64_C(0xFB951877C06E057C), Q_UINT64_C(0xA843D943A544EE86),
	Q_UINT64_C(0x2171E64683023A08), Q_UINT64_C(0x5B9B63EB9CEFF80C),
	Q_UINT64_C(0x506AACF489889342), Q_UINT64_C(0x1881AFC9A3A701D6),
	Q_UINT64_C(0x6503080440750644), Q_UINT64_C(0xDFD395339CDBF4A7),
	Q_UINT64_C(0xEF927DBCF00C20F2), Q_UINT64_C(0x7B32F7D1E03680EC),
	Q_UINT64_C(0x9FFC4884A28CA647), Q_UINT64_C(0xFC751A94DFCCB6A1),
	Q_UINT64_C(0x9C1633264DB49C89), Q_UINT64_C(0xB3F22C3D0B0B38ED),
	Q_UINT64_C(0x390E5FB44D01144B), Q_UINT64_C(0x5BFEA5B4712768E9),
	Q_UINT64_C(0x1E1032911FA78984), Q_UINT64_C(0x9A74ACB964E78CB3),
	Q_UINT64_C(0x4F80F7A035DAFB04), Q_UINT64_C(0x6304D09A0B3738C4),
	Q_UINT64_C(0xA2ACCA35B04BDFEA), Q_UINT64_C(0x72C532DDDF863AFB),
	Q_UINT64_C(0x87B3E2B2B5C907B1), Q_UINT64_C(0xA366E5B8C54F48B8),
	Q_UINT64_C(0xAE4A9346CC3F7CF2), Q_UINT64_C(0x1920C04D47267BBD),
	Q_UINT64_C(0x87BF02C6B49E2AE9), Q_UINT64_C(0x92237AC237F3859),
	Q_UINT64_C(0xFF07F64EF8ED14D0), Q_UINT64_C(0x8DE8DCA9F03CC54E),
	Q_UINT64_C(0x44ACA94945C31026), Q_UINT64_C(0x1ECFBF01B1129F68),
	Q_UINT64_C(0x27E6AD7891165C3F), Q_UINT64_C(0x8535F040B9744FF1),
	Q_UINT64_C(0x54B3F4FA5F40D873), Q_UINT64_C(0x72B12C32127FED2B),
	Q_UINT64_C(0xEE954D3C7B411F47), Q_UINT64_C(0x9A85AC909A24EAA1),
	Q_UINT64_C(0x70AC4CD9F04F21F5), Q_UINT64_C(0xF9B89D3E99A075C2),
	Q_UINT64_C(0xDF917C6D8CA75A72), Q_UINT64_C(0x5C0CF4C49BADEED1),
	Q_UINT64_C(0x14ACBAF4777D5776), Q_UINT64_C(0xF145B6BECCDEA195),
	Q_UINT64_C(0xDABF2AC8201752FC), Q_UINT64_C(0x24C3C94DF9C8D3F6),
	Q_UINT64_C(0xBB6E2924F03912EA), Q_UINT64_C(0xCE26C0B95C980D9),
	Q_UINT64_C(0xA49CD132BFBF7CC4), Q_UINT64_C(0xE99D662AF4243939),
	Q_UINT64_C(0xD00C37F7FB6ACA8E), Q_UINT64_C(0x6E026BE8C6604B9F),
	Q_UINT64_C(0x5355F900C2A82DC7), Q_UINT64_C(0x7FB9F855A997142),
	Q_UINT64_C(0x5093417AA8A7ED5E), Q_UINT64_C(0x7BCBC38DA25A7F3C),
	Q_UINT64_C(0x19FC8A768CF4B6D4), Q_UINT64_C(0x637A7780DECFC0D9),
	Q_UINT64_C(0x8249A47AEE0E41F7), Q_UINT64_C(0x79AD695501E7D1E8),
	Q_UINT64_C(0x7F08F6327D2E9850), Q_UINT64_C(0x616174F6AA9B6FB5),
	Q_UINT64_C(0x2BA04114676403F7), Q_UINT64_C(0x4CD364C99A21AFF4),
	Q_UINT64_C(0x4CA343F0A3F0D93E), Q_UINT64_C(0xF282424CEF98035B),
	Q_UINT64_C(0xFCF4501947B20AE), Q_UINT64_C(0xD91323B4C22F57B1),
	Q_UINT64_C(0xA63060012A95BBDD), Q_UINT64_C(0xBD142194FE4D22CE),
	Q_UINT64_C(0xEBEE7B52E375FF8E), Q_UINT64_C(0xF12D5DB3D062400B),
	Q_UINT64_C(0x9AE21EB2CAE9B65F), Q_UINT64_C(0xAC359DE9BD27329A),
	Q_UINT64_C(0xD2DDE3B7C684831C), Q_UINT64_C(0xB9834E0ABCB685BE),
	Q_UINT64_C(0xDDB2B6D22145094C), Q_UINT64_C(0x5E0B6BBD43B7605),
	Q_UINT64_C(0xAABA573156EADD82), Q_UINT64_C(0xBED8E6095383FA7B),
	Q_UINT64_C(0x4054E51F6431C996), Q_UINT64_C(0x3B5030F00793C5D2),
	Q_UINT64_C(0x903BFCE2E4037ADF), Q_UINT64_C(0x12EF53585E7C1B36),
	Q_UINT64_C(0x3B136FD4F47A0234), Q_UINT64_C(0x70276A9020157374),
	Q_UINT64_C(0xDE54BD5D3BEAEDE9), Q_UINT64_C(0xF97513F6C0D163B9),
	Q_UINT64_C(0x7E474BE4FAB6E17F), Q_UINT64_C(0x90D331A41308B8F3),
	Q_UINT64_C(0xF151CDE862BEE4DD), Q_UINT64_C(0x1ACB89A43A2C593E),
	Q_UINT64_C(0x6F7CF66CD2D40A72), Q_UINT64_C(0x31EF2592A2D55578),
	Q_UINT64_C(0xB269CAB20F5C0EDC), Q_UINT64_C(0xDB32183B09E37DFC),
	Q_UINT64_C(0x7C77C6875117E9B1), Q_UINT64_C(0xB31B9639F9154FFF),
	Q_UINT64_C(0xB5097FDD1F96DF21), Q_UINT64_C(0x8604196E9D42CAAD),
	Q_UINT64_C(0xBD1901B905911DA8), Q_UINT64_C(0x60C42F5DEF3BD6A2),
	Q_UINT64_C(0xF678647E3519AC6E), Q_UINT64_C(0x1B85D488D0F20CC5),
	Q_UINT64_C(0xDAB9FE6525D89021), Q_UINT64_C(0xD151D86ADB73615),
	Q_UINT64_C(0xA865A54EDCC0F019), Q_UINT64_C(0x93C42566AEF98FFB),
	Q_UINT64_C(0x99E7AFEABE000731), Q_UINT64_C(0x48CBFF086DDF285A),
	Q_UINT64_C(0x8854D4B8D00F1EB7), Q_UINT64_C(0x15035A7756C335E2),
	Q_UINT64_C(0x4FEABFBBDB619CB), Q_UINT64_C(0x742E1E651C60BA83),
	Q_UINT64_C(0x9A9632E65904AD3C), Q_UINT64_C(0x881B82A13B51B9E2),
	Q_UINT64_C(0x506E6744CD974924), Q_UINT64_C(0xB0183DB56FFC6A79),
	Q_UINT64_C(0xED9B915C66ED37E), Q_UINT64_C(0x5E11E86D5873D484),
	Q_UINT64_C(0xB57E7CEB56A30E41), Q_UINT64_C(0x688E67F6CFB85DE6),
	Q_UINT64_C(0x722FF175F572C348), Q_UINT64_C(0x1D1260A51107FE97),
	Q_UINT64_C(0x7A249A57EC0C9BA2), Q_UINT64_C(0x4208FE9E8F7F2D6),
	Q_UINT64_C(0x5A110C6058B920A0), Q_UINT64_C(0xCD9A497658A5698),
	Q_UINT64_C(0x56FD23C8F9715A4C), Q_UINT64_C(0x284C847B9D887AAE),
	Q_UINT64_C(0x51D3FBA464B2FF8E), Q_UINT64_C(0xF9770FE3DA06C6ED),
	Q_UINT64_C(0xA90B24499FCFAFB1), Q_UINT64_C(0x77A225A07CC2C6BD),
	Q_UINT64_C(0x513E5E634C70E331), Q_UINT64_C(0x4361C0CA3F692F12),
	Q_UINT64_C(0xD941ACA44B20A45B), Q_UINT64_C(0x528F7C8602C5807B),
	Q_UINT64_C(0x52AB92BEB9613989), Q_UINT64_C(0x9D1DFA2EFC557F73),
	Q_UINT64_C(0x899FAE4CD6BB109B), Q_UINT64_C(0x16B36DC740EF867),
	Q_UINT64_C(0x40E087931A00930D), Q_UINT64_C(0x8CFFA9412EB642C1),
	Q_UINT64_C(0x68CA39053261169F), Q_UINT64_C(0x7A1EE967D27579E2),
	Q_UINT64_C(0x9D1D60E5076F5B6F), Q_UINT64_C(0x3810E399B6F65BA2),
	Q_UINT64_C(0x32095B6D4AB5F9B1), Q_UINT64_C(0x35CAB62109DD038A),
	Q_UINT64_C(0x89E2311CAC5D17C8), Q_UINT64_C(0xEC921AB8C861035E),
	Q_UINT64_C(0x87D380BDA5BF7859), Q_UINT64_C(0x16B9F7E06C453A21),
	Q_UINT64_C(0x7BA2484C8A0FD54E), Q_UINT64_C(0xF3A678CAD9A2E38C),
	Q_UINT64_C(0x39B0BF7DDE437BA2), Q_UINT64_C(0xFCAF55C1BF8A4424),
	Q_UINT64_C(0x18FCF680573FA594), Q_UINT64_C(0x4C0563B89F495AC3),
	Q_UINT64_C(0xC21BF7D74B3CCB11), Q_UINT64_C(0xA08289F5E0F81C39),
	Q_UINT64_C(0xD2B7ADEEDED1F73F), Q_UINT64_C(0xF7A255D83BC373F8),
	Q_UINT64_C(0xD7F4F2448C0CEB81), Q_UINT64_C(0xD95BE88CD210FFA7),
	Q_UINT64_C(0x336F52F8FF4728E7), Q_UINT64_C(0xA74049DAC312AC71),
	Q_UINT64_C(0xA2F61BB6E437FDB5), Q_UINT64_C(0x4F2A5CB07F6A35B3),
	Q_UINT64_C(0xD77D40BEC1B47726), Q_UINT64_C(0x1A9904D40FD6294F),
	Q_UINT64_C(0xC547F57E42A7444E), Q_UINT64_C(0x78E37644E7CAD29E),
	Q_UINT64_C(0xFE9A44E9362F05FA), Q_UINT64_C(0x8BD35CC38336615),
	Q_UINT64_C(0x9315E5EB3A129ACE), Q_UINT64_C(0x94061B871E04DF75),
	Q_UINT64_C(0xDF1D9F9D784BA010), Q_UINT64_C(0x3BBA57B68871B59D),
	Q_UINT64_C(0x4EFA096C3993EA30), Q_UINT64_C(0x77CB914FC38B518D),
	Q_UINT64_C(0x2B2CD3C13AB74613), Q_UINT64_C(0x96DBBDCE4C61DFF9),
	Q_UINT64_C(0xC351E7003628291F), Q_UINT64_C(0xBB22FFD391C084AB),
	Q_UINT64_C(0x816C900BE8FA35A9), Q_UINT64_C(0x6F19CAEA234653FB),
	Q_UINT64_C(0xB20F27046A1E30ED), Q_UINT64_C(0xA6BDF4EA6610A00D),
	Q_UINT64_C(0xA81DE1EEC60A54A7), Q_UINT64_C(0x64EE3B82A7EF3666),
	Q_UINT64_C(0x741D4AB853685B2F), Q_UINT64_C(0xABF0B642DE57D30E),
	Q_UINT64_C(0x143C428B608A8E1E), Q_UINT64_C(0xA47107358D53127A),
	Q_UINT64_C(0x276E9E8F9B1C0E08), Q_UINT64_C(0xC5ACDDF5F0693605),
	Q_UINT64_C(0x33716260CBFD5CF8), Q_UINT64_C(0xF30F952752ED7ECA),
	Q_UINT64_C(0x65E197277D8F4FD8), Q_UINT64_C(0xB747E119AA67766C),
	Q_UINT64_C(0xCA2AACDB3C82638B), Q_UINT64_C(0x828B42055B7D639B),
	Q_UINT64_C(0xCBE56A48E523E5E7), Q_UINT64_C(0xEBB06F391E722323),
	Q_UINT64_C(0x160A97FA53619750), Q_UINT64_C(0x1745DCEA893DA6B),
	Q_UINT64_C(0x6A611EBA1D3A26B1), Q_UINT64_C(0x43F3AACA76E645A8),
	Q_UINT64_C(0xA9ADE905A4ED3D6D), Q_UINT64_C(0xAF66F55917303882),
	Q_UINT64_C(0x418E01A9C44AAED4), Q_UINT64_C(0xFBD4870C3DEAA3D1),
	Q_UINT64_C(0x38ABC9194B251C18), Q_UINT64_C(0x406B6B24EF4499F1),
	Q_UINT64_C(0x8E73027027EE8713), Q_UINT64_C(0xCE1B4EB4E8B2755A),
	Q_UINT64_C(0x8BB7361F189005D3), Q_UINT64_C(0xDFACEC9FF262F74C),
	Q_UINT64_C(0x568362AB91CD0CDA), Q_UINT64_C(0x545359E58BBB19F),
	Q_UINT64_C(0x3D5774A11D31AB39), Q_UINT64_C(0x8A1B083821F40CB4),
	Q_UINT64_C(0x7B4A38E32537DF62), Q_UINT64_C(0x950113646D1D6E03),
	Q_UINT64_C(0x4DA8979A0041E8A9), Q_UINT64_C(0x3BC36E078F7515D7),
	Q_UINT64_C(0x5D0A12F27AD310D1), Q_UINT64_C(0x7F9D1A2E1EBE1327),
	Q_UINT64_C(0xA1041B7E3778684F), Q_UINT64_C(0xBEF86AE14588663F),
	Q_UINT64_C(0xE479EE5B9930578C), Q_UINT64_C(0xE7F28ECD2D49EECD),
	Q_UINT64_C(0x56C074A581EA17FE), Q_UINT64_C(0x5544F7D774B14AEF),
	Q_UINT64_C(0x7B3F0195FC6F290F), Q_UINT64_C(0x12153635B2C0CF57),
	Q_UINT64_C(0x7F5126DBBA5E0CA7), Q_UINT64_C(0x7A76956C3EAFB413),
	Q_UINT64_C(0xEF9F9039B5687E59), Q_UINT64_C(0xE03E65585470E7B7),
	Q_UINT64_C(0x829626E3892D95D7), Q_UINT64_C(0x92FAE24291F2B3F1),
	Q_UINT64_C(0x63E22C147B9C3403), Q_UINT64_C(0xC678B6D860284A1C),
	Q_UINT64_C(0x5873888850659AE7), Q_UINT64_C(0x981DCD296A8736D),
	Q_UINT64_C(0x9F65789A6509A440), Q_UINT64_C(0x9FF38FED72E9052F),
	Q_UINT64_C(0xB2D4D11F648B0F8B), Q_UINT64_C(0x5677A505B0A72311),
	Q_UINT64_C(0xD2733C4335C6A72F), Q_UINT64_C(0x7E75D99D94A70F4D),
	Q_UINT64_C(0x6CED1983376FA72B), Q_UINT64_C(0x97FCAACBF030BC24),
	Q_UINT64_C(0x7B77497B32503B12), Q_UINT64_C(0x8547EDDFB81CCB94),
	Q_UINT64_C(0x79999CDFF70902CB), Q_UINT64_C(0xCFFE1939438E9B24),
	Q_UINT64_C(0xE9F631D64A15A88B), Q_UINT64_C(0x3ADAE26BACF0CF3D),
	Q_UINT64_C(0xB7A0B174CFF6F36E), Q_UINT64_C(0xD4DBA84729AF48AD),
	Q_UINT64_C(0x2E18BC1AD9704A68), Q_UINT64_C(0x2DE0966DAF2F8B1C),
	Q_UINT64_C(0xB9C11D5B1E43A07E), Q_UINT64_C(0x64972D68DEE33360),
	Q_UINT64_C(0x94628D38D0C20584), Q_UINT64_C(0xDBC0D2B6AB90A559),
	Q_UINT64_C(0x4637EE463E27655D), Q_UINT64_C(0xF23CE066ABF1241C),
	Q_UINT64_C(0x1DD01AAFCD53486A), Q_UINT64_C(0x1FCA8A92FD719F85),
	Q_UINT64_C(0xFC7C95D827357AFA), Q_UINT64_C(0x18A6A990C8B35EBD),
	Q_UINT64_C(0xCCCB7005C6B9C28D), Q_UINT64_C(0x3BDBB92C43B17F26),
	Q_UINT64_C(0xAA70B5B4F89695A2), Q_UINT64_C(0xE94C39A54A98307F),
	Q_UINT64_C(0x784B11D6292BA5D), Q_UINT64_C(0x47E2EC47068CF37E),
	Q_UINT64_C(0x11317BA87905E790), Q_UINT64_C(0x7FBF21EC8A1F45EC),
	Q_UINT64_C(0x1725CABFCB045B00), Q_UINT64_C(0x964E915CD5E2B207),
	Q_UINT64_C(0x3E2B8BCBF016D66D), Q_UINT64_C(0xBE7444E39328A0AC),
	Q_UINT64_C(0xF85B2B4FBCDE44B7), Q_UINT64_C(0x49353FEA39BA63B1),
	Q_UINT64_C(0x54534340E2C7C25), Q_UINT64_C(0xCBE3A7499046CB36),
	Q_UINT64_C(0x23B70EDB1955C4BF), Q_UINT64_C(0xC330DE426430F69D),
	Q_UINT64_C(0x4715ED43E8A45C0A), Q_UINT64_C(0xA8D7E4DAB780A08D),
	Q_UINT64_C(0x572B974F03CE0BB), Q_UINT64_C(0xB57D2E985E1419C7),
	Q_UINT64_C(0xE8D9ECBE2CF3D73F), Q_UINT64_C(0x2FE4B17170E59750),
	Q_UINT64_C(0xD49A5DFDAE0A5872), Q_UINT64_C(0x3DC7D4E4167963EE),
	Q_UINT64_C(0xFF172C0EDC26E796), Q_UINT64_C(0x6A477FA8D26E7FE6),
	Q_UINT64_C(0x71C636E3094C1B2E), Q_UINT64_C(0xDFC6202EB8AE5DBD),
	Q_UINT64_C(0x55D035B7BFB78D57), Q_UINT64_C(0x683CC7F6AEE35B37),
	Q_UINT64_C(0x717BF12777C01265), Q_UINT64_C(0x605A94F1EEDA57B8),
	Q_UINT64_C(0x29EF5F9C324ECE9D), Q_UINT64_C(0x18588FCCCFDCEAA5),
	Q_UINT64_C(0xB14425AFF8350B88), Q_UINT64_C(0x71C429FC21C26D18),
	Q_UINT64_C(0x243B6FC154C4DCB8), Q_UINT64_C(0x83CEF85126C0016E),
	Q_UINT64_C(0x6E0E99F13CA0BA26), Q_UINT64_C(0xE7E273CFE048DD7B),
	Q_UINT64_C(0xAC3B275CCE403191), Q_UINT64_C(0x7121D93AFF7EDE87),
	Q_UINT64_C(0x195D44062E46EE1), Q_UINT64_C(0xFD8E8FC93BB16403),
	Q_UINT64_C(0xDA52E2993CF7DC6), Q_UINT64_C(0xA601FA61EAE4B090),
	Q_UINT64_C(0x34514495CA2F51C9), Q_UINT64_C(0x715E1AFFBBCC508C),
	Q_UINT64_C(0x14DA7808379161F0), Q_UINT64_C(0x534EE54EF4960AC7),
	Q_UINT64_C(0x49A57E644EC5AAB7), Q_UINT64_C(0x7EF949307896F221),
	Q_UINT64_C(0xDF609E04F356AA37), Q_UINT64_C(0xFFFDF4D4A34ABDF0),
	Q_UINT64_C(0x4305193E0332F368), Q_UINT64_C(0x89E235DAF37D00DF),
	Q_UINT64_C(0x5397CB5C78380A59), Q_UINT64_C(0xC5DF26FB2EEA1BAA),
	Q_UINT64_C(0xEA3578F6B90091E7), Q_UINT64_C(0x7CB3531DCAB61A06),
	Q_UINT64_C(0x57CD5EB0C095DFD7), Q_UINT64_C(0x1ADB8862C4ED469D),
	Q_UINT64_C(0xC66D79EA66E23459), Q_UINT64_C(0x6BD6E3FBCA467509),
	Q_UINT64_C(0xEBE9EA2ADF4321C7), Q_UINT64_C(0x3219A39EE587A30),
	Q_UINT64_C(0x49787FEF17AF9924), Q_UINT64_C(0xA1E9300CD8520548),
	Q_UINT64_C(0x5B45E522E4B1B4EF), Q_UINT64_C(0xB49C3B3995091A36),
	Q_UINT64_C(0xD4490AD526F14431), Q_UINT64_C(0x12A8F216AF9418C2),
	Q_UINT64_C(0xDEC4A244062E1D5B), Q_UINT64_C(0x478EDC03D9887A6D),
	Q_UINT64_C(0xABEEDDB2DDE06FF1), Q_UINT64_C(0x58EFC10B06A2068D),
	Q_UINT64_C(0xC6E57A78FBD986E0), Q_UINT64_C(0x2EAB8CA63CE802D7),
	Q_UINT64_C(0x14A195640116F336), Q_UINT64_C(0x7C0828DD624EC390),
	Q_UINT64_C(0xD74BBE77E6116AC7), Q_UINT64_C(0x804456AF10F5FB53),
	Q_UINT64_C(0x5B7729619ED8F9A7), Q_UINT64_C(0xD142DE229B57D1A9),
	Q_UINT64_C(0x2472F6207C2D0484), Q_UINT64_C(0xC2A1E7B5B459AEB5),
	Q_UINT64_C(0xAB4F6451CC1D45EC), Q_UINT64_C(0x63767572AE3D6174),
	Q_UINT64_C(0xA59E0BD101731A28), Q_UINT64_C(0x116D0016CB948F09),
	Q_UINT64_C(0x2CF9C8CA052F6E9F), Q_UINT64_C(0xB090A7560A968E3),
	Q_UINT64_C(0x56851C604AEB8775), Q_UINT64_C(0xDF89B35FADE795AC),
	Q_UINT64_C(0xEB3593803173E0CE), Q_UINT64_C(0x9C4CD6257C5A3603),
	Q_UINT64_C(0xAF0C317D32ADAA8A), Q_UINT64_C(0x258E5A80C7204C4B),
	Q_UINT64_C(0x8B889D624D44885D), Q_UINT64_C(0xF4D14597E660F855),
	Q_UINT64_C(0xD4347F66EC8941C3), Q_UINT64_C(0xE699ED85B0DFB40D),
	Q_UINT64_C(0xF7D517A5F7CBF696), Q_UINT64_C(0xE102AD12F54FAD76),
	Q_UINT64_C(0x1FE2CCA76517DB90), Q_UINT64_C(0xD7504DFA8816EDBB),
	Q_UINT64_C(0xB9571FA04DC089C8), Q_UINT64_C(0x1DDC0325259B27DE),
	Q_UINT64_C(0xCF3F4688801EB9AA), Q_UINT64_C(0xF4F5D05C10CAB243),
	Q_UINT64_C(0x38B6525C21A42B0E), Q_UINT64_C(0x36F60E2BA4FA6800),
	Q_UINT64_C(0xE31A5399C74DD277), Q_UINT64_C(0x5EBC9CDB03510A45),
	Q_UINT64_C(0x66C1A2A1A60CD889), Q_UINT64_C(0x9E17E49642A3E4C1),
	Q_UINT64_C(0xEDB454E7BADC0805), Q_UINT64_C(0x50B704CAB602C329),
	Q_UINT64_C(0x4CC317FB9CDDD023), Q_UINT64_C(0x66B4835D9EAFEA22),
	Q_UINT64_C(0x219B97E26FFC81BD), Q_UINT64_C(0x261E4E4C0A333A9D),
	Q_UINT64_C(0x43A8D61177324CD), Q_UINT64_C(0x6027FEADFD96EFA7),
	Q_UINT64_C(0x4ED0FE7E9DC91335), Q_UINT64_C(0xE4DBF0634473F5D2),
	Q_UINT64_C(0x1761F93A44D5AEFE), Q_UINT64_C(0x53898E4C3910DA55),
	Q_UINT64_C(0x734DE8181F6EC39A), Q_UINT64_C(0x2680B122BAA28D97),
	Q_UINT64_C(0x298AF231C85BAFAB), Q_UINT64_C(0x7983EED3740847D5),
	Q_UINT64_C(0x4B056DF8B0E913AD), Q_UINT64_C(0x927490C42469E7AD),
	Q_UINT64_C(0xA09E8C8C35AB96DE), Q_UINT64_C(0xFA7E393983325753),
	Q_UINT64_C(0xD6B6D0ECC617C699), Q_UINT64_C(0xDFEA21EA9E7557E3),
	Q_UINT64_C(0xB67C1FA481680AF8), Q_UINT64_C(0xCA1E3785A9E724E5),
	Q_UINT64_C(0x1CFC8BED0D681639), Q_UINT64_C(0xD18D8549D140CAEA),
	Q_UINT64_C(0x8831C46CD07C4C07), Q_UINT64_C(0x81E8FB81F242DD58),
	Q_UINT64_C(0xC27C2D12D7A2DB7E), Q_UINT64_C(0xF3A4D55F9DCE9B9A),
	Q_UINT64_C(0x445F4361A64917E0), Q_UINT64_C(0x7405D8483E0D7EFB),
	Q_UINT64_C(0x90BBDD9BF117116), Q_UINT64_C(0x1BD258C174253890),
	Q_UINT64_C(0xCFEB9676BC40468A), Q_UINT64_C(0x5287319C1C0D2D23),
	Q_UINT64_C(0xCE71D8BF1AB5E93D), Q_UINT64_C(0x57942ABB8BB173C8),
	Q_UINT64_C(0x3727A8A8700362DB), Q_UINT64_C(0x5FB3BA14587A35E1),
	Q_UINT64_C(0xFC9E7446427C7655), Q_UINT64_C(0xA4476AF0A4012A86),
	Q_UINT64_C(0xF9B85B290E8D9DC4), Q_UINT64_C(0xC070E9A44E258395),
	Q_UINT64_C(0x81418D459CC3EB26), Q_UINT64_C(0x691CE947F1F61284),
	Q_UINT64_C(0xF76AF56B007E777A), Q_UINT64_C(0xCFEAA9840C0ECD7F),
	Q_UINT64_C(0x61313703B982EC38), Q_UINT64_C(0x304306693E2C9379),
	Q_UINT64_C(0x4AA580CF2157F3DC), Q_UINT64_C(0x74D9AB10C6DB5526),
	Q_UINT64_C(0x2C2BADD9C0D4E255), Q_UINT64_C(0x1AF23D95844A7B4),
	Q_UINT64_C(0xDAEFF47F173D3EB5), Q_UINT64_C(0x48CF32761DFE0B66),
	Q_UINT64_C(0x868B17FE1893C3B7), Q_UINT64_C(0x2B89B3FEB722F15A),
	Q_UINT64_C(0x287BD163A7C660B7), Q_UINT64_C(0x9E5ACC12E101CAFC),
	Q_UINT64_C(0x643C9189D256EB68), Q_UINT64_C(0x5DCBAC3BB766C32B),
	Q_UINT64_C(0x1E68FB08CED5E58E), Q_UINT64_C(0xC9B45FA29D9E89CC),
	Q_UINT64_C(0xFEA4F373B72D45ED), Q_UINT64_C(0xF44A11EA3677A393),
	Q_UINT64_C(0xCC9AFD4BC48D4EE2), Q_UINT64_C(0x3C0E4393E4220F54),
	Q_UINT64_C(0xCD04F3FF001A4778), Q_UINT64_C(0xE3273522064480CA),
	Q_UINT64_C(0x9F91508BFFCFC14A), Q_UINT64_C(0x49A7F41061A9E60),
	Q_UINT64_C(0xFCB6BE43A9F2FE9B), Q_UINT64_C(0x8DE8A1C7797DA9B),
	Q_UINT64_C(0x8F9887E6078735A1), Q_UINT64_C(0xB5B4071DBFC73A66),
	Q_UINT64_C(0xA68AF6A1F4CF2B16), Q_UINT64_C(0x44119897998B4BE3),
	Q_UINT64_C(0x1F2B1D1F15F6DC9C), Q_UINT64_C(0xB69E38A8965C6B65),
	Q_UINT64_C(0xAA9119FF184CCCF4), Q_UINT64_C(0xF43C732873F24C13),
	Q_UINT64_C(0xFB4A3D794A9A80D2), Q_UINT64_C(0x3550C2321FD6109C),
	Q_UINT64_C(0x371F77E76BB8417E), Q_UINT64_C(0x6BFA9AAE5EC05779),
	Q_UINT64_C(0x80B46921877E7D9D), Q_UINT64_C(0xC70A712087829541),
	Q_UINT64_C(0x9C1169FA2777B874), Q_UINT64_C(0x78EDEFD694AF1EED),
	Q_UINT64_C(0x6DC93D9526A50E68), Q_UINT64_C(0xEE97F453F06791ED),
	Q_UINT64_C(0x32AB0EDB696703D3), Q_UINT64_C(0x3A6853C7E70757A7),
	Q_UINT64_C(0x31865CED6120F37D), Q_UINT64_C(0x67FEF95D92607890),
	Q_UINT64_C(0x6886EBFE977FF290), Q_UINT64_C(0x279E159591F0AA4),
	Q_UINT64_C(0x5092EF950A16DA0B), Q_UINT64_C(0x9338E69C052B8E7B),
	Q_UINT64_C(0x455A4B4CFE30E3F5), Q_UINT64_C(0x6B02E63195AD0CF8),
	Q_UINT64_C(0x6B17B224BAD6BF27), Q_UINT64_C(0xD1E0CCD25BB9C169),
	Q_UINT64_C(0xDE0C89A556B9AE70), Q_UINT64_C(0x50065E535A213CF6),
	Q_UINT64_C(0x303654A628BC4558), Q_UINT64_C(0x60536FAB6DD8FC7),
	Q_UINT64_C(0x22AF003AB672E811), Q_UINT64_C(0x52E762596BF68235),
	Q_UINT64_C(0x9AEBA33AC6ECC6B0), Q_UINT64_C(0x944F6DE09134DFB6),
	Q_UINT64_C(0x6C47BEC883A7DE39), Q_UINT64_C(0x6AD047C430A12104),
	Q_UINT64_C(0xA5B1CFDBA0AB4067), Q_UINT64_C(0x7C45D833AFF07862),
	Q_UINT64_C(0x77B47209CA3D1200), Q_UINT64_C(0xF374D0C88BF49710),
	Q_UINT64_C(0xC0C0F5A60EF4CDCF), Q_UINT64_C(0xCAF21ECD4377B28C),
	Q_UINT64_C(0x57277707199B8175), Q_UINT64_C(0x506C11B9D90E8B1D),
	Q_UINT64_C(0xD83CC2687A19255F), Q_UINT64_C(0x4A29C6465A314CD1),
	Q_UINT64_C(0xED2DF21216235097), Q_UINT64_C(0xB5635C95FF7296E2),
	Q_UINT64_C(0x6B8E3C0EAFC3AB32), Q_UINT64_C(0x3B31538038B70006),
	Q_UINT64_C(0xB0774D261CC609DB), Q_UINT64_C(0x443F64EC5A371195),
	Q_UINT64_C(0x4112CF68649A260E), Q_UINT64_C(0xD813F2FAB7F5C5CA),
	Q_UINT64_C(0x660D3257380841EE), Q_UINT64_C(0x59AC2C7873F910A3),
	Q_UINT64_C(0xE846963877671A17), Q_UINT64_C(0x93B633ABFA3469F8),
	Q_UINT64_C(0xDFA2F970B7554580), Q_UINT64_C(0x2810272A0A494442),
	Q_UINT64_C(0x6FFE73E81B637FB3), Q_UINT64_C(0xDDF957BC36D8B9CA),
	Q_UINT64_C(0x64D0E29EEA8838B3), Q_UINT64_C(0x8DD9BDFD96B9F63),
	Q_UINT64_C(0x87E79E5A57D1D13), Q_UINT64_C(0xE328E230E3E2B3FB),
	Q_UINT64_C(0x1C2559E30F0946BE), Q_UINT64_C(0x720BF5F26F4D2EAA),
	Q_UINT64_C(0x977DBD4995C0F49D), Q_UINT64_C(0xD60D58C26193C3C8),
	Q_UINT64_C(0xEC4A3BDFBB7E2C64), Q_UINT64_C(0x6962A54B9C36D0C9),
	Q_UINT64_C(0xF3EAB5E373BE9F6F), Q_UINT64_C(0x80A839811F81C77F),
	Q_UINT64_C(0xD0F186DF3AA2FA5D), Q_UINT64_C(0x398F9C5E392614CB),
	Q_UINT64_C(0x3A7B0200AF8B9549), Q_UINT64_C(0x4228B4C2D0BA809B),
	Q_UINT64_C(0x969F078D084BDF7F), Q_UINT64_C(0x5CC2DE17EC8795F3),
	Q_UINT64_C(0xF6EDF7ED3A63CBD8), Q_UINT64_C(0x7636B03C6F138C80),
	Q_UINT64_C(0xD69E826E8D6625D2), Q_UINT64_C(0xEA13A4A7503CFD81),
	Q_UINT64_C(0x1072E1F3D1DD7006), Q_UINT64_C(0x82AF6553BE1D8A3D),
	Q_UINT64_C(0x9F78E4296075737F), Q_UINT64_C(0x77DBC735A5D3BB73),
	Q_UINT64_C(0x24974B668E353CDC), Q_UINT64_C(0x1CD34226DC04B76D),
	Q_UINT64_C(0xAED23F34EFAF4BF7), Q_UINT64_C(0xB49738B8349614C8),
	Q_UINT64_C(0xA18F95B9EBE202B2), Q_UINT64_C(0x9C44E522CB2631B6),
	Q_UINT64_C(0x115F24C4DEA8E6A4), Q_UINT64_C(0x6BF1F99FDEE4334C),
	Q_UINT64_C(0xF60CCCB5B4EDDC4A), Q_UINT64_C(0xF8F920AB0E85CB7C),
	Q_UINT64_C(0xD2692E8FB4BDFB9E), Q_UINT64_C(0xECEEAFCC1FE49C7B),
	Q_UINT64_C(0x13791B1B5F18188), Q_UINT64_C(0x94CBADD1BDB8B58D),
	Q_UINT64_C(0xD9E8323A41FABA1B), Q_UINT64_C(0xF29ADDC93DB99E06),
	Q_UINT64_C(0x334CF776D70C454), Q_UINT64_C(0xA3A5054D333C7975),
	Q_UINT64_C(0xDB6B244EE93770EA), Q_UINT64_C(0xB30BB7F9B6A27E62),
	Q_UINT64_C(0x1E771E283DFD3DF3), Q_UINT64_C(0xD87DF748D4A935),
	Q_UINT64_C(0xF1BCC3D275AFE51A), Q_UINT64_C(0xE728E8C83C334074),
	Q_UINT64_C(0x96FBF83A12884624), Q_UINT64_C(0x81A1549FD6573DA5),
	Q_UINT64_C(0x5FA7867CAF35E149), Q_UINT64_C(0x56986E2EF3ED091B),
	Q_UINT64_C(0x917F1DD5F8886C61), Q_UINT64_C(0xD20D8C88C8FFE65F),
	Q_UINT64_C(0xBE1D061C9DA215A1), Q_UINT64_C(0xE403BA1D71679770),
	Q_UINT64_C(0x150F361DAB9DEC26), Q_UINT64_C(0x9F6A419D382595F4),
	Q_UINT64_C(0x64A53DC924FE7AC9), Q_UINT64_C(0x142DE49FFF7A7C3D),
	Q_UINT64_C(0xC335248857FA9E7), Q_UINT64_C(0xA9C32D5EAE45305),
	Q_UINT64_C(0xE6C42178C4BBB92E), Q_UINT64_C(0x71F1CE2490D20B07),
	Q_UINT64_C(0x28F84B43FD399EEB), Q_UINT64_C(0x493EA8F9753981DE),
	Q_UINT64_C(0x65FA4F227A2B6D79), Q_UINT64_C(0xD5F9E858292504D5),
	Q_UINT64_C(0xC2B5A03F71471A6F), Q_UINT64_C(0x59300222B4561E00),
	Q_UINT64_C(0xCE2F8642CA0712DC), Q_UINT64_C(0x7CA9723FBB2E8988),
	Q_UINT64_C(0x2785338347F2BA08), Q_UINT64_C(0xC61BB3A141E50E8C),
	Q_UINT64_C(0x2BCCBF617E17F7FA), Q_UINT64_C(0x92CEA15FEA1570),
	Q_UINT64_C(0x5E5637885F29BC2B), Q_UINT64_C(0x7EBA726D8C94094B),
	Q_UINT64_C(0xA56A5F0BFE39272), Q_UINT64_C(0xD79476A84EE20D06),
	Q_UINT64_C(0x9E4C1269BAA4BF37), Q_UINT64_C(0x17EFEE45B0DEE640),
	Q_UINT64_C(0x1D95B0A5FCF90BC6), Q_UINT64_C(0x93CBE0B699C2585D),
	Q_UINT64_C(0x246DFE9363A682E6), Q_UINT64_C(0x7EE353FCF5CD5DC2),
	Q_UINT64_C(0x7DC7785B8EFDFC80), Q_UINT64_C(0x8AF38731C02BA980),
	Q_UINT64_C(0x1FAB64EA29A2DDF7), Q_UINT64_C(0xE4D9429322CD065A),
	Q_UINT64_C(0x9DA058C67844F20C), Q_UINT64_C(0x24C0E332B70019B0),
	Q_UINT64_C(0x233003B5A6CFE6AD), Q_UINT64_C(0xD586BD01C5C217F6),
	Q_UINT64_C(0x16ED69B640345D52), Q_UINT64_C(0xD4B1D8F1C1379A10),
	Q_UINT64_C(0xF05D129681949A4C), Q_UINT64_C(0x964781CE734B3C84),
	Q_UINT64_C(0x9C2ED44081CE5FBD), Q_UINT64_C(0x522E23F3925E319E),
	Q_UINT64_C(0x177E00F9FC32F791), Q_UINT64_C(0x2BC60A63A6F3B3F2),
	Q_UINT64_C(0x222BBFAE61725606), Q_UINT64_C(0x486289DDCC3D6780),
	Q_UINT64_C(0xD8E615B98B2EDD71), Q_UINT64_C(0xDC0BD71B2BBBD2F8),
	Q_UINT64_C(0xF8549E1A3AA5E00D), Q_UINT64_C(0x7A69AFDCC42261A),
	Q_UINT64_C(0xC4C118BFE78FEAAE), Q_UINT64_C(0xF9F4892ED96BD438),
	Q_UINT64_C(0x1AF3DBE25D8F45DA), Q_UINT64_C(0xF5B4B0B0D2DEEEB4),
	Q_UINT64_C(0x962ACEEFA82E1C84), Q_UINT64_C(0x46E3ECAAF453CE9),
	Q_UINT64_C(0xE3B2CE59F1ADC513), Q_UINT64_C(0xD228E078F32F44DB),
	Q_UINT64_C(0x55B6344CF97AAFAE), Q_UINT64_C(0xB862225B055B6960),
	Q_UINT64_C(0xCAC09AFBDDD2CDB4), Q_UINT64_C(0xDAF8E9829FE96B5F),
	Q_UINT64_C(0xB5FDFC5D3132C498), Q_UINT64_C(0x310CB380DB6F7503),
	Q_UINT64_C(0xE87FBB46217A360E), Q_UINT64_C(0x2102AE466EBB1148),
	Q_UINT64_C(0xDC18936DE692EDA9), Q_UINT64_C(0x5C63C9773B896313),
	Q_UINT64_C(0xD5764DF8E597383A), Q_UINT64_C(0x2A86143DF52ED2B7),
	Q_UINT64_C(0x9588E6D639FD657), Q_UINT64_C(0x22BCCA7179F6F98C),
	Q_UINT64_C(0x7B11F66F913FD6A1), Q_UINT64_C(0x8A238ACA5D70BC01),
	Q_UINT64_C(0x376F91D2FE31AB34), Q_UINT64_C(0x8AE8C32B18A764E7),
	Q_UINT64_C(0x4E698D55B171A819), Q_UINT64_C(0x57097D875837A86),
	Q_UINT64_C(0x51FA164BA15A2024), Q_UINT64_C(0x11857C8AE5ECE282),
	Q_UINT64_C(0xE12614F85ED4463), Q_UINT64_C(0xB16C60A6F750F06D),
	Q_UINT64_C(0xE22B7F4F1D37F38E), Q_UINT64_C(0xABB2A5C6CCA6BF7B),
	Q_UINT64_C(0x63BA1402BCD700C7), Q_UINT64_C(0xE6F4F767E2FEEACF),
	Q_UINT64_C(0xE44B611E749E5BB4), Q_UINT64_C(0x3104180C25A2C83D),
	Q_UINT64_C(0x223DDA40658FCF6F), Q_UINT64_C(0x72B0869B6B5C016A),
	Q_UINT64_C(0xD12C5F2B65D57A6D), Q_UINT64_C(0xD3447B7471133EEF),
	Q_UINT64_C(0xE67997D839E29E00), Q_UINT64_C(0x77913DC5F0FCF4A8),
	Q_UINT64_C(0xD1C9396DF4441C1F), Q_UINT64_C(0x70DE309862A395BF),
	Q_UINT64_C(0x569214F17B577E49), Q_UINT64_C(0xF13A9F525964B43D),
	Q_UINT64_C(0x268CC049EA9C9193), Q_UINT64_C(0x202BC1CE11299299),
	Q_UINT64_C(0xDDEAAF93312DE40), Q_UINT64_C(0x3F18205EFEA8D4E1),
	Q_UINT64_C(0x746D101338AEFECC), Q_UINT64_C(0x7C716AE1EE2FA0C0),
	Q_UINT64_C(0x54D16714A2E21833), Q_UINT64_C(0x4624932E00B967BB),
	Q_UINT64_C(0x269E8F6F613A95B), Q_UINT64_C(0x6E547C58D5B8E0B6),
	Q_UINT64_C(0x3F6E35A083906CE2), Q_UINT64_C(0x461C787DA6D39287),
	Q_UINT64_C(0x456B13B48BA14D3E), Q_UINT64_C(0x13208F2F3BBBCBCD),
	Q_UINT64_C(0x9FD9D09B0BCB0CC6), Q_UINT64_C(0x2EA80842562611A3),
	Q_UINT64_C(0x7C6A516016BBA328), Q_UINT64_C(0x7E11E8FD8971863C),
	Q_UINT64_C(0xF1D5D10C4371CA97), Q_UINT64_C(0xFBEE22F1C4794DB3),
	Q_UINT64_C(0x440FA4EE9B95CE5), Q_UINT64_C(0x249540E9C01F5590),
	Q_UINT64_C(0x5CAFD766426FCA9F), Q_UINT64_C(0x455D292596C1C249),
	Q_UINT64_C(0x61792414CC27B556), Q_UINT64_C(0xD7DFBED555838D82),
	Q_UINT64_C(0xAD2CEFCC8821AAE2), Q_UINT64_C(0xF986B171F10C9CD8),
	Q_UINT64_C(0x95FEBC8B40E5C16B), Q_UINT64_C(0x4396D320F53B48E0),
	Q_UINT64_C(0xFFA4915F24EBF599), Q_UINT64_C(0xBF2ACDC7614AEE18),
	Q_UINT64_C(0x3685E0834D27C16C), Q_UINT64_C(0xB12AF8749B280CA4),
	Q_UINT64_C(0xBCC928EC0B31E86D), Q_UINT64_C(0xDCA4586B13D7BF2F),
	Q_UINT64_C(0x1CD832A71FEBEB79), Q_UINT64_C(0xA077AD985CCDA491),
	Q_UINT64_C(0x1E449EFC1EA851A9), Q_UINT64_C(0xBFFEF9D3EA83FF8A),
	Q_UINT64_C(0xA5876E9AB5B62C2F), Q_UINT64_C(0x6AE97C384B49BBF5),
	Q_UINT64_C(0xABD49C6450CF44BA), Q_UINT64_C(0x6CE61B36DFE3A2A9),
	Q_UINT64_C(0x6F383137A881C02F), Q_UINT64_C(0x6A0D690F234FEC2E),
	Q_UINT64_C(0x4173887850FEB813), Q_UINT64_C(0x69800934BE5F0FB4),
	Q_UINT64_C(0xD79A277FA5EE0B7D), Q_UINT64_C(0x722F20F6C983AF1F),
	Q_UINT64_C(0x1A396AD150FD8628), Q_UINT64_C(0xDDA7A8C620D3F45A),
	Q_UINT64_C(0xC4756429C0FAAAE9), Q_UINT64_C(0xD3D6BA273CF7A9CF),
	Q_UINT64_C(0xD6F48274C510403B), Q_UINT64_C(0x7F88AD29B44A60AE),
	Q_UINT64_C(0x77DED73FCFE5ACF3), Q_UINT64_C(0xED1EEC4D07F6C5F3),
	Q_UINT64_C(0x731CF9A2B3E69101), Q_UINT64_C(0x95115C6B16CBFC53),
	Q_UINT64_C(0xC6377B48F0FF5A04), Q_UINT64_C(0xA1623EA2072BA691),
	Q_UINT64_C(0x2D6385D5DEFBA3EC), Q_UINT64_C(0xB53229ED8AE98A05),
	Q_UINT64_C(0x3CA991513A832A60), Q_UINT64_C(0x81BD2FEB07DC1B2),
	Q_UINT64_C(0xDB66D8B4739EAE6D), Q_UINT64_C(0x5127152585FB0236),
	Q_UINT64_C(0x871A8BAF905FFE5F), Q_UINT64_C(0x4B2CEC12E28EF0A8),
	Q_UINT64_C(0xA15BC40D676B8059), Q_UINT64_C(0x4D019C4D521F9F0D),
	Q_UINT64_C(0x40185CAC031D6A), Q_UINT64_C(0xA102BAA74E6EA4CC),
	Q_UINT64_C(0x770AD606DB9A489E), Q_UINT64_C(0xC83865D9BCBADEAB),
	Q_UINT64_C(0xC0ED0F7C0221EF20), Q_UINT64_C(0x61B08FE50CE9B4DD),
	Q_UINT64_C(0x457F98F52B5B9A8B), Q_UINT64_C(0x9F37DA3E069B4F3F),
	Q_UINT64_C(0x16E2563EBDEB76CD), Q_UINT64_C(0x1FC53027ABBDE320),
	Q_UINT64_C(0x3EBE566AA57C3504), Q_UINT64_C(0x36F117F03C169259),
	Q_UINT64_C(0x94863345C47C009D), Q_UINT64_C(0x1664C1F26180474E),
	Q_UINT64_C(0x62A0B1E25812F7A8), Q_UINT64_C(0x1472D67CB21D6933),
	Q_UINT64_C(0xFE66E31B6EF68DA), Q_UINT64_C(0x2DC2CD84C8BABBE4),
	Q_UINT64_C(0xA8807FC12376DE5E), Q_UINT64_C(0xFC5374D1BD27B04A),
	Q_UINT64_C(0x74926FFA7431AC44), Q_UINT64_C(0x66CC273FDA40B2C3),
	Q_UINT64_C(0x89213887A68993BD), Q_UINT64_C(0xEE67914331AB2BE),
	Q_UINT64_C(0x53444E636E28864A), Q_UINT64_C(0x30E4D661ACB60423),
	Q_UINT64_C(0xE6A7849FE7DEB15F), Q_UINT64_C(0x8C54305DE4553F33),
	Q_UINT64_C(0xF003268AEBFDBEFE), Q_UINT64_C(0x31D97BA51F94D328),
	Q_UINT64_C(0x490A4FD8CC7ACCB1), Q_UINT64_C(0xE1FB595A41EF4665),
	Q_UINT64_C(0xE71A7B8A8B239989), Q_UINT64_C(0xCE013FB905AEE038),
	Q_UINT64_C(0x6DB3584E1C34FF53), Q_UINT64_C(0x3EA458773E1D6AB5),
	Q_UINT64_C(0x912516C640F34164), Q_UINT64_C(0x883BC1186DB1424B),
	Q_UINT64_C(0x2EC36EB66A4AEED8), Q_UINT64_C(0x797ACDDCFEB64EE4),
	Q_UINT64_C(0x7F76BB7EAA449E30), Q_UINT64_C(0xF8FF8A4CA2B27482),
	Q_UINT64_C(0x394892E1F2B1BB90), Q_UINT64_C(0x4BAF246B8D469EB8),
	Q_UINT64_C(0xF59AB89D33102DE6), Q_UINT64_C(0x24EBEF21DD8CD878),
	Q_UINT64_C(0x6D80A3EA724BFDC3), Q_UINT64_C(0x4ED3EFA64DAB1F9A),
	Q_UINT64_C(0x5187E679610F0CC6), Q_UINT64_C(0x98C9BD638D376C00),
	Q_UINT64_C(0x931BC3482E871415), Q_UINT64_C(0xC0A525FD102934D0),
	Q_UINT64_C(0x9DAF8EE2F4F9CA8), Q_UINT64_C(0xF37148CF3794439B),
	Q_UINT64_C(0xAC9938057E5661D), Q_UINT64_C(0x8C9EB0E2433437D4),
	Q_UINT64_C(0xCC72E82728195BFB), Q_UINT64_C(0x5EAA084386052B27),
	Q_UINT64_C(0x42E240CB63689F2F), Q_UINT64_C(0x6D2BDCDAE2919661),
	Q_UINT64_C(0x42880B0236E4D951), Q_UINT64_C(0x5F0F4A5898171BB6),
	Q_UINT64_C(0x39F890F579F92F88), Q_UINT64_C(0x93C5B5F47356388B),
	Q_UINT64_C(0x63DC359D8D231B78), Q_UINT64_C(0xEC16CA8AEA98AD76),
	Q_UINT64_C(0x47EE51E01786C0D), Q_UINT64_C(0x5D57FDC24613C035),
	Q_UINT64_C(0x3253A729B9BA3DDE), Q_UINT64_C(0x8C74C368081B3075),
	Q_UINT64_C(0xB9BC6C87167C33E7), Q_UINT64_C(0x7EF48F2B83024E20),
	Q_UINT64_C(0x11D505D4C351BD7F), Q_UINT64_C(0x6568FCA92C76A243),
	Q_UINT64_C(0x4DE0B0F40F32A7B8), Q_UINT64_C(0x96D693460CC37E5D),
	Q_UINT64_C(0xF9A2A8FC7456DEEB), Q_UINT64_C(0xDC1B40BB4D4DF1B0),
	Q_UINT64_C(0x18727070F1BD400B), Q_UINT64_C(0x1FCBACD259BF02E7),
	Q_UINT64_C(0xD310A7C2CE9B6555), Q_UINT64_C(0xBF983FE0FE5D8244),
	Q_UINT64_C(0x9F74D14F7454A824), Q_UINT64_C(0x51EBDC4AB9BA3035),
	Q_UINT64_C(0x5C82C505DB9AB0FA), Q_UINT64_C(0xFCF7FE8A3430B241),
	Q_UINT64_C(0x167EFF15A9E9AF74), Q_UINT64_C(0x5E66B27B148F119D),
	Q_UINT64_C(0x4C9F34427501B447), Q_UINT64_C(0x14A68FD73C910841),
	Q_UINT64_C(0xA71B9B83461CBD93), Q_UINT64_C(0x3488B95B0F1850F),
	Q_UINT64_C(0x637B2B34FF93C040), Q_UINT64_C(0x9D1BC9A3DD90A94),
	Q_UINT64_C(0x3575668334A1DD3B), Q_UINT64_C(0x735E2B97A4C45A23),
	Q_UINT64_C(0x194F508B7E617E1C), Q_UINT64_C(0x44D577CE26E12E5D),
	Q_UINT64_C(0xAA649C6EBCFD50FC), Q_UINT64_C(0x8DBD98A352AFD40B),
	Q_UINT64_C(0x87D2074B81D79217), Q_UINT64_C(0x19F3C751D3E92AE1),
	Q_UINT64_C(0xB4AB30F062B19ABF), Q_UINT64_C(0x7B0500AC42047AC4),
	Q_UINT64_C(0xC9452CA81A09D85D), Q_UINT64_C(0x24AA6C514DA27500),
	Q_UINT64_C(0xA28FAED3689F95BB), Q_UINT64_C(0xC83350115F9A613F),
	Q_UINT64_C(0x5D1A1AE85B49AA1), Q_UINT64_C(0x679F848F6E8FC971),
	Q_UINT64_C(0x7449BBFF801FED0B), Q_UINT64_C(0x7D11CDB1C3B7ADF0),
	Q_UINT64_C(0x82C7709E781EB7CC), Q_UINT64_C(0xF3218F1C9510786C),
	Q_UINT64_C(0x331478F3AF51BBE6), Q_UINT64_C(0x4BB38DE5E7219443),
	Q_UINT64_C(0xE1A1184053CD2CF3), Q_UINT64_C(0xED01A22A64258031),
	Q_UINT64_C(0xD7E765D58755C10), Q_UINT64_C(0x1A083822CEAFE02D),
	Q_UINT64_C(0x9605D5F0E25EC3B0), Q_UINT64_C(0xD021FF5CD13A2ED5),
	Q_UINT64_C(0x40BDF15D4A672E32), Q_UINT64_C(0x11355146FD56395),
	Q_UINT64_C(0x5DB4832046F3D9E5), Q_UINT64_C(0x239F8B2D7FF719CC),
	Q_UINT64_C(0xBEDB87820B300578), Q_UINT64_C(0xD48E0D91309D5495),
	Q_UINT64_C(0x9D39247E33776D41), Q_UINT64_C(0x2AF7398005AAA5C7),
	Q_UINT64_C(0x44DB015024623547), Q_UINT64_C(0x9C15F73E62A76AE2),
	Q_UINT64_C(0x75834465489C0C89), Q_UINT64_C(0x3290AC3A203001BF),
	Q_UINT64_C(0xFBBAD1F61042279), Q_UINT64_C(0xE83A908FF2FB60CA),
	Q_UINT64_C(0xD9AEA92E9B82F7D7), Q_UINT64_C(0x125DFFB1B0033D85),
	Q_UINT64_C(0xDF3C5A6BDE6ED558), Q_UINT64_C(0xD15B7567CC8C9994),
	Q_UINT64_C(0x33820EFB5D00EA05), Q_UINT64_C(0x7A7CB7F62DADEA6),
	Q_UINT64_C(0xD786A7818C7A441B), Q_UINT64_C(0x49083EAF1220799E),
	Q_UINT64_C(0xE806DB566CE19D0C), Q_UINT64_C(0xB1E64841769BA28B),
	Q_UINT64_C(0xF0EA3BE7461E1868), Q_UINT64_C(0xEDE2D8ABCF3BC02C),
	Q_UINT64_C(0xE4215E28EA15F7D8), Q_UINT64_C(0xE5CC6571AAB4EAA4),
	Q_UINT64_C(0xCF1C488E9C820D52), Q_UINT64_C(0xE901A40CE658D4ED),
	Q_UINT64_C(0x3088075A531C35CC), Q_UINT64_C(0x2E405CD11AAF14D5),
	Q_UINT64_C(0x8F44BD3F98D45E85), Q_UINT64_C(0x44590BA83F5B62C7),
	Q_UINT64_C(0x1BB0C75386F4E2FA), Q_UINT64_C(0x2061E167F40C03A6),
	Q_UINT64_C(0x7FDDFB73A3FC2855), Q_UINT64_C(0x47EE611ABBCB0D66),
	Q_UINT64_C(0x823DC7CF1D36FA8E), Q_UINT64_C(0x5F47FFACA586F256),
	Q_UINT64_C(0xEFC20227120A4242), Q_UINT64_C(0x62DD10895A0616AA),
	Q_UINT64_C(0xE0C5E3A99DEF2D5F), Q_UINT64_C(0xA3A1CE99B7C09FED),
	Q_UINT64_C(0xC59E3E840A464485), Q_UINT64_C(0x49BE6C9ACE6FE276),
	Q_UINT64_C(0xCD3029D2069CB5C0), Q_UINT64_C(0xB901970A56321509),
	Q_UINT64_C(0x870CBE02E1262067), Q_UINT64_C(0x1293EA5D0A1FAB4F),
	Q_UINT64_C(0xD75CBD2A79109164), Q_UINT64_C(0x6761A49C0AB093FB),
	Q_UINT64_C(0xC5A31678A39AD9A2), Q_UINT64_C(0x5EBCE9C5A6308D03),
	Q_UINT64_C(0x7E9B255587E5C249), Q_UINT64_C(0xFE04C9D3D87162BD),
	Q_UINT64_C(0xA4FC4BD4FC5558CA), Q_UINT64_C(0xE755178D58FC4E76),
	Q_UINT64_C(0x69B97DB1A4C03DFE), Q_UINT64_C(0xF9B5B7C4ACC67C96),
	Q_UINT64_C(0xFC6A82D64B8655FB), Q_UINT64_C(0x9C684CB6C4D24417),
	Q_UINT64_C(0x8EC97D2917456ED0), Q_UINT64_C(0x6703DF9D2924E97E),
	Q_UINT64_C(0x1A98A523CB8B869), Q_UINT64_C(0xB384E1E1F56B8966),
	Q_UINT64_C(0xD7288E012AEB8D31), Q_UINT64_C(0xDE336A2A4BC1C44B),
	Q_UINT64_C(0xBF692B38D079F23), Q_UINT64_C(0x2C604A7A177326B3),
	Q_UINT64_C(0x4850E73E03EB6064), Q_UINT64_C(0xCFC447F1E53C8E1B),
	Q_UINT64_C(0xB05CA3F564268D99), Q_UINT64_C(0x9AE182C8BC9474E8),
	Q_UINT64_C(0x62174C4EC793FAA), Q_UINT64_C(0x19E964407E09C6AD),
	Q_UINT64_C(0x51039AB7712457C3), Q_UINT64_C(0xC07A3F80C31FB4B4),
	Q_UINT64_C(0xB46EE9C5E64A6E7C), Q_UINT64_C(0xB3819A42ABE61C87),
	Q_UINT64_C(0x21A007933A522A20), Q_UINT64_C(0x2DF16F761598AA4F),
	Q_UINT64_C(0x763C4A1371B368FD), Q_UINT64_C(0xF793C46702E086A0),
	Q_UINT64_C(0x97B330C4F8EB88DC), Q_UINT64_C(0xDA084354F03CFD28),
	Q_UINT64_C(0x19AFE59AE451497F), Q_UINT64_C(0x52593803DFF1E840),
	Q_UINT64_C(0xF4F076E65F2CE6F0), Q_UINT64_C(0x11379625747D5AF3),
	Q_UINT64_C(0xBCE5D2248682C115), Q_UINT64_C(0x9DA4243DE836994F),
	Q_UINT64_C(0x66F70B33FE09017), Q_UINT64_C(0x4DC4DE189B671A1C),
	Q_UINT64_C(0xFF4D19A4372964D2), Q_UINT64_C(0x79A594F48D9FC14B),
	Q_UINT64_C(0xC5CC1D89724FA456), Q_UINT64_C(0x5648F680F11A2741),
	Q_UINT64_C(0x2D255069F0B7DAB3), Q_UINT64_C(0x9BC5A38EF729ABD4),
	Q_UINT64_C(0xEF2F054308F6A2BC), Q_UINT64_C(0xAF2042F5CC5C2858),
	Q_UINT64_C(0x480412BAB7F5BE2A), Q_UINT64_C(0xAEF3AF4A563DFE43),
	Q_UINT64_C(0xEF38249EAB24559B), Q_UINT64_C(0xC02CE5D9EDB6DCCB),
	Q_UINT64_C(0xA87832D392EFEE56), Q_UINT64_C(0x65942C7B3C7E11AE),
	Q_UINT64_C(0xDED2D633CAD004F6), Q_UINT64_C(0x21F08570F420E565),
	Q_UINT64_C(0xB415938D7DA94E3C), Q_UINT64_C(0x91B859E59ECB6350),
	Q_UINT64_C(0x10CFF333E0ED804A), Q_UINT64_C(0x28AED140BE0BB7DD),
	Q_UINT64_C(0x6B7A4C702BFE9530), Q_UINT64_C(0x4AF027D39D96C6F6),
	Q_UINT64_C(0x7EED120D54CF2DD9), Q_UINT64_C(0x22FE545401165F1C),
	Q_UINT64_C(0xC91800E98FB99929), Q_UINT64_C(0x808BD68E6AC10365),
	Q_UINT64_C(0xDEC468145B7605F6), Q_UINT64_C(0x1BEDE3A3AEF53302),
	Q_UINT64_C(0x43539603D6C55602), Q_UINT64_C(0xAA969B5C691CCB7A),
	Q_UINT64_C(0x53B53CFF084DBBE4), Q_UINT64_C(0x82C93DA09A63AB88),
	Q_UINT64_C(0x56436C9FE1A1AA8D), Q_UINT64_C(0xEFAC4B70633B8F81),
	Q_UINT64_C(0xBB215798D45DF7AF), Q_UINT64_C(0x45F20042F24F1768),
	Q_UINT64_C(0x930F80F4E8EB7462), Q_UINT64_C(0xFF6712FFCFD75EA1),
	Q_UINT64_C(0xAE623FD67468AA70), Q_UINT64_C(0xDD2C5BC84BC8D8FC),
	Q_UINT64_C(0x646EBA6B1B2D82AA), Q_UINT64_C(0x45203C04D96D1BDD),
	Q_UINT64_C(0x5BBCEDD5AAC241FB), Q_UINT64_C(0x5B850BEAADBA9EB7),
	Q_UINT64_C(0xC1356E175D3212B7), Q_UINT64_C(0xFF9C94156B411A98),
	Q_UINT64_C(0x4A4B589F7BC066B3), Q_UINT64_C(0xDAD93ADD928E32F1),
	Q_UINT64_C(0xEE4FAABB1D0F60D9), Q_UINT64_C(0x56E890FF282F1FCE),
	Q_UINT64_C(0xC426885553EF5F1B), Q_UINT64_C(0x2886FED586BAC9),
	Q_UINT64_C(0x8D198B212B022695), Q_UINT64_C(0x229E0F877BC12463),
	Q_UINT64_C(0x9E1315CDAB71CC75), Q_UINT64_C(0x4D738571F14B9BE1),
	Q_UINT64_C(0x2E0D09DF94495B8), Q_UINT64_C(0xAF7DE544C1E3FD12),
	Q_UINT64_C(0xCF9B6F23E1F126FD), Q_UINT64_C(0xF79887BE147870BB),
	Q_UINT64_C(0x4E52E5020AF9E6E5), Q_UINT64_C(0x9562304EAAF4C163),
	Q_UINT64_C(0xA0F58406D9A0A5E3), Q_UINT64_C(0x4E5E360C619F3A8A),
	Q_UINT64_C(0xA79B26CD1DB6D85B), Q_UINT64_C(0x8B0DD22C68DB4EF0),
	Q_UINT64_C(0x2DBAF19CF7BA1BC7), Q_UINT64_C(0x273947E45D23A245),
	Q_UINT64_C(0xBD7A5F0B09EE48E9), Q_UINT64_C(0x93E6F3940A085045),
	Q_UINT64_C(0xF841AE335FE2081F), Q_UINT64_C(0x21ADE9C05AA9D300),
	Q_UINT64_C(0x972AE72F0D39527A), Q_UINT64_C(0xEACBF6D9F834D914),
	Q_UINT64_C(0xF68F42E66EC592A4), Q_UINT64_C(0x3C05F9A14AEE9F0C),
	Q_UINT64_C(0x243A624AC1535ECC), Q_UINT64_C(0xBE28A542D88CAF6D),
	Q_UINT64_C(0x80FDF15D1EF183AD), Q_UINT64_C(0xDFA6F540973D637A),
	Q_UINT64_C(0x9A535D0DDFA4AE2B), Q_UINT64_C(0xBBB9BEF7209E47AC),
	Q_UINT64_C(0xDC842B7E2819E230), Q_UINT64_C(0xBA89142E007503B8),
	Q_UINT64_C(0xA3BC941D0A5061CB), Q_UINT64_C(0xE9F6760E32CD8021),
	Q_UINT64_C(0x9C7E552BC76492F), Q_UINT64_C(0x852F54934DA55CC9),
	Q_UINT64_C(0x8107FCCF064FCF56), Q_UINT64_C(0x98954D51FFF6580),
	Q_UINT64_C(0xA66E66E972A18FA1), Q_UINT64_C(0xE52BA6C9A2794F9),
	Q_UINT64_C(0xE9F6082B05542E4E), Q_UINT64_C(0xEBFAFA33D7254B59),
	Q_UINT64_C(0x9255ABB50D532280), Q_UINT64_C(0xB9AB4CE57F2D34F3),
	Q_UINT64_C(0x693501D628297551), Q_UINT64_C(0xC62C58F97DD949BF),
	Q_UINT64_C(0xCD454F8F19C5126A), Q_UINT64_C(0xBBE83F4ECC2BDECB),
	Q_UINT64_C(0xCCD44DAD39A17F3D), Q_UINT64_C(0x3482B6C0DB88A8D9),
	Q_UINT64_C(0x947AE053EE56E63C), Q_UINT64_C(0xC8C93882F9475F5F),
	Q_UINT64_C(0x3A9BF55BA91F81CA), Q_UINT64_C(0xD9A11FBB3D9808E4),
	Q_UINT64_C(0xFD22063EDC29FCA), Q_UINT64_C(0xB3F256D8ACA0B0B9),
	Q_UINT64_C(0xB03031A8B4516E84), Q_UINT64_C(0x35DD37D5871448AF),
	Q_UINT64_C(0xFD3024EEE99BE715), Q_UINT64_C(0x3B58F552A438759E),
	Q_UINT64_C(0x6F423357E7C6A9F9), Q_UINT64_C(0x325928EE6E6F8794),
	Q_UINT64_C(0xD0E4366228B03343), Q_UINT64_C(0x565C31F7DE89EA27),
	Q_UINT64_C(0x30F5611484119414), Q_UINT64_C(0xD873DB391292ED4F),
	Q_UINT64_C(0x7BD94E1D8E17DEBC), Q_UINT64_C(0xC7D9F16864A76E94),
	Q_UINT64_C(0x3B3ED3FB66C884A9), Q_UINT64_C(0x83DF7693DB92E039),
	Q_UINT64_C(0x65D34954DAF3CEBD), Q_UINT64_C(0xB4B81B3FA97511E2),
	Q_UINT64_C(0xB422061193D6F6A7), Q_UINT64_C(0x71582401C38434D),
	Q_UINT64_C(0x7A13F18BBEDC4FF5), Q_UINT64_C(0xBC4097B116C524D2),
	Q_UINT64_C(0x59B97885E2F2EA28), Q_UINT64_C(0x99170A5DC3115544),
	Q_UINT64_C(0x8F83912E50A95CBB), Q_UINT64_C(0xDFABE7ED507D031E),
	Q_UINT64_C(0xD60F6DCEDC314222), Q_UINT64_C(0x56963B0DCA418FC0),
	Q_UINT64_C(0x16F50EDF91E513AF), Q_UINT64_C(0xEF1955914B609F93),
	Q_UINT64_C(0x565601C0364E3228), Q_UINT64_C(0xECB53939887E8175),
	Q_UINT64_C(0xBAC7A9A18531294B), Q_UINT64_C(0xB344C470397BBA52),
	Q_UINT64_C(0xC80301965A4F5B96), Q_UINT64_C(0xB7E4E0745B44863F),
	Q_UINT64_C(0x37624AE5A48FA6E9), Q_UINT64_C(0x957BAF61700CFF4E),
	Q_UINT64_C(0x3A6C27934E31188A), Q_UINT64_C(0xD49503536ABCA345),
	Q_UINT64_C(0x88E049589C432E0), Q_UINT64_C(0xF943AEE7FEBF21B8),
	Q_UINT64_C(0x6C3B8E3E336139D3), Q_UINT64_C(0x364F6FFA464EE52E),
	Q_UINT64_C(0xEC2C2E8AB929929C), Q_UINT64_C(0x371A871F5B734AD1),
	Q_UINT64_C(0x7F9B6AF1EBF78BAF), Q_UINT64_C(0x58627E1A149BBA21),
	Q_UINT64_C(0x2CD16E2ABD791E33), Q_UINT64_C(0xD363EFF5F0977996),
	Q_UINT64_C(0xCE2A38C344A6EED), Q_UINT64_C(0x1A804AADB9CFA741),
	Q_UINT64_C(0x907F30421D78C5DE), Q_UINT64_C(0x501F65EDB3034D07),
	Q_UINT64_C(0x3B19671C68219AB0), Q_UINT64_C(0xB7B12313AE8FFDD),
	Q_UINT64_C(0x953F1EA2EEE7A6E5), Q_UINT64_C(0x514D79A727FE363D),
	Q_UINT64_C(0x5BDC41EDF6C001D5), Q_UINT64_C(0xDFD3204932FA11CB),
	Q_UINT64_C(0x9FE26CE9B88F2CC7), Q_UINT64_C(0x6B1D4662F0703356),
	Q_UINT64_C(0x18182A5BF908CAA5), Q_UINT64_C(0x528E946A1801E7DC),
	Q_UINT64_C(0xAC5E9610F1CD3A85), Q_UINT64_C(0x5265AE65582FB7),
	Q_UINT64_C(0x11C95AFD3033F6D7), Q_UINT64_C(0x151BA697FE01D4C2),
	Q_UINT64_C(0x6E9D87664063E0CA), Q_UINT64_C(0xC7A3572D50BE9190),
	Q_UINT64_C(0xEEF7985DC648EDB9), Q_UINT64_C(0xC89290F017E45B49),
	Q_UINT64_C(0x1FA85542E122FA15), Q_UINT64_C(0xE96E20BA4514B68A),
	Q_UINT64_C(0x609AC19AEA0C1CC7), Q_UINT64_C(0xB56447289FC5ACA),
	Q_UINT64_C(0xF8876B0931DA4597), Q_UINT64_C(0x74D974D8ED62AE91),
	Q_UINT64_C(0x587EF6A023D5EA2), Q_UINT64_C(0xAE090C3989194D0F),
	Q_UINT64_C(0x9C55702F2D16DF7), Q_UINT64_C(0x48E7F5B49BBAFF50),
	Q_UINT64_C(0x4076CBF03C303517), Q_UINT64_C(0x3EA1E1DBA973FA83),
	Q_UINT64_C(0xCE33B6796296D4B7), Q_UINT64_C(0x23A922886214DB6E),
	Q_UINT64_C(0x27BBAB250CDA4B15), Q_UINT64_C(0xDA89B2AF2534EA8F),
	Q_UINT64_C(0xF1EC650DFFC8FB07), Q_UINT64_C(0x57A6299ECC94971A),
	Q_UINT64_C(0xB1FBD4103CECE237), Q_UINT64_C(0x8E261A24D022CB39),
	Q_UINT64_C(0x42A51020B054A5B1), Q_UINT64_C(0x5DFB99344D1F3596),
	Q_UINT64_C(0xD007862D1FF5471A), Q_UINT64_C(0x3ACE9D2D8E6A8E31),
	Q_UINT64_C(0x26E6DB8FFDF5ADFE), Q_UINT64_C(0x469356C504EC9F9D),
	Q_UINT64_C(0xC8763C5B08D1908C), Q_UINT64_C(0x3F6C6AF859D80055),
	Q_UINT64_C(0x7F7CC39420A3A545), Q_UINT64_C(0x9BFB227EBDF4C5CE),
	Q_UINT64_C(0x89039D79D6FC5C5C), Q_UINT64_C(0x8FE88B57305E2AB6),
	Q_UINT64_C(0x1F7B9E79C0388645), Q_UINT64_C(0x2EE75B18F5F9B8B9),
	Q_UINT64_C(0x604D51B25FBF70E2), Q_UINT64_C(0x73AA8A564FB7AC9E),
	Q_UINT64_C(0x1A8C1E992B941148), Q_UINT64_C(0xAAC40A2703D9BEA0),
	Q_UINT64_C(0x764DBEAE7FA4F3A6), Q_UINT64_C(0x1E99B96E70A9BE8B),
	Q_UINT64_C(0x2C5E9DEB57EF4743), Q_UINT64_C(0x3A938FEE32D29981),
	Q_UINT64_C(0x5B452D1049ABEDD1), Q_UINT64_C(0x62F4F6158E96ABD0),
	Q_UINT64_C(0x9FC10D0F989993E0), Q_UINT64_C(0xDE68A2355B93CAE6),
	Q_UINT64_C(0xA44CFE79AE538BBE), Q_UINT64_C(0x9D1D84FCCE371425),
	Q_UINT64_C(0x51D2B1AB2DDFB636), Q_UINT64_C(0x2FD7E4B9E72CD38C),
	Q_UINT64_C(0x65CA5B96B7552210), Q_UINT64_C(0xDD69A0D8AB3B546D),
	Q_UINT64_C(0x1AA62DFD2DF51558), Q_UINT64_C(0x11C0D78503B7FA0E),
	Q_UINT64_C(0x13328503DF48229F), Q_UINT64_C(0xD6BF7BAEE43CAC40),
	Q_UINT64_C(0x4838D65F6EF6748F), Q_UINT64_C(0x1E152328F3318DEA),
	Q_UINT64_C(0x8F8419A348F296BF), Q_UINT64_C(0x72C8834A5957B511),
	Q_UINT64_C(0xD7A023A73260B45C), Q_UINT64_C(0x94EBC8ABCFB56DAE),
	Q_UINT64_C(0xEA2F10DB4A041E40), Q_UINT64_C(0xADA54288597DF0C6),
	Q_UINT64_C(0xA319CE15B0B4DB31), Q_UINT64_C(0x73973751F12DD5E),
	Q_UINT64_C(0x8A8E849EB32781A5), Q_UINT64_C(0xE1925C71285279F5),
	Q_UINT64_C(0x74C04BF1790C0EFE), Q_UINT64_C(0x4DDA48153C94938A),
	Q_UINT64_C(0x9D266D6A1CC0542C), Q_UINT64_C(0x7440FB816508C4FE),
	Q_UINT64_C(0x2973F90EB09051C3), Q_UINT64_C(0x2753D1DDD85B3F86),
	Q_UINT64_C(0x1B0CAB936E65C744), Q_UINT64_C(0xB559EB1D04E5E932),
	Q_UINT64_C(0xC37B45B3F8D6F2BA), Q_UINT64_C(0xC3A9DC228CAAC9E9),
	Q_UINT64_C(0xF3B8B6675A6507FF), Q_UINT64_C(0x9FC477DE4ED681DA),
	Q_UINT64_C(0x67378D8ECCEF96CB), Q_UINT64_C(0x6DD856D94D259236),
	Q_UINT64_C(0x745AB7E19564403D), Q_UINT64_C(0xBE330A7458E85219),
	Q_UINT64_C(0xDBC27AB5447822BF), Q_UINT64_C(0x9B3CDB65F82CA382),
	Q_UINT64_C(0xB67B7896167B4C84), Q_UINT64_C(0xBFCED1B0048EAC50),
	Q_UINT64_C(0xA9119B60369FFEBD), Q_UINT64_C(0x1FFF7AC80904BF45),
	Q_UINT64_C(0xAC12FB171817EEE7), Q_UINT64_C(0xAF08DA9177DDA93D),
	Q_UINT64_C(0x44962ED382E30FF4), Q_UINT64_C(0x576B834EEACAE651),
	Q_UINT64_C(0xDA3A361B1C5157B1), Q_UINT64_C(0xDCDD7D20903D0C25),
	Q_UINT64_C(0x36833336D068F707), Q_UINT64_C(0xCE68341F79893389),
	Q_UINT64_C(0xAB9090168DD05F34), Q_UINT64_C(0x43954B3252DC25E5),
	Q_UINT64_C(0xB438C2B67F98E5E9), Q_UINT64_C(0x10DCD78E3851A492),
	Q_UINT64_C(0x642A50BE22044CE6), Q_UINT64_C(0x2943BAF20B6DC0B8),
	Q_UINT64_C(0x3E3011E5B9AEB2DA), Q_UINT64_C(0x8CD127A98AABDE96),
	Q_UINT64_C(0xD7CA42C26A86AC37), Q_UINT64_C(0x99F4C3CF53ABCC2C),
	Q_UINT64_C(0x209EE04F0C7A8B08), Q_UINT64_C(0x76802E63D56F0A1A),
	Q_UINT64_C(0xF42103FD3F0CE7BC), Q_UINT64_C(0x7FE8EE0B74AAE5C0),
	Q_UINT64_C(0x6688932D4BA155F0), Q_UINT64_C(0x1EEFB6D229349FAE),
	Q_UINT64_C(0xF853D9DCD68DB21), Q_UINT64_C(0x94A7C02B5030A3C3),
	Q_UINT64_C(0xC5A73C4C943E60F1), Q_UINT64_C(0x363A8CCC4D94ED82),
	Q_UINT64_C(0x9D082375155DB103), Q_UINT64_C(0xE24B6D9BC8A2FD1A),
	Q_UINT64_C(0x43A6AB2AF8AE7BF9), Q_UINT64_C(0xA16B629D61616B78),
	Q_UINT64_C(0xF1C391B29C25861A), Q_UINT64_C(0x50DE046243C2AC45),
	Q_UINT64_C(0xA5F0468CF4489F83), Q_UINT64_C(0xD32C58C25B3D8E88),
	Q_UINT64_C(0xCD645A4EDB1A4965), Q_UINT64_C(0xEF945D47EA18443),
	Q_UINT64_C(0xA21311AD6759F9E8), Q_UINT64_C(0xE746A2D821C7F4A),
	Q_UINT64_C(0xB97720282F2C04C9), Q_UINT64_C(0xE798EFEFFEDACE99),
	Q_UINT64_C(0x3F8521779810EC4), Q_UINT64_C(0x8615F9721E3C59CE),
	Q_UINT64_C(0x150405A36992E15), Q_UINT64_C(0xC997170FAD126717),
	Q_UINT64_C(0xF7E48A65055C50FD), Q_UINT64_C(0xA623C7A0DA92906B),
	Q_UINT64_C(0x1F011D6D603132DC), Q_UINT64_C(0x880F80ED3BD2DADD),
	Q_UINT64_C(0xCF45B6A3E1F6FDB8), Q_UINT64_C(0x73385DDCA56282AB),
	Q_UINT64_C(0xF92AFC0E84C82E46), Q_UINT64_C(0x60592BFCE46D40B1),
	Q_UINT64_C(0xA4EC0132764CA04B), Q_UINT64_C(0x733EA705FAE4FA77),
	Q_UINT64_C(0xB4D8F77BC3E56167), Q_UINT64_C(0x9E21F4F903B33FD9),
	Q_UINT64_C(0x9D765E419FB69F6D), Q_UINT64_C(0xD30C088BA61EA5EF),
	Q_UINT64_C(0x5D94337FBFAF7F5B), Q_UINT64_C(0x1A4E4822EB4D7A59),
	Q_UINT64_C(0xEA37B2C3F3B49439), Q_UINT64_C(0xEEF8BC6E13D467E7),
	Q_UINT64_C(0x959F587D507A8359), Q_UINT64_C(0xB063E962E045F54D),
	Q_UINT64_C(0x60E8ED72C0DFF5D1), Q_UINT64_C(0x7B64978555326F9F),
	Q_UINT64_C(0xFD080D236DA814BA), Q_UINT64_C(0x8C90FD9B083F4558),
	Q_UINT64_C(0x106F72FE81E2C590), Q_UINT64_C(0x7976033A39F7D952),
	Q_UINT64_C(0x77E20A7B35B8AE6F), Q_UINT64_C(0x5CC3EC118AF097F),
	Q_UINT64_C(0xEF02CDD06FFDB432), Q_UINT64_C(0xA1082C0466DF6C0A),
	Q_UINT64_C(0x8215E577001332C8), Q_UINT64_C(0xD39BB9C3A48DB6CF),
	Q_UINT64_C(0x2738259634305C14), Q_UINT64_C(0x61CF4F94C97DF93D),
	Q_UINT64_C(0x1B6BACA2AE4E125B), Q_UINT64_C(0x758F450C88572E0B),
	Q_UINT64_C(0xAE0AFB44CAF2183F), Q_UINT64_C(0xD8E2D1645D2AFEE9),
	Q_UINT64_C(0xBF84470805E69B5F), Q_UINT64_C(0x94C3251F06F90CF3),
	Q_UINT64_C(0x3E003E616A6591E9), Q_UINT64_C(0xB925A6CD0421AFF3),
	Q_UINT64_C(0x61BDD1307C66E300), Q_UINT64_C(0xBF8D5108E27E0D48),
	Q_UINT64_C(0x240AB57A8B888B20), Q_UINT64_C(0xFC87614BAF287E07),
	Q_UINT64_C(0xE28ECD0A504A68AA), Q_UINT64_C(0xA91136155B95F567),
	Q_UINT64_C(0xA2EBEE47E2FBFCE1), Q_UINT64_C(0xD9F1F30CCD97FB09),
	Q_UINT64_C(0xEFED53D75FD64E6B), Q_UINT64_C(0x2E6D02C36017F67F),
	Q_UINT64_C(0xA9AA4D20DB084E9B), Q_UINT64_C(0xB64BE8D8B25396C1),
	Q_UINT64_C(0x70CB6AF7C2D5BCF0), Q_UINT64_C(0x98F076A4F7A2322E),
	Q_UINT64_C(0x9F62086FA605AD89), Q_UINT64_C(0xA72F1F601511F6BE),
	Q_UINT64_C(0x106C09B972D2E822), Q_UINT64_C(0x7FBA195410E5CA30),
	Q_UINT64_C(0x7884D9BC6CB569D8), Q_UINT64_C(0x647DFEDCD894A29),
	Q_UINT64_C(0x63573FF03E224774), Q_UINT64_C(0x4FC8E9560F91B123),
	Q_UINT64_C(0x1DB956E450275779), Q_UINT64_C(0xB8D91274B9E9D4FB),
	Q_UINT64_C(0xE7FBFFF6E7FDED91), Q_UINT64_C(0xFC017631C316778D),
	Q_UINT64_C(0x21E0BD5026C619BF), Q_UINT64_C(0x3B097ADAF088F94E),
	Q_UINT64_C(0x8D14DEDB30BE846E), Q_UINT64_C(0xF95CFFA23AF5F6F4),
	Q_UINT64_C(0x3871700761B3F743), Q_UINT64_C(0xCA672B91E9E4FA16),
	Q_UINT64_C(0x64C8E531BFF53B55), Q_UINT64_C(0x241260ED4AD1E87D),
	Q_UINT64_C(0x6B478F44714E779D), Q_UINT64_C(0xE39E6D7FAB950FB),
	Q_UINT64_C(0x1F837CC7350524), Q_UINT64_C(0x1877B51E57A764D5),
	Q_UINT64_C(0xA2853B80F17F58EE), Q_UINT64_C(0x993E1DE72D36D310),
	Q_UINT64_C(0xB3598080CE64A656), Q_UINT64_C(0x252F59CF0D9F04BB),
	Q_UINT64_C(0xD23C8E176D113600), Q_UINT64_C(0x1BDA0492E7E4586E),
	Q_UINT64_C(0x72A80E8D2B39E2A), Q_UINT64_C(0x7D4124345708ACB3),
	Q_UINT64_C(0xBFFF6114701B0D2F), Q_UINT64_C(0xEA5A184B9517E8CA),
	Q_UINT64_C(0x3CAA2A37AA023E7C), Q_UINT64_C(0xEC1E3FE968443DE8),
	Q_UINT64_C(0xA979B742CB112673), Q_UINT64_C(0xBF2D52D67C4C7034),
	Q_UINT64_C(0xA7C9A5A34B45BD5D), Q_UINT64_C(0x1ACC3F6A9FB35135),
	Q_UINT64_C(0x4B1E73095E666C01), Q_UINT64_C(0x85EF5974316D7FC2),
	Q_UINT64_C(0x8E64CAA0B0AEB08F), Q_UINT64_C(0x3F2F578E1DB59D20),
	Q_UINT64_C(0xE434CC0A9CD687BD), Q_UINT64_C(0x90B5104E92F152AA),
	Q_UINT64_C(0x352CD63217EF76B2), Q_UINT64_C(0xB8D716F0590F2695),
	Q_UINT64_C(0x23E92E8E391F929), Q_UINT64_C(0x67A463C0C1AF1BC7),
	Q_UINT64_C(0xE9ED918B80FAD591), Q_UINT64_C(0x2290F0ACE780FC05),
	Q_UINT64_C(0x43FDB69FBB713F6E), Q_UINT64_C(0x77CB7A49BE28E7FE),
	Q_UINT64_C(0x66573645F2152EB8), Q_UINT64_C(0x110AA013AB13D159),
	Q_UINT64_C(0x605FB6CA7B9FEDF4), Q_UINT64_C(0xC2CDE6E0B545FBE2),
	Q_UINT64_C(0xB4417D9E245D497A), Q_UINT64_C(0x7F57BD56E22165FF),
	Q_UINT64_C(0x9D47CF4DF245A5E9), Q_UINT64_C(0xE7AD2A60786964D2),
	Q_UINT64_C(0x62DC3A4E8E2D62E8), Q_UINT64_C(0xBC4EDC33C17B18DE),
	Q_UINT64_C(0x812D70FDEE39853E), Q_UINT64_C(0x1D895E2E66E2E891),
	Q_UINT64_C(0x7DEB25E797FD60AE), Q_UINT64_C(0x11106176813E50A6),
	Q_UINT64_C(0xE0F88101D39C69F7), Q_UINT64_C(0xA4E8CD515861060),
	Q_UINT64_C(0x174130651687D064), Q_UINT64_C(0xC8B248361A505A7),
	Q_UINT64_C(0xCF05DAF5AC8D77B0), Q_UINT64_C(0x49CAD48CEBF4A71E),
	Q_UINT64_C(0x7A4C10EC2158C4A6), Q_UINT64_C(0xD9E92AA246BF719E),
	Q_UINT64_C(0x13AE978D09FE5557), Q_UINT64_C(0x730499AF921549FF),
	Q_UINT64_C(0x4E4B705B92903BA4), Q_UINT64_C(0xFF577222C14F0A3A),
	Q_UINT64_C(0xD68495B907505CFE), Q_UINT64_C(0xA33DF61270B23FD1),
	Q_UINT64_C(0x963EF2C96B33BE31), Q_UINT64_C(0x74F85198B05A2E7D),
	Q_UINT64_C(0x5A0F544DD2B1FB18), Q_UINT64_C(0x3727073C2E134B1),
	Q_UINT64_C(0xC7F6AA2DE59AEA61), Q_UINT64_C(0x352787BAA0D7C22F),
	Q_UINT64_C(0x9853EAB63B5E0B35), Q_UINT64_C(0xABBDCDD7ED5C0860),
	Q_UINT64_C(0x58FC9FAA0DDB331F), Q_UINT64_C(0x5ED0E1C3BAC871B7),
	Q_UINT64_C(0xF6F7FD1431714200), Q_UINT64_C(0x30C05B1BA332F41C),
	Q_UINT64_C(0x8D2636B81555A786), Q_UINT64_C(0x46C9FEB55D120902),
	Q_UINT64_C(0xCCEC0A73B49C9921), Q_UINT64_C(0x4E9D2827355FC492),
	Q_UINT64_C(0x19EBB029435DCB0F), Q_UINT64_C(0x4659D2B743848A2C),
	Q_UINT64_C(0x87D8E041774FAC30), Q_UINT64_C(0x91E6ADF31AB02ADA),
	Q_UINT64_C(0x4AE7D6A36EB5DBCB), Q_UINT64_C(0x2D8D5432157064C8),
	Q_UINT64_C(0xD1E649DE1E7F268B), Q_UINT64_C(0x8A328A1CEDFE552C),
	Q_UINT64_C(0x7A3AEC79624C7DA), Q_UINT64_C(0x84547DDC3E203C94),
	Q_UINT64_C(0x990A98FD5071D263), Q_UINT64_C(0x1A4FF12616EEFC89),
	Q_UINT64_C(0xC7B699A5477014EA), Q_UINT64_C(0xF3CA1D92C54F84BF),
	Q_UINT64_C(0xFB152FE3FF26DA89), Q_UINT64_C(0x3E666E6F69AE2C15),
	Q_UINT64_C(0x3B544EBE544C19F9), Q_UINT64_C(0xE805A1E290CF2456),
	Q_UINT64_C(0x24B33C9D7ED25117), Q_UINT64_C(0xE74733427B72F0C1),
	Q_UINT64_C(0xA804D18B7097475), Q_UINT64_C(0x57E3306D881EDB4F),
	Q_UINT64_C(0x1060F6B4EC7B82B3), Q_UINT64_C(0x1F5A1EC6D06F5AD4),
	Q_UINT64_C(0x81536D601170FC20), Q_UINT64_C(0x91B534F885818A06),
	Q_UINT64_C(0xEC8177F83F900978), Q_UINT64_C(0x190E714FADA5156E),
	Q_UINT64_C(0xB592BF39B0364963), Q_UINT64_C(0x89C350C893AE7DC1),
	Q_UINT64_C(0xAC042E70F8B383F2), Q_UINT64_C(0xB49B52E587A1EE60),
	Q_UINT64_C(0xFD4F8282C3D9791F), Q_UINT64_C(0xDB26AF80925F6A9),
	Q_UINT64_C(0x5E90277E7CB39E2D), Q_UINT64_C(0x2C046F22062DC67D),
	Q_UINT64_C(0xB10BB459132D0A26), Q_UINT64_C(0x3FA9DDFB67E2F199),
	Q_UINT64_C(0xE09B88E1914F7AF), Q_UINT64_C(0x10E8B35AF3EEAB37),
	Q_UINT64_C(0x9EEDECA8E272B933), Q_UINT64_C(0xD4C718BC4AE8AE5F),
	Q_UINT64_C(0x1B94254B080DA283), Q_UINT64_C(0xC715AF96CE798D4B),
	Q_UINT64_C(0x230E343DFBA08D33), Q_UINT64_C(0x43ED7F5A0FAE657D),
	Q_UINT64_C(0x3A88A0FBBCB05C63), Q_UINT64_C(0x21874B8B4D2DBC4F),
	Q_UINT64_C(0x1BDEA12E35F6A8C9), Q_UINT64_C(0x53C065C6C8E63528),
	Q_UINT64_C(0xE34A1D250E7A8D6B), Q_UINT64_C(0xD6B04D3B7651DD7E),
	Q_UINT64_C(0x7A82860807EF61E9), Q_UINT64_C(0x469ED6ECF34076E4),
	Q_UINT64_C(0xAD1B35B1D597B23B), Q_UINT64_C(0x581B678AC22F5025),
	Q_UINT64_C(0x5F0477CA4069407D), Q_UINT64_C(0xC41B1E57FA9203C7),
	Q_UINT64_C(0xB7063D3DB02D4CCA), Q_UINT64_C(0x15F95E490ECAEAA4),
	Q_UINT64_C(0x828386C926107F14), Q_UINT64_C(0x7BA18CE74D6C263F),
	Q_UINT64_C(0x5CCB5EFA7BE7F541), Q_UINT64_C(0x6AB52C9EF7D54FC),
	Q_UINT64_C(0xC5ED1ED6CAB85516), Q_UINT64_C(0xD68719F67A9A5FE6),
	Q_UINT64_C(0x3DD5F0914F578827), Q_UINT64_C(0x2E5A86B440811D75),
	Q_UINT64_C(0xCAEF87A00C9CF9F8), Q_UINT64_C(0x2FCCCD9062D25827),
	Q_UINT64_C(0x74C5309606137D59), Q_UINT64_C(0x5AE494C4BDF36285),
	Q_UINT64_C(0x7C7FA74105624E40)
};

} // anonymous namespace

namespace Chess {

StandardBoard::StandardBoard()
	: WesternBoard(new WesternZobrist(s_keys))
{
}

Board* StandardBoard::copy() const
{
	return new StandardBoard(*this);
}

QString StandardBoard::variant() const
{
	return "standard";
}

QString StandardBoard::defaultFenString() const
{
	return "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1";
}

Result StandardBoard::tablebaseResult(unsigned int* dtz) const
{
	SyzygyTablebase::PieceList pieces;

	for (int i = 0; i < arraySize(); i++)
	{
		Piece piece(pieceAt(i));
		if (piece.isValid())
		{
			if (pieces.size() > 6)
				return Result();
			pieces.append(qMakePair(chessSquare(i), piece));
		}
	}

	SyzygyTablebase::Castling castling = SyzygyTablebase::NoCastling;
	if (hasCastlingRight(Chess::Side::White, KingSide))
		castling |= SyzygyTablebase::WhiteKingSide;
	if (hasCastlingRight(Chess::Side::White, QueenSide))
		castling |= SyzygyTablebase::WhiteQueenSide;
	if (hasCastlingRight(Chess::Side::Black, KingSide))
		castling |= SyzygyTablebase::BlackKingSide;
	if (hasCastlingRight(Chess::Side::Black, QueenSide))
		castling |= SyzygyTablebase::BlackQueenSide;

	return SyzygyTablebase::result(sideToMove(),
					chessSquare(enpassantSquare()),
					castling,
					reversibleMoveCount(),
					pieces,
					dtz);
}

} // namespace Chess
