package ivpd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentImage invokes the ivpd.SegmentImage API synchronously
// api document: https://help.aliyun.com/api/ivpd/segmentimage.html
func (client *Client) SegmentImage(request *SegmentImageRequest) (response *SegmentImageResponse, err error) {
	response = CreateSegmentImageResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentImageWithChan invokes the ivpd.SegmentImage API asynchronously
// api document: https://help.aliyun.com/api/ivpd/segmentimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SegmentImageWithChan(request *SegmentImageRequest) (<-chan *SegmentImageResponse, <-chan error) {
	responseChan := make(chan *SegmentImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentImageWithCallback invokes the ivpd.SegmentImage API asynchronously
// api document: https://help.aliyun.com/api/ivpd/segmentimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SegmentImageWithCallback(request *SegmentImageRequest, callback func(response *SegmentImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentImageResponse
		var err error
		defer close(result)
		response, err = client.SegmentImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentImageRequest is the request struct for api SegmentImage
type SegmentImageRequest struct {
	*requests.RpcRequest
	Url string `position:"Body" name:"Url"`
}

// SegmentImageResponse is the response struct for api SegmentImage
type SegmentImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentImageRequest creates a request to invoke SegmentImage API
func CreateSegmentImageRequest() (request *SegmentImageRequest) {
	request = &SegmentImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivpd", "2019-06-25", "SegmentImage", "ivpd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentImageResponse creates a response to parse from SegmentImage response
func CreateSegmentImageResponse() (response *SegmentImageResponse) {
	response = &SegmentImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
